/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.ParcelizeResolveExtensionKt;
import org.jetbrains.kotlin.parcelize.diagnostic.ErrorsParcelize;
import org.jetbrains.kotlin.parcelize.serializers.ParcelSerializer;
import org.jetbrains.kotlin.parcelize.serializers.TypeUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\"\u001a\u00020#*\u00020\fH\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/parcelize/ParcelizeDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkParcelableClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkParcelableClassMethod", "method", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtFunction;", "checkParcelableClassProperty", "property", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "containerClass", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "checkParcelerClass", "hasCustomParceler", "", "Companion", "parcelize.k1"})
public class ParcelizeDeclarationChecker
implements DeclarationChecker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final List<FqName> IGNORED_ON_PARCEL_FQ_NAMES;

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BindingTrace trace = context.getTrace();
        DeclarationDescriptor declarationDescriptor = descriptor;
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
            DiagnosticSink diagnosticSink = (DiagnosticSink)trace;
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            this.checkParcelableClass(classDescriptor, declaration, diagnosticSink, bindingContext, context.getLanguageVersionSettings());
            this.checkParcelerClass((ClassDescriptor)descriptor, declaration, (DiagnosticSink)trace);
        } else if (declarationDescriptor instanceof SimpleFunctionDescriptor) {
            KtFunction ktFunction;
            DeclarationDescriptor declarationDescriptor2 = ((SimpleFunctionDescriptor)descriptor).getContainingDeclaration();
            ClassDescriptor containingClass = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
            KtFunction ktFunction2 = ktFunction = declaration instanceof KtFunction ? (KtFunction)declaration : null;
            if (containingClass != null && ktFunction != null) {
                this.checkParcelableClassMethod((SimpleFunctionDescriptor)descriptor, containingClass, ktFunction, (DiagnosticSink)trace);
            }
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            KtProperty ktProperty;
            DeclarationDescriptor ktFunction = ((PropertyDescriptor)descriptor).getContainingDeclaration();
            ClassDescriptor containingClass = ktFunction instanceof ClassDescriptor ? (ClassDescriptor)ktFunction : null;
            KtProperty ktProperty2 = ktProperty = declaration instanceof KtProperty ? (KtProperty)declaration : null;
            if (containingClass != null && ktProperty != null) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                DiagnosticSink diagnosticSink = (DiagnosticSink)trace;
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                this.checkParcelableClassProperty(propertyDescriptor, containingClass, ktProperty, diagnosticSink, bindingContext);
            }
        }
    }

    private final void checkParcelableClassMethod(SimpleFunctionDescriptor method, ClassDescriptor containingClass, KtFunction declaration, DiagnosticSink diagnosticHolder) {
        if (!ParcelizeResolveExtensionKt.isParcelize(containingClass)) {
            return;
        }
        if (ParcelizeResolveExtensionKt.isWriteToParcel(method) && declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if ((ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD)) == null) && (ktModifierList = declaration.getNameIdentifier()) == null) {
                ktModifierList = (PsiElement)declaration;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierList, (String)"declaration.modifierList\u2026           ?: declaration");
            KtModifierList reportElement = ktModifierList;
            diagnosticHolder.report((Diagnostic)ErrorsParcelize.OVERRIDING_WRITE_TO_PARCEL_IS_NOT_ALLOWED.on((PsiElement)reportElement));
        }
    }

    private final void checkParcelableClassProperty(PropertyDescriptor property, ClassDescriptor containingClass, KtProperty declaration, DiagnosticSink diagnosticHolder, BindingContext bindingContext) {
        if (ParcelizeResolveExtensionKt.isParcelize(containingClass) && (declaration.hasDelegate() || Intrinsics.areEqual((Object)bindingContext.get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, (Object)property), (Object)true)) && !ParcelizeDeclarationChecker.checkParcelableClassProperty$hasIgnoredOnParcel$1(property) && !this.hasCustomParceler(containingClass)) {
            PsiElement psiElement = declaration.getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.nameIdentifier ?: declaration");
            PsiElement reportElement = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsParcelize.PROPERTY_WONT_BE_SERIALIZED.on(reportElement));
        }
        if (Intrinsics.areEqual((Object)property.getName().asString(), (Object)"CREATOR") && JvmAnnotationUtilKt.findJvmFieldAnnotation((DeclarationDescriptor)((DeclarationDescriptor)property)) != null && containingClass.isCompanionObject()) {
            ClassDescriptor outerClass;
            DeclarationDescriptor declarationDescriptor = containingClass.getContainingDeclaration();
            ClassDescriptor classDescriptor = outerClass = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (outerClass != null && ParcelizeResolveExtensionKt.isParcelize(outerClass)) {
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = (PsiElement)declaration;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.nameIdentifier ?: declaration");
                PsiElement reportElement = psiElement;
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.CREATOR_DEFINITION_IS_NOT_ALLOWED.on(reportElement));
            }
        }
    }

    private final void checkParcelerClass(ClassDescriptor descriptor, KtDeclaration declaration, DiagnosticSink diagnosticHolder) {
        if (!descriptor.isCompanionObject() || !(declaration instanceof KtObjectDeclaration)) {
            return;
        }
        SimpleType simpleType = descriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"descriptor.defaultType");
        for (KotlinType type : org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.supertypes((KotlinType)((KotlinType)simpleType))) {
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            if (!Intrinsics.areEqual((Object)(classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor)) : null), (Object)ParcelizeNames.INSTANCE.getOLD_PARCELER_FQN())) continue;
            PsiElement psiElement = ((KtObjectDeclaration)declaration).getNameIdentifier();
            if (psiElement == null && (psiElement = ((KtObjectDeclaration)declaration).getObjectKeyword()) == null) {
                psiElement = (PsiElement)declaration;
            }
            PsiElement reportElement = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsParcelize.DEPRECATED_PARCELER.on(reportElement));
            break;
        }
    }

    private final void checkParcelableClass(ClassDescriptor descriptor, KtDeclaration declaration, DiagnosticSink diagnosticHolder, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        Object reportElement;
        block30: {
            PsiElement reportElement2;
            PsiElement abstractModifier;
            PsiElement psiElement;
            if (!ParcelizeResolveExtensionKt.isParcelize(descriptor)) {
                return;
            }
            if (!(declaration instanceof KtClassOrObject)) {
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_SHOULD_BE_CLASS.on((PsiElement)declaration));
                return;
            }
            if (declaration instanceof KtClass && (((KtClassOrObject)declaration).isAnnotation() || ((KtClass)declaration).isInterface() && !((KtClass)declaration).isSealed())) {
                PsiElement psiElement2 = ((KtClass)declaration).getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = (PsiElement)declaration;
                }
                PsiElement reportElement3 = psiElement2;
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_SHOULD_BE_CLASS.on(reportElement3));
                return;
            }
            for (KtObjectDeclaration companion : ((KtClassOrObject)declaration).getCompanionObjects()) {
                if (!Intrinsics.areEqual((Object)companion.getName(), (Object)"CREATOR")) continue;
                PsiElement psiElement3 = companion.getNameIdentifier();
                if (psiElement3 == null) {
                    psiElement3 = (PsiElement)companion;
                }
                reportElement = psiElement3;
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.CREATOR_DEFINITION_IS_NOT_ALLOWED.on((PsiElement)reportElement));
            }
            KtModifierList ktModifierList = ((KtClassOrObject)declaration).getModifierList();
            if (ktModifierList != null) {
                KtModifierList it = ktModifierList;
                boolean bl2 = false;
                psiElement = it.getModifier(KtTokens.ABSTRACT_KEYWORD);
            } else {
                psiElement = abstractModifier = null;
            }
            if (abstractModifier != null) {
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_SHOULD_BE_INSTANTIABLE.on(abstractModifier));
            }
            if (declaration instanceof KtClass && ((KtClass)declaration).isInner()) {
                KtModifierList ktModifierList2 = ((KtClass)declaration).getModifierList();
                if ((ktModifierList2 == null || (ktModifierList2 = ktModifierList2.getModifier(KtTokens.INNER_KEYWORD)) == null) && (ktModifierList2 = ((KtClass)declaration).getNameIdentifier()) == null) {
                    ktModifierList2 = (PsiElement)declaration;
                }
                reportElement2 = ktModifierList2;
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_CANT_BE_INNER_CLASS.on(reportElement2));
            }
            if (((KtClassOrObject)declaration).isLocal()) {
                PsiElement psiElement4 = ((KtClassOrObject)declaration).getNameIdentifier();
                if (psiElement4 == null) {
                    psiElement4 = (PsiElement)declaration;
                }
                reportElement2 = psiElement4;
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_CANT_BE_LOCAL_CLASS.on(reportElement2));
            }
            Set set = TypeUtils.getAllSupertypes((KotlinType)((KotlinType)descriptor.getDefaultType()));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllSupertypes(descriptor.defaultType)");
            Set superTypes = set;
            Iterable $this$none$iv = superTypes;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FqName fqName;
                    ClassifierDescriptor classifierDescriptor;
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl3 = false;
                    ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor2 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptor2, (String)"declarationDescriptor");
                        fqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor));
                    } else {
                        fqName = null;
                    }
                    if (!Intrinsics.areEqual((Object)fqName, (Object)ParcelizeNames.INSTANCE.getPARCELABLE_FQN())) continue;
                    bl = false;
                    break block30;
                }
                bl = true;
            }
        }
        if (bl) {
            PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            reportElement = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsParcelize.NO_PARCELABLE_SUPERTYPE.on((PsiElement)reportElement));
        }
        for (KtSuperTypeListEntry supertypeEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            KotlinType type;
            if ((supertypeEntry instanceof KtDelegatedSuperTypeEntry ? (KtDelegatedSuperTypeEntry)supertypeEntry : null) == null || ((KtDelegatedSuperTypeEntry)supertypeEntry).getDelegateExpression() == null || (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)((KtDelegatedSuperTypeEntry)supertypeEntry).getTypeReference()) == null || !TypeUtilsKt.isParcelable(type)) continue;
            ASTNode aSTNode = ((KtDelegatedSuperTypeEntry)supertypeEntry).getByKeywordNode();
            Object object = aSTNode != null ? aSTNode.getPsi() : null;
            if (object == null) {
                KtExpression delegateExpression;
                object = (PsiElement)delegateExpression;
            }
            PsiElement reportElement4 = object;
            diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_DELEGATE_IS_NOT_ALLOWED.on(reportElement4));
        }
        if (this.hasCustomParceler(descriptor)) {
            return;
        }
        KtPrimaryConstructor primaryConstructor = ((KtClassOrObject)declaration).getPrimaryConstructor();
        if (primaryConstructor == null && !((Collection)((KtClassOrObject)declaration).getSecondaryConstructors()).isEmpty()) {
            PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            PsiElement reportElement5 = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_SHOULD_HAVE_PRIMARY_CONSTRUCTOR.on(reportElement5));
        } else if (primaryConstructor != null && primaryConstructor.getValueParameters().isEmpty()) {
            PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            PsiElement reportElement6 = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_PRIMARY_CONSTRUCTOR_IS_EMPTY.on(reportElement6));
        }
        ClassBuilderMode classBuilderMode = ClassBuilderMode.FULL;
        Intrinsics.checkNotNullExpressionValue((Object)classBuilderMode, (String)"FULL");
        String string = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.module.name.asString()");
        KotlinTypeMapper typeMapper = new KotlinTypeMapper(bindingContext, classBuilderMode, string, languageVersionSettings, false, null, false, null, null, 480, null);
        KtPrimaryConstructor ktPrimaryConstructor = primaryConstructor;
        List list = ktPrimaryConstructor != null ? ktPrimaryConstructor.getValueParameters() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (KtParameter parameter : list) {
            this.checkParcelableClassProperty(parameter, descriptor, diagnosticHolder, typeMapper);
        }
    }

    private final void checkParcelableClassProperty(KtParameter parameter, ClassDescriptor containerClass, DiagnosticSink diagnosticHolder, KotlinTypeMapper typeMapper) {
        boolean bl;
        PropertyDescriptor descriptor;
        block13: {
            if (!parameter.hasValOrVar()) {
                PsiElement psiElement = parameter.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = (PsiElement)parameter;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameter.nameIdentifier ?: parameter");
                PsiElement reportElement = psiElement;
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_CONSTRUCTOR_PARAMETER_SHOULD_BE_VAL_OR_VAR.on(reportElement));
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)typeMapper.getBindingContext().get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)parameter);
            if (propertyDescriptor == null) {
                return;
            }
            descriptor = propertyDescriptor;
            Iterable $this$any$iv = (Iterable)descriptor.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)IGNORED_ON_PARCEL_FQ_NAMES, (Object)it.getFqName())) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        KotlinType kotlinType = descriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        KotlinType type = kotlinType;
        if (!KotlinTypeKt.isError((KotlinType)type)) {
            Type asmType = KotlinTypeMapper.mapType$default((KotlinTypeMapper)typeMapper, (KotlinType)type, null, (TypeMappingMode)TypeMappingMode.CLASS_DECLARATION, (int)2, null);
            try {
                List parcelers = CollectionsKt.plus((Collection)ParcelizeResolveExtensionKt.getTypeParcelers(descriptor.getAnnotations()), (Iterable)ParcelizeResolveExtensionKt.getTypeParcelers(containerClass.getAnnotations()));
                ParcelSerializer.ParcelSerializerContext context = new ParcelSerializer.ParcelSerializerContext(typeMapper, typeMapper.mapClass((ClassifierDescriptor)containerClass), parcelers, new FrameMap());
                ParcelSerializer.Companion.get$default(ParcelSerializer.Companion, type, asmType, context, false, true, 8, null);
            }
            catch (IllegalArgumentException e) {
                PsiElement psiElement;
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                if (ktTypeReference != null) {
                    psiElement = (PsiElement)ktTypeReference;
                } else {
                    psiElement = parameter.getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = (PsiElement)parameter;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameter.typeReference \u2026meIdentifier ?: parameter");
                PsiElement reportElement = psiElement;
                diagnosticHolder.report((Diagnostic)ErrorsParcelize.PARCELABLE_TYPE_NOT_SUPPORTED.on(reportElement));
            }
        }
    }

    private final boolean hasCustomParceler(ClassDescriptor $this$hasCustomParceler) {
        boolean bl;
        block7: {
            ClassDescriptor it;
            Object object;
            block9: {
                block8: {
                    object = $this$hasCustomParceler.getCompanionObjectDescriptor();
                    if (object == null) break block8;
                    it = object;
                    boolean bl2 = false;
                    Set set = TypeUtils.getAllSupertypes((KotlinType)((KotlinType)it.getDefaultType()));
                    object = set;
                    if (set != null) break block9;
                }
                return false;
            }
            Object companionObjectSuperTypes = object;
            Iterable $this$any$iv = (Iterable)companionObjectSuperTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KotlinType)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!ParcelizeResolveExtensionKt.isParceler((KotlinType)it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkParcelableClassProperty$hasIgnoredOnParcel$1$hasIgnoredOnParcel(Annotations $this$checkParcelableClassProperty_u24hasIgnoredOnParcel_u241_u24hasIgnoredOnParcel) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)$this$checkParcelableClassProperty_u24hasIgnoredOnParcel_u241_u24hasIgnoredOnParcel;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)IGNORED_ON_PARCEL_FQ_NAMES, (Object)it.getFqName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkParcelableClassProperty$hasIgnoredOnParcel$1(PropertyDescriptor $property) {
        PropertyGetterDescriptor propertyGetterDescriptor;
        return ParcelizeDeclarationChecker.checkParcelableClassProperty$hasIgnoredOnParcel$1$hasIgnoredOnParcel($property.getAnnotations()) || ((propertyGetterDescriptor = $property.getGetter()) != null && (propertyGetterDescriptor = propertyGetterDescriptor.getAnnotations()) != null ? ParcelizeDeclarationChecker.checkParcelableClassProperty$hasIgnoredOnParcel$1$hasIgnoredOnParcel((Annotations)propertyGetterDescriptor) : false);
    }

    static {
        Object[] objectArray = new FqName[]{new FqName("kotlinx.parcelize.IgnoredOnParcel"), new FqName("kotlinx.android.parcel.IgnoredOnParcel")};
        IGNORED_ON_PARCEL_FQ_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/parcelize/ParcelizeDeclarationChecker$Companion;", "", "()V", "IGNORED_ON_PARCEL_FQ_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "parcelize.k1"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

