/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "parcelize.k2"})
public final class FirParcelizeConstructorChecker
extends FirDeclarationChecker<FirConstructor> {
    @NotNull
    public static final FirParcelizeConstructorChecker INSTANCE = new FirParcelizeConstructorChecker();

    private FirParcelizeConstructorChecker() {
    }

    public void check(@NotNull FirConstructor declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!declaration.isPrimary()) {
            return;
        }
        KtSourceElement ktSourceElement = declaration.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
            return;
        }
        Iterator iterator = CollectionsKt.last((List)context.getContainingDeclarations());
        FirRegularClass firRegularClass = iterator instanceof FirRegularClass ? (FirRegularClass)iterator : null;
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass containingClass = firRegularClass;
        FirRegularClassSymbol containingClassSymbol = containingClass.getSymbol();
        if (!FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)containingClassSymbol, context.getSession()) || FirParcelizeClassCheckerKt.hasCustomParceler(containingClass, context.getSession())) {
            return;
        }
        if (declaration.getValueParameters().isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)containingClass.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_PRIMARY_CONSTRUCTOR_IS_EMPTY(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        } else {
            for (FirValueParameter valueParameter : declaration.getValueParameters()) {
                FirAnnotation illegalAnnotation;
                Object v5;
                block10: {
                    KtSourceElement ktSourceElement2 = valueParameter.getSource();
                    if (!(ktSourceElement2 != null ? LightTreePositioningStrategiesKt.hasValOrVar((KtSourceElement)ktSourceElement2) : false)) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)valueParameter.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_CONSTRUCTOR_PARAMETER_SHOULD_BE_VAL_OR_VAR(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                    }
                    if (valueParameter.getDefaultValue() != null) continue;
                    Iterable $this$firstOrNull$iv = valueParameter.getAnnotations();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ConeKotlinType coneKotlinType;
                        ConeClassLikeType coneClassLikeType;
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl = false;
                        FirAnnotation $this$classId$iv = it;
                        boolean $i$f$getClassId = false;
                        FirAnnotation $this$coneClassLikeType$iv$iv = $this$classId$iv;
                        boolean $i$f$getConeClassLikeType = false;
                        FirTypeRef firTypeRef = $this$coneClassLikeType$iv$iv.getAnnotationTypeRef();
                        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                        if (!CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getIGNORED_ON_PARCEL_CLASS_IDS(), (coneClassLikeType = (coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null) instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null) != null && (coneClassLikeType = coneClassLikeType.getLookupTag()) != null ? coneClassLikeType.getClassId() : null)) continue;
                        v5 = element$iv;
                        break block10;
                    }
                    v5 = null;
                }
                if ((illegalAnnotation = (FirAnnotation)v5) == null) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)illegalAnnotation.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getINAPPLICABLE_IGNORED_ON_PARCEL_CONSTRUCTOR_PROPERTY(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        }
    }
}

