/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.tex.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.openoffice.da.comp.w2lcommon.tex.tokenizer.Catcode;
import org.openoffice.da.comp.w2lcommon.tex.tokenizer.CatcodeTable;
import org.openoffice.da.comp.w2lcommon.tex.tokenizer.State;
import org.openoffice.da.comp.w2lcommon.tex.tokenizer.Token;
import org.openoffice.da.comp.w2lcommon.tex.tokenizer.TokenType;

public class Mouth {
    private Reader reader;
    private CatcodeTable catcodes;
    private char cEndlinechar;
    private Token token;
    private State state;
    private Eyes eyes;

    public Mouth(Reader reader) throws IOException {
        this.reader = reader;
        this.catcodes = new CatcodeTable();
        this.cEndlinechar = (char)13;
        this.token = new Token();
        this.state = State.N;
        this.eyes = new Eyes();
    }

    public CatcodeTable getCatcodes() {
        return this.catcodes;
    }

    public void setCatcodes(CatcodeTable catcodes) {
        this.catcodes = catcodes;
    }

    public char getEndlinechar() {
        return this.cEndlinechar;
    }

    public void setEndlinechar(char c) {
        this.cEndlinechar = c;
    }

    public Token getTokenObject() {
        return this.token;
    }

    public Token getToken() throws IOException {
        while (this.eyes.lookingAtLine()) {
            while (this.eyes.lookingAtChar()) {
                char c = this.eyes.getChar();
                switch (this.catcodes.get(c)) {
                    case ESCAPE: {
                        this.token.setType(TokenType.COMMAND_SEQUENCE);
                        this.token.clearChars();
                        if (this.catcodes.get(this.eyes.peekChar()) == Catcode.LETTER) {
                            this.state = State.S;
                            while (this.eyes.lookingAtChar() && this.catcodes.get(this.eyes.peekChar()) == Catcode.LETTER) {
                                this.token.addChar(this.eyes.getChar());
                            }
                        } else if (this.catcodes.get(this.eyes.peekChar()) == Catcode.SPACE) {
                            this.state = State.S;
                            this.token.setChar(this.eyes.getChar());
                        } else if (this.catcodes.get(this.eyes.peekChar()) != Catcode.END_OF_LINE) {
                            this.state = State.M;
                            this.token.setChar(this.eyes.getChar());
                        } else {
                            this.state = State.M;
                        }
                        return this.token;
                    }
                    case BEGIN_GROUP: {
                        this.state = State.M;
                        this.token.set(c, TokenType.BEGIN_GROUP);
                        return this.token;
                    }
                    case END_GROUP: {
                        this.state = State.M;
                        this.token.set(c, TokenType.END_GROUP);
                        return this.token;
                    }
                    case MATH_SHIFT: {
                        this.state = State.M;
                        this.token.set(c, TokenType.MATH_SHIFT);
                        return this.token;
                    }
                    case ALIGNMENT_TAB: {
                        this.state = State.M;
                        this.token.set(c, TokenType.ALIGNMENT_TAB);
                        return this.token;
                    }
                    case END_OF_LINE: {
                        while (this.eyes.lookingAtChar()) {
                            this.eyes.getChar();
                        }
                        switch (this.state) {
                            case N: {
                                this.token.setType(TokenType.COMMAND_SEQUENCE);
                                this.token.clearChars();
                                this.token.addChar('p');
                                this.token.addChar('a');
                                this.token.addChar('r');
                                return this.token;
                            }
                            case M: {
                                this.token.set(' ', TokenType.SPACE);
                                return this.token;
                            }
                        }
                        break;
                    }
                    case PARAMETER: {
                        this.state = State.M;
                        this.token.set(c, TokenType.PARAMETER);
                        return this.token;
                    }
                    case SUPERSCRIPT: {
                        this.state = State.M;
                        this.token.set(c, TokenType.SUPERSCRIPT);
                        return this.token;
                    }
                    case SUBSCRIPT: {
                        this.state = State.M;
                        this.token.set(c, TokenType.SUBSCRIPT);
                        return this.token;
                    }
                    case IGNORED: {
                        break;
                    }
                    case SPACE: {
                        if (this.state != State.M) break;
                        this.state = State.S;
                        this.token.set(' ', TokenType.SPACE);
                        return this.token;
                    }
                    case LETTER: {
                        this.state = State.M;
                        this.token.set(c, TokenType.LETTER);
                        return this.token;
                    }
                    case OTHER: {
                        this.state = State.M;
                        this.token.set(c, TokenType.OTHER);
                        return this.token;
                    }
                    case ACTIVE: {
                        this.state = State.M;
                        this.token.set(c, TokenType.ACTIVE);
                        return this.token;
                    }
                    case COMMENT: {
                        while (this.eyes.lookingAtChar()) {
                            this.eyes.getChar();
                        }
                        break;
                    }
                }
            }
            this.eyes.nextLine();
            this.state = State.N;
        }
        this.token.setType(TokenType.ENDINPUT);
        this.token.clearChars();
        return this.token;
    }

    private class Eyes {
        private BufferedReader br;
        private String sLine;
        private int nLen;
        private int nIndex;

        Eyes() throws IOException {
            this.br = new BufferedReader(Mouth.this.reader);
            this.nextLine();
        }

        void nextLine() throws IOException {
            this.sLine = this.br.readLine();
            if (this.sLine != null) {
                this.nLen = this.sLine.length();
                this.nIndex = 0;
                while (this.nLen > 0 && this.sLine.charAt(this.nLen - 1) == ' ') {
                    --this.nLen;
                }
            } else {
                this.nLen = 0;
                this.nIndex = 1;
            }
        }

        boolean lookingAtChar() {
            return this.nIndex <= this.nLen;
        }

        boolean lookingAtLine() {
            return this.sLine != null;
        }

        char peekChar() {
            return this.getChar(false);
        }

        char getChar() {
            return this.getChar(true);
        }

        private char getChar(boolean bMove) {
            if (this.nIndex < this.nLen) {
                char c = this.sLine.charAt(this.nIndex);
                if (Mouth.this.catcodes.get(c) == Catcode.SUPERSCRIPT && this.nIndex + 2 < this.nLen && Mouth.this.catcodes.get(this.sLine.charAt(this.nIndex + 1)) == Catcode.SUPERSCRIPT) {
                    char c1 = this.sLine.charAt(this.nIndex + 2);
                    if (this.nIndex + 3 < this.nLen && this.isHex(c1)) {
                        char c2 = this.sLine.charAt(this.nIndex + 3);
                        if (this.isHex(c2)) {
                            if (bMove) {
                                this.nIndex += 4;
                            }
                            char[] digits = new char[]{c1, c2};
                            return (char)Integer.parseInt(new String(digits), 16);
                        }
                    } else if (c1 < '\u0080') {
                        if (bMove) {
                            this.nIndex += 3;
                        }
                        if (c1 < '@') {
                            return (char)(c1 + 64);
                        }
                        return (char)(c1 - 64);
                    }
                }
                if (bMove) {
                    ++this.nIndex;
                }
                return c;
            }
            if (this.nIndex == this.nLen) {
                if (bMove) {
                    ++this.nIndex;
                }
                return Mouth.this.cEndlinechar;
            }
            return '\uffff';
        }

        private boolean isHex(char c) {
            return '0' <= c && c <= '9' || 'a' <= c && c <= 'z';
        }
    }
}

