/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.utility.NamedObjectSort;

abstract class AbstractNamedObject
implements NamedObject {
    private static final long serialVersionUID = -1486322887991472729L;
    private final String name;
    private transient NamedObjectKey key;

    AbstractNamedObject(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(NamedObject obj) {
        return Objects.compare(this, obj, NamedObjectSort.alphabetical);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedObject)) {
            return false;
        }
        return Objects.equals(this.name, ((NamedObject)obj).getName());
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public NamedObjectKey key() {
        this.buildKey();
        return this.key;
    }

    public final String toString() {
        return this.getFullName();
    }

    private void buildKey() {
        if (this.key != null) {
            return;
        }
        this.key = new NamedObjectKey(this.name);
    }
}

