/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.resource.ResourceException;

public class FBResourceException
extends ResourceException {
    private static final boolean PERFORM_EXPLICIT_INIT_CAUSE;

    public FBResourceException(String reason) {
        super(reason, "HY000");
    }

    public FBResourceException(String reason, String errorCode) {
        super(reason, errorCode);
    }

    public FBResourceException(String reason, Exception original) {
        super(reason, "HY000");
        SQLException origSql;
        this.setLinkedException(original);
        if (PERFORM_EXPLICIT_INIT_CAUSE) {
            this.initCause(original);
        }
        if (original instanceof SQLException && (origSql = (SQLException)original).getSQLState() != null) {
            this.setErrorCode(origSql.getSQLState());
        }
    }

    public FBResourceException(Exception original) {
        this(original.getMessage(), original);
    }

    public String getMessage() {
        String message = super.getMessage();
        String causeMessage = null;
        if (this.getCause() != null) {
            causeMessage = this.getCause().getMessage();
        } else if (this.getLinkedException() != null) {
            causeMessage = this.getLinkedException().getMessage();
        }
        if (causeMessage == null) {
            return message;
        }
        if (message == null) {
            return causeMessage;
        }
        return message + "\nReason: " + causeMessage;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.getLinkedException() != null) {
            s.print("at ");
            this.getLinkedException().printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.getLinkedException() != null) {
            s.print("at ");
            this.getLinkedException().printStackTrace(s);
        }
    }

    static {
        ResourceException resourceException = new ResourceException();
        resourceException.setLinkedException((Exception)new RuntimeException());
        PERFORM_EXPLICIT_INIT_CAUSE = resourceException.getCause() == null;
    }
}

