/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import us.fatehi.utility.scheduler.AbstractTaskRunner;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TimedTask;
import us.fatehi.utility.string.StringFormat;

public final class MultiThreadedTaskRunner
extends AbstractTaskRunner {
    private static final Logger LOGGER = Logger.getLogger(MultiThreadedTaskRunner.class.getName());
    public static final int MIN_THREADS = 1;
    public static final int MAX_THREADS = 10;
    private final ExecutorService executorService;

    MultiThreadedTaskRunner(String id, int maxThreadsSuggested) {
        super(id);
        int maxThreads = maxThreadsSuggested < 1 ? 1 : (maxThreadsSuggested > 10 ? 10 : maxThreadsSuggested);
        LOGGER.log(Level.INFO, new StringFormat("Configured to run loaders in <%d> threads", maxThreads));
        this.executorService = Executors.newFixedThreadPool(maxThreads);
    }

    @Override
    public boolean isStopped() {
        return this.executorService.isShutdown();
    }

    @Override
    public void run(TaskDefinition ... taskDefinitions) throws Exception {
        if (this.executorService.isShutdown()) {
            throw new IllegalStateException("Task runner is stopped");
        }
        Objects.requireNonNull(taskDefinitions, "Tasks not provided");
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(Arrays.stream(taskDefinitions).map(task -> CompletableFuture.runAsync(new TimedTask(this.getTasks(), (TaskDefinition)task), this.executorService)).collect(Collectors.toList()).toArray(new CompletableFuture[taskDefinitions.length]));
        completableFuture.join();
    }

    @Override
    public void stop() throws ExecutionException {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(1L, TimeUnit.HOURS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

