/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.tika.parser.digest;

import java.io.IOException;
import java.io.InputStream;
import net.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import net.snowflake.client.jdbc.internal.apache.tika.io.IOExceptionWithCause;
import net.snowflake.client.jdbc.internal.apache.tika.io.TemporaryResources;
import net.snowflake.client.jdbc.internal.apache.tika.io.TikaInputStream;
import net.snowflake.client.jdbc.internal.apache.tika.metadata.Metadata;
import net.snowflake.client.jdbc.internal.apache.tika.parser.DigestingParser;
import net.snowflake.client.jdbc.internal.apache.tika.parser.ParseContext;

public class CompositeDigester
implements DigestingParser.Digester {
    private final DigestingParser.Digester[] digesters;

    public CompositeDigester(DigestingParser.Digester ... digesters) {
        this.digesters = digesters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void digest(InputStream is, Metadata m3, ParseContext parseContext) throws IOException {
        TemporaryResources tmp = new TemporaryResources();
        TikaInputStream tis = TikaInputStream.get(is, tmp);
        try {
            for (DigestingParser.Digester digester : this.digesters) {
                digester.digest(tis, m3, parseContext);
            }
        }
        finally {
            try {
                tmp.dispose();
            }
            catch (TikaException e) {
                throw new IOExceptionWithCause(e);
            }
        }
    }
}

