/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.Objects;
import java.util.Set;
import net.snowflake.client.jdbc.internal.google.cloud.NoCredentials;
import net.snowflake.client.jdbc.internal.google.cloud.ServiceDefaults;
import net.snowflake.client.jdbc.internal.google.cloud.ServiceOptions;
import net.snowflake.client.jdbc.internal.google.cloud.ServiceRpc;
import net.snowflake.client.jdbc.internal.google.cloud.TransportOptions;
import net.snowflake.client.jdbc.internal.google.cloud.http.HttpTransportOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.RetryAlgorithmManager;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageFactory;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageImpl;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageRetryStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.StorageRpcFactory;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.HttpStorageRpc;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.StorageRpc;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;

public class StorageOptions
extends ServiceOptions<Storage, StorageOptions> {
    private static final long serialVersionUID = -2907268477247502947L;
    private static final String API_SHORT_NAME = "Storage";
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final Set<String> SCOPES = ImmutableSet.of("https://www.googleapis.com/auth/devstorage.full_control");
    private static final String DEFAULT_HOST = "https://storage.googleapis.com";
    private final RetryAlgorithmManager retryAlgorithmManager;

    private StorageOptions(Builder builder, StorageDefaults serviceDefaults) {
        super(StorageFactory.class, StorageRpcFactory.class, builder, serviceDefaults);
        this.retryAlgorithmManager = new RetryAlgorithmManager(MoreObjects.firstNonNull(builder.storageRetryStrategy, serviceDefaults.getStorageRetryStrategy()));
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    @Override
    protected boolean projectIdRequired() {
        return false;
    }

    @Override
    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected StorageRpc getStorageRpcV1() {
        return (StorageRpc)this.getRpc();
    }

    RetryAlgorithmManager getRetryAlgorithmManager() {
        return this.retryAlgorithmManager;
    }

    public static StorageOptions getDefaultInstance() {
        return StorageOptions.newBuilder().build();
    }

    public static StorageOptions getUnauthenticatedInstance() {
        return ((Builder)StorageOptions.newBuilder().setCredentials(NoCredentials.getInstance())).build();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof StorageOptions && this.baseEquals((StorageOptions)obj);
    }

    public static Builder newBuilder() {
        return (Builder)new Builder().setHost(DEFAULT_HOST);
    }

    private static class StorageDefaults
    implements ServiceDefaults<Storage, StorageOptions> {
        private StorageDefaults() {
        }

        public StorageFactory getDefaultServiceFactory() {
            return DefaultStorageFactory.INSTANCE;
        }

        public StorageRpcFactory getDefaultRpcFactory() {
            return DefaultStorageRpcFactory.INSTANCE;
        }

        @Override
        public TransportOptions getDefaultTransportOptions() {
            return StorageOptions.getDefaultHttpTransportOptions();
        }

        public StorageRetryStrategy getStorageRetryStrategy() {
            return StorageRetryStrategy.getDefaultStorageRetryStrategy();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Storage, StorageOptions, Builder> {
        private StorageRetryStrategy storageRetryStrategy;

        private Builder() {
        }

        private Builder(StorageOptions options) {
            super(options);
        }

        @Override
        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Storage.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public Builder setStorageRetryStrategy(StorageRetryStrategy storageRetryStrategy) {
            this.storageRetryStrategy = Objects.requireNonNull(storageRetryStrategy, "storageRetryStrategy must be non null");
            return this;
        }

        public StorageOptions build() {
            return new StorageOptions(this, new StorageDefaults());
        }
    }

    public static class DefaultStorageRpcFactory
    implements StorageRpcFactory {
        private static final StorageRpcFactory INSTANCE = new DefaultStorageRpcFactory();

        @Override
        public ServiceRpc create(StorageOptions options) {
            return new HttpStorageRpc(options);
        }
    }

    public static class DefaultStorageFactory
    implements StorageFactory {
        private static final StorageFactory INSTANCE = new DefaultStorageFactory();

        @Override
        public Storage create(StorageOptions options) {
            return new StorageImpl(options);
        }
    }
}

