Object.assign(window.search, {"doc_urls":["Introduction.html#how-does-it-work","Introduction.html#source-code","Introduction.html#license","Installation.html#-installation","Installation.html#homebrew","Installation.html#cargo","Installation.html#cargo-binstall","Installation.html#pre-built-binaries","Installation.html#building-from-source","Getting-started.html#-getting-started","Getting-started.html#initializing","Getting-started.html#adding-a-plugin","Getting-started.html#loading-plugins","Command-line-interface.html#-command-line-interface","Command-line-interface.html#init","Command-line-interface.html#lock","Command-line-interface.html#source","Command-line-interface.html#add","Command-line-interface.html#edit","Command-line-interface.html#remove","Command-line-interface.html#options","Command-line-interface.html#completions","Configuration.html#-configuration","Configuration.html#plugin-sources","Configuration.html#git","Configuration.html#remote","Configuration.html#local","Configuration.html#plugin-options","Configuration.html#use","Configuration.html#apply","Configuration.html#profiles","Configuration.html#inline-plugins","Configuration.html#templates","Configuration.html#custom-templates","Configuration.html#global-options","Configuration.html#shell","Configuration.html#match","Configuration.html#apply-1","Examples.html#-examples","Examples.html#deferred-loading-of-plugins-in-zsh","Examples.html#overriding-the-path-template","Examples.html#zsh-frameworks","Examples.html#ohmyzsh","Examples.html#zsh-plugins","Examples.html#autosuggestions","Examples.html#autojump","Examples.html#syntax-highlighting","Examples.html#blackbox","Examples.html#zlua","Examples.html#enhancd","Examples.html#base16","Examples.html#zsh-themes","Examples.html#powerlevel10k","Examples.html#spaceship","Examples.html#pure","RELEASES.html#-release-notes","RELEASES.html#070","RELEASES.html#breaking-changes","RELEASES.html#features","RELEASES.html#fixes","RELEASES.html#066","RELEASES.html#065","RELEASES.html#064","RELEASES.html#063","RELEASES.html#062","RELEASES.html#061","RELEASES.html#060","RELEASES.html#breaking-changes-1","RELEASES.html#fixes-1","RELEASES.html#054","RELEASES.html#features-1","RELEASES.html#fixes-2","RELEASES.html#053","RELEASES.html#features-2","RELEASES.html#052","RELEASES.html#fixes-3","RELEASES.html#other","RELEASES.html#051","RELEASES.html#050","RELEASES.html#features-3","RELEASES.html#breaking-changes-2","RELEASES.html#fixes-4","RELEASES.html#deprecations","RELEASES.html#048","RELEASES.html#047","RELEASES.html#046","RELEASES.html#045","RELEASES.html#044","RELEASES.html#043","RELEASES.html#042","RELEASES.html#041","RELEASES.html#040"],"index":{"documentStore":{"docInfo":{"0":{"body":54,"breadcrumbs":2,"title":1},"1":{"body":6,"breadcrumbs":3,"title":2},"10":{"body":39,"breadcrumbs":3,"title":1},"11":{"body":42,"breadcrumbs":4,"title":2},"12":{"body":24,"breadcrumbs":4,"title":2},"13":{"body":27,"breadcrumbs":6,"title":3},"14":{"body":23,"breadcrumbs":4,"title":1},"15":{"body":44,"breadcrumbs":4,"title":1},"16":{"body":39,"breadcrumbs":4,"title":1},"17":{"body":30,"breadcrumbs":4,"title":1},"18":{"body":32,"breadcrumbs":4,"title":1},"19":{"body":18,"breadcrumbs":4,"title":1},"2":{"body":12,"breadcrumbs":2,"title":1},"20":{"body":115,"breadcrumbs":4,"title":1},"21":{"body":38,"breadcrumbs":4,"title":1},"22":{"body":0,"breadcrumbs":2,"title":1},"23":{"body":49,"breadcrumbs":3,"title":2},"24":{"body":206,"breadcrumbs":2,"title":1},"25":{"body":31,"breadcrumbs":2,"title":1},"26":{"body":36,"breadcrumbs":2,"title":1},"27":{"body":4,"breadcrumbs":3,"title":2},"28":{"body":40,"breadcrumbs":2,"title":1},"29":{"body":33,"breadcrumbs":2,"title":1},"3":{"body":0,"breadcrumbs":2,"title":1},"30":{"body":19,"breadcrumbs":2,"title":1},"31":{"body":21,"breadcrumbs":3,"title":2},"32":{"body":111,"breadcrumbs":2,"title":1},"33":{"body":84,"breadcrumbs":3,"title":2},"34":{"body":0,"breadcrumbs":3,"title":2},"35":{"body":23,"breadcrumbs":2,"title":1},"36":{"body":48,"breadcrumbs":2,"title":1},"37":{"body":11,"breadcrumbs":2,"title":1},"38":{"body":13,"breadcrumbs":2,"title":1},"39":{"body":102,"breadcrumbs":5,"title":4},"4":{"body":7,"breadcrumbs":2,"title":1},"40":{"body":32,"breadcrumbs":4,"title":3},"41":{"body":0,"breadcrumbs":3,"title":2},"42":{"body":33,"breadcrumbs":2,"title":1},"43":{"body":0,"breadcrumbs":3,"title":2},"44":{"body":29,"breadcrumbs":2,"title":1},"45":{"body":27,"breadcrumbs":2,"title":1},"46":{"body":27,"breadcrumbs":3,"title":2},"47":{"body":17,"breadcrumbs":2,"title":1},"48":{"body":17,"breadcrumbs":2,"title":1},"49":{"body":17,"breadcrumbs":2,"title":1},"5":{"body":11,"breadcrumbs":2,"title":1},"50":{"body":19,"breadcrumbs":2,"title":1},"51":{"body":0,"breadcrumbs":3,"title":2},"52":{"body":17,"breadcrumbs":2,"title":1},"53":{"body":21,"breadcrumbs":2,"title":1},"54":{"body":23,"breadcrumbs":2,"title":1},"55":{"body":0,"breadcrumbs":4,"title":2},"56":{"body":3,"breadcrumbs":3,"title":1},"57":{"body":112,"breadcrumbs":4,"title":2},"58":{"body":60,"breadcrumbs":3,"title":1},"59":{"body":21,"breadcrumbs":3,"title":1},"6":{"body":14,"breadcrumbs":3,"title":2},"60":{"body":7,"breadcrumbs":3,"title":1},"61":{"body":7,"breadcrumbs":3,"title":1},"62":{"body":20,"breadcrumbs":3,"title":1},"63":{"body":9,"breadcrumbs":3,"title":1},"64":{"body":25,"breadcrumbs":3,"title":1},"65":{"body":46,"breadcrumbs":3,"title":1},"66":{"body":3,"breadcrumbs":3,"title":1},"67":{"body":150,"breadcrumbs":4,"title":2},"68":{"body":32,"breadcrumbs":3,"title":1},"69":{"body":3,"breadcrumbs":3,"title":1},"7":{"body":42,"breadcrumbs":4,"title":3},"70":{"body":21,"breadcrumbs":3,"title":1},"71":{"body":31,"breadcrumbs":3,"title":1},"72":{"body":3,"breadcrumbs":3,"title":1},"73":{"body":45,"breadcrumbs":3,"title":1},"74":{"body":3,"breadcrumbs":3,"title":1},"75":{"body":25,"breadcrumbs":3,"title":1},"76":{"body":8,"breadcrumbs":2,"title":0},"77":{"body":25,"breadcrumbs":3,"title":1},"78":{"body":2,"breadcrumbs":3,"title":1},"79":{"body":81,"breadcrumbs":3,"title":1},"8":{"body":27,"breadcrumbs":3,"title":2},"80":{"body":36,"breadcrumbs":4,"title":2},"81":{"body":20,"breadcrumbs":3,"title":1},"82":{"body":39,"breadcrumbs":3,"title":1},"83":{"body":55,"breadcrumbs":3,"title":1},"84":{"body":38,"breadcrumbs":3,"title":1},"85":{"body":15,"breadcrumbs":3,"title":1},"86":{"body":15,"breadcrumbs":3,"title":1},"87":{"body":16,"breadcrumbs":3,"title":1},"88":{"body":15,"breadcrumbs":3,"title":1},"89":{"body":9,"breadcrumbs":3,"title":1},"9":{"body":0,"breadcrumbs":4,"title":2},"90":{"body":22,"breadcrumbs":3,"title":1},"91":{"body":11,"breadcrumbs":3,"title":1}},"docs":{"0":{"body":"Sheldon is a fast, configurable, command-line tool to manage your shell plugins. Plugins are specified in a TOML configuration file and Sheldon renders an install script using user configurable templates. A ~/.zshrc or ~/.bashrc that uses Sheldon simply contains the following. eval \"$(sheldon source)\" Sheldon can manage GitHub or Git repositories, Gists, arbitrary remote scripts or binaries, local plugins, and inline plugins. Plugins are installed and updated in parallel and as a result Sheldon is blazingly fast.","breadcrumbs":"Introduction » How does it work?","id":"0","title":"How does it work?"},"1":{"body":"Sheldon is open source and you can find the code on GitHub .","breadcrumbs":"Introduction » Source code","id":"1","title":"Source code"},"10":{"body":"Sheldon works by specifying plugin information in a TOML configuration file, plugins.toml. You can initialize this file by running sheldon init. sheldon init --shell bash or sheldon init --shell zsh This will create plugins.toml under $XDG_CONFIG_HOME/sheldon, on most systems this will be ~/.config/sheldon/plugins.toml. You can either edit this file directly or use the provided command line interface to add or remove plugins.","breadcrumbs":"🚀 Getting started » Initializing","id":"10","title":"Initializing"},"11":{"body":"To add your first plugin append the following to the Sheldon config file. # ~/.config/sheldon/plugins.toml [plugins.base16]\ngithub = \"chriskempson/base16-shell\" Or use the add command to automatically add it. sheldon add base16 --github chriskempson/base16-shell The first argument given here base16 is a unique name for the plugin. The --github option specifies that we want Sheldon to manage a clone of the https://github.com/chriskempson/base16-shell repository.","breadcrumbs":"🚀 Getting started » Adding a plugin","id":"11","title":"Adding a plugin"},"12":{"body":"You can then use sheldon source to install this plugin, generate a lock file, and print out the shell script to source. Simply add the following to your ~/.zshrc or ~/.bashrc file. # ~/.zshrc or ~/.bashrc eval \"$(sheldon source)\"","breadcrumbs":"🚀 Getting started » Loading plugins","id":"12","title":"Loading plugins"},"13":{"body":"Sheldon has three different types of commands. init initializes a new config file. lock and source deal with plugin downloading, installation, and generation of shell source code. add , edit , and remove automate editing of the config file.","breadcrumbs":"💻 Command line interface » 💻 Command line interface","id":"13","title":"💻 Command line interface"},"14":{"body":"This command initializes a new config file. If a config file exists then this command does nothing. For example sheldon init Or you can specify the shell. sheldon init --shell bash or sheldon init --shell zsh","breadcrumbs":"💻 Command line interface » init","id":"14","title":"init"},"15":{"body":"The lock command installs the plugins sources and generates the lock file. Rerunning this command without any extra options will not reinstall plugin sources, just verify that they are correctly installed. It will always regenerate the lock file. sheldon lock To update all plugin sources you can use the --update flag. sheldon lock --update To force a reinstall of all plugin sources you can use the --reinstall flag. sheldon lock --reinstall","breadcrumbs":"💻 Command line interface » lock","id":"15","title":"lock"},"16":{"body":"This command generates the shell script. This command will first check if there is an up to date lock file, if not, then it will first do the equivalent of the lock command above. This command is usually used with the built-in shell eval command. eval \"$(sheldon source)\" But you can also run it directly to inspect the output. The output of this command is highly configurable. You can define your own custom templates to apply to your plugins.","breadcrumbs":"💻 Command line interface » source","id":"16","title":"source"},"17":{"body":"This command adds a new plugin to the config file. It does nothing else but edit the config file. In the following command we add a GitHub repository as a source. sheldon add my-repo --git https://github.com/owner/repo.git An example usage of this command for each source type is shown in the Configuration section.","breadcrumbs":"💻 Command line interface » add","id":"17","title":"add"},"18":{"body":"This command will open the config file in the default editor and only overwrite the contents if the updated config file is valid. To override the editor that is used you should set the EDITOR environment variable. For example using vim EDITOR=vim sheldon edit Or with Visual Studio Code EDITOR=\"code --wait\" sheldon edit","breadcrumbs":"💻 Command line interface » edit","id":"18","title":"edit"},"19":{"body":"This command removes a plugin from the config file. It does nothing else but edit the config file. In the following command we remove the plugin with name my-repo. sheldon remove my-repo","breadcrumbs":"💻 Command line interface » remove","id":"19","title":"remove"},"2":{"body":"Sheldon and its source code is licensed under either of Apache License, Version 2.0 MIT license at your option.","breadcrumbs":"Introduction » License","id":"2","title":"License"},"20":{"body":"Sheldon accepts the following global command line options and environment variables. You can also view all options by running Sheldon with -h or --help. The value that will be used for the option follows the following priority. Command line option. Environment variable. Default value. --color <when> Set the output coloring. always: Always use colored output. auto: Automatically determine whether to use colored output ( default ). never: Never use colored output. --config-dir <path> Environment variable: SHELDON_CONFIG_DIR Set the config directory where the configuration file will be stored. This defaults to $XDG_CONFIG_HOME/sheldon or ~/.config/sheldon. --data-dir <path> Environment variable: SHELDON_DATA_DIR Set the data directory where plugins will be downloaded to. This defaults to $XDG_DATA_HOME/sheldon or ~/.local/share/sheldon. --config-file <path> Environment variable: SHELDON_CONFIG_FILE Set the path to the config file. This defaults to <config-dir>/plugins.toml where <config-dir> is the config directory. --profile <profile> Environment variable: SHELDON_PROFILE Specify the profile to match plugins against. Plugins which have profiles configured will only get loaded if one of the given profiles matches the profile.","breadcrumbs":"💻 Command line interface » Options","id":"20","title":"Options"},"21":{"body":"Shell completion scripts for Bash and Zsh are available. If Sheldon was installed via Homebrew then the completions should have been installed automatically. They can also be generated by Sheldon using the completions subcommand which will output the completions to stdout. Refer to your specific shell documentation for more details on how to install these. sheldon completions --shell bash > /path/to/completions/sheldon.bash or sheldon completions --shell zsh > /path/to/completions/_sheldon","breadcrumbs":"💻 Command line interface » Completions","id":"21","title":"Completions"},"22":{"body":"","breadcrumbs":"⚙️ Configuration » ⚙️ Configuration","id":"22","title":"⚙️ Configuration"},"23":{"body":"A plugin is defined by adding a new unique name to the plugins table in the TOML config file. This can be done by either editing the file directly or using the provided Sheldon commands. A plugin must provide the location of the source. There are three types of sources, each kind is described in this section. A plugin may only specify one source type. # ~/.config/sheldon/plugins.toml # ┌─ Unique name for the plugin\n# ┌──┴─┐\n[plugins.base16]\ngithub = \"chriskempson/base16-shell\"\n# └─────┬────┘ └─────┬────┘\n# │ └─ GitHub repository name\n# └─ GitHub user or organization","breadcrumbs":"⚙️ Configuration » Plugin sources","id":"23","title":"Plugin sources"},"24":{"body":"Git sources specify a remote Git repository that will be cloned to the Sheldon data directory. There are three flavors of Git sources. github A GitHub source must set the github field and specify the repository. This should be the username or organization and the repository name separated by a forward slash. Add the following to the Sheldon config file. [plugins.example]\ngithub = \"owner/repo\" Or run add with the --github option. sheldon add example --github owner/repo gist A Gist source must set the gist field and specify the repository. This should be the hash or username and hash of the Gist. Add the following to the Sheldon config file. [plugins.example]\ngist = \"579d02802b1cc17baed07753d09f5009\" Or run add with the --gist option. sheldon add example --gist 579d02802b1cc17baed07753d09f5009 git A Git source must set the git field and specify the URL to clone. Add the following to the Sheldon config file. [plugins.example]\ngit = \"https://github.com/owner/repo\" Or run add with the --git option. sheldon add example --git https://github.com/owner/repo Specifying a branch, tag, or commit All Git sources also allow setting of one of the branch, tag or rev fields. Sheldon will then checkout the repository at this reference. [plugins.example]\ngithub = \"owner/repo\"\ntag = \"v0.1.0\" Or run add with the --tag, --branch, or --rev option. sheldon add example --github owner/repo --tag v0.1.0 Cloning with Git or SSH protocols GitHub and Gist sources are cloned using HTTPS by default. You can specify that Git or SSH should be used by setting the proto field to the protocol type. This must be one of git, https, or ssh. [plugins.example]\ngithub = \"owner/repo\"\nproto = \"ssh\" For a plain Git source you should specify the URL with a git:// or ssh://. For SSH you will need to specify the username as well (it is git for GitHub). [plugins.example]\ngit = \"ssh://git@github.com/owner/repo\" Private Git repositories Currently Sheldon only supports authentication when cloning using SSH and requires an SSH agent to provide credentials. This means if you have a plugin source that is a private repository you will have to use the SSH protocol for cloning.","breadcrumbs":"⚙️ Configuration » Git","id":"24","title":"Git"},"25":{"body":"Remote sources specify a remote file that will be downloaded by Sheldon. A remote source must set the remote field and specify the URL. Add the following to the Sheldon config file. [plugins.example]\nremote = \"https://github.com/owner/repo/raw/branch/plugin.zsh\" Or run add with the --remote option. sheldon add example --remote https://github.com/owner/repo/raw/branch/plugin.zsh","breadcrumbs":"⚙️ Configuration » Remote","id":"25","title":"Remote"},"26":{"body":"Local sources reference local directories. A local source must set the local field and specify a directory. Tildes may be used and will be expanded to the current user's home directory. Add the following to the Sheldon config file. [plugins.example]\nlocal = \"~/Downloads/plugin\" Or run add with the --local option. sheldon add example --local '~/Downloads/plugin'","breadcrumbs":"⚙️ Configuration » Local","id":"26","title":"Local"},"27":{"body":"These are options that are common to all the above plugins.","breadcrumbs":"⚙️ Configuration » Plugin options","id":"27","title":"Plugin options"},"28":{"body":"A list of files / globs to use in the plugin's source directory. If this field is not given then the first pattern in the global match field that matches any files will be used. Add the following to the Sheldon config file. [plugins.example]\ngithub = \"owner/repo\"\nuse = [\"*.zsh\"] Or run add with the --use option when adding the plugin. sheldon add example --github owner/repo --use '*.zsh'","breadcrumbs":"⚙️ Configuration » use","id":"28","title":"use"},"29":{"body":"A list of template names to apply to this plugin. This defaults to the global apply . [plugins.example]\ngithub = \"owner/repo\"\napply = [\"source\", \"PATH\"] Or run add with the --apply option when adding the plugin. sheldon add example --github owner/repo --apply source PATH You can define your own custom templates to apply to your plugins.","breadcrumbs":"⚙️ Configuration » apply","id":"29","title":"apply"},"3":{"body":"","breadcrumbs":"📦 Installation » 📦 Installation","id":"3","title":"📦 Installation"},"30":{"body":"A list of profiles this plugin should be used in. If this field is not given the plugin will be used regardless of the profile. Otherwise, the plugin is only used if the specified profile is included in the configured list of profiles.","breadcrumbs":"⚙️ Configuration » profiles","id":"30","title":"profiles"},"31":{"body":"For convenience it also possible to define Inline plugins. An Inline plugin must set the inline field and specify the raw source. [plugins.example]\ninline = 'example() { echo \"Just an example of inline shell code\" }'","breadcrumbs":"⚙️ Configuration » Inline plugins","id":"31","title":"Inline plugins"},"32":{"body":"A template defines how the shell source for a particular plugin is generated. For example the PATH template adds the plugin directory to the shell PATH variable. A template will be applied to a plugin if you add the template name to the apply field on a plugin. Available built-in templates are different depending on what shell you are using. The following are available for both Bash and Zsh. source : source each file in a plugin. PATH : add the plugin directory to the PATH variable. If you are using Zsh then the following are also available. path : add the plugin directory to the path variable. fpath : add the plugin directory to the fpath variable. As template strings in the config file they could be represented like the following. [templates]\nsource = \"{% for file in files %}source \\\"{{ file }}\\\"\\n{% endfor %}\"\nPATH = 'export PATH=\"{{ dir }}:$PATH\"'\npath = 'path=( \"{{ dir }}\" $path )'\nfpath = 'fpath=( \"{{ dir }}\" $fpath )' For example if we change the apply field for the below plugin, it will only add the plugin directory to the PATH and append it to the fpath. The plugin will not be sourced. [plugins.example]\ngithub = \"owner/repo\"\napply = [\"PATH\", \"fpath\"]","breadcrumbs":"⚙️ Configuration » Templates","id":"32","title":"Templates"},"33":{"body":"It is possible to create your own custom templates, and you can even override the built-in ones. Plugins all have the following information that can be used in templates. A unique name. This is completely arbitrary, and it is the value specified for the plugin in the plugins table. However, it is often the name of the plugin, so it can be useful to use this name in templates with {{ name }}. A directory. For Git sources this is the location of the cloned repository, for local sources, it is the directory specified. This directory can be used in templates with {{ dir }}. One or more files. These are the matched files in the plugin directory either discovered using the the global match field or specified as a plugin option with use. These can be used in templates by iterating over the files. For example: {% for file in files %} ... {{ file }} ... {% endfor %}. To add or update a template add a new key to the [templates] table in the config file. Take a look at the examples for some interesting applications of this.","breadcrumbs":"⚙️ Configuration » Custom templates","id":"33","title":"Custom templates"},"34":{"body":"","breadcrumbs":"⚙️ Configuration » Global options","id":"34","title":"Global options"},"35":{"body":"Indicates the shell that you are using. This setting will affect the default values for several global config settings. This includes the global match setting and the available templates. This defaults to zsh. shell = \"bash\" or shell = \"zsh\"","breadcrumbs":"⚙️ Configuration » shell","id":"35","title":"shell"},"36":{"body":"A list of glob patterns to match against a plugin's contents. The first pattern that matches any files will be used by default as a plugin's use field. This defaults to match = [ \"{{ name }}.plugin.zsh\", \"{{ name }}.zsh\", \"{{ name }}.sh\", \"{{ name }}.zsh-theme\", \"*.plugin.zsh\", \"*.zsh\", \"*.sh\", \"*.zsh-theme\"\n] If the shell is Bash then this defaults to match = [ \"{{ name }}.plugin.bash\", \"{{ name }}.plugin.sh\", \"{{ name }}.bash\", \"{{ name }}.sh\", \"*.plugin.bash\", \"*.plugin.sh\", \"*.bash\", \"*.sh\"\n]","breadcrumbs":"⚙️ Configuration » match","id":"36","title":"match"},"37":{"body":"A list of template names to apply to all plugins by default (see apply ). This defaults to apply = [\"source\"]","breadcrumbs":"⚙️ Configuration » apply","id":"37","title":"apply"},"38":{"body":"This section demonstrates the configuration file contents for some common installation practices as well how to configure popular plugins and themes.","breadcrumbs":"💡 Examples » 💡 Examples","id":"38","title":"💡 Examples"},"39":{"body":"A commonly desired feature of shell plugin managers is deferred loading of plugins because of the massive increase in speed that it provides. Because Sheldon is not written in a shell language it cannot provide the level of integration that other plugin managers can. However, it is pretty easy to get deferred loading working with Sheldon using romkatv/zsh-defer . Firstly, you should add zsh-defer as a plugin. [plugins.zsh-defer]\ngithub = \"romkatv/zsh-defer\" Important: the zsh-defer plugin definition should be placed before any plugins that will use the defer template. Sheldon always processes plugins in the order they are defined in the config file. Then add a template that calls zsh-defer source instead of just source. [templates]\ndefer = \"{% for file in files %}zsh-defer source \\\"{{ file }}\\\"\\n{% endfor %}\" Now any plugin that you want to defer you can apply the defer template. For example if you wanted to defer loading of zsh-syntax-highlighting. [plugins.zsh-syntax-highlighting]\ngithub = \"zsh-users/zsh-syntax-highlighting\"\napply = [\"defer\"]","breadcrumbs":"💡 Examples » Deferred loading of plugins in Zsh","id":"39","title":"Deferred loading of plugins in Zsh"},"4":{"body":"Sheldon can be installed using Homebrew. brew install sheldon","breadcrumbs":"📦 Installation » Homebrew","id":"4","title":"Homebrew"},"40":{"body":"The built-in PATH template adds the directory path to the beginning of the PATH variable, we might want to change it to the be added at the end. We could do this like this [templates]\nPATH = 'export PATH=\"$PATH:{{ dir }}\"' You can then apply it to the plugin like this [plugins.example]\ngithub = \"owner/repo\"\napply = [\"source\", \"PATH\"] Note: this would change the behavior of PATH for all plugins using it.","breadcrumbs":"💡 Examples » Overriding the PATH template","id":"40","title":"Overriding the PATH template"},"41":{"body":"","breadcrumbs":"💡 Examples » Zsh frameworks","id":"41","title":"Zsh frameworks"},"42":{"body":"Add the following to the Sheldon config file. [plugins.oh-my-zsh]\ngithub = \"ohmyzsh/ohmyzsh\" Or run the following to automatically add it. sheldon add oh-my-zsh --github \"ohmyzsh/ohmyzsh\" Add the following to your ~/.zshrc file. # ~/.zshrc export ZSH=\"$HOME/.local/share/sheldon/repos/github.com/ohmyzsh/ohmyzsh\" # Oh My Zsh settings here eval \"$(sheldon source)\"","breadcrumbs":"💡 Examples » ohmyzsh","id":"42","title":"ohmyzsh"},"43":{"body":"","breadcrumbs":"💡 Examples » Zsh plugins","id":"43","title":"Zsh plugins"},"44":{"body":"Add the following to the Sheldon config file. [plugins.zsh-autosuggestions]\ngithub = \"zsh-users/zsh-autosuggestions\"\nuse = [\"{{ name }}.zsh\"] Or run the following to automatically add it. sheldon add zsh-autosuggestions --github zsh-users/zsh-autosuggestions --use '{{ name }}.zsh'","breadcrumbs":"💡 Examples » autosuggestions","id":"44","title":"autosuggestions"},"45":{"body":"Add the following to the Sheldon config file. [plugins.autojump]\ngithub = \"wting/autojump\"\ndir = \"bin\"\napply = [\"PATH\", \"source\"] Or run the following to automatically add it. sheldon add autojump --github wting/autojump --dir bin --apply PATH source","breadcrumbs":"💡 Examples » autojump","id":"45","title":"autojump"},"46":{"body":"Add the following to the Sheldon config file. [plugins.zsh-syntax-highlighting]\ngithub = \"zsh-users/zsh-syntax-highlighting\" Or run the following to automatically add it. sheldon add zsh-syntax-highlighting --github zsh-users/zsh-syntax-highlighting","breadcrumbs":"💡 Examples » syntax-highlighting","id":"46","title":"syntax-highlighting"},"47":{"body":"Add the following to the Sheldon config file. [plugins.blackbox]\ngithub = \"StackExchange/blackbox\" Or run the following to automatically add it. sheldon add blackbox --github StackExchange/blackbox","breadcrumbs":"💡 Examples » blackbox","id":"47","title":"blackbox"},"48":{"body":"Add the following to the Sheldon config file. [plugins.\"z.lua\"]\ngithub = \"skywind3000/z.lua\" Or run the following to automatically add it. sheldon add z.lua --github skywind3000/z.lua","breadcrumbs":"💡 Examples » z.lua","id":"48","title":"z.lua"},"49":{"body":"Add the following to the Sheldon config file. [plugins.enhancd]\ngithub = \"b4b4r07/enhancd\" Or run the following to automatically add it. sheldon add enhancd --github b4b4r07/enhancd","breadcrumbs":"💡 Examples » enhancd","id":"49","title":"enhancd"},"5":{"body":"Sheldon can be installed from Crates.io using Cargo , the Rust package manager. cargo install sheldon","breadcrumbs":"📦 Installation » Cargo","id":"5","title":"Cargo"},"50":{"body":"Add the following to the Sheldon config file. [plugins.base16]\ngithub = \"chriskempson/base16-shell\" Or run the following to automatically add it. sheldon add base16 --github chriskempson/base16-shell","breadcrumbs":"💡 Examples » base16","id":"50","title":"base16"},"51":{"body":"","breadcrumbs":"💡 Examples » Zsh themes","id":"51","title":"Zsh themes"},"52":{"body":"Add the following to the Sheldon config file. [plugins.powerlevel10k]\ngithub = \"romkatv/powerlevel10k\" Or run the following to automatically add it. sheldon add powerlevel10k --github romkatv/powerlevel10k","breadcrumbs":"💡 Examples » powerlevel10k","id":"52","title":"powerlevel10k"},"53":{"body":"Add the following to the Sheldon config file. [plugins.spaceship]\ngithub = \"spaceship-prompt/spaceship-prompt\" Or run the following to automatically add it. sheldon add spaceship --github spaceship-prompt/spaceship-prompt","breadcrumbs":"💡 Examples » spaceship","id":"53","title":"spaceship"},"54":{"body":"Add the following to the Sheldon config file. [plugins.pure]\ngithub = \"sindresorhus/pure\"\nuse = [\"async.zsh\", \"pure.zsh\"] Or run the following to automatically add it. sheldon add pure --github sindresorhus/pure --use async.zsh pure.zsh","breadcrumbs":"💡 Examples » pure","id":"54","title":"pure"},"55":{"body":"","breadcrumbs":"📝 Release notes » 📝 Release notes","id":"55","title":"📝 Release notes"},"56":{"body":"October 13th, 2022","breadcrumbs":"📝 Release notes » 0.7.0","id":"56","title":"0.7.0"},"57":{"body":"Use XDG directories by default. Previously Sheldon tried to automatically detect whether the user wanted to use XDG. This proved difficult and Sheldon now follows the XDG directory structure by default. Sheldon will log a warning if the old directory ~/.sheldon is still used as the config directory. To use the new location you should move the config file from ~/.sheldon/plugins.toml to $XDG_CONFIG_HOME/sheldon/plugins.toml, which will be ~/.config/sheldon/plugins.toml if the XDG variable is unset. You can then safely delete the old ~/.sheldon directory. If you wish to preserve the existing behaviour you can simply set the following environment variables. SHELDON_CONFIG_DIR=\"$HOME/.sheldon\"\nSHELDON_DATA_DIR=\"$HOME/.sheldon\" Update template engine. Stop using Handlebars in favour of Jinja-like templating . This will only affect you if you were using custom templates. Only apply templates per plugin. This effectively removes the each field from the template configuration. Any templates that are applied to each file in a plugin need to now use a for loop. For example: {% for file in files %}\nsource \"{{ file }}\"\n{% endfor %} Remove clone, download dir and lock file options. These paths are no longer configurable, only the data directory is configurable.","breadcrumbs":"📝 Release notes » Breaking changes","id":"57","title":"Breaking changes"},"58":{"body":"Conditional sourcing of plugins using profiles. This allows you to specify a profile that a plugin is applicable to. The plugin will only be included when Sheldon is run with that profile. A separate lock file will be used for each profile. Plugins can specify the profiles using the profiles key. [plugins.example]\ngithub = \"owner/repo\"\nprofiles = [\"<name>\"] You can specify the profile in two ways: Command line flag: --profile <name> Environment variable: SHELDON_PROFILE=<name>. Support cargo-binstall. This allows Sheldon to be installed using cargo binstall sheldon which will fetch the release artifact for Sheldon from the GitHub release.","breadcrumbs":"📝 Release notes » Features","id":"58","title":"Features"},"59":{"body":"Fix not updating Git source branches after force pushes. Previously repositories with a branch that was force pushed wouldn't be updated by sheldon lock --update. Many other fixes and internal improvements.","breadcrumbs":"📝 Release notes » Fixes","id":"59","title":"Fixes"},"6":{"body":"Sheldon can be installed using cargo-binstall , which will download the release artifacts directly from the GitHub release. cargo binstall sheldon","breadcrumbs":"📦 Installation » Cargo BInstall","id":"6","title":"Cargo BInstall"},"60":{"body":"January 29th, 2022 Support and bundle shell completions.","breadcrumbs":"📝 Release notes » 0.6.6","id":"60","title":"0.6.6"},"61":{"body":"October 27th, 2021 Fix libgit2 compatibility issues.","breadcrumbs":"📝 Release notes » 0.6.5","id":"61","title":"0.6.5"},"62":{"body":"July 14th, 2021 Fix broken symlink handling. If a glob match includes a broken symlink Sheldon will now emit an error. Fix glob behaviour with uses.","breadcrumbs":"📝 Release notes » 0.6.4","id":"62","title":"0.6.4"},"63":{"body":"March 27th, 2021 Support Git proxy settings. (Contributed by @iclac .)","breadcrumbs":"📝 Release notes » 0.6.3","id":"63","title":"0.6.3"},"64":{"body":"March 13th, 2021 Fix edit bug. If the edit file existed and you chose the \"Abort\" option the file would be deleted by mistake. Always include details section in version output. This was previously excluded if there was no Git information.","breadcrumbs":"📝 Release notes » 0.6.2","id":"64","title":"0.6.2"},"65":{"body":"February 12th, 2021 Embed Git and Rustc information in binary. Git (if available) and Rustc information will now be displayed when passing --version to Sheldon. Switch to curl instead of reqwest. This significantly reduces compile time and binary size. Fix temporary file issues when using edit. Now the same file is used for editing, if it already exists then Sheldon will prompt the user to either re-open it or overwrite.","breadcrumbs":"📝 Release notes » 0.6.1","id":"65","title":"0.6.1"},"66":{"body":"October 16th, 2020","breadcrumbs":"📝 Release notes » 0.6.0","id":"66","title":"0.6.0"},"67":{"body":"Support XDG directory structure. If any XDG environment variable is set then Sheldon will adopt the XDG directory structure by default. The config file will be located at $XDG_CONFIG_HOME/sheldon/plugins.toml and downloaded data will be located in $XDG_CONFIG_DATA/sheldon. (Contributed by @tapeinosyne .) Change the default lock file location. For non-XDG directory structures the lock file now always defaults to $SHELDON_DATA_DIR/plugins.lock. It previously was the config file path with a .lock extension. Remove the Sheldon root. The root directory has been replaced by individual directories for configuration and data: config_dir and data_dir. Both default to $HOME/.sheldon, the old default root. (Contributed by @tapeinosyne .) If you used Sheldon's defaults, everything will just keep working as it did; no action needs to be taken. Otherwise, you may refer to this migration table: Old New Config paths <root>/plugins.toml <config_dir>/plugins.toml Data paths <root>/plugins.lock <data_dir>/plugins.lock <root>/repos <data_dir>/repos <root>/downloads <data_dir>/downloads Env variables SHELDON_ROOT SHELDON_CONFIG_DIR SHELDON_DATA_DIR CLI options --root --config-dir --data-dir Template variables {{ root }} {{ data_dir }} Auto-detect whether to use colored output. A new --color option was added with three values always, auto, or never. By default Sheldon will now automatically whether to use colored output or not (auto). But you can still force Sheldon to always use color or never use color with the --color always option or --color never. The previous --no-color option has been removed.","breadcrumbs":"📝 Release notes » Breaking changes","id":"67","title":"Breaking changes"},"68":{"body":"Fix performance bug introduced in version 0.5.4. A significant drop in performance was introduced by switching to the Rust rayon package. This change has been reverted. Fix --relock not being implied for other flags. This fixes a bug where passing --update or --reinstall to the source command didn't imply --relock like the documentation says.","breadcrumbs":"📝 Release notes » Fixes","id":"68","title":"Fixes"},"69":{"body":"August 14th, 2020","breadcrumbs":"📝 Release notes » 0.5.4","id":"69","title":"0.5.4"},"7":{"body":"Pre-built binaries for Linux (x86-64, aarch64, armv7) and macOS (x86-64) are provided. These can be downloaded directly from the the releases page . Alternatively, the following script can be used to automatically detect your host system, download the required artifact, and extract the sheldon binary to the given directory. curl --proto '=https' -fLsS https://rossmacarthur.github.io/install/crate.sh \\ | bash -s -- --repo rossmacarthur/sheldon --to ~/.local/bin","breadcrumbs":"📦 Installation » Pre-built binaries","id":"7","title":"Pre-built binaries"},"70":{"body":"Support extended glob syntax. This means that {a,b} and ! glob patterns can now be used. For example, the following is now valid. [plugins.ohmyzsh]\ngithub = \"ohmyzsh/ohmyzsh\"\ndir = \"lib\"\nuse = [\"{!git,!nvm,*}.zsh]","breadcrumbs":"📝 Release notes » Features","id":"70","title":"Features"},"71":{"body":"Fix not erroring out when no files matched for plugin. This fixes cases where no files would be matched for a plugin and Sheldon would silently continue, resulting in no source rendered by sheldon source. Update default templates for Bash, path and fpath are now removed. These templates were meaningless in a Bash context.","breadcrumbs":"📝 Release notes » Fixes","id":"71","title":"Fixes"},"72":{"body":"July 28th, 2020","breadcrumbs":"📝 Release notes » 0.5.3","id":"72","title":"0.5.3"},"73":{"body":"Add init command. Adds a new command to Sheldon which initializes a config file. Simply run sheldon init. Add shell config key. Indicates to Sheldon what type of shell is being used. Certain other config values will have different defaults if this value is set. Support updating of plugins via --update option. Simply run sheldon lock --update to update all plugin sources.","breadcrumbs":"📝 Release notes » Features","id":"73","title":"Features"},"74":{"body":"June 4th, 2020","breadcrumbs":"📝 Release notes » 0.5.2","id":"74","title":"0.5.2"},"75":{"body":"Fix not erroring out on a bad HTTP status code. This fixes remote sources from silently not being downloaded correctly. Fix missing status log. This fixes a missing status log for when fetching remote sources.","breadcrumbs":"📝 Release notes » Fixes","id":"75","title":"Fixes"},"76":{"body":"Only ship musl binaries. The download script will figure this out automatically.","breadcrumbs":"📝 Release notes » Other","id":"76","title":"Other"},"77":{"body":"May 11th, 2020 Using --reinstall on source command now implies --relock. Support aarch64 linux. Update Docker images to use OpenSSL 1.1.1g. This affects the shipped musl binaries which statically bundle OpenSSL.","breadcrumbs":"📝 Release notes » 0.5.1","id":"77","title":"0.5.1"},"78":{"body":"May 2nd, 2020","breadcrumbs":"📝 Release notes » 0.5.0","id":"78","title":"0.5.0"},"79":{"body":"Add add and remove commands to edit config. These commands will edit the config file for you. For example sheldon add example --github owner/repo --tag v0.1.0 will add the following to the config file [plugins.example]\ngithub = \"owner/repo\"\ntag = \"v0.1.0\" The following will remove it again. sheldon remove example Add edit command. Adds a new command to Sheldon which allows you to open the config file in the default editor. Simply run sheldon edit. Add initial config file. When running add or edit Sheldon will attempt to initialize a new config file at ~/.sheldon/plugins.toml. Warn about unused config keys. Anytime Sheldon loads the config file it will log warnings when there are unused config keys. Great for catching typos!","breadcrumbs":"📝 Release notes » Features","id":"79","title":"Features"},"8":{"body":"Sheldon is written in Rust, so to install it from source you will first need to install Rust and Cargo using rustup . Then you can run the following to build Sheldon. git clone https://github.com/rossmacarthur/sheldon.git\ncd sheldon\ncargo build --release The binary will be found at target/release/sheldon.","breadcrumbs":"📦 Installation » Building from source","id":"8","title":"Building from source"},"80":{"body":"Update default root directory and clone directory. The root directory now defaults to ~/.sheldon and the clone directory now defaults to {root}/repos. To migrate you should do the following: mv ~/.zsh ~/.sheldon\nmv ~/.sheldon/repositories ~/.sheldon/repos Or to preserve the old behavior you should export the following before running Sheldon. export SHELDON_ROOT=\"$HOME/.zsh\"\nexport SHELDON_CLONE_DIR=\"$SHELDON_ROOT/repositories\"","breadcrumbs":"📝 Release notes » Breaking changes","id":"80","title":"Breaking changes"},"81":{"body":"Download/clone sources to a temporary path first. This fixes an issue ( #99 ) where if someone tried to reinstall they would be left without any plugins because they would all be nuked up front prior to trying to download them.","breadcrumbs":"📝 Release notes » Fixes","id":"81","title":"Fixes"},"82":{"body":"Most of these are still supported, however Sheldon will log a deprecation warning if you use them. Rename filename to file This affects both the the config file and the template rendering context. Rename directory to dir. This affects both the the config file and the template rendering context. Rename protocol plugin config key to proto. Rename revision plugin config key to rev.","breadcrumbs":"📝 Release notes » Deprecations","id":"82","title":"Deprecations"},"83":{"body":"November 3rd, 2019 Auto clean clone and download directories . Unused source directories and files will now be automatically removed. Support Git submodules. After cloning and checking out a repository submodules will now be recursively fetched. Support Git source cloning using Git and SSH protocols. This adds an optional protocol field to plugin configuration which can be used to specify the protocol for Gist and GitHub sources. Additionally, Git sources can now specify URLs with protocols git:// and ssh://.","breadcrumbs":"📝 Release notes » 0.4.8","id":"83","title":"0.4.8"},"84":{"body":"October 22nd, 2019 Add --clone-dir and --download-dir options. The directories where Git plugin sources are cloned to, and remote sources are downloaded to, are now configurable. Environment variables for setting these options are also now available. Fix --config-file and --lock-file options. These two options were previously ignored and only the environment variables were recognized.","breadcrumbs":"📝 Release notes » 0.4.7","id":"84","title":"0.4.7"},"85":{"body":"August 18th, 2019 Support globs in local plugin directories. Globs should match only one directory. Support for inline plugins.","breadcrumbs":"📝 Release notes » 0.4.6","id":"85","title":"0.4.6"},"86":{"body":"July 19th, 2019 Require mutex to run a Sheldon command. Makes sure multiple instances of Sheldon do not interfere with each other!","breadcrumbs":"📝 Release notes » 0.4.5","id":"86","title":"0.4.5"},"87":{"body":"July 7th, 2019 Warn instead of erroring when running sheldon source. This allows at least some plugins to be sourced, this only happens if there is already a lock file.","breadcrumbs":"📝 Release notes » 0.4.4","id":"87","title":"0.4.4"},"88":{"body":"July 3rd, 2019 Verify that locked directories and filenames exist when running sheldon source. If they do not then sheldon lock will be run again.","breadcrumbs":"📝 Release notes » 0.4.3","id":"88","title":"0.4.3"},"89":{"body":"June 27th, 2019 Improve output granularity and add --verbose option.","breadcrumbs":"📝 Release notes » 0.4.2","id":"89","title":"0.4.2"},"9":{"body":"","breadcrumbs":"🚀 Getting started » 🚀 Getting started","id":"9","title":"🚀 Getting started"},"90":{"body":"June 2nd, 2019 Add --no-color option. Replace home directory with tilde in output. Support directory key for plugins. The plugin directory can now be configured to be a sub directory of the source.","breadcrumbs":"📝 Release notes » 0.4.1","id":"90","title":"0.4.1"},"91":{"body":"May 26th, 2019 Complete refactor including breaking changes to the configuration file from prior versions.","breadcrumbs":"📝 Release notes » 0.4.0","id":"91","title":"0.4.0"}},"length":92,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"4":{".":{"0":{"df":1,"docs":{"91":{"tf":1.0}}},"1":{"df":1,"docs":{"90":{"tf":1.0}}},"2":{"df":1,"docs":{"89":{"tf":1.0}}},"3":{"df":1,"docs":{"88":{"tf":1.0}}},"4":{"df":1,"docs":{"87":{"tf":1.0}}},"5":{"df":1,"docs":{"86":{"tf":1.0}}},"6":{"df":1,"docs":{"85":{"tf":1.0}}},"7":{"df":1,"docs":{"84":{"tf":1.0}}},"8":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"0":{"df":1,"docs":{"78":{"tf":1.0}}},"1":{"df":1,"docs":{"77":{"tf":1.0}}},"2":{"df":1,"docs":{"74":{"tf":1.0}}},"3":{"df":1,"docs":{"72":{"tf":1.0}}},"4":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{".":{"0":{"df":1,"docs":{"66":{"tf":1.0}}},"1":{"df":1,"docs":{"65":{"tf":1.0}}},"2":{"df":1,"docs":{"64":{"tf":1.0}}},"3":{"df":1,"docs":{"63":{"tf":1.0}}},"4":{"df":1,"docs":{"62":{"tf":1.0}}},"5":{"df":1,"docs":{"61":{"tf":1.0}}},"6":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"1":{".":{"1":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"77":{"tf":1.0}}}}},"2":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"65":{"tf":1.0}}}}},"3":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"56":{"tf":1.0},"64":{"tf":1.0}}}}},"4":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"62":{"tf":1.0},"69":{"tf":1.0}}}}},"6":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}}},"8":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"85":{"tf":1.0}}}}},"9":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"9":{"df":9,"docs":{"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":6,"docs":{"66":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}}},"1":{"df":5,"docs":{"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"2":{"df":2,"docs":{"56":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}},"6":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"91":{"tf":1.0}}}}},"7":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"61":{"tf":1.0},"63":{"tf":1.0},"89":{"tf":1.0}}}}},"8":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"72":{"tf":1.0}}}}},"9":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"78":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}},"3":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"4":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}}},"5":{"7":{"9":{"d":{"0":{"2":{"8":{"0":{"2":{"b":{"1":{"c":{"c":{"1":{"7":{"b":{"a":{"df":0,"docs":{},"e":{"d":{"0":{"7":{"7":{"5":{"3":{"d":{"0":{"9":{"df":0,"docs":{},"f":{"5":{"0":{"0":{"9":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"7":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"87":{"tf":1.0}}}}},"9":{"9":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"a":{",":{"b":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":2,"docs":{"7":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}},"v":{"df":2,"docs":{"16":{"tf":1.0},"27":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"d":{"d":{"df":31,"docs":{"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":2.0},"24":{"tf":3.3166247903554},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"32":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":2.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":1.7320508075688772},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"79":{"tf":2.8284271247461903},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":6,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"35":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"79":{"tf":1.0},"88":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"24":{"tf":1.0},"58":{"tf":1.4142135623730951},"79":{"tf":1.0},"87":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"65":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"15":{"tf":1.0},"20":{"tf":1.4142135623730951},"39":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":2.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"11":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"33":{"tf":1.0},"58":{"tf":1.0}}},"df":8,"docs":{"16":{"tf":1.0},"29":{"tf":2.6457513110645907},"32":{"tf":2.0},"37":{"tf":2.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"33":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"v":{"7":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"85":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"o":{"df":3,"docs":{"20":{"tf":1.0},"67":{"tf":1.7320508075688772},"83":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":19,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}}}},"df":1,"docs":{"13":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":2.23606797749979}}}}}}}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"21":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":1.0},"65":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"4":{"b":{"4":{"df":0,"docs":{},"r":{"0":{"7":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"d":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"df":8,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"7":{"tf":1.0},"71":{"tf":1.4142135623730951}},"r":{"c":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"68":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"80":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"80":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"0":{"tf":1.0},"65":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}}},"df":1,"docs":{"45":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"32":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"24":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":4,"docs":{"57":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"4":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"64":{"tf":1.0},"68":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"df":5,"docs":{"16":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"60":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":4,"docs":{"5":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"80":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"16":{"tf":1.0},"83":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"23":{"tf":1.0},"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"67":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":8,"docs":{"11":{"tf":1.0},"24":{"tf":2.449489742783178},"33":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"20":{"tf":2.23606797749979},"67":{"tf":2.8284271247461903},"90":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":18,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":2.449489742783178},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"23":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":2.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"38":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"21":{"tf":2.6457513110645907},"33":{"tf":1.0},"60":{"tf":1.0},"91":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"23":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{">":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":33,"docs":{"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":2.6457513110645907},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"67":{"tf":2.0},"73":{"tf":1.7320508075688772},"79":{"tf":3.0},"82":{"tf":2.0},"84":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"67":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"71":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"63":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"33":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"65":{"tf":1.0},"7":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"26":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"16":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.4142135623730951},"57":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{">":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":4,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":2.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":13,"docs":{"18":{"tf":1.0},"20":{"tf":2.23606797749979},"24":{"tf":1.0},"29":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"67":{"tf":2.6457513110645907},"71":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":4.0}}}},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"16":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"64":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"21":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"57":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"32":{"tf":1.0},"73":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{">":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":10,"docs":{"20":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.4142135623730951},"70":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":17,"docs":{"20":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.0},"32":{"tf":2.23606797749979},"33":{"tf":2.0},"40":{"tf":1.0},"57":{"tf":2.449489742783178},"67":{"tf":2.23606797749979},"7":{"tf":1.0},"80":{"tf":2.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":2.0}}}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":12,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"23":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"79":{"tf":2.23606797749979}},"o":{"df":0,"docs":{},"r":{"=":{"\"":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":2,"docs":{"18":{"tf":1.7320508075688772},"79":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"b":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"57":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"d":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":1,"docs":{"67":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"18":{"tf":1.0},"20":{"tf":2.449489742783178},"57":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"62":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"42":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":16,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"88":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"32":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"39":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"58":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":11,"docs":{"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"36":{"tf":1.0},"57":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":46,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"33":{"tf":2.6457513110645907},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":2.449489742783178},"58":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"67":{"tf":2.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":2.449489742783178},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0},"91":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"82":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"28":{"tf":1.0},"36":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"x":{"df":10,"docs":{"59":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":2.0},"71":{"tf":1.7320508075688772},"75":{"tf":2.23606797749979},"81":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"58":{"tf":1.0},"68":{"tf":1.0}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":29,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}}},"r":{"c":{"df":3,"docs":{"15":{"tf":1.0},"59":{"tf":1.4142135623730951},"67":{"tf":1.0}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"32":{"tf":2.6457513110645907},"71":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0}}}}},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"24":{"tf":2.8284271247461903},"83":{"tf":1.0}}}},"t":{",":{"!":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{",":{"*":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":11,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"24":{"tf":4.358898943540674},"33":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"8":{"tf":1.0},"83":{"tf":2.23606797749979},"84":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":27,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"11":{"tf":1.7320508075688772},"17":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":3.3166247903554},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951}}}},"df":5,"docs":{"28":{"tf":1.0},"36":{"tf":1.0},"62":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"20":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"46":{"tf":2.23606797749979}}}}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"21":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"26":{"tf":1.0},"90":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":3,"docs":{"24":{"tf":1.4142135623730951},"7":{"tf":1.0},"75":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"/":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"59":{"tf":1.0},"89":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":6,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"35":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.0},"33":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":2.0},"73":{"tf":1.4142135623730951}},"i":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"31":{"tf":2.449489742783178},"85":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"3":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"n":{"c":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"39":{"tf":1.0},"65":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"f":{"a":{"c":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"61":{"tf":1.0},"65":{"tf":1.0},"81":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"a":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"62":{"tf":1.0},"72":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"74":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}},"y":{"df":6,"docs":{"33":{"tf":1.0},"58":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"i":{"b":{"df":1,"docs":{"70":{"tf":1.0}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"2":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":2.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.4142135623730951},"58":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"7":{"tf":1.0},"77":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0}}}}},"o":{"a":{"d":{"df":4,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":2.0},"79":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":4,"docs":{"0":{"tf":1.0},"26":{"tf":2.8284271247461903},"33":{"tf":1.0},"85":{"tf":1.0}}},"t":{"df":4,"docs":{"23":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":12,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":2.6457513110645907},"16":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.7320508075688772},"73":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":4,"docs":{"57":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"82":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"33":{"tf":1.0}}},"p":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"86":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"39":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"63":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"20":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":2.23606797749979},"62":{"tf":1.0},"71":{"tf":1.4142135623730951},"85":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"24":{"tf":1.0},"70":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"21":{"tf":1.0},"33":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"l":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.0},"36":{"tf":2.8284271247461903},"37":{"tf":1.0},"44":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"32":{"tf":1.0},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":4,"docs":{"24":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772}}}}},"w":{"df":9,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.0},"55":{"tf":1.0}}},"h":{"df":3,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":12,"docs":{"39":{"tf":1.0},"57":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"u":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":4,"docs":{"56":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"42":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"l":{"d":{"df":3,"docs":{"57":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":5,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"65":{"tf":1.0},"79":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":20,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.23606797749979},"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":2.0},"73":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"30":{"tf":1.0},"67":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"16":{"tf":1.4142135623730951},"20":{"tf":2.0},"21":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"18":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"65":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":7,"docs":{"24":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"40":{"tf":1.0},"58":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"5":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"\"":{"$":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"20":{"tf":2.0},"29":{"tf":1.4142135623730951},"32":{"tf":3.7416573867739413},"40":{"tf":2.6457513110645907},"45":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.7320508075688772},"71":{"tf":1.0},"81":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.0},"36":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.4142135623730951}}},".":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}},"df":35,"docs":{"0":{"tf":2.23606797749979},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":2.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"32":{"tf":3.3166247903554},"33":{"tf":2.449489742783178},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":3.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0},"90":{"tf":1.4142135623730951}},"s":{".":{"\"":{"df":0,"docs":{},"z":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":3,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"24":{"tf":2.449489742783178},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.0},"58":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"1":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"39":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"31":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"1":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"57":{"tf":1.0},"80":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"67":{"tf":1.0}},"s":{"df":5,"docs":{"57":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"81":{"tf":1.0},"91":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"20":{"tf":2.449489742783178},"30":{"tf":2.23606797749979},"58":{"tf":3.0}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"53":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":2.0}}}}},"df":3,"docs":{"24":{"tf":1.4142135623730951},"7":{"tf":1.0},"82":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}},"i":{"d":{"df":5,"docs":{"10":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"39":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"65":{"tf":1.0}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"67":{"tf":1.0}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":2.0},"68":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":2.8284271247461903},"75":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"v":{"df":8,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":2.0},"57":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"79":{"tf":1.7320508075688772},"83":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":2.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"67":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"7":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":2.6457513110645907},"33":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"24":{"tf":1.0},"7":{"tf":1.0},"86":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"71":{"tf":1.0}}}}}},"v":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"1":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{">":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"67":{"tf":2.23606797749979},"80":{"tf":1.4142135623730951}},"}":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"80":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":27,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"73":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"df":3,"docs":{"5":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":13,"docs":{"18":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.7320508075688772},"42":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"84":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"h":{"df":1,"docs":{"36":{"tf":2.0}},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"67":{"tf":1.0}}},"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"57":{"tf":1.0},"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"80":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}}}}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"=":{"\"":{"$":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"=":{"\"":{"$":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"=":{"\"":{"$":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}},"e":{"=":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"=":{"\"":{"$":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":52,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.0},"10":{"tf":2.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":3.1622776601683795},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":2.23606797749979},"58":{"tf":2.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":2.0},"79":{"tf":2.449489742783178},"8":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"82":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":17,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"21":{"tf":2.0},"23":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":2.0},"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"60":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"75":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"57":{"tf":1.0},"73":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"3":{"0":{"0":{"0":{"/":{"df":0,"docs":{},"z":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":37,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":3.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":2.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":2.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":1.0}},"i":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":2.8284271247461903},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":3.0},"83":{"tf":1.4142135623730951}}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"/":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"75":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"57":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"57":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"32":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"67":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"90":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":12,"docs":{"24":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"86":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":3,"docs":{"39":{"tf":1.7320508075688772},"46":{"tf":2.23606797749979},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"33":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"24":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":13,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":2.8284271247461903},"33":{"tf":2.8284271247461903},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.7320508075688772},"57":{"tf":2.449489742783178},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"65":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"51":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"67":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"26":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"23":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"57":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"w":{"df":0,"docs":{},"o":{"df":2,"docs":{"58":{"tf":1.0},"84":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":5,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"73":{"tf":1.0}}},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":3,"docs":{"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"79":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.0},"15":{"tf":1.7320508075688772},"18":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.7320508075688772},"68":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":2.0},"77":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"16":{"tf":1.0},"81":{"tf":1.0}}},"r":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"83":{"tf":1.0}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":37,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":2.0},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":2.0},"26":{"tf":1.0},"28":{"tf":2.449489742783178},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":2.6457513110645907},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"58":{"tf":2.0},"6":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":4,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"s":{"/":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"39":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"0":{".":{"1":{".":{"0":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"18":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"20":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"18":{"tf":1.0},"20":{"tf":2.449489742783178},"32":{"tf":2.0},"40":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"67":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"2":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"91":{"tf":1.0}}}}}}}},"i":{"a":{"df":2,"docs":{"21":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"m":{"df":1,"docs":{"18":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"57":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"57":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"87":{"tf":1.0}}}},"y":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"24":{"tf":1.0},"38":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"20":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"81":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{"8":{"6":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"57":{"tf":1.0},"67":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"57":{"tf":2.0},"67":{"tf":2.0}}}},"df":0,"docs":{}},"z":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"=":{"\"":{"$":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"39":{"tf":2.6457513110645907},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"51":{"tf":1.0},"80":{"tf":1.0}},"r":{"c":{"df":3,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"breadcrumbs":{"root":{"0":{".":{"4":{".":{"0":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}},"7":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}},"8":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"0":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}},"4":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{".":{"0":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"1":{".":{"1":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"77":{"tf":1.0}}}}},"2":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"65":{"tf":1.0}}}}},"3":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"56":{"tf":1.0},"64":{"tf":1.0}}}}},"4":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"62":{"tf":1.0},"69":{"tf":1.0}}}}},"6":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}}},"8":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"85":{"tf":1.0}}}}},"9":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"9":{"df":9,"docs":{"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":6,"docs":{"66":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}}},"1":{"df":5,"docs":{"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"2":{"df":2,"docs":{"56":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}},"6":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"91":{"tf":1.0}}}}},"7":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"61":{"tf":1.0},"63":{"tf":1.0},"89":{"tf":1.0}}}}},"8":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"72":{"tf":1.0}}}}},"9":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"78":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}},"3":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"83":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"4":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}}},"5":{"7":{"9":{"d":{"0":{"2":{"8":{"0":{"2":{"b":{"1":{"c":{"c":{"1":{"7":{"b":{"a":{"df":0,"docs":{},"e":{"d":{"0":{"7":{"7":{"5":{"3":{"d":{"0":{"9":{"df":0,"docs":{},"f":{"5":{"0":{"0":{"9":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"7":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"87":{"tf":1.0}}}}},"9":{"9":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"a":{",":{"b":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":2,"docs":{"7":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}},"v":{"df":2,"docs":{"16":{"tf":1.0},"27":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"d":{"d":{"df":31,"docs":{"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":2.23606797749979},"24":{"tf":3.3166247903554},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"32":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":2.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":1.7320508075688772},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"79":{"tf":2.8284271247461903},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":6,"docs":{"11":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"35":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"79":{"tf":1.0},"88":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"24":{"tf":1.0},"58":{"tf":1.4142135623730951},"79":{"tf":1.0},"87":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"65":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"15":{"tf":1.0},"20":{"tf":1.4142135623730951},"39":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":2.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"11":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"33":{"tf":1.0},"58":{"tf":1.0}}},"df":8,"docs":{"16":{"tf":1.0},"29":{"tf":2.8284271247461903},"32":{"tf":2.0},"37":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"33":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"v":{"7":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"85":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"o":{"df":3,"docs":{"20":{"tf":1.0},"67":{"tf":1.7320508075688772},"83":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.7320508075688772}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":19,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}}}},"df":1,"docs":{"13":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":2.449489742783178}}}}}}}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"21":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":1.0},"65":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"4":{"b":{"4":{"df":0,"docs":{},"r":{"0":{"7":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"d":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"h":{"df":8,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"7":{"tf":1.0},"71":{"tf":1.4142135623730951}},"r":{"c":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"68":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"80":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"80":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"0":{"tf":1.0},"65":{"tf":1.4142135623730951},"7":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}}},"df":1,"docs":{"45":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"6":{"tf":2.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"47":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"32":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"24":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":4,"docs":{"57":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"4":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"64":{"tf":1.0},"68":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":2.0}}},"df":0,"docs":{},"t":{"df":5,"docs":{"16":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"60":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":4,"docs":{"5":{"tf":2.0},"58":{"tf":1.4142135623730951},"6":{"tf":2.0},"8":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"80":{"tf":1.4142135623730951},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"16":{"tf":1.0},"83":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"23":{"tf":1.0},"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"67":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":8,"docs":{"11":{"tf":1.0},"24":{"tf":2.449489742783178},"33":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.7320508075688772},"13":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"20":{"tf":2.23606797749979},"67":{"tf":2.8284271247461903},"90":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":19,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":2.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":2.6457513110645907},"17":{"tf":2.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"23":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":2.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"38":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"21":{"tf":2.8284271247461903},"33":{"tf":1.0},"60":{"tf":1.0},"91":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"23":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{">":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":33,"docs":{"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":2.6457513110645907},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"67":{"tf":2.0},"73":{"tf":1.7320508075688772},"79":{"tf":3.0},"82":{"tf":2.0},"84":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":28,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"67":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"71":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"63":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"33":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"65":{"tf":1.0},"7":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"26":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"16":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.7320508075688772},"57":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{">":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":4,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":2.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":13,"docs":{"18":{"tf":1.0},"20":{"tf":2.23606797749979},"24":{"tf":1.0},"29":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"67":{"tf":2.6457513110645907},"71":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":4.123105625617661}}}},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"16":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"64":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"21":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"57":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"32":{"tf":1.0},"73":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{">":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":10,"docs":{"20":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.4142135623730951},"70":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":17,"docs":{"20":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.0},"32":{"tf":2.23606797749979},"33":{"tf":2.0},"40":{"tf":1.0},"57":{"tf":2.449489742783178},"67":{"tf":2.23606797749979},"7":{"tf":1.0},"80":{"tf":2.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":2.0}}}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":12,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.0},"23":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"79":{"tf":2.23606797749979}},"o":{"df":0,"docs":{},"r":{"=":{"\"":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":2,"docs":{"18":{"tf":1.7320508075688772},"79":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"b":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"57":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"d":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":1,"docs":{"67":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"18":{"tf":1.0},"20":{"tf":2.449489742783178},"57":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"62":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"42":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":31,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"38":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"88":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"32":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"39":{"tf":1.0},"58":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}}}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"58":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":11,"docs":{"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"36":{"tf":1.0},"57":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":46,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"33":{"tf":2.6457513110645907},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":2.449489742783178},"58":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"67":{"tf":2.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":2.449489742783178},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0},"91":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"82":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"28":{"tf":1.0},"36":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"x":{"df":10,"docs":{"59":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":2.23606797749979},"71":{"tf":2.0},"75":{"tf":2.449489742783178},"81":{"tf":1.7320508075688772},"84":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"58":{"tf":1.0},"68":{"tf":1.0}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":29,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}}},"r":{"c":{"df":3,"docs":{"15":{"tf":1.0},"59":{"tf":1.4142135623730951},"67":{"tf":1.0}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"32":{"tf":2.6457513110645907},"71":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0}}}}},"t":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"24":{"tf":2.8284271247461903},"83":{"tf":1.0}}}},"t":{",":{"!":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{",":{"*":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":11,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"24":{"tf":4.47213595499958},"33":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"8":{"tf":1.0},"83":{"tf":2.23606797749979},"84":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":27,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"11":{"tf":1.7320508075688772},"17":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":3.3166247903554},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951}}}},"df":5,"docs":{"28":{"tf":1.0},"36":{"tf":1.0},"62":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"20":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"46":{"tf":2.449489742783178}}}}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"21":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}},"df":2,"docs":{"26":{"tf":1.0},"90":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":3,"docs":{"24":{"tf":1.4142135623730951},"7":{"tf":1.0},"75":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"/":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"59":{"tf":1.0},"89":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":6,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"35":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.0},"33":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":2.23606797749979},"73":{"tf":1.4142135623730951}},"i":{"df":5,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"31":{"tf":2.6457513110645907},"85":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"38":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"n":{"c":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"39":{"tf":1.0},"65":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"f":{"a":{"c":{"df":10,"docs":{"10":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}}},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"t":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"61":{"tf":1.0},"65":{"tf":1.0},"81":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"a":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"62":{"tf":1.0},"72":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"74":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}},"y":{"df":6,"docs":{"33":{"tf":1.0},"58":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"i":{"b":{"df":1,"docs":{"70":{"tf":1.0}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"2":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":2.23606797749979}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"58":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"7":{"tf":1.0},"77":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0}}}}},"o":{"a":{"d":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"39":{"tf":2.23606797749979},"79":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":4,"docs":{"0":{"tf":1.0},"26":{"tf":3.0},"33":{"tf":1.0},"85":{"tf":1.0}}},"t":{"df":4,"docs":{"23":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":12,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":2.8284271247461903},"16":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.7320508075688772},"73":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":4,"docs":{"57":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"82":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"33":{"tf":1.0}}},"p":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"86":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"39":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"63":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"20":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":2.449489742783178},"62":{"tf":1.0},"71":{"tf":1.4142135623730951},"85":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"24":{"tf":1.0},"70":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"21":{"tf":1.0},"33":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"l":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.0},"36":{"tf":2.8284271247461903},"37":{"tf":1.0},"44":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"32":{"tf":1.0},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":4,"docs":{"24":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772}}}}},"w":{"df":9,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":38,"docs":{"40":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"h":{"df":3,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":12,"docs":{"39":{"tf":1.0},"57":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"u":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":4,"docs":{"56":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"42":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"42":{"tf":1.4142135623730951}}}}}}}},"l":{"d":{"df":3,"docs":{"57":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":5,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"65":{"tf":1.0},"79":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":20,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.449489742783178},"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"57":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":2.0},"73":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"30":{"tf":1.0},"67":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"16":{"tf":1.4142135623730951},"20":{"tf":2.0},"21":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"18":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"65":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":7,"docs":{"24":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"40":{"tf":1.0},"58":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"5":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"\"":{"$":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"20":{"tf":2.0},"29":{"tf":1.4142135623730951},"32":{"tf":3.7416573867739413},"40":{"tf":2.8284271247461903},"45":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.7320508075688772},"71":{"tf":1.0},"81":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.0},"36":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.4142135623730951}}},".":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}},"df":35,"docs":{"0":{"tf":2.23606797749979},"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"15":{"tf":2.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"23":{"tf":2.6457513110645907},"24":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.7320508075688772},"31":{"tf":2.0},"32":{"tf":3.3166247903554},"33":{"tf":2.449489742783178},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":3.1622776601683795},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":2.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0},"90":{"tf":1.4142135623730951}},"s":{".":{"\"":{"df":0,"docs":{},"z":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":3,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"24":{"tf":2.449489742783178},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.0},"58":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"1":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"39":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"31":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"1":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"57":{"tf":1.0},"80":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"67":{"tf":1.0}},"s":{"df":5,"docs":{"57":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"81":{"tf":1.0},"91":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"20":{"tf":2.449489742783178},"30":{"tf":2.449489742783178},"58":{"tf":3.0}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"53":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":2.0}}}}},"df":3,"docs":{"24":{"tf":1.4142135623730951},"7":{"tf":1.0},"82":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}},"i":{"d":{"df":5,"docs":{"10":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"39":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"54":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"65":{"tf":1.0}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"67":{"tf":1.0}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":2.0},"68":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":40,"docs":{"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":3.0},"75":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"v":{"df":8,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":2.23606797749979},"57":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"79":{"tf":1.7320508075688772},"83":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":2.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"67":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"7":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":2.6457513110645907},"33":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"24":{"tf":1.0},"7":{"tf":1.0},"86":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"71":{"tf":1.0}}}}}},"v":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"1":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{">":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"67":{"tf":2.23606797749979},"80":{"tf":1.4142135623730951}},"}":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"80":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":27,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"73":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}},"df":3,"docs":{"5":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":13,"docs":{"18":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.7320508075688772},"42":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"84":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"h":{"df":1,"docs":{"36":{"tf":2.0}},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"67":{"tf":1.0}}},"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"57":{"tf":1.0},"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"80":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}}}}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"=":{"\"":{"$":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"=":{"\"":{"$":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"=":{"\"":{"$":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}},"e":{"=":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"=":{"\"":{"$":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":52,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.0},"10":{"tf":2.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":3.1622776601683795},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":2.23606797749979},"58":{"tf":2.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":2.0},"79":{"tf":2.449489742783178},"8":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"82":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":17,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"21":{"tf":2.0},"23":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":2.23606797749979},"36":{"tf":1.0},"39":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"60":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"75":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"57":{"tf":1.0},"73":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"3":{"0":{"0":{"0":{"/":{"df":0,"docs":{},"z":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":37,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":2.23606797749979},"24":{"tf":3.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"77":{"tf":1.0},"8":{"tf":1.7320508075688772},"81":{"tf":1.0},"83":{"tf":2.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":1.0}},"i":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":2.8284271247461903},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":3.0},"83":{"tf":1.4142135623730951}}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"/":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"75":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"57":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"57":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"32":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"67":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"90":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":12,"docs":{"24":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"86":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":3,"docs":{"39":{"tf":1.7320508075688772},"46":{"tf":2.449489742783178},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"33":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"24":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":13,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":3.0},"33":{"tf":3.0},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":2.0},"57":{"tf":2.449489742783178},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"65":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"51":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"67":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"26":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"23":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"57":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"w":{"df":0,"docs":{},"o":{"df":2,"docs":{"58":{"tf":1.0},"84":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":5,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"73":{"tf":1.0}}},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":3,"docs":{"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"79":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.0},"15":{"tf":1.7320508075688772},"18":{"tf":1.0},"33":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.7320508075688772},"68":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":2.0},"77":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"16":{"tf":1.0},"81":{"tf":1.0}}},"r":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"83":{"tf":1.0}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":37,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":2.0},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":2.0},"26":{"tf":1.0},"28":{"tf":2.6457513110645907},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":2.6457513110645907},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"58":{"tf":2.0},"6":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":4,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"s":{"/":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"39":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"0":{".":{"1":{".":{"0":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"18":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"20":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"18":{"tf":1.0},"20":{"tf":2.449489742783178},"32":{"tf":2.0},"40":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"67":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"2":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"91":{"tf":1.0}}}}}}}},"i":{"a":{"df":2,"docs":{"21":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"m":{"df":1,"docs":{"18":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"57":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"57":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"87":{"tf":1.0}}}},"y":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"24":{"tf":1.0},"38":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"20":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"81":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{"8":{"6":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"57":{"tf":1.0},"67":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"57":{"tf":2.0},"67":{"tf":2.0}}}},"df":0,"docs":{}},"z":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"=":{"\"":{"$":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"39":{"tf":2.8284271247461903},"41":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"80":{"tf":1.0}},"r":{"c":{"df":3,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"title":{"root":{"0":{".":{"4":{".":{"0":{"df":1,"docs":{"91":{"tf":1.0}}},"1":{"df":1,"docs":{"90":{"tf":1.0}}},"2":{"df":1,"docs":{"89":{"tf":1.0}}},"3":{"df":1,"docs":{"88":{"tf":1.0}}},"4":{"df":1,"docs":{"87":{"tf":1.0}}},"5":{"df":1,"docs":{"86":{"tf":1.0}}},"6":{"df":1,"docs":{"85":{"tf":1.0}}},"7":{"df":1,"docs":{"84":{"tf":1.0}}},"8":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"0":{"df":1,"docs":{"78":{"tf":1.0}}},"1":{"df":1,"docs":{"77":{"tf":1.0}}},"2":{"df":1,"docs":{"74":{"tf":1.0}}},"3":{"df":1,"docs":{"72":{"tf":1.0}}},"4":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{".":{"0":{"df":1,"docs":{"66":{"tf":1.0}}},"1":{"df":1,"docs":{"65":{"tf":1.0}}},"2":{"df":1,"docs":{"64":{"tf":1.0}}},"3":{"df":1,"docs":{"63":{"tf":1.0}}},"4":{"df":1,"docs":{"62":{"tf":1.0}}},"5":{"df":1,"docs":{"61":{"tf":1.0}}},"6":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"37":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"1":{"6":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"57":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"57":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"58":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"x":{"df":5,"docs":{"59":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"o":{"a":{"d":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"1":{"0":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}},"v":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"z":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":4,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});