/* WindowManager.c generated by valac 0.56.2, the Vala compiler
 * generated from WindowManager.vala, do not modify */

/*
 * Copyright 2012-2014 Tom Beckmann, Rico Tzschichholz
 * Copyright 2018 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <meta/meta-plugin.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <meta/meta-background-group.h>
#include <meta/window.h>
#include <gee.h>
#include <meta/meta-window-actor.h>
#include <glib.h>
#include <meta/compositor.h>
#include <meta/boxes.h>
#include <meta/common.h>
#include <stdlib.h>
#include <string.h>
#include <meta/display.h>
#include <meta/meta-background-actor.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <meta/compositor-mutter.h>
#include <meta/keybindings.h>
#include <meta/meta-context.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include <meta/prefs.h>
#include <gdk/gdk.h>
#include <meta/util.h>
#include <glib/gi18n-lib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>

#define GREETER_COMPOSITOR_WINDOW_MANAGER_GL_VENDOR ((guint) 0x1F00)
#define GREETER_COMPOSITOR_WINDOW_MANAGER_LOGIND_DBUS_NAME "org.freedesktop.login1"
#define GREETER_COMPOSITOR_WINDOW_MANAGER_LOGIND_DBUS_OBJECT_PATH "/org/freedesktop/login1"
#define CONSTANTS_VERSION "6.1.0"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;
typedef struct _GreeterCompositorWindowManagerPrivate GreeterCompositorWindowManagerPrivate;

#define GREETER_TYPE_SYSTEM_BACKGROUND (greeter_system_background_get_type ())
#define GREETER_SYSTEM_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SYSTEM_BACKGROUND, GreeterSystemBackground))
#define GREETER_SYSTEM_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SYSTEM_BACKGROUND, GreeterSystemBackgroundClass))
#define GREETER_IS_SYSTEM_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SYSTEM_BACKGROUND))
#define GREETER_IS_SYSTEM_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SYSTEM_BACKGROUND))
#define GREETER_SYSTEM_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SYSTEM_BACKGROUND, GreeterSystemBackgroundClass))

typedef struct _GreeterSystemBackground GreeterSystemBackground;
typedef struct _GreeterSystemBackgroundClass GreeterSystemBackgroundClass;
enum  {
	GREETER_COMPOSITOR_WINDOW_MANAGER_0_PROPERTY,
	GREETER_COMPOSITOR_WINDOW_MANAGER_UI_GROUP_PROPERTY,
	GREETER_COMPOSITOR_WINDOW_MANAGER_STAGE_PROPERTY,
	GREETER_COMPOSITOR_WINDOW_MANAGER_WINDOW_GROUP_PROPERTY,
	GREETER_COMPOSITOR_WINDOW_MANAGER_TOP_WINDOW_GROUP_PROPERTY,
	GREETER_COMPOSITOR_WINDOW_MANAGER_BACKGROUND_GROUP_PROPERTY,
	GREETER_COMPOSITOR_WINDOW_MANAGER_SYSTEM_BACKGROUND_PROPERTY,
	GREETER_COMPOSITOR_WINDOW_MANAGER_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

#define GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR (greeter_compositor_dbus_accelerator_get_type ())
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAccelerator))
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAcceleratorClass))
#define GREETER_COMPOSITOR_IS_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR))
#define GREETER_COMPOSITOR_IS_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR))
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAcceleratorClass))

typedef struct _GreeterCompositorDBusAccelerator GreeterCompositorDBusAccelerator;
typedef struct _GreeterCompositorDBusAcceleratorClass GreeterCompositorDBusAcceleratorClass;
typedef struct _Block7Data Block7Data;
typedef const gchar* (*GreeterCompositorWindowManagerGlQueryFunc) (guint id, gpointer user_data);

struct _GreeterCompositorWindowManager {
	MetaPlugin parent_instance;
	GreeterCompositorWindowManagerPrivate * priv;
};

struct _GreeterCompositorWindowManagerClass {
	MetaPluginClass parent_class;
};

struct _GreeterCompositorWindowManagerPrivate {
	ClutterActor* _ui_group;
	ClutterStage* _stage;
	ClutterActor* _window_group;
	ClutterActor* _top_window_group;
	MetaBackgroundGroup* _background_group;
	GreeterSystemBackground* _system_background;
	MetaPluginInfo info;
	MetaWindow* moving;
	GeeHashSet* minimizing;
	GeeHashSet* maximizing;
	GeeHashSet* unmaximizing;
	GeeHashSet* mapping;
	GeeHashSet* destroying;
	GeeHashSet* unminimizing;
	GHashTable* ws_assoc;
	GList* windows;
	GList* parents;
	GList* tmp_actors;
};

struct _Block6Data {
	int _ref_count_;
	GreeterCompositorWindowManager* self;
	MetaDisplay* display;
};

struct _Block7Data {
	int _ref_count_;
	GreeterCompositorWindowManager* self;
	MetaWindow* window;
	gulong signal_id;
	MetaWindowActor* actor;
	MetaSizeChange which_change;
};

static gint GreeterCompositorWindowManager_private_offset;
static gpointer greeter_compositor_window_manager_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN GType greeter_system_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSystemBackground, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void greeter_compositor_window_manager_real_start (MetaPlugin* base);
static void greeter_compositor_window_manager_show_stage (GreeterCompositorWindowManager* self);
static void __lambda35_ (GreeterCompositorWindowManager* self);
static void greeter_compositor_window_manager_refresh_background (GreeterCompositorWindowManager* self);
static void ___lambda35__meta_display_gl_video_memory_purged (MetaDisplay* _sender,
                                                       gpointer self);
VALA_EXTERN ClutterStage* greeter_compositor_window_manager_get_stage (GreeterCompositorWindowManager* self);
VALA_EXTERN GreeterSystemBackground* greeter_compositor_window_manager_get_system_background (GreeterCompositorWindowManager* self);
VALA_EXTERN MetaBackgroundActor* greeter_system_background_get_background_actor (GreeterSystemBackground* self);
VALA_EXTERN GreeterSystemBackground* greeter_system_background_new (MetaDisplay* display);
VALA_EXTERN GreeterSystemBackground* greeter_system_background_construct (GType object_type,
                                                              MetaDisplay* display);
static void greeter_compositor_window_manager_set_system_background (GreeterCompositorWindowManager* self,
                                                              GreeterSystemBackground* value);
VALA_EXTERN void greeter_system_background_refresh (GreeterSystemBackground* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN void greeter_compositor_media_feedback_init (void);
VALA_EXTERN void greeter_compositor_dbus_init (GreeterCompositorWindowManager* _wm);
VALA_EXTERN gpointer greeter_compositor_dbus_accelerator_ref (gpointer instance);
VALA_EXTERN void greeter_compositor_dbus_accelerator_unref (gpointer instance);
VALA_EXTERN GParamSpec* greeter_compositor_param_spec_dbus_accelerator (const gchar* name,
                                                            const gchar* nick,
                                                            const gchar* blurb,
                                                            GType object_type,
                                                            GParamFlags flags);
VALA_EXTERN void greeter_compositor_value_set_dbus_accelerator (GValue* value,
                                                    gpointer v_object);
VALA_EXTERN void greeter_compositor_value_take_dbus_accelerator (GValue* value,
                                                     gpointer v_object);
VALA_EXTERN gpointer greeter_compositor_value_get_dbus_accelerator (const GValue* value);
VALA_EXTERN GType greeter_compositor_dbus_accelerator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorDBusAccelerator, greeter_compositor_dbus_accelerator_unref)
VALA_EXTERN guint greeter_compositor_dbus_accelerator_register_object (void* object,
                                                           GDBusConnection* connection,
                                                           const gchar* path,
                                                           GError** error);
VALA_EXTERN GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_init (GreeterCompositorWindowManager* wm);
VALA_EXTERN void greeter_compositor_dbus_background_manager_init (GreeterCompositorWindowManager* _wm);
VALA_EXTERN void greeter_compositor_keyboard_manager_init (MetaDisplay* display);
VALA_EXTERN void greeter_compositor_window_manager_set_stage (GreeterCompositorWindowManager* self,
                                                  ClutterStage* value);
VALA_EXTERN void greeter_compositor_window_manager_set_ui_group (GreeterCompositorWindowManager* self,
                                                     ClutterActor* value);
VALA_EXTERN ClutterActor* greeter_compositor_window_manager_get_ui_group (GreeterCompositorWindowManager* self);
VALA_EXTERN void greeter_compositor_window_manager_set_window_group (GreeterCompositorWindowManager* self,
                                                         ClutterActor* value);
VALA_EXTERN ClutterActor* greeter_compositor_window_manager_get_window_group (GreeterCompositorWindowManager* self);
VALA_EXTERN void greeter_compositor_window_manager_set_top_window_group (GreeterCompositorWindowManager* self,
                                                             ClutterActor* value);
VALA_EXTERN ClutterActor* greeter_compositor_window_manager_get_top_window_group (GreeterCompositorWindowManager* self);
static void __lambda15_ (GreeterCompositorWindowManager* self);
static void ___lambda15__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda16_ (GreeterCompositorWindowManager* self);
static void ___lambda16__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda17_ (GreeterCompositorWindowManager* self);
static void ___lambda17__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda18_ (GreeterCompositorWindowManager* self);
static void ___lambda18__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda19_ (GreeterCompositorWindowManager* self);
static void ___lambda19__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda20_ (GreeterCompositorWindowManager* self);
static void ___lambda20__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda21_ (GreeterCompositorWindowManager* self);
static void ___lambda21__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda22_ (GreeterCompositorWindowManager* self);
static void ___lambda22__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda23_ (GreeterCompositorWindowManager* self);
static void ___lambda23__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda24_ (GreeterCompositorWindowManager* self);
static void ___lambda24__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda25_ (GreeterCompositorWindowManager* self);
static void ___lambda25__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda26_ (GreeterCompositorWindowManager* self);
static void ___lambda26__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda27_ (GreeterCompositorWindowManager* self);
static void ___lambda27__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda28_ (GreeterCompositorWindowManager* self);
static void ___lambda28__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda29_ (GreeterCompositorWindowManager* self);
static void ___lambda29__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda30_ (GreeterCompositorWindowManager* self);
static void ___lambda30__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda31_ (GreeterCompositorWindowManager* self);
static void ___lambda31__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda32_ (GreeterCompositorWindowManager* self);
static void ___lambda32__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static void __lambda33_ (GreeterCompositorWindowManager* self);
static void ___lambda33__meta_key_handler_func (MetaDisplay* display,
                                         MetaWindow* window,
                                         ClutterKeyEvent* event,
                                         MetaKeyBinding* binding,
                                         gpointer self);
static gboolean __lambda34_ (Block6Data* _data6_);
static gboolean ___lambda34__gsource_func (gpointer self);
VALA_EXTERN guint32* greeter_compositor_window_manager_get_all_xids (GreeterCompositorWindowManager* self,
                                                         gint* result_length1);
VALA_EXTERN void greeter_compositor_window_manager_move_window (GreeterCompositorWindowManager* self,
                                                    MetaWindow* window,
                                                    MetaMotionDirection direction);
VALA_EXTERN guint greeter_compositor_utils_get_n_windows (MetaWorkspace* workspace);
VALA_EXTERN void greeter_compositor_utils_bell (MetaDisplay* display);
VALA_EXTERN void greeter_compositor_window_manager_get_current_cursor_position (GreeterCompositorWindowManager* self,
                                                                    gint* x,
                                                                    gint* y);
static void greeter_compositor_window_manager_real_show_window_menu_for_rect (MetaPlugin* base,
                                                                       MetaWindow* window,
                                                                       MetaWindowMenuType menu,
                                                                       MetaRectangle* rect);
static void greeter_compositor_window_manager_handle_fullscreen_window (GreeterCompositorWindowManager* self,
                                                                 MetaWindow* window,
                                                                 MetaSizeChange which_change);
static void greeter_compositor_window_manager_real_size_change (MetaPlugin* base,
                                                         MetaWindowActor* actor,
                                                         MetaSizeChange which_change,
                                                         MetaRectangle* old_frame_rect,
                                                         MetaRectangle* old_buffer_rect);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda39_ (Block7Data* _data7_);
static void ___lambda39__meta_window_size_changed (MetaWindow* _sender,
                                            gpointer self);
static void greeter_compositor_window_manager_real_minimize (MetaPlugin* base,
                                                      MetaWindowActor* actor);
static void greeter_compositor_window_manager_real_unminimize (MetaPlugin* base,
                                                        MetaWindowActor* actor);
static void greeter_compositor_window_manager_real_map (MetaPlugin* base,
                                                 MetaWindowActor* actor);
static void greeter_compositor_window_manager_real_destroy (MetaPlugin* base,
                                                     MetaWindowActor* actor);
VALA_EXTERN void greeter_compositor_utils_request_clean_icon_cache (guint32* xids,
                                                        gint xids_length1);
static gboolean greeter_compositor_window_manager_end_animation (GreeterCompositorWindowManager* self,
                                                          GeeHashSet** list,
                                                          MetaWindowActor* actor);
static void greeter_compositor_window_manager_real_kill_window_effects (MetaPlugin* base,
                                                                 MetaWindowActor* actor);
static void greeter_compositor_window_manager_real_switch_workspace (MetaPlugin* base,
                                                              gint from,
                                                              gint to,
                                                              MetaMotionDirection direction);
static void greeter_compositor_window_manager_end_switch_workspace (GreeterCompositorWindowManager* self);
static void greeter_compositor_window_manager_clutter_actor_reparent (ClutterActor* actor,
                                                               ClutterActor* new_parent);
static void greeter_compositor_window_manager_real_kill_switch_workspace (MetaPlugin* base);
static void greeter_compositor_window_manager_real_confirm_display_change (MetaPlugin* base);
static void __lambda40_ (GreeterCompositorWindowManager* self,
                  GPid pid,
                  gint status);
static void ___lambda40__gchild_watch_func (GPid pid,
                                     gint wait_status,
                                     gpointer self);
static MetaPluginInfo* greeter_compositor_window_manager_real_plugin_info (MetaPlugin* base);
VALA_EXTERN GreeterCompositorWindowManager* greeter_compositor_window_manager_new (void);
VALA_EXTERN GreeterCompositorWindowManager* greeter_compositor_window_manager_construct (GType object_type);
VALA_EXTERN MetaBackgroundGroup* greeter_compositor_window_manager_get_background_group (GreeterCompositorWindowManager* self);
VALA_EXTERN void greeter_compositor_window_manager_set_background_group (GreeterCompositorWindowManager* self,
                                                             MetaBackgroundGroup* value);
static GObject * greeter_compositor_window_manager_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void greeter_compositor_window_manager_finalize (GObject * obj);
static GType greeter_compositor_window_manager_get_type_once (void);
static void _vala_greeter_compositor_window_manager_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_greeter_compositor_window_manager_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
Window clutter_x11_get_stage_window (ClutterActor* stage);

static inline gpointer
greeter_compositor_window_manager_get_instance_private (GreeterCompositorWindowManager* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorWindowManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda35_ (GreeterCompositorWindowManager* self)
{
	greeter_compositor_window_manager_refresh_background (self);
}

static void
___lambda35__meta_display_gl_video_memory_purged (MetaDisplay* _sender,
                                                  gpointer self)
{
	__lambda35_ ((GreeterCompositorWindowManager*) self);
}

static void
greeter_compositor_window_manager_real_start (MetaPlugin* base)
{
	GreeterCompositorWindowManager * self;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	self = (GreeterCompositorWindowManager*) base;
	greeter_compositor_window_manager_show_stage (self);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	display = _tmp0_;
	g_signal_connect_object (display, "gl-video-memory-purged", (GCallback) ___lambda35__meta_display_gl_video_memory_purged, self, 0);
}

static void
greeter_compositor_window_manager_refresh_background (GreeterCompositorWindowManager* self)
{
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	ClutterStage* _tmp1_;
	GreeterSystemBackground* _tmp2_;
	MetaBackgroundActor* _tmp3_;
	MetaBackgroundActor* _tmp4_;
	GreeterSystemBackground* _tmp5_;
	GreeterSystemBackground* _tmp6_;
	GreeterSystemBackground* _tmp7_;
	MetaBackgroundActor* _tmp8_;
	MetaBackgroundActor* _tmp9_;
	ClutterStage* _tmp10_;
	ClutterBindConstraint* _tmp11_;
	ClutterBindConstraint* _tmp12_;
	ClutterStage* _tmp13_;
	GreeterSystemBackground* _tmp14_;
	MetaBackgroundActor* _tmp15_;
	MetaBackgroundActor* _tmp16_;
	GreeterSystemBackground* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	display = _tmp0_;
	_tmp1_ = self->priv->_stage;
	_tmp2_ = self->priv->_system_background;
	_tmp3_ = greeter_system_background_get_background_actor (_tmp2_);
	_tmp4_ = _tmp3_;
	clutter_actor_remove_child ((ClutterActor*) _tmp1_, (ClutterActor*) _tmp4_);
	_tmp5_ = greeter_system_background_new (display);
	_tmp6_ = _tmp5_;
	greeter_compositor_window_manager_set_system_background (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_system_background;
	_tmp8_ = greeter_system_background_get_background_actor (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_stage;
	_tmp11_ = (ClutterBindConstraint*) clutter_bind_constraint_new ((ClutterActor*) _tmp10_, CLUTTER_BIND_ALL, (gfloat) 0);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp9_, (ClutterConstraint*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->_stage;
	_tmp14_ = self->priv->_system_background;
	_tmp15_ = greeter_system_background_get_background_actor (_tmp14_);
	_tmp16_ = _tmp15_;
	clutter_actor_insert_child_below ((ClutterActor*) _tmp13_, (ClutterActor*) _tmp16_, NULL);
	_tmp17_ = self->priv->_system_background;
	greeter_system_background_refresh (_tmp17_);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GreeterCompositorWindowManager* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda15_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda15__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda15_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda16_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda16__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda16_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda17_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda17__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda17_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda18_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda18__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda18_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda19_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda19__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda19_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda20_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda20__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda20_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda21_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda21__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda21_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda22_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda22__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda22_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda23_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda23__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda23_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda24_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda24__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda24_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda25_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda25__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda25_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda26_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda26__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda26_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda27_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda27__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda27_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda28_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda28__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda28_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda29_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda29__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda29_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda30_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda30__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda30_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda31_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda31__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda31_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda32_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda32__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda32_ ((GreeterCompositorWindowManager*) self);
}

static void
__lambda33_ (GreeterCompositorWindowManager* self)
{
}

static void
___lambda33__meta_key_handler_func (MetaDisplay* display,
                                    MetaWindow* window,
                                    ClutterKeyEvent* event,
                                    MetaKeyBinding* binding,
                                    gpointer self)
{
	__lambda33_ ((GreeterCompositorWindowManager*) self);
}

static gboolean
__lambda34_ (Block6Data* _data6_)
{
	GreeterCompositorWindowManager* self;
	MetaContext* _tmp0_;
	gboolean result;
	self = _data6_->self;
	_tmp0_ = meta_display_get_context (_data6_->display);
	meta_context_notify_ready (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda34__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda34_ (self);
	return result;
}

static void
greeter_compositor_window_manager_show_stage (GreeterCompositorWindowManager* self)
{
	Block6Data* _data6_;
	MetaDisplay* _tmp0_;
	ClutterActor* _tmp1_;
	GreeterSystemBackground* _tmp2_;
	GreeterSystemBackground* _tmp3_;
	GreeterSystemBackground* _tmp4_;
	MetaBackgroundActor* _tmp5_;
	MetaBackgroundActor* _tmp6_;
	ClutterStage* _tmp7_;
	ClutterBindConstraint* _tmp8_;
	ClutterBindConstraint* _tmp9_;
	ClutterStage* _tmp10_;
	GreeterSystemBackground* _tmp11_;
	MetaBackgroundActor* _tmp12_;
	MetaBackgroundActor* _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	ClutterActor* _tmp16_;
	ClutterStage* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterActor* _tmp19_;
	ClutterStage* _tmp20_;
	ClutterActor* _tmp21_;
	ClutterActor* _tmp22_;
	ClutterActor* _tmp23_;
	ClutterActor* _tmp24_;
	ClutterStage* _tmp25_;
	ClutterActor* _tmp26_;
	ClutterActor* _tmp27_;
	ClutterActor* _tmp28_;
	ClutterStage* _tmp29_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	_data6_->display = _tmp0_;
	greeter_compositor_media_feedback_init ();
	greeter_compositor_dbus_init (self);
	greeter_compositor_dbus_accelerator_init (self);
	greeter_compositor_dbus_background_manager_init (self);
	greeter_compositor_keyboard_manager_init (_data6_->display);
	_tmp1_ = meta_get_stage_for_display (_data6_->display);
	greeter_compositor_window_manager_set_stage (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, clutter_stage_get_type ()) ? ((ClutterStage*) _tmp1_) : NULL);
	_tmp2_ = greeter_system_background_new (_data6_->display);
	_tmp3_ = _tmp2_;
	greeter_compositor_window_manager_set_system_background (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_system_background;
	_tmp5_ = greeter_system_background_get_background_actor (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_stage;
	_tmp8_ = (ClutterBindConstraint*) clutter_bind_constraint_new ((ClutterActor*) _tmp7_, CLUTTER_BIND_ALL, (gfloat) 0);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp6_, (ClutterConstraint*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->_stage;
	_tmp11_ = self->priv->_system_background;
	_tmp12_ = greeter_system_background_get_background_actor (_tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_insert_child_below ((ClutterActor*) _tmp10_, (ClutterActor*) _tmp13_, NULL);
	_tmp14_ = clutter_actor_new ();
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	greeter_compositor_window_manager_set_ui_group (self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->_ui_group;
	clutter_actor_set_reactive (_tmp16_, TRUE);
	_tmp17_ = self->priv->_stage;
	_tmp18_ = self->priv->_ui_group;
	clutter_actor_add_child ((ClutterActor*) _tmp17_, _tmp18_);
	_tmp19_ = meta_get_window_group_for_display (_data6_->display);
	greeter_compositor_window_manager_set_window_group (self, _tmp19_);
	_tmp20_ = self->priv->_stage;
	_tmp21_ = self->priv->_window_group;
	clutter_actor_remove_child ((ClutterActor*) _tmp20_, _tmp21_);
	_tmp22_ = self->priv->_ui_group;
	_tmp23_ = self->priv->_window_group;
	clutter_actor_add_child (_tmp22_, _tmp23_);
	_tmp24_ = meta_get_top_window_group_for_display (_data6_->display);
	greeter_compositor_window_manager_set_top_window_group (self, _tmp24_);
	_tmp25_ = self->priv->_stage;
	_tmp26_ = self->priv->_top_window_group;
	clutter_actor_remove_child ((ClutterActor*) _tmp25_, _tmp26_);
	_tmp27_ = self->priv->_ui_group;
	_tmp28_ = self->priv->_top_window_group;
	clutter_actor_add_child (_tmp27_, _tmp28_);
	meta_keybindings_set_custom_handler ("switch-to-workspace-first", ___lambda15__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-to-workspace-last", ___lambda16__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("move-to-workspace-first", ___lambda17__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("move-to-workspace-last", ___lambda18__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("cycle-workspaces-next", ___lambda19__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("cycle-workspaces-previous", ___lambda20__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("panel-main-menu", ___lambda21__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("toggle-recording", ___lambda22__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-to-workspace-up", ___lambda23__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-to-workspace-down", ___lambda24__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-to-workspace-left", ___lambda25__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-to-workspace-right", ___lambda26__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("move-to-workspace-up", ___lambda27__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("move-to-workspace-down", ___lambda28__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("move-to-workspace-left", ___lambda29__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("move-to-workspace-right", ___lambda30__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-group", ___lambda31__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-group-backward", ___lambda32__meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("show-desktop", ___lambda33__meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp29_ = self->priv->_stage;
	clutter_actor_show ((ClutterActor*) _tmp29_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda34__gsource_func, block6_data_ref (_data6_), block6_data_unref);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

guint32*
greeter_compositor_window_manager_get_all_xids (GreeterCompositorWindowManager* self,
                                                gint* result_length1)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	GeeArrayList* _tmp12_;
	gint _tmp13_ = 0;
	gpointer* _tmp14_;
	guint32* _tmp15_;
	gint _tmp15__length1;
	guint32* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) self);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
	manager = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp6_;
				MetaWorkspaceManager* _tmp7_;
				MetaWorkspace* _tmp8_;
				GList* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp6_))) {
					break;
				}
				_tmp7_ = manager;
				_tmp8_ = meta_workspace_manager_get_workspace_by_index (_tmp7_, i);
				_tmp9_ = meta_workspace_list_windows (_tmp8_);
				{
					GList* window_collection = NULL;
					GList* window_it = NULL;
					window_collection = _tmp9_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						MetaWindow* window = NULL;
						window = (MetaWindow*) window_it->data;
						{
							GeeArrayList* _tmp10_;
							MetaWindow* _tmp11_;
							_tmp10_ = list;
							_tmp11_ = window;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (gpointer) ((guintptr) meta_window_get_xwindow (_tmp11_)));
						}
					}
					(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
				}
			}
		}
	}
	_tmp12_ = list;
	_tmp14_ = gee_collection_to_array ((GeeCollection*) _tmp12_, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp13_;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_object_unref0 (list);
	return result;
}

/**
         * {@inheritDoc}
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
greeter_compositor_window_manager_move_window (GreeterCompositorWindowManager* self,
                                               MetaWindow* window,
                                               MetaMotionDirection direction)
{
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* active = NULL;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	MetaWorkspace* next = NULL;
	MetaWorkspace* _tmp6_;
	MetaWorkspace* _tmp7_;
	MetaWorkspace* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	MetaWindow* _tmp17_;
	MetaWorkspace* _tmp19_;
	MetaDisplay* _tmp20_;
	g_return_if_fail (self != NULL);
	if (window == NULL) {
		return;
	}
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	display = _tmp0_;
	_tmp1_ = display;
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = manager;
	_tmp4_ = meta_workspace_manager_get_active_workspace (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	active = _tmp5_;
	_tmp6_ = active;
	_tmp7_ = meta_workspace_get_neighbor (_tmp6_, direction);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	next = _tmp8_;
	if (meta_prefs_get_dynamic_workspaces ()) {
		MetaWorkspace* _tmp11_;
		_tmp11_ = active;
		_tmp10_ = greeter_compositor_utils_get_n_windows (_tmp11_) == ((guint) 1);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		MetaWorkspace* _tmp12_;
		MetaWorkspaceManager* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp12_ = next;
		_tmp13_ = manager;
		_tmp14_ = meta_workspace_manager_get_n_workspaces (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = meta_workspace_index (_tmp12_) == (_tmp15_ - 1);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		MetaDisplay* _tmp16_;
		_tmp16_ = display;
		greeter_compositor_utils_bell (_tmp16_);
		_g_object_unref0 (next);
		_g_object_unref0 (active);
		return;
	}
	_tmp17_ = _g_object_ref0 (window);
	_g_object_unref0 (self->priv->moving);
	self->priv->moving = _tmp17_;
	if (!meta_window_is_on_all_workspaces (window)) {
		MetaWorkspace* _tmp18_;
		_tmp18_ = next;
		meta_window_change_workspace (window, _tmp18_);
	}
	_tmp19_ = next;
	_tmp20_ = display;
	meta_workspace_activate_with_focus (_tmp19_, window, meta_display_get_current_time (_tmp20_));
	_g_object_unref0 (next);
	_g_object_unref0 (active);
}

void
greeter_compositor_window_manager_get_current_cursor_position (GreeterCompositorWindowManager* self,
                                                               gint* x,
                                                               gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkDevice* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = gdk_seat_get_pointer (_tmp1_);
	gdk_device_get_position (_tmp2_, NULL, &_tmp3_, &_tmp4_);
	_vala_x = _tmp3_;
	_vala_y = _tmp4_;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

static void
greeter_compositor_window_manager_real_show_window_menu_for_rect (MetaPlugin* base,
                                                                  MetaWindow* window,
                                                                  MetaWindowMenuType menu,
                                                                  MetaRectangle* rect)
{
	GreeterCompositorWindowManager * self;
	MetaRectangle _tmp0_;
	MetaRectangle _tmp1_;
	self = (GreeterCompositorWindowManager*) base;
	g_return_if_fail (window != NULL);
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	G_TYPE_INSTANCE_GET_CLASS ((MetaPlugin*) self, meta_plugin_get_type (), MetaPluginClass)->show_window_menu ((MetaPlugin*) self, window, menu, _tmp0_.x, _tmp1_.y);
}

static void
greeter_compositor_window_manager_handle_fullscreen_window (GreeterCompositorWindowManager* self,
                                                            MetaWindow* window,
                                                            MetaSizeChange which_change)
{
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	guint32 time = 0U;
	MetaDisplay* _tmp1_;
	MetaWorkspace* win_ws = NULL;
	MetaWorkspace* _tmp2_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (!meta_window_is_on_primary_monitor (window)) {
		return;
	}
	if (!meta_prefs_get_dynamic_workspaces ()) {
		return;
	}
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	display = _tmp0_;
	_tmp1_ = display;
	time = meta_display_get_current_time (_tmp1_);
	_tmp2_ = meta_window_get_workspace (window);
	win_ws = _tmp2_;
	_tmp3_ = display;
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	manager = _tmp4_;
	if (which_change == META_SIZE_CHANGE_FULLSCREEN) {
		MetaWorkspace* _tmp5_;
		gint old_ws_index = 0;
		MetaWorkspace* _tmp6_;
		gint new_ws_index = 0;
		MetaWorkspace* new_ws_obj = NULL;
		MetaWorkspaceManager* _tmp7_;
		MetaWorkspace* _tmp8_;
		MetaWorkspace* _tmp9_;
		MetaWorkspace* _tmp10_;
		MetaWorkspace* _tmp11_;
		GHashTable* _tmp12_;
		MetaWindow* _tmp13_;
		_tmp5_ = win_ws;
		if (greeter_compositor_utils_get_n_windows (_tmp5_) <= ((guint) 1)) {
			return;
		}
		_tmp6_ = win_ws;
		old_ws_index = meta_workspace_index (_tmp6_);
		new_ws_index = old_ws_index + 1;
		_tmp7_ = manager;
		_tmp8_ = meta_workspace_manager_get_workspace_by_index (_tmp7_, new_ws_index);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		new_ws_obj = _tmp9_;
		_tmp10_ = new_ws_obj;
		meta_window_change_workspace (window, _tmp10_);
		_tmp11_ = new_ws_obj;
		meta_workspace_activate_with_focus (_tmp11_, window, time);
		_tmp12_ = self->priv->ws_assoc;
		_tmp13_ = _g_object_ref0 (window);
		g_hash_table_insert (_tmp12_, _tmp13_, (gpointer) ((gintptr) old_ws_index));
		_g_object_unref0 (new_ws_obj);
	} else {
		GHashTable* _tmp14_;
		_tmp14_ = self->priv->ws_assoc;
		if (g_hash_table_contains (_tmp14_, window)) {
			gint old_ws_index = 0;
			GHashTable* _tmp15_;
			gconstpointer _tmp16_;
			gint new_ws_index = 0;
			MetaWorkspace* _tmp17_;
			gboolean _tmp18_ = FALSE;
			GHashTable* _tmp25_;
			_tmp15_ = self->priv->ws_assoc;
			_tmp16_ = g_hash_table_lookup (_tmp15_, window);
			old_ws_index = (gint) ((gintptr) _tmp16_);
			_tmp17_ = win_ws;
			new_ws_index = meta_workspace_index (_tmp17_);
			if (new_ws_index != old_ws_index) {
				MetaWorkspaceManager* _tmp19_;
				_tmp19_ = manager;
				_tmp18_ = old_ws_index < meta_workspace_manager_get_n_workspaces (_tmp19_);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				MetaWorkspace* old_ws_obj = NULL;
				MetaWorkspaceManager* _tmp20_;
				MetaWorkspace* _tmp21_;
				MetaWorkspace* _tmp22_;
				MetaWorkspace* _tmp23_;
				MetaWorkspace* _tmp24_;
				_tmp20_ = manager;
				_tmp21_ = meta_workspace_manager_get_workspace_by_index (_tmp20_, old_ws_index);
				_tmp22_ = _g_object_ref0 (_tmp21_);
				old_ws_obj = _tmp22_;
				_tmp23_ = old_ws_obj;
				meta_window_change_workspace (window, _tmp23_);
				_tmp24_ = old_ws_obj;
				meta_workspace_activate_with_focus (_tmp24_, window, time);
				_g_object_unref0 (old_ws_obj);
			}
			_tmp25_ = self->priv->ws_assoc;
			g_hash_table_remove (_tmp25_, window);
		}
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GreeterCompositorWindowManager* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->actor);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda39_ (Block7Data* _data7_)
{
	GreeterCompositorWindowManager* self;
	MetaWindow* _tmp0_;
	self = _data7_->self;
	_tmp0_ = _data7_->window;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data7_->signal_id);
	switch (_data7_->which_change) {
		case META_SIZE_CHANGE_MAXIMIZE:
		{
			break;
		}
		case META_SIZE_CHANGE_FULLSCREEN:
		case META_SIZE_CHANGE_UNFULLSCREEN:
		{
			MetaWindow* _tmp1_;
			_tmp1_ = meta_window_actor_get_meta_window (_data7_->actor);
			greeter_compositor_window_manager_handle_fullscreen_window (self, _tmp1_, _data7_->which_change);
			break;
		}
		default:
		break;
	}
	meta_plugin_size_change_completed ((MetaPlugin*) self, _data7_->actor);
}

static void
___lambda39__meta_window_size_changed (MetaWindow* _sender,
                                       gpointer self)
{
	__lambda39_ (self);
}

static void
greeter_compositor_window_manager_real_size_change (MetaPlugin* base,
                                                    MetaWindowActor* actor,
                                                    MetaSizeChange which_change,
                                                    MetaRectangle* old_frame_rect,
                                                    MetaRectangle* old_buffer_rect)
{
	GreeterCompositorWindowManager * self;
	Block7Data* _data7_;
	MetaWindowActor* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	gulong _tmp5_;
	self = (GreeterCompositorWindowManager*) base;
	g_return_if_fail (actor != NULL);
	g_return_if_fail (old_frame_rect != NULL);
	g_return_if_fail (old_buffer_rect != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (actor);
	_g_object_unref0 (_data7_->actor);
	_data7_->actor = _tmp0_;
	_data7_->which_change = which_change;
	_tmp1_ = meta_window_actor_get_meta_window (_data7_->actor);
	_data7_->window = _tmp1_;
	_tmp2_ = _data7_->window;
	_tmp3_ = meta_window_get_tile_match (_tmp2_);
	if (_tmp3_ != NULL) {
		meta_plugin_size_change_completed ((MetaPlugin*) self, _data7_->actor);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_data7_->signal_id = (gulong) 0U;
	_tmp4_ = _data7_->window;
	_tmp5_ = g_signal_connect_data (_tmp4_, "size-changed", (GCallback) ___lambda39__meta_window_size_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_data7_->signal_id = _tmp5_;
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
greeter_compositor_window_manager_real_minimize (MetaPlugin* base,
                                                 MetaWindowActor* actor)
{
	GreeterCompositorWindowManager * self;
	self = (GreeterCompositorWindowManager*) base;
	g_return_if_fail (actor != NULL);
}

static void
greeter_compositor_window_manager_real_unminimize (MetaPlugin* base,
                                                   MetaWindowActor* actor)
{
	GreeterCompositorWindowManager * self;
	self = (GreeterCompositorWindowManager*) base;
	g_return_if_fail (actor != NULL);
	clutter_actor_show ((ClutterActor*) actor);
	meta_plugin_unminimize_completed ((MetaPlugin*) self, actor);
	return;
}

static void
greeter_compositor_window_manager_real_map (MetaPlugin* base,
                                            MetaWindowActor* actor)
{
	GreeterCompositorWindowManager * self;
	self = (GreeterCompositorWindowManager*) base;
	g_return_if_fail (actor != NULL);
	clutter_actor_show ((ClutterActor*) actor);
	meta_plugin_map_completed ((MetaPlugin*) self, actor);
	return;
}

static void
greeter_compositor_window_manager_real_destroy (MetaPlugin* base,
                                                MetaWindowActor* actor)
{
	GreeterCompositorWindowManager * self;
	gint _tmp0_ = 0;
	guint32* _tmp1_;
	guint32* _tmp2_;
	gint _tmp2__length1;
	self = (GreeterCompositorWindowManager*) base;
	g_return_if_fail (actor != NULL);
	meta_plugin_destroy_completed ((MetaPlugin*) self, actor);
	_tmp1_ = greeter_compositor_window_manager_get_all_xids (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	greeter_compositor_utils_request_clean_icon_cache (_tmp2_, (gint) _tmp0_);
	_tmp2_ = (g_free (_tmp2_), NULL);
	return;
}

static gboolean
greeter_compositor_window_manager_end_animation (GreeterCompositorWindowManager* self,
                                                 GeeHashSet** list,
                                                 MetaWindowActor* actor)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (*list != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) (*list), actor)) {
		result = FALSE;
		return result;
	}
	if (meta_window_actor_is_destroyed (actor)) {
		gee_abstract_collection_remove ((GeeAbstractCollection*) (*list), actor);
		result = FALSE;
		return result;
	}
	clutter_actor_remove_all_transitions ((ClutterActor*) actor);
	clutter_actor_set_opacity ((ClutterActor*) actor, 255U);
	clutter_actor_set_scale ((ClutterActor*) actor, (gdouble) 1.0f, (gdouble) 1.0f);
	g_object_set ((ClutterActor*) actor, "rotation-angle-x", (gdouble) 0.0f, NULL);
	clutter_actor_set_pivot_point ((ClutterActor*) actor, 0.0f, 0.0f);
	gee_abstract_collection_remove ((GeeAbstractCollection*) (*list), actor);
	result = TRUE;
	return result;
}

static void
greeter_compositor_window_manager_real_kill_window_effects (MetaPlugin* base,
                                                            MetaWindowActor* actor)
{
	GreeterCompositorWindowManager * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (GreeterCompositorWindowManager*) base;
	g_return_if_fail (actor != NULL);
	_tmp0_ = greeter_compositor_window_manager_end_animation (self, &self->priv->mapping, actor);
	if (_tmp0_) {
		meta_plugin_map_completed ((MetaPlugin*) self, actor);
	}
	_tmp1_ = greeter_compositor_window_manager_end_animation (self, &self->priv->unminimizing, actor);
	if (_tmp1_) {
		meta_plugin_unminimize_completed ((MetaPlugin*) self, actor);
	}
	_tmp2_ = greeter_compositor_window_manager_end_animation (self, &self->priv->minimizing, actor);
	if (_tmp2_) {
		meta_plugin_minimize_completed ((MetaPlugin*) self, actor);
	}
	_tmp3_ = greeter_compositor_window_manager_end_animation (self, &self->priv->destroying, actor);
	if (_tmp3_) {
		meta_plugin_destroy_completed ((MetaPlugin*) self, actor);
	}
	greeter_compositor_window_manager_end_animation (self, &self->priv->unmaximizing, actor);
	greeter_compositor_window_manager_end_animation (self, &self->priv->maximizing, actor);
}

static void
greeter_compositor_window_manager_real_switch_workspace (MetaPlugin* base,
                                                         gint from,
                                                         gint to,
                                                         MetaMotionDirection direction)
{
	GreeterCompositorWindowManager * self;
	self = (GreeterCompositorWindowManager*) base;
	meta_plugin_switch_workspace_completed ((MetaPlugin*) self);
	return;
}

static void
greeter_compositor_window_manager_end_switch_workspace (GreeterCompositorWindowManager* self)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp3_;
	MetaWorkspace* active_workspace = NULL;
	MetaDisplay* _tmp4_;
	MetaWorkspaceManager* _tmp5_;
	MetaWorkspace* _tmp6_;
	MetaWorkspace* _tmp7_;
	GList* _tmp47_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->windows;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GList* _tmp2_;
		_tmp2_ = self->priv->parents;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) self);
	display = _tmp3_;
	_tmp4_ = display;
	_tmp5_ = meta_display_get_workspace_manager (_tmp4_);
	_tmp6_ = meta_workspace_manager_get_active_workspace (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	active_workspace = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GList* _tmp10_;
				ClutterActor* actor = NULL;
				GList* _tmp11_;
				gconstpointer _tmp12_;
				ClutterActor* _tmp13_;
				ClutterActor* _tmp14_;
				ClutterActor* _tmp15_;
				MetaWindowActor* window = NULL;
				ClutterActor* _tmp19_;
				MetaWindowActor* _tmp20_;
				gboolean _tmp21_ = FALSE;
				MetaWindowActor* _tmp22_;
				gboolean _tmp27_ = FALSE;
				MetaWindowActor* _tmp28_;
				MetaWindowActor* _tmp30_;
				MetaWindow* meta_window = NULL;
				MetaWindowActor* _tmp31_;
				MetaWindow* _tmp32_;
				MetaWindow* _tmp33_;
				gboolean _tmp34_ = FALSE;
				MetaWindow* _tmp35_;
				MetaWorkspace* _tmp36_;
				MetaWorkspace* _tmp37_;
				ClutterActor* _tmp40_;
				guint _tmp41_;
				guint _tmp42_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = self->priv->windows;
				if (!(((guint) i) < g_list_length (_tmp10_))) {
					break;
				}
				_tmp11_ = self->priv->windows;
				_tmp12_ = g_list_nth_data (_tmp11_, (guint) i);
				_tmp13_ = _g_object_ref0 ((ClutterActor*) _tmp12_);
				actor = _tmp13_;
				_tmp14_ = actor;
				clutter_actor_set_translation (_tmp14_, 0.0f, 0.0f, 0.0f);
				_tmp15_ = actor;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, meta_background_group_get_type ())) {
					ClutterActor* _tmp16_;
					ClutterActor* _tmp17_;
					ClutterActor* _tmp18_;
					_tmp16_ = actor;
					clutter_actor_set_x (_tmp16_, (gfloat) 0);
					_tmp17_ = actor;
					_tmp18_ = self->priv->_window_group;
					greeter_compositor_window_manager_clutter_actor_reparent (_tmp17_, _tmp18_);
					_g_object_unref0 (actor);
					continue;
				}
				_tmp19_ = actor;
				_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, meta_window_actor_get_type ()) ? ((MetaWindowActor*) _tmp19_) : NULL);
				window = _tmp20_;
				_tmp22_ = window;
				if (_tmp22_ == NULL) {
					_tmp21_ = TRUE;
				} else {
					MetaWindowActor* _tmp23_;
					_tmp23_ = window;
					_tmp21_ = !meta_window_actor_is_destroyed (_tmp23_);
				}
				if (_tmp21_) {
					ClutterActor* _tmp24_;
					GList* _tmp25_;
					gconstpointer _tmp26_;
					_tmp24_ = actor;
					_tmp25_ = self->priv->parents;
					_tmp26_ = g_list_nth_data (_tmp25_, (guint) i);
					greeter_compositor_window_manager_clutter_actor_reparent (_tmp24_, (ClutterActor*) _tmp26_);
				}
				_tmp28_ = window;
				if (_tmp28_ == NULL) {
					_tmp27_ = TRUE;
				} else {
					MetaWindowActor* _tmp29_;
					_tmp29_ = window;
					_tmp27_ = meta_window_actor_is_destroyed (_tmp29_);
				}
				if (_tmp27_) {
					_g_object_unref0 (window);
					_g_object_unref0 (actor);
					continue;
				}
				_tmp30_ = window;
				G_TYPE_INSTANCE_GET_CLASS ((MetaPlugin*) self, meta_plugin_get_type (), MetaPluginClass)->kill_window_effects ((MetaPlugin*) self, _tmp30_);
				_tmp31_ = window;
				_tmp32_ = meta_window_actor_get_meta_window (_tmp31_);
				_tmp33_ = _g_object_ref0 (_tmp32_);
				meta_window = _tmp33_;
				_tmp35_ = meta_window;
				_tmp36_ = meta_window_get_workspace (_tmp35_);
				_tmp37_ = active_workspace;
				if (_tmp36_ != _tmp37_) {
					MetaWindow* _tmp38_;
					_tmp38_ = meta_window;
					_tmp34_ = !meta_window_is_on_all_workspaces (_tmp38_);
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					MetaWindowActor* _tmp39_;
					_tmp39_ = window;
					clutter_actor_hide ((ClutterActor*) _tmp39_);
				}
				_tmp40_ = actor;
				_tmp41_ = clutter_actor_get_opacity (_tmp40_);
				_tmp42_ = _tmp41_;
				if (_tmp42_ < 255U) {
					ClutterActor* _tmp43_;
					ClutterActor* _tmp44_;
					ClutterActor* _tmp45_;
					ClutterActor* _tmp46_;
					_tmp43_ = actor;
					clutter_actor_save_easing_state (_tmp43_);
					_tmp44_ = actor;
					clutter_actor_set_easing_duration (_tmp44_, (guint) 300);
					_tmp45_ = actor;
					clutter_actor_set_opacity (_tmp45_, 255U);
					_tmp46_ = actor;
					clutter_actor_restore_easing_state (_tmp46_);
				}
				_g_object_unref0 (meta_window);
				_g_object_unref0 (window);
				_g_object_unref0 (actor);
			}
		}
	}
	_tmp47_ = self->priv->tmp_actors;
	if (_tmp47_ != NULL) {
		GList* _tmp48_;
		_tmp48_ = self->priv->tmp_actors;
		{
			GList* actor_collection = NULL;
			GList* actor_it = NULL;
			actor_collection = _tmp48_;
			for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
				ClutterActor* _tmp49_;
				ClutterActor* actor = NULL;
				_tmp49_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
				actor = _tmp49_;
				{
					ClutterActor* _tmp50_;
					_tmp50_ = actor;
					clutter_actor_destroy (_tmp50_);
					_g_object_unref0 (actor);
				}
			}
		}
		(self->priv->tmp_actors == NULL) ? NULL : (self->priv->tmp_actors = (_g_list_free__g_object_unref0_ (self->priv->tmp_actors), NULL));
		self->priv->tmp_actors = NULL;
	}
	(self->priv->windows == NULL) ? NULL : (self->priv->windows = (_g_list_free__g_object_unref0_ (self->priv->windows), NULL));
	self->priv->windows = NULL;
	(self->priv->parents == NULL) ? NULL : (self->priv->parents = (_g_list_free__g_object_unref0_ (self->priv->parents), NULL));
	self->priv->parents = NULL;
	_g_object_unref0 (self->priv->moving);
	self->priv->moving = NULL;
	meta_plugin_switch_workspace_completed ((MetaPlugin*) self);
	_g_object_unref0 (active_workspace);
}

static void
greeter_compositor_window_manager_real_kill_switch_workspace (MetaPlugin* base)
{
	GreeterCompositorWindowManager * self;
	self = (GreeterCompositorWindowManager*) base;
	greeter_compositor_window_manager_end_switch_workspace (self);
}

static void
__lambda40_ (GreeterCompositorWindowManager* self,
             GPid pid,
             gint status)
{
	gboolean ok = FALSE;
	GError* _inner_error0_ = NULL;
	ok = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_spawn_check_exit_status (status, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		ok = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	meta_plugin_complete_display_change ((MetaPlugin*) self, ok);
}

static void
___lambda40__gchild_watch_func (GPid pid,
                                gint wait_status,
                                gpointer self)
{
	__lambda40_ ((GreeterCompositorWindowManager*) self, pid, wait_status);
}

static void
greeter_compositor_window_manager_real_confirm_display_change (MetaPlugin* base)
{
	GreeterCompositorWindowManager * self;
	GPid pid = 0;
	self = (GreeterCompositorWindowManager*) base;
	pid = meta_show_dialog ("--question", _ ("Does the display look OK?"), "30", NULL, _ ("Keep This Configuration"), _ ("Restore Previous Configuration"), "preferences-desktop-display", 0, NULL, NULL);
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, pid, ___lambda40__gchild_watch_func, g_object_ref (self), g_object_unref);
}

static MetaPluginInfo*
greeter_compositor_window_manager_real_plugin_info (MetaPlugin* base)
{
	GreeterCompositorWindowManager * self;
	MetaPluginInfo _tmp0_;
	MetaPluginInfo* result;
	self = (GreeterCompositorWindowManager*) base;
	_tmp0_ = self->priv->info;
	result = &_tmp0_;
	return result;
}

static void
greeter_compositor_window_manager_clutter_actor_reparent (ClutterActor* actor,
                                                          ClutterActor* new_parent)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (actor != NULL);
	g_return_if_fail (new_parent != NULL);
	if (actor == new_parent) {
		return;
	}
	g_object_ref ((GObject*) actor);
	_tmp0_ = clutter_actor_get_parent (actor);
	clutter_actor_remove_child (_tmp0_, actor);
	clutter_actor_add_child (new_parent, actor);
	g_object_unref ((GObject*) actor);
}

GreeterCompositorWindowManager*
greeter_compositor_window_manager_construct (GType object_type)
{
	GreeterCompositorWindowManager * self = NULL;
	self = (GreeterCompositorWindowManager*) g_object_new (object_type, NULL);
	return self;
}

GreeterCompositorWindowManager*
greeter_compositor_window_manager_new (void)
{
	return greeter_compositor_window_manager_construct (GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER);
}

ClutterActor*
greeter_compositor_window_manager_get_ui_group (GreeterCompositorWindowManager* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ui_group;
	result = _tmp0_;
	return result;
}

void
greeter_compositor_window_manager_set_ui_group (GreeterCompositorWindowManager* self,
                                                ClutterActor* value)
{
	ClutterActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_window_manager_get_ui_group (self);
	if (old_value != value) {
		ClutterActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_ui_group);
		self->priv->_ui_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_UI_GROUP_PROPERTY]);
	}
}

ClutterStage*
greeter_compositor_window_manager_get_stage (GreeterCompositorWindowManager* self)
{
	ClutterStage* result;
	ClutterStage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stage;
	result = _tmp0_;
	return result;
}

void
greeter_compositor_window_manager_set_stage (GreeterCompositorWindowManager* self,
                                             ClutterStage* value)
{
	ClutterStage* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_window_manager_get_stage (self);
	if (old_value != value) {
		ClutterStage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_stage);
		self->priv->_stage = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_STAGE_PROPERTY]);
	}
}

ClutterActor*
greeter_compositor_window_manager_get_window_group (GreeterCompositorWindowManager* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_group;
	result = _tmp0_;
	return result;
}

void
greeter_compositor_window_manager_set_window_group (GreeterCompositorWindowManager* self,
                                                    ClutterActor* value)
{
	ClutterActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_window_manager_get_window_group (self);
	if (old_value != value) {
		ClutterActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window_group);
		self->priv->_window_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_WINDOW_GROUP_PROPERTY]);
	}
}

ClutterActor*
greeter_compositor_window_manager_get_top_window_group (GreeterCompositorWindowManager* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_top_window_group;
	result = _tmp0_;
	return result;
}

void
greeter_compositor_window_manager_set_top_window_group (GreeterCompositorWindowManager* self,
                                                        ClutterActor* value)
{
	ClutterActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_window_manager_get_top_window_group (self);
	if (old_value != value) {
		ClutterActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_top_window_group);
		self->priv->_top_window_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_TOP_WINDOW_GROUP_PROPERTY]);
	}
}

MetaBackgroundGroup*
greeter_compositor_window_manager_get_background_group (GreeterCompositorWindowManager* self)
{
	MetaBackgroundGroup* result;
	MetaBackgroundGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background_group;
	result = _tmp0_;
	return result;
}

void
greeter_compositor_window_manager_set_background_group (GreeterCompositorWindowManager* self,
                                                        MetaBackgroundGroup* value)
{
	MetaBackgroundGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_window_manager_get_background_group (self);
	if (old_value != value) {
		MetaBackgroundGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_background_group);
		self->priv->_background_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_BACKGROUND_GROUP_PROPERTY]);
	}
}

GreeterSystemBackground*
greeter_compositor_window_manager_get_system_background (GreeterCompositorWindowManager* self)
{
	GreeterSystemBackground* result;
	GreeterSystemBackground* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_system_background;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_window_manager_set_system_background (GreeterCompositorWindowManager* self,
                                                         GreeterSystemBackground* value)
{
	GreeterSystemBackground* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_window_manager_get_system_background (self);
	if (old_value != value) {
		GreeterSystemBackground* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_system_background);
		self->priv->_system_background = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_SYSTEM_BACKGROUND_PROPERTY]);
	}
}

static GObject *
greeter_compositor_window_manager_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorWindowManager * self;
	MetaPluginInfo _tmp0_ = {0};
	parent_class = G_OBJECT_CLASS (greeter_compositor_window_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager);
	memset (&_tmp0_, 0, sizeof (MetaPluginInfo));
	_tmp0_.name = "GreeterCompositor";
	_tmp0_.version = CONSTANTS_VERSION;
	_tmp0_.author = "elementary LLC.";
	_tmp0_.license = "GPLv3";
	_tmp0_.description = "The greeter compositor";
	self->priv->info = _tmp0_;
	return obj;
}

static void
greeter_compositor_window_manager_class_init (GreeterCompositorWindowManagerClass * klass,
                                              gpointer klass_data)
{
	greeter_compositor_window_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorWindowManager_private_offset);
	((MetaPluginClass *) klass)->start = (void (*) (MetaPlugin*)) greeter_compositor_window_manager_real_start;
	((MetaPluginClass *) klass)->show_window_menu_for_rect = (void (*) (MetaPlugin*, MetaWindow*, MetaWindowMenuType, MetaRectangle*)) greeter_compositor_window_manager_real_show_window_menu_for_rect;
	((MetaPluginClass *) klass)->size_change = (void (*) (MetaPlugin*, MetaWindowActor*, MetaSizeChange, MetaRectangle*, MetaRectangle*)) greeter_compositor_window_manager_real_size_change;
	((MetaPluginClass *) klass)->minimize = (void (*) (MetaPlugin*, MetaWindowActor*)) greeter_compositor_window_manager_real_minimize;
	((MetaPluginClass *) klass)->unminimize = (void (*) (MetaPlugin*, MetaWindowActor*)) greeter_compositor_window_manager_real_unminimize;
	((MetaPluginClass *) klass)->map = (void (*) (MetaPlugin*, MetaWindowActor*)) greeter_compositor_window_manager_real_map;
	((MetaPluginClass *) klass)->destroy = (void (*) (MetaPlugin*, MetaWindowActor*)) greeter_compositor_window_manager_real_destroy;
	((MetaPluginClass *) klass)->kill_window_effects = (void (*) (MetaPlugin*, MetaWindowActor*)) greeter_compositor_window_manager_real_kill_window_effects;
	((MetaPluginClass *) klass)->switch_workspace = (void (*) (MetaPlugin*, gint, gint, MetaMotionDirection)) greeter_compositor_window_manager_real_switch_workspace;
	((MetaPluginClass *) klass)->kill_switch_workspace = (void (*) (MetaPlugin*)) greeter_compositor_window_manager_real_kill_switch_workspace;
	((MetaPluginClass *) klass)->confirm_display_change = (void (*) (MetaPlugin*)) greeter_compositor_window_manager_real_confirm_display_change;
	((MetaPluginClass *) klass)->plugin_info = (MetaPluginInfo* (*) (MetaPlugin*)) greeter_compositor_window_manager_real_plugin_info;
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_window_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_window_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_window_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_window_manager_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_WINDOW_MANAGER_UI_GROUP_PROPERTY, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_UI_GROUP_PROPERTY] = g_param_spec_object ("ui-group", "ui-group", "ui-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_WINDOW_MANAGER_STAGE_PROPERTY, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_STAGE_PROPERTY] = g_param_spec_object ("stage", "stage", "stage", clutter_stage_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_WINDOW_MANAGER_WINDOW_GROUP_PROPERTY, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_WINDOW_GROUP_PROPERTY] = g_param_spec_object ("window-group", "window-group", "window-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_WINDOW_MANAGER_TOP_WINDOW_GROUP_PROPERTY, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_TOP_WINDOW_GROUP_PROPERTY] = g_param_spec_object ("top-window-group", "top-window-group", "top-window-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_WINDOW_MANAGER_BACKGROUND_GROUP_PROPERTY, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_BACKGROUND_GROUP_PROPERTY] = g_param_spec_object ("background-group", "background-group", "background-group", meta_background_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_WINDOW_MANAGER_SYSTEM_BACKGROUND_PROPERTY, greeter_compositor_window_manager_properties[GREETER_COMPOSITOR_WINDOW_MANAGER_SYSTEM_BACKGROUND_PROPERTY] = g_param_spec_object ("system-background", "system-background", "system-background", GREETER_TYPE_SYSTEM_BACKGROUND, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
greeter_compositor_window_manager_instance_init (GreeterCompositorWindowManager * self,
                                                 gpointer klass)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	self->priv = greeter_compositor_window_manager_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (meta_window_actor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->minimizing = _tmp0_;
	_tmp1_ = gee_hash_set_new (meta_window_actor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->maximizing = _tmp1_;
	_tmp2_ = gee_hash_set_new (meta_window_actor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->unmaximizing = _tmp2_;
	_tmp3_ = gee_hash_set_new (meta_window_actor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->mapping = _tmp3_;
	_tmp4_ = gee_hash_set_new (meta_window_actor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->destroying = _tmp4_;
	_tmp5_ = gee_hash_set_new (meta_window_actor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->unminimizing = _tmp5_;
	_tmp6_ = g_direct_hash;
	_tmp7_ = g_direct_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_object_unref0_, NULL);
	self->priv->ws_assoc = _tmp8_;
}

static void
greeter_compositor_window_manager_finalize (GObject * obj)
{
	GreeterCompositorWindowManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager);
	_g_object_unref0 (self->priv->_ui_group);
	_g_object_unref0 (self->priv->_stage);
	_g_object_unref0 (self->priv->_window_group);
	_g_object_unref0 (self->priv->_top_window_group);
	_g_object_unref0 (self->priv->_background_group);
	_g_object_unref0 (self->priv->_system_background);
	_g_object_unref0 (self->priv->moving);
	_g_object_unref0 (self->priv->minimizing);
	_g_object_unref0 (self->priv->maximizing);
	_g_object_unref0 (self->priv->unmaximizing);
	_g_object_unref0 (self->priv->mapping);
	_g_object_unref0 (self->priv->destroying);
	_g_object_unref0 (self->priv->unminimizing);
	_g_hash_table_unref0 (self->priv->ws_assoc);
	(self->priv->windows == NULL) ? NULL : (self->priv->windows = (_g_list_free__g_object_unref0_ (self->priv->windows), NULL));
	(self->priv->parents == NULL) ? NULL : (self->priv->parents = (_g_list_free__g_object_unref0_ (self->priv->parents), NULL));
	(self->priv->tmp_actors == NULL) ? NULL : (self->priv->tmp_actors = (_g_list_free__g_object_unref0_ (self->priv->tmp_actors), NULL));
	G_OBJECT_CLASS (greeter_compositor_window_manager_parent_class)->finalize (obj);
}

static GType
greeter_compositor_window_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorWindowManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_window_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorWindowManager), 0, (GInstanceInitFunc) greeter_compositor_window_manager_instance_init, NULL };
	GType greeter_compositor_window_manager_type_id;
	greeter_compositor_window_manager_type_id = g_type_register_static (meta_plugin_get_type (), "GreeterCompositorWindowManager", &g_define_type_info, 0);
	GreeterCompositorWindowManager_private_offset = g_type_add_instance_private (greeter_compositor_window_manager_type_id, sizeof (GreeterCompositorWindowManagerPrivate));
	return greeter_compositor_window_manager_type_id;
}

GType
greeter_compositor_window_manager_get_type (void)
{
	static volatile gsize greeter_compositor_window_manager_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_window_manager_type_id__once)) {
		GType greeter_compositor_window_manager_type_id;
		greeter_compositor_window_manager_type_id = greeter_compositor_window_manager_get_type_once ();
		g_once_init_leave (&greeter_compositor_window_manager_type_id__once, greeter_compositor_window_manager_type_id);
	}
	return greeter_compositor_window_manager_type_id__once;
}

static void
_vala_greeter_compositor_window_manager_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	GreeterCompositorWindowManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_WINDOW_MANAGER_UI_GROUP_PROPERTY:
		g_value_set_object (value, greeter_compositor_window_manager_get_ui_group (self));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_STAGE_PROPERTY:
		g_value_set_object (value, greeter_compositor_window_manager_get_stage (self));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_WINDOW_GROUP_PROPERTY:
		g_value_set_object (value, greeter_compositor_window_manager_get_window_group (self));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_TOP_WINDOW_GROUP_PROPERTY:
		g_value_set_object (value, greeter_compositor_window_manager_get_top_window_group (self));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_BACKGROUND_GROUP_PROPERTY:
		g_value_set_object (value, greeter_compositor_window_manager_get_background_group (self));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_SYSTEM_BACKGROUND_PROPERTY:
		g_value_set_object (value, greeter_compositor_window_manager_get_system_background (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_window_manager_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	GreeterCompositorWindowManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_WINDOW_MANAGER_UI_GROUP_PROPERTY:
		greeter_compositor_window_manager_set_ui_group (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_STAGE_PROPERTY:
		greeter_compositor_window_manager_set_stage (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_WINDOW_GROUP_PROPERTY:
		greeter_compositor_window_manager_set_window_group (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_TOP_WINDOW_GROUP_PROPERTY:
		greeter_compositor_window_manager_set_top_window_group (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_BACKGROUND_GROUP_PROPERTY:
		greeter_compositor_window_manager_set_background_group (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_WINDOW_MANAGER_SYSTEM_BACKGROUND_PROPERTY:
		greeter_compositor_window_manager_set_system_background (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

