/*
* autoflip.cc
* DIN Is Noise is copyright (c) 2006-2022 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#include "defvelaccel.h"
#include "autoflip.h"


void autoflipt::calc (float& theta, int& dir, defvelaccel& d) {
  total += theta;
  if (total >= angle.rad) {
    dir = -dir;
    total = repdiv (total, angle.rad);
    if (d.autos.flip.deg.rndrd) angle = d.autos.flip.deg ();
  }
}

autoflipt::autoflipt (defvelaccel& d) {
  yes = d.autos.flip.yes;
  angle = d.autos.flip.deg();
  total = 0.0f;
}

std::istream& operator>> (std::istream& file, autoflipt& af) {
  float d;
  file >> af.yes >> d >> af.total;
  af.angle = d;
  return file;
}


std::ostream& operator<< (std::ostream& file, autoflipt& af) {
  extern const char spc;
  file << af.yes << spc << af.angle.deg << spc << af.total;
  return file;
}
