// services/data_decoder/public/mojom/xml_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/xml_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/data_decoder/public/mojom/xml_parser.mojom-params-data.h"
#include "services/data_decoder/public/mojom/xml_parser.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/xml_parser.mojom-import-headers.h"


#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_XML_PARSER_MOJOM_JUMBO_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_XML_PARSER_MOJOM_JUMBO_H_
#endif
namespace data_decoder {
namespace mojom {
const char XmlParser::Name_[] = "data_decoder.mojom.XmlParser";
const char XmlParser::kTypeKey[] = "type";
const char XmlParser::kTagKey[] = "tag";
const char XmlParser::kTextKey[] = "text";
const char XmlParser::kAttributesKey[] = "attributes";
const char XmlParser::kChildrenKey[] = "children";
const char XmlParser::kNamespacesKey[] = "namespaces";
const char XmlParser::kElementType[] = "element";
const char XmlParser::kTextNodeType[] = "text";
const char XmlParser::kCDataNodeType[] = "cdata";

class XmlParser_Parse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XmlParser_Parse_ForwardToCallback(
      XmlParser::ParseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XmlParser::ParseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XmlParser_Parse_ForwardToCallback);
};

XmlParserProxy::XmlParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XmlParserProxy::Parse(
    const std::string& in_xml, ParseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::XmlParser::Parse", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("xml", in_xml);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXmlParser_Parse_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::data_decoder::mojom::internal::XmlParser_Parse_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->xml)::BaseType::BufferWriter
      xml_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_xml, buffer, &xml_writer, &serialization_context);
  params->xml.Set(
      xml_writer.is_null() ? nullptr : xml_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->xml.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null xml in XmlParser.Parse request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XmlParser::Name_);
  message.set_method_name("Parse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XmlParser_Parse_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class XmlParser_Parse_ProxyToResponder {
 public:
  static XmlParser::ParseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XmlParser_Parse_ProxyToResponder> proxy(
        new XmlParser_Parse_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XmlParser_Parse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XmlParser_Parse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XmlParser_Parse_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XmlParser::ParseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::Optional<::base::Value> in_result, const base::Optional<std::string>& in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XmlParser_Parse_ProxyToResponder);
};

bool XmlParser_Parse_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::XmlParser::ParseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::XmlParser_Parse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XmlParser_Parse_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  base::Optional<::base::Value> p_result{};
  base::Optional<std::string> p_error{};
  XmlParser_Parse_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XmlParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error));
  return true;
}

void XmlParser_Parse_ProxyToResponder::Run(
    base::Optional<::base::Value> in_result, const base::Optional<std::string>& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::XmlParser::ParseCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type base::Optional<::base::Value>>"));
      if (in_error.has_value()) {
        raw_value->SetString("error", in_error.value());
      } else {
        raw_value->SetString("error", "base::nullopt");
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXmlParser_Parse_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::data_decoder::mojom::internal::XmlParser_Parse_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  typename decltype(params->error)::BaseType::BufferWriter
      error_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, buffer, &error_writer, &serialization_context);
  params->error.Set(
      error_writer.is_null() ? nullptr : error_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::XmlParser::ParseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XmlParser::Name_);
  message.set_method_name("Parse");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XmlParserStubDispatch::Accept(
    XmlParser* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kXmlParser_Parse_Name: {
      break;
    }
  }
  return false;
}

// static
bool XmlParserStubDispatch::AcceptWithResponder(
    XmlParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXmlParser_Parse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::XmlParser::Parse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::XmlParser::Parse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XmlParser_Parse_Params_Data* params =
          reinterpret_cast<
              internal::XmlParser_Parse_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_xml{};
      XmlParser_Parse_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadXml(&p_xml))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XmlParser::Name_, 0, false);
        return false;
      }
      XmlParser::ParseCallback callback =
          XmlParser_Parse_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Parse(
std::move(p_xml), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXmlParserValidationInfo[] = {
    {internal::kXmlParser_Parse_Name,
     {&internal::XmlParser_Parse_Params_Data::Validate,
      &internal::XmlParser_Parse_ResponseParams_Data::Validate}},
};

bool XmlParserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::XmlParser::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXmlParserValidationInfo);
}

bool XmlParserResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::XmlParser::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kXmlParserValidationInfo);

}
}  // namespace mojom
}  // namespace data_decoder

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif