/* gci-entry-controller.c generated by valac 0.56.3, the Vala compiler
 * generated from gci-entry-controller.vala, do not modify */

/* gcalc-entry-controler.vala
 *
 * Copyright (C) 2019  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include "gci/gci.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "gcalc/gcalc.h"
#include "gci.h"

enum  {
	GCI_ENTRY_CONTROLLER_0_PROPERTY,
	GCI_ENTRY_CONTROLLER_ENTRY_PROPERTY,
	GCI_ENTRY_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* gci_entry_controller_properties[GCI_ENTRY_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GCiEntryControllerPrivate {
	GtkEntry* _entry;
};

static gint GCiEntryController_private_offset;
static gpointer gci_entry_controller_parent_class = NULL;

VALA_EXTERN void gci_entry_controller_setup (GCiEntryController* self);
static void __lambda4_ (GCiEntryController* self);
VALA_EXTERN void gci_entry_controller_calculate (GCiEntryController* self);
static void ___lambda4__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda5_ (GCiEntryController* self,
                 GtkEntry* pos,
                 GtkEntryIconPosition ev);
static void ___lambda5__gtk_entry_icon_press (GtkEntry* _sender,
                                       GtkEntryIconPosition icon_pos,
                                       gpointer self);
static void gci_entry_controller_finalize (GObject * obj);
static GType gci_entry_controller_get_type_once (void);
static void _vala_gci_entry_controller_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gci_entry_controller_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gci_entry_controller_get_instance_private (GCiEntryController* self)
{
	return G_STRUCT_MEMBER_P (self, GCiEntryController_private_offset);
}

GCiEntryController*
gci_entry_controller_construct_for_entry (GType object_type,
                                          GtkEntry* entry)
{
	GCiEntryController * self = NULL;
	g_return_val_if_fail (entry != NULL, NULL);
	self = (GCiEntryController*) g_object_new (object_type, NULL);
	gci_entry_controller_set_entry (self, entry);
	gci_entry_controller_setup (self);
	return self;
}

GCiEntryController*
gci_entry_controller_new_for_entry (GtkEntry* entry)
{
	return gci_entry_controller_construct_for_entry (GCI_TYPE_ENTRY_CONTROLLER, entry);
}

static void
__lambda4_ (GCiEntryController* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = gci_entry_controller_get_entry (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!g_str_has_prefix (_tmp3_, "=")) {
		return;
	}
	gci_entry_controller_calculate (self);
}

static void
___lambda4__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda4_ ((GCiEntryController*) self);
}

static void
__lambda5_ (GCiEntryController* self,
            GtkEntry* pos,
            GtkEntryIconPosition ev)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (pos != NULL);
	_tmp0_ = gci_entry_controller_get_entry (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!g_str_has_prefix (_tmp3_, "=")) {
		return;
	}
	gci_entry_controller_calculate (self);
}

static void
___lambda5__gtk_entry_icon_press (GtkEntry* _sender,
                                  GtkEntryIconPosition icon_pos,
                                  gpointer self)
{
	__lambda5_ ((GCiEntryController*) self, _sender, icon_pos);
}

void
gci_entry_controller_setup (GCiEntryController* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gci_entry_controller_get_entry (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		g_warning ("gci-entry-controller.vala:52: No entry was set");
	}
	_tmp2_ = gci_entry_controller_get_entry (self);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp3_, "secondary-icon-name", "accessories-calculator", NULL);
	_tmp4_ = gci_entry_controller_get_entry (self);
	_tmp5_ = _tmp4_;
	g_object_set (_tmp5_, "secondary-icon-activatable", TRUE, NULL);
	_tmp6_ = gci_entry_controller_get_entry (self);
	_tmp7_ = _tmp6_;
	g_object_set (_tmp7_, "secondary-icon-sensitive", TRUE, NULL);
	_tmp8_ = gci_entry_controller_get_entry (self);
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "activate", (GCallback) ___lambda4__gtk_entry_activate, self, 0);
	_tmp10_ = gci_entry_controller_get_entry (self);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "icon-press", (GCallback) ___lambda5__gtk_entry_icon_press, self, 0);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
gci_entry_controller_calculate (GCiEntryController* self)
{
	GCalcSolver* s = NULL;
	GCalcSolver* _tmp0_;
	gchar* str = NULL;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gcalc_solver_new ();
	s = _tmp0_;
	_tmp1_ = gci_entry_controller_get_entry (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "=", "");
	str = _tmp5_;
	{
		GCalcMathResult* r = NULL;
		GCalcMathResult* _tmp6_;
		_tmp6_ = gcalc_solver_solve (s, str, &_inner_error0_);
		r = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (G_TYPE_CHECK_INSTANCE_TYPE (r, GCALC_TYPE_MATH_RESULT)) {
			GtkEntry* _tmp7_;
			GtkEntry* _tmp8_;
			GCalcMathExpression* _tmp9_;
			GCalcMathExpression* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp7_ = gci_entry_controller_get_entry (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = gcalc_math_result_get_expression (r);
			_tmp10_ = _tmp9_;
			_tmp11_ = gcalc_math_expression_to_string (_tmp10_);
			_tmp12_ = _tmp11_;
			gtk_editable_set_text ((GtkEditable*) _tmp8_, _tmp12_);
			_g_free0 (_tmp12_);
		}
		_g_object_unref0 (r);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("gci-entry-controller.vala:80: Math Expression evaluation error: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (str);
		_g_object_unref0 (s);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (str);
	_g_object_unref0 (s);
}

GCiEntryController*
gci_entry_controller_construct (GType object_type)
{
	GCiEntryController * self = NULL;
	self = (GCiEntryController*) g_object_new (object_type, NULL);
	return self;
}

GCiEntryController*
gci_entry_controller_new (void)
{
	return gci_entry_controller_construct (GCI_TYPE_ENTRY_CONTROLLER);
}

GtkEntry*
gci_entry_controller_get_entry (GCiEntryController* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gci_entry_controller_set_entry (GCiEntryController* self,
                                GtkEntry* value)
{
	GtkEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_entry);
	self->priv->_entry = _tmp0_;
	gci_entry_controller_setup (self);
	g_object_notify_by_pspec ((GObject *) self, gci_entry_controller_properties[GCI_ENTRY_CONTROLLER_ENTRY_PROPERTY]);
}

static void
gci_entry_controller_class_init (GCiEntryControllerClass * klass,
                                 gpointer klass_data)
{
	gci_entry_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GCiEntryController_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gci_entry_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gci_entry_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = gci_entry_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCI_ENTRY_CONTROLLER_ENTRY_PROPERTY, gci_entry_controller_properties[GCI_ENTRY_CONTROLLER_ENTRY_PROPERTY] = g_param_spec_object ("entry", "entry", "entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gci_entry_controller_instance_init (GCiEntryController * self,
                                    gpointer klass)
{
	self->priv = gci_entry_controller_get_instance_private (self);
}

static void
gci_entry_controller_finalize (GObject * obj)
{
	GCiEntryController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCI_TYPE_ENTRY_CONTROLLER, GCiEntryController);
	_g_object_unref0 (self->priv->_entry);
	G_OBJECT_CLASS (gci_entry_controller_parent_class)->finalize (obj);
}

/**
 * A {@link Gtk.Entry} controler to provide calculator services
 *
 * Setup a {@link Gtk.Entry} to response when the user hits the
 * enter key or click the secondary icon, to evaluate the math
 * expression and substitude the result as the new content text
 * of the {@link Gtk.Entry}.
 *
 * The math expression should start with the equal sign "=", in
 * order to execute the math expression evaluation.
 *
 * If the expression is not a valid one, like using undefined
 * variables, the new text is empty.
 */
static GType
gci_entry_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GCiEntryControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gci_entry_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GCiEntryController), 0, (GInstanceInitFunc) gci_entry_controller_instance_init, NULL };
	GType gci_entry_controller_type_id;
	gci_entry_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "GCiEntryController", &g_define_type_info, 0);
	GCiEntryController_private_offset = g_type_add_instance_private (gci_entry_controller_type_id, sizeof (GCiEntryControllerPrivate));
	return gci_entry_controller_type_id;
}

GType
gci_entry_controller_get_type (void)
{
	static volatile gsize gci_entry_controller_type_id__once = 0;
	if (g_once_init_enter (&gci_entry_controller_type_id__once)) {
		GType gci_entry_controller_type_id;
		gci_entry_controller_type_id = gci_entry_controller_get_type_once ();
		g_once_init_leave (&gci_entry_controller_type_id__once, gci_entry_controller_type_id);
	}
	return gci_entry_controller_type_id__once;
}

static void
_vala_gci_entry_controller_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GCiEntryController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCI_TYPE_ENTRY_CONTROLLER, GCiEntryController);
	switch (property_id) {
		case GCI_ENTRY_CONTROLLER_ENTRY_PROPERTY:
		g_value_set_object (value, gci_entry_controller_get_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gci_entry_controller_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GCiEntryController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCI_TYPE_ENTRY_CONTROLLER, GCiEntryController);
	switch (property_id) {
		case GCI_ENTRY_CONTROLLER_ENTRY_PROPERTY:
		gci_entry_controller_set_entry (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

