/* new-game-window.c generated by valac 0.56.3, the Vala compiler
 * generated from new-game-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2022 Nils Lück
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include "libengine.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NEW_GAME_WINDOW (new_game_window_get_type ())
#define NEW_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEW_GAME_WINDOW, NewGameWindow))
#define NEW_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEW_GAME_WINDOW, NewGameWindowClass))
#define IS_NEW_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEW_GAME_WINDOW))
#define IS_NEW_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEW_GAME_WINDOW))
#define NEW_GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEW_GAME_WINDOW, NewGameWindowClass))

typedef struct _NewGameWindow NewGameWindow;
typedef struct _NewGameWindowClass NewGameWindowClass;
typedef struct _NewGameWindowPrivate NewGameWindowPrivate;

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;

#define TYPE_OPPONENT (opponent_get_type ())
#define OPPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OPPONENT, Opponent))
#define OPPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OPPONENT, OpponentClass))
#define IS_OPPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OPPONENT))
#define IS_OPPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OPPONENT))
#define OPPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OPPONENT, OpponentClass))

typedef struct _Opponent Opponent;
typedef struct _OpponentClass OpponentClass;
enum  {
	NEW_GAME_WINDOW_0_PROPERTY,
	NEW_GAME_WINDOW_NUM_PROPERTIES
};
static GParamSpec* new_game_window_properties[NEW_GAME_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	PLAY_AS_WHITE,
	PLAY_AS_BLACK,
	PLAY_AS_ALTERNATE
} PlayAs;

#define TYPE_PLAY_AS (play_as_get_type ())
typedef enum  {
	DIFFICULTY_EASY,
	DIFFICULTY_NORMAL,
	DIFFICULTY_HARD
} Difficulty;

#define TYPE_DIFFICULTY (difficulty_get_type ())
typedef enum  {
	CLOCK_TYPE_FISCHER,
	CLOCK_TYPE_BRONSTEIN
} ClockType;

#define TYPE_CLOCK_TYPE (clock_type_get_type ())

#define TYPE_TIME_LIMIT (time_limit_get_type ())
#define TIME_LIMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIME_LIMIT, TimeLimit))
#define TIME_LIMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIME_LIMIT, TimeLimitClass))
#define IS_TIME_LIMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIME_LIMIT))
#define IS_TIME_LIMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIME_LIMIT))
#define TIME_LIMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIME_LIMIT, TimeLimitClass))

typedef struct _TimeLimit TimeLimit;
typedef struct _TimeLimitClass TimeLimitClass;
#define _time_limit_unref0(var) ((var == NULL) ? NULL : (var = (time_limit_unref (var), NULL)))
enum  {
	NEW_GAME_WINDOW_NEW_GAME_REQUESTED_SIGNAL,
	NEW_GAME_WINDOW_NUM_SIGNALS
};
static guint new_game_window_signals[NEW_GAME_WINDOW_NUM_SIGNALS] = {0};

struct _NewGameWindow {
	AdwPreferencesWindow parent_instance;
	NewGameWindowPrivate * priv;
};

struct _NewGameWindowClass {
	AdwPreferencesWindowClass parent_class;
};

struct _NewGameWindowPrivate {
	gboolean syncing_time_limit;
	Preferences* preferences;
	GList* ai_profiles;
	GList* opponents;
	AdwComboRow* play_as_combo;
	AdwComboRow* difficulty_combo;
	AdwComboRow* opponent_combo;
	AdwComboRow* clock_type_combo;
	GtkSpinButton* duration_spin;
	GtkSpinButton* increment_spin;
	GtkSwitch* time_limit_switch;
};

static gint NewGameWindow_private_offset;
static gpointer new_game_window_parent_class = NULL;

VALA_EXTERN GType new_game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NewGameWindow, g_object_unref)
VALA_EXTERN GType preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Preferences, g_object_unref)
VALA_EXTERN GType opponent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Opponent, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN NewGameWindow* new_game_window_new (GtkWindow* window,
                                    Preferences* preferences,
                                    GList* ai_profiles);
VALA_EXTERN NewGameWindow* new_game_window_construct (GType object_type,
                                          GtkWindow* window,
                                          Preferences* preferences,
                                          GList* ai_profiles);
static void new_game_window_initialize_opponents (NewGameWindow* self,
                                           GList* ai_profiles);
static gboolean __lambda17_ (NewGameWindow* self,
                      GBinding* binding,
                      GValue* from_value,
                      GValue* to_value);
static guint new_game_window_get_opponent_index (NewGameWindow* self,
                                          const gchar* display_name);
VALA_EXTERN const gchar* opponent_get_display_name (Opponent* self);
static gboolean ___lambda17__gbinding_transform_func (GBinding* binding,
                                               GValue* from_value,
                                               GValue* to_value,
                                               gpointer self);
static gboolean __lambda18_ (NewGameWindow* self,
                      GBinding* binding,
                      GValue* from_value,
                      GValue* to_value);
static gboolean ___lambda18__gbinding_transform_func (GBinding* binding,
                                               GValue* from_value,
                                               GValue* to_value,
                                               gpointer self);
static void new_game_window_time_limit_settings_changed_cb (NewGameWindow* self);
static void new_game_window_time_limit_controls_changed_cb (NewGameWindow* self);
static void _new_game_window_time_limit_controls_changed_cb_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void _new_game_window_time_limit_controls_changed_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                                    gpointer self);
static void _new_game_window_time_limit_settings_changed_cb_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static gboolean __lambda19_ (NewGameWindow* self,
                      GBinding* binding,
                      GValue* from_value,
                      GValue* to_value);
VALA_EXTERN gboolean opponent_get_is_human (Opponent* self);
static gboolean ___lambda19__gbinding_transform_func (GBinding* binding,
                                               GValue* from_value,
                                               GValue* to_value,
                                               gpointer self);
static gboolean __lambda20_ (NewGameWindow* self,
                      GBinding* binding,
                      GValue* from_value,
                      GValue* to_value);
static gboolean ___lambda20__gbinding_transform_func (GBinding* binding,
                                               GValue* from_value,
                                               GValue* to_value,
                                               gpointer self);
static void new_game_window_start_game_cb (NewGameWindow* self);
static void _new_game_window_start_game_cb_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static gchar* new_game_window_play_as_display_name_cb (NewGameWindow* self,
                                                AdwEnumListItem* item);
VALA_EXTERN GType play_as_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* play_as_display_name (PlayAs self);
static gchar* new_game_window_difficulty_display_name_cb (NewGameWindow* self,
                                                   AdwEnumListItem* item);
VALA_EXTERN GType difficulty_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* difficulty_display_name (Difficulty self);
static gchar* new_game_window_clock_type_display_name_cb (NewGameWindow* self,
                                                   AdwEnumListItem* item);
VALA_EXTERN GType clock_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* clock_type_display_name (ClockType self);
VALA_EXTERN gpointer time_limit_ref (gpointer instance);
VALA_EXTERN void time_limit_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_time_limit (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_time_limit (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_time_limit (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_time_limit (const GValue* value);
VALA_EXTERN GType time_limit_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimeLimit, time_limit_unref)
VALA_EXTERN TimeLimit* preferences_get_time_limit (Preferences* self);
VALA_EXTERN gint time_limit_get_duration_in_seconds (TimeLimit* self);
VALA_EXTERN gint time_limit_get_increment_in_seconds (TimeLimit* self);
VALA_EXTERN ClockType time_limit_get_clock_type (TimeLimit* self);
VALA_EXTERN TimeLimit* time_limit_new (gint duration_in_seconds,
                           gint increment_in_seconds,
                           ClockType clock_type);
VALA_EXTERN TimeLimit* time_limit_construct (GType object_type,
                                 gint duration_in_seconds,
                                 gint increment_in_seconds,
                                 ClockType clock_type);
VALA_EXTERN void preferences_set_time_limit (Preferences* self,
                                 TimeLimit* value);
VALA_EXTERN Opponent* opponent_get_human (void);
VALA_EXTERN Opponent* opponent_from_ai_profile (AIProfile* ai_profile);
static void new_game_window_finalize (GObject * obj);
static GType new_game_window_get_type_once (void);

static inline gpointer
new_game_window_get_instance_private (NewGameWindow* self)
{
	return G_STRUCT_MEMBER_P (self, NewGameWindow_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda17_ (NewGameWindow* self,
             GBinding* binding,
             GValue* from_value,
             GValue* to_value)
{
	Opponent* opponent = NULL;
	GObject* _tmp0_;
	Opponent* _tmp1_;
	guint position = 0U;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	g_return_val_if_fail (to_value != NULL, FALSE);
	_tmp0_ = g_value_get_object (from_value);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_OPPONENT, Opponent));
	opponent = _tmp1_;
	_tmp2_ = opponent_get_display_name (opponent);
	_tmp3_ = _tmp2_;
	position = new_game_window_get_opponent_index (self, _tmp3_);
	g_value_set_uint (to_value, position);
	result = TRUE;
	_g_object_unref0 (opponent);
	return result;
}

static gboolean
___lambda17__gbinding_transform_func (GBinding* binding,
                                      GValue* from_value,
                                      GValue* to_value,
                                      gpointer self)
{
	gboolean result;
	result = __lambda17_ ((NewGameWindow*) self, binding, from_value, to_value);
	return result;
}

static gboolean
__lambda18_ (NewGameWindow* self,
             GBinding* binding,
             GValue* from_value,
             GValue* to_value)
{
	guint position = 0U;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	g_return_val_if_fail (to_value != NULL, FALSE);
	position = g_value_get_uint (from_value);
	_tmp0_ = self->priv->opponents;
	_tmp1_ = g_list_nth_data (_tmp0_, position);
	g_value_set_object (to_value, (GObject*) ((Opponent*) _tmp1_));
	result = TRUE;
	return result;
}

static gboolean
___lambda18__gbinding_transform_func (GBinding* binding,
                                      GValue* from_value,
                                      GValue* to_value,
                                      gpointer self)
{
	gboolean result;
	result = __lambda18_ ((NewGameWindow*) self, binding, from_value, to_value);
	return result;
}

static void
_new_game_window_time_limit_controls_changed_cb_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	new_game_window_time_limit_controls_changed_cb ((NewGameWindow*) self);
}

static void
_new_game_window_time_limit_controls_changed_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                               gpointer self)
{
	new_game_window_time_limit_controls_changed_cb ((NewGameWindow*) self);
}

static void
_new_game_window_time_limit_settings_changed_cb_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	new_game_window_time_limit_settings_changed_cb ((NewGameWindow*) self);
}

static gboolean
__lambda19_ (NewGameWindow* self,
             GBinding* binding,
             GValue* from_value,
             GValue* to_value)
{
	Opponent* opponent = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	Opponent* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	g_return_val_if_fail (to_value != NULL, FALSE);
	_tmp0_ = self->priv->opponents;
	_tmp1_ = g_list_nth_data (_tmp0_, g_value_get_uint (from_value));
	_tmp2_ = _g_object_ref0 ((Opponent*) _tmp1_);
	opponent = _tmp2_;
	_tmp3_ = opponent_get_is_human (opponent);
	_tmp4_ = _tmp3_;
	g_value_set_boolean (to_value, !_tmp4_);
	result = TRUE;
	_g_object_unref0 (opponent);
	return result;
}

static gboolean
___lambda19__gbinding_transform_func (GBinding* binding,
                                      GValue* from_value,
                                      GValue* to_value,
                                      gpointer self)
{
	gboolean result;
	result = __lambda19_ ((NewGameWindow*) self, binding, from_value, to_value);
	return result;
}

static gboolean
__lambda20_ (NewGameWindow* self,
             GBinding* binding,
             GValue* from_value,
             GValue* to_value)
{
	Opponent* opponent = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	Opponent* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	g_return_val_if_fail (to_value != NULL, FALSE);
	_tmp0_ = self->priv->opponents;
	_tmp1_ = g_list_nth_data (_tmp0_, g_value_get_uint (from_value));
	_tmp2_ = _g_object_ref0 ((Opponent*) _tmp1_);
	opponent = _tmp2_;
	_tmp3_ = opponent_get_is_human (opponent);
	_tmp4_ = _tmp3_;
	g_value_set_boolean (to_value, !_tmp4_);
	result = TRUE;
	_g_object_unref0 (opponent);
	return result;
}

static gboolean
___lambda20__gbinding_transform_func (GBinding* binding,
                                      GValue* from_value,
                                      GValue* to_value,
                                      gpointer self)
{
	gboolean result;
	result = __lambda20_ ((NewGameWindow*) self, binding, from_value, to_value);
	return result;
}

NewGameWindow*
new_game_window_construct (GType object_type,
                           GtkWindow* window,
                           Preferences* preferences,
                           GList* ai_profiles)
{
	NewGameWindow * self = NULL;
	Preferences* _tmp0_;
	AdwComboRow* _tmp1_;
	AdwComboRow* _tmp2_;
	AdwComboRow* _tmp3_;
	GtkSwitch* _tmp4_;
	AdwComboRow* _tmp5_;
	GtkSpinButton* _tmp6_;
	GtkSpinButton* _tmp7_;
	AdwComboRow* _tmp8_;
	AdwComboRow* _tmp9_;
	AdwComboRow* _tmp10_;
	AdwComboRow* _tmp11_;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (preferences != NULL, NULL);
	self = (NewGameWindow*) g_object_new (object_type, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, window);
	_tmp0_ = _g_object_ref0 (preferences);
	_g_object_unref0 (self->priv->preferences);
	self->priv->preferences = _tmp0_;
	self->priv->ai_profiles = ai_profiles;
	new_game_window_initialize_opponents (self, ai_profiles);
	_tmp1_ = self->priv->play_as_combo;
	g_object_bind_property_with_closures ((GObject*) preferences, "play-as", (GObject*) _tmp1_, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp2_ = self->priv->difficulty_combo;
	g_object_bind_property_with_closures ((GObject*) preferences, "difficulty", (GObject*) _tmp2_, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp3_ = self->priv->opponent_combo;
	g_object_bind_property_with_closures ((GObject*) preferences, "opponent", (GObject*) _tmp3_, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((___lambda17__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda17__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda18__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda18__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)));
	new_game_window_time_limit_settings_changed_cb (self);
	_tmp4_ = self->priv->time_limit_switch;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::active", (GCallback) _new_game_window_time_limit_controls_changed_cb_g_object_notify, self, 0);
	_tmp5_ = self->priv->clock_type_combo;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::selected", (GCallback) _new_game_window_time_limit_controls_changed_cb_g_object_notify, self, 0);
	_tmp6_ = self->priv->duration_spin;
	g_signal_connect_object (_tmp6_, "value-changed", (GCallback) _new_game_window_time_limit_controls_changed_cb_gtk_spin_button_value_changed, self, 0);
	_tmp7_ = self->priv->increment_spin;
	g_signal_connect_object (_tmp7_, "value-changed", (GCallback) _new_game_window_time_limit_controls_changed_cb_gtk_spin_button_value_changed, self, 0);
	g_signal_connect_object ((GObject*) preferences, "notify::time-limit", (GCallback) _new_game_window_time_limit_settings_changed_cb_g_object_notify, self, 0);
	_tmp8_ = self->priv->opponent_combo;
	_tmp9_ = self->priv->difficulty_combo;
	g_object_bind_property_with_closures ((GObject*) _tmp8_, "selected", (GObject*) _tmp9_, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((___lambda19__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda19__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = self->priv->opponent_combo;
	_tmp11_ = self->priv->play_as_combo;
	g_object_bind_property_with_closures ((GObject*) _tmp10_, "selected", (GObject*) _tmp11_, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((___lambda20__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda20__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return self;
}

NewGameWindow*
new_game_window_new (GtkWindow* window,
                     Preferences* preferences,
                     GList* ai_profiles)
{
	return new_game_window_construct (TYPE_NEW_GAME_WINDOW, window, preferences, ai_profiles);
}

static void
new_game_window_start_game_cb (NewGameWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_window_close ((GtkWindow*) self);
	g_signal_emit (self, new_game_window_signals[NEW_GAME_WINDOW_NEW_GAME_REQUESTED_SIGNAL], 0);
}

static void
_new_game_window_start_game_cb_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	new_game_window_start_game_cb ((NewGameWindow*) self);
}

static gchar*
new_game_window_play_as_display_name_cb (NewGameWindow* self,
                                         AdwEnumListItem* item)
{
	PlayAs value = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	value = (PlayAs) _tmp1_;
	_tmp2_ = play_as_display_name (value);
	result = _tmp2_;
	return result;
}

static gchar*
new_game_window_difficulty_display_name_cb (NewGameWindow* self,
                                            AdwEnumListItem* item)
{
	Difficulty value = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	value = (Difficulty) _tmp1_;
	_tmp2_ = difficulty_display_name (value);
	result = _tmp2_;
	return result;
}

static gchar*
new_game_window_clock_type_display_name_cb (NewGameWindow* self,
                                            AdwEnumListItem* item)
{
	ClockType value = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	value = (ClockType) _tmp1_;
	_tmp2_ = clock_type_display_name (value);
	result = _tmp2_;
	return result;
}

static void
new_game_window_time_limit_settings_changed_cb (NewGameWindow* self)
{
	Preferences* _tmp0_;
	TimeLimit* _tmp1_;
	TimeLimit* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->syncing_time_limit) {
		return;
	}
	self->priv->syncing_time_limit = TRUE;
	_tmp0_ = self->priv->preferences;
	_tmp1_ = preferences_get_time_limit (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		GtkSwitch* _tmp3_;
		GtkSpinButton* _tmp4_;
		GtkSpinButton* _tmp5_;
		AdwComboRow* _tmp6_;
		_tmp3_ = self->priv->time_limit_switch;
		gtk_switch_set_active (_tmp3_, FALSE);
		_tmp4_ = self->priv->duration_spin;
		gtk_spin_button_set_value (_tmp4_, (gdouble) 5);
		_tmp5_ = self->priv->increment_spin;
		gtk_spin_button_set_value (_tmp5_, (gdouble) 0);
		_tmp6_ = self->priv->clock_type_combo;
		adw_combo_row_set_selected (_tmp6_, (guint) ((gint) CLOCK_TYPE_FISCHER));
	} else {
		GtkSwitch* _tmp7_;
		GtkSpinButton* _tmp8_;
		Preferences* _tmp9_;
		TimeLimit* _tmp10_;
		TimeLimit* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GtkSpinButton* _tmp14_;
		Preferences* _tmp15_;
		TimeLimit* _tmp16_;
		TimeLimit* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		AdwComboRow* _tmp20_;
		Preferences* _tmp21_;
		TimeLimit* _tmp22_;
		TimeLimit* _tmp23_;
		ClockType _tmp24_;
		ClockType _tmp25_;
		_tmp7_ = self->priv->time_limit_switch;
		gtk_switch_set_active (_tmp7_, TRUE);
		_tmp8_ = self->priv->duration_spin;
		_tmp9_ = self->priv->preferences;
		_tmp10_ = preferences_get_time_limit (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = time_limit_get_duration_in_seconds (_tmp11_);
		_tmp13_ = _tmp12_;
		gtk_spin_button_set_value (_tmp8_, _tmp13_ / 60.0);
		_tmp14_ = self->priv->increment_spin;
		_tmp15_ = self->priv->preferences;
		_tmp16_ = preferences_get_time_limit (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = time_limit_get_increment_in_seconds (_tmp17_);
		_tmp19_ = _tmp18_;
		gtk_spin_button_set_value (_tmp14_, (gdouble) _tmp19_);
		_tmp20_ = self->priv->clock_type_combo;
		_tmp21_ = self->priv->preferences;
		_tmp22_ = preferences_get_time_limit (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = time_limit_get_clock_type (_tmp23_);
		_tmp25_ = _tmp24_;
		adw_combo_row_set_selected (_tmp20_, (guint) ((gint) _tmp25_));
	}
	self->priv->syncing_time_limit = FALSE;
}

static void
new_game_window_time_limit_controls_changed_cb (NewGameWindow* self)
{
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->syncing_time_limit) {
		return;
	}
	self->priv->syncing_time_limit = TRUE;
	_tmp0_ = self->priv->time_limit_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gint duration_in_seconds = 0;
		GtkSpinButton* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		gint increment_in_seconds = 0;
		GtkSpinButton* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		ClockType clock_type = 0;
		AdwComboRow* _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		Preferences* _tmp12_;
		TimeLimit* _tmp13_;
		TimeLimit* _tmp14_;
		_tmp3_ = self->priv->duration_spin;
		_tmp4_ = gtk_spin_button_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		duration_in_seconds = ((gint) _tmp5_) * 60;
		_tmp6_ = self->priv->increment_spin;
		_tmp7_ = gtk_spin_button_get_value (_tmp6_);
		_tmp8_ = _tmp7_;
		increment_in_seconds = (gint) _tmp8_;
		_tmp9_ = self->priv->clock_type_combo;
		_tmp10_ = adw_combo_row_get_selected (_tmp9_);
		_tmp11_ = _tmp10_;
		clock_type = (ClockType) _tmp11_;
		_tmp12_ = self->priv->preferences;
		_tmp13_ = time_limit_new (duration_in_seconds, increment_in_seconds, clock_type);
		_tmp14_ = _tmp13_;
		preferences_set_time_limit (_tmp12_, _tmp14_);
		_time_limit_unref0 (_tmp14_);
	} else {
		Preferences* _tmp15_;
		_tmp15_ = self->priv->preferences;
		preferences_set_time_limit (_tmp15_, NULL);
	}
	self->priv->syncing_time_limit = FALSE;
}

static void
new_game_window_initialize_opponents (NewGameWindow* self,
                                      GList* ai_profiles)
{
	Opponent* _tmp0_;
	Opponent* _tmp1_;
	Opponent* _tmp2_;
	GtkStringList* opponents_model = NULL;
	GtkStringList* _tmp6_;
	GList* _tmp7_;
	AdwComboRow* _tmp13_;
	GtkStringList* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = opponent_get_human ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self->priv->opponents = g_list_append (self->priv->opponents, _tmp2_);
	{
		GList* ai_profile_collection = NULL;
		GList* ai_profile_it = NULL;
		ai_profile_collection = ai_profiles;
		for (ai_profile_it = ai_profile_collection; ai_profile_it != NULL; ai_profile_it = ai_profile_it->next) {
			AIProfile* _tmp3_;
			AIProfile* ai_profile = NULL;
			_tmp3_ = _g_object_ref0 ((AIProfile*) ai_profile_it->data);
			ai_profile = _tmp3_;
			{
				AIProfile* _tmp4_;
				Opponent* _tmp5_;
				_tmp4_ = ai_profile;
				_tmp5_ = opponent_from_ai_profile (_tmp4_);
				self->priv->opponents = g_list_append (self->priv->opponents, _tmp5_);
				_g_object_unref0 (ai_profile);
			}
		}
	}
	_tmp6_ = gtk_string_list_new (NULL);
	opponents_model = _tmp6_;
	_tmp7_ = self->priv->opponents;
	{
		GList* opponent_collection = NULL;
		GList* opponent_it = NULL;
		opponent_collection = _tmp7_;
		for (opponent_it = opponent_collection; opponent_it != NULL; opponent_it = opponent_it->next) {
			Opponent* _tmp8_;
			Opponent* opponent = NULL;
			_tmp8_ = _g_object_ref0 ((Opponent*) opponent_it->data);
			opponent = _tmp8_;
			{
				GtkStringList* _tmp9_;
				Opponent* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp9_ = opponents_model;
				_tmp10_ = opponent;
				_tmp11_ = opponent_get_display_name (_tmp10_);
				_tmp12_ = _tmp11_;
				gtk_string_list_append (_tmp9_, _tmp12_);
				_g_object_unref0 (opponent);
			}
		}
	}
	_tmp13_ = self->priv->opponent_combo;
	_tmp14_ = opponents_model;
	adw_combo_row_set_model (_tmp13_, (GListModel*) _tmp14_);
	_g_object_unref0 (opponents_model);
}

static guint
new_game_window_get_opponent_index (NewGameWindow* self,
                                    const gchar* display_name)
{
	gint i = 0;
	GList* _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (display_name != NULL, 0U);
	i = 0;
	_tmp0_ = self->priv->opponents;
	{
		GList* opponent_collection = NULL;
		GList* opponent_it = NULL;
		opponent_collection = _tmp0_;
		for (opponent_it = opponent_collection; opponent_it != NULL; opponent_it = opponent_it->next) {
			Opponent* _tmp1_;
			Opponent* opponent = NULL;
			_tmp1_ = _g_object_ref0 ((Opponent*) opponent_it->data);
			opponent = _tmp1_;
			{
				Opponent* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				_tmp2_ = opponent;
				_tmp3_ = opponent_get_display_name (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, display_name) == 0) {
					result = (guint) i;
					_g_object_unref0 (opponent);
					return result;
				}
				_tmp5_ = i;
				i = _tmp5_ + 1;
				_g_object_unref0 (opponent);
			}
		}
	}
	result = (guint) 0;
	return result;
}

static void
new_game_window_class_init (NewGameWindowClass * klass,
                            gpointer klass_data)
{
	new_game_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NewGameWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = new_game_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Chess/ui/new-game-window.ui");
	new_game_window_signals[NEW_GAME_WINDOW_NEW_GAME_REQUESTED_SIGNAL] = g_signal_new ("new-game-requested", TYPE_NEW_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_as_combo", FALSE, NewGameWindow_private_offset + G_STRUCT_OFFSET (NewGameWindowPrivate, play_as_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "difficulty_combo", FALSE, NewGameWindow_private_offset + G_STRUCT_OFFSET (NewGameWindowPrivate, difficulty_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "opponent_combo", FALSE, NewGameWindow_private_offset + G_STRUCT_OFFSET (NewGameWindowPrivate, opponent_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_type_combo", FALSE, NewGameWindow_private_offset + G_STRUCT_OFFSET (NewGameWindowPrivate, clock_type_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "duration_spin", FALSE, NewGameWindow_private_offset + G_STRUCT_OFFSET (NewGameWindowPrivate, duration_spin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "increment_spin", FALSE, NewGameWindow_private_offset + G_STRUCT_OFFSET (NewGameWindowPrivate, increment_spin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_limit_switch", FALSE, NewGameWindow_private_offset + G_STRUCT_OFFSET (NewGameWindowPrivate, time_limit_switch));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "start_game_cb", G_CALLBACK(_new_game_window_start_game_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "play_as_display_name_cb", G_CALLBACK(new_game_window_play_as_display_name_cb));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "difficulty_display_name_cb", G_CALLBACK(new_game_window_difficulty_display_name_cb));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "clock_type_display_name_cb", G_CALLBACK(new_game_window_clock_type_display_name_cb));
}

static void
new_game_window_instance_init (NewGameWindow * self,
                               gpointer klass)
{
	self->priv = new_game_window_get_instance_private (self);
	self->priv->syncing_time_limit = FALSE;
	self->priv->opponents = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
new_game_window_finalize (GObject * obj)
{
	NewGameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NEW_GAME_WINDOW, NewGameWindow);
	_g_object_unref0 (self->priv->preferences);
	(self->priv->opponents == NULL) ? NULL : (self->priv->opponents = (_g_list_free__g_object_unref0_ (self->priv->opponents), NULL));
	G_OBJECT_CLASS (new_game_window_parent_class)->finalize (obj);
}

static GType
new_game_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NewGameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) new_game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NewGameWindow), 0, (GInstanceInitFunc) new_game_window_instance_init, NULL };
	GType new_game_window_type_id;
	new_game_window_type_id = g_type_register_static (adw_preferences_window_get_type (), "NewGameWindow", &g_define_type_info, 0);
	NewGameWindow_private_offset = g_type_add_instance_private (new_game_window_type_id, sizeof (NewGameWindowPrivate));
	return new_game_window_type_id;
}

GType
new_game_window_get_type (void)
{
	static volatile gsize new_game_window_type_id__once = 0;
	if (g_once_init_enter (&new_game_window_type_id__once)) {
		GType new_game_window_type_id;
		new_game_window_type_id = new_game_window_get_type_once ();
		g_once_init_leave (&new_game_window_type_id__once, new_game_window_type_id);
	}
	return new_game_window_type_id__once;
}

