/* dconf-editor.c generated by valac 0.56.3, the Vala compiler
 * generated from dconf-editor.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include "config.h"
#include <stdio.h>
#include <handy.h>
#include <gdk/gdk.h>

#define CONFIGURATION_EDITOR_PROGRAM_NAME _ ("dconf Editor")
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BASE_APPLICATION (base_application_get_type ())
#define BASE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_APPLICATION, BaseApplication))
#define IS_BASE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_APPLICATION))
#define BASE_APPLICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BASE_APPLICATION, BaseApplicationIface))

typedef struct _BaseApplication BaseApplication;
typedef struct _BaseApplicationIface BaseApplicationIface;

#define TYPE_CONFIGURATION_EDITOR (configuration_editor_get_type ())
#define CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditor))
#define CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))
#define IS_CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_EDITOR))
#define IS_CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_EDITOR))
#define CONFIGURATION_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))

typedef struct _ConfigurationEditor ConfigurationEditor;
typedef struct _ConfigurationEditorClass ConfigurationEditorClass;
typedef struct _ConfigurationEditorPrivate ConfigurationEditorPrivate;
enum  {
	CONFIGURATION_EDITOR_0_PROPERTY,
	CONFIGURATION_EDITOR_NUM_PROPERTIES
};
static GParamSpec* configuration_editor_properties[CONFIGURATION_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;

#define TYPE_BASE_WINDOW (base_window_get_type ())
#define BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_WINDOW, BaseWindow))
#define BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_WINDOW, BaseWindowClass))
#define IS_BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_WINDOW))
#define IS_BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_WINDOW))
#define BASE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_WINDOW, BaseWindowClass))

typedef struct _BaseWindow BaseWindow;
typedef struct _BaseWindowClass BaseWindowClass;

#define TYPE_BROWSER_WINDOW (browser_window_get_type ())
#define BROWSER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_WINDOW, BrowserWindow))
#define BROWSER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_WINDOW, BrowserWindowClass))
#define IS_BROWSER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_WINDOW))
#define IS_BROWSER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_WINDOW))
#define BROWSER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_WINDOW, BrowserWindowClass))

typedef struct _BrowserWindow BrowserWindow;
typedef struct _BrowserWindowClass BrowserWindowClass;

#define TYPE_BOOKMARKS_WINDOW (bookmarks_window_get_type ())
#define BOOKMARKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_WINDOW, BookmarksWindow))
#define BOOKMARKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_WINDOW, BookmarksWindowClass))
#define IS_BOOKMARKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_WINDOW))
#define IS_BOOKMARKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_WINDOW))
#define BOOKMARKS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_WINDOW, BookmarksWindowClass))

typedef struct _BookmarksWindow BookmarksWindow;
typedef struct _BookmarksWindowClass BookmarksWindowClass;

#define TYPE_DCONF_WINDOW (dconf_window_get_type ())
#define DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_WINDOW, DConfWindow))
#define DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_WINDOW, DConfWindowClass))
#define IS_DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_WINDOW))
#define IS_DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_WINDOW))
#define DCONF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_WINDOW, DConfWindowClass))

typedef struct _DConfWindow DConfWindow;
typedef struct _DConfWindowClass DConfWindowClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BaseApplicationIface {
	GTypeInterface parent_iface;
	void (*copy) (BaseApplication* self, const gchar* text);
	void (*get_about_dialog_infos) (BaseApplication* self, gchar*** artists, gint* artists_length1, gchar*** authors, gint* authors_length1, gchar** comments, gchar** copyright, gchar*** documenters, gint* documenters_length1, gchar** logo_icon_name, gchar** program_name, gchar** translator_credits, gchar** version, gchar** website, gchar** website_label);
};

struct _ConfigurationEditor {
	GtkApplication parent_instance;
	ConfigurationEditorPrivate * priv;
};

struct _ConfigurationEditorClass {
	GtkApplicationClass parent_class;
};

struct _ConfigurationEditorPrivate {
	guint notification_number;
	GNotification* notification;
};

static gint ConfigurationEditor_private_offset;
static gpointer configuration_editor_parent_class = NULL;
static gboolean configuration_editor_disable_warning;
static gchar** configuration_editor_remaining;
static gint configuration_editor_remaining_length1;
VALA_EXTERN gchar** configuration_editor_internal_mappings;
VALA_EXTERN gint configuration_editor_internal_mappings_length1;
VALA_EXTERN gint configuration_editor_internal_mappings_length2;
gchar** configuration_editor_internal_mappings = NULL;
gint configuration_editor_internal_mappings_length1 = 0;
gint configuration_editor_internal_mappings_length2 = 0;
VALA_EXTERN gchar** configuration_editor_known_mappings;
VALA_EXTERN gint configuration_editor_known_mappings_length1;
VALA_EXTERN gint configuration_editor_known_mappings_length2;
gchar** configuration_editor_known_mappings = NULL;
gint configuration_editor_known_mappings_length1 = 0;
gint configuration_editor_known_mappings_length2 = 0;
static gchar** configuration_editor_skipped_schemas;
static gint configuration_editor_skipped_schemas_length1;
static gchar** configuration_editor_skipped_schemas = NULL;
static gint configuration_editor_skipped_schemas_length1 = 0;
static gint _configuration_editor_skipped_schemas_size_ = 0;
static gboolean configuration_editor_disable_warning = FALSE;
static gchar** configuration_editor_remaining = NULL;
static gint configuration_editor_remaining_length1 = 0;
static gint _configuration_editor_remaining_size_ = 0;
static BaseApplicationIface * configuration_editor_base_application_parent_iface = NULL;

VALA_EXTERN GType base_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseApplication, g_object_unref)
VALA_EXTERN GType configuration_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationEditor, g_object_unref)
static void configuration_editor_copy_cb (ConfigurationEditor* self,
                                   GSimpleAction* action,
                                   GVariant* gvariant);
static void _configuration_editor_copy_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void configuration_editor_quit_if_no_pending_changes (ConfigurationEditor* self);
static void _configuration_editor_quit_if_no_pending_changes_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                        GVariant* parameter,
                                                                                        gpointer self);
static void configuration_editor_apply_pending_changes_and_quit (ConfigurationEditor* self);
static void _configuration_editor_apply_pending_changes_and_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                            GVariant* parameter,
                                                                                            gpointer self);
static gint configuration_editor_main (gchar** args,
                                gint args_length1);
static ConfigurationEditor* configuration_editor_new (void);
static ConfigurationEditor* configuration_editor_construct (GType object_type);
static gint configuration_editor_real_handle_local_options (GApplication* base,
                                                     GVariantDict* options);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add17 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add19 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void configuration_editor_real_startup (GApplication* base);
static void configuration_editor_real_activate (GApplication* base);
static void configuration_editor_simple_activation (ConfigurationEditor* self);
static void configuration_editor_real_open (GApplication* base,
                                     GFile** files,
                                     gint files_length1,
                                     const gchar* hint);
static gint configuration_editor_real_command_line (GApplication* base,
                                             GApplicationCommandLine* commands);
static void _vala_array_add20 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gint configuration_editor_failure_space (ConfigurationEditor* self,
                                         GApplicationCommandLine* commands);
static gint configuration_editor_failure_double_slash (ConfigurationEditor* self,
                                                GApplicationCommandLine* commands);
static GtkWindow* configuration_editor_get_new_window (ConfigurationEditor* self,
                                                const gchar* schema,
                                                const gchar* path,
                                                const gchar* key_name);
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType base_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseWindow, g_object_unref)
VALA_EXTERN GType browser_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserWindow, g_object_unref)
VALA_EXTERN GType bookmarks_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksWindow, g_object_unref)
VALA_EXTERN GType dconf_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DConfWindow, g_object_unref)
VALA_EXTERN DConfWindow* dconf_window_new (gboolean disable_warning,
                               const gchar* schema,
                               const gchar* path,
                               const gchar* key_name);
VALA_EXTERN DConfWindow* dconf_window_construct (GType object_type,
                                     gboolean disable_warning,
                                     const gchar* schema,
                                     const gchar* path,
                                     const gchar* key_name);
VALA_EXTERN void base_application_copy (BaseApplication* self,
                            const gchar* text);
static void configuration_editor_real_copy (BaseApplication* base,
                                     const gchar* text);
VALA_EXTERN void configuration_editor_clean_copy_notification (ConfigurationEditor* self);
static gboolean __lambda22_ (ConfigurationEditor* self);
static gboolean ___lambda22__gsource_func (gpointer self);
VALA_EXTERN gboolean dconf_window_quit_if_no_pending_changes (DConfWindow* self);
VALA_EXTERN void dconf_window_apply_pending_changes_and_quit (DConfWindow* self);
static void configuration_editor_real_get_about_dialog_infos (BaseApplication* base,
                                                       gchar*** artists,
                                                       gint* artists_length1,
                                                       gchar*** authors,
                                                       gint* authors_length1,
                                                       gchar** comments,
                                                       gchar** copyright,
                                                       gchar*** documenters,
                                                       gint* documenters_length1,
                                                       gchar** logo_icon_name,
                                                       gchar** program_name,
                                                       gchar** translator_credits,
                                                       gchar** version,
                                                       gchar** website,
                                                       gchar** website_label);
VALA_EXTERN void base_application_get_about_dialog_infos (BaseApplication* self,
                                              gchar*** artists,
                                              gint* artists_length1,
                                              gchar*** authors,
                                              gint* authors_length1,
                                              gchar** comments,
                                              gchar** copyright,
                                              gchar*** documenters,
                                              gint* documenters_length1,
                                              gchar** logo_icon_name,
                                              gchar** program_name,
                                              gchar** translator_credits,
                                              gchar** version,
                                              gchar** website,
                                              gchar** website_label);
static void configuration_editor_finalize (GObject * obj);
static GType configuration_editor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GOptionEntry CONFIGURATION_EDITOR_option_entries[5] = {{"version", 'v', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {"list-relocatable-schemas", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Print relocatable schemas and exit"), NULL}, {"I-understand-that-changing-options-can-break-applications", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &configuration_editor_disable_warning, N_ ("Do not show initial warning"), NULL}, {G_OPTION_REMAINING, (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_STRING_ARRAY, &configuration_editor_remaining, "args", NULL}, {0}};
static const GActionEntry CONFIGURATION_EDITOR_action_entries[3] = {{"copy", _configuration_editor_copy_cb_gsimple_action_activate_callback, "s"}, {"quit", _configuration_editor_quit_if_no_pending_changes_gsimple_action_activate_callback}, {"apply-and-quit", _configuration_editor_apply_pending_changes_and_quit_gsimple_action_activate_callback}};

static inline gpointer
configuration_editor_get_instance_private (ConfigurationEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ConfigurationEditor_private_offset);
}

static void
_configuration_editor_copy_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	configuration_editor_copy_cb ((ConfigurationEditor*) self, action, parameter);
}

static void
_configuration_editor_quit_if_no_pending_changes_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self)
{
	configuration_editor_quit_if_no_pending_changes ((ConfigurationEditor*) self);
}

static void
_configuration_editor_apply_pending_changes_and_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                       GVariant* parameter,
                                                                                       gpointer self)
{
	configuration_editor_apply_pending_changes_and_quit ((ConfigurationEditor*) self);
}

static gint
configuration_editor_main (gchar** args,
                           gint args_length1)
{
	ConfigurationEditor* app = NULL;
	ConfigurationEditor* _tmp0_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = configuration_editor_new ();
	app = _tmp0_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return configuration_editor_main (argv, argc);
}

static ConfigurationEditor*
configuration_editor_construct (GType object_type)
{
	ConfigurationEditor * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	self = (ConfigurationEditor*) g_object_new (object_type, "application-id", "ca.desrt.dconf-editor", "flags", (G_APPLICATION_HANDLES_COMMAND_LINE | G_APPLICATION_HANDLES_OPEN) | G_APPLICATION_CAN_OVERRIDE_APP_ID, NULL);
	g_application_set_option_context_parameter_string ((GApplication*) self, "[ PATH | [FIXED_SCHEMA|RELOC_SCHEMA:DIR] [KEY] ]");
	_tmp0_ = g_strconcat (_ ("Graphical interface for editing other applications settings."), "\n\n", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, _ ("Uses the gsettings API of the glib library, among others."), NULL);
	_tmp3_ = _tmp2_;
	g_application_set_option_context_summary ((GApplication*) self, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = g_strconcat (_ ("Arguments description:"), "\n  PATH", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "\n    ", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, _ ("a folder path or a key path"), NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "\n    ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, _ ("example: “/org/gnome/” or “/ca/desrt/dconf-editor/Demo/boolean”"), NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "\n  FIXED_SCHEMA", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, "\n    ", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, _ ("the name of a schema with fixed path"), NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, "\n    ", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, _ ("example: “ca.desrt.dconf-editor.Settings”"), NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, "\n  RELOC_SCHEMA", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp25_, "\n    ", NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, _ ("the name of a “relocatable” schema, without fixed path"), NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, "\n    ", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp31_, _ ("see list with the “--list-relocatable-schemas” option"), NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, "\n  DIR", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat (_tmp35_, "\n    ", NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp37_, _ ("the path where to map the relocatable schema"), NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp39_, "\n    ", NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp41_, _ ("example: “ca.desrt.dconf-editor.Bookmarks:/ca/desrt/dconf-editor/”"), NULL);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strconcat (_tmp43_, "\n  KEY", NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strconcat (_tmp45_, "\n    ", NULL);
	_tmp47_ = _tmp46_;
	_tmp48_ = g_strconcat (_tmp47_, _ ("the name of a key from the schema"), NULL);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strconcat (_tmp49_, "\n    ", NULL);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat (_tmp51_, _ ("example: “bookmarks”"), NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_strconcat (_tmp53_, "\n", NULL);
	_tmp55_ = _tmp54_;
	g_application_set_option_context_description ((GApplication*) self, _tmp55_);
	_g_free0 (_tmp55_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	_g_free0 (_tmp49_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	g_application_add_main_option_entries ((GApplication*) self, CONFIGURATION_EDITOR_option_entries);
	return self;
}

static ConfigurationEditor*
configuration_editor_new (void)
{
	return configuration_editor_construct (TYPE_CONFIGURATION_EDITOR);
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add17 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add19 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gint
configuration_editor_real_handle_local_options (GApplication* base,
                                                GVariantDict* options)
{
	ConfigurationEditor * self;
	gint result;
	self = (ConfigurationEditor*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%1$s %2$s\n", "dconf-editor", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (g_variant_dict_contains (options, "list-relocatable-schemas")) {
		gchar** non_relocatable_schemas = NULL;
		gint non_relocatable_schemas_length1 = 0;
		gint _non_relocatable_schemas_size_ = 0;
		gchar** relocatable_schemas = NULL;
		gint relocatable_schemas_length1 = 0;
		gint _relocatable_schemas_size_ = 0;
		GSettingsSchemaSource* settings_schema_source = NULL;
		GSettingsSchemaSource* _tmp1_;
		GSettingsSchemaSource* _tmp2_;
		GSettingsSchemaSource* _tmp3_;
		GSettingsSchemaSource* _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gchar** known_schemas_installed = NULL;
		gchar** _tmp7_;
		gint known_schemas_installed_length1;
		gint _known_schemas_installed_size_;
		gchar** known_schemas_skipped = NULL;
		gchar** _tmp8_;
		gint known_schemas_skipped_length1;
		gint _known_schemas_skipped_size_;
		gchar** unknown_schemas = NULL;
		gchar** _tmp9_;
		gint unknown_schemas_length1;
		gint _unknown_schemas_size_;
		gchar** schemas_ids = NULL;
		gchar** _tmp10_;
		gint schemas_ids_length1;
		gint _schemas_ids_size_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		gchar** _tmp37_;
		gint _tmp37__length1;
		FILE* _tmp51_;
		gchar** _tmp52_;
		gint _tmp52__length1;
		FILE* _tmp66_;
		gchar** _tmp67_;
		gint _tmp67__length1;
		_tmp1_ = g_settings_schema_source_get_default ();
		_tmp2_ = _g_settings_schema_source_ref0 (_tmp1_);
		settings_schema_source = _tmp2_;
		_tmp3_ = settings_schema_source;
		if (_tmp3_ == NULL) {
			g_warning ("dconf-editor.vala:262: No schema source!");
			result = EXIT_FAILURE;
			_g_settings_schema_source_unref0 (settings_schema_source);
			relocatable_schemas = (_vala_array_free (relocatable_schemas, relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
			non_relocatable_schemas = (_vala_array_free (non_relocatable_schemas, non_relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp4_ = settings_schema_source;
		g_settings_schema_source_list_schemas ((GSettingsSchemaSource*) _tmp4_, TRUE, &_tmp5_, &_tmp6_);
		non_relocatable_schemas = (_vala_array_free (non_relocatable_schemas, non_relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
		non_relocatable_schemas = _tmp5_;
		non_relocatable_schemas_length1 = -1;
		_non_relocatable_schemas_size_ = non_relocatable_schemas_length1;
		non_relocatable_schemas_length1 = _vala_array_length (non_relocatable_schemas);
		relocatable_schemas = (_vala_array_free (relocatable_schemas, relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
		relocatable_schemas = _tmp6_;
		relocatable_schemas_length1 = -1;
		_relocatable_schemas_size_ = relocatable_schemas_length1;
		relocatable_schemas_length1 = _vala_array_length (relocatable_schemas);
		_tmp7_ = g_new0 (gchar*, 0 + 1);
		known_schemas_installed = _tmp7_;
		known_schemas_installed_length1 = 0;
		_known_schemas_installed_size_ = known_schemas_installed_length1;
		_tmp8_ = g_new0 (gchar*, 0 + 1);
		known_schemas_skipped = _tmp8_;
		known_schemas_skipped_length1 = 0;
		_known_schemas_skipped_size_ = known_schemas_skipped_length1;
		_tmp9_ = g_new0 (gchar*, 0 + 1);
		unknown_schemas = _tmp9_;
		unknown_schemas_length1 = 0;
		_unknown_schemas_size_ = unknown_schemas_length1;
		_tmp10_ = g_new0 (gchar*, 0 + 1);
		schemas_ids = _tmp10_;
		schemas_ids_length1 = 0;
		_schemas_ids_size_ = schemas_ids_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					gint _tmp13__length2;
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gint _tmp15__length2;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = configuration_editor_known_mappings;
					_tmp13__length1 = configuration_editor_known_mappings_length1;
					_tmp13__length2 = configuration_editor_known_mappings_length2;
					_tmp14_ = _tmp13__length1;
					if (!(i < _tmp14_)) {
						break;
					}
					_tmp15_ = configuration_editor_known_mappings;
					_tmp15__length1 = configuration_editor_known_mappings_length1;
					_tmp15__length2 = configuration_editor_known_mappings_length2;
					_tmp16_ = _tmp15_[(i * _tmp15__length2) + 0];
					_tmp17_ = g_strdup (_tmp16_);
					_vala_array_add15 (&schemas_ids, &schemas_ids_length1, &_schemas_ids_size_, _tmp17_);
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gchar** _tmp20_;
					gint _tmp20__length1;
					gint _tmp20__length2;
					gint _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					gint _tmp22__length2;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = configuration_editor_internal_mappings;
					_tmp20__length1 = configuration_editor_internal_mappings_length1;
					_tmp20__length2 = configuration_editor_internal_mappings_length2;
					_tmp21_ = _tmp20__length1;
					if (!(i < _tmp21_)) {
						break;
					}
					_tmp22_ = configuration_editor_internal_mappings;
					_tmp22__length1 = configuration_editor_internal_mappings_length1;
					_tmp22__length2 = configuration_editor_internal_mappings_length2;
					_tmp23_ = _tmp22_[(i * _tmp22__length2) + 0];
					_tmp24_ = g_strdup (_tmp23_);
					_vala_array_add16 (&schemas_ids, &schemas_ids_length1, &_schemas_ids_size_, _tmp24_);
				}
			}
		}
		_tmp25_ = relocatable_schemas;
		_tmp25__length1 = relocatable_schemas_length1;
		{
			gchar** schema_id_collection = NULL;
			gint schema_id_collection_length1 = 0;
			gint _schema_id_collection_size_ = 0;
			gint schema_id_it = 0;
			schema_id_collection = _tmp25_;
			schema_id_collection_length1 = _tmp25__length1;
			for (schema_id_it = 0; schema_id_it < schema_id_collection_length1; schema_id_it = schema_id_it + 1) {
				gchar* _tmp26_;
				gchar* schema_id = NULL;
				_tmp26_ = g_strdup (schema_id_collection[schema_id_it]);
				schema_id = _tmp26_;
				{
					const gchar* _tmp27_;
					gchar** _tmp28_;
					gint _tmp28__length1;
					_tmp27_ = schema_id;
					_tmp28_ = schemas_ids;
					_tmp28__length1 = schemas_ids_length1;
					if (_vala_string_array_contains (_tmp28_, _tmp28__length1, _tmp27_)) {
						const gchar* _tmp29_;
						gchar* _tmp30_;
						_tmp29_ = schema_id;
						_tmp30_ = g_strdup (_tmp29_);
						_vala_array_add17 (&known_schemas_installed, &known_schemas_installed_length1, &_known_schemas_installed_size_, _tmp30_);
					} else {
						const gchar* _tmp31_;
						gchar** _tmp32_;
						gint _tmp32__length1;
						_tmp31_ = schema_id;
						_tmp32_ = configuration_editor_skipped_schemas;
						_tmp32__length1 = configuration_editor_skipped_schemas_length1;
						if (_vala_string_array_contains (_tmp32_, _tmp32__length1, _tmp31_)) {
							const gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp33_ = schema_id;
							_tmp34_ = g_strdup (_tmp33_);
							_vala_array_add18 (&known_schemas_skipped, &known_schemas_skipped_length1, &_known_schemas_skipped_size_, _tmp34_);
						} else {
							const gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp35_ = schema_id;
							_tmp36_ = g_strdup (_tmp35_);
							_vala_array_add19 (&unknown_schemas, &unknown_schemas_length1, &_unknown_schemas_size_, _tmp36_);
						}
					}
					_g_free0 (schema_id);
				}
			}
		}
		_tmp37_ = known_schemas_installed;
		_tmp37__length1 = known_schemas_installed_length1;
		if (_tmp37__length1 > 0) {
			FILE* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar** _tmp41_;
			gint _tmp41__length1;
			_tmp38_ = stdout;
			_tmp39_ = g_strconcat (_ ("Known schemas installed:"), "\n", NULL);
			_tmp40_ = _tmp39_;
			fprintf (_tmp38_, "%s", _tmp40_);
			_g_free0 (_tmp40_);
			_tmp41_ = known_schemas_installed;
			_tmp41__length1 = known_schemas_installed_length1;
			{
				gchar** schema_id_collection = NULL;
				gint schema_id_collection_length1 = 0;
				gint _schema_id_collection_size_ = 0;
				gint schema_id_it = 0;
				schema_id_collection = _tmp41_;
				schema_id_collection_length1 = _tmp41__length1;
				for (schema_id_it = 0; schema_id_it < schema_id_collection_length1; schema_id_it = schema_id_it + 1) {
					gchar* _tmp42_;
					gchar* schema_id = NULL;
					_tmp42_ = g_strdup (schema_id_collection[schema_id_it]);
					schema_id = _tmp42_;
					{
						FILE* _tmp43_;
						const gchar* _tmp44_;
						const gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						_tmp43_ = stdout;
						_tmp44_ = schema_id;
						_tmp45_ = string_to_string (_tmp44_);
						_tmp46_ = g_strconcat ("  ", _tmp45_, "\n", NULL);
						_tmp47_ = _tmp46_;
						fprintf (_tmp43_, "%s", _tmp47_);
						_g_free0 (_tmp47_);
						_g_free0 (schema_id);
					}
				}
			}
		} else {
			FILE* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp48_ = stdout;
			_tmp49_ = g_strconcat (_ ("No known schemas installed."), "\n", NULL);
			_tmp50_ = _tmp49_;
			fprintf (_tmp48_, "%s", _tmp50_);
			_g_free0 (_tmp50_);
		}
		_tmp51_ = stdout;
		fprintf (_tmp51_, "\n");
		_tmp52_ = known_schemas_skipped;
		_tmp52__length1 = known_schemas_skipped_length1;
		if (_tmp52__length1 > 0) {
			FILE* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar** _tmp56_;
			gint _tmp56__length1;
			_tmp53_ = stdout;
			_tmp54_ = g_strconcat (_ ("Known schemas skipped:"), "\n", NULL);
			_tmp55_ = _tmp54_;
			fprintf (_tmp53_, "%s", _tmp55_);
			_g_free0 (_tmp55_);
			_tmp56_ = known_schemas_skipped;
			_tmp56__length1 = known_schemas_skipped_length1;
			{
				gchar** schema_id_collection = NULL;
				gint schema_id_collection_length1 = 0;
				gint _schema_id_collection_size_ = 0;
				gint schema_id_it = 0;
				schema_id_collection = _tmp56_;
				schema_id_collection_length1 = _tmp56__length1;
				for (schema_id_it = 0; schema_id_it < schema_id_collection_length1; schema_id_it = schema_id_it + 1) {
					gchar* _tmp57_;
					gchar* schema_id = NULL;
					_tmp57_ = g_strdup (schema_id_collection[schema_id_it]);
					schema_id = _tmp57_;
					{
						FILE* _tmp58_;
						const gchar* _tmp59_;
						const gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						_tmp58_ = stdout;
						_tmp59_ = schema_id;
						_tmp60_ = string_to_string (_tmp59_);
						_tmp61_ = g_strconcat ("  ", _tmp60_, "\n", NULL);
						_tmp62_ = _tmp61_;
						fprintf (_tmp58_, "%s", _tmp62_);
						_g_free0 (_tmp62_);
						_g_free0 (schema_id);
					}
				}
			}
		} else {
			FILE* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp63_ = stdout;
			_tmp64_ = g_strconcat (_ ("No known schemas skipped."), "\n", NULL);
			_tmp65_ = _tmp64_;
			fprintf (_tmp63_, "%s", _tmp65_);
			_g_free0 (_tmp65_);
		}
		_tmp66_ = stdout;
		fprintf (_tmp66_, "\n");
		_tmp67_ = unknown_schemas;
		_tmp67__length1 = unknown_schemas_length1;
		if (_tmp67__length1 > 0) {
			FILE* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar** _tmp71_;
			gint _tmp71__length1;
			_tmp68_ = stdout;
			_tmp69_ = g_strconcat (_ ("Unknown schemas:"), "\n", NULL);
			_tmp70_ = _tmp69_;
			fprintf (_tmp68_, "%s", _tmp70_);
			_g_free0 (_tmp70_);
			_tmp71_ = unknown_schemas;
			_tmp71__length1 = unknown_schemas_length1;
			{
				gchar** schema_id_collection = NULL;
				gint schema_id_collection_length1 = 0;
				gint _schema_id_collection_size_ = 0;
				gint schema_id_it = 0;
				schema_id_collection = _tmp71_;
				schema_id_collection_length1 = _tmp71__length1;
				for (schema_id_it = 0; schema_id_it < schema_id_collection_length1; schema_id_it = schema_id_it + 1) {
					gchar* _tmp72_;
					gchar* schema_id = NULL;
					_tmp72_ = g_strdup (schema_id_collection[schema_id_it]);
					schema_id = _tmp72_;
					{
						FILE* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						gchar* _tmp76_;
						gchar* _tmp77_;
						_tmp73_ = stdout;
						_tmp74_ = schema_id;
						_tmp75_ = string_to_string (_tmp74_);
						_tmp76_ = g_strconcat ("  ", _tmp75_, "\n", NULL);
						_tmp77_ = _tmp76_;
						fprintf (_tmp73_, "%s", _tmp77_);
						_g_free0 (_tmp77_);
						_g_free0 (schema_id);
					}
				}
			}
		} else {
			FILE* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			_tmp78_ = stdout;
			_tmp79_ = g_strconcat (_ ("No unknown schemas."), "\n", NULL);
			_tmp80_ = _tmp79_;
			fprintf (_tmp78_, "%s", _tmp80_);
			_g_free0 (_tmp80_);
		}
		result = EXIT_SUCCESS;
		schemas_ids = (_vala_array_free (schemas_ids, schemas_ids_length1, (GDestroyNotify) g_free), NULL);
		unknown_schemas = (_vala_array_free (unknown_schemas, unknown_schemas_length1, (GDestroyNotify) g_free), NULL);
		known_schemas_skipped = (_vala_array_free (known_schemas_skipped, known_schemas_skipped_length1, (GDestroyNotify) g_free), NULL);
		known_schemas_installed = (_vala_array_free (known_schemas_installed, known_schemas_installed_length1, (GDestroyNotify) g_free), NULL);
		_g_settings_schema_source_unref0 (settings_schema_source);
		relocatable_schemas = (_vala_array_free (relocatable_schemas, relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
		non_relocatable_schemas = (_vala_array_free (non_relocatable_schemas, non_relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = -1;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
configuration_editor_real_startup (GApplication* base)
{
	ConfigurationEditor * self;
	HdyStyleManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar* _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	gchar* _tmp44_;
	gchar** _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	gchar* _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gchar* _tmp62_;
	gchar** _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	gchar* _tmp65_;
	gchar** _tmp66_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	gchar* _tmp68_;
	gchar** _tmp69_;
	gchar** _tmp70_;
	gint _tmp70__length1;
	gchar* _tmp71_;
	gchar** _tmp72_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	gchar* _tmp74_;
	gchar** _tmp75_;
	gchar** _tmp76_;
	gint _tmp76__length1;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar** _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar** _tmp86_;
	gchar** _tmp87_;
	gint _tmp87__length1;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar** _tmp91_;
	gchar** _tmp92_;
	gint _tmp92__length1;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp93_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp94_;
	GdkScreen* _tmp95_;
	self = (ConfigurationEditor*) base;
	G_APPLICATION_CLASS (configuration_editor_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	hdy_init ();
	g_set_application_name (CONFIGURATION_EDITOR_PROGRAM_NAME);
	gtk_window_set_default_icon_name ("ca.desrt.dconf-editor");
	_tmp0_ = hdy_style_manager_get_default ();
	hdy_style_manager_set_color_scheme (_tmp0_, HDY_COLOR_SCHEME_PREFER_LIGHT);
	g_action_map_add_action_entries ((GActionMap*) self, CONFIGURATION_EDITOR_action_entries, (gint) G_N_ELEMENTS (CONFIGURATION_EDITOR_action_entries), self);
	_tmp1_ = g_strdup ("<Primary>b");
	_tmp2_ = g_strdup ("<Shift><Primary>b");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "bw.toggle-bookmark", _tmp4_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = g_strdup ("<Primary>c");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.copy", _tmp7_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = g_strdup ("<Shift><Primary>c");
	_tmp9_ = g_new0 (gchar*, 1 + 1);
	_tmp9_[0] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.copy-alt", _tmp10_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = g_strdup ("<Primary>d");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "bw.bookmark", _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = g_strdup ("<Shift><Primary>d");
	_tmp15_ = g_new0 (gchar*, 1 + 1);
	_tmp15_[0] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "bw.unbookmark", _tmp16_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = g_strdup ("<Primary>f");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.search-global(false)", _tmp19_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = g_strdup ("<Shift><Primary>f");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.search-local(false)", _tmp22_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = g_strdup ("<Primary><Alt>f");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.search-global(true)", _tmp25_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = g_strdup ("<Shift><Primary><Alt>f");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.search-local(true)", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = g_strdup ("<Primary>g");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.next-match", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("<Shift><Primary>g");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.previous-match", _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("<Alt>i");
	_tmp36_ = g_new0 (gchar*, 1 + 1);
	_tmp36_[0] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "kbd.modifications", _tmp37_);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = g_strdup ("<Primary>l");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.edit-path-end", _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = g_strdup ("<Shift><Primary>l");
	_tmp42_ = g_new0 (gchar*, 1 + 1);
	_tmp42_[0] = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.edit-path-last", _tmp43_);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	_tmp44_ = g_strdup ("<Primary>q");
	_tmp45_ = g_new0 (gchar*, 1 + 1);
	_tmp45_[0] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp46_);
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
	_tmp47_ = g_strdup ("<Shift><Primary>q");
	_tmp48_ = g_new0 (gchar*, 1 + 1);
	_tmp48_[0] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.apply-and-quit", _tmp49_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp50_ = g_strdup ("<Primary>v");
	_tmp51_ = g_new0 (gchar*, 1 + 1);
	_tmp51_[0] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.paste", _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = g_strdup ("<Shift><Primary>v");
	_tmp54_ = g_new0 (gchar*, 1 + 1);
	_tmp54_[0] = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.paste-alt", _tmp55_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = g_strdup ("<Shift><Alt>Up");
	_tmp57_ = g_new0 (gchar*, 1 + 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.open-root", _tmp58_);
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
	_tmp59_ = g_strdup ("<Alt>Up");
	_tmp60_ = g_new0 (gchar*, 1 + 1);
	_tmp60_[0] = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp61__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.open-parent", _tmp61_);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
	_tmp62_ = g_strdup ("<Alt>Down");
	_tmp63_ = g_new0 (gchar*, 1 + 1);
	_tmp63_[0] = _tmp62_;
	_tmp64_ = _tmp63_;
	_tmp64__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.open-child", _tmp64_);
	_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
	_tmp65_ = g_strdup ("<Shift><Alt>Down");
	_tmp66_ = g_new0 (gchar*, 1 + 1);
	_tmp66_[0] = _tmp65_;
	_tmp67_ = _tmp66_;
	_tmp67__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "key.open-last-child", _tmp67_);
	_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
	_tmp68_ = g_strdup ("Escape");
	_tmp69_ = g_new0 (gchar*, 1 + 1);
	_tmp69_[0] = _tmp68_;
	_tmp70_ = _tmp69_;
	_tmp70__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.escape", _tmp70_);
	_tmp70_ = (_vala_array_free (_tmp70_, _tmp70__length1, (GDestroyNotify) g_free), NULL);
	_tmp71_ = g_strdup ("F10");
	_tmp72_ = g_new0 (gchar*, 1 + 1);
	_tmp72_[0] = _tmp71_;
	_tmp73_ = _tmp72_;
	_tmp73__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.toggle-hamburger", _tmp73_);
	_tmp73_ = (_vala_array_free (_tmp73_, _tmp73__length1, (GDestroyNotify) g_free), NULL);
	_tmp74_ = g_strdup ("Menu");
	_tmp75_ = g_new0 (gchar*, 1 + 1);
	_tmp75_[0] = _tmp74_;
	_tmp76_ = _tmp75_;
	_tmp76__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "base.menu", _tmp76_);
	_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
	_tmp77_ = g_strdup ("<Primary>Delete");
	_tmp78_ = g_strdup ("<Primary>KP_Delete");
	_tmp79_ = g_strdup ("<Primary>decimalpoint");
	_tmp80_ = g_strdup ("<Primary>period");
	_tmp81_ = g_strdup ("<Primary>KP_Decimal");
	_tmp82_ = g_new0 (gchar*, 5 + 1);
	_tmp82_[0] = _tmp77_;
	_tmp82_[1] = _tmp78_;
	_tmp82_[2] = _tmp79_;
	_tmp82_[3] = _tmp80_;
	_tmp82_[4] = _tmp81_;
	_tmp83_ = _tmp82_;
	_tmp83__length1 = 5;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "kbd.set-to-default", _tmp83_);
	_tmp83_ = (_vala_array_free (_tmp83_, _tmp83__length1, (GDestroyNotify) g_free), NULL);
	_tmp84_ = g_strdup ("<Primary>Return");
	_tmp85_ = g_strdup ("<Primary>KP_Enter");
	_tmp86_ = g_new0 (gchar*, 2 + 1);
	_tmp86_[0] = _tmp84_;
	_tmp86_[1] = _tmp85_;
	_tmp87_ = _tmp86_;
	_tmp87__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "kbd.toggle-boolean", _tmp87_);
	_tmp87_ = (_vala_array_free (_tmp87_, _tmp87__length1, (GDestroyNotify) g_free), NULL);
	_tmp88_ = g_strdup ("F1");
	_tmp89_ = g_strdup ("<Primary>question");
	_tmp90_ = g_strdup ("<Shift><Primary>question");
	_tmp91_ = g_new0 (gchar*, 3 + 1);
	_tmp91_[0] = _tmp88_;
	_tmp91_[1] = _tmp89_;
	_tmp91_[2] = _tmp90_;
	_tmp92_ = _tmp91_;
	_tmp92__length1 = 3;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.show-help-overlay", _tmp92_);
	_tmp92_ = (_vala_array_free (_tmp92_, _tmp92__length1, (GDestroyNotify) g_free), NULL);
	_tmp93_ = gtk_css_provider_new ();
	css_provider = _tmp93_;
	gtk_css_provider_load_from_resource (css_provider, "/ca/desrt/dconf-editor/ui/dconf-editor.css");
	_tmp94_ = gdk_screen_get_default ();
	_tmp95_ = _g_object_ref0 (_tmp94_);
	screen = _tmp95_;
	g_return_if_fail (screen != NULL);
	gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (screen, gdk_screen_get_type (), GdkScreen), (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (screen);
	_g_object_unref0 (css_provider);
}

static void
configuration_editor_real_activate (GApplication* base)
{
	ConfigurationEditor * self;
	self = (ConfigurationEditor*) base;
	configuration_editor_simple_activation (self);
}

static void
configuration_editor_real_open (GApplication* base,
                                GFile** files,
                                gint files_length1,
                                const gchar* hint)
{
	ConfigurationEditor * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (ConfigurationEditor*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = g_strdup_printf ("%i", files_length1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Flatpak test, ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, " files.", NULL);
	_tmp5_ = _tmp4_;
	g_warning ("dconf-editor.vala:419: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	configuration_editor_simple_activation (self);
}

static void
_vala_array_add20 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
configuration_editor_real_command_line (GApplication* base,
                                        GApplicationCommandLine* commands)
{
	ConfigurationEditor * self;
	gchar** args = NULL;
	gchar** _tmp0_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GtkWindow* test_window = NULL;
	GtkWindow* _tmp7_;
	GtkWindow* _tmp8_;
	GtkWindow* _tmp9_;
	gchar* arg0 = NULL;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	const gchar* _tmp23_;
	gchar* key_name = NULL;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar** test_format = NULL;
	const gchar* _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gint test_format_length1;
	gint _test_format_size_;
	gchar* path = NULL;
	gchar** _tmp39_;
	gint _tmp39__length1;
	GtkWindow* window = NULL;
	gchar** _tmp47_;
	gint _tmp47__length1;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	GtkWindow* _tmp51_;
	GtkWindow* _tmp52_;
	gint result;
	self = (ConfigurationEditor*) base;
	g_return_val_if_fail (commands != NULL, 0);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	args = _tmp0_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp1_ = configuration_editor_remaining;
	_tmp1__length1 = configuration_editor_remaining_length1;
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp1_;
		i_collection_length1 = _tmp1__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			gchar* _tmp2_;
			gchar* i = NULL;
			_tmp2_ = g_strdup (i_collection[i_it]);
			i = _tmp2_;
			{
				const gchar* _tmp3_;
				_tmp3_ = i;
				if (_tmp3_ != NULL) {
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp4_ = i;
					_tmp5_ = g_strdup ((const gchar*) _tmp4_);
					_vala_array_add20 (&args, &args_length1, &_args_size_, _tmp5_);
				} else {
					_g_free0 (i);
					break;
				}
				_g_free0 (i);
			}
		}
	}
	_tmp6_ = args;
	_tmp6__length1 = args_length1;
	if (_tmp6__length1 == 0) {
		configuration_editor_simple_activation (self);
		result = EXIT_SUCCESS;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp7_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	test_window = _tmp8_;
	_tmp9_ = test_window;
	if (_tmp9_ != NULL) {
		GtkWindow* _tmp10_;
		g_application_command_line_print (commands, "%s", _ ("Only one window can be opened for now.\n"));
		_tmp10_ = test_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow));
		result = EXIT_FAILURE;
		_g_object_unref0 (test_window);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = args;
	_tmp11__length1 = args_length1;
	_tmp12_ = _tmp11_[0];
	_tmp13_ = g_strdup (_tmp12_);
	arg0 = _tmp13_;
	_tmp14_ = arg0;
	if (string_contains (_tmp14_, " ")) {
		gchar** _tmp15_;
		gint _tmp15__length1;
		_tmp15_ = args;
		_tmp15__length1 = args_length1;
		if (_tmp15__length1 == 1) {
			const gchar* _tmp16_;
			gchar** _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp16_ = arg0;
			_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, " ", 0);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			args = _tmp18_;
			args_length1 = _vala_array_length (_tmp17_);
			_args_size_ = args_length1;
			_tmp19_ = args;
			_tmp19__length1 = args_length1;
			_tmp20_ = _tmp19_[0];
			_tmp21_ = g_strdup (_tmp20_);
			_g_free0 (arg0);
			arg0 = _tmp21_;
		} else {
			result = configuration_editor_failure_space (self, commands);
			_g_free0 (arg0);
			_g_object_unref0 (test_window);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
	}
	_tmp22_ = args;
	_tmp22__length1 = args_length1;
	if (_tmp22__length1 > 2) {
		g_application_command_line_print (commands, "%s", _ ("Cannot understand: too many arguments.\n"));
		configuration_editor_simple_activation (self);
		result = EXIT_FAILURE;
		_g_free0 (arg0);
		_g_object_unref0 (test_window);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp23_ = arg0;
	if (g_str_has_prefix (_tmp23_, "/")) {
		const gchar* _tmp24_;
		GtkWindow* window = NULL;
		const gchar* _tmp25_;
		GtkWindow* _tmp26_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp24_ = arg0;
		if (string_contains (_tmp24_, "//")) {
			result = configuration_editor_failure_double_slash (self, commands);
			_g_free0 (arg0);
			_g_object_unref0 (test_window);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp25_ = arg0;
		_tmp26_ = configuration_editor_get_new_window (self, NULL, _tmp25_, NULL);
		window = _tmp26_;
		_tmp27_ = args;
		_tmp27__length1 = args_length1;
		if (_tmp27__length1 == 2) {
			GtkWindow* _tmp28_;
			g_application_command_line_print (commands, "%s", _ ("Cannot understand second argument in this context.\n"));
			_tmp28_ = window;
			gtk_window_present (_tmp28_);
			result = EXIT_FAILURE;
			_g_object_unref0 (window);
			_g_free0 (arg0);
			_g_object_unref0 (test_window);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			GtkWindow* _tmp29_;
			_tmp29_ = window;
			gtk_window_present (_tmp29_);
			result = EXIT_SUCCESS;
			_g_object_unref0 (window);
			_g_free0 (arg0);
			_g_object_unref0 (test_window);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_object_unref0 (window);
	}
	key_name = NULL;
	_tmp30_ = args;
	_tmp30__length1 = args_length1;
	if (_tmp30__length1 == 2) {
		gchar** _tmp31_;
		gint _tmp31__length1;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp31_ = args;
		_tmp31__length1 = args_length1;
		_tmp32_ = _tmp31_[1];
		_tmp33_ = g_strdup (_tmp32_);
		_g_free0 (key_name);
		key_name = _tmp33_;
		_tmp34_ = key_name;
		if (string_contains ((const gchar*) _tmp34_, " ")) {
			result = configuration_editor_failure_space (self, commands);
			_g_free0 (key_name);
			_g_free0 (arg0);
			_g_object_unref0 (test_window);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp35_ = key_name;
		if (string_contains ((const gchar*) _tmp35_, "/")) {
			g_application_command_line_print (commands, "%s", _ ("Cannot understand: slash character in second argument.\n"));
			configuration_editor_simple_activation (self);
			result = EXIT_FAILURE;
			_g_free0 (key_name);
			_g_free0 (arg0);
			_g_object_unref0 (test_window);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
	}
	_tmp36_ = arg0;
	_tmp38_ = _tmp37_ = g_strsplit (_tmp36_, ":", 2);
	test_format = _tmp38_;
	test_format_length1 = _vala_array_length (_tmp37_);
	_test_format_size_ = test_format_length1;
	path = NULL;
	_tmp39_ = test_format;
	_tmp39__length1 = test_format_length1;
	if (_tmp39__length1 == 2) {
		gchar** _tmp40_;
		gint _tmp40__length1;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gboolean _tmp43_ = FALSE;
		const gchar* _tmp44_;
		const gchar* _tmp46_;
		_tmp40_ = test_format;
		_tmp40__length1 = test_format_length1;
		_tmp41_ = _tmp40_[1];
		_tmp42_ = g_strdup (_tmp41_);
		_g_free0 (path);
		path = _tmp42_;
		_tmp44_ = path;
		if (!g_str_has_prefix ((const gchar*) _tmp44_, "/")) {
			_tmp43_ = TRUE;
		} else {
			const gchar* _tmp45_;
			_tmp45_ = path;
			_tmp43_ = !g_str_has_suffix ((const gchar*) _tmp45_, "/");
		}
		if (_tmp43_) {
			g_application_command_line_print (commands, "%s", _ ("Schema path should start and end with a “/”.\n"));
			configuration_editor_simple_activation (self);
			result = EXIT_FAILURE;
			_g_free0 (path);
			test_format = (_vala_array_free (test_format, test_format_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (key_name);
			_g_free0 (arg0);
			_g_object_unref0 (test_window);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp46_ = path;
		if (string_contains ((const gchar*) _tmp46_, "//")) {
			result = configuration_editor_failure_double_slash (self, commands);
			_g_free0 (path);
			test_format = (_vala_array_free (test_format, test_format_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (key_name);
			_g_free0 (arg0);
			_g_object_unref0 (test_window);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
	}
	_tmp47_ = test_format;
	_tmp47__length1 = test_format_length1;
	_tmp48_ = _tmp47_[0];
	_tmp49_ = path;
	_tmp50_ = key_name;
	_tmp51_ = configuration_editor_get_new_window (self, _tmp48_, _tmp49_, _tmp50_);
	window = _tmp51_;
	_tmp52_ = window;
	gtk_window_present (_tmp52_);
	result = EXIT_SUCCESS;
	_g_object_unref0 (window);
	_g_free0 (path);
	test_format = (_vala_array_free (test_format, test_format_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (key_name);
	_g_free0 (arg0);
	_g_object_unref0 (test_window);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gint
configuration_editor_failure_double_slash (ConfigurationEditor* self,
                                           GApplicationCommandLine* commands)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (commands != NULL, 0);
	g_application_command_line_print (commands, "%s", _ ("Cannot understand: given path contains “//”.\n"));
	configuration_editor_simple_activation (self);
	result = EXIT_FAILURE;
	return result;
}

static gint
configuration_editor_failure_space (ConfigurationEditor* self,
                                    GApplicationCommandLine* commands)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (commands != NULL, 0);
	g_application_command_line_print (commands, "%s", _ ("Cannot understand: space character in argument.\n"));
	configuration_editor_simple_activation (self);
	result = EXIT_FAILURE;
	return result;
}

static void
configuration_editor_simple_activation (ConfigurationEditor* self)
{
	GtkWindow* window = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = window;
	if (_tmp2_ == NULL) {
		GtkWindow* _tmp3_;
		_tmp3_ = configuration_editor_get_new_window (self, NULL, NULL, NULL);
		_g_object_unref0 (window);
		window = _tmp3_;
	}
	_tmp4_ = window;
	gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
	_g_object_unref0 (window);
}

static GtkWindow*
configuration_editor_get_new_window (ConfigurationEditor* self,
                                     const gchar* schema,
                                     const gchar* path,
                                     const gchar* key_name)
{
	DConfWindow* window = NULL;
	DConfWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dconf_window_new (configuration_editor_disable_warning, schema, path, key_name);
	g_object_ref_sink (_tmp0_);
	window = _tmp0_;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) window);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (window, gtk_window_get_type (), GtkWindow));
	result = _tmp1_;
	_g_object_unref0 (window);
	return result;
}

static void
configuration_editor_copy_cb (ConfigurationEditor* self,
                              GSimpleAction* action,
                              GVariant* gvariant)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (gvariant != NULL, "gvariant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) gvariant, NULL);
	_tmp1_ = g_strcompress (_tmp0_);
	_tmp2_ = _tmp1_;
	base_application_copy ((BaseApplication*) self, _tmp2_);
	_g_free0 (_tmp2_);
}

static gboolean
__lambda22_ (ConfigurationEditor* self)
{
	gboolean result;
	g_application_withdraw_notification ((GApplication*) self, "copy");
	self->priv->notification_number = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda22__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda22_ ((ConfigurationEditor*) self);
	return result;
}

static void
configuration_editor_real_copy (BaseApplication* base,
                                const gchar* text)
{
	ConfigurationEditor * self;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp3_;
	GtkClipboard* _tmp4_;
	GtkClipboard* _tmp5_;
	GtkClipboard* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GNotification* _tmp9_;
	GNotification* _tmp10_;
	self = (ConfigurationEditor*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (display);
		return;
	}
	_tmp3_ = display;
	_tmp4_ = gtk_clipboard_get_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_display_get_type (), GdkDisplay));
	_tmp5_ = _g_object_ref0 (_tmp4_);
	clipboard = _tmp5_;
	_tmp6_ = clipboard;
	_tmp7_ = strlen (text);
	_tmp8_ = _tmp7_;
	gtk_clipboard_set_text (_tmp6_, text, _tmp8_);
	configuration_editor_clean_copy_notification (self);
	self->priv->notification_number = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda22__gsource_func, g_object_ref (self), g_object_unref);
	_tmp9_ = self->priv->notification;
	g_notification_set_body (_tmp9_, text);
	_tmp10_ = self->priv->notification;
	g_application_send_notification ((GApplication*) self, "copy", _tmp10_);
	_g_object_unref0 (clipboard);
	_g_object_unref0 (display);
}

void
configuration_editor_clean_copy_notification (ConfigurationEditor* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->notification_number > ((guint) 0)) {
		g_application_withdraw_notification ((GApplication*) self, "copy");
		g_source_remove (self->priv->notification_number);
		self->priv->notification_number = (guint) 0;
	}
}

static void
configuration_editor_quit_if_no_pending_changes (ConfigurationEditor* self)
{
	GtkWindow* window = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp3_ = window;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GtkWindow* _tmp4_;
		_tmp4_ = window;
		_tmp2_ = dconf_window_quit_if_no_pending_changes (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), TYPE_DCONF_WINDOW, DConfWindow));
	}
	if (_tmp2_) {
		g_application_quit ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	}
	_g_object_unref0 (window);
}

static void
configuration_editor_apply_pending_changes_and_quit (ConfigurationEditor* self)
{
	GtkWindow* window = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = window;
	if (_tmp2_ != NULL) {
		GtkWindow* _tmp3_;
		_tmp3_ = window;
		dconf_window_apply_pending_changes_and_quit (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow), TYPE_DCONF_WINDOW, DConfWindow));
	}
	g_application_quit ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_g_object_unref0 (window);
}

static void
configuration_editor_real_get_about_dialog_infos (BaseApplication* base,
                                                  gchar*** artists,
                                                  gint* artists_length1,
                                                  gchar*** authors,
                                                  gint* authors_length1,
                                                  gchar** comments,
                                                  gchar** copyright,
                                                  gchar*** documenters,
                                                  gint* documenters_length1,
                                                  gchar** logo_icon_name,
                                                  gchar** program_name,
                                                  gchar** translator_credits,
                                                  gchar** version,
                                                  gchar** website,
                                                  gchar** website_label)
{
	ConfigurationEditor * self;
	gchar** _vala_artists = NULL;
	gint _vala_artists_length1 = 0;
	gchar** _vala_authors = NULL;
	gint _vala_authors_length1 = 0;
	gchar* _vala_comments = NULL;
	gchar* _vala_copyright = NULL;
	gchar** _vala_documenters = NULL;
	gint _vala_documenters_length1 = 0;
	gchar* _vala_logo_icon_name = NULL;
	gchar* _vala_program_name = NULL;
	gchar* _vala_translator_credits = NULL;
	gchar* _vala_version = NULL;
	gchar* _vala_website = NULL;
	gchar* _vala_website_label = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	self = (ConfigurationEditor*) base;
	_tmp0_ = g_strdup (_ ("A graphical viewer and editor of applications’ internal settings."));
	_g_free0 (_vala_comments);
	_vala_comments = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	_vala_artists = (_vala_array_free (_vala_artists, _vala_artists_length1, (GDestroyNotify) g_free), NULL);
	_vala_artists = _tmp1_;
	_vala_artists_length1 = 0;
	_tmp2_ = g_strdup (_ ("Robert Ancell"));
	_tmp3_ = g_strdup (_ ("Arnaud Bonatti"));
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	_vala_authors = (_vala_array_free (_vala_authors, _vala_authors_length1, (GDestroyNotify) g_free), NULL);
	_vala_authors = _tmp4_;
	_vala_authors_length1 = 2;
	_tmp5_ = g_strconcat (_ ("Copyright \xc2\xa9 2010-2014 – Canonical Ltd"), "\n", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, _ ("Copyright \xc2\xa9 2017-2018 – Davi da Silva Böger"), NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "\n", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Arnaud Bonatti"), (guint) 2015, (guint) 2020);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp10_, _tmp12_, NULL);
	_g_free0 (_vala_copyright);
	_vala_copyright = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp14_ = g_new0 (gchar*, 0 + 1);
	_vala_documenters = (_vala_array_free (_vala_documenters, _vala_documenters_length1, (GDestroyNotify) g_free), NULL);
	_vala_documenters = _tmp14_;
	_vala_documenters_length1 = 0;
	_tmp15_ = g_strdup ("ca.desrt.dconf-editor");
	_g_free0 (_vala_logo_icon_name);
	_vala_logo_icon_name = _tmp15_;
	_tmp16_ = g_strdup (CONFIGURATION_EDITOR_PROGRAM_NAME);
	_g_free0 (_vala_program_name);
	_vala_program_name = _tmp16_;
	_tmp17_ = g_strdup (_ ("translator-credits"));
	_g_free0 (_vala_translator_credits);
	_vala_translator_credits = _tmp17_;
	_tmp18_ = g_strdup (VERSION);
	_g_free0 (_vala_version);
	_vala_version = _tmp18_;
	_tmp19_ = g_strdup ("https://wiki.gnome.org/Apps/DconfEditor");
	_g_free0 (_vala_website);
	_vala_website = _tmp19_;
	_tmp20_ = g_strdup (_ ("Page on GNOME wiki"));
	_g_free0 (_vala_website_label);
	_vala_website_label = _tmp20_;
	if (artists) {
		*artists = _vala_artists;
	} else {
		_vala_artists = (_vala_array_free (_vala_artists, _vala_artists_length1, (GDestroyNotify) g_free), NULL);
	}
	if (artists_length1) {
		*artists_length1 = _vala_artists_length1;
	}
	if (authors) {
		*authors = _vala_authors;
	} else {
		_vala_authors = (_vala_array_free (_vala_authors, _vala_authors_length1, (GDestroyNotify) g_free), NULL);
	}
	if (authors_length1) {
		*authors_length1 = _vala_authors_length1;
	}
	if (comments) {
		*comments = _vala_comments;
	} else {
		_g_free0 (_vala_comments);
	}
	if (copyright) {
		*copyright = _vala_copyright;
	} else {
		_g_free0 (_vala_copyright);
	}
	if (documenters) {
		*documenters = _vala_documenters;
	} else {
		_vala_documenters = (_vala_array_free (_vala_documenters, _vala_documenters_length1, (GDestroyNotify) g_free), NULL);
	}
	if (documenters_length1) {
		*documenters_length1 = _vala_documenters_length1;
	}
	if (logo_icon_name) {
		*logo_icon_name = _vala_logo_icon_name;
	} else {
		_g_free0 (_vala_logo_icon_name);
	}
	if (program_name) {
		*program_name = _vala_program_name;
	} else {
		_g_free0 (_vala_program_name);
	}
	if (translator_credits) {
		*translator_credits = _vala_translator_credits;
	} else {
		_g_free0 (_vala_translator_credits);
	}
	if (version) {
		*version = _vala_version;
	} else {
		_g_free0 (_vala_version);
	}
	if (website) {
		*website = _vala_website;
	} else {
		_g_free0 (_vala_website);
	}
	if (website_label) {
		*website_label = _vala_website_label;
	} else {
		_g_free0 (_vala_website_label);
	}
}

static void
configuration_editor_class_init (ConfigurationEditorClass * klass,
                                 gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	gchar* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	gchar* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	gchar* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	gchar** _tmp147_;
	gchar* _tmp148_;
	gchar* _tmp149_;
	gchar* _tmp150_;
	gchar* _tmp151_;
	gchar* _tmp152_;
	gchar* _tmp153_;
	gchar* _tmp154_;
	gchar* _tmp155_;
	gchar* _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	gchar* _tmp159_;
	gchar* _tmp160_;
	gchar* _tmp161_;
	gchar** _tmp162_;
	gchar** _tmp163_;
	configuration_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConfigurationEditor_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) configuration_editor_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) configuration_editor_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) configuration_editor_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) configuration_editor_real_open;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) configuration_editor_real_command_line;
	G_OBJECT_CLASS (klass)->finalize = configuration_editor_finalize;
	_tmp0_ = g_strdup ("ca.desrt.dconf-editor.Bookmarks");
	_tmp1_ = g_strdup ("/ca/desrt/dconf-editor/");
	_tmp2_ = g_strdup ("ca.desrt.dconf-editor.Lib");
	_tmp3_ = g_strdup ("/ca/desrt/dconf-editor/");
	_tmp4_ = g_strdup ("ca.desrt.dconf-editor.Demo.EmptyRelocatable");
	_tmp5_ = g_strdup ("/ca/desrt/dconf-editor/Demo/EmptyRelocatable/");
	_tmp6_ = g_new0 (gchar*, (3 * 2) + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	configuration_editor_internal_mappings = _tmp6_;
	configuration_editor_internal_mappings_length1 = 3;
	configuration_editor_internal_mappings_length2 = 2;
	_tmp7_ = g_strdup ("com.gexperts.Tilix.Profile");
	_tmp8_ = g_strdup ("/com/gexperts/Tilix/profiles//");
	_tmp9_ = g_strdup ("org.gnome.builder.editor.language");
	_tmp10_ = g_strdup ("/org/gnome/builder/editor/language//");
	_tmp11_ = g_strdup ("org.gnome.builder.extension-type");
	_tmp12_ = g_strdup ("/org/gnome/builder/extension-types///");
	_tmp13_ = g_strdup ("org.gnome.desktop.app-folders.folder");
	_tmp14_ = g_strdup ("/org/gnome/desktop/app-folders/folders//");
	_tmp15_ = g_strdup ("org.gnome.desktop.notifications.application");
	_tmp16_ = g_strdup ("/org/gnome/desktop/notifications/application//");
	_tmp17_ = g_strdup ("org.gnome.libdevhelp-3.contents");
	_tmp18_ = g_strdup ("/org/gnome/devhelp/state/main/contents/");
	_tmp19_ = g_strdup ("org.gnome.libdevhelp-3.fonts");
	_tmp20_ = g_strdup ("/org/gnome/devhelp/fonts/");
	_tmp21_ = g_strdup ("org.gnome.Epiphany.state");
	_tmp22_ = g_strdup ("/org/gnome/epiphany/state/");
	_tmp23_ = g_strdup ("org.gnome.Epiphany.state");
	_tmp24_ = g_strdup ("/org/gnome/epiphany/web-apps//state/");
	_tmp25_ = g_strdup ("org.gnome.Epiphany.web");
	_tmp26_ = g_strdup ("/org/gnome/epiphany/web/");
	_tmp27_ = g_strdup ("org.gnome.Epiphany.web");
	_tmp28_ = g_strdup ("/org/gnome/epiphany/web-apps//web/");
	_tmp29_ = g_strdup ("org.gnome.Epiphany.webapp");
	_tmp30_ = g_strdup ("/org/gnome/epiphany/web-apps//webapp/");
	_tmp31_ = g_strdup ("org.gnome.nm-applet.eap");
	_tmp32_ = g_strdup ("/org/gnome/nm-applet/eap//");
	_tmp33_ = g_strdup ("org.gnome.seahorse.window");
	_tmp34_ = g_strdup ("/apps/seahorse/windows//");
	_tmp35_ = g_strdup ("org.gnome.settings-daemon.plugins.media-keys.custom-keybinding");
	_tmp36_ = g_strdup ("/org/gnome/settings-daemon/plugins/media-keys/custom-keybindings//");
	_tmp37_ = g_strdup ("org.gnome.settings-daemon.plugins.sharing.service");
	_tmp38_ = g_strdup ("/org/gnome/settings-daemon/plugins/sharing//");
	_tmp39_ = g_strdup ("org.gnome.software.auth");
	_tmp40_ = g_strdup ("/org/gnome/software/auth//");
	_tmp41_ = g_strdup ("org.gnome.Reversi.Lib");
	_tmp42_ = g_strdup ("/org/gnome/iagno/");
	_tmp43_ = g_strdup ("org.gnome.Taquin.Lib");
	_tmp44_ = g_strdup ("/org/gnome/taquin/");
	_tmp45_ = g_strdup ("org.gnome.Taquin.NightLight");
	_tmp46_ = g_strdup ("/org/gnome/taquin/");
	_tmp47_ = g_strdup ("org.gnome.Terminal.Legacy.Profile");
	_tmp48_ = g_strdup ("/org/gnome/terminal/legacy/profiles://");
	_tmp49_ = g_strdup ("org.gnome.Terminal.Legacy.Keybindings");
	_tmp50_ = g_strdup ("/org/gnome/terminal/legacy/keybindings/");
	_tmp51_ = g_strdup ("org.gnome.builder.plugin");
	_tmp52_ = g_strdup ("/org/gnome/builder/plugins/beautifier_plugin/");
	_tmp53_ = g_strdup ("org.gnome.builder.plugin");
	_tmp54_ = g_strdup ("/org/gnome/builder/plugins/cargo_plugin/");
	_tmp55_ = g_strdup ("org.gnome.builder.plugin");
	_tmp56_ = g_strdup ("/org/gnome/builder/plugins/clang-plugin/");
	_tmp57_ = g_strdup ("org.gnome.builder.plugin");
	_tmp58_ = g_strdup ("/org/gnome/builder/plugins/cmake_plugin/");
	_tmp59_ = g_strdup ("org.gnome.builder.plugin");
	_tmp60_ = g_strdup ("/org/gnome/builder/plugins/code-index-plugin/");
	_tmp61_ = g_strdup ("org.gnome.builder.plugin");
	_tmp62_ = g_strdup ("/org/gnome/builder/plugins/color-picker-plugin/");
	_tmp63_ = g_strdup ("org.gnome.builder.plugin");
	_tmp64_ = g_strdup ("/org/gnome/builder/plugins/comment-code-plugin/");
	_tmp65_ = g_strdup ("org.gnome.builder.plugin");
	_tmp66_ = g_strdup ("/org/gnome/builder/plugins/c-pack-plugin/");
	_tmp67_ = g_strdup ("org.gnome.builder.plugin");
	_tmp68_ = g_strdup ("/org/gnome/builder/plugins/ctags-plugin/");
	_tmp69_ = g_strdup ("org.gnome.builder.plugin");
	_tmp70_ = g_strdup ("/org/gnome/builder/plugins/devhelp-plugin/");
	_tmp71_ = g_strdup ("org.gnome.builder.plugin");
	_tmp72_ = g_strdup ("/org/gnome/builder/plugins/documentation-card-plugin/");
	_tmp73_ = g_strdup ("org.gnome.builder.plugin");
	_tmp74_ = g_strdup ("/org/gnome/builder/plugins/eslint_plugin/");
	_tmp75_ = g_strdup ("org.gnome.builder.plugin");
	_tmp76_ = g_strdup ("/org/gnome/builder/plugins/find_other_file/");
	_tmp77_ = g_strdup ("org.gnome.builder.plugin");
	_tmp78_ = g_strdup ("/org/gnome/builder/plugins/flatpak-plugin/");
	_tmp79_ = g_strdup ("org.gnome.builder.plugin");
	_tmp80_ = g_strdup ("/org/gnome/builder/plugins/gcc-plugin/");
	_tmp81_ = g_strdup ("org.gnome.builder.plugin");
	_tmp82_ = g_strdup ("/org/gnome/builder/plugins/gdb-plugin/");
	_tmp83_ = g_strdup ("org.gnome.builder.plugin");
	_tmp84_ = g_strdup ("/org/gnome/builder/plugins/gettext-plugin/");
	_tmp85_ = g_strdup ("org.gnome.builder.plugin");
	_tmp86_ = g_strdup ("/org/gnome/builder/plugins/gnome-code-assistance-plugin/");
	_tmp87_ = g_strdup ("org.gnome.builder.plugin");
	_tmp88_ = g_strdup ("/org/gnome/builder/plugins/history-plugin/");
	_tmp89_ = g_strdup ("org.gnome.builder.plugin");
	_tmp90_ = g_strdup ("/org/gnome/builder/plugins/html-completion-plugin/");
	_tmp91_ = g_strdup ("org.gnome.builder.plugin");
	_tmp92_ = g_strdup ("/org/gnome/builder/plugins/html_preview_plugin/");
	_tmp93_ = g_strdup ("org.gnome.builder.plugin");
	_tmp94_ = g_strdup ("/org/gnome/builder/plugins/jedi_plugin/");
	_tmp95_ = g_strdup ("org.gnome.builder.plugin");
	_tmp96_ = g_strdup ("/org/gnome/builder/plugins/jhbuild_plugin/");
	_tmp97_ = g_strdup ("org.gnome.builder.plugin");
	_tmp98_ = g_strdup ("/org/gnome/builder/plugins/make_plugin/");
	_tmp99_ = g_strdup ("org.gnome.builder.plugin");
	_tmp100_ = g_strdup ("/org/gnome/builder/plugins/meson_plugin/");
	_tmp101_ = g_strdup ("org.gnome.builder.plugin");
	_tmp102_ = g_strdup ("/org/gnome/builder/plugins/mingw-plugin/");
	_tmp103_ = g_strdup ("org.gnome.builder.plugin");
	_tmp104_ = g_strdup ("/org/gnome/builder/plugins/mono_plugin/");
	_tmp105_ = g_strdup ("org.gnome.builder.plugin");
	_tmp106_ = g_strdup ("/org/gnome/builder/plugins/notification-plugin/");
	_tmp107_ = g_strdup ("org.gnome.builder.plugin");
	_tmp108_ = g_strdup ("/org/gnome/builder/plugins/npm_plugin/");
	_tmp109_ = g_strdup ("org.gnome.builder.plugin");
	_tmp110_ = g_strdup ("/org/gnome/builder/plugins/phpize_plugin/");
	_tmp111_ = g_strdup ("org.gnome.builder.plugin");
	_tmp112_ = g_strdup ("/org/gnome/builder/plugins/python_gi_imports_completion/");
	_tmp113_ = g_strdup ("org.gnome.builder.plugin");
	_tmp114_ = g_strdup ("/org/gnome/builder/plugins/python-pack-plugin/");
	_tmp115_ = g_strdup ("org.gnome.builder.plugin");
	_tmp116_ = g_strdup ("/org/gnome/builder/plugins/quick-highlight-plugin/");
	_tmp117_ = g_strdup ("org.gnome.builder.plugin");
	_tmp118_ = g_strdup ("/org/gnome/builder/plugins/retab-plugin/");
	_tmp119_ = g_strdup ("org.gnome.builder.plugin");
	_tmp120_ = g_strdup ("/org/gnome/builder/plugins/rust_langserv_plugin/");
	_tmp121_ = g_strdup ("org.gnome.builder.plugin");
	_tmp122_ = g_strdup ("/org/gnome/builder/plugins/rustup_plugin/");
	_tmp123_ = g_strdup ("org.gnome.builder.plugin");
	_tmp124_ = g_strdup ("/org/gnome/builder/plugins/spellcheck-plugin/");
	_tmp125_ = g_strdup ("org.gnome.builder.plugin");
	_tmp126_ = g_strdup ("/org/gnome/builder/plugins/symbol-tree-plugin/");
	_tmp127_ = g_strdup ("org.gnome.builder.plugin");
	_tmp128_ = g_strdup ("/org/gnome/builder/plugins/sysmon/");
	_tmp129_ = g_strdup ("org.gnome.builder.plugin");
	_tmp130_ = g_strdup ("/org/gnome/builder/plugins/sysprof-plugin/");
	_tmp131_ = g_strdup ("org.gnome.builder.plugin");
	_tmp132_ = g_strdup ("/org/gnome/builder/plugins/terminal/");
	_tmp133_ = g_strdup ("org.gnome.builder.plugin");
	_tmp134_ = g_strdup ("/org/gnome/builder/plugins/todo-plugin/");
	_tmp135_ = g_strdup ("org.gnome.builder.plugin");
	_tmp136_ = g_strdup ("/org/gnome/builder/plugins/vala-pack-plugin/");
	_tmp137_ = g_strdup ("org.gnome.builder.plugin");
	_tmp138_ = g_strdup ("/org/gnome/builder/plugins/valgrind_plugin/");
	_tmp139_ = g_strdup ("org.gnome.builder.plugin");
	_tmp140_ = g_strdup ("/org/gnome/builder/plugins/xml-pack-plugin/");
	_tmp141_ = g_strdup ("org.mate.panel.object");
	_tmp142_ = g_strdup ("/org/mate/panel/objects//");
	_tmp143_ = g_strdup ("org.mate.panel.toplevel");
	_tmp144_ = g_strdup ("/org/mate/panel/toplevels//");
	_tmp145_ = g_strdup ("org.mate.panel.toplevel.background");
	_tmp146_ = g_strdup ("/org/mate/panel/toplevels//background/");
	_tmp147_ = g_new0 (gchar*, (70 * 2) + 1);
	_tmp147_[0] = _tmp7_;
	_tmp147_[1] = _tmp8_;
	_tmp147_[2] = _tmp9_;
	_tmp147_[3] = _tmp10_;
	_tmp147_[4] = _tmp11_;
	_tmp147_[5] = _tmp12_;
	_tmp147_[6] = _tmp13_;
	_tmp147_[7] = _tmp14_;
	_tmp147_[8] = _tmp15_;
	_tmp147_[9] = _tmp16_;
	_tmp147_[10] = _tmp17_;
	_tmp147_[11] = _tmp18_;
	_tmp147_[12] = _tmp19_;
	_tmp147_[13] = _tmp20_;
	_tmp147_[14] = _tmp21_;
	_tmp147_[15] = _tmp22_;
	_tmp147_[16] = _tmp23_;
	_tmp147_[17] = _tmp24_;
	_tmp147_[18] = _tmp25_;
	_tmp147_[19] = _tmp26_;
	_tmp147_[20] = _tmp27_;
	_tmp147_[21] = _tmp28_;
	_tmp147_[22] = _tmp29_;
	_tmp147_[23] = _tmp30_;
	_tmp147_[24] = _tmp31_;
	_tmp147_[25] = _tmp32_;
	_tmp147_[26] = _tmp33_;
	_tmp147_[27] = _tmp34_;
	_tmp147_[28] = _tmp35_;
	_tmp147_[29] = _tmp36_;
	_tmp147_[30] = _tmp37_;
	_tmp147_[31] = _tmp38_;
	_tmp147_[32] = _tmp39_;
	_tmp147_[33] = _tmp40_;
	_tmp147_[34] = _tmp41_;
	_tmp147_[35] = _tmp42_;
	_tmp147_[36] = _tmp43_;
	_tmp147_[37] = _tmp44_;
	_tmp147_[38] = _tmp45_;
	_tmp147_[39] = _tmp46_;
	_tmp147_[40] = _tmp47_;
	_tmp147_[41] = _tmp48_;
	_tmp147_[42] = _tmp49_;
	_tmp147_[43] = _tmp50_;
	_tmp147_[44] = _tmp51_;
	_tmp147_[45] = _tmp52_;
	_tmp147_[46] = _tmp53_;
	_tmp147_[47] = _tmp54_;
	_tmp147_[48] = _tmp55_;
	_tmp147_[49] = _tmp56_;
	_tmp147_[50] = _tmp57_;
	_tmp147_[51] = _tmp58_;
	_tmp147_[52] = _tmp59_;
	_tmp147_[53] = _tmp60_;
	_tmp147_[54] = _tmp61_;
	_tmp147_[55] = _tmp62_;
	_tmp147_[56] = _tmp63_;
	_tmp147_[57] = _tmp64_;
	_tmp147_[58] = _tmp65_;
	_tmp147_[59] = _tmp66_;
	_tmp147_[60] = _tmp67_;
	_tmp147_[61] = _tmp68_;
	_tmp147_[62] = _tmp69_;
	_tmp147_[63] = _tmp70_;
	_tmp147_[64] = _tmp71_;
	_tmp147_[65] = _tmp72_;
	_tmp147_[66] = _tmp73_;
	_tmp147_[67] = _tmp74_;
	_tmp147_[68] = _tmp75_;
	_tmp147_[69] = _tmp76_;
	_tmp147_[70] = _tmp77_;
	_tmp147_[71] = _tmp78_;
	_tmp147_[72] = _tmp79_;
	_tmp147_[73] = _tmp80_;
	_tmp147_[74] = _tmp81_;
	_tmp147_[75] = _tmp82_;
	_tmp147_[76] = _tmp83_;
	_tmp147_[77] = _tmp84_;
	_tmp147_[78] = _tmp85_;
	_tmp147_[79] = _tmp86_;
	_tmp147_[80] = _tmp87_;
	_tmp147_[81] = _tmp88_;
	_tmp147_[82] = _tmp89_;
	_tmp147_[83] = _tmp90_;
	_tmp147_[84] = _tmp91_;
	_tmp147_[85] = _tmp92_;
	_tmp147_[86] = _tmp93_;
	_tmp147_[87] = _tmp94_;
	_tmp147_[88] = _tmp95_;
	_tmp147_[89] = _tmp96_;
	_tmp147_[90] = _tmp97_;
	_tmp147_[91] = _tmp98_;
	_tmp147_[92] = _tmp99_;
	_tmp147_[93] = _tmp100_;
	_tmp147_[94] = _tmp101_;
	_tmp147_[95] = _tmp102_;
	_tmp147_[96] = _tmp103_;
	_tmp147_[97] = _tmp104_;
	_tmp147_[98] = _tmp105_;
	_tmp147_[99] = _tmp106_;
	_tmp147_[100] = _tmp107_;
	_tmp147_[101] = _tmp108_;
	_tmp147_[102] = _tmp109_;
	_tmp147_[103] = _tmp110_;
	_tmp147_[104] = _tmp111_;
	_tmp147_[105] = _tmp112_;
	_tmp147_[106] = _tmp113_;
	_tmp147_[107] = _tmp114_;
	_tmp147_[108] = _tmp115_;
	_tmp147_[109] = _tmp116_;
	_tmp147_[110] = _tmp117_;
	_tmp147_[111] = _tmp118_;
	_tmp147_[112] = _tmp119_;
	_tmp147_[113] = _tmp120_;
	_tmp147_[114] = _tmp121_;
	_tmp147_[115] = _tmp122_;
	_tmp147_[116] = _tmp123_;
	_tmp147_[117] = _tmp124_;
	_tmp147_[118] = _tmp125_;
	_tmp147_[119] = _tmp126_;
	_tmp147_[120] = _tmp127_;
	_tmp147_[121] = _tmp128_;
	_tmp147_[122] = _tmp129_;
	_tmp147_[123] = _tmp130_;
	_tmp147_[124] = _tmp131_;
	_tmp147_[125] = _tmp132_;
	_tmp147_[126] = _tmp133_;
	_tmp147_[127] = _tmp134_;
	_tmp147_[128] = _tmp135_;
	_tmp147_[129] = _tmp136_;
	_tmp147_[130] = _tmp137_;
	_tmp147_[131] = _tmp138_;
	_tmp147_[132] = _tmp139_;
	_tmp147_[133] = _tmp140_;
	_tmp147_[134] = _tmp141_;
	_tmp147_[135] = _tmp142_;
	_tmp147_[136] = _tmp143_;
	_tmp147_[137] = _tmp144_;
	_tmp147_[138] = _tmp145_;
	_tmp147_[139] = _tmp146_;
	configuration_editor_known_mappings = _tmp147_;
	configuration_editor_known_mappings_length1 = 70;
	configuration_editor_known_mappings_length2 = 2;
	_tmp148_ = g_strdup ("ca.desrt.dconf-editor.Demo.Relocatable");
	_tmp149_ = g_strdup ("org.gnome.Epiphany.permissions");
	_tmp150_ = g_strdup ("org.gnome.yelp.documents");
	_tmp151_ = g_strdup ("org.gnome.settings-daemon.peripherals.keyboard.deprecated");
	_tmp152_ = g_strdup ("org.gnome.settings-daemon.peripherals.mouse.deprecated");
	_tmp153_ = g_strdup ("org.gnome.settings-daemon.peripherals.touchpad.deprecated");
	_tmp154_ = g_strdup ("org.gnome.settings-daemon.peripherals.trackball.deprecated");
	_tmp155_ = g_strdup ("org.gnome.settings-daemon.peripherals.wacom.deprecated");
	_tmp156_ = g_strdup ("org.gnome.settings-daemon.peripherals.wacom.eraser.deprecated");
	_tmp157_ = g_strdup ("org.gnome.settings-daemon.peripherals.wacom.stylus.deprecated");
	_tmp158_ = g_strdup ("org.gnome.settings-daemon.peripherals.wacom.tablet-button.deprecated");
	_tmp159_ = g_strdup ("com.gexperts.Tilix.SettingsList");
	_tmp160_ = g_strdup ("org.gnome.Terminal.SettingsList");
	_tmp161_ = g_strdup ("org.gnome.libdevhelp-3");
	_tmp162_ = g_new0 (gchar*, 14 + 1);
	_tmp162_[0] = _tmp148_;
	_tmp162_[1] = _tmp149_;
	_tmp162_[2] = _tmp150_;
	_tmp162_[3] = _tmp151_;
	_tmp162_[4] = _tmp152_;
	_tmp162_[5] = _tmp153_;
	_tmp162_[6] = _tmp154_;
	_tmp162_[7] = _tmp155_;
	_tmp162_[8] = _tmp156_;
	_tmp162_[9] = _tmp157_;
	_tmp162_[10] = _tmp158_;
	_tmp162_[11] = _tmp159_;
	_tmp162_[12] = _tmp160_;
	_tmp162_[13] = _tmp161_;
	configuration_editor_skipped_schemas = _tmp162_;
	configuration_editor_skipped_schemas_length1 = 14;
	_tmp163_ = g_new0 (gchar*, 3 + 1);
	configuration_editor_remaining = _tmp163_;
	configuration_editor_remaining_length1 = 3;
}

static void
configuration_editor_base_application_interface_init (BaseApplicationIface * iface,
                                                      gpointer iface_data)
{
	configuration_editor_base_application_parent_iface = g_type_interface_peek_parent (iface);
	iface->copy = (void (*) (BaseApplication*, const gchar*)) configuration_editor_real_copy;
	iface->get_about_dialog_infos = (void (*) (BaseApplication*, gchar***, gint*, gchar***, gint*, gchar**, gchar**, gchar***, gint*, gchar**, gchar**, gchar**, gchar**, gchar**, gchar**)) configuration_editor_real_get_about_dialog_infos;
}

static void
configuration_editor_instance_init (ConfigurationEditor * self,
                                    gpointer klass)
{
	GNotification* _tmp0_;
	self->priv = configuration_editor_get_instance_private (self);
	self->priv->notification_number = (guint) 0;
	_tmp0_ = g_notification_new (_ ("Copied to clipboard"));
	self->priv->notification = _tmp0_;
}

static void
configuration_editor_finalize (GObject * obj)
{
	ConfigurationEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (configuration_editor_parent_class)->finalize (obj);
}

static GType
configuration_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConfigurationEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) configuration_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigurationEditor), 0, (GInstanceInitFunc) configuration_editor_instance_init, NULL };
	static const GInterfaceInfo base_application_info = { (GInterfaceInitFunc) configuration_editor_base_application_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType configuration_editor_type_id;
	configuration_editor_type_id = g_type_register_static (gtk_application_get_type (), "ConfigurationEditor", &g_define_type_info, 0);
	g_type_add_interface_static (configuration_editor_type_id, TYPE_BASE_APPLICATION, &base_application_info);
	ConfigurationEditor_private_offset = g_type_add_instance_private (configuration_editor_type_id, sizeof (ConfigurationEditorPrivate));
	return configuration_editor_type_id;
}

GType
configuration_editor_get_type (void)
{
	static volatile gsize configuration_editor_type_id__once = 0;
	if (g_once_init_enter (&configuration_editor_type_id__once)) {
		GType configuration_editor_type_id;
		configuration_editor_type_id = configuration_editor_get_type_once ();
		g_once_init_leave (&configuration_editor_type_id__once, configuration_editor_type_id);
	}
	return configuration_editor_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

