/* tracker-json-cursor.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-json-cursor.vala, do not modify */

/*
 * Copyright (C) 2016 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Carlos Garnacho <carlosg@gnome.org>
 */

#include "tracker-remote.h"
#include "libtracker-sparql/tracker-generated-no-checks.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

#define TRACKER_REMOTE_JSON_CURSOR_XSD_NS "http://www.w3.org/2001/XMLSchema#"

enum  {
	TRACKER_REMOTE_JSON_CURSOR_0_PROPERTY,
	TRACKER_REMOTE_JSON_CURSOR_N_COLUMNS_PROPERTY,
	TRACKER_REMOTE_JSON_CURSOR_NUM_PROPERTIES
};
static GParamSpec* tracker_remote_json_cursor_properties[TRACKER_REMOTE_JSON_CURSOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _TrackerRemoteJsonCursorNextAsyncData TrackerRemoteJsonCursorNextAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerRemoteJsonCursorNextAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerRemoteJsonCursor* self;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GError* _inner_error0_;
};

static gpointer tracker_remote_json_cursor_parent_class = NULL;

static TrackerSparqlValueType tracker_remote_json_cursor_real_get_value_type (TrackerSparqlCursor* base,
                                                                       gint column);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static const gchar* tracker_remote_json_cursor_real_get_variable_name (TrackerSparqlCursor* base,
                                                                gint column);
static const gchar* tracker_remote_json_cursor_real_get_string (TrackerSparqlCursor* base,
                                                         gint column,
                                                         glong* length);
static gboolean tracker_remote_json_cursor_real_next (TrackerSparqlCursor* base,
                                               GCancellable* cancellable,
                                               GError** error);
static void tracker_remote_json_cursor_real_next_async_data_free (gpointer _data);
static void tracker_remote_json_cursor_real_next_async (TrackerSparqlCursor* base,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean tracker_remote_json_cursor_real_next_async_co (TrackerRemoteJsonCursorNextAsyncData* _data_);
static void tracker_remote_json_cursor_real_rewind (TrackerSparqlCursor* base);
static void tracker_remote_json_cursor_real_close (TrackerSparqlCursor* base);
static void tracker_remote_json_cursor_finalize (GObject * obj);
static GType tracker_remote_json_cursor_get_type_once (void);
static void _vala_tracker_remote_json_cursor_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);

static gpointer
_json_object_ref0 (gpointer self)
{
#line 36 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return self ? json_object_ref (self) : NULL;
#line 98 "tracker-json-cursor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 40 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return self ? g_object_ref (self) : NULL;
#line 106 "tracker-json-cursor.c"
}

static gpointer
_json_array_ref0 (gpointer self)
{
#line 41 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return self ? json_array_ref (self) : NULL;
#line 114 "tracker-json-cursor.c"
}

TrackerRemoteJsonCursor*
tracker_remote_json_cursor_construct (GType object_type,
                                      const gchar* document,
                                      glong length,
                                      GError** error)
{
	TrackerRemoteJsonCursor * self = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	JsonObject* root = NULL;
	JsonNode* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
	JsonObject* head = NULL;
	JsonObject* _tmp4_;
	JsonObject* _tmp5_;
	JsonObject* _tmp6_;
	JsonObject* results = NULL;
	JsonObject* _tmp7_;
	JsonObject* _tmp8_;
	JsonObject* _tmp9_;
	JsonParser* _tmp10_;
	JsonObject* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	JsonObject* _tmp14_;
	JsonArray* _tmp15_;
	JsonArray* _tmp16_;
	GError* _inner_error0_ = NULL;
#line 32 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	g_return_val_if_fail (document != NULL, NULL);
#line 32 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) tracker_sparql_cursor_construct (object_type);
#line 33 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp0_ = json_parser_new ();
#line 33 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	parser = _tmp0_;
#line 34 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	json_parser_load_from_data (parser, document, (gssize) length, &_inner_error0_);
#line 34 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 34 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		g_propagate_error (error, _inner_error0_);
#line 34 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		_g_object_unref0 (parser);
#line 34 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		_g_object_unref0 (self);
#line 34 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		return NULL;
#line 166 "tracker-json-cursor.c"
	}
#line 36 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp1_ = json_parser_get_root (parser);
#line 36 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp2_ = json_node_get_object (_tmp1_);
#line 36 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp3_ = _json_object_ref0 (_tmp2_);
#line 36 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	root = _tmp3_;
#line 37 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp4_ = root;
#line 37 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp5_ = json_object_get_object_member (_tmp4_, "head");
#line 37 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp6_ = _json_object_ref0 (_tmp5_);
#line 37 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	head = _tmp6_;
#line 38 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp7_ = root;
#line 38 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp8_ = json_object_get_object_member (_tmp7_, "results");
#line 38 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp9_ = _json_object_ref0 (_tmp8_);
#line 38 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	results = _tmp9_;
#line 40 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp10_ = _g_object_ref0 (parser);
#line 40 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_g_object_unref0 (self->_parser);
#line 40 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_parser = _tmp10_;
#line 41 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp11_ = head;
#line 41 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp12_ = json_object_get_array_member (_tmp11_, "vars");
#line 41 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp13_ = _json_array_ref0 (_tmp12_);
#line 41 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_array_unref0 (self->_vars);
#line 41 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_vars = _tmp13_;
#line 42 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp14_ = results;
#line 42 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp15_ = json_object_get_array_member (_tmp14_, "bindings");
#line 42 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp16_ = _json_array_ref0 (_tmp15_);
#line 42 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_array_unref0 (self->_results);
#line 42 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_results = _tmp16_;
#line 43 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_started_iterating = FALSE;
#line 32 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_object_unref0 (results);
#line 32 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_object_unref0 (head);
#line 32 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_object_unref0 (root);
#line 32 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_g_object_unref0 (parser);
#line 32 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return self;
#line 230 "tracker-json-cursor.c"
}

TrackerRemoteJsonCursor*
tracker_remote_json_cursor_new (const gchar* document,
                                glong length,
                                GError** error)
{
#line 32 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return tracker_remote_json_cursor_construct (TRACKER_REMOTE_TYPE_JSON_CURSOR, document, length, error);
#line 240 "tracker-json-cursor.c"
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
#line 51 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return g_boxed_copy (json_node_get_type (), self);
#line 248 "tracker-json-cursor.c"
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
#line 51 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return self ? _vala_JsonNode_copy (self) : NULL;
#line 256 "tracker-json-cursor.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 54 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	g_boxed_free (json_node_get_type (), self);
#line 264 "tracker-json-cursor.c"
}

static TrackerSparqlValueType
tracker_remote_json_cursor_real_get_value_type (TrackerSparqlCursor* base,
                                                gint column)
{
	TrackerRemoteJsonCursor * self;
	JsonObject* _tmp0_;
	JsonNode* col_node = NULL;
	JsonObject* _tmp1_;
	const gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* _tmp5_;
	JsonObject* object = NULL;
	JsonNode* _tmp6_;
	JsonObject* _tmp7_;
	JsonObject* _tmp8_;
	const gchar* str = NULL;
	JsonObject* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GQuark _tmp14_ = 0U;
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	static GQuark _tmp13_label0 = 0;
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	static GQuark _tmp13_label1 = 0;
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	static GQuark _tmp13_label2 = 0;
#line 295 "tracker-json-cursor.c"
	TrackerSparqlValueType result;
#line 50 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) base;
#line 50 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp0_ = self->_cur_row;
#line 50 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_vala_return_val_if_fail (_tmp0_ != NULL, "_cur_row != null", 0);
#line 51 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp1_ = self->_cur_row;
#line 51 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp2_ = tracker_sparql_cursor_get_variable_name ((TrackerSparqlCursor*) self, column);
#line 51 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp3_ = json_object_get_member (_tmp1_, _tmp2_);
#line 51 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
#line 51 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	col_node = _tmp4_;
#line 53 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp5_ = col_node;
#line 53 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (_tmp5_ == NULL) {
#line 54 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		result = TRACKER_SPARQL_VALUE_TYPE_UNBOUND;
#line 54 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		__vala_JsonNode_free0 (col_node);
#line 54 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		return result;
#line 323 "tracker-json-cursor.c"
	}
#line 56 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp6_ = col_node;
#line 56 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp7_ = json_node_get_object (_tmp6_);
#line 56 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp8_ = _json_object_ref0 (_tmp7_);
#line 56 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	object = _tmp8_;
#line 57 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp9_ = object;
#line 57 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp10_ = json_object_get_string_member (_tmp9_, "type");
#line 57 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	str = _tmp10_;
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp11_ = str;
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp12_ = _tmp11_;
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("uri")))) {
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		switch (0) {
#line 349 "tracker-json-cursor.c"
			default:
			{
#line 61 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				result = TRACKER_SPARQL_VALUE_TYPE_URI;
#line 61 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				_json_object_unref0 (object);
#line 61 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				__vala_JsonNode_free0 (col_node);
#line 61 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				return result;
#line 360 "tracker-json-cursor.c"
			}
		}
	} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("bnode")))) {
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		switch (0) {
#line 366 "tracker-json-cursor.c"
			default:
			{
#line 63 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				result = TRACKER_SPARQL_VALUE_TYPE_BLANK_NODE;
#line 63 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				_json_object_unref0 (object);
#line 63 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				__vala_JsonNode_free0 (col_node);
#line 63 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				return result;
#line 377 "tracker-json-cursor.c"
			}
		}
	} else if (_tmp14_ == ((0 != _tmp13_label2) ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string ("literal")))) {
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		switch (0) {
#line 383 "tracker-json-cursor.c"
			default:
			{
				{
					JsonNode* node = NULL;
					JsonObject* _tmp15_;
					JsonNode* _tmp16_;
					JsonNode* _tmp17_;
					JsonNode* _tmp18_;
					JsonNode* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					GQuark _tmp24_ = 0U;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					static GQuark _tmp23_label0 = 0;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					static GQuark _tmp23_label1 = 0;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					static GQuark _tmp23_label2 = 0;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					static GQuark _tmp23_label3 = 0;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					static GQuark _tmp23_label4 = 0;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					static GQuark _tmp23_label5 = 0;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					static GQuark _tmp23_label6 = 0;
#line 65 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp15_ = object;
#line 65 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp16_ = json_object_get_member (_tmp15_, "datatype");
#line 65 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp17_ = __vala_JsonNode_copy0 (_tmp16_);
#line 65 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					node = _tmp17_;
#line 67 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp18_ = node;
#line 67 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					if (_tmp18_ == NULL) {
#line 68 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						result = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 68 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						__vala_JsonNode_free0 (node);
#line 68 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						_json_object_unref0 (object);
#line 68 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						__vala_JsonNode_free0 (col_node);
#line 68 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						return result;
#line 433 "tracker-json-cursor.c"
					}
#line 70 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp19_ = node;
#line 70 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp20_ = json_node_get_string (_tmp19_);
#line 70 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					str = _tmp20_;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp21_ = str;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp22_ = _tmp21_;
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					_tmp24_ = (NULL == _tmp22_) ? 0 : g_quark_from_string (_tmp22_);
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					if ((((_tmp24_ == ((0 != _tmp23_label0) ? _tmp23_label0 : (_tmp23_label0 = g_quark_from_static_string (TRACKER_REMOTE_JSON_CURSOR_XSD_NS "byte")))) || (_tmp24_ == ((0 != _tmp23_label1) ? _tmp23_label1 : (_tmp23_label1 = g_quark_from_static_string (TRACKER_REMOTE_JSON_CURSOR_XSD_NS "int"))))) || (_tmp24_ == ((0 != _tmp23_label2) ? _tmp23_label2 : (_tmp23_label2 = g_quark_from_static_string (TRACKER_REMOTE_JSON_CURSOR_XSD_NS "integer"))))) || (_tmp24_ == ((0 != _tmp23_label3) ? _tmp23_label3 : (_tmp23_label3 = g_quark_from_static_string (TRACKER_REMOTE_JSON_CURSOR_XSD_NS "long"))))) {
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						switch (0) {
#line 451 "tracker-json-cursor.c"
							default:
							{
#line 77 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								result = TRACKER_SPARQL_VALUE_TYPE_INTEGER;
#line 77 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								__vala_JsonNode_free0 (node);
#line 77 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								_json_object_unref0 (object);
#line 77 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								__vala_JsonNode_free0 (col_node);
#line 77 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								return result;
#line 464 "tracker-json-cursor.c"
							}
						}
					} else if ((_tmp24_ == ((0 != _tmp23_label4) ? _tmp23_label4 : (_tmp23_label4 = g_quark_from_static_string (TRACKER_REMOTE_JSON_CURSOR_XSD_NS "decimal")))) || (_tmp24_ == ((0 != _tmp23_label5) ? _tmp23_label5 : (_tmp23_label5 = g_quark_from_static_string (TRACKER_REMOTE_JSON_CURSOR_XSD_NS "double"))))) {
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						switch (0) {
#line 470 "tracker-json-cursor.c"
							default:
							{
#line 80 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								result = TRACKER_SPARQL_VALUE_TYPE_DOUBLE;
#line 80 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								__vala_JsonNode_free0 (node);
#line 80 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								_json_object_unref0 (object);
#line 80 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								__vala_JsonNode_free0 (col_node);
#line 80 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								return result;
#line 483 "tracker-json-cursor.c"
							}
						}
					} else if (_tmp24_ == ((0 != _tmp23_label6) ? _tmp23_label6 : (_tmp23_label6 = g_quark_from_static_string (TRACKER_REMOTE_JSON_CURSOR_XSD_NS "dateTime")))) {
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						switch (0) {
#line 489 "tracker-json-cursor.c"
							default:
							{
#line 82 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								result = TRACKER_SPARQL_VALUE_TYPE_DATETIME;
#line 82 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								__vala_JsonNode_free0 (node);
#line 82 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								_json_object_unref0 (object);
#line 82 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								__vala_JsonNode_free0 (col_node);
#line 82 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								return result;
#line 502 "tracker-json-cursor.c"
							}
						}
					} else {
#line 72 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
						switch (0) {
#line 508 "tracker-json-cursor.c"
							default:
							{
#line 84 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								result = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 84 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								__vala_JsonNode_free0 (node);
#line 84 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								_json_object_unref0 (object);
#line 84 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								__vala_JsonNode_free0 (col_node);
#line 84 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
								return result;
#line 521 "tracker-json-cursor.c"
							}
						}
					}
#line 64 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
					__vala_JsonNode_free0 (node);
#line 527 "tracker-json-cursor.c"
				}
			}
		}
	} else {
#line 59 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		switch (0) {
#line 534 "tracker-json-cursor.c"
			default:
			{
#line 89 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				result = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 89 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				_json_object_unref0 (object);
#line 89 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				__vala_JsonNode_free0 (col_node);
#line 89 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
				return result;
#line 545 "tracker-json-cursor.c"
			}
		}
	}
}

static const gchar*
tracker_remote_json_cursor_real_get_variable_name (TrackerSparqlCursor* base,
                                                   gint column)
{
	TrackerRemoteJsonCursor * self;
	JsonArray* _tmp0_;
	const gchar* _tmp1_;
	const gchar* result;
#line 93 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) base;
#line 94 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp0_ = self->_vars;
#line 94 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp1_ = json_array_get_string_element (_tmp0_, (guint) column);
#line 94 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	result = _tmp1_;
#line 94 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return result;
#line 569 "tracker-json-cursor.c"
}

static const gchar*
tracker_remote_json_cursor_real_get_string (TrackerSparqlCursor* base,
                                            gint column,
                                            glong* length)
{
	TrackerRemoteJsonCursor * self;
	glong _vala_length = 0L;
	JsonObject* _tmp0_;
	JsonNode* col_node = NULL;
	JsonObject* _tmp1_;
	const gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* _tmp5_;
	JsonObject* object = NULL;
	JsonNode* _tmp6_;
	JsonObject* _tmp7_;
	JsonObject* _tmp8_;
	JsonObject* _tmp9_;
	const gchar* str = NULL;
	JsonObject* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	const gchar* _tmp15_;
	const gchar* result;
#line 97 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) base;
#line 97 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp0_ = self->_cur_row;
#line 97 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_vala_return_val_if_fail (_tmp0_ != NULL, "_cur_row != null", NULL);
#line 98 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp1_ = self->_cur_row;
#line 98 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp2_ = tracker_sparql_cursor_get_variable_name ((TrackerSparqlCursor*) self, column);
#line 98 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp3_ = json_object_get_member (_tmp1_, _tmp2_);
#line 98 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
#line 98 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	col_node = _tmp4_;
#line 99 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_vala_length = (glong) 0;
#line 101 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp5_ = col_node;
#line 101 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (_tmp5_ == NULL) {
#line 102 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		result = NULL;
#line 102 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		__vala_JsonNode_free0 (col_node);
#line 102 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		if (length) {
#line 102 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
			*length = _vala_length;
#line 629 "tracker-json-cursor.c"
		}
#line 102 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		return result;
#line 633 "tracker-json-cursor.c"
	}
#line 104 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp6_ = col_node;
#line 104 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp7_ = json_node_get_object (_tmp6_);
#line 104 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp8_ = _json_object_ref0 (_tmp7_);
#line 104 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	object = _tmp8_;
#line 106 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp9_ = object;
#line 106 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (_tmp9_ == NULL) {
#line 107 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		result = NULL;
#line 107 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		_json_object_unref0 (object);
#line 107 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		__vala_JsonNode_free0 (col_node);
#line 107 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		if (length) {
#line 107 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
			*length = _vala_length;
#line 657 "tracker-json-cursor.c"
		}
#line 107 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		return result;
#line 661 "tracker-json-cursor.c"
	}
#line 109 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp10_ = object;
#line 109 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp11_ = json_object_get_string_member (_tmp10_, "value");
#line 109 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	str = _tmp11_;
#line 110 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp12_ = str;
#line 110 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp13_ = strlen (_tmp12_);
#line 110 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp14_ = _tmp13_;
#line 110 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_vala_length = (glong) _tmp14_;
#line 111 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp15_ = str;
#line 111 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	result = _tmp15_;
#line 111 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_object_unref0 (object);
#line 111 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	__vala_JsonNode_free0 (col_node);
#line 111 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (length) {
#line 111 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		*length = _vala_length;
#line 689 "tracker-json-cursor.c"
	}
#line 111 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return result;
#line 693 "tracker-json-cursor.c"
}

static gboolean
tracker_remote_json_cursor_real_next (TrackerSparqlCursor* base,
                                      GCancellable* cancellable,
                                      GError** error)
{
	TrackerRemoteJsonCursor * self;
	JsonArray* _tmp1_;
	gboolean _tmp2_ = FALSE;
	JsonArray* _tmp5_;
	JsonObject* _tmp6_;
	JsonObject* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 114 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) base;
#line 115 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (self->_started_iterating) {
#line 713 "tracker-json-cursor.c"
		guint _tmp0_;
#line 116 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		_tmp0_ = self->_cur_idx;
#line 116 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		self->_cur_idx = _tmp0_ + 1;
#line 719 "tracker-json-cursor.c"
	}
#line 118 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp1_ = self->_results;
#line 118 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (self->_cur_idx >= json_array_get_length (_tmp1_)) {
#line 119 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		result = FALSE;
#line 119 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		return result;
#line 729 "tracker-json-cursor.c"
	}
#line 121 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (cancellable != NULL) {
#line 121 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		_tmp2_ = g_cancellable_is_cancelled (cancellable);
#line 735 "tracker-json-cursor.c"
	} else {
#line 121 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		_tmp2_ = FALSE;
#line 739 "tracker-json-cursor.c"
	}
#line 121 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (_tmp2_) {
#line 743 "tracker-json-cursor.c"
		GError* _tmp3_;
		gboolean _tmp4_ = FALSE;
#line 122 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		_tmp3_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 122 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		_inner_error0_ = _tmp3_;
#line 122 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		g_propagate_error (error, _inner_error0_);
#line 122 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		return _tmp4_;
#line 754 "tracker-json-cursor.c"
	}
#line 124 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_started_iterating = TRUE;
#line 125 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp5_ = self->_results;
#line 125 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp6_ = json_array_get_object_element (_tmp5_, self->_cur_idx);
#line 125 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp7_ = _json_object_ref0 (_tmp6_);
#line 125 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_object_unref0 (self->_cur_row);
#line 125 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_cur_row = _tmp7_;
#line 126 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	result = TRUE;
#line 126 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return result;
#line 772 "tracker-json-cursor.c"
}

static void
tracker_remote_json_cursor_real_next_async_data_free (gpointer _data)
{
	TrackerRemoteJsonCursorNextAsyncData* _data_;
	_data_ = _data;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_g_object_unref0 (_data_->self);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	g_slice_free (TrackerRemoteJsonCursorNextAsyncData, _data_);
#line 786 "tracker-json-cursor.c"
}

static void
tracker_remote_json_cursor_real_next_async (TrackerSparqlCursor* base,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	TrackerRemoteJsonCursor * self;
	TrackerRemoteJsonCursorNextAsyncData* _data_;
	TrackerRemoteJsonCursor* _tmp0_;
	GCancellable* _tmp1_;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) base;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_data_ = g_slice_new0 (TrackerRemoteJsonCursorNextAsyncData);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_remote_json_cursor_real_next_async_data_free);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_data_->self = _tmp0_;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_data_->cancellable = _tmp1_;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	tracker_remote_json_cursor_real_next_async_co (_data_);
#line 819 "tracker-json-cursor.c"
}

static gboolean
tracker_remote_json_cursor_next_finish (TrackerSparqlCursor* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	gboolean result;
	TrackerRemoteJsonCursorNextAsyncData* _data_;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (NULL == _data_) {
#line 833 "tracker-json-cursor.c"
		gboolean _tmp0_ = FALSE;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		return _tmp0_;
#line 837 "tracker-json-cursor.c"
	}
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	result = _data_->result;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return result;
#line 843 "tracker-json-cursor.c"
}

static gboolean
tracker_remote_json_cursor_real_next_async_co (TrackerRemoteJsonCursorNextAsyncData* _data_)
{
#line 129 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	switch (_data_->_state_) {
#line 129 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		case 0:
#line 853 "tracker-json-cursor.c"
		goto _state_0;
		default:
#line 129 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		g_assert_not_reached ();
#line 858 "tracker-json-cursor.c"
	}
	_state_0:
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_data_->_tmp0_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _data_->self, _data_->cancellable, &_data_->_inner_error0_);
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		g_object_unref (_data_->_async_result);
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		return FALSE;
#line 871 "tracker-json-cursor.c"
	}
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_data_->result = _data_->_tmp0_;
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	if (_data_->_state_ != 0) {
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 883 "tracker-json-cursor.c"
		}
	}
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	g_object_unref (_data_->_async_result);
#line 130 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return FALSE;
#line 890 "tracker-json-cursor.c"
}

static void
tracker_remote_json_cursor_real_rewind (TrackerSparqlCursor* base)
{
	TrackerRemoteJsonCursor * self;
#line 133 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) base;
#line 134 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_started_iterating = FALSE;
#line 901 "tracker-json-cursor.c"
}

static void
tracker_remote_json_cursor_real_close (TrackerSparqlCursor* base)
{
	TrackerRemoteJsonCursor * self;
#line 137 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) base;
#line 910 "tracker-json-cursor.c"
}

static gint
tracker_remote_json_cursor_real_get_n_columns (TrackerSparqlCursor* base)
{
	gint result;
	TrackerRemoteJsonCursor* self;
	JsonArray* _tmp0_;
#line 47 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = (TrackerRemoteJsonCursor*) base;
#line 47 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_tmp0_ = self->_vars;
#line 47 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	result = (gint) json_array_get_length (_tmp0_);
#line 47 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	return result;
#line 927 "tracker-json-cursor.c"
}

static void
tracker_remote_json_cursor_class_init (TrackerRemoteJsonCursorClass * klass,
                                       gpointer klass_data)
{
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	tracker_remote_json_cursor_parent_class = g_type_class_peek_parent (klass);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_value_type = (TrackerSparqlValueType (*) (TrackerSparqlCursor*, gint)) tracker_remote_json_cursor_real_get_value_type;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_variable_name = (const gchar* (*) (TrackerSparqlCursor*, gint)) tracker_remote_json_cursor_real_get_variable_name;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_string = (const gchar* (*) (TrackerSparqlCursor*, gint, glong*)) tracker_remote_json_cursor_real_get_string;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next = (gboolean (*) (TrackerSparqlCursor*, GCancellable*, GError**)) tracker_remote_json_cursor_real_next;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next_async = (void (*) (TrackerSparqlCursor*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_remote_json_cursor_real_next_async;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next_finish = (gboolean (*) (TrackerSparqlCursor*, GAsyncResult*, GError**)) tracker_remote_json_cursor_next_finish;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->rewind = (void (*) (TrackerSparqlCursor*)) tracker_remote_json_cursor_real_rewind;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->close = (void (*) (TrackerSparqlCursor*)) tracker_remote_json_cursor_real_close;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	TRACKER_SPARQL_CURSOR_CLASS (klass)->get_n_columns = tracker_remote_json_cursor_real_get_n_columns;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_remote_json_cursor_get_property;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_remote_json_cursor_finalize;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_REMOTE_JSON_CURSOR_N_COLUMNS_PROPERTY, tracker_remote_json_cursor_properties[TRACKER_REMOTE_JSON_CURSOR_N_COLUMNS_PROPERTY] = g_param_spec_int ("n-columns", "n-columns", "n-columns", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 960 "tracker-json-cursor.c"
}

static void
tracker_remote_json_cursor_instance_init (TrackerRemoteJsonCursor * self,
                                          gpointer klass)
{
#line 27 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_cur_idx = (guint) 0;
#line 28 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self->_started_iterating = FALSE;
#line 971 "tracker-json-cursor.c"
}

static void
tracker_remote_json_cursor_finalize (GObject * obj)
{
	TrackerRemoteJsonCursor * self;
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_REMOTE_TYPE_JSON_CURSOR, TrackerRemoteJsonCursor);
#line 23 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_g_object_unref0 (self->_parser);
#line 24 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_array_unref0 (self->_vars);
#line 25 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_array_unref0 (self->_results);
#line 26 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	_json_object_unref0 (self->_cur_row);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	G_OBJECT_CLASS (tracker_remote_json_cursor_parent_class)->finalize (obj);
#line 990 "tracker-json-cursor.c"
}

static GType
tracker_remote_json_cursor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerRemoteJsonCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_remote_json_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerRemoteJsonCursor), 0, (GInstanceInitFunc) tracker_remote_json_cursor_instance_init, NULL };
	GType tracker_remote_json_cursor_type_id;
	tracker_remote_json_cursor_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CURSOR, "TrackerRemoteJsonCursor", &g_define_type_info, 0);
	return tracker_remote_json_cursor_type_id;
}

GType
tracker_remote_json_cursor_get_type (void)
{
	static volatile gsize tracker_remote_json_cursor_type_id__once = 0;
	if (g_once_init_enter (&tracker_remote_json_cursor_type_id__once)) {
		GType tracker_remote_json_cursor_type_id;
		tracker_remote_json_cursor_type_id = tracker_remote_json_cursor_get_type_once ();
		g_once_init_leave (&tracker_remote_json_cursor_type_id__once, tracker_remote_json_cursor_type_id);
	}
	return tracker_remote_json_cursor_type_id__once;
}

static void
_vala_tracker_remote_json_cursor_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	TrackerRemoteJsonCursor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_REMOTE_TYPE_JSON_CURSOR, TrackerRemoteJsonCursor);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
	switch (property_id) {
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		case TRACKER_REMOTE_JSON_CURSOR_N_COLUMNS_PROPERTY:
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		g_value_set_int (value, tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) self));
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		break;
#line 1030 "tracker-json-cursor.c"
		default:
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../tracker/src/libtracker-remote/tracker-json-cursor.vala"
		break;
#line 1036 "tracker-json-cursor.c"
	}
}

