/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2020, Google Inc.
 *
 * raspberrypi_ipa_proxy_worker.cpp - Image Processing Algorithm proxy worker for raspberrypi
 *
 * This file is auto-generated. Do not edit.
 */

#include <algorithm>
#include <iostream>
#include <sys/types.h>
#include <tuple>
#include <unistd.h>

#include <libcamera/ipa/ipa_interface.h>
#include <libcamera/ipa/raspberrypi_ipa_interface.h>
#include <libcamera/ipa/raspberrypi_ipa_serializer.h>
#include <libcamera/logging.h>

#include <libcamera/base/event_dispatcher.h>
#include <libcamera/base/log.h>
#include <libcamera/base/thread.h>
#include <libcamera/base/unique_fd.h>

#include "libcamera/internal/camera_sensor.h"
#include "libcamera/internal/control_serializer.h"
#include "libcamera/internal/ipa_data_serializer.h"
#include "libcamera/internal/ipa_module.h"
#include "libcamera/internal/ipa_proxy.h"
#include "libcamera/internal/ipc_pipe.h"
#include "libcamera/internal/ipc_pipe_unixsocket.h"
#include "libcamera/internal/ipc_unixsocket.h"

using namespace libcamera;

LOG_DEFINE_CATEGORY(IPAProxyRPiWorker)
using namespace ipa;
using namespace RPi;


class IPAProxyRPiWorker
{
public:
	IPAProxyRPiWorker()
		: ipa_(nullptr),
		  controlSerializer_(ControlSerializer::Role::Worker),
		  exit_(false) {}

	~IPAProxyRPiWorker() {}

	void readyRead()
	{
		IPCUnixSocket::Payload _message;
		int _retRecv = socket_.receive(&_message);
		if (_retRecv) {
			LOG(IPAProxyRPiWorker, Error)
				<< "Receive message failed: " << _retRecv;
			return;
		}

		IPCMessage _ipcMessage(_message);

		_RPiCmd _cmd = static_cast<_RPiCmd>(_ipcMessage.header().cmd);

		switch (_cmd) {
		case _RPiCmd::Exit: {
			exit_ = true;
			break;
		}


		case _RPiCmd::Init: {
		                

                	const size_t settingsStart = 0;


                	IPASettings settings = IPADataSerializer<IPASettings>::deserialize(
                        	_ipcMessage.data().cbegin() + settingsStart,
                        	_ipcMessage.data().cend());


			IPAInitResult result;

			int32_t _callRet =ipa_->init(settings, &result);

			IPCMessage::Header header = { _ipcMessage.header().cmd, _ipcMessage.header().cookie };
			IPCMessage _response(header);
			std::vector<uint8_t> _callRetBuf;
			std::tie(_callRetBuf, std::ignore) =
				IPADataSerializer<int32_t>::serialize(_callRet);
			_response.data().insert(_response.data().end(), _callRetBuf.cbegin(), _callRetBuf.cend());
		                
                	std::vector<uint8_t> resultBuf;
                	std::tie(resultBuf, std::ignore) =
                		IPADataSerializer<IPAInitResult>::serialize(result, &controlSerializer_);
                	_response.data().insert(_response.data().end(), resultBuf.begin(), resultBuf.end());
			int _ret = socket_.send(_response.payload());
			if (_ret < 0) {
				LOG(IPAProxyRPiWorker, Error)
					<< "Reply to init() failed: " << _ret;
			}
			LOG(IPAProxyRPiWorker, Debug) << "Done replying to init()";
			break;
		}

		case _RPiCmd::Start: {
		                

                	const size_t controlsStart = 0;


                	ControlList controls = IPADataSerializer<ControlList>::deserialize(
                        	_ipcMessage.data().cbegin() + controlsStart,
                        	_ipcMessage.data().cend(),
                        	&controlSerializer_);


			StartConfig startConfig;
ipa_->start(controls, &startConfig);

			IPCMessage::Header header = { _ipcMessage.header().cmd, _ipcMessage.header().cookie };
			IPCMessage _response(header);
		                
                	std::vector<uint8_t> startConfigBuf;
                	std::tie(startConfigBuf, std::ignore) =
                		IPADataSerializer<StartConfig>::serialize(startConfig, &controlSerializer_);
                	_response.data().insert(_response.data().end(), startConfigBuf.begin(), startConfigBuf.end());
			int _ret = socket_.send(_response.payload());
			if (_ret < 0) {
				LOG(IPAProxyRPiWorker, Error)
					<< "Reply to start() failed: " << _ret;
			}
			LOG(IPAProxyRPiWorker, Debug) << "Done replying to start()";
			break;
		}

		case _RPiCmd::Stop: {
		                



ipa_->stop();

			IPCMessage::Header header = { _ipcMessage.header().cmd, _ipcMessage.header().cookie };
			IPCMessage _response(header);
		                
			int _ret = socket_.send(_response.payload());
			if (_ret < 0) {
				LOG(IPAProxyRPiWorker, Error)
					<< "Reply to stop() failed: " << _ret;
			}
			LOG(IPAProxyRPiWorker, Debug) << "Done replying to stop()";
			break;
		}

		case _RPiCmd::Configure: {
			controlSerializer_.reset();
		                
                	[[maybe_unused]] const size_t sensorInfoBufSize = readPOD<uint32_t>(_ipcMessage.data(), 0);
                	[[maybe_unused]] const size_t streamConfigBufSize = readPOD<uint32_t>(_ipcMessage.data(), 4);
                	[[maybe_unused]] const size_t entityControlsBufSize = readPOD<uint32_t>(_ipcMessage.data(), 8);
                	[[maybe_unused]] const size_t ipaConfigBufSize = readPOD<uint32_t>(_ipcMessage.data(), 12);
                	[[maybe_unused]] const size_t ipaConfigFdsSize = readPOD<uint32_t>(_ipcMessage.data(), 16);

                	const size_t sensorInfoStart = 20;
                	const size_t streamConfigStart = sensorInfoStart + sensorInfoBufSize;
                	const size_t entityControlsStart = streamConfigStart + streamConfigBufSize;
                	const size_t ipaConfigStart = entityControlsStart + entityControlsBufSize;

                	const size_t ipaConfigFdStart = 0;

                	IPACameraSensorInfo sensorInfo = IPADataSerializer<IPACameraSensorInfo>::deserialize(
                        	_ipcMessage.data().cbegin() + sensorInfoStart,
                        	_ipcMessage.data().cbegin() + sensorInfoStart + sensorInfoBufSize);

                	std::map<uint32_t, libcamera::IPAStream> streamConfig = IPADataSerializer<std::map<uint32_t, libcamera::IPAStream>>::deserialize(
                        	_ipcMessage.data().cbegin() + streamConfigStart,
                        	_ipcMessage.data().cbegin() + streamConfigStart + streamConfigBufSize);

                	std::map<uint32_t, libcamera::ControlInfoMap> entityControls = IPADataSerializer<std::map<uint32_t, libcamera::ControlInfoMap>>::deserialize(
                        	_ipcMessage.data().cbegin() + entityControlsStart,
                        	_ipcMessage.data().cbegin() + entityControlsStart + entityControlsBufSize,
                        	&controlSerializer_);

                	IPAConfig ipaConfig = IPADataSerializer<IPAConfig>::deserialize(
                        	_ipcMessage.data().cbegin() + ipaConfigStart,
                        	_ipcMessage.data().cend(),
                        	_ipcMessage.fds().cbegin() + ipaConfigFdStart,
                        	_ipcMessage.fds().cend());


			ControlList controls;

			IPAConfigResult result;

			int32_t _callRet =ipa_->configure(sensorInfo, streamConfig, entityControls, ipaConfig, &controls, &result);

			IPCMessage::Header header = { _ipcMessage.header().cmd, _ipcMessage.header().cookie };
			IPCMessage _response(header);
			std::vector<uint8_t> _callRetBuf;
			std::tie(_callRetBuf, std::ignore) =
				IPADataSerializer<int32_t>::serialize(_callRet);
			_response.data().insert(_response.data().end(), _callRetBuf.cbegin(), _callRetBuf.cend());
		                
                	std::vector<uint8_t> controlsBuf;
                	std::tie(controlsBuf, std::ignore) =
                		IPADataSerializer<ControlList>::serialize(controls, &controlSerializer_);
                	std::vector<uint8_t> resultBuf;
                	std::tie(resultBuf, std::ignore) =
                		IPADataSerializer<IPAConfigResult>::serialize(result, &controlSerializer_);
                	appendPOD<uint32_t>(_response.data(), controlsBuf.size());
                	appendPOD<uint32_t>(_response.data(), resultBuf.size());
                	_response.data().insert(_response.data().end(), controlsBuf.begin(), controlsBuf.end());
                	_response.data().insert(_response.data().end(), resultBuf.begin(), resultBuf.end());
			int _ret = socket_.send(_response.payload());
			if (_ret < 0) {
				LOG(IPAProxyRPiWorker, Error)
					<< "Reply to configure() failed: " << _ret;
			}
			LOG(IPAProxyRPiWorker, Debug) << "Done replying to configure()";
			break;
		}

		case _RPiCmd::MapBuffers: {
		                

                	const size_t buffersStart = 0;

                	const size_t buffersFdStart = 0;

                	std::vector<libcamera::IPABuffer> buffers = IPADataSerializer<std::vector<libcamera::IPABuffer>>::deserialize(
                        	_ipcMessage.data().cbegin() + buffersStart,
                        	_ipcMessage.data().cend(),
                        	_ipcMessage.fds().cbegin() + buffersFdStart,
                        	_ipcMessage.fds().cend());

ipa_->mapBuffers(buffers);

			IPCMessage::Header header = { _ipcMessage.header().cmd, _ipcMessage.header().cookie };
			IPCMessage _response(header);
		                
			int _ret = socket_.send(_response.payload());
			if (_ret < 0) {
				LOG(IPAProxyRPiWorker, Error)
					<< "Reply to mapBuffers() failed: " << _ret;
			}
			LOG(IPAProxyRPiWorker, Debug) << "Done replying to mapBuffers()";
			break;
		}

		case _RPiCmd::UnmapBuffers: {
		                

                	const size_t idsStart = 0;


                	std::vector<uint32_t> ids = IPADataSerializer<std::vector<uint32_t>>::deserialize(
                        	_ipcMessage.data().cbegin() + idsStart,
                        	_ipcMessage.data().cend());

ipa_->unmapBuffers(ids);

			IPCMessage::Header header = { _ipcMessage.header().cmd, _ipcMessage.header().cookie };
			IPCMessage _response(header);
		                
			int _ret = socket_.send(_response.payload());
			if (_ret < 0) {
				LOG(IPAProxyRPiWorker, Error)
					<< "Reply to unmapBuffers() failed: " << _ret;
			}
			LOG(IPAProxyRPiWorker, Debug) << "Done replying to unmapBuffers()";
			break;
		}

		case _RPiCmd::SignalStatReady: {
		                

                	const size_t bufferIdStart = 0;


                	uint32_t bufferId = IPADataSerializer<uint32_t>::deserialize(
                        	_ipcMessage.data().cbegin() + bufferIdStart,
                        	_ipcMessage.data().cend());

ipa_->signalStatReady(bufferId);

			break;
		}

		case _RPiCmd::SignalQueueRequest: {
		                

                	const size_t controlsStart = 0;


                	ControlList controls = IPADataSerializer<ControlList>::deserialize(
                        	_ipcMessage.data().cbegin() + controlsStart,
                        	_ipcMessage.data().cend(),
                        	&controlSerializer_);

ipa_->signalQueueRequest(controls);

			break;
		}

		case _RPiCmd::SignalIspPrepare: {
		                

                	const size_t dataStart = 0;


                	ISPConfig data = IPADataSerializer<ISPConfig>::deserialize(
                        	_ipcMessage.data().cbegin() + dataStart,
                        	_ipcMessage.data().cend(),
                        	&controlSerializer_);

ipa_->signalIspPrepare(data);

			break;
		}

		default:
			LOG(IPAProxyRPiWorker, Error) << "Unknown command " << _ipcMessage.header().cmd;
		}
	}

	int init(std::unique_ptr<IPAModule> &ipam, UniqueFD socketfd)
	{
		if (socket_.bind(std::move(socketfd)) < 0) {
			LOG(IPAProxyRPiWorker, Error)
				<< "IPC socket binding failed";
			return EXIT_FAILURE;
		}
		socket_.readyRead.connect(this, &IPAProxyRPiWorker::readyRead);

		ipa_ = dynamic_cast<IPARPiInterface *>(ipam->createInterface());
		if (!ipa_) {
			LOG(IPAProxyRPiWorker, Error)
				<< "Failed to create IPA interface instance";
			return EXIT_FAILURE;
		}

		ipa_->statsMetadataComplete.connect(this, &IPAProxyRPiWorker::statsMetadataComplete);
		ipa_->runIsp.connect(this, &IPAProxyRPiWorker::runIsp);
		ipa_->embeddedComplete.connect(this, &IPAProxyRPiWorker::embeddedComplete);
		ipa_->setIspControls.connect(this, &IPAProxyRPiWorker::setIspControls);
		ipa_->setDelayedControls.connect(this, &IPAProxyRPiWorker::setDelayedControls);
		return 0;
	}

	void run()
	{
		EventDispatcher *dispatcher = Thread::current()->eventDispatcher();
		while (!exit_)
			dispatcher->processEvents();
	}

	void cleanup()
	{
		delete ipa_;
		socket_.close();
	}

private:


        void statsMetadataComplete(
        	const uint32_t bufferId,
        	const ControlList &controls)
	{
		IPCMessage::Header header = {
			static_cast<uint32_t>(_RPiEventCmd::StatsMetadataComplete),
			0
		};
		IPCMessage _message(header);

		
	std::vector<uint8_t> bufferIdBuf;
	std::tie(bufferIdBuf, std::ignore) =
		IPADataSerializer<uint32_t>::serialize(bufferId);
	std::vector<uint8_t> controlsBuf;
	std::tie(controlsBuf, std::ignore) =
		IPADataSerializer<ControlList>::serialize(controls, &controlSerializer_);
	appendPOD<uint32_t>(_message.data(), bufferIdBuf.size());
	appendPOD<uint32_t>(_message.data(), controlsBuf.size());
	_message.data().insert(_message.data().end(), bufferIdBuf.begin(), bufferIdBuf.end());
	_message.data().insert(_message.data().end(), controlsBuf.begin(), controlsBuf.end());

		int _ret = socket_.send(_message.payload());
		if (_ret < 0)
			LOG(IPAProxyRPiWorker, Error)
				<< "Sending event statsMetadataComplete() failed: " << _ret;

		LOG(IPAProxyRPiWorker, Debug) << "statsMetadataComplete done";
	}

        void runIsp(
        	const uint32_t bufferId)
	{
		IPCMessage::Header header = {
			static_cast<uint32_t>(_RPiEventCmd::RunIsp),
			0
		};
		IPCMessage _message(header);

		
	std::vector<uint8_t> bufferIdBuf;
	std::tie(bufferIdBuf, std::ignore) =
		IPADataSerializer<uint32_t>::serialize(bufferId);
	_message.data().insert(_message.data().end(), bufferIdBuf.begin(), bufferIdBuf.end());

		int _ret = socket_.send(_message.payload());
		if (_ret < 0)
			LOG(IPAProxyRPiWorker, Error)
				<< "Sending event runIsp() failed: " << _ret;

		LOG(IPAProxyRPiWorker, Debug) << "runIsp done";
	}

        void embeddedComplete(
        	const uint32_t bufferId)
	{
		IPCMessage::Header header = {
			static_cast<uint32_t>(_RPiEventCmd::EmbeddedComplete),
			0
		};
		IPCMessage _message(header);

		
	std::vector<uint8_t> bufferIdBuf;
	std::tie(bufferIdBuf, std::ignore) =
		IPADataSerializer<uint32_t>::serialize(bufferId);
	_message.data().insert(_message.data().end(), bufferIdBuf.begin(), bufferIdBuf.end());

		int _ret = socket_.send(_message.payload());
		if (_ret < 0)
			LOG(IPAProxyRPiWorker, Error)
				<< "Sending event embeddedComplete() failed: " << _ret;

		LOG(IPAProxyRPiWorker, Debug) << "embeddedComplete done";
	}

        void setIspControls(
        	const ControlList &controls)
	{
		IPCMessage::Header header = {
			static_cast<uint32_t>(_RPiEventCmd::SetIspControls),
			0
		};
		IPCMessage _message(header);

		
	std::vector<uint8_t> controlsBuf;
	std::tie(controlsBuf, std::ignore) =
		IPADataSerializer<ControlList>::serialize(controls, &controlSerializer_);
	_message.data().insert(_message.data().end(), controlsBuf.begin(), controlsBuf.end());

		int _ret = socket_.send(_message.payload());
		if (_ret < 0)
			LOG(IPAProxyRPiWorker, Error)
				<< "Sending event setIspControls() failed: " << _ret;

		LOG(IPAProxyRPiWorker, Debug) << "setIspControls done";
	}

        void setDelayedControls(
        	const ControlList &controls)
	{
		IPCMessage::Header header = {
			static_cast<uint32_t>(_RPiEventCmd::SetDelayedControls),
			0
		};
		IPCMessage _message(header);

		
	std::vector<uint8_t> controlsBuf;
	std::tie(controlsBuf, std::ignore) =
		IPADataSerializer<ControlList>::serialize(controls, &controlSerializer_);
	_message.data().insert(_message.data().end(), controlsBuf.begin(), controlsBuf.end());

		int _ret = socket_.send(_message.payload());
		if (_ret < 0)
			LOG(IPAProxyRPiWorker, Error)
				<< "Sending event setDelayedControls() failed: " << _ret;

		LOG(IPAProxyRPiWorker, Debug) << "setDelayedControls done";
	}


	IPARPiInterface *ipa_;
	IPCUnixSocket socket_;

	ControlSerializer controlSerializer_;

	bool exit_;
};

int main(int argc, char **argv)
{
	/* Uncomment this for debugging. */
#if 0
	std::string logPath = "/tmp/libcamera.worker." +
			      std::to_string(getpid()) + ".log";
	logSetFile(logPath.c_str());
#endif

	if (argc < 3) {
		LOG(IPAProxyRPiWorker, Error)
			<< "Tried to start worker with no args: "
			<< "expected <path to IPA so> <fd to bind unix socket>";
		return EXIT_FAILURE;
	}

	UniqueFD fd(std::stoi(argv[2]));
	LOG(IPAProxyRPiWorker, Info)
		<< "Starting worker for IPA module " << argv[1]
		<< " with IPC fd = " << fd.get();

	std::unique_ptr<IPAModule> ipam = std::make_unique<IPAModule>(argv[1]);
	if (!ipam->isValid() || !ipam->load()) {
		LOG(IPAProxyRPiWorker, Error)
			<< "IPAModule " << argv[1] << " isn't valid";
		return EXIT_FAILURE;
	}

	/*
	 * Shutdown of proxy worker can be pre-empted by events like
	 * SIGINT/SIGTERM, even before the pipeline handler can request
	 * shutdown. Hence, assign a new gid to prevent signals on the
	 * application being delivered to the proxy.
	 */
	if (setpgid(0, 0) < 0) {
		int err = errno;
		LOG(IPAProxyRPiWorker, Warning)
			<< "Failed to set new gid: " << strerror(err);
	}

	IPAProxyRPiWorker proxyWorker;
	int ret = proxyWorker.init(ipam, std::move(fd));
	if (ret < 0) {
		LOG(IPAProxyRPiWorker, Error)
			<< "Failed to initialize proxy worker";
		return ret;
	}

	LOG(IPAProxyRPiWorker, Debug) << "Proxy worker successfully initialized";

	proxyWorker.run();

	proxyWorker.cleanup();

	return 0;
}