/* rygel-root-device-factory.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-core.h"
#include <glib/gstdio.h>
#include <libgupnp/gupnp.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "config.h"
#include <gee.h>
#include <libgssdp/gssdp.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_0_PROPERTY,
	RYGEL_ROOT_DEVICE_FACTORY_CONTEXT_PROPERTY,
	RYGEL_ROOT_DEVICE_FACTORY_NUM_PROPERTIES
};
static GParamSpec* rygel_root_device_factory_properties[RYGEL_ROOT_DEVICE_FACTORY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

struct _RygelRootDeviceFactoryPrivate {
	GUPnPContext* _context;
	RygelConfiguration* config;
	gchar* desc_dir;
};

VALA_EXTERN gchar* rygel_pretty_host_name;
gchar* rygel_pretty_host_name = NULL;
static gint RygelRootDeviceFactory_private_offset;
static gpointer rygel_root_device_factory_parent_class = NULL;
static GInitableIface * rygel_root_device_factory_g_initable_parent_iface = NULL;

static gboolean rygel_root_device_factory_real_init (GInitable* base,
                                              GCancellable* cancellable,
                                              GError** error);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self,
                                                  const gchar* dir_path,
                                                  GError** error);
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self,
                                                    RygelPlugin* plugin,
                                                    const gchar* desc_path,
                                                    const gchar* template_path,
                                                    GError** error);
static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self,
                                                       const gchar* path1,
                                                       const gchar* path2,
                                                       GError** error);
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self,
                                                     RygelDescriptionFile* file,
                                                     RygelPlugin* plugin);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self,
                                                  RygelDescriptionFile* file,
                                                  RygelPlugin* plugin);
static gchar* rygel_root_device_factory_get_friendly_name (RygelRootDeviceFactory* self,
                                                    RygelPlugin* plugin);
static gchar* rygel_root_device_factory_get_icon_remote_path (RygelRootDeviceFactory* self,
                                                       RygelIconInfo* icon_info,
                                                       RygelPlugin* plugin);
static void rygel_root_device_factory_finalize (GObject * obj);
static GType rygel_root_device_factory_get_type_once (void);
static void _vala_rygel_root_device_factory_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_rygel_root_device_factory_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
rygel_get_pretty_host_name (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = rygel_pretty_host_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_get_host_name ();
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (rygel_pretty_host_name);
		rygel_pretty_host_name = _tmp2_;
		{
			gchar* machine_info = NULL;
			gchar* _tmp3_ = NULL;
			gchar** lines = NULL;
			const gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint lines_length1;
			gint _lines_size_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			g_file_get_contents ("/etc/machine-info", &_tmp3_, NULL, &_inner_error0_);
			_g_free0 (machine_info);
			machine_info = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (machine_info);
				goto __catch0_g_error;
			}
			_tmp4_ = machine_info;
			_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "\n", 0);
			lines = _tmp6_;
			lines_length1 = _vala_array_length (_tmp5_);
			_lines_size_ = lines_length1;
			_tmp7_ = lines;
			_tmp7__length1 = lines_length1;
			{
				gchar** line_collection = NULL;
				gint line_collection_length1 = 0;
				gint _line_collection_size_ = 0;
				gint line_it = 0;
				line_collection = _tmp7_;
				line_collection_length1 = _tmp7__length1;
				for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
					gchar* _tmp8_;
					gchar* line = NULL;
					_tmp8_ = g_strdup (line_collection[line_it]);
					line = _tmp8_;
					{
						gchar** parts = NULL;
						const gchar* _tmp9_;
						gchar** _tmp10_;
						gchar** _tmp11_;
						gint parts_length1;
						gint _parts_size_;
						gchar** _tmp12_;
						gint _tmp12__length1;
						const gchar* _tmp13_;
						_tmp9_ = line;
						_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "=", 0);
						parts = _tmp11_;
						parts_length1 = _vala_array_length (_tmp10_);
						_parts_size_ = parts_length1;
						_tmp12_ = parts;
						_tmp12__length1 = parts_length1;
						_tmp13_ = _tmp12_[0];
						if (g_strcmp0 (_tmp13_, "PRETTY_HOSTNAME") == 0) {
							gchar** _tmp14_;
							gint _tmp14__length1;
							gchar** _tmp15_;
							gint _tmp15__length1;
							gchar* _tmp16_;
							_tmp14_ = parts;
							_tmp14__length1 = parts_length1;
							_tmp15_ = parts;
							_tmp15__length1 = parts_length1;
							_tmp16_ = _vala_g_strjoinv ("=", _tmp14_ + 1, (gint) (_tmp15__length1 - 1));
							_g_free0 (rygel_pretty_host_name);
							rygel_pretty_host_name = _tmp16_;
						}
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
					}
				}
			}
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (machine_info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_debug ("rygel-root-device-factory.vala:54: Failed to parse /etc/machine-info: " \
"%s", _tmp18_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp19_ = rygel_pretty_host_name;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	return result;
}

static inline gpointer
rygel_root_device_factory_get_instance_private (RygelRootDeviceFactory* self)
{
	return G_STRUCT_MEMBER_P (self, RygelRootDeviceFactory_private_offset);
}

RygelRootDeviceFactory*
rygel_root_device_factory_construct (GType object_type,
                                     GUPnPContext* context,
                                     GError** error)
{
	RygelRootDeviceFactory * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	self = (RygelRootDeviceFactory*) g_object_new (object_type, "context", context, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

RygelRootDeviceFactory*
rygel_root_device_factory_new (GUPnPContext* context,
                               GError** error)
{
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
}

static gboolean
rygel_root_device_factory_real_init (GInitable* base,
                                     GCancellable* cancellable,
                                     GError** error)
{
	RygelRootDeviceFactory * self;
	RygelConfiguration* _tmp0_;
	RygelMetaConfig* _tmp1_;
	gchar* config_dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelRootDeviceFactory*) base;
	_tmp0_ = self->priv->config;
	if (_tmp0_ != NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp1_;
	_tmp2_ = g_get_user_config_dir ();
	_tmp3_ = g_strdup (_tmp2_);
	config_dir = _tmp3_;
	_tmp4_ = config_dir;
	rygel_root_device_factory_ensure_dir_exists (self, _tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (config_dir);
		return _tmp5_;
	}
	_tmp6_ = config_dir;
	_tmp7_ = g_build_filename (_tmp6_, "Rygel", NULL);
	_g_free0 (self->priv->desc_dir);
	self->priv->desc_dir = _tmp7_;
	_tmp8_ = self->priv->desc_dir;
	rygel_root_device_factory_ensure_dir_exists (self, _tmp8_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (config_dir);
		return _tmp9_;
	}
	result = TRUE;
	_g_free0 (config_dir);
	return result;
}

RygelRootDevice*
rygel_root_device_factory_create (RygelRootDeviceFactory* self,
                                  RygelPlugin* plugin,
                                  GError** error)
{
	gchar* desc_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* template_path = NULL;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GUPnPXMLDoc* doc = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GUPnPXMLDoc* _tmp12_;
	RygelRootDevice* device = NULL;
	GUPnPContext* _tmp13_;
	GUPnPXMLDoc* _tmp14_;
	const gchar* _tmp15_;
	RygelRootDevice* _tmp16_;
	RygelRootDevice* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	RygelRootDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	_tmp0_ = self->priv->desc_dir;
	_tmp1_ = rygel_plugin_get_name (plugin);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ".xml", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_build_filename (_tmp0_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	desc_path = _tmp6_;
	_tmp7_ = rygel_plugin_get_desc_path (plugin);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	template_path = _tmp9_;
	_tmp10_ = desc_path;
	_tmp11_ = template_path;
	_tmp12_ = rygel_root_device_factory_create_desc (self, plugin, _tmp10_, _tmp11_, &_inner_error0_);
	doc = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	_tmp13_ = self->priv->_context;
	_tmp14_ = doc;
	_tmp15_ = desc_path;
	_tmp16_ = rygel_root_device_new (_tmp13_, plugin, _tmp14_, _tmp15_, DATA_DIR, &_inner_error0_);
	device = _tmp16_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (doc);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	_tmp17_ = device;
	_tmp18_ = desc_path;
	rygel_plugin_apply_hacks (plugin, _tmp17_, _tmp18_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (device);
		_g_object_unref0 (doc);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	result = device;
	_g_object_unref0 (doc);
	_g_free0 (template_path);
	_g_free0 (desc_path);
	return result;
}

static GUPnPXMLDoc*
rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self,
                                       RygelPlugin* plugin,
                                       const gchar* desc_path,
                                       const gchar* template_path,
                                       GError** error)
{
	GUPnPXMLDoc* doc = NULL;
	GUPnPXMLDoc* _tmp0_;
	RygelDescriptionFile* file = NULL;
	GUPnPXMLDoc* _tmp1_;
	RygelDescriptionFile* _tmp2_;
	RygelDescriptionFile* _tmp3_;
	RygelDescriptionFile* _tmp4_;
	RygelDescriptionFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	RygelDescriptionFile* _tmp8_;
	RygelPluginCapabilities _tmp9_;
	RygelPluginCapabilities _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* udn = NULL;
	RygelDescriptionFile* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	RygelDescriptionFile* _tmp32_;
	GError* _inner_error0_ = NULL;
	GUPnPXMLDoc* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	g_return_val_if_fail (desc_path != NULL, NULL);
	g_return_val_if_fail (template_path != NULL, NULL);
	_tmp0_ = rygel_root_device_factory_get_latest_doc (self, desc_path, template_path, &_inner_error0_);
	doc = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = doc;
	_tmp2_ = rygel_description_file_new_from_xml_document (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	rygel_root_device_factory_add_services_to_desc (self, _tmp3_, plugin);
	_tmp4_ = file;
	rygel_root_device_factory_add_icons_to_desc (self, _tmp4_, plugin);
	_tmp5_ = file;
	_tmp6_ = rygel_root_device_factory_get_friendly_name (self, plugin);
	_tmp7_ = _tmp6_;
	rygel_description_file_set_friendly_name (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = file;
	_tmp9_ = rygel_plugin_get_capabilities (plugin);
	_tmp10_ = _tmp9_;
	rygel_description_file_set_dlna_caps (_tmp8_, _tmp10_);
	_tmp11_ = rygel_plugin_get_description (plugin);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		RygelDescriptionFile* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = file;
		_tmp14_ = rygel_plugin_get_description (plugin);
		_tmp15_ = _tmp14_;
		rygel_description_file_set_model_description (_tmp13_, _tmp15_);
	}
	_tmp16_ = file;
	_tmp17_ = rygel_description_file_get_udn (_tmp16_);
	udn = _tmp17_;
	_tmp19_ = udn;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = udn;
		_tmp18_ = g_strcmp0 (_tmp20_, "") == 0;
	}
	if (_tmp18_) {
		RygelDescriptionFile* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		{
			gchar* _tmp21_ = NULL;
			RygelConfiguration* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp22_ = self->priv->config;
			_tmp23_ = rygel_plugin_get_name (plugin);
			_tmp24_ = _tmp23_;
			_tmp25_ = rygel_configuration_get_string (_tmp22_, _tmp24_, "uuid", &_inner_error0_);
			_tmp21_ = _tmp25_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp26_ = _tmp21_;
			_tmp21_ = NULL;
			_g_free0 (udn);
			udn = _tmp26_;
			_g_free0 (_tmp21_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			gchar* _tmp27_;
			g_clear_error (&_inner_error0_);
			_tmp27_ = g_uuid_string_random ();
			_g_free0 (udn);
			udn = _tmp27_;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (udn);
			_g_object_unref0 (file);
			_g_object_unref0 (doc);
			return NULL;
		}
		_tmp28_ = file;
		_tmp29_ = udn;
		_tmp30_ = g_strconcat ("uuid:", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		rygel_description_file_set_udn (_tmp28_, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = file;
	rygel_description_file_save (_tmp32_, desc_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (udn);
		_g_object_unref0 (file);
		_g_object_unref0 (doc);
		return NULL;
	}
	result = doc;
	_g_free0 (udn);
	_g_object_unref0 (file);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
rygel_root_device_factory_get_friendly_name (RygelRootDeviceFactory* self,
                                             RygelPlugin* plugin)
{
	gchar* title = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		RygelConfiguration* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = self->priv->config;
		_tmp2_ = rygel_plugin_get_name (plugin);
		_tmp3_ = _tmp2_;
		_tmp4_ = rygel_configuration_get_title (_tmp1_, _tmp3_, &_inner_error0_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (title);
		title = _tmp5_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		g_clear_error (&_inner_error0_);
		_tmp6_ = rygel_plugin_get_title (plugin);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (title);
		title = _tmp8_;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (title);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp9_ = title;
	_tmp10_ = g_get_real_name ();
	_tmp11_ = string_replace (_tmp9_, "@REALNAME@", _tmp10_);
	_g_free0 (title);
	title = _tmp11_;
	_tmp12_ = title;
	_tmp13_ = g_get_user_name ();
	_tmp14_ = string_replace (_tmp12_, "@USERNAME@", _tmp13_);
	_g_free0 (title);
	title = _tmp14_;
	_tmp15_ = title;
	_tmp16_ = g_get_host_name ();
	_tmp17_ = string_replace (_tmp15_, "@HOSTNAME@", _tmp16_);
	_g_free0 (title);
	title = _tmp17_;
	_tmp18_ = title;
	_tmp19_ = rygel_get_pretty_host_name ();
	_tmp20_ = _tmp19_;
	_tmp21_ = string_replace (_tmp18_, "@PRETTY_HOSTNAME@", _tmp20_);
	_g_free0 (title);
	title = _tmp21_;
	_g_free0 (_tmp20_);
	result = title;
	return result;
}

static void
rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self,
                                                RygelDescriptionFile* file,
                                                RygelPlugin* plugin)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (plugin != NULL);
	rygel_description_file_clear_service_list (file);
	{
		GeeArrayList* _resource_info_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _resource_info_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _resource_info_index = 0;
		_tmp0_ = rygel_plugin_get_resource_infos (plugin);
		_tmp1_ = _tmp0_;
		_resource_info_list = _tmp1_;
		_tmp2_ = _resource_info_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_resource_info_size = _tmp4_;
		_resource_info_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			RygelResourceInfo* resource_info = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			RygelResourceInfo* _tmp9_;
			_resource_info_index = _resource_info_index + 1;
			_tmp5_ = _resource_info_index;
			_tmp6_ = _resource_info_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _resource_info_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _resource_info_index);
			resource_info = (RygelResourceInfo*) _tmp8_;
			_tmp9_ = resource_info;
			if (g_type_is_a (_tmp9_->type, gupnp_service_get_type ())) {
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				RygelResourceInfo* _tmp12_;
				_tmp10_ = rygel_plugin_get_name (plugin);
				_tmp11_ = _tmp10_;
				_tmp12_ = resource_info;
				rygel_description_file_add_service (file, _tmp11_, _tmp12_);
			}
			_rygel_resource_info_unref0 (resource_info);
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self,
                                             RygelDescriptionFile* file,
                                             RygelPlugin* plugin)
{
	GeeArrayList* icons = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeArrayList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = rygel_plugin_get_icon_infos (plugin);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	icons = _tmp2_;
	_tmp4_ = icons;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = icons;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == 0;
	}
	if (_tmp3_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		_tmp8_ = rygel_plugin_get_name (plugin);
		_tmp9_ = _tmp8_;
		g_debug ("rygel-root-device-factory.vala:181: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", _tmp9_);
		_tmp10_ = rygel_plugin_get_default_icons (plugin);
		_tmp11_ = _tmp10_;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (icons);
		icons = _tmp12_;
	}
	rygel_description_file_clear_icon_list (file);
	{
		GeeArrayList* _icon_list = NULL;
		GeeArrayList* _tmp13_;
		gint _icon_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _icon_index = 0;
		_tmp13_ = icons;
		_icon_list = _tmp13_;
		_tmp14_ = _icon_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_icon_size = _tmp16_;
		_icon_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			RygelIconInfo* icon = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			gchar* remote_path = NULL;
			RygelIconInfo* _tmp21_;
			gchar* _tmp22_;
			RygelIconInfo* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			RygelIconInfo* _tmp33_;
			const gchar* _tmp34_;
			_icon_index = _icon_index + 1;
			_tmp17_ = _icon_index;
			_tmp18_ = _icon_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _icon_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _icon_index);
			icon = (RygelIconInfo*) _tmp20_;
			_tmp21_ = icon;
			_tmp22_ = rygel_root_device_factory_get_icon_remote_path (self, _tmp21_, plugin);
			remote_path = _tmp22_;
			_tmp23_ = icon;
			_tmp24_ = _tmp23_->uri;
			if (g_str_has_prefix (_tmp24_, "file://")) {
				gchar* local_path = NULL;
				RygelIconInfo* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				GUPnPContext* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				_tmp25_ = icon;
				_tmp26_ = _tmp25_->uri;
				_tmp27_ = string_substring (_tmp26_, (glong) 7, (glong) -1);
				local_path = _tmp27_;
				_tmp28_ = self->priv->_context;
				_tmp29_ = local_path;
				_tmp30_ = remote_path;
				gupnp_context_host_path (_tmp28_, _tmp29_, _tmp30_);
				_g_free0 (local_path);
			}
			_tmp31_ = rygel_plugin_get_name (plugin);
			_tmp32_ = _tmp31_;
			_tmp33_ = icon;
			_tmp34_ = remote_path;
			rygel_description_file_add_icon (file, _tmp32_, _tmp33_, _tmp34_);
			_g_free0 (remote_path);
			_rygel_icon_info_unref0 (icon);
		}
	}
	_g_object_unref0 (icons);
}

static gchar*
rygel_root_device_factory_get_icon_remote_path (RygelRootDeviceFactory* self,
                                                RygelIconInfo* icon_info,
                                                RygelPlugin* plugin)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_info != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	_tmp0_ = icon_info->uri;
	if (g_str_has_prefix (_tmp0_, "file://")) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp1_ = rygel_plugin_get_name (plugin);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("/", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "-", NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("%i", icon_info->width);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "x", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("%i", icon_info->height);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "x", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%i", icon_info->depth);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, ".", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = icon_info->file_extension;
		_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		result = _tmp27_;
		return result;
	} else {
		gchar* uri = NULL;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		GUPnPContext* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp28_ = icon_info->uri;
		_tmp29_ = g_strdup (_tmp28_);
		uri = _tmp29_;
		_tmp30_ = uri;
		_tmp31_ = self->priv->_context;
		_tmp32_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = string_replace (_tmp30_, "@ADDRESS@", _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp35_);
		result = uri;
		return result;
	}
}

static GUPnPXMLDoc*
rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self,
                                          const gchar* path1,
                                          const gchar* path2,
                                          GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFile* _tmp5_;
	GFileInfo* _tmp6_;
	guint64 mod1 = 0ULL;
	GFileInfo* _tmp7_;
	GFile* _tmp8_;
	GFileInfo* _tmp9_ = NULL;
	GFile* _tmp10_;
	GFileInfo* _tmp11_;
	GFileInfo* _tmp12_;
	guint64 mod2 = 0ULL;
	GFileInfo* _tmp13_;
	GError* _inner_error0_ = NULL;
	GUPnPXMLDoc* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path1 != NULL, NULL);
	g_return_val_if_fail (path2 != NULL, NULL);
	_tmp0_ = g_file_new_for_path (path1);
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		GUPnPXMLDoc* _tmp2_ = NULL;
		GUPnPXMLDoc* _tmp3_;
		GUPnPXMLDoc* _tmp4_;
		_tmp3_ = gupnp_xml_doc_new_from_path (path2, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			return NULL;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp4_;
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (file);
		return result;
	}
	_tmp5_ = file;
	_tmp6_ = g_file_query_info (_tmp5_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	info = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp7_ = info;
	mod1 = g_file_info_get_attribute_uint64 (_tmp7_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	_tmp8_ = g_file_new_for_path (path2);
	_g_object_unref0 (file);
	file = _tmp8_;
	_tmp10_ = file;
	_tmp11_ = g_file_query_info (_tmp10_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	_tmp9_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp12_ = _tmp9_;
	_tmp9_ = NULL;
	_g_object_unref0 (info);
	info = _tmp12_;
	_tmp13_ = info;
	mod2 = g_file_info_get_attribute_uint64 (_tmp13_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	if (mod1 > mod2) {
		{
			GUPnPXMLDoc* _tmp14_ = NULL;
			GUPnPXMLDoc* _tmp15_;
			GUPnPXMLDoc* _tmp16_;
			_tmp15_ = gupnp_xml_doc_new_from_path (path1, &_inner_error0_);
			_tmp14_ = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp16_ = _tmp14_;
			_tmp14_ = NULL;
			result = _tmp16_;
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GUPnPXMLDoc* _tmp17_ = NULL;
			GUPnPXMLDoc* _tmp18_;
			GUPnPXMLDoc* _tmp19_;
			g_clear_error (&_inner_error0_);
			_tmp18_ = gupnp_xml_doc_new_from_path (path2, &_inner_error0_);
			_tmp17_ = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __finally0;
			}
			_tmp19_ = _tmp17_;
			_tmp17_ = NULL;
			result = _tmp19_;
			_g_object_unref0 (_tmp17_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		__finally0:
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	} else {
		GUPnPXMLDoc* _tmp20_ = NULL;
		GUPnPXMLDoc* _tmp21_;
		GUPnPXMLDoc* _tmp22_;
		_tmp21_ = gupnp_xml_doc_new_from_path (path2, &_inner_error0_);
		_tmp20_ = _tmp21_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return NULL;
		}
		_tmp22_ = _tmp20_;
		_tmp20_ = NULL;
		result = _tmp22_;
		_g_object_unref0 (_tmp20_);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
}

static void
rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self,
                                             const gchar* dir_path,
                                             GError** error)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir_path != NULL);
	g_mkdir_with_parents (dir_path, 0750);
}

GUPnPContext*
rygel_root_device_factory_get_context (RygelRootDeviceFactory* self)
{
	GUPnPContext* result;
	GUPnPContext* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}

static void
rygel_root_device_factory_set_context (RygelRootDeviceFactory* self,
                                       GUPnPContext* value)
{
	GUPnPContext* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_root_device_factory_get_context (self);
	if (old_value != value) {
		GUPnPContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_context);
		self->priv->_context = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_root_device_factory_properties[RYGEL_ROOT_DEVICE_FACTORY_CONTEXT_PROPERTY]);
	}
}

static void
rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass,
                                      gpointer klass_data)
{
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelRootDeviceFactory_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_root_device_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_root_device_factory_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ROOT_DEVICE_FACTORY_CONTEXT_PROPERTY, rygel_root_device_factory_properties[RYGEL_ROOT_DEVICE_FACTORY_CONTEXT_PROPERTY] = g_param_spec_object ("context", "context", "context", gupnp_context_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
rygel_root_device_factory_g_initable_interface_init (GInitableIface * iface,
                                                     gpointer iface_data)
{
	rygel_root_device_factory_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) rygel_root_device_factory_real_init;
}

static void
rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self,
                                         gpointer klass)
{
	self->priv = rygel_root_device_factory_get_instance_private (self);
}

static void
rygel_root_device_factory_finalize (GObject * obj)
{
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	_g_object_unref0 (self->priv->_context);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->desc_dir);
	G_OBJECT_CLASS (rygel_root_device_factory_parent_class)->finalize (obj);
}

/**
 * This is a factory to create #RygelRootDevice objects for
 * a given UPnP context.
 *
 * Call rygel_root_device_factory_create() with a plugin
 * to create a root device for the plugin.
 */
 G_GNUC_NO_INLINE static GType
rygel_root_device_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) rygel_root_device_factory_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_root_device_factory_type_id;
	rygel_root_device_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRootDeviceFactory", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_root_device_factory_type_id, g_initable_get_type (), &g_initable_info);
	RygelRootDeviceFactory_private_offset = g_type_add_instance_private (rygel_root_device_factory_type_id, sizeof (RygelRootDeviceFactoryPrivate));
	return rygel_root_device_factory_type_id;
}

GType
rygel_root_device_factory_get_type (void)
{
	static volatile gsize rygel_root_device_factory_type_id__once = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__once)) {
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = rygel_root_device_factory_get_type_once ();
		g_once_init_leave (&rygel_root_device_factory_type_id__once, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__once;
}

static void
_vala_rygel_root_device_factory_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	switch (property_id) {
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT_PROPERTY:
		g_value_set_object (value, rygel_root_device_factory_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_root_device_factory_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	switch (property_id) {
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT_PROPERTY:
		rygel_root_device_factory_set_context (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

