/* rygel-playbin-player.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010,2011,2012 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Neha Shanbhag <N.Shanbhag@cablelabs.com>
 *         Sivakumar Mani <siva@orexel.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-renderer-gst.h"
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgupnp-av/gupnp-av.h>
#include "rygel-core.h"
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include "rygel-renderer.h"
#include <gio/gio.h>
#include <gst/audio/audio.h>

#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING "Streaming"
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE "Interactive"
#define RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE "http-get:%s:*:%s"

enum  {
	RYGEL_PLAYBIN_PLAYER_0_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBIN_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_URI_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_MIME_TYPE_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_METADATA_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_CAN_SEEK_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_USER_AGENT_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_VOLUME_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_DURATION_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_SIZE_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_POSITION_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_BYTE_POSITION_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_NUM_PROPERTIES
};
static GParamSpec* rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))

struct _RygelPlaybinPlayerPrivate {
	GstElement* _playbin;
	gchar* _playback_state;
	gchar** _allowed_playback_speeds;
	gint _allowed_playback_speeds_length1;
	gint __allowed_playback_speeds_size_;
	gchar* _new_playback_speed;
	gchar* _playback_speed;
	gchar* transfer_mode;
	gboolean uri_update_hint;
	gchar* _uri;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _user_agent;
	gchar* _content_features;
	GUPnPProtocolInfo* protocol_info;
	gint64 _parsed_duration;
	GList* _supported_profiles;
	GstElement* source;
};

static gint RygelPlaybinPlayer_private_offset;
static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static gboolean rygel_playbin_player_has_dlna_src;
static gboolean rygel_playbin_player_has_dlna_src = FALSE;
static RygelMediaPlayerIface * rygel_playbin_player_rygel_media_player_parent_iface = NULL;

static void _rygel_dlna_profile_unref0_ (gpointer var);
static inline void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
static RygelPlaybinPlayer* rygel_playbin_player_new (GError** error);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type,
                                                    GError** error);
static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self,
                                       GstElement* value);
static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self);
static gboolean rygel_playbin_player_seek_with_format (RygelPlaybinPlayer* self,
                                                GstFormat format,
                                                gint64 target);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base,
                                         gint64 time);
static gboolean rygel_playbin_player_real_seek_bytes (RygelMediaPlayer* base,
                                               gint64 bytes);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base,
                                                 gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base,
                                                  gint* result_length1);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self);
static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self,
                                       GstBus* bus,
                                       GstMessage* message);
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self);
static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self,
                                           GstElement* pipeline,
                                           GstElement* source);
static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self,
                                         GParamSpec* pspec);
static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender,
                                                                   GstElement* source,
                                                                   gpointer self);
static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender,
                                                        GstMessage* message,
                                                        gpointer self);
static void rygel_playbin_player_guess_duration (RygelPlaybinPlayer* self);
static void __lambda4_ (RygelPlaybinPlayer* self,
                 GUPnPDIDLLiteObject* object);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender,
                                                          GUPnPDIDLLiteObject* object,
                                                          gpointer self);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void rygel_playbin_player_finalize (GObject * obj);
static GType rygel_playbin_player_get_type_once (void);
static void _vala_rygel_playbin_player_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_rygel_playbin_player_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[45] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-flac+ogg", "audio/flac", "audio/mp4", "audio/3gpp", "audio/vnd.dlna.adts", "audio/x-mod", "audio/x-wav", "audio/wav", "audio/x-ac3", "audio/x-m4a", "audio/aac", "audio/l16;rate=44100;channels=2", "audio/l16;rate=44100;channels=1", "audio/l16;channels=2;rate=44100", "audio/l16;channels=1;rate=44100", "audio/l16;rate=44100", "image/jpeg", "image/png", "video/x-theora", "video/x-theora+ogg", "video/x-oggm", "video/ogg", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/x-mkv", "video/mpeg", "video/mp4", "video/avi", "application/x-shockwave-flash", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv"};

GQuark
rygel_playbin_player_error_quark (void)
{
	return g_quark_from_static_string ("rygel-playbin-player-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_playbin_player_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_PLAYBIN_PLAYER_ERROR_NO_ELEMENT, "RYGEL_PLAYBIN_PLAYER_ERROR_NO_ELEMENT", "no-element"}, {0, NULL, NULL}};
	GType rygel_playbin_player_error_type_id;
	rygel_playbin_player_error_type_id = g_enum_register_static ("RygelPlaybinPlayerError", values);
	return rygel_playbin_player_error_type_id;
}

GType
rygel_playbin_player_error_get_type (void)
{
	static volatile gsize rygel_playbin_player_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_playbin_player_error_type_id__once)) {
		GType rygel_playbin_player_error_type_id;
		rygel_playbin_player_error_type_id = rygel_playbin_player_error_get_type_once ();
		g_once_init_leave (&rygel_playbin_player_error_type_id__once, rygel_playbin_player_error_type_id);
	}
	return rygel_playbin_player_error_type_id__once;
}

static inline gpointer
rygel_playbin_player_get_instance_private (RygelPlaybinPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPlaybinPlayer_private_offset);
}

static void
_rygel_dlna_profile_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
}

static inline void
_g_list_free__rygel_dlna_profile_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _rygel_dlna_profile_unref0_);
}

static RygelPlaybinPlayer*
rygel_playbin_player_construct (GType object_type,
                                GError** error)
{
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = gst_element_factory_make ("playbin3", NULL);
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	_tmp1_ = _tmp0_;
	rygel_playbin_player_set_playbin (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_playbin;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_PLAYBIN_PLAYER_ERROR, RYGEL_PLAYBIN_PLAYER_ERROR_NO_ELEMENT, _ ("Your GStreamer installation seems to be missing the “playbin3” element" \
". The Rygel GStreamer renderer implementation cannot work without it"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	rygel_playbin_player_setup_playbin (self);
	return self;
}

static RygelPlaybinPlayer*
rygel_playbin_player_new (GError** error)
{
	return rygel_playbin_player_construct (RYGEL_TYPE_PLAYBIN_PLAYER, error);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelPlaybinPlayer*
rygel_playbin_player_instance (GError** error)
{
	RygelPlaybinPlayer* _tmp0_;
	RygelPlaybinPlayer* _tmp4_;
	RygelPlaybinPlayer* _tmp5_;
	GError* _inner_error0_ = NULL;
	RygelPlaybinPlayer* result;
	_tmp0_ = rygel_playbin_player_player;
	if (_tmp0_ == NULL) {
		RygelPlaybinPlayer* _tmp1_ = NULL;
		RygelPlaybinPlayer* _tmp2_;
		RygelPlaybinPlayer* _tmp3_;
		_tmp2_ = rygel_playbin_player_new (&_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (rygel_playbin_player_player);
		rygel_playbin_player_player = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	_tmp4_ = rygel_playbin_player_player;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}

static gboolean
rygel_playbin_player_seek_with_format (RygelPlaybinPlayer* self,
                                       GstFormat format,
                                       gint64 target)
{
	gboolean seeked = FALSE;
	gdouble speed = 0.0;
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_new_playback_speed;
	speed = rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, _tmp0_);
	if (speed > ((gdouble) 0)) {
		GstElement* _tmp1_;
		_tmp1_ = self->priv->_playbin;
		seeked = gst_element_seek (_tmp1_, speed, format, (GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_SKIP) | GST_SEEK_FLAG_ACCURATE, GST_SEEK_TYPE_SET, target, GST_SEEK_TYPE_NONE, (gint64) -1);
	} else {
		GstElement* _tmp2_;
		_tmp2_ = self->priv->_playbin;
		seeked = gst_element_seek (_tmp2_, speed, format, (GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_SKIP) | GST_SEEK_FLAG_ACCURATE, GST_SEEK_TYPE_SET, (gint64) 0, GST_SEEK_TYPE_SET, target);
	}
	if (seeked) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->_new_playback_speed;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->_playback_speed);
		self->priv->_playback_speed = _tmp4_;
	}
	result = seeked;
	return result;
}

static gboolean
rygel_playbin_player_real_seek (RygelMediaPlayer* base,
                                gint64 time)
{
	RygelPlaybinPlayer * self;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gboolean result;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_new_playback_speed;
	g_debug ("rygel-playbin-player.vala:412: Seeking %lld usec, play speed %s", time, _tmp0_);
	_tmp1_ = rygel_media_player_get_duration ((RygelMediaPlayer*) self);
	_tmp2_ = _tmp1_;
	if (time > _tmp2_) {
		result = FALSE;
		return result;
	}
	result = rygel_playbin_player_seek_with_format (self, GST_FORMAT_TIME, time * GST_USECOND);
	return result;
}

static gboolean
rygel_playbin_player_real_seek_bytes (RygelMediaPlayer* base,
                                      gint64 bytes)
{
	RygelPlaybinPlayer * self;
	const gchar* _tmp0_;
	gint64 size = 0LL;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_new_playback_speed;
	g_debug ("rygel-playbin-player.vala:424: Seeking %lld bytes, play speed %s", bytes, _tmp0_);
	_tmp1_ = rygel_media_player_get_size ((RygelMediaPlayer*) self);
	_tmp2_ = _tmp1_;
	size = _tmp2_;
	if (size > ((gint64) 0)) {
		_tmp3_ = bytes > size;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	result = rygel_playbin_player_seek_with_format (self, GST_FORMAT_BYTES, bytes);
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base,
                                         gint* result_length1)
{
	RygelPlaybinPlayer * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** result;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = _vala_array_dup1 (RYGEL_PLAYBIN_PLAYER_protocols, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols));
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base,
                                          gint* result_length1)
{
	RygelPlaybinPlayer * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** result;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = _vala_array_dup2 (RYGEL_PLAYBIN_PLAYER_mime_types, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types));
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gboolean
rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self)
{
	GstElement* typefind = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	GstCaps* caps = NULL;
	GstElement* _tmp2_;
	GstCaps* _tmp3_;
	GstCaps* _tmp4_;
	GstStructure* structure = NULL;
	GstCaps* _tmp5_;
	GstStructure* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GstStructure* _tmp8_;
	const gchar* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_playbin;
	_tmp1_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_bin_get_type (), GstBin), "typefind");
	_g_object_unref0 (typefind);
	typefind = _tmp1_;
	_tmp2_ = typefind;
	g_object_get (_tmp2_, "caps", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	caps = _tmp4_;
	_tmp5_ = caps;
	_tmp6_ = gst_caps_get_structure (_tmp5_, (guint) 0);
	structure = _tmp6_;
	_tmp8_ = structure;
	_tmp9_ = gst_structure_get_name (_tmp8_);
	if (g_strcmp0 (_tmp9_, "image/jpeg") == 0) {
		_tmp7_ = TRUE;
	} else {
		GstStructure* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = structure;
		_tmp11_ = gst_structure_get_name (_tmp10_);
		_tmp7_ = g_strcmp0 (_tmp11_, "image/png") == 0;
	}
	result = _tmp7_;
	_gst_caps_unref0 (caps);
	_g_object_unref0 (typefind);
	return result;
}

static void
rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self,
                                  GstBus* bus,
                                  GstMessage* message)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	switch (message->type) {
		case GST_MESSAGE_DURATION_CHANGED:
		{
			GstElement* _tmp0_;
			_tmp0_ = self->priv->_playbin;
			if (gst_element_query_duration (_tmp0_, GST_FORMAT_TIME, NULL)) {
				g_object_notify ((GObject*) self, "duration");
			}
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstObject* _tmp1_;
			GstElement* _tmp2_;
			_tmp1_ = message->src;
			_tmp2_ = self->priv->_playbin;
			if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gst_object_get_type (), GstObject)) {
				GstState old_state = 0;
				GstState new_state = 0;
				GstState pending = 0;
				GstState _tmp3_ = 0;
				GstState _tmp4_ = 0;
				GstState _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gst_message_parse_state_changed (message, &_tmp3_, &_tmp4_, &_tmp5_);
				old_state = _tmp3_;
				new_state = _tmp4_;
				pending = _tmp5_;
				if (old_state == GST_STATE_READY) {
					_tmp6_ = new_state == GST_STATE_PAUSED;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					GstElement* _tmp19_;
					if (self->priv->uri_update_hint) {
						gchar* uri = NULL;
						GstElement* _tmp7_;
						gchar* _tmp8_;
						gchar* _tmp9_;
						gboolean _tmp10_ = FALSE;
						const gchar* _tmp11_;
						const gchar* _tmp12_;
						self->priv->uri_update_hint = FALSE;
						_tmp7_ = self->priv->_playbin;
						g_object_get (_tmp7_, "current-uri", &_tmp8_, NULL);
						_tmp9_ = _tmp8_;
						uri = _tmp9_;
						_tmp11_ = self->priv->_uri;
						_tmp12_ = uri;
						if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
							const gchar* _tmp13_;
							_tmp13_ = uri;
							_tmp10_ = g_strcmp0 (_tmp13_, "") != 0;
						} else {
							_tmp10_ = FALSE;
						}
						if (_tmp10_) {
							GstElement* _tmp14_;
							gchar* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							gchar* _tmp18_;
							_tmp14_ = self->priv->_playbin;
							g_object_get (_tmp14_, "uri", &_tmp15_, NULL);
							_tmp16_ = _tmp15_;
							_g_free0 (self->priv->_uri);
							self->priv->_uri = _tmp16_;
							g_object_notify ((GObject*) self, "uri");
							_tmp17_ = rygel_playbin_player_generate_basic_didl (self);
							_tmp18_ = _tmp17_;
							rygel_media_player_set_metadata ((RygelMediaPlayer*) self, _tmp18_);
							_g_free0 (_tmp18_);
						}
						_g_free0 (uri);
					}
					_tmp19_ = self->priv->_playbin;
					if (gst_element_query_duration (_tmp19_, GST_FORMAT_TIME, NULL)) {
						g_object_notify ((GObject*) self, "duration");
					}
				}
				if (pending == GST_STATE_VOID_PENDING) {
					switch (new_state) {
						case GST_STATE_PAUSED:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PAUSED_PLAYBACK");
							break;
						}
						case GST_STATE_NULL:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
							break;
						}
						case GST_STATE_PLAYING:
						{
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
							break;
						}
						default:
						{
							break;
						}
					}
				}
				if (old_state == GST_STATE_PAUSED) {
					_tmp20_ = new_state == GST_STATE_PLAYING;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
				}
			}
			break;
		}
		case GST_MESSAGE_EOS:
		{
			if (!rygel_playbin_player_is_rendering_image (self)) {
				g_debug ("rygel-playbin-player.vala:570: EOS");
				rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "EOS");
			} else {
				g_debug ("rygel-playbin-player.vala:573: Content is image, ignoring EOS");
			}
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* _error_ = NULL;
			gchar* debug_message = NULL;
			GError* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			GstElement* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gst_message_parse_error (message, &_tmp21_, &_tmp22_);
			_g_error_free0 (_error_);
			_error_ = _tmp21_;
			_g_free0 (debug_message);
			debug_message = _tmp22_;
			_tmp23_ = self->priv->_playbin;
			_tmp24_ = gst_object_get_name ((GstObject*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = _tmp25_;
			_tmp27_ = _error_;
			_tmp28_ = _tmp27_->message;
			_tmp29_ = debug_message;
			g_warning ("rygel-playbin-player.vala:583: Error from GStreamer element %s: %s (%s" \
")", _tmp26_, _tmp28_, _tmp29_);
			_g_free0 (_tmp26_);
			g_warning ("rygel-playbin-player.vala:587: Going to STOPPED state");
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
			_g_free0 (debug_message);
			_g_error_free0 (_error_);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self,
                                      GstElement* pipeline,
                                      GstElement* source)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GstElement* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pipeline != NULL);
	g_return_if_fail (source != NULL);
	_tmp1_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) source));
	if (g_strcmp0 (_tmp1_, "GstSoupHTTPSrc") == 0) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->transfer_mode;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		GstStructure* structure = NULL;
		GstStructure* _tmp4_;
		GstStructure* _tmp5_;
		const gchar* _tmp6_;
		GValue _tmp7_ = {0};
		GstStructure* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp3_ = self->priv->transfer_mode;
		g_debug ("rygel-playbin-player.vala:601: Setting transfer mode to %s", _tmp3_);
		_tmp4_ = gst_structure_new_empty ("HTTPHeaders");
		structure = _tmp4_;
		_tmp5_ = structure;
		_tmp6_ = self->priv->transfer_mode;
		g_value_init (&_tmp7_, G_TYPE_STRING);
		g_value_set_string (&_tmp7_, _tmp6_);
		gst_structure_set_value (_tmp5_, "transferMode.dlna.org", &_tmp7_);
		G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
		_tmp8_ = structure;
		g_object_set (source, "extra-headers", _tmp8_, NULL);
		_tmp9_ = rygel_media_player_get_user_agent ((RygelMediaPlayer*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		g_object_set (source, "user-agent", _tmp11_, NULL);
		_g_free0 (_tmp11_);
		_gst_structure_free0 (structure);
	}
	_tmp12_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp12_;
}

static void
rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self,
                                    GParamSpec* pspec)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	self->priv->uri_update_hint = TRUE;
}

/**
     * Generate basic DIDLLite information.
     *
     * This is used when the URI gets changed externally. DLNA requires that a
     * minimum DIDLLite is always present if the URI is not empty.
     */
static gchar*
rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self)
{
	GUPnPDIDLLiteWriter* writer = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteItem* item = NULL;
	GUPnPDIDLLiteItem* _tmp1_;
	GUPnPDIDLLiteResource* resource = NULL;
	GUPnPDIDLLiteResource* _tmp2_;
	const gchar* _tmp3_;
	GFile* file = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gupnp_didl_lite_writer_new (NULL);
	writer = _tmp0_;
	_tmp1_ = gupnp_didl_lite_writer_add_item (writer);
	item = _tmp1_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) item, "1");
	gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) item, "-1");
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) item, "object.item");
	_tmp2_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) item);
	resource = _tmp2_;
	_tmp3_ = self->priv->_uri;
	gupnp_didl_lite_resource_set_uri (resource, _tmp3_);
	_tmp4_ = rygel_media_player_get_uri ((RygelMediaPlayer*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_new_for_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	file = _tmp8_;
	_tmp9_ = g_file_get_basename (file);
	_tmp10_ = _tmp9_;
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) item, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = gupnp_didl_lite_writer_get_string (writer);
	result = _tmp11_;
	_g_object_unref0 (file);
	_g_object_unref0 (resource);
	_g_object_unref0 (item);
	_g_object_unref0 (writer);
	return result;
}

static void
_rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender,
                                                              GstElement* source,
                                                              gpointer self)
{
	rygel_playbin_player_on_source_setup ((RygelPlaybinPlayer*) self, _sender, source);
}

static void
_rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	rygel_playbin_player_on_uri_notify ((RygelPlaybinPlayer*) self, pspec);
}

static void
_rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender,
                                                   GstMessage* message,
                                                   gpointer self)
{
	rygel_playbin_player_bus_handler ((RygelPlaybinPlayer*) self, _sender, message);
}

static void
rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self)
{
	GstElement* _tmp20_;
	GstElement* _tmp21_;
	GstElement* _tmp22_;
	GstBus* bus = NULL;
	GstElement* _tmp23_;
	GstBus* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp0_;
		gchar* sink_launch = NULL;
		RygelMetaConfig* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		GstElement* sink = NULL;
		const gchar* _tmp4_;
		GstElement* _tmp5_;
		GstElement* _tmp6_;
		GstElement* _tmp7_;
		_tmp0_ = rygel_meta_config_get_default ();
		config = _tmp0_;
		_tmp1_ = config;
		_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) _tmp1_, "Playbin", "audio-sink", &_inner_error0_);
		sink_launch = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp3_ = sink_launch;
		g_debug ("rygel-playbin-player.vala:641: Trying to parse audio sink %s", _tmp3_);
		_tmp4_ = sink_launch;
		_tmp5_ = gst_parse_bin_from_description_full (_tmp4_, TRUE, NULL, GST_PARSE_FLAG_FATAL_ERRORS, &_inner_error0_);
		if (_tmp5_ != NULL) {
			g_object_ref_sink (_tmp5_);
		}
		sink = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (sink_launch);
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->_playbin;
		_tmp7_ = sink;
		g_object_set (_tmp6_, "audio-sink", _tmp7_, NULL);
		_g_object_unref0 (sink);
		_g_free0 (sink_launch);
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_debug ("rygel-playbin-player.vala:648: No audio sink configured, using default" \
": %s", _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp10_;
		gchar* sink_launch = NULL;
		RygelMetaConfig* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		GstElement* sink = NULL;
		const gchar* _tmp14_;
		GstElement* _tmp15_;
		GstElement* _tmp16_;
		GstElement* _tmp17_;
		_tmp10_ = rygel_meta_config_get_default ();
		config = _tmp10_;
		_tmp11_ = config;
		_tmp12_ = rygel_configuration_get_string ((RygelConfiguration*) _tmp11_, "Playbin", "video-sink", &_inner_error0_);
		sink_launch = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch1_g_error;
		}
		_tmp13_ = sink_launch;
		g_debug ("rygel-playbin-player.vala:654: Trying to parse video sink %s", _tmp13_);
		_tmp14_ = sink_launch;
		_tmp15_ = gst_parse_bin_from_description_full (_tmp14_, TRUE, NULL, GST_PARSE_FLAG_FATAL_ERRORS, &_inner_error0_);
		if (_tmp15_ != NULL) {
			g_object_ref_sink (_tmp15_);
		}
		sink = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (sink_launch);
			_g_object_unref0 (config);
			goto __catch1_g_error;
		}
		_tmp16_ = self->priv->_playbin;
		_tmp17_ = sink;
		g_object_set (_tmp16_, "video-sink", _tmp17_, NULL);
		_g_object_unref0 (sink);
		_g_free0 (sink_launch);
		_g_object_unref0 (config);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = _error_;
		_tmp19_ = _tmp18_->message;
		g_debug ("rygel-playbin-player.vala:661: No video sink configured, using default" \
": %s", _tmp19_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = self->priv->_playbin;
	g_object_set (_tmp20_, "auto-flush-bus", FALSE, NULL);
	_tmp21_ = self->priv->_playbin;
	g_signal_connect_object (_tmp21_, "source-setup", (GCallback) _rygel_playbin_player_on_source_setup_dynamic_source_setup0_, self, 0);
	_tmp22_ = self->priv->_playbin;
	g_signal_connect_object ((GObject*) _tmp22_, "notify::uri", (GCallback) _rygel_playbin_player_on_uri_notify_g_object_notify, self, 0);
	rygel_media_player_set_volume ((RygelMediaPlayer*) self, 0.5);
	_tmp23_ = self->priv->_playbin;
	_tmp24_ = gst_element_get_bus (_tmp23_);
	bus = _tmp24_;
	gst_bus_add_signal_watch_full (bus, G_PRIORITY_DEFAULT);
	g_signal_connect_object (bus, "message", (GCallback) _rygel_playbin_player_bus_handler_gst_bus_message, self, 0);
	_g_object_unref0 (bus);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda4_ (RygelPlaybinPlayer* self,
            GUPnPDIDLLiteObject* object)
{
	GList* resources = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (object != NULL);
	_tmp0_ = gupnp_didl_lite_object_get_resources (object);
	resources = _tmp0_;
	_tmp1_ = resources;
	{
		GList* resource_collection = NULL;
		GList* resource_it = NULL;
		resource_collection = _tmp1_;
		for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
			GUPnPDIDLLiteResource* _tmp2_;
			GUPnPDIDLLiteResource* resource = NULL;
			_tmp2_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
			resource = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_;
				GUPnPDIDLLiteResource* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp4_ = self->priv->_uri;
				_tmp5_ = resource;
				_tmp6_ = gupnp_didl_lite_resource_get_uri (_tmp5_);
				_tmp7_ = _tmp6_;
				if (g_strcmp0 (_tmp4_, _tmp7_) == 0) {
					GUPnPDIDLLiteResource* _tmp8_;
					glong _tmp9_;
					glong _tmp10_;
					_tmp8_ = resource;
					_tmp9_ = gupnp_didl_lite_resource_get_duration (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp3_ = _tmp10_ > ((glong) 0);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					GUPnPDIDLLiteResource* _tmp11_;
					glong _tmp12_;
					glong _tmp13_;
					_tmp11_ = resource;
					_tmp12_ = gupnp_didl_lite_resource_get_duration (_tmp11_);
					_tmp13_ = _tmp12_;
					self->priv->_parsed_duration = (gint64) (_tmp13_ * G_TIME_SPAN_SECOND);
					g_object_notify ((GObject*) self, "duration");
				}
				_g_object_unref0 (resource);
			}
		}
	}
	(resources == NULL) ? NULL : (resources = (_g_list_free__g_object_unref0_ (resources), NULL));
}

static void
___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender,
                                                     GUPnPDIDLLiteObject* object,
                                                     gpointer self)
{
	__lambda4_ ((RygelPlaybinPlayer*) self, object);
}

static void
rygel_playbin_player_guess_duration (RygelPlaybinPlayer* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GUPnPDIDLLiteParser* reader = NULL;
	GUPnPDIDLLiteParser* _tmp3_;
	GUPnPDIDLLiteParser* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_metadata;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_metadata;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = gupnp_didl_lite_parser_new ();
	reader = _tmp3_;
	_tmp4_ = reader;
	g_signal_connect_object (_tmp4_, "object-available", (GCallback) ___lambda4__gupnp_didl_lite_parser_object_available, self, 0);
	{
		GUPnPDIDLLiteParser* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = reader;
		_tmp6_ = self->priv->_metadata;
		gupnp_didl_lite_parser_parse_didl (_tmp5_, _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_debug ("rygel-playbin-player.vala:700: Failed to parse meta-data: %s", _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (reader);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (reader);
}

GstElement*
rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self)
{
	GstElement* result;
	GstElement* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_playbin;
	result = _tmp0_;
	return result;
}

static void
rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self,
                                  GstElement* value)
{
	GstElement* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_playbin_player_get_playbin (self);
	if (old_value != value) {
		GstElement* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_playbin);
		self->priv->_playbin = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_PLAYBIN_PROPERTY]);
	}
}

static gchar*
rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base)
{
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playback_state;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base,
                                              const gchar* value)
{
	RygelPlaybinPlayer* self;
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) GST_MSECOND);
	state = _tmp1_;
	pending = _tmp2_;
	g_debug ("rygel-playbin-player.vala:115: Changing playback state to %s.", value);
	_tmp3_ = value;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				gboolean _tmp6_ = FALSE;
				if (state != GST_STATE_NULL) {
					_tmp6_ = TRUE;
				} else {
					_tmp6_ = pending != GST_STATE_VOID_PENDING;
				}
				if (_tmp6_) {
					GstElement* _tmp7_;
					_tmp7_ = self->priv->_playbin;
					gst_element_set_state (_tmp7_, GST_STATE_NULL);
				} else {
					gchar* _tmp8_;
					_tmp8_ = g_strdup (value);
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp8_;
				}
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				gboolean _tmp9_ = FALSE;
				if (state != GST_STATE_PAUSED) {
					_tmp9_ = TRUE;
				} else {
					_tmp9_ = pending != GST_STATE_VOID_PENDING;
				}
				if (_tmp9_) {
					GstElement* _tmp10_;
					_tmp10_ = self->priv->_playbin;
					gst_element_set_state (_tmp10_, GST_STATE_PAUSED);
				} else {
					gchar* _tmp11_;
					_tmp11_ = g_strdup (value);
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp11_;
				}
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("PLAYING")))) {
		switch (0) {
			default:
			{
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = self->priv->_new_playback_speed;
				_tmp15_ = self->priv->_playback_speed;
				if (g_strcmp0 (_tmp14_, _tmp15_) != 0) {
					gboolean _tmp16_ = FALSE;
					if (state == GST_STATE_PLAYING) {
						_tmp16_ = TRUE;
					} else {
						_tmp16_ = state == GST_STATE_PAUSED;
					}
					_tmp13_ = _tmp16_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					_tmp12_ = pending == GST_STATE_VOID_PENDING;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					gchar* _tmp17_;
					gint64 _tmp18_;
					gint64 _tmp19_;
					_tmp17_ = g_strdup ("TRANSITIONING");
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp17_;
					_tmp18_ = rygel_media_player_get_position ((RygelMediaPlayer*) self);
					_tmp19_ = _tmp18_;
					rygel_media_player_seek ((RygelMediaPlayer*) self, _tmp19_);
				} else {
					gboolean _tmp20_ = FALSE;
					if (state != GST_STATE_PLAYING) {
						_tmp20_ = TRUE;
					} else {
						_tmp20_ = pending != GST_STATE_VOID_PENDING;
					}
					if (_tmp20_) {
						gchar* _tmp21_;
						GstElement* _tmp22_;
						_tmp21_ = g_strdup ("TRANSITIONING");
						_g_free0 (self->priv->_playback_state);
						self->priv->_playback_state = _tmp21_;
						_tmp22_ = self->priv->_playbin;
						gst_element_set_state (_tmp22_, GST_STATE_PLAYING);
					} else {
						gchar* _tmp23_;
						_tmp23_ = g_strdup (value);
						_g_free0 (self->priv->_playback_state);
						self->priv->_playback_state = _tmp23_;
					}
				}
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("EOS")))) {
		switch (0) {
			default:
			{
				gchar* _tmp24_;
				_tmp24_ = g_strdup (value);
				_g_free0 (self->priv->_playback_state);
				self->priv->_playback_state = _tmp24_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE_PROPERTY]);
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
rygel_playbin_player_real_get_allowed_playback_speeds (RygelMediaPlayer* base,
                                                       gint* result_length1)
{
	gchar** result;
	RygelPlaybinPlayer* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
rygel_playbin_player_real_get_playback_speed (RygelMediaPlayer* base)
{
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playback_speed;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_playbin_player_real_set_playback_speed (RygelMediaPlayer* base,
                                              const gchar* value)
{
	RygelPlaybinPlayer* self;
	gchar* _tmp0_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_new_playback_speed);
	self->priv->_new_playback_speed = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED_PROPERTY]);
}

static gchar*
rygel_playbin_player_real_get_uri (RygelMediaPlayer* base)
{
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_playbin_player_real_set_uri (RygelMediaPlayer* base,
                                   const gchar* value)
{
	RygelPlaybinPlayer* self;
	gchar* _tmp0_;
	GstElement* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp0_;
	_tmp1_ = self->priv->_playbin;
	gst_element_set_state (_tmp1_, GST_STATE_READY);
	if (rygel_playbin_player_has_dlna_src) {
		_tmp2_ = g_str_has_prefix (value, "http");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GstElement* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		g_debug ("rygel-playbin-player.vala:202: Trying to use DLNA src element");
		_tmp3_ = self->priv->_playbin;
		_tmp4_ = g_strconcat ("dlna+", value, NULL);
		_tmp5_ = _tmp4_;
		g_object_set (_tmp3_, "uri", _tmp5_, NULL);
		_g_free0 (_tmp5_);
	} else {
		GstElement* _tmp6_;
		_tmp6_ = self->priv->_playbin;
		g_object_set (_tmp6_, "uri", value, NULL);
	}
	if (g_strcmp0 (value, "") != 0) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GQuark _tmp10_ = 0U;
		static GQuark _tmp9_label0 = 0;
		static GQuark _tmp9_label1 = 0;
		static GQuark _tmp9_label2 = 0;
		static GQuark _tmp9_label3 = 0;
		static GQuark _tmp9_label4 = 0;
		rygel_playbin_player_guess_duration (self);
		_tmp7_ = self->priv->_playback_state;
		_tmp8_ = _tmp7_;
		_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
		if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("NO_MEDIA_PRESENT")))) {
			switch (0) {
				default:
				{
					gchar* _tmp11_;
					_tmp11_ = g_strdup ("STOPPED");
					_g_free0 (self->priv->_playback_state);
					self->priv->_playback_state = _tmp11_;
					g_object_notify ((GObject*) self, "playback-state");
					break;
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("STOPPED")))) {
			switch (0) {
				default:
				{
					break;
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
			switch (0) {
				default:
				{
					GstElement* _tmp12_;
					_tmp12_ = self->priv->_playbin;
					gst_element_set_state (_tmp12_, GST_STATE_PAUSED);
					break;
				}
			}
		} else if ((_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("EOS")))) || (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("PLAYING"))))) {
			switch (0) {
				default:
				{
					GstElement* _tmp13_;
					_tmp13_ = self->priv->_playbin;
					gst_element_set_state (_tmp13_, GST_STATE_PLAYING);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
	} else {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("NO_MEDIA_PRESENT");
		_g_free0 (self->priv->_playback_state);
		self->priv->_playback_state = _tmp14_;
		g_object_notify ((GObject*) self, "playback-state");
	}
	g_debug ("rygel-playbin-player.vala:231: URI set to %s.", value);
	g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_URI_PROPERTY]);
}

static gchar*
rygel_playbin_player_real_get_mime_type (RygelMediaPlayer* base)
{
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_mime_type;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_playbin_player_real_set_mime_type (RygelMediaPlayer* base,
                                         const gchar* value)
{
	RygelPlaybinPlayer* self;
	gchar* _tmp0_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_MIME_TYPE_PROPERTY]);
}

static gchar*
rygel_playbin_player_real_get_metadata (RygelMediaPlayer* base)
{
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_playbin_player_real_set_metadata (RygelMediaPlayer* base,
                                        const gchar* value)
{
	RygelPlaybinPlayer* self;
	gchar* _tmp0_;
	self = (RygelPlaybinPlayer*) base;
	self->priv->_parsed_duration = (gint64) 0;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_metadata);
	self->priv->_metadata = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_METADATA_PROPERTY]);
}

static gboolean
rygel_playbin_player_real_get_can_seek (RygelMediaPlayer* base)
{
	gboolean result;
	RygelPlaybinPlayer* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp1_ = self->priv->transfer_mode;
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE) != 0) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp0_ = !g_str_has_prefix (_tmp4_, "image/");
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
rygel_playbin_player_real_get_can_seek_bytes (RygelMediaPlayer* base)
{
	gboolean result;
	RygelPlaybinPlayer* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp1_ = self->priv->transfer_mode;
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE) != 0) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp0_ = !g_str_has_prefix (_tmp4_, "image/");
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gchar*
rygel_playbin_player_real_get_user_agent (RygelMediaPlayer* base)
{
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_user_agent;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_playbin_player_real_set_user_agent (RygelMediaPlayer* base,
                                          const gchar* value)
{
	RygelPlaybinPlayer* self;
	gchar* old_value;
	self = (RygelPlaybinPlayer*) base;
	old_value = rygel_playbin_player_real_get_user_agent (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_user_agent);
		self->priv->_user_agent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_USER_AGENT_PROPERTY]);
	}
	_g_free0 (old_value);
}

static gchar*
rygel_playbin_player_real_get_content_features (RygelMediaPlayer* base)
{
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_content_features;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_playbin_player_real_set_content_features (RygelMediaPlayer* base,
                                                const gchar* value)
{
	RygelPlaybinPlayer* self;
	gchar* pi_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE, _tmp2_, value);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	pi_string = _tmp4_;
	{
		GUPnPProtocolInfo* _tmp5_ = NULL;
		GUPnPProtocolInfo* _tmp6_;
		GUPnPProtocolInfo* _tmp7_;
		GUPnPDLNAFlags flags = 0U;
		GUPnPProtocolInfo* _tmp8_;
		GUPnPDLNAFlags _tmp9_;
		GUPnPDLNAFlags _tmp10_;
		_tmp6_ = gupnp_protocol_info_new_from_string (pi_string, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (self->priv->protocol_info);
		self->priv->protocol_info = _tmp7_;
		_tmp8_ = self->priv->protocol_info;
		_tmp9_ = gupnp_protocol_info_get_dlna_flags (_tmp8_);
		_tmp10_ = _tmp9_;
		flags = _tmp10_;
		if ((flags & GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE);
			_g_free0 (self->priv->transfer_mode);
			self->priv->transfer_mode = _tmp11_;
		} else {
			if ((flags & GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING);
				_g_free0 (self->priv->transfer_mode);
				self->priv->transfer_mode = _tmp12_;
			} else {
				_g_free0 (self->priv->transfer_mode);
				self->priv->transfer_mode = NULL;
			}
		}
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (self->priv->protocol_info);
		self->priv->protocol_info = NULL;
		_g_free0 (self->priv->transfer_mode);
		self->priv->transfer_mode = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (pi_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp13_ = g_strdup (value);
	_g_free0 (self->priv->_content_features);
	self->priv->_content_features = _tmp13_;
	_g_free0 (pi_string);
	g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES_PROPERTY]);
}

static gdouble
rygel_playbin_player_real_get_volume (RygelMediaPlayer* base)
{
	gdouble result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	result = gst_stream_volume_get_volume (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_stream_volume_get_type (), GstStreamVolume), GST_STREAM_VOLUME_FORMAT_CUBIC);
	return result;
}

static void
rygel_playbin_player_real_set_volume (RygelMediaPlayer* base,
                                      gdouble value)
{
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	gst_stream_volume_set_volume (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_stream_volume_get_type (), GstStreamVolume), GST_STREAM_VOLUME_FORMAT_CUBIC, value);
	g_debug ("rygel-playbin-player.vala:311: volume set to %f.", value);
	g_object_notify_by_pspec ((GObject *) self, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_VOLUME_PROPERTY]);
}

static gint64
rygel_playbin_player_real_get_duration (RygelMediaPlayer* base)
{
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 dur = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	dur = (gint64) 0;
	_tmp0_ = self->priv->_playbin;
	_tmp2_ = gst_element_query_duration (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	dur = _tmp1_;
	if (_tmp2_) {
		result = dur / GST_USECOND;
		return result;
	} else {
		result = self->priv->_parsed_duration;
		return result;
	}
}

static gint64
rygel_playbin_player_real_get_size (RygelMediaPlayer* base)
{
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 dur = 0LL;
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	dur = (gint64) 0;
	_tmp1_ = self->priv->source;
	if (_tmp1_ != NULL) {
		GstElement* _tmp2_;
		gint64 _tmp3_ = 0LL;
		gboolean _tmp4_;
		_tmp2_ = self->priv->source;
		_tmp4_ = gst_element_query_duration (_tmp2_, GST_FORMAT_BYTES, &_tmp3_);
		dur = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = dur;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}

static gint64
rygel_playbin_player_real_get_position (RygelMediaPlayer* base)
{
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 pos = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playbin;
	_tmp2_ = gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	pos = _tmp1_;
	if (_tmp2_) {
		result = pos / GST_USECOND;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}

static gint64
rygel_playbin_player_real_get_byte_position (RygelMediaPlayer* base)
{
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 pos = 0LL;
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	pos = (gint64) 0;
	_tmp1_ = self->priv->source;
	if (_tmp1_ != NULL) {
		GstElement* _tmp2_;
		gint64 _tmp3_ = 0LL;
		gboolean _tmp4_;
		_tmp2_ = self->priv->source;
		_tmp4_ = gst_element_query_position (_tmp2_, GST_FORMAT_BYTES, &_tmp3_);
		pos = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = pos;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}

GList*
rygel_playbin_player_get_supported_profiles (RygelPlaybinPlayer* self)
{
	GList* result;
	GList* _tmp0_;
	GList* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_supported_profiles;
	if (_tmp0_ == NULL) {
		RygelDLNAProfile* _tmp1_;
		RygelDLNAProfile* _tmp2_;
		RygelDLNAProfile* _tmp3_;
		RygelDLNAProfile* _tmp4_;
		RygelDLNAProfile* _tmp5_;
		RygelDLNAProfile* _tmp6_;
		RygelDLNAProfile* _tmp7_;
		RygelDLNAProfile* _tmp8_;
		RygelDLNAProfile* _tmp9_;
		RygelDLNAProfile* _tmp10_;
		RygelDLNAProfile* _tmp11_;
		RygelDLNAProfile* _tmp12_;
		RygelDLNAProfile* _tmp13_;
		RygelDLNAProfile* _tmp14_;
		RygelDLNAProfile* _tmp15_;
		RygelDLNAProfile* _tmp16_;
		RygelDLNAProfile* _tmp17_;
		RygelDLNAProfile* _tmp18_;
		(self->priv->_supported_profiles == NULL) ? NULL : (self->priv->_supported_profiles = (_g_list_free__rygel_dlna_profile_unref0_ (self->priv->_supported_profiles), NULL));
		self->priv->_supported_profiles = NULL;
		_tmp1_ = rygel_dlna_profile_new ("JPEG_SM", "image/jpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp1_);
		_tmp2_ = rygel_dlna_profile_new ("JPEG_MED", "image/jpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp2_);
		_tmp3_ = rygel_dlna_profile_new ("JPEG_LRG", "image/jpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp3_);
		_tmp4_ = rygel_dlna_profile_new ("PNG_LRG", "image/png");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp4_);
		_tmp5_ = rygel_dlna_profile_new ("MP3", "audio/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp5_);
		_tmp6_ = rygel_dlna_profile_new ("MP3X", "audio/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp6_);
		_tmp7_ = rygel_dlna_profile_new ("AAC_ADTS_320", "audio/vnd.dlna.adts");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp7_);
		_tmp8_ = rygel_dlna_profile_new ("AAC_ISO_320", "audio/mp4");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp8_);
		_tmp9_ = rygel_dlna_profile_new ("AAC_ISO_320", "audio/3gpp");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp9_);
		_tmp10_ = rygel_dlna_profile_new ("LPCM", "audio/l16;rate=44100;channels=2");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp10_);
		_tmp11_ = rygel_dlna_profile_new ("LPCM", "audio/l16;rate=44100;channels=1");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp11_);
		_tmp12_ = rygel_dlna_profile_new ("WMABASE", "audio/x-ms-wma");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp12_);
		_tmp13_ = rygel_dlna_profile_new ("WMAFULL", "audio/x-ms-wma");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp13_);
		_tmp14_ = rygel_dlna_profile_new ("WMAPRO", "audio/x-ms-wma");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp14_);
		_tmp15_ = rygel_dlna_profile_new ("MPEG_TS_SD_EU_ISO", "video/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp15_);
		_tmp16_ = rygel_dlna_profile_new ("MPEG_TS_SD_NA_ISO", "video/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp16_);
		_tmp17_ = rygel_dlna_profile_new ("MPEG_TS_HD_NA_ISO", "video/mpeg");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp17_);
		_tmp18_ = rygel_dlna_profile_new ("AVC_MP4_BL_CIF15_AAC_520", "video/mp4");
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp18_);
	}
	_tmp19_ = self->priv->_supported_profiles;
	result = _tmp19_;
	return result;
}

static void
rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass,
                                 gpointer klass_data)
{
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPlaybinPlayer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBIN_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_PLAYBIN_PROPERTY] = g_param_spec_object ("playbin", "playbin", "playbin", gst_element_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE_PROPERTY] = g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS_PROPERTY] = g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED_PROPERTY] = g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_MIME_TYPE_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_METADATA_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_METADATA_PROPERTY] = g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CAN_SEEK_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_CAN_SEEK_PROPERTY] = g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES_PROPERTY] = g_param_spec_boolean ("can-seek-bytes", "can-seek-bytes", "can-seek-bytes", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_USER_AGENT_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_USER_AGENT_PROPERTY] = g_param_spec_string ("user-agent", "user-agent", "user-agent", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES_PROPERTY] = g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_DURATION_PROPERTY] = g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_SIZE_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_SIZE_PROPERTY] = g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_POSITION_PROPERTY] = g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_BYTE_POSITION_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_BYTE_POSITION_PROPERTY] = g_param_spec_int64 ("byte-position", "byte-position", "byte-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES_PROPERTY, rygel_playbin_player_properties[RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES_PROPERTY] = g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	rygel_playbin_player_has_dlna_src = gst_uri_protocol_is_supported (GST_URI_SRC, "dlna+http");
}

static void
rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface,
                                                        gpointer iface_data)
{
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*) (RygelMediaPlayer*, gint64)) rygel_playbin_player_real_seek;
	iface->seek_bytes = (gboolean (*) (RygelMediaPlayer*, gint64)) rygel_playbin_player_real_seek_bytes;
	iface->get_protocols = (gchar** (*) (RygelMediaPlayer*, gint*)) rygel_playbin_player_real_get_protocols;
	iface->get_mime_types = (gchar** (*) (RygelMediaPlayer*, gint*)) rygel_playbin_player_real_get_mime_types;
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
	iface->get_allowed_playback_speeds = rygel_playbin_player_real_get_allowed_playback_speeds;
	iface->get_playback_speed = rygel_playbin_player_real_get_playback_speed;
	iface->set_playback_speed = rygel_playbin_player_real_set_playback_speed;
	iface->get_uri = rygel_playbin_player_real_get_uri;
	iface->set_uri = rygel_playbin_player_real_set_uri;
	iface->get_mime_type = rygel_playbin_player_real_get_mime_type;
	iface->set_mime_type = rygel_playbin_player_real_set_mime_type;
	iface->get_metadata = rygel_playbin_player_real_get_metadata;
	iface->set_metadata = rygel_playbin_player_real_set_metadata;
	iface->get_can_seek = rygel_playbin_player_real_get_can_seek;
	iface->get_can_seek_bytes = rygel_playbin_player_real_get_can_seek_bytes;
	iface->get_user_agent = rygel_playbin_player_real_get_user_agent;
	iface->set_user_agent = rygel_playbin_player_real_set_user_agent;
	iface->get_content_features = rygel_playbin_player_real_get_content_features;
	iface->set_content_features = rygel_playbin_player_real_set_content_features;
	iface->get_volume = rygel_playbin_player_real_get_volume;
	iface->set_volume = rygel_playbin_player_real_set_volume;
	iface->get_duration = rygel_playbin_player_real_get_duration;
	iface->get_size = rygel_playbin_player_real_get_size;
	iface->get_position = rygel_playbin_player_real_get_position;
	iface->get_byte_position = rygel_playbin_player_real_get_byte_position;
}

static void
rygel_playbin_player_instance_init (RygelPlaybinPlayer * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	self->priv = rygel_playbin_player_get_instance_private (self);
	_tmp0_ = g_strdup ("NO_MEDIA_PRESENT");
	self->priv->_playback_state = _tmp0_;
	_tmp1_ = g_strdup ("1/16");
	_tmp2_ = g_strdup ("1/8");
	_tmp3_ = g_strdup ("1/4");
	_tmp4_ = g_strdup ("1/2");
	_tmp5_ = g_strdup ("1");
	_tmp6_ = g_strdup ("2");
	_tmp7_ = g_strdup ("4");
	_tmp8_ = g_strdup ("8");
	_tmp9_ = g_strdup ("16");
	_tmp10_ = g_strdup ("32");
	_tmp11_ = g_strdup ("64");
	_tmp12_ = g_new0 (gchar*, 11 + 1);
	_tmp12_[0] = _tmp1_;
	_tmp12_[1] = _tmp2_;
	_tmp12_[2] = _tmp3_;
	_tmp12_[3] = _tmp4_;
	_tmp12_[4] = _tmp5_;
	_tmp12_[5] = _tmp6_;
	_tmp12_[6] = _tmp7_;
	_tmp12_[7] = _tmp8_;
	_tmp12_[8] = _tmp9_;
	_tmp12_[9] = _tmp10_;
	_tmp12_[10] = _tmp11_;
	self->priv->_allowed_playback_speeds = _tmp12_;
	self->priv->_allowed_playback_speeds_length1 = 11;
	self->priv->__allowed_playback_speeds_size_ = self->priv->_allowed_playback_speeds_length1;
	_tmp13_ = g_strdup ("1");
	self->priv->_new_playback_speed = _tmp13_;
	_tmp14_ = g_strdup ("1");
	self->priv->_playback_speed = _tmp14_;
	self->priv->transfer_mode = NULL;
	self->priv->uri_update_hint = FALSE;
	self->priv->_uri = NULL;
	_tmp15_ = g_strdup ("");
	self->priv->_mime_type = _tmp15_;
	_tmp16_ = g_strdup ("");
	self->priv->_metadata = _tmp16_;
	_tmp17_ = g_strdup ("");
	self->priv->_content_features = _tmp17_;
}

static void
rygel_playbin_player_finalize (GObject * obj)
{
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAYBIN_PLAYER, RygelPlaybinPlayer);
	_g_object_unref0 (self->priv->_playbin);
	_g_free0 (self->priv->_playback_state);
	self->priv->_allowed_playback_speeds = (_vala_array_free (self->priv->_allowed_playback_speeds, self->priv->_allowed_playback_speeds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_new_playback_speed);
	_g_free0 (self->priv->_playback_speed);
	_g_free0 (self->priv->transfer_mode);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_user_agent);
	_g_free0 (self->priv->_content_features);
	_g_object_unref0 (self->priv->protocol_info);
	(self->priv->_supported_profiles == NULL) ? NULL : (self->priv->_supported_profiles = (_g_list_free__rygel_dlna_profile_unref0_ (self->priv->_supported_profiles), NULL));
	_g_object_unref0 (self->priv->source);
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
}

/**
 * Implementation of RygelMediaPlayer for GStreamer.
 *
 * This class is useful only when implementing Rygel plugins.
 */
 G_GNUC_NO_INLINE static GType
rygel_playbin_player_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
	static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_playbin_player_type_id;
	rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
	RygelPlaybinPlayer_private_offset = g_type_add_instance_private (rygel_playbin_player_type_id, sizeof (RygelPlaybinPlayerPrivate));
	return rygel_playbin_player_type_id;
}

GType
rygel_playbin_player_get_type (void)
{
	static volatile gsize rygel_playbin_player_type_id__once = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__once)) {
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = rygel_playbin_player_get_type_once ();
		g_once_init_leave (&rygel_playbin_player_type_id__once, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__once;
}

static void
_vala_rygel_playbin_player_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAYBIN_PLAYER, RygelPlaybinPlayer);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN_PROPERTY:
		g_value_set_object (value, rygel_playbin_player_get_playbin (self));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, rygel_media_player_get_allowed_playback_speeds ((RygelMediaPlayer*) self, &length));
		}
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_playback_speed ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_METADATA_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_CAN_SEEK_PROPERTY:
		g_value_set_boolean (value, rygel_media_player_get_can_seek ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES_PROPERTY:
		g_value_set_boolean (value, rygel_media_player_get_can_seek_bytes ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_USER_AGENT_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_user_agent ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME_PROPERTY:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_DURATION_PROPERTY:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_media_player_get_size ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_POSITION_PROPERTY:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_BYTE_POSITION_PROPERTY:
		g_value_set_int64 (value, rygel_media_player_get_byte_position ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES_PROPERTY:
		g_value_set_pointer (value, rygel_playbin_player_get_supported_profiles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_playbin_player_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAYBIN_PLAYER, RygelPlaybinPlayer);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN_PROPERTY:
		rygel_playbin_player_set_playbin (self, g_value_get_object (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE_PROPERTY:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED_PROPERTY:
		rygel_media_player_set_playback_speed ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI_PROPERTY:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE_PROPERTY:
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_METADATA_PROPERTY:
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_USER_AGENT_PROPERTY:
		rygel_media_player_set_user_agent ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES_PROPERTY:
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME_PROPERTY:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

