/* rygel-media-export-media-cache-upgrader.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-media-export-media-cache-upgrader.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include "rygel-db.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "rygel-media-export.h"
#include <gobject/gvaluecollector.h>

#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_2 "UPDATE meta_data SET object_fk = " "(SELECT upnp_id FROM Object WHERE metadata_fk = meta_data.id)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_3 "ALTER TABLE Object ADD timestamp INTEGER"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_4 "UPDATE Object SET timestamp = 0"
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "18"

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
typedef struct _RygelMediaExportMediaCacheUpgraderPrivate RygelMediaExportMediaCacheUpgraderPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CREATE_IGNORELIST_TABLE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CREATE_IGNORELIST_INDEX,
	RYGEL_MEDIA_EXPORT_SQL_STRING_ADD_TO_IGNORELIST,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHECK_IGNORELIST
} RygelMediaExportSQLString;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportParamSpecMediaCacheUpgrader RygelMediaExportParamSpecMediaCacheUpgrader;

struct _RygelMediaExportMediaCacheUpgrader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaExportMediaCacheUpgraderPrivate * priv;
};

struct _RygelMediaExportMediaCacheUpgraderClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaExportMediaCacheUpgrader *self);
};

struct _RygelMediaExportMediaCacheUpgraderPrivate {
	RygelDatabaseDatabase* database;
	RygelMediaExportSQLFactory* sql;
};

struct _RygelMediaExportParamSpecMediaCacheUpgrader {
	GParamSpec parent_instance;
};

static gint RygelMediaExportMediaCacheUpgrader_private_offset;
static gpointer rygel_media_export_media_cache_upgrader_parent_class = NULL;

VALA_EXTERN gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
VALA_EXTERN void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
VALA_EXTERN GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags);
VALA_EXTERN void rygel_media_export_value_set_media_cache_upgrader (GValue* value,
                                                        gpointer v_object);
VALA_EXTERN void rygel_media_export_value_take_media_cache_upgrader (GValue* value,
                                                         gpointer v_object);
VALA_EXTERN gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
VALA_EXTERN GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelDatabaseDatabase* database,
                                                                                 RygelMediaExportSQLFactory* sql);
VALA_EXTERN RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type,
                                                                                       RygelDatabaseDatabase* database,
                                                                                       RygelMediaExportSQLFactory* sql);
VALA_EXTERN gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self,
                                                                gint* current_version,
                                                                GError** error);
VALA_EXTERN void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self,
                                                         GError** error);
VALA_EXTERN GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self,
                                                  RygelMediaExportSQLString query);
VALA_EXTERN void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
VALA_EXTERN void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self,
                                                      gint old_version,
                                                      GError** error);
static void rygel_media_export_media_cache_upgrader_update_v17_v18 (RygelMediaExportMediaCacheUpgrader* self,
                                                             gboolean move_data,
                                                             GError** error);
static void rygel_media_export_media_cache_upgrader_finalize (RygelMediaExportMediaCacheUpgrader * obj);
static GType rygel_media_export_media_cache_upgrader_get_type_once (void);

static inline gpointer
rygel_media_export_media_cache_upgrader_get_instance_private (RygelMediaExportMediaCacheUpgrader* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportMediaCacheUpgrader_private_offset);
}

RygelMediaExportMediaCacheUpgrader*
rygel_media_export_media_cache_upgrader_construct (GType object_type,
                                                   RygelDatabaseDatabase* database,
                                                   RygelMediaExportSQLFactory* sql)
{
	RygelMediaExportMediaCacheUpgrader* self = NULL;
	g_return_val_if_fail (database != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (RygelMediaExportMediaCacheUpgrader*) g_type_create_instance (object_type);
	self->priv->database = database;
	self->priv->sql = sql;
	return self;
}

RygelMediaExportMediaCacheUpgrader*
rygel_media_export_media_cache_upgrader_new (RygelDatabaseDatabase* database,
                                             RygelMediaExportSQLFactory* sql)
{
	return rygel_media_export_media_cache_upgrader_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, database, sql);
}

gboolean
rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self,
                                                       gint* current_version,
                                                       GError** error)
{
	gint _vala_current_version = 0;
	gint _tmp0_ = 0;
	RygelDatabaseDatabase* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->database;
	_tmp0_ = rygel_database_database_query_value (_tmp1_, "SELECT version FROM schema_info", NULL, (gint) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_vala_current_version = _tmp0_;
	result = _vala_current_version < atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	if (current_version) {
		*current_version = _vala_current_version;
	}
	return result;
}

void
rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self,
                                                    GError** error)
{
	gint matching_schema_count = 0;
	RygelDatabaseDatabase* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	matching_schema_count = rygel_database_database_query_value (_tmp0_, "SELECT count(*) FROM " "sqlite_master WHERE sql " "LIKE 'CREATE TABLE Meta_Data" "%object_fk TEXT UNIQUE%'", NULL, (gint) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (matching_schema_count == 0) {
		{
			RygelDatabaseDatabase* _tmp1_;
			RygelDatabaseDatabase* _tmp2_;
			RygelDatabaseDatabase* _tmp3_;
			RygelDatabaseDatabase* _tmp4_;
			RygelMediaExportSQLFactory* _tmp5_;
			const gchar* _tmp6_;
			RygelDatabaseDatabase* _tmp7_;
			g_message ("rygel-media-export-media-cache-upgrader.vala:58: Found faulty schema, " \
"forcing full reindex");
			_tmp1_ = self->priv->database;
			rygel_database_database_begin (_tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = self->priv->database;
			rygel_database_database_exec (_tmp2_, "DELETE FROM Object WHERE upnp_id IN (" "SELECT DISTINCT object_fk FROM meta_data)", NULL, (gint) 0, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = self->priv->database;
			rygel_database_database_exec (_tmp3_, "DROP TABLE Meta_Data", NULL, (gint) 0, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = self->priv->database;
			_tmp5_ = self->priv->sql;
			_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA);
			rygel_database_database_exec (_tmp4_, _tmp6_, NULL, (gint) 0, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = self->priv->database;
			rygel_database_database_commit (_tmp7_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			RygelDatabaseDatabase* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = self->priv->database;
			rygel_database_database_rollback (_tmp8_);
			_tmp9_ = _error_;
			_tmp10_ = _tmp9_->message;
			g_warning (_ ("Failed to force reindex to fix database: %s"), _tmp10_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
}

void
rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_;
		RygelMediaExportSQLFactory* _tmp1_;
		const gchar* _tmp2_;
		RygelDatabaseDatabase* _tmp3_;
		_tmp0_ = self->priv->database;
		_tmp1_ = self->priv->sql;
		_tmp2_ = rygel_media_export_sql_factory_make (_tmp1_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_database_database_exec (_tmp0_, _tmp2_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_analyze (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning (_ ("Failed to create indices: %s"), _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self,
                                                 gint old_version,
                                                 GError** error)
{
	gint current_version = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("rygel-media-export-media-cache-upgrader.vala:84: Older schema detected" \
". Upgrading...");
	current_version = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	while (TRUE) {
		gint _tmp2_;
		if (!(old_version < current_version)) {
			break;
		}
		switch (old_version) {
			case 16:
			{
				gint _tmp0_;
				rygel_media_export_media_cache_upgrader_update_v17_v18 (self, FALSE, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp0_ = old_version;
				old_version = _tmp0_ + 1;
				break;
			}
			case 17:
			{
				rygel_media_export_media_cache_upgrader_update_v17_v18 (self, TRUE, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			default:
			{
				GError* _tmp1_;
				_tmp1_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UPGRADE_FAILED, _ ("Cannot upgrade from version %d"), old_version);
				_inner_error0_ = _tmp1_;
				if (_inner_error0_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		_tmp2_ = old_version;
		old_version = _tmp2_ + 1;
	}
}

static void
rygel_media_export_media_cache_upgrader_update_v17_v18 (RygelMediaExportMediaCacheUpgrader* self,
                                                        gboolean move_data,
                                                        GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_;
		RygelDatabaseDatabase* _tmp1_;
		RygelMediaExportSQLFactory* _tmp2_;
		const gchar* _tmp3_;
		RygelDatabaseDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		const gchar* _tmp6_;
		RygelDatabaseDatabase* _tmp8_;
		RygelDatabaseDatabase* _tmp9_;
		RygelDatabaseDatabase* _tmp10_;
		RygelDatabaseDatabase* _tmp11_;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp1_ = self->priv->database;
		_tmp2_ = self->priv->sql;
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_CREATE_IGNORELIST_TABLE);
		rygel_database_database_exec (_tmp1_, _tmp3_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = self->priv->database;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_CREATE_IGNORELIST_INDEX);
		rygel_database_database_exec (_tmp4_, _tmp6_, NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (move_data) {
			RygelDatabaseDatabase* _tmp7_;
			_tmp7_ = self->priv->database;
			rygel_database_database_exec (_tmp7_, "INSERT INTO ignorelist SELECT * FROM blacklist", NULL, (gint) 0, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch0_rygel_database_database_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp8_ = self->priv->database;
		rygel_database_database_exec (_tmp8_, "UPDATE schema_info SET VERSION = '18'", NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp9_ = self->priv->database;
		rygel_database_database_commit (_tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = self->priv->database;
		rygel_database_database_exec (_tmp10_, "VACUUM", NULL, (gint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp11_ = self->priv->database;
		rygel_database_database_analyze (_tmp11_);
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = self->priv->database;
		rygel_database_database_rollback (_tmp12_);
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UPGRADE_FAILED, _ ("Database upgrade to v18 failed: %s"), _tmp14_);
		_inner_error0_ = _tmp15_;
		_g_error_free0 (_error_);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
rygel_media_export_value_media_cache_upgrader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_media_export_value_media_cache_upgrader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_media_export_media_cache_upgrader_unref (value->data[0].v_pointer);
	}
}

static void
rygel_media_export_value_media_cache_upgrader_copy_value (const GValue* src_value,
                                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_export_media_cache_upgrader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_media_export_value_media_cache_upgrader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_media_export_value_media_cache_upgrader_collect_value (GValue* value,
                                                             guint n_collect_values,
                                                             GTypeCValue* collect_values,
                                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelMediaExportMediaCacheUpgrader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_export_media_cache_upgrader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_media_export_value_media_cache_upgrader_lcopy_value (const GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	RygelMediaExportMediaCacheUpgrader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_export_media_cache_upgrader_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_media_export_param_spec_media_cache_upgrader (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags)
{
	RygelMediaExportParamSpecMediaCacheUpgrader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_media_export_value_get_media_cache_upgrader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER), NULL);
	return value->data[0].v_pointer;
}

void
rygel_media_export_value_set_media_cache_upgrader (GValue* value,
                                                   gpointer v_object)
{
	RygelMediaExportMediaCacheUpgrader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_export_media_cache_upgrader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_export_media_cache_upgrader_unref (old);
	}
}

void
rygel_media_export_value_take_media_cache_upgrader (GValue* value,
                                                    gpointer v_object)
{
	RygelMediaExportMediaCacheUpgrader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_export_media_cache_upgrader_unref (old);
	}
}

static void
rygel_media_export_media_cache_upgrader_class_init (RygelMediaExportMediaCacheUpgraderClass * klass,
                                                    gpointer klass_data)
{
	rygel_media_export_media_cache_upgrader_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaExportMediaCacheUpgraderClass *) klass)->finalize = rygel_media_export_media_cache_upgrader_finalize;
	g_type_class_adjust_private_offset (klass, &RygelMediaExportMediaCacheUpgrader_private_offset);
}

static void
rygel_media_export_media_cache_upgrader_instance_init (RygelMediaExportMediaCacheUpgrader * self,
                                                       gpointer klass)
{
	self->priv = rygel_media_export_media_cache_upgrader_get_instance_private (self);
	self->ref_count = 1;
}

static void
rygel_media_export_media_cache_upgrader_finalize (RygelMediaExportMediaCacheUpgrader * obj)
{
	RygelMediaExportMediaCacheUpgrader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
rygel_media_export_media_cache_upgrader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { rygel_media_export_value_media_cache_upgrader_init, rygel_media_export_value_media_cache_upgrader_free_value, rygel_media_export_value_media_cache_upgrader_copy_value, rygel_media_export_value_media_cache_upgrader_peek_pointer, "p", rygel_media_export_value_media_cache_upgrader_collect_value, "p", rygel_media_export_value_media_cache_upgrader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheUpgraderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_upgrader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCacheUpgrader), 0, (GInstanceInitFunc) rygel_media_export_media_cache_upgrader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType rygel_media_export_media_cache_upgrader_type_id;
	rygel_media_export_media_cache_upgrader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaExportMediaCacheUpgrader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	RygelMediaExportMediaCacheUpgrader_private_offset = g_type_add_instance_private (rygel_media_export_media_cache_upgrader_type_id, sizeof (RygelMediaExportMediaCacheUpgraderPrivate));
	return rygel_media_export_media_cache_upgrader_type_id;
}

GType
rygel_media_export_media_cache_upgrader_get_type (void)
{
	static volatile gsize rygel_media_export_media_cache_upgrader_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_upgrader_type_id__once)) {
		GType rygel_media_export_media_cache_upgrader_type_id;
		rygel_media_export_media_cache_upgrader_type_id = rygel_media_export_media_cache_upgrader_get_type_once ();
		g_once_init_leave (&rygel_media_export_media_cache_upgrader_type_id__once, rygel_media_export_media_cache_upgrader_type_id);
	}
	return rygel_media_export_media_cache_upgrader_type_id__once;
}

gpointer
rygel_media_export_media_cache_upgrader_ref (gpointer instance)
{
	RygelMediaExportMediaCacheUpgrader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_media_export_media_cache_upgrader_unref (gpointer instance)
{
	RygelMediaExportMediaCacheUpgrader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

