/* rygel-mpris-player.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-mpris-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 * Copyright (C) 2015 Jens Georg
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Sivakumar Mani <siva@orexel.com>
 *         Jens Georg <mail@jensge.org>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-mpris.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "rygel-renderer.h"
#include <float.h>
#include <math.h>

enum  {
	RYGEL_MPRIS_PLAYER_0_PROPERTY,
	RYGEL_MPRIS_PLAYER_USER_AGENT_PROPERTY,
	RYGEL_MPRIS_PLAYER_PLAYBACK_STATE_PROPERTY,
	RYGEL_MPRIS_PLAYER_ALLOWED_PLAYBACK_SPEEDS_PROPERTY,
	RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED_PROPERTY,
	RYGEL_MPRIS_PLAYER_MINIMUM_RATE_PROPERTY,
	RYGEL_MPRIS_PLAYER_MAXIMUM_RATE_PROPERTY,
	RYGEL_MPRIS_PLAYER_URI_PROPERTY,
	RYGEL_MPRIS_PLAYER_MIME_TYPE_PROPERTY,
	RYGEL_MPRIS_PLAYER_METADATA_PROPERTY,
	RYGEL_MPRIS_PLAYER_CONTENT_FEATURES_PROPERTY,
	RYGEL_MPRIS_PLAYER_CAN_SEEK_PROPERTY,
	RYGEL_MPRIS_PLAYER_CAN_SEEK_BYTES_PROPERTY,
	RYGEL_MPRIS_PLAYER_VOLUME_PROPERTY,
	RYGEL_MPRIS_PLAYER_DURATION_PROPERTY,
	RYGEL_MPRIS_PLAYER_SIZE_PROPERTY,
	RYGEL_MPRIS_PLAYER_POSITION_PROPERTY,
	RYGEL_MPRIS_PLAYER_BYTE_POSITION_PROPERTY,
	RYGEL_MPRIS_PLAYER_NUM_PROPERTIES
};
static GParamSpec* rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelMPRISPlayerPrivate {
	gchar** protocols;
	gint protocols_length1;
	gint _protocols_size_;
	gchar** mime_types;
	gint mime_types_length1;
	gint _mime_types_size_;
	RygelMPRISMediaPlayerPlayerProxy* actual_player;
	gchar* _user_agent;
	gchar** _allowed_playback_speeds;
	gint _allowed_playback_speeds_length1;
	gint __allowed_playback_speeds_size_;
	gchar* _playback_speed;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _content_features;
};

static gint RygelMPRISPlayer_private_offset;
static gpointer rygel_mpris_player_parent_class = NULL;
static RygelMediaPlayerIface * rygel_mpris_player_rygel_media_player_parent_iface = NULL;

static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void rygel_mpris_player_on_properties_changed (RygelMPRISPlayer* self,
                                               GDBusProxy* actual_player,
                                               GVariant* changed,
                                               gchar** invalidated,
                                               gint invalidated_length1);
static void _rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                  GVariant* changed_properties,
                                                                                  gchar** invalidated_properties,
                                                                                  gpointer self);
static void rygel_mpris_player_real_constructed (GObject* base);
static gboolean __lambda4_ (RygelMPRISPlayer* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean rygel_mpris_player_real_seek (RygelMediaPlayer* base,
                                       gint64 time);
static gboolean rygel_mpris_player_real_seek_bytes (RygelMediaPlayer* base,
                                             gint64 bytes);
static gchar** rygel_mpris_player_real_get_protocols (RygelMediaPlayer* base,
                                               gint* result_length1);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gchar** rygel_mpris_player_real_get_mime_types (RygelMediaPlayer* base,
                                                gint* result_length1);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar* rygel_mpris_player_mpris_to_upnp_state (RygelMPRISPlayer* self,
                                               const gchar* state);
static gchar* _variant_get1 (GVariant* value);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static gchar* _variant_get2 (GVariant* value);
static gint64 _variant_get3 (GVariant* value);
static void rygel_mpris_player_finalize (GObject * obj);
static GType rygel_mpris_player_get_type_once (void);
static void _vala_rygel_mpris_player_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_rygel_mpris_player_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
rygel_mpris_player_get_instance_private (RygelMPRISPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMPRISPlayer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                             GVariant* changed_properties,
                                                                             gchar** invalidated_properties,
                                                                             gpointer self)
{
	rygel_mpris_player_on_properties_changed ((RygelMPRISPlayer*) self, _sender, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}

RygelMPRISPlayer*
rygel_mpris_player_construct (GType object_type,
                              RygelMPRISPlugin* plugin)
{
	RygelMPRISPlayer * self = NULL;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	RygelMPRISMediaPlayerPlayerProxy* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	RygelMPRISMediaPlayerPlayerProxy* _tmp6_;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (RygelMPRISPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = plugin->actual_player;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->actual_player);
	self->priv->actual_player = _tmp1_;
	_tmp2_ = plugin->mime_types;
	_tmp2__length1 = plugin->mime_types_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mime_types = _tmp3_;
	self->priv->mime_types_length1 = _tmp3__length1;
	self->priv->_mime_types_size_ = self->priv->mime_types_length1;
	_tmp4_ = plugin->protocols;
	_tmp4__length1 = plugin->protocols_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup2 (_tmp4_, _tmp4__length1) : _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->priv->protocols = _tmp5_;
	self->priv->protocols_length1 = _tmp5__length1;
	self->priv->_protocols_size_ = self->priv->protocols_length1;
	_tmp6_ = self->priv->actual_player;
	g_signal_connect_object ((GDBusProxy*) _tmp6_, "g-properties-changed", (GCallback) _rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed, self, 0);
	return self;
}

RygelMPRISPlayer*
rygel_mpris_player_new (RygelMPRISPlugin* plugin)
{
	return rygel_mpris_player_construct (RYGEL_MPRIS_TYPE_PLAYER, plugin);
}

static gboolean
__lambda4_ (RygelMPRISPlayer* self)
{
	gboolean result;
	g_object_notify ((GObject*) self, "playback-state");
	g_object_notify ((GObject*) self, "volume");
	g_object_notify ((GObject*) self, "uri");
	g_object_notify ((GObject*) self, "duration");
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((RygelMPRISPlayer*) self);
	return result;
}

static void
rygel_mpris_player_real_constructed (GObject* base)
{
	RygelMPRISPlayer * self;
	self = (RygelMPRISPlayer*) base;
	G_OBJECT_CLASS (rygel_mpris_player_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
rygel_mpris_player_real_seek (RygelMediaPlayer* base,
                              gint64 time)
{
	RygelMPRISPlayer * self;
	gboolean ret = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelMPRISPlayer*) base;
	ret = FALSE;
	{
		RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
		gint64 _tmp1_;
		gint64 _tmp2_;
		_tmp0_ = self->priv->actual_player;
		_tmp1_ = rygel_media_player_get_position ((RygelMediaPlayer*) self);
		_tmp2_ = _tmp1_;
		rygel_mpris_media_player_player_proxy_seek (_tmp0_, time - _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		ret = TRUE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = ret;
	return result;
}

static gboolean
rygel_mpris_player_real_seek_bytes (RygelMediaPlayer* base,
                                    gint64 bytes)
{
	RygelMPRISPlayer * self;
	gboolean result;
	self = (RygelMPRISPlayer*) base;
	result = FALSE;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
rygel_mpris_player_real_get_protocols (RygelMediaPlayer* base,
                                       gint* result_length1)
{
	RygelMPRISPlayer * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->protocols;
	_tmp0__length1 = self->priv->protocols_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
rygel_mpris_player_real_get_mime_types (RygelMediaPlayer* base,
                                        gint* result_length1)
{
	RygelMPRISPlayer * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->mime_types;
	_tmp0__length1 = self->priv->mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
rygel_mpris_player_mpris_to_upnp_state (RygelMPRISPlayer* self,
                                        const gchar* state)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = state;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Stopped")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("STOPPED");
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Paused")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("PAUSED_PLAYBACK");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Playing")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("PLAYING");
				result = _tmp5_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static void
rygel_mpris_player_on_properties_changed (RygelMPRISPlayer* self,
                                          GDBusProxy* actual_player,
                                          GVariant* changed,
                                          gchar** invalidated,
                                          gint invalidated_length1)
{
	const GVariantType* _tmp0_;
	const GVariantType* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actual_player != NULL);
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_get_type (changed);
	_tmp1_ = G_VARIANT_TYPE_VARDICT;
	if (!g_variant_type_equal (_tmp0_, _tmp1_)) {
		return;
	}
	{
		GVariantIter* _changed_prop_it = NULL;
		GVariantIter* _tmp2_;
		GVariant* changed_prop = NULL;
		_tmp2_ = g_variant_iter_new (changed);
		_changed_prop_it = _tmp2_;
		while (TRUE) {
			GVariantIter* _tmp3_;
			GVariant* _tmp4_;
			GVariant* _tmp5_;
			gchar* key = NULL;
			GVariant* _tmp6_;
			GVariant* _tmp7_;
			GVariant* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GVariant* value = NULL;
			GVariant* _tmp11_;
			GVariant* _tmp12_;
			GVariant* _tmp13_;
			GVariant* _tmp14_;
			GVariant* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			GQuark _tmp19_ = 0U;
			static GQuark _tmp18_label0 = 0;
			static GQuark _tmp18_label1 = 0;
			static GQuark _tmp18_label2 = 0;
			static GQuark _tmp18_label3 = 0;
			static GQuark _tmp18_label4 = 0;
			_tmp3_ = _changed_prop_it;
			_tmp4_ = g_variant_iter_next_value (_tmp3_);
			_g_variant_unref0 (changed_prop);
			changed_prop = _tmp4_;
			_tmp5_ = changed_prop;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp6_ = changed_prop;
			_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 0);
			_tmp8_ = _tmp7_;
			_tmp9_ = _variant_get1 (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_variant_unref0 (_tmp8_);
			key = _tmp10_;
			_tmp11_ = changed_prop;
			_tmp12_ = g_variant_get_child_value (_tmp11_, (gsize) 1);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_variant_get_child_value (_tmp13_, (gsize) 0);
			_tmp15_ = _tmp14_;
			_g_variant_unref0 (_tmp13_);
			value = _tmp15_;
			_tmp16_ = key;
			_tmp17_ = _tmp16_;
			_tmp19_ = (NULL == _tmp17_) ? 0 : g_quark_from_string (_tmp17_);
			if (_tmp19_ == ((0 != _tmp18_label0) ? _tmp18_label0 : (_tmp18_label0 = g_quark_from_static_string ("PlaybackStatus")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "playback-state");
						break;
					}
				}
			} else if (_tmp19_ == ((0 != _tmp18_label1) ? _tmp18_label1 : (_tmp18_label1 = g_quark_from_static_string ("Volume")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "volume");
						break;
					}
				}
			} else if (_tmp19_ == ((0 != _tmp18_label2) ? _tmp18_label2 : (_tmp18_label2 = g_quark_from_static_string ("Metadata")))) {
				switch (0) {
					default:
					{
						GVariant* _tmp20_;
						gchar** _tmp21_;
						gchar** _tmp22_;
						gint _tmp22__length1;
						_tmp20_ = value;
						_tmp21_ = g_new0 (gchar*, 0 + 1);
						_tmp22_ = _tmp21_;
						_tmp22__length1 = 0;
						rygel_mpris_player_on_properties_changed (self, actual_player, _tmp20_, _tmp22_, (gint) 0);
						_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
						break;
					}
				}
			} else if (_tmp19_ == ((0 != _tmp18_label3) ? _tmp18_label3 : (_tmp18_label3 = g_quark_from_static_string ("xesam:url")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "uri");
						break;
					}
				}
			} else if (_tmp19_ == ((0 != _tmp18_label4) ? _tmp18_label4 : (_tmp18_label4 = g_quark_from_static_string ("mpris:length")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "duration");
						break;
					}
				}
			}
			_g_variant_unref0 (value);
			_g_free0 (key);
		}
		_g_variant_unref0 (changed_prop);
		_g_variant_iter_free0 (_changed_prop_it);
	}
}

static gchar*
rygel_mpris_player_real_get_user_agent (RygelMediaPlayer* base)
{
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_user_agent;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_mpris_player_real_set_user_agent (RygelMediaPlayer* base,
                                        const gchar* value)
{
	RygelMPRISPlayer* self;
	gchar* old_value;
	self = (RygelMPRISPlayer*) base;
	old_value = rygel_mpris_player_real_get_user_agent (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_user_agent);
		self->priv->_user_agent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_USER_AGENT_PROPERTY]);
	}
	_g_free0 (old_value);
}

static gchar*
rygel_mpris_player_real_get_playback_state (RygelMediaPlayer* base)
{
	gchar* result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_playback_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_mpris_player_mpris_to_upnp_state (self, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static void
rygel_mpris_player_real_set_playback_state (RygelMediaPlayer* base,
                                            const gchar* value)
{
	RygelMPRISPlayer* self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	GError* _inner_error0_ = NULL;
	self = (RygelMPRISPlayer*) base;
	g_debug ("rygel-mpris-player.vala:46: Changing playback state to %s..", value);
	_tmp0_ = value;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp3_;
					_tmp3_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_stop (_tmp3_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp4_;
					_tmp4_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_pause (_tmp4_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("PLAYING")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp5_;
					_tmp5_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_play (_tmp5_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_PLAYBACK_STATE_PROPERTY]);
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
rygel_mpris_player_real_get_allowed_playback_speeds (RygelMediaPlayer* base,
                                                     gint* result_length1)
{
	gchar** result;
	RygelMPRISPlayer* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
rygel_mpris_player_real_get_playback_speed (RygelMediaPlayer* base)
{
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_playback_speed;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_mpris_player_real_set_playback_speed (RygelMediaPlayer* base,
                                            const gchar* value)
{
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gchar* _tmp1_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	rygel_mpris_media_player_player_proxy_set_rate (_tmp0_, rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, value));
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_playback_speed);
	self->priv->_playback_speed = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED_PROPERTY]);
}

gdouble
rygel_mpris_player_get_minimum_rate (RygelMPRISPlayer* self)
{
	gdouble result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp1_ = _tmp0_[0];
	result = rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, _tmp1_);
	return result;
}

gdouble
rygel_mpris_player_get_maximum_rate (RygelMPRISPlayer* self)
{
	gdouble result;
	gint i = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	i = _tmp0__length1;
	_vala_assert (i > 0, "i > 0");
	_tmp1_ = self->priv->_allowed_playback_speeds;
	_tmp1__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp2_ = _tmp1_[i - 1];
	result = rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, _tmp2_);
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gchar*
_variant_get2 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
rygel_mpris_player_real_get_uri (RygelMediaPlayer* base)
{
	gchar* result;
	RygelMPRISPlayer* self;
	GVariant* val = NULL;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (_tmp3_, "xesam:url");
	_tmp5_ = _g_variant_ref0 ((GVariant*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_hash_table_unref0 (_tmp3_);
	val = _tmp6_;
	_tmp7_ = val;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = val;
		_tmp9_ = _variant_get2 (_tmp8_);
		result = _tmp9_;
		_g_variant_unref0 (val);
		return result;
	} else {
		result = NULL;
		_g_variant_unref0 (val);
		return result;
	}
}

static void
rygel_mpris_player_real_set_uri (RygelMediaPlayer* base,
                                 const gchar* value)
{
	RygelMPRISPlayer* self;
	GError* _inner_error0_ = NULL;
	self = (RygelMPRISPlayer*) base;
	{
		RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
		_tmp0_ = self->priv->actual_player;
		rygel_mpris_media_player_player_proxy_open_uri (_tmp0_, value, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_URI_PROPERTY]);
}

static gchar*
rygel_mpris_player_real_get_mime_type (RygelMediaPlayer* base)
{
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_mime_type;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_mpris_player_real_set_mime_type (RygelMediaPlayer* base,
                                       const gchar* value)
{
	RygelMPRISPlayer* self;
	gchar* old_value;
	self = (RygelMPRISPlayer*) base;
	old_value = rygel_mpris_player_real_get_mime_type (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mime_type);
		self->priv->_mime_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_MIME_TYPE_PROPERTY]);
	}
	_g_free0 (old_value);
}

static gchar*
rygel_mpris_player_real_get_metadata (RygelMediaPlayer* base)
{
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_mpris_player_real_set_metadata (RygelMediaPlayer* base,
                                      const gchar* value)
{
	RygelMPRISPlayer* self;
	gchar* old_value;
	self = (RygelMPRISPlayer*) base;
	old_value = rygel_mpris_player_real_get_metadata (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_metadata);
		self->priv->_metadata = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_METADATA_PROPERTY]);
	}
	_g_free0 (old_value);
}

static gchar*
rygel_mpris_player_real_get_content_features (RygelMediaPlayer* base)
{
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_content_features;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_mpris_player_real_set_content_features (RygelMediaPlayer* base,
                                              const gchar* value)
{
	RygelMPRISPlayer* self;
	gchar* old_value;
	self = (RygelMPRISPlayer*) base;
	old_value = rygel_mpris_player_real_get_content_features (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content_features);
		self->priv->_content_features = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_CONTENT_FEATURES_PROPERTY]);
	}
	_g_free0 (old_value);
}

static gboolean
rygel_mpris_player_real_get_can_seek (RygelMediaPlayer* base)
{
	gboolean result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_can_seek (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gboolean
rygel_mpris_player_real_get_can_seek_bytes (RygelMediaPlayer* base)
{
	gboolean result;
	RygelMPRISPlayer* self;
	self = (RygelMPRISPlayer*) base;
	result = FALSE;
	return result;
}

static gdouble
rygel_mpris_player_real_get_volume (RygelMediaPlayer* base)
{
	gdouble result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_volume (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
rygel_mpris_player_real_set_volume (RygelMediaPlayer* base,
                                    gdouble value)
{
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	rygel_mpris_media_player_player_proxy_set_volume (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_VOLUME_PROPERTY]);
}

static gint64
_variant_get3 (GVariant* value)
{
	return g_variant_get_int64 (value);
}

static gint64
rygel_mpris_player_real_get_duration (RygelMediaPlayer* base)
{
	gint64 result;
	RygelMPRISPlayer* self;
	GVariant* val = NULL;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	gint64 dur = 0LL;
	GVariant* _tmp7_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (_tmp3_, "mpris:length");
	_tmp5_ = _g_variant_ref0 ((GVariant*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_hash_table_unref0 (_tmp3_);
	val = _tmp6_;
	dur = (gint64) 0;
	_tmp7_ = val;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_;
		gint64 _tmp9_;
		_tmp8_ = val;
		_tmp9_ = _variant_get3 (_tmp8_);
		dur = _tmp9_;
	}
	result = dur;
	_g_variant_unref0 (val);
	return result;
}

static gint64
rygel_mpris_player_real_get_size (RygelMediaPlayer* base)
{
	gint64 result;
	RygelMPRISPlayer* self;
	self = (RygelMPRISPlayer*) base;
	result = (gint64) 0;
	return result;
}

static gint64
rygel_mpris_player_real_get_position (RygelMediaPlayer* base)
{
	gint64 result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	RygelMPRISMediaPlayerPlayerProxy* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	g_dbus_proxy_set_cached_property ((GDBusProxy*) _tmp0_, "Position", NULL);
	_tmp1_ = self->priv->actual_player;
	_tmp2_ = rygel_mpris_media_player_player_proxy_get_position (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static gint64
rygel_mpris_player_real_get_byte_position (RygelMediaPlayer* base)
{
	gint64 result;
	RygelMPRISPlayer* self;
	self = (RygelMPRISPlayer*) base;
	result = (gint64) 0;
	return result;
}

static void
rygel_mpris_player_class_init (RygelMPRISPlayerClass * klass,
                               gpointer klass_data)
{
	rygel_mpris_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMPRISPlayer_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_mpris_player_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_mpris_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_mpris_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_mpris_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_USER_AGENT_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_USER_AGENT_PROPERTY] = g_param_spec_string ("user-agent", "user-agent", "user-agent", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_PLAYBACK_STATE_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_PLAYBACK_STATE_PROPERTY] = g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_ALLOWED_PLAYBACK_SPEEDS_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_ALLOWED_PLAYBACK_SPEEDS_PROPERTY] = g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED_PROPERTY] = g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_MINIMUM_RATE_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_MINIMUM_RATE_PROPERTY] = g_param_spec_double ("minimum-rate", "minimum-rate", "minimum-rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_MAXIMUM_RATE_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_MAXIMUM_RATE_PROPERTY] = g_param_spec_double ("maximum-rate", "maximum-rate", "maximum-rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_URI_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_MIME_TYPE_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_METADATA_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_METADATA_PROPERTY] = g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_CONTENT_FEATURES_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_CONTENT_FEATURES_PROPERTY] = g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_CAN_SEEK_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_CAN_SEEK_PROPERTY] = g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_CAN_SEEK_BYTES_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_CAN_SEEK_BYTES_PROPERTY] = g_param_spec_boolean ("can-seek-bytes", "can-seek-bytes", "can-seek-bytes", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_VOLUME_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_DURATION_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_DURATION_PROPERTY] = g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_SIZE_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_SIZE_PROPERTY] = g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_POSITION_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_POSITION_PROPERTY] = g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_BYTE_POSITION_PROPERTY, rygel_mpris_player_properties[RYGEL_MPRIS_PLAYER_BYTE_POSITION_PROPERTY] = g_param_spec_int64 ("byte-position", "byte-position", "byte-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_mpris_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface,
                                                      gpointer iface_data)
{
	rygel_mpris_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*) (RygelMediaPlayer*, gint64)) rygel_mpris_player_real_seek;
	iface->seek_bytes = (gboolean (*) (RygelMediaPlayer*, gint64)) rygel_mpris_player_real_seek_bytes;
	iface->get_protocols = (gchar** (*) (RygelMediaPlayer*, gint*)) rygel_mpris_player_real_get_protocols;
	iface->get_mime_types = (gchar** (*) (RygelMediaPlayer*, gint*)) rygel_mpris_player_real_get_mime_types;
	iface->get_user_agent = rygel_mpris_player_real_get_user_agent;
	iface->set_user_agent = rygel_mpris_player_real_set_user_agent;
	iface->get_playback_state = rygel_mpris_player_real_get_playback_state;
	iface->set_playback_state = rygel_mpris_player_real_set_playback_state;
	iface->get_allowed_playback_speeds = rygel_mpris_player_real_get_allowed_playback_speeds;
	iface->get_playback_speed = rygel_mpris_player_real_get_playback_speed;
	iface->set_playback_speed = rygel_mpris_player_real_set_playback_speed;
	iface->get_uri = rygel_mpris_player_real_get_uri;
	iface->set_uri = rygel_mpris_player_real_set_uri;
	iface->get_mime_type = rygel_mpris_player_real_get_mime_type;
	iface->set_mime_type = rygel_mpris_player_real_set_mime_type;
	iface->get_metadata = rygel_mpris_player_real_get_metadata;
	iface->set_metadata = rygel_mpris_player_real_set_metadata;
	iface->get_content_features = rygel_mpris_player_real_get_content_features;
	iface->set_content_features = rygel_mpris_player_real_set_content_features;
	iface->get_can_seek = rygel_mpris_player_real_get_can_seek;
	iface->get_can_seek_bytes = rygel_mpris_player_real_get_can_seek_bytes;
	iface->get_volume = rygel_mpris_player_real_get_volume;
	iface->set_volume = rygel_mpris_player_real_set_volume;
	iface->get_duration = rygel_mpris_player_real_get_duration;
	iface->get_size = rygel_mpris_player_real_get_size;
	iface->get_position = rygel_mpris_player_real_get_position;
	iface->get_byte_position = rygel_mpris_player_real_get_byte_position;
}

static void
rygel_mpris_player_instance_init (RygelMPRISPlayer * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar* _tmp2_;
	self->priv = rygel_mpris_player_get_instance_private (self);
	_tmp0_ = g_strdup ("1");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	self->priv->_allowed_playback_speeds = _tmp1_;
	self->priv->_allowed_playback_speeds_length1 = 1;
	self->priv->__allowed_playback_speeds_size_ = self->priv->_allowed_playback_speeds_length1;
	_tmp2_ = g_strdup ("1");
	self->priv->_playback_speed = _tmp2_;
}

static void
rygel_mpris_player_finalize (GObject * obj)
{
	RygelMPRISPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer);
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->actual_player);
	_g_free0 (self->priv->_user_agent);
	self->priv->_allowed_playback_speeds = (_vala_array_free (self->priv->_allowed_playback_speeds, self->priv->_allowed_playback_speeds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_playback_speed);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_content_features);
	G_OBJECT_CLASS (rygel_mpris_player_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_mpris_player_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPlayer), 0, (GInstanceInitFunc) rygel_mpris_player_instance_init, NULL };
	static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_mpris_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_mpris_player_type_id;
	rygel_mpris_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMPRISPlayer", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_mpris_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
	RygelMPRISPlayer_private_offset = g_type_add_instance_private (rygel_mpris_player_type_id, sizeof (RygelMPRISPlayerPrivate));
	return rygel_mpris_player_type_id;
}

GType
rygel_mpris_player_get_type (void)
{
	static volatile gsize rygel_mpris_player_type_id__once = 0;
	if (g_once_init_enter (&rygel_mpris_player_type_id__once)) {
		GType rygel_mpris_player_type_id;
		rygel_mpris_player_type_id = rygel_mpris_player_get_type_once ();
		g_once_init_leave (&rygel_mpris_player_type_id__once, rygel_mpris_player_type_id);
	}
	return rygel_mpris_player_type_id__once;
}

static void
_vala_rygel_mpris_player_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	RygelMPRISPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer);
	switch (property_id) {
		case RYGEL_MPRIS_PLAYER_USER_AGENT_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_user_agent ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_PLAYBACK_STATE_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_ALLOWED_PLAYBACK_SPEEDS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, rygel_media_player_get_allowed_playback_speeds ((RygelMediaPlayer*) self, &length));
		}
		break;
		case RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_playback_speed ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_MINIMUM_RATE_PROPERTY:
		g_value_set_double (value, rygel_mpris_player_get_minimum_rate (self));
		break;
		case RYGEL_MPRIS_PLAYER_MAXIMUM_RATE_PROPERTY:
		g_value_set_double (value, rygel_mpris_player_get_maximum_rate (self));
		break;
		case RYGEL_MPRIS_PLAYER_URI_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_MIME_TYPE_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_METADATA_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_CONTENT_FEATURES_PROPERTY:
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_CAN_SEEK_PROPERTY:
		g_value_set_boolean (value, rygel_media_player_get_can_seek ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_CAN_SEEK_BYTES_PROPERTY:
		g_value_set_boolean (value, rygel_media_player_get_can_seek_bytes ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_VOLUME_PROPERTY:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_DURATION_PROPERTY:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_media_player_get_size ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_POSITION_PROPERTY:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_BYTE_POSITION_PROPERTY:
		g_value_set_int64 (value, rygel_media_player_get_byte_position ((RygelMediaPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_mpris_player_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	RygelMPRISPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer);
	switch (property_id) {
		case RYGEL_MPRIS_PLAYER_USER_AGENT_PROPERTY:
		rygel_media_player_set_user_agent ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_PLAYBACK_STATE_PROPERTY:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED_PROPERTY:
		rygel_media_player_set_playback_speed ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_URI_PROPERTY:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_MIME_TYPE_PROPERTY:
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_METADATA_PROPERTY:
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_CONTENT_FEATURES_PROPERTY:
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_VOLUME_PROPERTY:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

