/* serializer.c generated by valac 0.56.3, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 * Copyright (C) 2010 Robin Sonefors
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <langinfo.h>
#include <glib/gi18n-lib.h>

enum  {
	SERIALIZER_0_PROPERTY,
	SERIALIZER_ERROR_PROPERTY,
	SERIALIZER_NUM_PROPERTIES
};
static GParamSpec* serializer_properties[SERIALIZER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SerializerPrivate {
	gint leading_digits;
	gint trailing_digits;
	DisplayFormat format;
	gboolean show_tsep;
	gboolean show_zeroes;
	gint number_base;
	guint representation_base;
	gunichar radix;
	gunichar tsep;
	gint tsep_count;
	gchar* _error;
};

static gint Serializer_private_offset;
static gpointer serializer_parent_class = NULL;

static gchar* serializer_cast_to_string (Serializer* self,
                                  Number* x,
                                  gint* n_digits);
static gchar* serializer_cast_to_exponential_string (Serializer* self,
                                              Number* x,
                                              gboolean eng_format,
                                              gint* n_digits);
static void serializer_cast_to_string_real (Serializer* self,
                                     Number* x,
                                     gint number_base,
                                     gboolean force_sign,
                                     gint* n_digits,
                                     GString* string);
static gint serializer_cast_to_exponential_string_real (Serializer* self,
                                                 Number* x,
                                                 GString* string,
                                                 gboolean eng_format,
                                                 gint* n_digits);
static void serializer_append_exponent (Serializer* self,
                                 GString* string,
                                 gint exponent);
static void serializer_finalize (GObject * obj);
static GType serializer_get_type_once (void);
static void _vala_serializer_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_serializer_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

static GType
display_format_get_type_once (void)
{
	static const GEnumValue values[] = {{DISPLAY_FORMAT_AUTOMATIC, "DISPLAY_FORMAT_AUTOMATIC", "automatic"}, {DISPLAY_FORMAT_FIXED, "DISPLAY_FORMAT_FIXED", "fixed"}, {DISPLAY_FORMAT_SCIENTIFIC, "DISPLAY_FORMAT_SCIENTIFIC", "scientific"}, {DISPLAY_FORMAT_ENGINEERING, "DISPLAY_FORMAT_ENGINEERING", "engineering"}, {0, NULL, NULL}};
	GType display_format_type_id;
	display_format_type_id = g_enum_register_static ("DisplayFormat", values);
	return display_format_type_id;
}

GType
display_format_get_type (void)
{
	static volatile gsize display_format_type_id__once = 0;
	if (g_once_init_enter (&display_format_type_id__once)) {
		GType display_format_type_id;
		display_format_type_id = display_format_get_type_once ();
		g_once_init_leave (&display_format_type_id__once, display_format_type_id);
	}
	return display_format_type_id__once;
}

static inline gpointer
serializer_get_instance_private (Serializer* self)
{
	return G_STRUCT_MEMBER_P (self, Serializer_private_offset);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

Serializer*
serializer_construct (GType object_type,
                      DisplayFormat format,
                      gint number_base,
                      gint trailing_digits)
{
	Serializer * self = NULL;
	gchar* radix_string = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* tsep_string = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	self = (Serializer*) g_object_new (object_type, NULL);
	_tmp0_ = nl_langinfo (RADIXCHAR);
	_tmp1_ = g_strdup (_tmp0_);
	radix_string = _tmp1_;
	_tmp3_ = radix_string;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = radix_string;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* radix_utf8 = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = radix_string;
		_tmp6_ = g_locale_to_utf8 (_tmp5_, (gssize) -1, NULL, NULL, NULL);
		radix_utf8 = _tmp6_;
		_tmp7_ = radix_utf8;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			_tmp8_ = radix_utf8;
			self->priv->radix = string_get_char (_tmp8_, (glong) 0);
		} else {
			self->priv->radix = (gunichar) '.';
		}
		_g_free0 (radix_utf8);
	} else {
		self->priv->radix = (gunichar) '.';
	}
	_tmp9_ = nl_langinfo (THOUSEP);
	_tmp10_ = g_strdup (_tmp9_);
	tsep_string = _tmp10_;
	_tmp12_ = tsep_string;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		_tmp13_ = tsep_string;
		_tmp11_ = g_strcmp0 (_tmp13_, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* tsep_utf8 = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = tsep_string;
		_tmp15_ = g_locale_to_utf8 (_tmp14_, (gssize) -1, NULL, NULL, NULL);
		tsep_utf8 = _tmp15_;
		_tmp16_ = tsep_utf8;
		if (_tmp16_ != NULL) {
			const gchar* _tmp17_;
			_tmp17_ = tsep_utf8;
			self->priv->tsep = string_get_char (_tmp17_, (glong) 0);
		} else {
			self->priv->tsep = (gunichar) ' ';
		}
		_g_free0 (tsep_utf8);
	} else {
		self->priv->tsep = (gunichar) ' ';
	}
	self->priv->tsep_count = 3;
	self->priv->number_base = number_base;
	self->priv->representation_base = (guint) number_base;
	self->priv->leading_digits = 12;
	self->priv->trailing_digits = trailing_digits;
	self->priv->show_zeroes = FALSE;
	self->priv->show_tsep = FALSE;
	self->priv->format = format;
	_g_free0 (tsep_string);
	_g_free0 (radix_string);
	return self;
}

Serializer*
serializer_new (DisplayFormat format,
                gint number_base,
                gint trailing_digits)
{
	return serializer_construct (TYPE_SERIALIZER, format, number_base, trailing_digits);
}

gchar*
serializer_to_string (Serializer* self,
                      Number* x)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	if (self->priv->representation_base != ((guint) self->priv->number_base)) {
		gint n_digits = 0;
		gchar* _tmp0_;
		n_digits = 0;
		_tmp0_ = serializer_cast_to_string (self, x, &n_digits);
		result = _tmp0_;
		return result;
	}
	switch (self->priv->format) {
		default:
		case DISPLAY_FORMAT_AUTOMATIC:
		{
			gint n_digits = 0;
			gchar* s0 = NULL;
			gchar* _tmp1_;
			n_digits = 0;
			_tmp1_ = serializer_cast_to_string (self, x, &n_digits);
			s0 = _tmp1_;
			switch (serializer_get_base (self)) {
				case 2:
				{
					if (n_digits <= 64) {
						result = s0;
						return result;
					} else {
						gchar* _tmp2_;
						_tmp2_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
						result = _tmp2_;
						_g_free0 (s0);
						return result;
					}
				}
				case 8:
				{
					if (n_digits <= 22) {
						result = s0;
						return result;
					} else {
						gchar* _tmp3_;
						_tmp3_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
						result = _tmp3_;
						_g_free0 (s0);
						return result;
					}
				}
				case 16:
				{
					if (n_digits <= 16) {
						result = s0;
						return result;
					} else {
						gchar* _tmp4_;
						_tmp4_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
						result = _tmp4_;
						_g_free0 (s0);
						return result;
					}
				}
				default:
				case 10:
				{
					if (n_digits <= self->priv->leading_digits) {
						result = s0;
						return result;
					} else {
						gchar* _tmp5_;
						_tmp5_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
						result = _tmp5_;
						_g_free0 (s0);
						return result;
					}
				}
			}
			_g_free0 (s0);
		}
		case DISPLAY_FORMAT_FIXED:
		{
			gint n_digits = 0;
			gchar* _tmp6_;
			n_digits = 0;
			_tmp6_ = serializer_cast_to_string (self, x, &n_digits);
			result = _tmp6_;
			return result;
		}
		case DISPLAY_FORMAT_SCIENTIFIC:
		{
			if (self->priv->representation_base == ((guint) 10)) {
				gint n_digits = 0;
				gchar* _tmp7_;
				n_digits = 0;
				_tmp7_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
				result = _tmp7_;
				return result;
			} else {
				gint n_digits = 0;
				gchar* _tmp8_;
				n_digits = 0;
				_tmp8_ = serializer_cast_to_string (self, x, &n_digits);
				result = _tmp8_;
				return result;
			}
		}
		case DISPLAY_FORMAT_ENGINEERING:
		{
			if (self->priv->representation_base == ((guint) 10)) {
				gint n_digits = 0;
				gchar* _tmp9_;
				n_digits = 0;
				_tmp9_ = serializer_cast_to_exponential_string (self, x, TRUE, &n_digits);
				result = _tmp9_;
				return result;
			} else {
				gint n_digits = 0;
				gchar* _tmp10_;
				n_digits = 0;
				_tmp10_ = serializer_cast_to_string (self, x, &n_digits);
				result = _tmp10_;
				return result;
			}
		}
	}
}

Number*
serializer_from_string (Serializer* self,
                        const gchar* str)
{
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = mp_set_from_string (str, self->priv->number_base);
	result = _tmp0_;
	return result;
}

void
serializer_set_base (Serializer* self,
                     gint number_base)
{
	g_return_if_fail (self != NULL);
	self->priv->number_base = number_base;
}

gint
serializer_get_base (Serializer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->number_base;
	return result;
}

void
serializer_set_representation_base (Serializer* self,
                                    guint representation_base)
{
	g_return_if_fail (self != NULL);
	self->priv->representation_base = representation_base;
}

guint
serializer_get_representation_base (Serializer* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->representation_base;
	return result;
}

void
serializer_set_radix (Serializer* self,
                      gunichar radix)
{
	g_return_if_fail (self != NULL);
	self->priv->radix = radix;
}

gunichar
serializer_get_radix (Serializer* self)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->radix;
	return result;
}

void
serializer_set_thousands_separator (Serializer* self,
                                    gunichar separator)
{
	g_return_if_fail (self != NULL);
	self->priv->tsep = separator;
}

gunichar
serializer_get_thousands_separator (Serializer* self)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->tsep;
	return result;
}

gint
serializer_get_thousands_separator_count (Serializer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->tsep_count;
	return result;
}

void
serializer_set_thousands_separator_count (Serializer* self,
                                          gint count)
{
	g_return_if_fail (self != NULL);
	self->priv->tsep_count = count;
}

void
serializer_set_show_thousands_separators (Serializer* self,
                                          gboolean visible)
{
	g_return_if_fail (self != NULL);
	self->priv->show_tsep = visible;
}

gboolean
serializer_get_show_thousands_separators (Serializer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->show_tsep;
	return result;
}

void
serializer_set_show_trailing_zeroes (Serializer* self,
                                     gboolean visible)
{
	g_return_if_fail (self != NULL);
	self->priv->show_zeroes = visible;
}

gboolean
serializer_get_show_trailing_zeroes (Serializer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->show_zeroes;
	return result;
}

gint
serializer_get_leading_digits (Serializer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->leading_digits;
	return result;
}

void
serializer_set_leading_digits (Serializer* self,
                               gint leading_digits)
{
	g_return_if_fail (self != NULL);
	self->priv->leading_digits = leading_digits;
}

gint
serializer_get_trailing_digits (Serializer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->trailing_digits;
	return result;
}

void
serializer_set_trailing_digits (Serializer* self,
                                gint trailing_digits)
{
	g_return_if_fail (self != NULL);
	self->priv->trailing_digits = trailing_digits;
}

DisplayFormat
serializer_get_number_format (Serializer* self)
{
	DisplayFormat result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->format;
	return result;
}

void
serializer_set_number_format (Serializer* self,
                              DisplayFormat format)
{
	g_return_if_fail (self != NULL);
	self->priv->format = format;
}

static gchar*
serializer_cast_to_string (Serializer* self,
                           Number* x,
                           gint* n_digits)
{
	GString* string = NULL;
	GString* _tmp0_;
	Number* x_real = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	GString* _tmp3_;
	GString* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = number_real_component (x);
	x_real = _tmp1_;
	_tmp2_ = x_real;
	_tmp3_ = string;
	serializer_cast_to_string_real (self, _tmp2_, (gint) self->priv->representation_base, FALSE, n_digits, _tmp3_);
	if (number_is_complex (x)) {
		Number* x_im = NULL;
		Number* _tmp4_;
		gboolean force_sign = FALSE;
		GString* _tmp5_;
		const gchar* _tmp6_;
		GString* s = NULL;
		GString* _tmp8_;
		gint n_complex_digits = 0;
		Number* _tmp9_;
		GString* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		GString* _tmp13_;
		const gchar* _tmp14_;
		_tmp4_ = number_imaginary_component (x);
		x_im = _tmp4_;
		force_sign = TRUE;
		_tmp5_ = string;
		_tmp6_ = _tmp5_->str;
		if (g_strcmp0 (_tmp6_, "0") == 0) {
			GString* _tmp7_;
			_tmp7_ = string;
			g_string_assign (_tmp7_, "");
			force_sign = FALSE;
		}
		_tmp8_ = g_string_sized_new ((gsize) 1024);
		s = _tmp8_;
		n_complex_digits = 0;
		_tmp9_ = x_im;
		_tmp10_ = s;
		serializer_cast_to_string_real (self, _tmp9_, (gint) self->priv->representation_base, force_sign, &n_complex_digits, _tmp10_);
		if (n_complex_digits > (*n_digits)) {
			*n_digits = n_complex_digits;
		}
		_tmp13_ = s;
		_tmp14_ = _tmp13_->str;
		if (g_strcmp0 (_tmp14_, "0") == 0) {
			_tmp12_ = TRUE;
		} else {
			GString* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = s;
			_tmp16_ = _tmp15_->str;
			_tmp12_ = g_strcmp0 (_tmp16_, "+0") == 0;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			GString* _tmp17_;
			const gchar* _tmp18_;
			_tmp17_ = s;
			_tmp18_ = _tmp17_->str;
			_tmp11_ = g_strcmp0 (_tmp18_, "−0") == 0;
		}
		if (_tmp11_) {
			GString* _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = string;
			_tmp20_ = _tmp19_->str;
			if (g_strcmp0 (_tmp20_, "") == 0) {
				GString* _tmp21_;
				_tmp21_ = string;
				g_string_append (_tmp21_, "0");
			}
		} else {
			GString* _tmp22_;
			const gchar* _tmp23_;
			_tmp22_ = s;
			_tmp23_ = _tmp22_->str;
			if (g_strcmp0 (_tmp23_, "1") == 0) {
				GString* _tmp24_;
				_tmp24_ = string;
				g_string_append (_tmp24_, "i");
			} else {
				GString* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = s;
				_tmp26_ = _tmp25_->str;
				if (g_strcmp0 (_tmp26_, "+1") == 0) {
					GString* _tmp27_;
					_tmp27_ = string;
					g_string_append (_tmp27_, "+i");
				} else {
					GString* _tmp28_;
					const gchar* _tmp29_;
					_tmp28_ = s;
					_tmp29_ = _tmp28_->str;
					if (g_strcmp0 (_tmp29_, "−1") == 0) {
						GString* _tmp30_;
						_tmp30_ = string;
						g_string_append (_tmp30_, "−i");
					} else {
						GString* _tmp31_;
						const gchar* _tmp32_;
						GString* _tmp39_;
						_tmp31_ = s;
						_tmp32_ = _tmp31_->str;
						if (g_strcmp0 (_tmp32_, "+0") == 0) {
							GString* _tmp33_;
							_tmp33_ = string;
							g_string_append (_tmp33_, "+");
						} else {
							GString* _tmp34_;
							const gchar* _tmp35_;
							_tmp34_ = s;
							_tmp35_ = _tmp34_->str;
							if (g_strcmp0 (_tmp35_, "0") != 0) {
								GString* _tmp36_;
								GString* _tmp37_;
								const gchar* _tmp38_;
								_tmp36_ = string;
								_tmp37_ = s;
								_tmp38_ = _tmp37_->str;
								g_string_append (_tmp36_, _tmp38_);
							}
						}
						_tmp39_ = string;
						g_string_append (_tmp39_, "i");
					}
				}
			}
		}
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp40_ = string;
	_tmp41_ = _tmp40_->str;
	_tmp42_ = g_strdup (_tmp41_);
	result = _tmp42_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
serializer_cast_to_string_real (Serializer* self,
                                Number* x,
                                gint number_base,
                                gboolean force_sign,
                                gint* n_digits,
                                GString* string)
{
	static const gchar digits[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	Number* number = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* temp = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* rounded_number = NULL;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	gint i = 0;
	gssize last_non_zero = 0L;
	Number* _tmp36_;
	Number* _tmp37_;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	g_return_if_fail (string != NULL);
	_tmp0_ = _g_object_ref0 (x);
	number = _tmp0_;
	_tmp1_ = number;
	if (number_is_negative (_tmp1_)) {
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = number;
		_tmp3_ = number_abs (_tmp2_);
		_g_object_unref0 (number);
		number = _tmp3_;
	}
	_tmp4_ = number_new_integer ((gint64) number_base, (gint64) 0);
	temp = _tmp4_;
	_tmp5_ = temp;
	_tmp6_ = number_xpowy_integer (_tmp5_, (gint64) (-(self->priv->trailing_digits + 1)));
	_g_object_unref0 (temp);
	temp = _tmp6_;
	_tmp7_ = temp;
	_tmp8_ = number_multiply_integer (_tmp7_, (gint64) number_base);
	_g_object_unref0 (temp);
	temp = _tmp8_;
	_tmp9_ = temp;
	_tmp10_ = number_divide_integer (_tmp9_, (gint64) 2);
	_g_object_unref0 (temp);
	temp = _tmp10_;
	_tmp11_ = number;
	_tmp12_ = temp;
	_tmp13_ = number_add (_tmp11_, _tmp12_);
	rounded_number = _tmp13_;
	_tmp14_ = rounded_number;
	_tmp15_ = number_floor (_tmp14_);
	_g_object_unref0 (temp);
	temp = _tmp15_;
	i = 0;
	{
		gboolean _tmp16_ = FALSE;
		_tmp16_ = TRUE;
		while (TRUE) {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gint _tmp20_;
			Number* t = NULL;
			Number* _tmp21_;
			Number* _tmp22_;
			Number* _tmp23_;
			Number* _tmp24_;
			Number* t2 = NULL;
			Number* _tmp25_;
			Number* _tmp26_;
			Number* t3 = NULL;
			Number* _tmp27_;
			Number* _tmp28_;
			Number* _tmp29_;
			gint64 d = 0LL;
			Number* _tmp30_;
			gboolean _tmp31_ = FALSE;
			gint _tmp33_;
			Number* _tmp34_;
			Number* _tmp35_;
			if (!_tmp16_) {
				Number* _tmp17_;
				_tmp17_ = temp;
				if (!(!number_is_zero (_tmp17_))) {
					break;
				}
			}
			_tmp16_ = FALSE;
			if (number_base == 10) {
				_tmp19_ = self->priv->show_tsep;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				_tmp18_ = i == self->priv->tsep_count;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				g_string_prepend_unichar (string, self->priv->tsep);
				i = 0;
			}
			_tmp20_ = i;
			i = _tmp20_ + 1;
			_tmp21_ = temp;
			_tmp22_ = number_divide_integer (_tmp21_, (gint64) number_base);
			t = _tmp22_;
			_tmp23_ = t;
			_tmp24_ = number_floor (_tmp23_);
			_g_object_unref0 (t);
			t = _tmp24_;
			_tmp25_ = t;
			_tmp26_ = number_multiply_integer (_tmp25_, (gint64) number_base);
			t2 = _tmp26_;
			_tmp27_ = temp;
			_tmp28_ = t2;
			_tmp29_ = number_subtract (_tmp27_, _tmp28_);
			t3 = _tmp29_;
			_tmp30_ = t3;
			d = number_to_integer (_tmp30_);
			if (d < ((gint64) 16)) {
				_tmp31_ = d >= ((gint64) 0);
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				gchar _tmp32_;
				_tmp32_ = digits[d];
				g_string_prepend_c (string, _tmp32_);
			} else {
				g_string_prepend_c (string, '?');
				serializer_set_error (self, _ ("Overflow: the result couldn’t be calculated"));
				g_string_assign (string, "0");
				_g_object_unref0 (t3);
				_g_object_unref0 (t2);
				_g_object_unref0 (t);
				break;
			}
			_tmp33_ = *n_digits;
			*n_digits = _tmp33_ + 1;
			_tmp34_ = t;
			_tmp35_ = _g_object_ref0 (_tmp34_);
			_g_object_unref0 (temp);
			temp = _tmp35_;
			_g_object_unref0 (t3);
			_g_object_unref0 (t2);
			_g_object_unref0 (t);
		}
	}
	last_non_zero = string->len;
	g_string_append_unichar (string, self->priv->radix);
	_tmp36_ = rounded_number;
	_tmp37_ = number_fractional_component (_tmp36_);
	_g_object_unref0 (temp);
	temp = _tmp37_;
	{
		gboolean _tmp38_ = FALSE;
		i = 0;
		_tmp38_ = TRUE;
		while (TRUE) {
			Number* _tmp40_;
			Number* _tmp41_;
			Number* _tmp42_;
			Number* digit = NULL;
			Number* _tmp43_;
			Number* _tmp44_;
			gint64 d = 0LL;
			Number* _tmp45_;
			gchar _tmp46_;
			Number* _tmp47_;
			Number* _tmp48_;
			Number* _tmp49_;
			if (!_tmp38_) {
				gint _tmp39_;
				_tmp39_ = i;
				i = _tmp39_ + 1;
			}
			_tmp38_ = FALSE;
			if (!(i < self->priv->trailing_digits)) {
				break;
			}
			_tmp40_ = temp;
			if (number_is_zero (_tmp40_)) {
				break;
			}
			_tmp41_ = temp;
			_tmp42_ = number_multiply_integer (_tmp41_, (gint64) number_base);
			_g_object_unref0 (temp);
			temp = _tmp42_;
			_tmp43_ = temp;
			_tmp44_ = number_floor (_tmp43_);
			digit = _tmp44_;
			_tmp45_ = digit;
			d = number_to_integer (_tmp45_);
			_tmp46_ = digits[d];
			g_string_append_c (string, _tmp46_);
			if (d != ((gint64) 0)) {
				last_non_zero = string->len;
			}
			_tmp47_ = temp;
			_tmp48_ = digit;
			_tmp49_ = number_subtract (_tmp47_, _tmp48_);
			_g_object_unref0 (temp);
			temp = _tmp49_;
			_g_object_unref0 (digit);
		}
	}
	if (!self->priv->show_zeroes) {
		_tmp50_ = TRUE;
	} else {
		_tmp50_ = self->priv->trailing_digits == 0;
	}
	if (_tmp50_) {
		g_string_truncate (string, (gsize) last_non_zero);
	}
	_tmp52_ = string->str;
	if (g_strcmp0 (_tmp52_, "0") != 0) {
		_tmp51_ = TRUE;
	} else {
		_tmp51_ = force_sign;
	}
	if (_tmp51_) {
		if (number_is_negative (x)) {
			g_string_prepend (string, "−");
		} else {
			if (force_sign) {
				g_string_prepend (string, "+");
			}
		}
	}
	if (number_base != self->priv->number_base) {
		static const gchar* sub_digits[10] = {"₀", "₁", "₂", "₃", "₄", "₅", "₆", "₇", "₈", "₉"};
		gint multiplier = 0;
		gint b = 0;
		multiplier = 1;
		b = number_base;
		while (TRUE) {
			if (!((number_base / multiplier) != 0)) {
				break;
			}
			multiplier *= 10;
		}
		while (TRUE) {
			gint d = 0;
			const gchar* _tmp53_;
			if (!(multiplier != 1)) {
				break;
			}
			multiplier /= 10;
			d = b / multiplier;
			_tmp53_ = sub_digits[d];
			g_string_append (string, _tmp53_);
			b -= d * multiplier;
		}
	}
	_g_object_unref0 (rounded_number);
	_g_object_unref0 (temp);
	_g_object_unref0 (number);
}

static gint
serializer_cast_to_exponential_string_real (Serializer* self,
                                            Number* x,
                                            GString* string,
                                            gboolean eng_format,
                                            gint* n_digits)
{
	Number* mantissa = NULL;
	Number* _tmp0_;
	Number* base_ = NULL;
	Number* _tmp1_;
	Number* base3 = NULL;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* base10 = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* t = NULL;
	Number* _tmp6_;
	Number* base10inv = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	gint exponent = 0;
	Number* _tmp10_;
	Number* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (x != NULL, 0);
	g_return_val_if_fail (string != NULL, 0);
	if (number_is_negative (x)) {
		g_string_append (string, "−");
	}
	_tmp0_ = number_abs (x);
	mantissa = _tmp0_;
	_tmp1_ = number_new_integer ((gint64) self->priv->number_base, (gint64) 0);
	base_ = _tmp1_;
	_tmp2_ = base_;
	_tmp3_ = number_xpowy_integer (_tmp2_, (gint64) 3);
	base3 = _tmp3_;
	_tmp4_ = base_;
	_tmp5_ = number_xpowy_integer (_tmp4_, (gint64) 10);
	base10 = _tmp5_;
	_tmp6_ = number_new_integer ((gint64) 1, (gint64) 0);
	t = _tmp6_;
	_tmp7_ = t;
	_tmp8_ = base10;
	_tmp9_ = number_divide (_tmp7_, _tmp8_);
	base10inv = _tmp9_;
	exponent = 0;
	_tmp10_ = mantissa;
	if (!number_is_zero (_tmp10_)) {
		Number* _tmp34_;
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			Number* _tmp14_;
			Number* _tmp15_;
			Number* _tmp16_;
			if (!eng_format) {
				Number* _tmp12_;
				Number* _tmp13_;
				_tmp12_ = mantissa;
				_tmp13_ = base10;
				_tmp11_ = number_compare (_tmp12_, _tmp13_) >= 0;
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			exponent += 10;
			_tmp14_ = mantissa;
			_tmp15_ = base10inv;
			_tmp16_ = number_multiply (_tmp14_, _tmp15_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp16_;
		}
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			Number* _tmp25_;
			Number* _tmp26_;
			Number* _tmp27_;
			if (!eng_format) {
				Number* _tmp19_;
				Number* _tmp20_;
				_tmp19_ = mantissa;
				_tmp20_ = base_;
				_tmp18_ = number_compare (_tmp19_, _tmp20_) >= 0;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				_tmp17_ = TRUE;
			} else {
				gboolean _tmp21_ = FALSE;
				if (eng_format) {
					gboolean _tmp22_ = FALSE;
					Number* _tmp23_;
					Number* _tmp24_;
					_tmp23_ = mantissa;
					_tmp24_ = base3;
					if (number_compare (_tmp23_, _tmp24_) >= 0) {
						_tmp22_ = TRUE;
					} else {
						_tmp22_ = (exponent % 3) != 0;
					}
					_tmp21_ = _tmp22_;
				} else {
					_tmp21_ = FALSE;
				}
				_tmp17_ = _tmp21_;
			}
			if (!_tmp17_) {
				break;
			}
			exponent += 1;
			_tmp25_ = mantissa;
			_tmp26_ = base_;
			_tmp27_ = number_divide (_tmp25_, _tmp26_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp27_;
		}
		while (TRUE) {
			gboolean _tmp28_ = FALSE;
			Number* _tmp31_;
			Number* _tmp32_;
			Number* _tmp33_;
			if (!eng_format) {
				Number* _tmp29_;
				Number* _tmp30_;
				_tmp29_ = mantissa;
				_tmp30_ = base10inv;
				_tmp28_ = number_compare (_tmp29_, _tmp30_) < 0;
			} else {
				_tmp28_ = FALSE;
			}
			if (!_tmp28_) {
				break;
			}
			exponent -= 10;
			_tmp31_ = mantissa;
			_tmp32_ = base10;
			_tmp33_ = number_multiply (_tmp31_, _tmp32_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp33_;
		}
		_tmp34_ = number_new_integer ((gint64) 1, (gint64) 0);
		_g_object_unref0 (t);
		t = _tmp34_;
		while (TRUE) {
			gboolean _tmp35_ = FALSE;
			Number* _tmp36_;
			Number* _tmp37_;
			Number* _tmp39_;
			Number* _tmp40_;
			Number* _tmp41_;
			_tmp36_ = mantissa;
			_tmp37_ = t;
			if (number_compare (_tmp36_, _tmp37_) < 0) {
				_tmp35_ = TRUE;
			} else {
				gboolean _tmp38_ = FALSE;
				if (eng_format) {
					_tmp38_ = (exponent % 3) != 0;
				} else {
					_tmp38_ = FALSE;
				}
				_tmp35_ = _tmp38_;
			}
			if (!_tmp35_) {
				break;
			}
			exponent -= 1;
			_tmp39_ = mantissa;
			_tmp40_ = base_;
			_tmp41_ = number_multiply (_tmp39_, _tmp40_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp41_;
		}
	}
	_tmp42_ = mantissa;
	_tmp43_ = serializer_cast_to_string (self, _tmp42_, n_digits);
	_tmp44_ = _tmp43_;
	g_string_append (string, _tmp44_);
	_g_free0 (_tmp44_);
	result = exponent;
	_g_object_unref0 (base10inv);
	_g_object_unref0 (t);
	_g_object_unref0 (base10);
	_g_object_unref0 (base3);
	_g_object_unref0 (base_);
	_g_object_unref0 (mantissa);
	return result;
}

static gchar*
serializer_cast_to_exponential_string (Serializer* self,
                                       Number* x,
                                       gboolean eng_format,
                                       gint* n_digits)
{
	GString* string = NULL;
	GString* _tmp0_;
	Number* x_real = NULL;
	Number* _tmp1_;
	gint exponent = 0;
	Number* _tmp2_;
	GString* _tmp3_;
	gint _tmp4_;
	GString* _tmp5_;
	GString* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = number_real_component (x);
	x_real = _tmp1_;
	_tmp2_ = x_real;
	_tmp3_ = string;
	_tmp4_ = serializer_cast_to_exponential_string_real (self, _tmp2_, _tmp3_, eng_format, n_digits);
	exponent = _tmp4_;
	_tmp5_ = string;
	serializer_append_exponent (self, _tmp5_, exponent);
	if (number_is_complex (x)) {
		Number* x_im = NULL;
		Number* _tmp6_;
		GString* _tmp7_;
		const gchar* _tmp8_;
		GString* s = NULL;
		GString* _tmp10_;
		gint n_complex_digits = 0;
		Number* _tmp11_;
		GString* _tmp12_;
		gint _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		GString* _tmp16_;
		const gchar* _tmp17_;
		GString* _tmp40_;
		_tmp6_ = number_imaginary_component (x);
		x_im = _tmp6_;
		_tmp7_ = string;
		_tmp8_ = _tmp7_->str;
		if (g_strcmp0 (_tmp8_, "0") == 0) {
			GString* _tmp9_;
			_tmp9_ = string;
			g_string_assign (_tmp9_, "");
		}
		_tmp10_ = g_string_sized_new ((gsize) 1024);
		s = _tmp10_;
		n_complex_digits = 0;
		_tmp11_ = x_im;
		_tmp12_ = s;
		_tmp13_ = serializer_cast_to_exponential_string_real (self, _tmp11_, _tmp12_, eng_format, &n_complex_digits);
		exponent = _tmp13_;
		if (n_complex_digits > (*n_digits)) {
			*n_digits = n_complex_digits;
		}
		_tmp16_ = s;
		_tmp17_ = _tmp16_->str;
		if (g_strcmp0 (_tmp17_, "0") == 0) {
			_tmp15_ = TRUE;
		} else {
			GString* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = s;
			_tmp19_ = _tmp18_->str;
			_tmp15_ = g_strcmp0 (_tmp19_, "+0") == 0;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			GString* _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = s;
			_tmp21_ = _tmp20_->str;
			_tmp14_ = g_strcmp0 (_tmp21_, "−0") == 0;
		}
		if (_tmp14_) {
		} else {
			GString* _tmp22_;
			const gchar* _tmp23_;
			_tmp22_ = s;
			_tmp23_ = _tmp22_->str;
			if (g_strcmp0 (_tmp23_, "1") == 0) {
				GString* _tmp24_;
				_tmp24_ = string;
				g_string_append (_tmp24_, "i");
			} else {
				GString* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = s;
				_tmp26_ = _tmp25_->str;
				if (g_strcmp0 (_tmp26_, "+1") == 0) {
					GString* _tmp27_;
					_tmp27_ = string;
					g_string_append (_tmp27_, "+i");
				} else {
					GString* _tmp28_;
					const gchar* _tmp29_;
					_tmp28_ = s;
					_tmp29_ = _tmp28_->str;
					if (g_strcmp0 (_tmp29_, "−1") == 0) {
						GString* _tmp30_;
						_tmp30_ = string;
						g_string_append (_tmp30_, "−i");
					} else {
						GString* _tmp31_;
						const gchar* _tmp32_;
						GString* _tmp39_;
						_tmp31_ = s;
						_tmp32_ = _tmp31_->str;
						if (g_strcmp0 (_tmp32_, "+0") == 0) {
							GString* _tmp33_;
							_tmp33_ = string;
							g_string_append (_tmp33_, "+");
						} else {
							GString* _tmp34_;
							const gchar* _tmp35_;
							_tmp34_ = s;
							_tmp35_ = _tmp34_->str;
							if (g_strcmp0 (_tmp35_, "0") != 0) {
								GString* _tmp36_;
								GString* _tmp37_;
								const gchar* _tmp38_;
								_tmp36_ = string;
								_tmp37_ = s;
								_tmp38_ = _tmp37_->str;
								g_string_append (_tmp36_, _tmp38_);
							}
						}
						_tmp39_ = string;
						g_string_append (_tmp39_, "i");
					}
				}
			}
		}
		_tmp40_ = string;
		serializer_append_exponent (self, _tmp40_, exponent);
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp41_ = string;
	_tmp42_ = _tmp41_->str;
	_tmp43_ = g_strdup (_tmp42_);
	result = _tmp43_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
serializer_append_exponent (Serializer* self,
                            GString* string,
                            gint exponent)
{
	static const gunichar super_digits[10] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	gchar* super_value = NULL;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (string != NULL);
	if (exponent == 0) {
		return;
	}
	g_string_append (string, "×10");
	if (exponent < 0) {
		exponent = -exponent;
		g_string_append_unichar (string, 8315U);
	}
	_tmp0_ = g_strdup_printf ("%d", exponent);
	super_value = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				const gchar* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				const gchar* _tmp6_;
				gunichar _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = super_value;
				_tmp4_ = strlen (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = super_value;
				_tmp7_ = super_digits[string_get (_tmp6_, (glong) i) - '0'];
				g_string_append_unichar (string, _tmp7_);
			}
		}
	}
	_g_free0 (super_value);
}

const gchar*
serializer_get_error (Serializer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error;
	result = _tmp0_;
	return result;
}

void
serializer_set_error (Serializer* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = serializer_get_error (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_error);
		self->priv->_error = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, serializer_properties[SERIALIZER_ERROR_PROPERTY]);
	}
}

static void
serializer_class_init (SerializerClass * klass,
                       gpointer klass_data)
{
	serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Serializer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_serializer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_serializer_set_property;
	G_OBJECT_CLASS (klass)->finalize = serializer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SERIALIZER_ERROR_PROPERTY, serializer_properties[SERIALIZER_ERROR_PROPERTY] = g_param_spec_string ("error", "error", "error", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
serializer_instance_init (Serializer * self,
                          gpointer klass)
{
	self->priv = serializer_get_instance_private (self);
	self->priv->_error = NULL;
}

static void
serializer_finalize (GObject * obj)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERIALIZER, Serializer);
	_g_free0 (self->priv->_error);
	G_OBJECT_CLASS (serializer_parent_class)->finalize (obj);
}

static GType
serializer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Serializer), 0, (GInstanceInitFunc) serializer_instance_init, NULL };
	GType serializer_type_id;
	serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "Serializer", &g_define_type_info, 0);
	Serializer_private_offset = g_type_add_instance_private (serializer_type_id, sizeof (SerializerPrivate));
	return serializer_type_id;
}

GType
serializer_get_type (void)
{
	static volatile gsize serializer_type_id__once = 0;
	if (g_once_init_enter (&serializer_type_id__once)) {
		GType serializer_type_id;
		serializer_type_id = serializer_get_type_once ();
		g_once_init_leave (&serializer_type_id__once, serializer_type_id);
	}
	return serializer_type_id__once;
}

static void
_vala_serializer_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
	switch (property_id) {
		case SERIALIZER_ERROR_PROPERTY:
		g_value_set_string (value, serializer_get_error (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_serializer_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
	switch (property_id) {
		case SERIALIZER_ERROR_PROPERTY:
		serializer_set_error (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

