/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Random;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Random"})
public class RubyRandom
extends RubyObject {
    private static final int DEFAULT_SEED_CNT = 4;
    private RandomType random = null;

    static int getIntBigIntegerBuffer(byte[] src, int loc) {
        int v = 0;
        int idx = src.length - loc * 4 - 1;
        if (idx >= 0) {
            v |= src[idx--] & 0xFF;
            if (idx >= 0) {
                v |= (src[idx--] & 0xFF) << 8;
                if (idx >= 0) {
                    v |= (src[idx--] & 0xFF) << 16;
                    if (idx >= 0) {
                        v |= (src[idx--] & 0xFF) << 24;
                    }
                }
            }
        }
        return v;
    }

    static void setIntBigIntegerBuffer(byte[] dest, int loc, int value2) {
        int idx = dest.length - loc * 4 - 1;
        if (idx >= 0) {
            dest[idx--] = (byte)(value2 & 0xFF);
            if (idx >= 0) {
                dest[idx--] = (byte)(value2 >> 8 & 0xFF);
                if (idx >= 0) {
                    dest[idx--] = (byte)(value2 >> 16 & 0xFF);
                    if (idx >= 0) {
                        dest[idx--] = (byte)(value2 >> 24 & 0xFF);
                    }
                }
            }
        }
    }

    public static BigInteger randomSeedBigInteger(java.util.Random random) {
        byte[] seed2 = new byte[16];
        random.nextBytes(seed2);
        return new BigInteger(seed2).abs();
    }

    public static RubyBignum randomSeed(Ruby runtime2) {
        return RubyBignum.newBignum(runtime2, RubyRandom.randomSeedBigInteger(runtime2.random));
    }

    public static RubyClass createRandomClass(Ruby runtime2) {
        RubyClass randomClass = runtime2.defineClass("Random", runtime2.getObject(), RubyRandom::new);
        randomClass.defineAnnotatedMethods(RubyRandom.class);
        RubyRandom defaultRand = new RubyRandom(runtime2, randomClass);
        defaultRand.random = new RandomType(RubyRandom.randomSeed(runtime2));
        randomClass.setConstant("DEFAULT", defaultRand);
        runtime2.setDefaultRand(defaultRand.random);
        return randomClass;
    }

    RubyRandom(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, optional=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.random = new RandomType(args2.length == 0 ? RubyRandom.randomSeed(context.runtime) : args2[0]);
        return this;
    }

    @JRubyMethod
    public IRubyObject seed(ThreadContext context) {
        return this.random.getSeed();
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject orig) {
        if (!(orig instanceof RubyRandom)) {
            throw this.getRuntime().newTypeError(String.format("wrong argument type %s (expected %s)", orig.getMetaClass().getName(), this.getMetaClass().getName()));
        }
        this.checkFrozen();
        this.random = new RandomType(((RubyRandom)orig).random);
        return this;
    }

    @JRubyMethod(name={"rand"}, meta=true)
    public static IRubyObject randDefault(ThreadContext context, IRubyObject recv2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        return RubyRandom.randFloat(context, random);
    }

    @JRubyMethod(name={"rand"}, meta=true)
    public static IRubyObject randDefault(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        return RubyRandom.randomRand(context, arg2, random);
    }

    static IRubyObject randKernel(ThreadContext context, IRubyObject arg2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        if (arg2 == context.nil) {
            return RubyRandom.randFloat(context, random);
        }
        if (arg2 instanceof RubyRange) {
            return RubyRandom.randomRand(context, arg2, random);
        }
        RubyInteger max2 = arg2.convertToInteger();
        if (max2.isZero()) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject r = RubyRandom.randInt(context, random, max2, false);
        return r == context.nil ? RubyRandom.randFloat(context, random) : r;
    }

    @Deprecated
    public IRubyObject randObj(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.rand(context) : this.rand(context, args2[0]);
    }

    @JRubyMethod(name={"rand"})
    public IRubyObject rand(ThreadContext context) {
        return RubyRandom.randFloat(context, this.random);
    }

    @JRubyMethod(name={"rand"})
    public IRubyObject rand(ThreadContext context, IRubyObject arg2) {
        return RubyRandom.randomRand(context, arg2, this.random);
    }

    private static IRubyObject randInt(ThreadContext context, RandomType random, RubyInteger vmax, boolean restrictive) {
        if (vmax instanceof RubyFixnum) {
            long max2 = RubyNumeric.fix2long(vmax);
            if (max2 == 0L) {
                return context.nil;
            }
            if (max2 < 0L) {
                if (restrictive) {
                    return context.nil;
                }
                max2 = -max2;
            }
            return RubyRandom.randLimitedFixnum(context, random, max2 - 1L);
        }
        BigInteger big = vmax.getBigIntegerValue();
        if (big.equals(BigInteger.ZERO)) {
            return context.nil;
        }
        if (big.signum() < 0) {
            if (restrictive) {
                return context.nil;
            }
            big = big.abs();
        }
        big = big.subtract(BigInteger.ONE);
        return RubyRandom.randLimitedBignum(context, random, big);
    }

    public static RubyFloat randFloat(ThreadContext context) {
        return RubyRandom.randFloat(context, RubyRandom.getDefaultRand(context));
    }

    public static RubyFloat randFloat(ThreadContext context, RandomType random) {
        return context.runtime.newFloat(random.genrandReal());
    }

    public static RubyInteger randLimited(ThreadContext context, long limit2) {
        return RubyRandom.randLimitedFixnum(context, RubyRandom.getDefaultRand(context), limit2);
    }

    private static RubyInteger randLimitedFixnum(ThreadContext context, RandomType random, long limit2) {
        return RubyFixnum.newFixnum(context.runtime, RubyRandom.randLimitedFixnumInner(random.impl, limit2));
    }

    public static long randLimitedFixnumInner(Random random, long limit2) {
        long val;
        if (limit2 == 0L) {
            val = 0L;
        } else {
            long mask = RubyRandom.makeMask(limit2);
            block0: while (true) {
                val = 0L;
                for (int i2 = 1; 0 <= i2; --i2) {
                    if ((mask >>> i2 * 32 & 0xFFFFFFFFL) != 0L) {
                        val |= ((long)random.genrandInt32() & 0xFFFFFFFFL) << i2 * 32;
                        val &= mask;
                    }
                    if (limit2 < val) continue block0;
                }
                break;
            }
        }
        return val;
    }

    public static RubyInteger randLimited(ThreadContext context, BigInteger limit2) {
        return RubyRandom.randLimitedBignum(context, RubyRandom.getDefaultRand(context), limit2);
    }

    private static RubyInteger randLimitedBignum(ThreadContext context, RandomType random, BigInteger limit2) {
        byte[] buf = limit2.toByteArray();
        byte[] bytes2 = new byte[buf.length];
        int len = (buf.length + 3) / 4;
        block0: while (true) {
            long mask = 0L;
            boolean boundary = true;
            for (int idx = len - 1; 0 <= idx; --idx) {
                long rnd;
                long lim = (long)RubyRandom.getIntBigIntegerBuffer(buf, idx) & 0xFFFFFFFFL;
                long l = mask = mask != 0L ? 0xFFFFFFFFL : RubyRandom.makeMask(lim);
                if (mask != 0L) {
                    rnd = (long)random.genrandInt32() & 0xFFFFFFFFL & mask;
                    if (boundary) {
                        if (lim < rnd) continue block0;
                        if (rnd < lim) {
                            boundary = false;
                        }
                    }
                } else {
                    rnd = 0L;
                }
                RubyRandom.setIntBigIntegerBuffer(bytes2, idx, (int)rnd);
            }
            break;
        }
        return RubyBignum.newBignum(context.runtime, new BigInteger(bytes2));
    }

    private static long makeMask(long x) {
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        x |= x >>> 32;
        return x;
    }

    private static RandomType getDefaultRand(ThreadContext context) {
        return context.runtime.defaultRand;
    }

    private static IRubyObject randomRand(ThreadContext context, IRubyObject vmax, RandomType random) {
        IRubyObject f;
        IRubyObject v;
        RangeLike range = null;
        IRubyObject nil = context.nil;
        if (vmax == nil) {
            v = nil;
        } else {
            v = RubyRandom.checkMaxInt(context, vmax);
            if (v != null) {
                v = RubyRandom.randInt(context, random, (RubyInteger)v, true);
            } else {
                v = TypeConverter.checkFloatType(context.runtime, vmax);
                if (v != nil) {
                    double max2 = ((RubyFloat)v).value;
                    v = max2 > 0.0 ? context.runtime.newFloat(max2 * random.genrandReal()) : nil;
                } else {
                    range = RubyRandom.rangeValues(context, vmax);
                    if (range != null) {
                        v = RubyRandom.checkMaxInt(context, range.range);
                        if (v != null) {
                            if (v instanceof RubyFixnum) {
                                long max3 = ((RubyFixnum)v).value;
                                if (range.excl) {
                                    --max3;
                                }
                                v = max3 >= 0L ? RubyRandom.randLimitedFixnum(context, random, max3) : nil;
                            } else if (v instanceof RubyBignum) {
                                BigInteger big = ((RubyBignum)v).value;
                                if (big.signum() > 0) {
                                    if (range.excl) {
                                        big = big.subtract(BigInteger.ONE);
                                    }
                                    v = RubyRandom.randLimitedBignum(context, random, big);
                                } else {
                                    v = nil;
                                }
                            } else {
                                v = nil;
                            }
                        } else {
                            v = TypeConverter.checkFloatType(context.runtime, range.range);
                            if (v != nil) {
                                int scale = 1;
                                double max4 = ((RubyFloat)v).value;
                                double mid = 0.5;
                                if (Double.isInfinite(max4)) {
                                    double min2 = RubyRandom.floatValue(context, TypeConverter.toFloat(context.runtime, range.begin)) / 2.0;
                                    max4 = RubyRandom.floatValue(context, TypeConverter.toFloat(context.runtime, range.end)) / 2.0;
                                    scale = 2;
                                    mid = max4 + min2;
                                    max4 -= min2;
                                } else {
                                    RubyRandom.checkFloatValue(context, max4);
                                }
                                v = context.nil;
                                if (max4 > 0.0) {
                                    double r = range.excl ? random.genrandReal() : random.genrandReal2();
                                    if (scale > 1) {
                                        return context.runtime.newFloat((r - 0.5) * max4 * (double)scale + mid);
                                    }
                                    v = context.runtime.newFloat(r * max4);
                                } else if (max4 == 0.0 && !range.excl) {
                                    v = context.runtime.newFloat(0.0);
                                }
                            }
                        }
                    } else {
                        v = nil;
                        RubyNumeric.num2long(vmax);
                    }
                }
            }
        }
        if (v == nil) {
            throw context.runtime.newArgumentError("invalid argument - " + vmax);
        }
        if (range == null) {
            return v;
        }
        if (range.begin instanceof RubyFixnum && v instanceof RubyFixnum) {
            long x = ((RubyFixnum)range.begin).getLongValue() + ((RubyFixnum)v).getLongValue();
            return context.runtime.newFixnum(x);
        }
        if (v instanceof RubyBignum) {
            return ((RubyBignum)v).op_plus(context, range.begin);
        }
        if (v instanceof RubyFloat && (f = TypeConverter.checkFloatType(context.runtime, range.begin)) != nil) {
            return ((RubyFloat)v).op_plus(context, f);
        }
        return Helpers.invoke(context, range.begin, "+", v);
    }

    private static double floatValue(ThreadContext context, RubyFloat v) {
        double x = v.value;
        RubyRandom.checkFloatValue(context, x);
        return x;
    }

    private static void checkFloatValue(ThreadContext context, double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw context.runtime.newErrnoEDOMError("Numerical argument out of domain");
        }
    }

    private static IRubyObject checkMaxInt(ThreadContext context, IRubyObject vmax) {
        IRubyObject v;
        if (!(vmax instanceof RubyFloat) && (v = TypeConverter.checkIntegerType(context, vmax)) != context.nil) {
            return v;
        }
        return null;
    }

    private static RangeLike rangeValues(ThreadContext context, IRubyObject range) {
        RangeLike like = new RangeLike();
        if (range instanceof RubyRange) {
            RubyRange vrange = (RubyRange)range;
            like.begin = vrange.first(context);
            like.end = vrange.last(context);
            like.excl = vrange.isExcludeEnd();
        } else {
            if (!(range.respondsTo("begin") && range.respondsTo("end") && range.respondsTo("exclude_end?"))) {
                return null;
            }
            like.begin = Helpers.invoke(context, range, "begin");
            like.end = Helpers.invoke(context, range, "end");
            like.excl = Helpers.invoke(context, range, "exclude_end?").isTrue();
        }
        like.range = Helpers.invoke(context, like.end, "-", like.begin);
        return like;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srandCommon(context, recv2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2, IRubyObject seed2) {
        return RubyRandom.srandCommon(context, recv2, seed2);
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srandCommon(context, recv2, RubyRandom.randomSeed(context.runtime));
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv2, IRubyObject newSeed2) {
        RandomType defaultRand = RubyRandom.getDefaultRand(context);
        RubyInteger previousSeed = defaultRand.getSeed();
        defaultRand = new RandomType(newSeed2);
        context.runtime.setDefaultRand(defaultRand);
        ((RubyRandom)context.runtime.getRandomClass().getConstant("DEFAULT")).setRandomType(defaultRand);
        return previousSeed;
    }

    @Override
    @Deprecated
    public IRubyObject op_equal_19(ThreadContext context, IRubyObject obj) {
        return this.op_equal(context, obj);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        if (!this.getType().equals(obj.getType())) {
            return context.fals;
        }
        return RubyBoolean.newBoolean(context, this.random.equals(((RubyRandom)obj).random));
    }

    @JRubyMethod(name={"state"}, visibility=Visibility.PRIVATE)
    public IRubyObject stateObj(ThreadContext context) {
        return this.random.getState();
    }

    @JRubyMethod(name={"left"}, visibility=Visibility.PRIVATE)
    public IRubyObject leftObj(ThreadContext context) {
        return RubyNumeric.int2fix(context.runtime, this.random.getLeft());
    }

    @JRubyMethod(name={"state"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject state(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.getDefaultRand(context).getState();
    }

    @JRubyMethod(name={"left"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject left(ThreadContext context, IRubyObject recv2) {
        return RubyNumeric.int2fix(context.runtime, RubyRandom.getDefaultRand(context).getLeft());
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyBignum state2 = this.random.getState();
        RubyFixnum left2 = RubyFixnum.newFixnum(context.runtime, this.random.getLeft());
        RubyArray dump2 = RubyArray.newArray(context.runtime, state2, left2, this.random.getSeed());
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        if (load2.size() != 3) {
            throw context.runtime.newArgumentError("wrong dump data");
        }
        if (!(load2.eltInternal(0) instanceof RubyBignum)) {
            throw context.runtime.newTypeError((IRubyObject)load2.eltInternal(0), context.runtime.getBignum());
        }
        RubyBignum state2 = (RubyBignum)load2.eltInternal(0);
        int left2 = RubyNumeric.num2int(load2.eltInternal(1));
        Object seed2 = load2.eltInternal(2);
        this.random = new RandomType((IRubyObject)seed2, state2, left2);
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        return this;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject bytes(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyRandom.bytesCommon(context, RubyRandom.getDefaultRand(context), arg2);
    }

    @JRubyMethod(name={"bytes"})
    public IRubyObject bytes(ThreadContext context, IRubyObject arg2) {
        return RubyRandom.bytesCommon(context, this.random, arg2);
    }

    private static IRubyObject bytesCommon(ThreadContext context, RandomType random, IRubyObject arg2) {
        int i2;
        int r;
        int n;
        byte[] bytes2 = new byte[n];
        int idx = 0;
        for (n = RubyNumeric.num2int(arg2); n >= 4; n -= 4) {
            r = random.genrandInt32();
            for (i2 = 0; i2 < 4; ++i2) {
                bytes2[idx++] = (byte)(r & 0xFF);
                r >>>= 8;
            }
        }
        if (n > 0) {
            r = random.genrandInt32();
            for (i2 = 0; i2 < n; ++i2) {
                bytes2[idx++] = (byte)(r & 0xFF);
                r >>>= 8;
            }
        }
        return context.runtime.newString(new ByteList(bytes2));
    }

    private static RandomType tryGetRandomType(ThreadContext context, IRubyObject obj) {
        if (obj.equals(context.runtime.getRandomClass())) {
            return RubyRandom.getDefaultRand(context);
        }
        if (obj instanceof RubyRandom) {
            return ((RubyRandom)obj).random;
        }
        return null;
    }

    public static long randomLongLimited(ThreadContext context, IRubyObject obj, long limit2) {
        RandomType rnd = RubyRandom.tryGetRandomType(context, obj);
        if (rnd == null) {
            RubyInteger v = Helpers.invokePublic(context, obj, "rand", context.runtime.newFixnum(limit2 + 1L)).convertToInteger();
            long r = RubyNumeric.num2long(v);
            if (r < 0L) {
                throw context.runtime.newRangeError("random number too small " + r);
            }
            if (r > limit2) {
                throw context.runtime.newRangeError("random number too big " + r);
            }
            return r;
        }
        return RubyRandom.randLimitedFixnumInner(rnd.impl, limit2);
    }

    public static double randomReal(ThreadContext context, IRubyObject obj) {
        RandomType random = RubyRandom.tryGetRandomType(context, obj);
        if (random != null) {
            return random.genrandReal();
        }
        double d = RubyNumeric.num2dbl(context, Helpers.invoke(context, obj, "rand"));
        if (d < 0.0 || d >= 1.0) {
            throw context.runtime.newRangeError("random number too big: " + d);
        }
        return d;
    }

    @JRubyMethod(name={"new_seed"}, meta=true)
    public static IRubyObject newSeed(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.randomSeed(context.runtime);
    }

    @JRubyMethod(name={"urandom"}, meta=true)
    public static IRubyObject urandom(ThreadContext context, IRubyObject recv2, IRubyObject num) {
        Ruby runtime2 = context.runtime;
        int n = num.convertToInteger().getIntValue();
        if (n < 0) {
            throw runtime2.newArgumentError("negative string size (or size too big)");
        }
        if (n == 0) {
            return runtime2.newString();
        }
        byte[] seed2 = new byte[n];
        runtime2.random.nextBytes(seed2);
        return RubyString.newString(runtime2, seed2);
    }

    private void setRandomType(RandomType random) {
        this.random = random;
    }

    @Deprecated
    public static IRubyObject randCommon19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyRandom.randKernel(context, args2);
    }

    @Deprecated
    static IRubyObject randKernel(ThreadContext context, IRubyObject[] args2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        if (args2.length == 0) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject arg2 = args2[0];
        return RubyRandom.randKernel(context, arg2);
    }

    @Deprecated
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return RubyRandom.randDefault(context, recv2);
            }
            case 1: {
                return RubyRandom.randDefault(context, recv2, args2[0]);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0, 1);
    }

    static class RangeLike {
        public IRubyObject begin = null;
        public IRubyObject end = null;
        boolean excl = false;
        public IRubyObject range = null;

        RangeLike() {
        }
    }

    public static final class RandomType {
        private final RubyInteger seed;
        private final Random impl;

        RandomType(IRubyObject seed2) {
            this.seed = seed2.convertToInteger();
            if (this.seed instanceof RubyFixnum) {
                this.impl = RandomType.randomFromFixnum((RubyFixnum)this.seed);
            } else if (this.seed instanceof RubyBignum) {
                this.impl = RandomType.randomFromBignum((RubyBignum)this.seed);
            } else {
                throw seed2.getRuntime().newTypeError(String.format("failed to convert %s into Integer", seed2.getMetaClass().getName()));
            }
        }

        public static Random randomFromFixnum(RubyFixnum seed2) {
            return RandomType.randomFromLong(RubyNumeric.num2long(seed2));
        }

        public static Random randomFromLong(long seed2) {
            long v = Math.abs(seed2);
            if (v == (v & 0xFFFFFFFFL)) {
                return new Random((int)v);
            }
            int[] ints = new int[]{(int)v, (int)(v >> 32)};
            return new Random(ints);
        }

        public static Random randomFromBignum(RubyBignum seed2) {
            BigInteger big = seed2.getBigIntegerValue();
            return RandomType.randomFromBigInteger(big);
        }

        public static Random randomFromBigInteger(BigInteger big) {
            if (big.signum() < 0) {
                big = big.abs();
            }
            byte[] buf = big.toByteArray();
            int buflen = buf.length;
            if (buf[0] == 0) {
                --buflen;
            }
            int len = Math.min((buflen + 3) / 4, 624);
            int[] ints = RandomType.bigEndianToInts(buf, len);
            if (len <= 1) {
                return new Random(ints[0]);
            }
            return new Random(ints);
        }

        RandomType(IRubyObject vseed, RubyBignum state2, int left2) {
            this.seed = vseed.convertToInteger();
            byte[] bytes2 = state2.getBigIntegerValue().toByteArray();
            int[] ints = new int[bytes2.length / 4];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                ints[i2] = RubyRandom.getIntBigIntegerBuffer(bytes2, i2);
            }
            this.impl = new Random(ints, left2);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RandomType)) {
                return false;
            }
            RandomType rhs = (RandomType)obj;
            return this.seed.op_equal(this.seed.getRuntime().getCurrentContext(), rhs.seed).isTrue() && this.impl.equals(rhs.impl);
        }

        public int hashCode() {
            return (629 + this.seed.hashCode()) * 37 + this.impl.hashCode();
        }

        RandomType(RandomType orig) {
            this.seed = orig.seed;
            this.impl = new Random(orig.impl);
        }

        int genrandInt32() {
            return this.impl.genrandInt32();
        }

        double genrandReal() {
            return this.impl.genrandReal();
        }

        double genrandReal2() {
            return this.impl.genrandReal2();
        }

        RubyInteger getSeed() {
            return this.seed;
        }

        RubyBignum getState() {
            int[] ints = this.impl.getState();
            byte[] bytes2 = new byte[ints.length * 4];
            for (int idx = 0; idx < ints.length; ++idx) {
                RubyRandom.setIntBigIntegerBuffer(bytes2, idx, ints[idx]);
            }
            return RubyBignum.newBignum(this.seed.getRuntime(), new BigInteger(bytes2));
        }

        int getLeft() {
            return this.impl.getLeft();
        }

        private static int[] bigEndianToInts(byte[] buf, int initKeyLen) {
            int[] initKey = new int[initKeyLen];
            for (int idx = 0; idx < initKey.length; ++idx) {
                initKey[idx] = RubyRandom.getIntBigIntegerBuffer(buf, idx);
            }
            return initKey;
        }
    }
}

