// third_party/blink/public/mojom/payments/payment_credential.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/payment_credential.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/payments/payment_credential.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/payment_credential.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/payment_credential.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_BLINK_JUMBO_H_
#endif
namespace payments {
namespace mojom {
namespace blink {
PaymentCredentialInstrument::PaymentCredentialInstrument()
    : display_name(),
      icon() {}

PaymentCredentialInstrument::PaymentCredentialInstrument(
    const WTF::String& display_name_in,
    const ::blink::KURL& icon_in)
    : display_name(std::move(display_name_in)),
      icon(std::move(icon_in)) {}

PaymentCredentialInstrument::~PaymentCredentialInstrument() = default;

void PaymentCredentialInstrument::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("display_name", this->display_name.Utf8());
  value->SetString("icon", base::trace_event::ValueToString(this->icon, "<value of type const ::blink::KURL&>"));
}

bool PaymentCredentialInstrument::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaymentCredential::Name_[] = "payments.mojom.PaymentCredential";

class PaymentCredential_StorePaymentCredential_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentCredential_StorePaymentCredential_ForwardToCallback(
      PaymentCredential::StorePaymentCredentialCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentCredential::StorePaymentCredentialCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentCredential_StorePaymentCredential_ForwardToCallback);
};

PaymentCredentialProxy::PaymentCredentialProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentCredentialProxy::StorePaymentCredential(
    PaymentCredentialInstrumentPtr in_instrument, const WTF::Vector<uint8_t>& in_credential_id, const WTF::String& in_rp_id, StorePaymentCredentialCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentCredential::StorePaymentCredential", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_instrument.is_null()) {
        raw_value->SetString("instrument", "nullptr");
      } else {
        raw_value->BeginDictionary("instrument");
        in_instrument->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->BeginArray("credential_id");
      for (const auto& item0 : in_credential_id) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      raw_value->SetString("rp_id", in_rp_id.Utf8());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentCredential_StorePaymentCredential_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentCredential_StorePaymentCredential_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->instrument)::BaseType::BufferWriter
      instrument_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentCredentialInstrumentDataView>(
      in_instrument, buffer, &instrument_writer, &serialization_context);
  params->instrument.Set(
      instrument_writer.is_null() ? nullptr : instrument_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument in PaymentCredential.StorePaymentCredential request");
  typename decltype(params->credential_id)::BaseType::BufferWriter
      credential_id_writer;
  const mojo::internal::ContainerValidateParams credential_id_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_credential_id, buffer, &credential_id_writer, &credential_id_validate_params,
      &serialization_context);
  params->credential_id.Set(
      credential_id_writer.is_null() ? nullptr : credential_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->credential_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credential_id in PaymentCredential.StorePaymentCredential request");
  typename decltype(params->rp_id)::BaseType::BufferWriter
      rp_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_rp_id, buffer, &rp_id_writer, &serialization_context);
  params->rp_id.Set(
      rp_id_writer.is_null() ? nullptr : rp_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rp_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rp_id in PaymentCredential.StorePaymentCredential request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentCredential::Name_);
  message.set_method_name("StorePaymentCredential");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentCredential_StorePaymentCredential_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PaymentCredential_StorePaymentCredential_ProxyToResponder {
 public:
  static PaymentCredential::StorePaymentCredentialCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentCredential_StorePaymentCredential_ProxyToResponder> proxy(
        new PaymentCredential_StorePaymentCredential_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentCredential_StorePaymentCredential_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentCredential_StorePaymentCredential_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentCredential_StorePaymentCredential_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentCredential::StorePaymentCredentialCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentCredentialCreationStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentCredential_StorePaymentCredential_ProxyToResponder);
};

bool PaymentCredential_StorePaymentCredential_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentCredential::StorePaymentCredentialCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PaymentCredential_StorePaymentCredential_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentCredential_StorePaymentCredential_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PaymentCredentialCreationStatus p_status{};
  PaymentCredential_StorePaymentCredential_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentCredential::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PaymentCredential_StorePaymentCredential_ProxyToResponder::Run(
    PaymentCredentialCreationStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentCredential::StorePaymentCredentialCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentCredential_StorePaymentCredential_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentCredential_StorePaymentCredential_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::payments::mojom::PaymentCredentialCreationStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentCredential::StorePaymentCredentialCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentCredential::Name_);
  message.set_method_name("StorePaymentCredential");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaymentCredentialStubDispatch::Accept(
    PaymentCredential* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPaymentCredential_StorePaymentCredential_Name: {
      break;
    }
  }
  return false;
}

// static
bool PaymentCredentialStubDispatch::AcceptWithResponder(
    PaymentCredential* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentCredential_StorePaymentCredential_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentCredential::StorePaymentCredential",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentCredential::StorePaymentCredential");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentCredential_StorePaymentCredential_Params_Data* params =
          reinterpret_cast<
              internal::PaymentCredential_StorePaymentCredential_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaymentCredentialInstrumentPtr p_instrument{};
      WTF::Vector<uint8_t> p_credential_id{};
      WTF::String p_rp_id{};
      PaymentCredential_StorePaymentCredential_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadInstrument(&p_instrument))
        success = false;
      if (success && !input_data_view.ReadCredentialId(&p_credential_id))
        success = false;
      if (success && !input_data_view.ReadRpId(&p_rp_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentCredential::Name_, 0, false);
        return false;
      }
      PaymentCredential::StorePaymentCredentialCallback callback =
          PaymentCredential_StorePaymentCredential_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StorePaymentCredential(
std::move(p_instrument), 
std::move(p_credential_id), 
std::move(p_rp_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentCredentialValidationInfo[] = {
    {&internal::PaymentCredential_StorePaymentCredential_Params_Data::Validate,
     &internal::PaymentCredential_StorePaymentCredential_ResponseParams_Data::Validate},
};

bool PaymentCredentialRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::PaymentCredential::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentCredentialValidationInfo);
}

bool PaymentCredentialResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::PaymentCredential::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPaymentCredentialValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace payments

namespace mojo {


// static
bool StructTraits<::payments::mojom::blink::PaymentCredentialInstrument::DataView, ::payments::mojom::blink::PaymentCredentialInstrumentPtr>::Read(
    ::payments::mojom::blink::PaymentCredentialInstrument::DataView input,
    ::payments::mojom::blink::PaymentCredentialInstrumentPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentCredentialInstrumentPtr result(::payments::mojom::blink::PaymentCredentialInstrument::New());
  
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif