/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.util.Pack;

class BIKERandomGenerator {
    BIKERandomGenerator() {
    }

    private static int bitScanReverse(int n) {
        int n2 = 0;
        while (n != 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    private static int GetRandomInMod(int n, Xof xof) {
        int n2 = BIKERandomGenerator.maskNumber(BIKERandomGenerator.bitScanReverse(n));
        int n3 = -1;
        do {
            n3 = BIKERandomGenerator.getRandomNumber(xof);
        } while ((n3 &= n2) >= n);
        return n3;
    }

    private static void generateRandomArray(byte[] byArray, int n, int n2, Xof xof) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = BIKERandomGenerator.GetRandomInMod(n, xof);
            if (BIKERandomGenerator.checkBit(byArray, n4) != 0) continue;
            BIKERandomGenerator.setBit(byArray, n4);
            ++n3;
        }
    }

    private static int checkBit(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        return byArray[n2] >> n3 & 1;
    }

    private static void setBit(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = n2;
        byArray[n4] = (byte)(byArray[n4] | 1 << n3);
    }

    static byte[] generateRandomByteArray(int n, int n2, int n3, Xof xof) {
        byte[] byArray = new byte[n2];
        BIKERandomGenerator.generateRandomArray(byArray, n, n3, xof);
        return byArray;
    }

    private static int maskNumber(int n) {
        return (1 << n) - 1;
    }

    private static int getRandomNumber(Xof xof) {
        byte[] byArray = new byte[4];
        xof.doOutput(byArray, 0, byArray.length);
        int n = Pack.littleEndianToInt(byArray, 0);
        return n;
    }
}

