info = {
    "name": "cs",
    "date_order": "DMY",
    "january": [
        "led",
        "leden",
        "ledna"
    ],
    "february": [
        "úno",
        "únor",
        "února"
    ],
    "march": [
        "bře",
        "březen",
        "března"
    ],
    "april": [
        "dub",
        "duben",
        "dubna"
    ],
    "may": [
        "kvě",
        "květen",
        "května"
    ],
    "june": [
        "červen",
        "června",
        "čvn",
        "Čer"
    ],
    "july": [
        "července",
        "červenec",
        "čvc",
        "Črc"
    ],
    "august": [
        "srp",
        "srpen",
        "srpna"
    ],
    "september": [
        "zář",
        "září"
    ],
    "october": [
        "říj",
        "říjen",
        "října"
    ],
    "november": [
        "lis",
        "listopad",
        "listopadu"
    ],
    "december": [
        "pro",
        "prosince",
        "prosinec"
    ],
    "monday": [
        "po",
        "pondělí",
        "Pon"
    ],
    "tuesday": [
        "út",
        "úterý",
        "Úte"
    ],
    "wednesday": [
        "st",
        "středa",
        "Stř",
        "Středu"
    ],
    "thursday": [
        "čt",
        "čtvrtek",
        "Čtv"
    ],
    "friday": [
        "pá",
        "pátek",
        "Pát"
    ],
    "saturday": [
        "so",
        "sobota",
        "Sob",
        "Sobotu"
    ],
    "sunday": [
        "ne",
        "neděle",
        "Ned",
        "Neděli"
    ],
    "am": [
        "dop"
    ],
    "pm": [
        "odp"
    ],
    "year": [
        "r",
        "rok",
        "roků",
        "roky"
    ],
    "month": [
        "měs",
        "měsíc",
        "měsíců",
        "měsíce"
    ],
    "week": [
        "týd",
        "týden",
        "týdnů",
        "týdny"
    ],
    "day": [
        "den",
        "dnů",
        "dny"
    ],
    "hour": [
        "h",
        "hodina",
        "hodin",
        "hodiny",
        "hodinu",
        "hodinami"
    ],
    "minute": [
        "min",
        "minuta",
        "minut",
        "minuty"
    ],
    "second": [
        "s",
        "sekunda",
        "sekundy",
        "sekund",
        "vteřina",
        "vteřin",
        "vteřiny"
    ],
    "relative-type": {
        "0 day ago": [
            "dnes"
        ],
        "0 hour ago": [
            "tuto hodinu"
        ],
        "0 minute ago": [
            "tuto minutu"
        ],
        "0 month ago": [
            "tento měsíc"
        ],
        "0 second ago": [
            "nyní"
        ],
        "0 week ago": [
            "tento týd",
            "tento týden"
        ],
        "0 year ago": [
            "tento rok"
        ],
        "1 day ago": [
            "včera"
        ],
        "1 month ago": [
            "minulý měsíc"
        ],
        "1 week ago": [
            "minulý týd",
            "minulý týden"
        ],
        "1 year ago": [
            "minulý rok"
        ],
        "in 1 day": [
            "zítra"
        ],
        "in 1 month": [
            "příští měsíc"
        ],
        "in 1 week": [
            "příští týd",
            "příští týden"
        ],
        "in 1 year": [
            "příští rok"
        ],
        "2 day ago": [
            "předevčírem"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "před (\\d+) dnem",
            "před (\\d+) dny"
        ],
        "\\1 hour ago": [
            "před (\\d+) h",
            "před (\\d+) hodinami",
            "před (\\d+) hodinou"
        ],
        "\\1 minute ago": [
            "před (\\d+) min",
            "před (\\d+) minutami",
            "před (\\d+) minutou"
        ],
        "\\1 month ago": [
            "před (\\d+) měs",
            "před (\\d+) měsícem",
            "před (\\d+) měsíci"
        ],
        "\\1 second ago": [
            "před (\\d+) s",
            "před (\\d+) sekundami",
            "před (\\d+) sekundou"
        ],
        "\\1 week ago": [
            "před (\\d+) týd",
            "před (\\d+) týdnem",
            "před (\\d+) týdny"
        ],
        "\\1 year ago": [
            "před (\\d+) l",
            "před (\\d+) lety",
            "před (\\d+) r",
            "před (\\d+) rokem"
        ],
        "in \\1 day": [
            "za (\\d+) den",
            "za (\\d+) dní"
        ],
        "in \\1 hour": [
            "za (\\d+) h",
            "za (\\d+) hodin",
            "za (\\d+) hodinu"
        ],
        "in \\1 minute": [
            "za (\\d+) min",
            "za (\\d+) minut",
            "za (\\d+) minutu"
        ],
        "in \\1 month": [
            "za (\\d+) měs",
            "za (\\d+) měsíc",
            "za (\\d+) měsíců"
        ],
        "in \\1 second": [
            "za (\\d+) s",
            "za (\\d+) sekund",
            "za (\\d+) sekundu"
        ],
        "in \\1 week": [
            "za (\\d+) týd",
            "za (\\d+) týden",
            "za (\\d+) týdnů"
        ],
        "in \\1 year": [
            "za (\\d+) l",
            "za (\\d+) let",
            "za (\\d+) r",
            "za (\\d+) rok"
        ]
    },
    "locale_specific": {},
    "skip": [
        "přibližně",
        "v",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "před"
    ],
    "in": [
        "ve",
        "v"
    ]
}
