/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.SymbolScaleFactor;
import tim.prune.gui.BaseImageDefinitionPanel;
import tim.prune.gui.DecimalNumberField;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.TerrainDefinitionPanel;
import tim.prune.threedee.TerrainDefinition;
import tim.prune.threedee.ThreeDException;
import tim.prune.threedee.ThreeDWindow;
import tim.prune.threedee.WindowFactory;

public class ShowThreeDFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private DecimalNumberField _exaggField = null;
    private DecimalNumberField _symbolScaleField = null;
    private BaseImageDefinitionPanel _baseImagePanel = null;
    private TerrainDefinitionPanel _terrainPanel = null;

    public ShowThreeDFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.show3d";
    }

    @Override
    public void begin() {
        ThreeDWindow threeDWindow = WindowFactory.getWindow(this._parentFrame);
        if (threeDWindow == null) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("error.function.nojava3d"), I18nManager.getText("error.function.notavailable.title"), 2);
        } else {
            int n;
            if (!this._app.getTrackInfo().getTrack().hasAltitudeData()) {
                this._app.showTip(3);
            }
            if (this._dialog == null) {
                this._dialog = new JDialog(this._app.getFrame(), I18nManager.getText(this.getNameKey()), true);
                this._dialog.setDefaultCloseOperation(2);
                this._dialog.getContentPane().add(this.makeDialogComponents());
                this._dialog.pack();
            }
            if ((n = Config.getConfigInt("prune.heightexaggeration")) > 0) {
                this._exaggField.setValue((double)n / 100.0);
            }
            this._baseImagePanel.updateBaseImageDetails();
            this._dialog.setLocationRelativeTo(this._app.getFrame());
            this._dialog.setVisible(true);
        }
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 4));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel3 = new JPanel();
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel3, new double[]{3.0, 1.0}, blArray);
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.3d.altitudefactor")) + ": ");
        jLabel.setHorizontalAlignment(11);
        guiGridLayout.add(jLabel);
        this._exaggField = new DecimalNumberField();
        this._exaggField.setText("5.0");
        guiGridLayout.add(this._exaggField);
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("dialog.3d.symbolscalefactor")) + ": ");
        jLabel2.setHorizontalAlignment(11);
        guiGridLayout.add(jLabel2);
        this._symbolScaleField = new DecimalNumberField();
        this._symbolScaleField.setText("1.0");
        guiGridLayout.add(this._symbolScaleField);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(4));
        this._terrainPanel = new TerrainDefinitionPanel();
        jPanel2.add(this._terrainPanel);
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add(Box.createVerticalStrut(4));
        this._baseImagePanel = new BaseImageDefinitionPanel(null, this._dialog, this._app.getTrackInfo().getTrack());
        jPanel2.add(this._baseImagePanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionEvent -> {
            this._dialog.dispose();
            new Thread(() -> this.finish()).start();
        });
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void finish() {
        Config.setConfigInt("prune.heightexaggeration", (int)(this._exaggField.getValue() * 100.0));
        int n = this._terrainPanel.getGridSize();
        if (n < 20) {
            n = 20;
        }
        Config.setConfigInt("prune.terraingridsize", n);
        ThreeDWindow threeDWindow = WindowFactory.getWindow(this._parentFrame);
        if (threeDWindow != null) {
            try {
                threeDWindow.setTrack(this._app.getTrackInfo().getTrack());
                threeDWindow.setAltitudeFactor(this._exaggField.getValue());
                if (this._symbolScaleField.isEmpty()) {
                    this._symbolScaleField.setValue(1.0);
                }
                threeDWindow.setSymbolScalingFactor(SymbolScaleFactor.validateFactor(this._symbolScaleField.getValue()));
                threeDWindow.setBaseImageParameters(this._baseImagePanel.getImageDefinition());
                threeDWindow.setTerrainParameters(new TerrainDefinition(this._terrainPanel.getUseTerrain(), this._terrainPanel.getGridSize()));
                threeDWindow.setDataStatus(this._app.getCurrentDataStatus());
                threeDWindow.show();
            }
            catch (ThreeDException threeDException) {
                this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(I18nManager.getText("error.3d")) + ": " + threeDException.getMessage());
            }
        }
    }
}

