/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.WholeNumberField;

public class SetDisplaySettings
extends GenericFunction {
    private JDialog _dialog = null;
    private WholeNumberField _lineWidthField = null;
    private JCheckBox _antialiasCheckbox = null;
    private JCheckBox _osScalingCheckbox = null;
    private JRadioButton[] _windowStyleRadios = null;
    private static final String STYLEKEY_NIMBUS = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
    private static final String STYLEKEY_GTK = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";

    public SetDisplaySettings(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.setdisplaysettings";
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel3);
        guiGridLayout.setYPadding(8);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.displaysettings.linewidth"));
        guiGridLayout.add(jLabel);
        this._lineWidthField = new WholeNumberField(1);
        guiGridLayout.add(this._lineWidthField);
        this._antialiasCheckbox = new JCheckBox(I18nManager.getText("dialog.displaysettings.antialias"), false);
        guiGridLayout.add(this._antialiasCheckbox);
        guiGridLayout.add(new JLabel(""));
        this._osScalingCheckbox = new JCheckBox(I18nManager.getText("dialog.displaysettings.allowosscaling"), false);
        guiGridLayout.add(this._osScalingCheckbox);
        guiGridLayout.add(new JLabel(""));
        jPanel3.setAlignmentX(0.5f);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(15));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jPanel4.setLayout(new FlowLayout(1));
        jPanel4.add(new JLabel(I18nManager.getText("dialog.displaysettings.windowstyle")));
        jPanel4.add(Box.createHorizontalStrut(10));
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = new String[]{"default", "nimbus", "gtk"};
        this._windowStyleRadios = new JRadioButton[3];
        int n = 0;
        while (n < 3) {
            this._windowStyleRadios[n] = new JRadioButton(I18nManager.getText("dialog.displaysettings.windowstyle." + stringArray[n]));
            buttonGroup.add(this._windowStyleRadios[n]);
            if (n != 2 || SetDisplaySettings.platformHasPlaf(STYLEKEY_GTK)) {
                jPanel4.add(this._windowStyleRadios[n]);
            }
            ++n;
        }
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionEvent -> this.finish());
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel5.add(jButton2);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private static boolean platformHasPlaf(String string) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n2];
            if (lookAndFeelInfo.getClassName().equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void begin() {
        int n;
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, I18nManager.getText(this.getNameKey()));
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        if ((n = Config.getConfigInt("prune.linewidth")) < 1 || n > 4) {
            n = 2;
        }
        this._lineWidthField.setValue(n);
        this._antialiasCheckbox.setSelected(Config.getConfigBoolean("prune.antialias"));
        this._osScalingCheckbox.setSelected(Config.getConfigBoolean("prune.osscaling"));
        this.selectWindowStyleRadio(Config.getConfigString("prune.windowstyle"));
        this._dialog.setVisible(true);
    }

    private void selectWindowStyleRadio(String string) {
        int n = 0;
        if (string != null && string.equals(STYLEKEY_NIMBUS)) {
            n = 1;
        } else if (string != null && string.equals(STYLEKEY_GTK) && this._windowStyleRadios[2] != null) {
            n = 2;
        }
        this._windowStyleRadios[n].setSelected(true);
    }

    private String getSelectedStyleString() {
        if (this._windowStyleRadios[1].isSelected()) {
            return STYLEKEY_NIMBUS;
        }
        if (this._windowStyleRadios[2] != null && this._windowStyleRadios[2].isSelected()) {
            return STYLEKEY_GTK;
        }
        return null;
    }

    public void finish() {
        int n = this._lineWidthField.getValue();
        if (n < 1 || n > 4) {
            n = 2;
        }
        Config.setConfigInt("prune.linewidth", n);
        Config.setConfigBoolean("prune.antialias", this._antialiasCheckbox.isSelected());
        Config.setConfigBoolean("prune.osscaling", this._osScalingCheckbox.isSelected());
        Config.setConfigString("prune.windowstyle", this.getSelectedStyleString());
        UpdateMessageBroker.informSubscribers((byte)64);
        this._dialog.dispose();
    }
}

