/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "mm-gdbus-modem.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Firmware
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemFirmware
 * @title: MmGdbusModemFirmware
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Firmware D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Firmware.top_of_page">org.freedesktop.ModemManager1.Modem.Firmware</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Firmware ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_firmware_method_info_list_OUT_ARG_selected =
{
  {
    -1,
    (gchar *) "selected",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_firmware_method_info_list_OUT_ARG_installed =
{
  {
    -1,
    (gchar *) "installed",
    (gchar *) "aa{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_firmware_method_info_list_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_firmware_method_info_list_OUT_ARG_selected.parent_struct,
  &_mm_gdbus_modem_firmware_method_info_list_OUT_ARG_installed.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_firmware_method_info_list =
{
  {
    -1,
    (gchar *) "List",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_firmware_method_info_list_OUT_ARG_pointers,
    NULL
  },
  "handle-list",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_firmware_method_info_select_IN_ARG_uniqueid =
{
  {
    -1,
    (gchar *) "uniqueid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_firmware_method_info_select_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_firmware_method_info_select_IN_ARG_uniqueid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_firmware_method_info_select =
{
  {
    -1,
    (gchar *) "Select",
    (GDBusArgInfo **) &_mm_gdbus_modem_firmware_method_info_select_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-select",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_firmware_method_info_pointers[] =
{
  &_mm_gdbus_modem_firmware_method_info_list.parent_struct,
  &_mm_gdbus_modem_firmware_method_info_select.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_firmware_property_info_update_settings =
{
  {
    -1,
    (gchar *) "UpdateSettings",
    (gchar *) "(ua{sv})",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "update-settings",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_firmware_property_info_pointers[] =
{
  &_mm_gdbus_modem_firmware_property_info_update_settings.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_firmware_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Firmware",
    (GDBusMethodInfo **) &_mm_gdbus_modem_firmware_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_firmware_property_info_pointers,
    NULL
  },
  "modem-firmware",
};


/**
 * mm_gdbus_modem_firmware_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Firmware.top_of_page">org.freedesktop.ModemManager1.Modem.Firmware</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_firmware_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_firmware_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_firmware_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemFirmware interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_firmware_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "update-settings");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemFirmware:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Firmware.top_of_page">org.freedesktop.ModemManager1.Modem.Firmware</link>.
 */

/**
 * MmGdbusModemFirmwareIface:
 * @parent_iface: The parent interface.
 * @handle_list: Handler for the #MmGdbusModemFirmware::handle-list signal.
 * @handle_select: Handler for the #MmGdbusModemFirmware::handle-select signal.
 * @get_update_settings: Getter for the #MmGdbusModemFirmware:update-settings property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Firmware.top_of_page">org.freedesktop.ModemManager1.Modem.Firmware</link>.
 */

typedef MmGdbusModemFirmwareIface MmGdbusModemFirmwareInterface;
G_DEFINE_INTERFACE (MmGdbusModemFirmware, mm_gdbus_modem_firmware, G_TYPE_OBJECT)

static void
mm_gdbus_modem_firmware_default_init (MmGdbusModemFirmwareIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemFirmware::handle-list:
   * @object: A #MmGdbusModemFirmware.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Firmware.List">List()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_firmware_complete_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemFirmwareIface, handle_list),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModemFirmware::handle-select:
   * @object: A #MmGdbusModemFirmware.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uniqueid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Firmware.Select">Select()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_firmware_complete_select() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemFirmwareIface, handle_select),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemFirmware:update-settings:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Firmware.UpdateSettings">"UpdateSettings"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("update-settings", "UpdateSettings", "UpdateSettings", G_VARIANT_TYPE ("(ua{sv})"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_firmware_get_update_settings: (skip)
 * @object: A #MmGdbusModemFirmware.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Firmware.UpdateSettings">"UpdateSettings"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_firmware_dup_update_settings() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_firmware_get_update_settings (MmGdbusModemFirmware *object)
{
  return MM_GDBUS_MODEM_FIRMWARE_GET_IFACE (object)->get_update_settings (object);
}

/**
 * mm_gdbus_modem_firmware_dup_update_settings: (skip)
 * @object: A #MmGdbusModemFirmware.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Firmware.UpdateSettings">"UpdateSettings"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_firmware_dup_update_settings (MmGdbusModemFirmware *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "update-settings", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_firmware_set_update_settings: (skip)
 * @object: A #MmGdbusModemFirmware.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Firmware.UpdateSettings">"UpdateSettings"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_firmware_set_update_settings (MmGdbusModemFirmware *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "update-settings", value, NULL);
}

/**
 * mm_gdbus_modem_firmware_call_list:
 * @proxy: A #MmGdbusModemFirmwareProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Firmware.List">List()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_firmware_call_list_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_firmware_call_list_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_firmware_call_list (
    MmGdbusModemFirmware *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_firmware_call_list_finish:
 * @proxy: A #MmGdbusModemFirmwareProxy.
 * @out_selected: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_installed: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_firmware_call_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_firmware_call_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_firmware_call_list_finish (
    MmGdbusModemFirmware *proxy,
    gchar **out_selected,
    GVariant **out_installed,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s@aa{sv})",
                 out_selected,
                 out_installed);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_firmware_call_list_sync:
 * @proxy: A #MmGdbusModemFirmwareProxy.
 * @out_selected: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_installed: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Firmware.List">List()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_firmware_call_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_firmware_call_list_sync (
    MmGdbusModemFirmware *proxy,
    gchar **out_selected,
    GVariant **out_installed,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s@aa{sv})",
                 out_selected,
                 out_installed);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_firmware_call_select:
 * @proxy: A #MmGdbusModemFirmwareProxy.
 * @arg_uniqueid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Firmware.Select">Select()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_firmware_call_select_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_firmware_call_select_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_firmware_call_select (
    MmGdbusModemFirmware *proxy,
    const gchar *arg_uniqueid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Select",
    g_variant_new ("(s)",
                   arg_uniqueid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_firmware_call_select_finish:
 * @proxy: A #MmGdbusModemFirmwareProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_firmware_call_select().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_firmware_call_select().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_firmware_call_select_finish (
    MmGdbusModemFirmware *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_firmware_call_select_sync:
 * @proxy: A #MmGdbusModemFirmwareProxy.
 * @arg_uniqueid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Firmware.Select">Select()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_firmware_call_select() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_firmware_call_select_sync (
    MmGdbusModemFirmware *proxy,
    const gchar *arg_uniqueid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Select",
    g_variant_new ("(s)",
                   arg_uniqueid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_firmware_complete_list:
 * @object: A #MmGdbusModemFirmware.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @selected: Parameter to return.
 * @installed: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Firmware.List">List()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_firmware_complete_list (
    MmGdbusModemFirmware *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *selected,
    GVariant *installed)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s@aa{sv})",
                   selected,
                   installed));
}

/**
 * mm_gdbus_modem_firmware_complete_select:
 * @object: A #MmGdbusModemFirmware.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Firmware.Select">Select()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_firmware_complete_select (
    MmGdbusModemFirmware *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemFirmwareProxy:
 *
 * The #MmGdbusModemFirmwareProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemFirmwareProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemFirmwareProxy.
 */

struct _MmGdbusModemFirmwareProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_firmware_proxy_iface_init (MmGdbusModemFirmwareIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemFirmwareProxy, mm_gdbus_modem_firmware_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemFirmwareProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_FIRMWARE, mm_gdbus_modem_firmware_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemFirmwareProxy, mm_gdbus_modem_firmware_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_FIRMWARE, mm_gdbus_modem_firmware_proxy_iface_init))

#endif
static void
mm_gdbus_modem_firmware_proxy_finalize (GObject *object)
{
  MmGdbusModemFirmwareProxy *proxy = MM_GDBUS_MODEM_FIRMWARE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_firmware_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_firmware_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_firmware_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_firmware_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Firmware: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_firmware_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_firmware_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Firmware", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_firmware_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_firmware_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_firmware_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_FIRMWARE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_FIRMWARE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_firmware_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemFirmwareProxy *proxy = MM_GDBUS_MODEM_FIRMWARE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_firmware_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_firmware_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static GVariant *
mm_gdbus_modem_firmware_proxy_get_update_settings (MmGdbusModemFirmware *object)
{
  MmGdbusModemFirmwareProxy *proxy = MM_GDBUS_MODEM_FIRMWARE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UpdateSettings");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
mm_gdbus_modem_firmware_proxy_init (MmGdbusModemFirmwareProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_firmware_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_FIRMWARE_PROXY, MmGdbusModemFirmwareProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_firmware_interface_info ());
}

static void
mm_gdbus_modem_firmware_proxy_class_init (MmGdbusModemFirmwareProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_firmware_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_firmware_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_firmware_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_firmware_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_firmware_proxy_g_properties_changed;

  mm_gdbus_modem_firmware_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemFirmwareProxyPrivate));
#endif
}

static void
mm_gdbus_modem_firmware_proxy_iface_init (MmGdbusModemFirmwareIface *iface)
{
  iface->get_update_settings = mm_gdbus_modem_firmware_proxy_get_update_settings;
}

/**
 * mm_gdbus_modem_firmware_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Firmware.top_of_page">org.freedesktop.ModemManager1.Modem.Firmware</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_firmware_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_firmware_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_firmware_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_FIRMWARE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Firmware", NULL);
}

/**
 * mm_gdbus_modem_firmware_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_firmware_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_firmware_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemFirmwareProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemFirmware *
mm_gdbus_modem_firmware_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_FIRMWARE (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_firmware_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Firmware.top_of_page">org.freedesktop.ModemManager1.Modem.Firmware</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_firmware_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemFirmwareProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemFirmware *
mm_gdbus_modem_firmware_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_FIRMWARE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Firmware", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_FIRMWARE (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_firmware_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_firmware_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_firmware_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_firmware_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_firmware_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_FIRMWARE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Firmware", NULL);
}

/**
 * mm_gdbus_modem_firmware_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_firmware_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_firmware_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemFirmwareProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemFirmware *
mm_gdbus_modem_firmware_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_FIRMWARE (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_firmware_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_firmware_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_firmware_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemFirmwareProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemFirmware *
mm_gdbus_modem_firmware_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_FIRMWARE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Firmware", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_FIRMWARE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemFirmwareSkeleton:
 *
 * The #MmGdbusModemFirmwareSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemFirmwareSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemFirmwareSkeleton.
 */

struct _MmGdbusModemFirmwareSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_firmware_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_FIRMWARE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_FIRMWARE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_firmware_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_firmware_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_firmware_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_firmware_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_firmware_skeleton_vtable =
{
  _mm_gdbus_modem_firmware_skeleton_handle_method_call,
  _mm_gdbus_modem_firmware_skeleton_handle_get_property,
  _mm_gdbus_modem_firmware_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_firmware_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_firmware_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_firmware_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_firmware_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_firmware_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_firmware_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_firmware_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_firmware_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_firmware_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Firmware", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_firmware_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_firmware_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_firmware_emit_changed (skeleton);
}

static void mm_gdbus_modem_firmware_skeleton_iface_init (MmGdbusModemFirmwareIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemFirmwareSkeleton, mm_gdbus_modem_firmware_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemFirmwareSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_FIRMWARE, mm_gdbus_modem_firmware_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemFirmwareSkeleton, mm_gdbus_modem_firmware_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_FIRMWARE, mm_gdbus_modem_firmware_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_firmware_skeleton_finalize (GObject *object)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_firmware_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_firmware_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_firmware_emit_changed (gpointer user_data)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Firmware",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_firmware_schedule_emit_changed (MmGdbusModemFirmwareSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_firmware_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_firmware_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_firmware_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_firmware_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_firmware_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_firmware_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_firmware_skeleton_init (MmGdbusModemFirmwareSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_firmware_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_FIRMWARE_SKELETON, MmGdbusModemFirmwareSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_VARIANT);
}

static GVariant *
mm_gdbus_modem_firmware_skeleton_get_update_settings (MmGdbusModemFirmware *object)
{
  MmGdbusModemFirmwareSkeleton *skeleton = MM_GDBUS_MODEM_FIRMWARE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_firmware_skeleton_class_init (MmGdbusModemFirmwareSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_firmware_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_firmware_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_firmware_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_firmware_skeleton_notify;


  mm_gdbus_modem_firmware_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_firmware_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_firmware_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_firmware_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_firmware_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemFirmwareSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_firmware_skeleton_iface_init (MmGdbusModemFirmwareIface *iface)
{
  iface->get_update_settings = mm_gdbus_modem_firmware_skeleton_get_update_settings;
}

/**
 * mm_gdbus_modem_firmware_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Firmware.top_of_page">org.freedesktop.ModemManager1.Modem.Firmware</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemFirmwareSkeleton): The skeleton object.
 */
MmGdbusModemFirmware *
mm_gdbus_modem_firmware_skeleton_new (void)
{
  return MM_GDBUS_MODEM_FIRMWARE (g_object_new (MM_GDBUS_TYPE_MODEM_FIRMWARE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Location
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemLocation
 * @title: MmGdbusModemLocation
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Location D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Location.top_of_page">org.freedesktop.ModemManager1.Modem.Location</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Location ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_location_method_info_setup_IN_ARG_sources =
{
  {
    -1,
    (gchar *) "sources",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_location_method_info_setup_IN_ARG_signal_location =
{
  {
    -1,
    (gchar *) "signal_location",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_location_method_info_setup_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_location_method_info_setup_IN_ARG_sources.parent_struct,
  &_mm_gdbus_modem_location_method_info_setup_IN_ARG_signal_location.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_location_method_info_setup =
{
  {
    -1,
    (gchar *) "Setup",
    (GDBusArgInfo **) &_mm_gdbus_modem_location_method_info_setup_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-setup",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_location_method_info_get_location_OUT_ARG_Location =
{
  {
    -1,
    (gchar *) "Location",
    (gchar *) "a{uv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_location_method_info_get_location_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_location_method_info_get_location_OUT_ARG_Location.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_location_method_info_get_location =
{
  {
    -1,
    (gchar *) "GetLocation",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_location_method_info_get_location_OUT_ARG_pointers,
    NULL
  },
  "handle-get-location",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_location_method_info_set_supl_server_IN_ARG_supl =
{
  {
    -1,
    (gchar *) "supl",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_location_method_info_set_supl_server_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_location_method_info_set_supl_server_IN_ARG_supl.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_location_method_info_set_supl_server =
{
  {
    -1,
    (gchar *) "SetSuplServer",
    (GDBusArgInfo **) &_mm_gdbus_modem_location_method_info_set_supl_server_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-supl-server",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_location_method_info_inject_assistance_data_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _mm_gdbus_modem_location_method_info_inject_assistance_data_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_location_method_info_inject_assistance_data_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_location_method_info_inject_assistance_data =
{
  {
    -1,
    (gchar *) "InjectAssistanceData",
    (GDBusArgInfo **) &_mm_gdbus_modem_location_method_info_inject_assistance_data_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-inject-assistance-data",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_location_method_info_set_gps_refresh_rate_IN_ARG_rate =
{
  {
    -1,
    (gchar *) "rate",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_location_method_info_set_gps_refresh_rate_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_location_method_info_set_gps_refresh_rate_IN_ARG_rate.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_location_method_info_set_gps_refresh_rate =
{
  {
    -1,
    (gchar *) "SetGpsRefreshRate",
    (GDBusArgInfo **) &_mm_gdbus_modem_location_method_info_set_gps_refresh_rate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-gps-refresh-rate",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_location_method_info_pointers[] =
{
  &_mm_gdbus_modem_location_method_info_setup.parent_struct,
  &_mm_gdbus_modem_location_method_info_get_location.parent_struct,
  &_mm_gdbus_modem_location_method_info_set_supl_server.parent_struct,
  &_mm_gdbus_modem_location_method_info_inject_assistance_data.parent_struct,
  &_mm_gdbus_modem_location_method_info_set_gps_refresh_rate.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_location_property_info_capabilities =
{
  {
    -1,
    (gchar *) "Capabilities",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "capabilities",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_location_property_info_supported_assistance_data =
{
  {
    -1,
    (gchar *) "SupportedAssistanceData",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-assistance-data",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_location_property_info_enabled =
{
  {
    -1,
    (gchar *) "Enabled",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_location_property_info_signals_location =
{
  {
    -1,
    (gchar *) "SignalsLocation",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "signals-location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_location_property_info_location =
{
  {
    -1,
    (gchar *) "Location",
    (gchar *) "a{uv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_location_property_info_supl_server =
{
  {
    -1,
    (gchar *) "SuplServer",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supl-server",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_location_property_info_assistance_data_servers =
{
  {
    -1,
    (gchar *) "AssistanceDataServers",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "assistance-data-servers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_location_property_info_gps_refresh_rate =
{
  {
    -1,
    (gchar *) "GpsRefreshRate",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "gps-refresh-rate",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_location_property_info_pointers[] =
{
  &_mm_gdbus_modem_location_property_info_capabilities.parent_struct,
  &_mm_gdbus_modem_location_property_info_supported_assistance_data.parent_struct,
  &_mm_gdbus_modem_location_property_info_enabled.parent_struct,
  &_mm_gdbus_modem_location_property_info_signals_location.parent_struct,
  &_mm_gdbus_modem_location_property_info_location.parent_struct,
  &_mm_gdbus_modem_location_property_info_supl_server.parent_struct,
  &_mm_gdbus_modem_location_property_info_assistance_data_servers.parent_struct,
  &_mm_gdbus_modem_location_property_info_gps_refresh_rate.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_location_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Location",
    (GDBusMethodInfo **) &_mm_gdbus_modem_location_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_location_property_info_pointers,
    NULL
  },
  "modem-location",
};


/**
 * mm_gdbus_modem_location_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Location.top_of_page">org.freedesktop.ModemManager1.Modem.Location</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_location_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_location_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_location_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemLocation interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_location_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "capabilities");
  g_object_class_override_property (klass, property_id_begin++, "supported-assistance-data");
  g_object_class_override_property (klass, property_id_begin++, "enabled");
  g_object_class_override_property (klass, property_id_begin++, "signals-location");
  g_object_class_override_property (klass, property_id_begin++, "location");
  g_object_class_override_property (klass, property_id_begin++, "supl-server");
  g_object_class_override_property (klass, property_id_begin++, "assistance-data-servers");
  g_object_class_override_property (klass, property_id_begin++, "gps-refresh-rate");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemLocation:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Location.top_of_page">org.freedesktop.ModemManager1.Modem.Location</link>.
 */

/**
 * MmGdbusModemLocationIface:
 * @parent_iface: The parent interface.
 * @handle_get_location: Handler for the #MmGdbusModemLocation::handle-get-location signal.
 * @handle_inject_assistance_data: Handler for the #MmGdbusModemLocation::handle-inject-assistance-data signal.
 * @handle_set_gps_refresh_rate: Handler for the #MmGdbusModemLocation::handle-set-gps-refresh-rate signal.
 * @handle_set_supl_server: Handler for the #MmGdbusModemLocation::handle-set-supl-server signal.
 * @handle_setup: Handler for the #MmGdbusModemLocation::handle-setup signal.
 * @get_assistance_data_servers: Getter for the #MmGdbusModemLocation:assistance-data-servers property.
 * @get_capabilities: Getter for the #MmGdbusModemLocation:capabilities property.
 * @get_enabled: Getter for the #MmGdbusModemLocation:enabled property.
 * @get_gps_refresh_rate: Getter for the #MmGdbusModemLocation:gps-refresh-rate property.
 * @get_location: Getter for the #MmGdbusModemLocation:location property.
 * @get_signals_location: Getter for the #MmGdbusModemLocation:signals-location property.
 * @get_supl_server: Getter for the #MmGdbusModemLocation:supl-server property.
 * @get_supported_assistance_data: Getter for the #MmGdbusModemLocation:supported-assistance-data property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Location.top_of_page">org.freedesktop.ModemManager1.Modem.Location</link>.
 */

typedef MmGdbusModemLocationIface MmGdbusModemLocationInterface;
G_DEFINE_INTERFACE (MmGdbusModemLocation, mm_gdbus_modem_location, G_TYPE_OBJECT)

static void
mm_gdbus_modem_location_default_init (MmGdbusModemLocationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemLocation::handle-setup:
   * @object: A #MmGdbusModemLocation.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_sources: Argument passed by remote caller.
   * @arg_signal_location: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.Setup">Setup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_location_complete_setup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-setup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemLocationIface, handle_setup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * MmGdbusModemLocation::handle-get-location:
   * @object: A #MmGdbusModemLocation.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.GetLocation">GetLocation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_location_complete_get_location() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-location",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemLocationIface, handle_get_location),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModemLocation::handle-set-supl-server:
   * @object: A #MmGdbusModemLocation.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_supl: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.SetSuplServer">SetSuplServer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_location_complete_set_supl_server() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-supl-server",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemLocationIface, handle_set_supl_server),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusModemLocation::handle-inject-assistance-data:
   * @object: A #MmGdbusModemLocation.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.InjectAssistanceData">InjectAssistanceData()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_location_complete_inject_assistance_data() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inject-assistance-data",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemLocationIface, handle_inject_assistance_data),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MmGdbusModemLocation::handle-set-gps-refresh-rate:
   * @object: A #MmGdbusModemLocation.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_rate: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.SetGpsRefreshRate">SetGpsRefreshRate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_location_complete_set_gps_refresh_rate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-gps-refresh-rate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemLocationIface, handle_set_gps_refresh_rate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemLocation:capabilities:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Capabilities">"Capabilities"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("capabilities", "Capabilities", "Capabilities", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemLocation:supported-assistance-data:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SupportedAssistanceData">"SupportedAssistanceData"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supported-assistance-data", "SupportedAssistanceData", "SupportedAssistanceData", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemLocation:enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Enabled">"Enabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("enabled", "Enabled", "Enabled", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemLocation:signals-location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SignalsLocation">"SignalsLocation"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("signals-location", "SignalsLocation", "SignalsLocation", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemLocation:location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Location">"Location"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("location", "Location", "Location", G_VARIANT_TYPE ("a{uv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemLocation:supl-server:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SuplServer">"SuplServer"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("supl-server", "SuplServer", "SuplServer", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemLocation:assistance-data-servers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.AssistanceDataServers">"AssistanceDataServers"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("assistance-data-servers", "AssistanceDataServers", "AssistanceDataServers", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemLocation:gps-refresh-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.GpsRefreshRate">"GpsRefreshRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("gps-refresh-rate", "GpsRefreshRate", "GpsRefreshRate", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_location_get_capabilities: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Capabilities">"Capabilities"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_location_get_capabilities (MmGdbusModemLocation *object)
{
  return MM_GDBUS_MODEM_LOCATION_GET_IFACE (object)->get_capabilities (object);
}

/**
 * mm_gdbus_modem_location_set_capabilities: (skip)
 * @object: A #MmGdbusModemLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Capabilities">"Capabilities"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_location_set_capabilities (MmGdbusModemLocation *object, guint value)
{
  g_object_set (G_OBJECT (object), "capabilities", value, NULL);
}

/**
 * mm_gdbus_modem_location_get_supported_assistance_data: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SupportedAssistanceData">"SupportedAssistanceData"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_location_get_supported_assistance_data (MmGdbusModemLocation *object)
{
  return MM_GDBUS_MODEM_LOCATION_GET_IFACE (object)->get_supported_assistance_data (object);
}

/**
 * mm_gdbus_modem_location_set_supported_assistance_data: (skip)
 * @object: A #MmGdbusModemLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SupportedAssistanceData">"SupportedAssistanceData"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_location_set_supported_assistance_data (MmGdbusModemLocation *object, guint value)
{
  g_object_set (G_OBJECT (object), "supported-assistance-data", value, NULL);
}

/**
 * mm_gdbus_modem_location_get_enabled: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Enabled">"Enabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_location_get_enabled (MmGdbusModemLocation *object)
{
  return MM_GDBUS_MODEM_LOCATION_GET_IFACE (object)->get_enabled (object);
}

/**
 * mm_gdbus_modem_location_set_enabled: (skip)
 * @object: A #MmGdbusModemLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Enabled">"Enabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_location_set_enabled (MmGdbusModemLocation *object, guint value)
{
  g_object_set (G_OBJECT (object), "enabled", value, NULL);
}

/**
 * mm_gdbus_modem_location_get_signals_location: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SignalsLocation">"SignalsLocation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mm_gdbus_modem_location_get_signals_location (MmGdbusModemLocation *object)
{
  return MM_GDBUS_MODEM_LOCATION_GET_IFACE (object)->get_signals_location (object);
}

/**
 * mm_gdbus_modem_location_set_signals_location: (skip)
 * @object: A #MmGdbusModemLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SignalsLocation">"SignalsLocation"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_location_set_signals_location (MmGdbusModemLocation *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "signals-location", value, NULL);
}

/**
 * mm_gdbus_modem_location_get_location: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_location_dup_location() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_location_get_location (MmGdbusModemLocation *object)
{
  return MM_GDBUS_MODEM_LOCATION_GET_IFACE (object)->get_location (object);
}

/**
 * mm_gdbus_modem_location_dup_location: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_location_dup_location (MmGdbusModemLocation *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "location", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_location_set_location: (skip)
 * @object: A #MmGdbusModemLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.Location">"Location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_location_set_location (MmGdbusModemLocation *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "location", value, NULL);
}

/**
 * mm_gdbus_modem_location_get_supl_server: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SuplServer">"SuplServer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_location_dup_supl_server() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem_location_get_supl_server (MmGdbusModemLocation *object)
{
  return MM_GDBUS_MODEM_LOCATION_GET_IFACE (object)->get_supl_server (object);
}

/**
 * mm_gdbus_modem_location_dup_supl_server: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SuplServer">"SuplServer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem_location_dup_supl_server (MmGdbusModemLocation *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "supl-server", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_location_set_supl_server: (skip)
 * @object: A #MmGdbusModemLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.SuplServer">"SuplServer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_location_set_supl_server (MmGdbusModemLocation *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "supl-server", value, NULL);
}

/**
 * mm_gdbus_modem_location_get_assistance_data_servers: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.AssistanceDataServers">"AssistanceDataServers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_location_dup_assistance_data_servers() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
mm_gdbus_modem_location_get_assistance_data_servers (MmGdbusModemLocation *object)
{
  return MM_GDBUS_MODEM_LOCATION_GET_IFACE (object)->get_assistance_data_servers (object);
}

/**
 * mm_gdbus_modem_location_dup_assistance_data_servers: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.AssistanceDataServers">"AssistanceDataServers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
mm_gdbus_modem_location_dup_assistance_data_servers (MmGdbusModemLocation *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "assistance-data-servers", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_location_set_assistance_data_servers: (skip)
 * @object: A #MmGdbusModemLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.AssistanceDataServers">"AssistanceDataServers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_location_set_assistance_data_servers (MmGdbusModemLocation *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "assistance-data-servers", value, NULL);
}

/**
 * mm_gdbus_modem_location_get_gps_refresh_rate: (skip)
 * @object: A #MmGdbusModemLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.GpsRefreshRate">"GpsRefreshRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_location_get_gps_refresh_rate (MmGdbusModemLocation *object)
{
  return MM_GDBUS_MODEM_LOCATION_GET_IFACE (object)->get_gps_refresh_rate (object);
}

/**
 * mm_gdbus_modem_location_set_gps_refresh_rate: (skip)
 * @object: A #MmGdbusModemLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Location.GpsRefreshRate">"GpsRefreshRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_location_set_gps_refresh_rate (MmGdbusModemLocation *object, guint value)
{
  g_object_set (G_OBJECT (object), "gps-refresh-rate", value, NULL);
}

/**
 * mm_gdbus_modem_location_call_setup:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @arg_sources: Argument to pass with the method invocation.
 * @arg_signal_location: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.Setup">Setup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_location_call_setup_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_location_call_setup_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_location_call_setup (
    MmGdbusModemLocation *proxy,
    guint arg_sources,
    gboolean arg_signal_location,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Setup",
    g_variant_new ("(ub)",
                   arg_sources,
                   arg_signal_location),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_location_call_setup_finish:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_location_call_setup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_location_call_setup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_setup_finish (
    MmGdbusModemLocation *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_setup_sync:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @arg_sources: Argument to pass with the method invocation.
 * @arg_signal_location: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.Setup">Setup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_location_call_setup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_setup_sync (
    MmGdbusModemLocation *proxy,
    guint arg_sources,
    gboolean arg_signal_location,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Setup",
    g_variant_new ("(ub)",
                   arg_sources,
                   arg_signal_location),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_get_location:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.GetLocation">GetLocation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_location_call_get_location_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_location_call_get_location_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_location_call_get_location (
    MmGdbusModemLocation *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetLocation",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_location_call_get_location_finish:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @out_Location: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_location_call_get_location().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_location_call_get_location().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_get_location_finish (
    MmGdbusModemLocation *proxy,
    GVariant **out_Location,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{uv})",
                 out_Location);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_get_location_sync:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @out_Location: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.GetLocation">GetLocation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_location_call_get_location() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_get_location_sync (
    MmGdbusModemLocation *proxy,
    GVariant **out_Location,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetLocation",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{uv})",
                 out_Location);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_set_supl_server:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @arg_supl: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.SetSuplServer">SetSuplServer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_location_call_set_supl_server_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_location_call_set_supl_server_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_location_call_set_supl_server (
    MmGdbusModemLocation *proxy,
    const gchar *arg_supl,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetSuplServer",
    g_variant_new ("(s)",
                   arg_supl),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_location_call_set_supl_server_finish:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_location_call_set_supl_server().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_location_call_set_supl_server().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_set_supl_server_finish (
    MmGdbusModemLocation *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_set_supl_server_sync:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @arg_supl: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.SetSuplServer">SetSuplServer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_location_call_set_supl_server() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_set_supl_server_sync (
    MmGdbusModemLocation *proxy,
    const gchar *arg_supl,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetSuplServer",
    g_variant_new ("(s)",
                   arg_supl),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_inject_assistance_data:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.InjectAssistanceData">InjectAssistanceData()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_location_call_inject_assistance_data_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_location_call_inject_assistance_data_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_location_call_inject_assistance_data (
    MmGdbusModemLocation *proxy,
    GVariant *arg_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "InjectAssistanceData",
    g_variant_new ("(@ay)",
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_location_call_inject_assistance_data_finish:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_location_call_inject_assistance_data().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_location_call_inject_assistance_data().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_inject_assistance_data_finish (
    MmGdbusModemLocation *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_inject_assistance_data_sync:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.InjectAssistanceData">InjectAssistanceData()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_location_call_inject_assistance_data() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_inject_assistance_data_sync (
    MmGdbusModemLocation *proxy,
    GVariant *arg_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "InjectAssistanceData",
    g_variant_new ("(@ay)",
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_set_gps_refresh_rate:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @arg_rate: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.SetGpsRefreshRate">SetGpsRefreshRate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_location_call_set_gps_refresh_rate_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_location_call_set_gps_refresh_rate_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_location_call_set_gps_refresh_rate (
    MmGdbusModemLocation *proxy,
    guint arg_rate,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetGpsRefreshRate",
    g_variant_new ("(u)",
                   arg_rate),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_location_call_set_gps_refresh_rate_finish:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_location_call_set_gps_refresh_rate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_location_call_set_gps_refresh_rate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_set_gps_refresh_rate_finish (
    MmGdbusModemLocation *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_call_set_gps_refresh_rate_sync:
 * @proxy: A #MmGdbusModemLocationProxy.
 * @arg_rate: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.SetGpsRefreshRate">SetGpsRefreshRate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_location_call_set_gps_refresh_rate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_location_call_set_gps_refresh_rate_sync (
    MmGdbusModemLocation *proxy,
    guint arg_rate,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetGpsRefreshRate",
    g_variant_new ("(u)",
                   arg_rate),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_location_complete_setup:
 * @object: A #MmGdbusModemLocation.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.Setup">Setup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_location_complete_setup (
    MmGdbusModemLocation *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_location_complete_get_location:
 * @object: A #MmGdbusModemLocation.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @Location: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.GetLocation">GetLocation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_location_complete_get_location (
    MmGdbusModemLocation *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *Location)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{uv})",
                   Location));
}

/**
 * mm_gdbus_modem_location_complete_set_supl_server:
 * @object: A #MmGdbusModemLocation.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.SetSuplServer">SetSuplServer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_location_complete_set_supl_server (
    MmGdbusModemLocation *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_location_complete_inject_assistance_data:
 * @object: A #MmGdbusModemLocation.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.InjectAssistanceData">InjectAssistanceData()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_location_complete_inject_assistance_data (
    MmGdbusModemLocation *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_location_complete_set_gps_refresh_rate:
 * @object: A #MmGdbusModemLocation.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Location.SetGpsRefreshRate">SetGpsRefreshRate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_location_complete_set_gps_refresh_rate (
    MmGdbusModemLocation *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemLocationProxy:
 *
 * The #MmGdbusModemLocationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemLocationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemLocationProxy.
 */

struct _MmGdbusModemLocationProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_location_proxy_iface_init (MmGdbusModemLocationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemLocationProxy, mm_gdbus_modem_location_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemLocationProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_LOCATION, mm_gdbus_modem_location_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemLocationProxy, mm_gdbus_modem_location_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_LOCATION, mm_gdbus_modem_location_proxy_iface_init))

#endif
static void
mm_gdbus_modem_location_proxy_finalize (GObject *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_location_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_location_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_location_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_location_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Location: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_location_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_location_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Location", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_location_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_location_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_location_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_LOCATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_LOCATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_location_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_location_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_location_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
mm_gdbus_modem_location_proxy_get_capabilities (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Capabilities");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_location_proxy_get_supported_assistance_data (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedAssistanceData");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_location_proxy_get_enabled (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Enabled");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mm_gdbus_modem_location_proxy_get_signals_location (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SignalsLocation");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_modem_location_proxy_get_location (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Location");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
mm_gdbus_modem_location_proxy_get_supl_server (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SuplServer");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
mm_gdbus_modem_location_proxy_get_assistance_data_servers (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "AssistanceDataServers");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AssistanceDataServers");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "AssistanceDataServers", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_location_proxy_get_gps_refresh_rate (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationProxy *proxy = MM_GDBUS_MODEM_LOCATION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "GpsRefreshRate");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_modem_location_proxy_init (MmGdbusModemLocationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_location_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_LOCATION_PROXY, MmGdbusModemLocationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_location_interface_info ());
}

static void
mm_gdbus_modem_location_proxy_class_init (MmGdbusModemLocationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_location_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_location_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_location_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_location_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_location_proxy_g_properties_changed;

  mm_gdbus_modem_location_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemLocationProxyPrivate));
#endif
}

static void
mm_gdbus_modem_location_proxy_iface_init (MmGdbusModemLocationIface *iface)
{
  iface->get_capabilities = mm_gdbus_modem_location_proxy_get_capabilities;
  iface->get_supported_assistance_data = mm_gdbus_modem_location_proxy_get_supported_assistance_data;
  iface->get_enabled = mm_gdbus_modem_location_proxy_get_enabled;
  iface->get_signals_location = mm_gdbus_modem_location_proxy_get_signals_location;
  iface->get_location = mm_gdbus_modem_location_proxy_get_location;
  iface->get_supl_server = mm_gdbus_modem_location_proxy_get_supl_server;
  iface->get_assistance_data_servers = mm_gdbus_modem_location_proxy_get_assistance_data_servers;
  iface->get_gps_refresh_rate = mm_gdbus_modem_location_proxy_get_gps_refresh_rate;
}

/**
 * mm_gdbus_modem_location_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Location.top_of_page">org.freedesktop.ModemManager1.Modem.Location</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_location_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_location_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_location_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_LOCATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Location", NULL);
}

/**
 * mm_gdbus_modem_location_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_location_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_location_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemLocation *
mm_gdbus_modem_location_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_LOCATION (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_location_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Location.top_of_page">org.freedesktop.ModemManager1.Modem.Location</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_location_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemLocation *
mm_gdbus_modem_location_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_LOCATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Location", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_LOCATION (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_location_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_location_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_location_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_location_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_location_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_LOCATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Location", NULL);
}

/**
 * mm_gdbus_modem_location_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_location_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_location_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemLocation *
mm_gdbus_modem_location_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_LOCATION (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_location_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_location_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_location_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemLocation *
mm_gdbus_modem_location_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_LOCATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Location", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_LOCATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemLocationSkeleton:
 *
 * The #MmGdbusModemLocationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemLocationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemLocationSkeleton.
 */

struct _MmGdbusModemLocationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_location_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_LOCATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_LOCATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_location_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_location_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_location_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_location_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_location_skeleton_vtable =
{
  _mm_gdbus_modem_location_skeleton_handle_method_call,
  _mm_gdbus_modem_location_skeleton_handle_get_property,
  _mm_gdbus_modem_location_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_location_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_location_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_location_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_location_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_location_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_location_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_location_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_location_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_location_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Location", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_location_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_location_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_location_emit_changed (skeleton);
}

static void mm_gdbus_modem_location_skeleton_iface_init (MmGdbusModemLocationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemLocationSkeleton, mm_gdbus_modem_location_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemLocationSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_LOCATION, mm_gdbus_modem_location_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemLocationSkeleton, mm_gdbus_modem_location_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_LOCATION, mm_gdbus_modem_location_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_location_skeleton_finalize (GObject *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  guint n;
  for (n = 0; n < 8; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_location_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_location_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_location_emit_changed (gpointer user_data)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Location",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_location_schedule_emit_changed (MmGdbusModemLocationSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_location_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_location_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_location_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_location_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_location_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_location_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_location_skeleton_init (MmGdbusModemLocationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_location_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_LOCATION_SKELETON, MmGdbusModemLocationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 8);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_UINT);
}

static guint 
mm_gdbus_modem_location_skeleton_get_capabilities (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_location_skeleton_get_supported_assistance_data (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_location_skeleton_get_enabled (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mm_gdbus_modem_location_skeleton_get_signals_location (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_location_skeleton_get_location (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_modem_location_skeleton_get_supl_server (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
mm_gdbus_modem_location_skeleton_get_assistance_data_servers (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_location_skeleton_get_gps_refresh_rate (MmGdbusModemLocation *object)
{
  MmGdbusModemLocationSkeleton *skeleton = MM_GDBUS_MODEM_LOCATION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_location_skeleton_class_init (MmGdbusModemLocationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_location_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_location_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_location_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_location_skeleton_notify;


  mm_gdbus_modem_location_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_location_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_location_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_location_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_location_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemLocationSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_location_skeleton_iface_init (MmGdbusModemLocationIface *iface)
{
  iface->get_capabilities = mm_gdbus_modem_location_skeleton_get_capabilities;
  iface->get_supported_assistance_data = mm_gdbus_modem_location_skeleton_get_supported_assistance_data;
  iface->get_enabled = mm_gdbus_modem_location_skeleton_get_enabled;
  iface->get_signals_location = mm_gdbus_modem_location_skeleton_get_signals_location;
  iface->get_location = mm_gdbus_modem_location_skeleton_get_location;
  iface->get_supl_server = mm_gdbus_modem_location_skeleton_get_supl_server;
  iface->get_assistance_data_servers = mm_gdbus_modem_location_skeleton_get_assistance_data_servers;
  iface->get_gps_refresh_rate = mm_gdbus_modem_location_skeleton_get_gps_refresh_rate;
}

/**
 * mm_gdbus_modem_location_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Location.top_of_page">org.freedesktop.ModemManager1.Modem.Location</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemLocationSkeleton): The skeleton object.
 */
MmGdbusModemLocation *
mm_gdbus_modem_location_skeleton_new (void)
{
  return MM_GDBUS_MODEM_LOCATION (g_object_new (MM_GDBUS_TYPE_MODEM_LOCATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Messaging
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemMessaging
 * @title: MmGdbusModemMessaging
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Messaging D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Messaging.top_of_page">org.freedesktop.ModemManager1.Modem.Messaging</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Messaging ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_messaging_method_info_list_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_messaging_method_info_list_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_messaging_method_info_list_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_messaging_method_info_list =
{
  {
    -1,
    (gchar *) "List",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_messaging_method_info_list_OUT_ARG_pointers,
    NULL
  },
  "handle-list",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_messaging_method_info_delete_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_messaging_method_info_delete_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_messaging_method_info_delete_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_messaging_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_mm_gdbus_modem_messaging_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_messaging_method_info_create_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_messaging_method_info_create_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_messaging_method_info_create_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_messaging_method_info_create_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_messaging_method_info_create_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_messaging_method_info_create_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_messaging_method_info_create =
{
  {
    -1,
    (gchar *) "Create",
    (GDBusArgInfo **) &_mm_gdbus_modem_messaging_method_info_create_IN_ARG_pointers,
    (GDBusArgInfo **) &_mm_gdbus_modem_messaging_method_info_create_OUT_ARG_pointers,
    NULL
  },
  "handle-create",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_messaging_method_info_pointers[] =
{
  &_mm_gdbus_modem_messaging_method_info_list.parent_struct,
  &_mm_gdbus_modem_messaging_method_info_delete.parent_struct,
  &_mm_gdbus_modem_messaging_method_info_create.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_messaging_signal_info_added_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_messaging_signal_info_added_ARG_received =
{
  {
    -1,
    (gchar *) "received",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_messaging_signal_info_added_ARG_pointers[] =
{
  &_mm_gdbus_modem_messaging_signal_info_added_ARG_path.parent_struct,
  &_mm_gdbus_modem_messaging_signal_info_added_ARG_received.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem_messaging_signal_info_added =
{
  {
    -1,
    (gchar *) "Added",
    (GDBusArgInfo **) &_mm_gdbus_modem_messaging_signal_info_added_ARG_pointers,
    NULL
  },
  "added"
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_messaging_signal_info_deleted_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_messaging_signal_info_deleted_ARG_pointers[] =
{
  &_mm_gdbus_modem_messaging_signal_info_deleted_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem_messaging_signal_info_deleted =
{
  {
    -1,
    (gchar *) "Deleted",
    (GDBusArgInfo **) &_mm_gdbus_modem_messaging_signal_info_deleted_ARG_pointers,
    NULL
  },
  "deleted"
};

static const GDBusSignalInfo * const _mm_gdbus_modem_messaging_signal_info_pointers[] =
{
  &_mm_gdbus_modem_messaging_signal_info_added.parent_struct,
  &_mm_gdbus_modem_messaging_signal_info_deleted.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_messaging_property_info_messages =
{
  {
    -1,
    (gchar *) "Messages",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "messages",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_messaging_property_info_supported_storages =
{
  {
    -1,
    (gchar *) "SupportedStorages",
    (gchar *) "au",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-storages",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_messaging_property_info_default_storage =
{
  {
    -1,
    (gchar *) "DefaultStorage",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "default-storage",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_messaging_property_info_pointers[] =
{
  &_mm_gdbus_modem_messaging_property_info_messages.parent_struct,
  &_mm_gdbus_modem_messaging_property_info_supported_storages.parent_struct,
  &_mm_gdbus_modem_messaging_property_info_default_storage.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_messaging_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Messaging",
    (GDBusMethodInfo **) &_mm_gdbus_modem_messaging_method_info_pointers,
    (GDBusSignalInfo **) &_mm_gdbus_modem_messaging_signal_info_pointers,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_messaging_property_info_pointers,
    NULL
  },
  "modem-messaging",
};


/**
 * mm_gdbus_modem_messaging_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Messaging.top_of_page">org.freedesktop.ModemManager1.Modem.Messaging</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_messaging_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_messaging_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_messaging_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemMessaging interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_messaging_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "messages");
  g_object_class_override_property (klass, property_id_begin++, "supported-storages");
  g_object_class_override_property (klass, property_id_begin++, "default-storage");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemMessaging:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Messaging.top_of_page">org.freedesktop.ModemManager1.Modem.Messaging</link>.
 */

/**
 * MmGdbusModemMessagingIface:
 * @parent_iface: The parent interface.
 * @handle_create: Handler for the #MmGdbusModemMessaging::handle-create signal.
 * @handle_delete: Handler for the #MmGdbusModemMessaging::handle-delete signal.
 * @handle_list: Handler for the #MmGdbusModemMessaging::handle-list signal.
 * @get_default_storage: Getter for the #MmGdbusModemMessaging:default-storage property.
 * @get_messages: Getter for the #MmGdbusModemMessaging:messages property.
 * @get_supported_storages: Getter for the #MmGdbusModemMessaging:supported-storages property.
 * @added: Handler for the #MmGdbusModemMessaging::added signal.
 * @deleted: Handler for the #MmGdbusModemMessaging::deleted signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Messaging.top_of_page">org.freedesktop.ModemManager1.Modem.Messaging</link>.
 */

typedef MmGdbusModemMessagingIface MmGdbusModemMessagingInterface;
G_DEFINE_INTERFACE (MmGdbusModemMessaging, mm_gdbus_modem_messaging, G_TYPE_OBJECT)

static void
mm_gdbus_modem_messaging_default_init (MmGdbusModemMessagingIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemMessaging::handle-list:
   * @object: A #MmGdbusModemMessaging.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.List">List()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_messaging_complete_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemMessagingIface, handle_list),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModemMessaging::handle-delete:
   * @object: A #MmGdbusModemMessaging.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_messaging_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemMessagingIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusModemMessaging::handle-create:
   * @object: A #MmGdbusModemMessaging.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.Create">Create()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_messaging_complete_create() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemMessagingIface, handle_create),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * MmGdbusModemMessaging::added:
   * @object: A #MmGdbusModemMessaging.
   * @arg_path: Argument.
   * @arg_received: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Messaging.Added">"Added"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemMessagingIface, added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * MmGdbusModemMessaging::deleted:
   * @object: A #MmGdbusModemMessaging.
   * @arg_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Messaging.Deleted">"Deleted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("deleted",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemMessagingIface, deleted),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemMessaging:messages:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.Messages">"Messages"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("messages", "Messages", "Messages", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemMessaging:supported-storages:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.SupportedStorages">"SupportedStorages"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("supported-storages", "SupportedStorages", "SupportedStorages", G_VARIANT_TYPE ("au"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemMessaging:default-storage:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.DefaultStorage">"DefaultStorage"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("default-storage", "DefaultStorage", "DefaultStorage", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_messaging_get_messages: (skip)
 * @object: A #MmGdbusModemMessaging.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.Messages">"Messages"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_messaging_dup_messages() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
mm_gdbus_modem_messaging_get_messages (MmGdbusModemMessaging *object)
{
  return MM_GDBUS_MODEM_MESSAGING_GET_IFACE (object)->get_messages (object);
}

/**
 * mm_gdbus_modem_messaging_dup_messages: (skip)
 * @object: A #MmGdbusModemMessaging.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.Messages">"Messages"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
mm_gdbus_modem_messaging_dup_messages (MmGdbusModemMessaging *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "messages", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_messaging_set_messages: (skip)
 * @object: A #MmGdbusModemMessaging.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.Messages">"Messages"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_messaging_set_messages (MmGdbusModemMessaging *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "messages", value, NULL);
}

/**
 * mm_gdbus_modem_messaging_get_supported_storages: (skip)
 * @object: A #MmGdbusModemMessaging.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.SupportedStorages">"SupportedStorages"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_messaging_dup_supported_storages() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_messaging_get_supported_storages (MmGdbusModemMessaging *object)
{
  return MM_GDBUS_MODEM_MESSAGING_GET_IFACE (object)->get_supported_storages (object);
}

/**
 * mm_gdbus_modem_messaging_dup_supported_storages: (skip)
 * @object: A #MmGdbusModemMessaging.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.SupportedStorages">"SupportedStorages"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_messaging_dup_supported_storages (MmGdbusModemMessaging *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "supported-storages", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_messaging_set_supported_storages: (skip)
 * @object: A #MmGdbusModemMessaging.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.SupportedStorages">"SupportedStorages"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_messaging_set_supported_storages (MmGdbusModemMessaging *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "supported-storages", value, NULL);
}

/**
 * mm_gdbus_modem_messaging_get_default_storage: (skip)
 * @object: A #MmGdbusModemMessaging.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.DefaultStorage">"DefaultStorage"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_messaging_get_default_storage (MmGdbusModemMessaging *object)
{
  return MM_GDBUS_MODEM_MESSAGING_GET_IFACE (object)->get_default_storage (object);
}

/**
 * mm_gdbus_modem_messaging_set_default_storage: (skip)
 * @object: A #MmGdbusModemMessaging.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Messaging.DefaultStorage">"DefaultStorage"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_messaging_set_default_storage (MmGdbusModemMessaging *object, guint value)
{
  g_object_set (G_OBJECT (object), "default-storage", value, NULL);
}

/**
 * mm_gdbus_modem_messaging_emit_added:
 * @object: A #MmGdbusModemMessaging.
 * @arg_path: Argument to pass with the signal.
 * @arg_received: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Messaging.Added">"Added"</link> D-Bus signal.
 */
void
mm_gdbus_modem_messaging_emit_added (
    MmGdbusModemMessaging *object,
    const gchar *arg_path,
    gboolean arg_received)
{
  g_signal_emit_by_name (object, "added", arg_path, arg_received);
}

/**
 * mm_gdbus_modem_messaging_emit_deleted:
 * @object: A #MmGdbusModemMessaging.
 * @arg_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Messaging.Deleted">"Deleted"</link> D-Bus signal.
 */
void
mm_gdbus_modem_messaging_emit_deleted (
    MmGdbusModemMessaging *object,
    const gchar *arg_path)
{
  g_signal_emit_by_name (object, "deleted", arg_path);
}

/**
 * mm_gdbus_modem_messaging_call_list:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.List">List()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_messaging_call_list_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_messaging_call_list_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_messaging_call_list (
    MmGdbusModemMessaging *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_messaging_call_list_finish:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @out_result: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_messaging_call_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_messaging_call_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_messaging_call_list_finish (
    MmGdbusModemMessaging *proxy,
    gchar ***out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_messaging_call_list_sync:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @out_result: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.List">List()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_messaging_call_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_messaging_call_list_sync (
    MmGdbusModemMessaging *proxy,
    gchar ***out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_messaging_call_delete:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_messaging_call_delete_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_messaging_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_messaging_call_delete (
    MmGdbusModemMessaging *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(o)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_messaging_call_delete_finish:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_messaging_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_messaging_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_messaging_call_delete_finish (
    MmGdbusModemMessaging *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_messaging_call_delete_sync:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_messaging_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_messaging_call_delete_sync (
    MmGdbusModemMessaging *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(o)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_messaging_call_create:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.Create">Create()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_messaging_call_create_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_messaging_call_create_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_messaging_call_create (
    MmGdbusModemMessaging *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Create",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_messaging_call_create_finish:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_messaging_call_create().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_messaging_call_create().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_messaging_call_create_finish (
    MmGdbusModemMessaging *proxy,
    gchar **out_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_messaging_call_create_sync:
 * @proxy: A #MmGdbusModemMessagingProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.Create">Create()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_messaging_call_create() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_messaging_call_create_sync (
    MmGdbusModemMessaging *proxy,
    GVariant *arg_properties,
    gchar **out_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Create",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_messaging_complete_list:
 * @object: A #MmGdbusModemMessaging.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.List">List()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_messaging_complete_list (
    MmGdbusModemMessaging *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   result));
}

/**
 * mm_gdbus_modem_messaging_complete_delete:
 * @object: A #MmGdbusModemMessaging.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_messaging_complete_delete (
    MmGdbusModemMessaging *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_messaging_complete_create:
 * @object: A #MmGdbusModemMessaging.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Messaging.Create">Create()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_messaging_complete_create (
    MmGdbusModemMessaging *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   path));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemMessagingProxy:
 *
 * The #MmGdbusModemMessagingProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemMessagingProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemMessagingProxy.
 */

struct _MmGdbusModemMessagingProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_messaging_proxy_iface_init (MmGdbusModemMessagingIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemMessagingProxy, mm_gdbus_modem_messaging_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemMessagingProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_MESSAGING, mm_gdbus_modem_messaging_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemMessagingProxy, mm_gdbus_modem_messaging_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_MESSAGING, mm_gdbus_modem_messaging_proxy_iface_init))

#endif
static void
mm_gdbus_modem_messaging_proxy_finalize (GObject *object)
{
  MmGdbusModemMessagingProxy *proxy = MM_GDBUS_MODEM_MESSAGING_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_messaging_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_messaging_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_messaging_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_messaging_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Messaging: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_messaging_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_messaging_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Messaging", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_messaging_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_messaging_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_messaging_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_MESSAGING);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_MESSAGING);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_messaging_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemMessagingProxy *proxy = MM_GDBUS_MODEM_MESSAGING_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_messaging_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_messaging_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
mm_gdbus_modem_messaging_proxy_get_messages (MmGdbusModemMessaging *object)
{
  MmGdbusModemMessagingProxy *proxy = MM_GDBUS_MODEM_MESSAGING_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Messages");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Messages");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Messages", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_modem_messaging_proxy_get_supported_storages (MmGdbusModemMessaging *object)
{
  MmGdbusModemMessagingProxy *proxy = MM_GDBUS_MODEM_MESSAGING_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedStorages");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static guint 
mm_gdbus_modem_messaging_proxy_get_default_storage (MmGdbusModemMessaging *object)
{
  MmGdbusModemMessagingProxy *proxy = MM_GDBUS_MODEM_MESSAGING_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultStorage");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_modem_messaging_proxy_init (MmGdbusModemMessagingProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_messaging_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_MESSAGING_PROXY, MmGdbusModemMessagingProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_messaging_interface_info ());
}

static void
mm_gdbus_modem_messaging_proxy_class_init (MmGdbusModemMessagingProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_messaging_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_messaging_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_messaging_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_messaging_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_messaging_proxy_g_properties_changed;

  mm_gdbus_modem_messaging_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemMessagingProxyPrivate));
#endif
}

static void
mm_gdbus_modem_messaging_proxy_iface_init (MmGdbusModemMessagingIface *iface)
{
  iface->get_messages = mm_gdbus_modem_messaging_proxy_get_messages;
  iface->get_supported_storages = mm_gdbus_modem_messaging_proxy_get_supported_storages;
  iface->get_default_storage = mm_gdbus_modem_messaging_proxy_get_default_storage;
}

/**
 * mm_gdbus_modem_messaging_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Messaging.top_of_page">org.freedesktop.ModemManager1.Modem.Messaging</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_messaging_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_messaging_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_messaging_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_MESSAGING_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Messaging", NULL);
}

/**
 * mm_gdbus_modem_messaging_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_messaging_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_messaging_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemMessagingProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemMessaging *
mm_gdbus_modem_messaging_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_MESSAGING (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_messaging_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Messaging.top_of_page">org.freedesktop.ModemManager1.Modem.Messaging</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_messaging_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemMessagingProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemMessaging *
mm_gdbus_modem_messaging_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_MESSAGING_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Messaging", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_MESSAGING (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_messaging_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_messaging_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_messaging_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_messaging_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_messaging_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_MESSAGING_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Messaging", NULL);
}

/**
 * mm_gdbus_modem_messaging_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_messaging_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_messaging_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemMessagingProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemMessaging *
mm_gdbus_modem_messaging_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_MESSAGING (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_messaging_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_messaging_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_messaging_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemMessagingProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemMessaging *
mm_gdbus_modem_messaging_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_MESSAGING_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Messaging", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_MESSAGING (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemMessagingSkeleton:
 *
 * The #MmGdbusModemMessagingSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemMessagingSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemMessagingSkeleton.
 */

struct _MmGdbusModemMessagingSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_messaging_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_MESSAGING);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_MESSAGING);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_messaging_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_messaging_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_messaging_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_messaging_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_messaging_skeleton_vtable =
{
  _mm_gdbus_modem_messaging_skeleton_handle_method_call,
  _mm_gdbus_modem_messaging_skeleton_handle_get_property,
  _mm_gdbus_modem_messaging_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_messaging_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_messaging_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_messaging_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_messaging_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_messaging_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_messaging_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_messaging_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_messaging_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_messaging_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Messaging", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_messaging_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_messaging_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_messaging_emit_changed (skeleton);
}

static void
_mm_gdbus_modem_messaging_on_signal_added (
    MmGdbusModemMessaging *object,
    const gchar *arg_path,
    gboolean arg_received)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ob)",
                   arg_path,
                   arg_received));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Messaging", "Added",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_mm_gdbus_modem_messaging_on_signal_deleted (
    MmGdbusModemMessaging *object,
    const gchar *arg_path)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Messaging", "Deleted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mm_gdbus_modem_messaging_skeleton_iface_init (MmGdbusModemMessagingIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemMessagingSkeleton, mm_gdbus_modem_messaging_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemMessagingSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_MESSAGING, mm_gdbus_modem_messaging_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemMessagingSkeleton, mm_gdbus_modem_messaging_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_MESSAGING, mm_gdbus_modem_messaging_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_messaging_skeleton_finalize (GObject *object)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_messaging_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_messaging_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_messaging_emit_changed (gpointer user_data)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Messaging",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_messaging_schedule_emit_changed (MmGdbusModemMessagingSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_messaging_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_messaging_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_messaging_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_messaging_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_messaging_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_messaging_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_messaging_skeleton_init (MmGdbusModemMessagingSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_messaging_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_MESSAGING_SKELETON, MmGdbusModemMessagingSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
}

static const gchar *const *
mm_gdbus_modem_messaging_skeleton_get_messages (MmGdbusModemMessaging *object)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_messaging_skeleton_get_supported_storages (MmGdbusModemMessaging *object)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_messaging_skeleton_get_default_storage (MmGdbusModemMessaging *object)
{
  MmGdbusModemMessagingSkeleton *skeleton = MM_GDBUS_MODEM_MESSAGING_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_messaging_skeleton_class_init (MmGdbusModemMessagingSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_messaging_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_messaging_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_messaging_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_messaging_skeleton_notify;


  mm_gdbus_modem_messaging_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_messaging_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_messaging_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_messaging_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_messaging_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemMessagingSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_messaging_skeleton_iface_init (MmGdbusModemMessagingIface *iface)
{
  iface->added = _mm_gdbus_modem_messaging_on_signal_added;
  iface->deleted = _mm_gdbus_modem_messaging_on_signal_deleted;
  iface->get_messages = mm_gdbus_modem_messaging_skeleton_get_messages;
  iface->get_supported_storages = mm_gdbus_modem_messaging_skeleton_get_supported_storages;
  iface->get_default_storage = mm_gdbus_modem_messaging_skeleton_get_default_storage;
}

/**
 * mm_gdbus_modem_messaging_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Messaging.top_of_page">org.freedesktop.ModemManager1.Modem.Messaging</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemMessagingSkeleton): The skeleton object.
 */
MmGdbusModemMessaging *
mm_gdbus_modem_messaging_skeleton_new (void)
{
  return MM_GDBUS_MODEM_MESSAGING (g_object_new (MM_GDBUS_TYPE_MODEM_MESSAGING_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModem3gppProfileManager
 * @title: MmGdbusModem3gppProfileManager
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_profile_manager_method_info_list_OUT_ARG_profiles =
{
  {
    -1,
    (gchar *) "profiles",
    (gchar *) "aa{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_profile_manager_method_info_list_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_profile_manager_method_info_list_OUT_ARG_profiles.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_profile_manager_method_info_list =
{
  {
    -1,
    (gchar *) "List",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_profile_manager_method_info_list_OUT_ARG_pointers,
    NULL
  },
  "handle-list",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_profile_manager_method_info_set_IN_ARG_requested_properties =
{
  {
    -1,
    (gchar *) "requested_properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_profile_manager_method_info_set_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_profile_manager_method_info_set_IN_ARG_requested_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_profile_manager_method_info_set_OUT_ARG_stored_properties =
{
  {
    -1,
    (gchar *) "stored_properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_profile_manager_method_info_set_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_profile_manager_method_info_set_OUT_ARG_stored_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_profile_manager_method_info_set =
{
  {
    -1,
    (gchar *) "Set",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_profile_manager_method_info_set_IN_ARG_pointers,
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_profile_manager_method_info_set_OUT_ARG_pointers,
    NULL
  },
  "handle-set",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_profile_manager_method_info_delete_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_profile_manager_method_info_delete_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_profile_manager_method_info_delete_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_profile_manager_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_profile_manager_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem3gpp_profile_manager_method_info_pointers[] =
{
  &_mm_gdbus_modem3gpp_profile_manager_method_info_list.parent_struct,
  &_mm_gdbus_modem3gpp_profile_manager_method_info_set.parent_struct,
  &_mm_gdbus_modem3gpp_profile_manager_method_info_delete.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem3gpp_profile_manager_signal_info_updated =
{
  {
    -1,
    (gchar *) "Updated",
    NULL,
    NULL
  },
  "updated"
};

static const GDBusSignalInfo * const _mm_gdbus_modem3gpp_profile_manager_signal_info_pointers[] =
{
  &_mm_gdbus_modem3gpp_profile_manager_signal_info_updated.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_profile_manager_property_info_index_field =
{
  {
    -1,
    (gchar *) "IndexField",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "index-field",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem3gpp_profile_manager_property_info_pointers[] =
{
  &_mm_gdbus_modem3gpp_profile_manager_property_info_index_field.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem3gpp_profile_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager",
    (GDBusMethodInfo **) &_mm_gdbus_modem3gpp_profile_manager_method_info_pointers,
    (GDBusSignalInfo **) &_mm_gdbus_modem3gpp_profile_manager_signal_info_pointers,
    (GDBusPropertyInfo **) &_mm_gdbus_modem3gpp_profile_manager_property_info_pointers,
    NULL
  },
  "modem3gpp-profile-manager",
};


/**
 * mm_gdbus_modem3gpp_profile_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem3gpp_profile_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModem3gppProfileManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem3gpp_profile_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "index-field");
  return property_id_begin - 1;
}



/**
 * MmGdbusModem3gppProfileManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager</link>.
 */

/**
 * MmGdbusModem3gppProfileManagerIface:
 * @parent_iface: The parent interface.
 * @handle_delete: Handler for the #MmGdbusModem3gppProfileManager::handle-delete signal.
 * @handle_list: Handler for the #MmGdbusModem3gppProfileManager::handle-list signal.
 * @handle_set: Handler for the #MmGdbusModem3gppProfileManager::handle-set signal.
 * @get_index_field: Getter for the #MmGdbusModem3gppProfileManager:index-field property.
 * @updated: Handler for the #MmGdbusModem3gppProfileManager::updated signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager</link>.
 */

typedef MmGdbusModem3gppProfileManagerIface MmGdbusModem3gppProfileManagerInterface;
G_DEFINE_INTERFACE (MmGdbusModem3gppProfileManager, mm_gdbus_modem3gpp_profile_manager, G_TYPE_OBJECT)

static void
mm_gdbus_modem3gpp_profile_manager_default_init (MmGdbusModem3gppProfileManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModem3gppProfileManager::handle-list:
   * @object: A #MmGdbusModem3gppProfileManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.List">List()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_profile_manager_complete_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppProfileManagerIface, handle_list),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModem3gppProfileManager::handle-set:
   * @object: A #MmGdbusModem3gppProfileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_requested_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Set">Set()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_profile_manager_complete_set() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppProfileManagerIface, handle_set),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MmGdbusModem3gppProfileManager::handle-delete:
   * @object: A #MmGdbusModem3gppProfileManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_profile_manager_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppProfileManagerIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * MmGdbusModem3gppProfileManager::updated:
   * @object: A #MmGdbusModem3gppProfileManager.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Updated">"Updated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("updated",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppProfileManagerIface, updated),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModem3gppProfileManager:index-field:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.IndexField">"IndexField"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("index-field", "IndexField", "IndexField", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem3gpp_profile_manager_get_index_field: (skip)
 * @object: A #MmGdbusModem3gppProfileManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.IndexField">"IndexField"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_profile_manager_dup_index_field() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem3gpp_profile_manager_get_index_field (MmGdbusModem3gppProfileManager *object)
{
  return MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_GET_IFACE (object)->get_index_field (object);
}

/**
 * mm_gdbus_modem3gpp_profile_manager_dup_index_field: (skip)
 * @object: A #MmGdbusModem3gppProfileManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.IndexField">"IndexField"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem3gpp_profile_manager_dup_index_field (MmGdbusModem3gppProfileManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "index-field", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_set_index_field: (skip)
 * @object: A #MmGdbusModem3gppProfileManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.IndexField">"IndexField"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_profile_manager_set_index_field (MmGdbusModem3gppProfileManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "index-field", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_profile_manager_emit_updated:
 * @object: A #MmGdbusModem3gppProfileManager.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Updated">"Updated"</link> D-Bus signal.
 */
void
mm_gdbus_modem3gpp_profile_manager_emit_updated (
    MmGdbusModem3gppProfileManager *object)
{
  g_signal_emit_by_name (object, "updated");
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_list:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.List">List()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_profile_manager_call_list_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_profile_manager_call_list_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_profile_manager_call_list (
    MmGdbusModem3gppProfileManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_list_finish:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @out_profiles: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_profile_manager_call_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_profile_manager_call_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_profile_manager_call_list_finish (
    MmGdbusModem3gppProfileManager *proxy,
    GVariant **out_profiles,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_profiles);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_list_sync:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @out_profiles: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.List">List()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_profile_manager_call_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_profile_manager_call_list_sync (
    MmGdbusModem3gppProfileManager *proxy,
    GVariant **out_profiles,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_profiles);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_set:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @arg_requested_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Set">Set()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_profile_manager_call_set_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_profile_manager_call_set_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_profile_manager_call_set (
    MmGdbusModem3gppProfileManager *proxy,
    GVariant *arg_requested_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(@a{sv})",
                   arg_requested_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_set_finish:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @out_stored_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_profile_manager_call_set().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_profile_manager_call_set().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_profile_manager_call_set_finish (
    MmGdbusModem3gppProfileManager *proxy,
    GVariant **out_stored_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_stored_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_set_sync:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @arg_requested_properties: Argument to pass with the method invocation.
 * @out_stored_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Set">Set()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_profile_manager_call_set() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_profile_manager_call_set_sync (
    MmGdbusModem3gppProfileManager *proxy,
    GVariant *arg_requested_properties,
    GVariant **out_stored_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(@a{sv})",
                   arg_requested_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_stored_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_delete:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_profile_manager_call_delete_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_profile_manager_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_profile_manager_call_delete (
    MmGdbusModem3gppProfileManager *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_delete_finish:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_profile_manager_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_profile_manager_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_profile_manager_call_delete_finish (
    MmGdbusModem3gppProfileManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_call_delete_sync:
 * @proxy: A #MmGdbusModem3gppProfileManagerProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_profile_manager_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_profile_manager_call_delete_sync (
    MmGdbusModem3gppProfileManager *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_complete_list:
 * @object: A #MmGdbusModem3gppProfileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @profiles: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.List">List()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_profile_manager_complete_list (
    MmGdbusModem3gppProfileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *profiles)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@aa{sv})",
                   profiles));
}

/**
 * mm_gdbus_modem3gpp_profile_manager_complete_set:
 * @object: A #MmGdbusModem3gppProfileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stored_properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Set">Set()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_profile_manager_complete_set (
    MmGdbusModem3gppProfileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *stored_properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   stored_properties));
}

/**
 * mm_gdbus_modem3gpp_profile_manager_complete_delete:
 * @object: A #MmGdbusModem3gppProfileManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_profile_manager_complete_delete (
    MmGdbusModem3gppProfileManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModem3gppProfileManagerProxy:
 *
 * The #MmGdbusModem3gppProfileManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModem3gppProfileManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModem3gppProfileManagerProxy.
 */

struct _MmGdbusModem3gppProfileManagerProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem3gpp_profile_manager_proxy_iface_init (MmGdbusModem3gppProfileManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppProfileManagerProxy, mm_gdbus_modem3gpp_profile_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModem3gppProfileManagerProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER, mm_gdbus_modem3gpp_profile_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppProfileManagerProxy, mm_gdbus_modem3gpp_profile_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER, mm_gdbus_modem3gpp_profile_manager_proxy_iface_init))

#endif
static void
mm_gdbus_modem3gpp_profile_manager_proxy_finalize (GObject *object)
{
  MmGdbusModem3gppProfileManagerProxy *proxy = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem3gpp_profile_manager_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem3gpp_profile_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_profile_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem3gpp_profile_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem3gpp_profile_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_profile_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem3gpp_profile_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem3gpp_profile_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem3gpp_profile_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModem3gppProfileManagerProxy *proxy = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
mm_gdbus_modem3gpp_profile_manager_proxy_get_index_field (MmGdbusModem3gppProfileManager *object)
{
  MmGdbusModem3gppProfileManagerProxy *proxy = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IndexField");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_modem3gpp_profile_manager_proxy_init (MmGdbusModem3gppProfileManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem3gpp_profile_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER_PROXY, MmGdbusModem3gppProfileManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem3gpp_profile_manager_interface_info ());
}

static void
mm_gdbus_modem3gpp_profile_manager_proxy_class_init (MmGdbusModem3gppProfileManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem3gpp_profile_manager_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem3gpp_profile_manager_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem3gpp_profile_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem3gpp_profile_manager_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem3gpp_profile_manager_proxy_g_properties_changed;

  mm_gdbus_modem3gpp_profile_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModem3gppProfileManagerProxyPrivate));
#endif
}

static void
mm_gdbus_modem3gpp_profile_manager_proxy_iface_init (MmGdbusModem3gppProfileManagerIface *iface)
{
  iface->get_index_field = mm_gdbus_modem3gpp_profile_manager_proxy_get_index_field;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_profile_manager_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_profile_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem3gpp_profile_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager", NULL);
}

/**
 * mm_gdbus_modem3gpp_profile_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_profile_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_profile_manager_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProfileManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gppProfileManager *
mm_gdbus_modem3gpp_profile_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP_PROFILE_MANAGER (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_profile_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProfileManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gppProfileManager *
mm_gdbus_modem3gpp_profile_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP_PROFILE_MANAGER (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem3gpp_profile_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager", NULL);
}

/**
 * mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProfileManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gppProfileManager *
mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP_PROFILE_MANAGER (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem3gpp_profile_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProfileManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gppProfileManager *
mm_gdbus_modem3gpp_profile_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP_PROFILE_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModem3gppProfileManagerSkeleton:
 *
 * The #MmGdbusModem3gppProfileManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModem3gppProfileManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModem3gppProfileManagerSkeleton.
 */

struct _MmGdbusModem3gppProfileManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem3gpp_profile_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem3gpp_profile_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem3gpp_profile_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem3gpp_profile_manager_skeleton_vtable =
{
  _mm_gdbus_modem3gpp_profile_manager_skeleton_handle_method_call,
  _mm_gdbus_modem3gpp_profile_manager_skeleton_handle_get_property,
  _mm_gdbus_modem3gpp_profile_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem3gpp_profile_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem3gpp_profile_manager_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem3gpp_profile_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem3gpp_profile_manager_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem3gpp_profile_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem3gpp_profile_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem3gpp_profile_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem3gpp_profile_manager_emit_changed (gpointer user_data);

static void
mm_gdbus_modem3gpp_profile_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem3gpp_profile_manager_emit_changed (skeleton);
}

static void
_mm_gdbus_modem3gpp_profile_manager_on_signal_updated (
    MmGdbusModem3gppProfileManager *object)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager", "Updated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mm_gdbus_modem3gpp_profile_manager_skeleton_iface_init (MmGdbusModem3gppProfileManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppProfileManagerSkeleton, mm_gdbus_modem3gpp_profile_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModem3gppProfileManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER, mm_gdbus_modem3gpp_profile_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppProfileManagerSkeleton, mm_gdbus_modem3gpp_profile_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER, mm_gdbus_modem3gpp_profile_manager_skeleton_iface_init))

#endif
static void
mm_gdbus_modem3gpp_profile_manager_skeleton_finalize (GObject *object)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem3gpp_profile_manager_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem3gpp_profile_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem3gpp_profile_manager_emit_changed (gpointer user_data)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem3gpp_profile_manager_schedule_emit_changed (MmGdbusModem3gppProfileManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem3gpp_profile_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem3gpp_profile_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem3gpp_profile_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem3gpp_profile_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_profile_manager_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem3gpp_profile_manager_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem3gpp_profile_manager_skeleton_init (MmGdbusModem3gppProfileManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem3gpp_profile_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER_SKELETON, MmGdbusModem3gppProfileManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
}

static const gchar *
mm_gdbus_modem3gpp_profile_manager_skeleton_get_index_field (MmGdbusModem3gppProfileManager *object)
{
  MmGdbusModem3gppProfileManagerSkeleton *skeleton = MM_GDBUS_MODEM3GPP_PROFILE_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem3gpp_profile_manager_skeleton_class_init (MmGdbusModem3gppProfileManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem3gpp_profile_manager_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem3gpp_profile_manager_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem3gpp_profile_manager_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem3gpp_profile_manager_skeleton_notify;


  mm_gdbus_modem3gpp_profile_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem3gpp_profile_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem3gpp_profile_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem3gpp_profile_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem3gpp_profile_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModem3gppProfileManagerSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem3gpp_profile_manager_skeleton_iface_init (MmGdbusModem3gppProfileManagerIface *iface)
{
  iface->updated = _mm_gdbus_modem3gpp_profile_manager_on_signal_updated;
  iface->get_index_field = mm_gdbus_modem3gpp_profile_manager_skeleton_get_index_field;
}

/**
 * mm_gdbus_modem3gpp_profile_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-ProfileManager.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.ProfileManager</link>.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProfileManagerSkeleton): The skeleton object.
 */
MmGdbusModem3gppProfileManager *
mm_gdbus_modem3gpp_profile_manager_skeleton_new (void)
{
  return MM_GDBUS_MODEM3GPP_PROFILE_MANAGER (g_object_new (MM_GDBUS_TYPE_MODEM3GPP_PROFILE_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModem3gppUssd
 * @title: MmGdbusModem3gppUssd
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_ussd_method_info_initiate_IN_ARG_command =
{
  {
    -1,
    (gchar *) "command",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_ussd_method_info_initiate_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_ussd_method_info_initiate_IN_ARG_command.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_ussd_method_info_initiate_OUT_ARG_reply =
{
  {
    -1,
    (gchar *) "reply",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_ussd_method_info_initiate_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_ussd_method_info_initiate_OUT_ARG_reply.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_ussd_method_info_initiate =
{
  {
    -1,
    (gchar *) "Initiate",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_ussd_method_info_initiate_IN_ARG_pointers,
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_ussd_method_info_initiate_OUT_ARG_pointers,
    NULL
  },
  "handle-initiate",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_ussd_method_info_respond_IN_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_ussd_method_info_respond_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_ussd_method_info_respond_IN_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_ussd_method_info_respond_OUT_ARG_reply =
{
  {
    -1,
    (gchar *) "reply",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_ussd_method_info_respond_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_ussd_method_info_respond_OUT_ARG_reply.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_ussd_method_info_respond =
{
  {
    -1,
    (gchar *) "Respond",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_ussd_method_info_respond_IN_ARG_pointers,
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_ussd_method_info_respond_OUT_ARG_pointers,
    NULL
  },
  "handle-respond",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_ussd_method_info_cancel =
{
  {
    -1,
    (gchar *) "Cancel",
    NULL,
    NULL,
    NULL
  },
  "handle-cancel",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem3gpp_ussd_method_info_pointers[] =
{
  &_mm_gdbus_modem3gpp_ussd_method_info_initiate.parent_struct,
  &_mm_gdbus_modem3gpp_ussd_method_info_respond.parent_struct,
  &_mm_gdbus_modem3gpp_ussd_method_info_cancel.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_ussd_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_ussd_property_info_network_notification =
{
  {
    -1,
    (gchar *) "NetworkNotification",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "network-notification",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_ussd_property_info_network_request =
{
  {
    -1,
    (gchar *) "NetworkRequest",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "network-request",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem3gpp_ussd_property_info_pointers[] =
{
  &_mm_gdbus_modem3gpp_ussd_property_info_state.parent_struct,
  &_mm_gdbus_modem3gpp_ussd_property_info_network_notification.parent_struct,
  &_mm_gdbus_modem3gpp_ussd_property_info_network_request.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem3gpp_ussd_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd",
    (GDBusMethodInfo **) &_mm_gdbus_modem3gpp_ussd_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_modem3gpp_ussd_property_info_pointers,
    NULL
  },
  "modem3gpp-ussd",
};


/**
 * mm_gdbus_modem3gpp_ussd_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem3gpp_ussd_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_ussd_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem3gpp_ussd_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModem3gppUssd interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem3gpp_ussd_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "network-notification");
  g_object_class_override_property (klass, property_id_begin++, "network-request");
  return property_id_begin - 1;
}



/**
 * MmGdbusModem3gppUssd:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd</link>.
 */

/**
 * MmGdbusModem3gppUssdIface:
 * @parent_iface: The parent interface.
 * @handle_cancel: Handler for the #MmGdbusModem3gppUssd::handle-cancel signal.
 * @handle_initiate: Handler for the #MmGdbusModem3gppUssd::handle-initiate signal.
 * @handle_respond: Handler for the #MmGdbusModem3gppUssd::handle-respond signal.
 * @get_network_notification: Getter for the #MmGdbusModem3gppUssd:network-notification property.
 * @get_network_request: Getter for the #MmGdbusModem3gppUssd:network-request property.
 * @get_state: Getter for the #MmGdbusModem3gppUssd:state property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd</link>.
 */

typedef MmGdbusModem3gppUssdIface MmGdbusModem3gppUssdInterface;
G_DEFINE_INTERFACE (MmGdbusModem3gppUssd, mm_gdbus_modem3gpp_ussd, G_TYPE_OBJECT)

static void
mm_gdbus_modem3gpp_ussd_default_init (MmGdbusModem3gppUssdIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModem3gppUssd::handle-initiate:
   * @object: A #MmGdbusModem3gppUssd.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_command: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Initiate">Initiate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_ussd_complete_initiate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-initiate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppUssdIface, handle_initiate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusModem3gppUssd::handle-respond:
   * @object: A #MmGdbusModem3gppUssd.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_response: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Respond">Respond()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_ussd_complete_respond() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-respond",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppUssdIface, handle_respond),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusModem3gppUssd::handle-cancel:
   * @object: A #MmGdbusModem3gppUssd.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Cancel">Cancel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_ussd_complete_cancel() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppUssdIface, handle_cancel),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModem3gppUssd:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("state", "State", "State", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gppUssd:network-notification:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.NetworkNotification">"NetworkNotification"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("network-notification", "NetworkNotification", "NetworkNotification", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gppUssd:network-request:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.NetworkRequest">"NetworkRequest"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("network-request", "NetworkRequest", "NetworkRequest", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem3gpp_ussd_get_state: (skip)
 * @object: A #MmGdbusModem3gppUssd.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem3gpp_ussd_get_state (MmGdbusModem3gppUssd *object)
{
  return MM_GDBUS_MODEM3GPP_USSD_GET_IFACE (object)->get_state (object);
}

/**
 * mm_gdbus_modem3gpp_ussd_set_state: (skip)
 * @object: A #MmGdbusModem3gppUssd.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_ussd_set_state (MmGdbusModem3gppUssd *object, guint value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_ussd_get_network_notification: (skip)
 * @object: A #MmGdbusModem3gppUssd.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.NetworkNotification">"NetworkNotification"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_ussd_dup_network_notification() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem3gpp_ussd_get_network_notification (MmGdbusModem3gppUssd *object)
{
  return MM_GDBUS_MODEM3GPP_USSD_GET_IFACE (object)->get_network_notification (object);
}

/**
 * mm_gdbus_modem3gpp_ussd_dup_network_notification: (skip)
 * @object: A #MmGdbusModem3gppUssd.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.NetworkNotification">"NetworkNotification"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem3gpp_ussd_dup_network_notification (MmGdbusModem3gppUssd *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "network-notification", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_ussd_set_network_notification: (skip)
 * @object: A #MmGdbusModem3gppUssd.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.NetworkNotification">"NetworkNotification"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_ussd_set_network_notification (MmGdbusModem3gppUssd *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "network-notification", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_ussd_get_network_request: (skip)
 * @object: A #MmGdbusModem3gppUssd.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.NetworkRequest">"NetworkRequest"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_ussd_dup_network_request() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem3gpp_ussd_get_network_request (MmGdbusModem3gppUssd *object)
{
  return MM_GDBUS_MODEM3GPP_USSD_GET_IFACE (object)->get_network_request (object);
}

/**
 * mm_gdbus_modem3gpp_ussd_dup_network_request: (skip)
 * @object: A #MmGdbusModem3gppUssd.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.NetworkRequest">"NetworkRequest"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem3gpp_ussd_dup_network_request (MmGdbusModem3gppUssd *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "network-request", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_ussd_set_network_request: (skip)
 * @object: A #MmGdbusModem3gppUssd.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.NetworkRequest">"NetworkRequest"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_ussd_set_network_request (MmGdbusModem3gppUssd *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "network-request", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_ussd_call_initiate:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @arg_command: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Initiate">Initiate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_ussd_call_initiate_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_ussd_call_initiate_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_ussd_call_initiate (
    MmGdbusModem3gppUssd *proxy,
    const gchar *arg_command,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Initiate",
    g_variant_new ("(s)",
                   arg_command),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_ussd_call_initiate_finish:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @out_reply: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_ussd_call_initiate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_ussd_call_initiate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_ussd_call_initiate_finish (
    MmGdbusModem3gppUssd *proxy,
    gchar **out_reply,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_reply);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_ussd_call_initiate_sync:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @arg_command: Argument to pass with the method invocation.
 * @out_reply: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Initiate">Initiate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_ussd_call_initiate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_ussd_call_initiate_sync (
    MmGdbusModem3gppUssd *proxy,
    const gchar *arg_command,
    gchar **out_reply,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Initiate",
    g_variant_new ("(s)",
                   arg_command),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_reply);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_ussd_call_respond:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @arg_response: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Respond">Respond()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_ussd_call_respond_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_ussd_call_respond_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_ussd_call_respond (
    MmGdbusModem3gppUssd *proxy,
    const gchar *arg_response,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Respond",
    g_variant_new ("(s)",
                   arg_response),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_ussd_call_respond_finish:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @out_reply: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_ussd_call_respond().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_ussd_call_respond().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_ussd_call_respond_finish (
    MmGdbusModem3gppUssd *proxy,
    gchar **out_reply,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_reply);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_ussd_call_respond_sync:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @arg_response: Argument to pass with the method invocation.
 * @out_reply: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Respond">Respond()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_ussd_call_respond() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_ussd_call_respond_sync (
    MmGdbusModem3gppUssd *proxy,
    const gchar *arg_response,
    gchar **out_reply,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Respond",
    g_variant_new ("(s)",
                   arg_response),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_reply);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_ussd_call_cancel:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Cancel">Cancel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_ussd_call_cancel_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_ussd_call_cancel_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_ussd_call_cancel (
    MmGdbusModem3gppUssd *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_ussd_call_cancel_finish:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_ussd_call_cancel().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_ussd_call_cancel().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_ussd_call_cancel_finish (
    MmGdbusModem3gppUssd *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_ussd_call_cancel_sync:
 * @proxy: A #MmGdbusModem3gppUssdProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Cancel">Cancel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_ussd_call_cancel() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_ussd_call_cancel_sync (
    MmGdbusModem3gppUssd *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_ussd_complete_initiate:
 * @object: A #MmGdbusModem3gppUssd.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @reply: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Initiate">Initiate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_ussd_complete_initiate (
    MmGdbusModem3gppUssd *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *reply)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   reply));
}

/**
 * mm_gdbus_modem3gpp_ussd_complete_respond:
 * @object: A #MmGdbusModem3gppUssd.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @reply: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Respond">Respond()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_ussd_complete_respond (
    MmGdbusModem3gppUssd *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *reply)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   reply));
}

/**
 * mm_gdbus_modem3gpp_ussd_complete_cancel:
 * @object: A #MmGdbusModem3gppUssd.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.Cancel">Cancel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_ussd_complete_cancel (
    MmGdbusModem3gppUssd *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModem3gppUssdProxy:
 *
 * The #MmGdbusModem3gppUssdProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModem3gppUssdProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModem3gppUssdProxy.
 */

struct _MmGdbusModem3gppUssdProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem3gpp_ussd_proxy_iface_init (MmGdbusModem3gppUssdIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppUssdProxy, mm_gdbus_modem3gpp_ussd_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModem3gppUssdProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP_USSD, mm_gdbus_modem3gpp_ussd_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppUssdProxy, mm_gdbus_modem3gpp_ussd_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP_USSD, mm_gdbus_modem3gpp_ussd_proxy_iface_init))

#endif
static void
mm_gdbus_modem3gpp_ussd_proxy_finalize (GObject *object)
{
  MmGdbusModem3gppUssdProxy *proxy = MM_GDBUS_MODEM3GPP_USSD_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem3gpp_ussd_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem3gpp_ussd_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_ussd_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem3gpp_ussd_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem3gpp_ussd_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_ussd_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem3gpp_ussd_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem3gpp_ussd_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_ussd_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM3GPP_USSD);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM3GPP_USSD);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem3gpp_ussd_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModem3gppUssdProxy *proxy = MM_GDBUS_MODEM3GPP_USSD_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_ussd_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_ussd_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
mm_gdbus_modem3gpp_ussd_proxy_get_state (MmGdbusModem3gppUssd *object)
{
  MmGdbusModem3gppUssdProxy *proxy = MM_GDBUS_MODEM3GPP_USSD_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_ussd_proxy_get_network_notification (MmGdbusModem3gppUssd *object)
{
  MmGdbusModem3gppUssdProxy *proxy = MM_GDBUS_MODEM3GPP_USSD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NetworkNotification");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_ussd_proxy_get_network_request (MmGdbusModem3gppUssd *object)
{
  MmGdbusModem3gppUssdProxy *proxy = MM_GDBUS_MODEM3GPP_USSD_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NetworkRequest");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_modem3gpp_ussd_proxy_init (MmGdbusModem3gppUssdProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem3gpp_ussd_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM3GPP_USSD_PROXY, MmGdbusModem3gppUssdProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem3gpp_ussd_interface_info ());
}

static void
mm_gdbus_modem3gpp_ussd_proxy_class_init (MmGdbusModem3gppUssdProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem3gpp_ussd_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem3gpp_ussd_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem3gpp_ussd_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem3gpp_ussd_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem3gpp_ussd_proxy_g_properties_changed;

  mm_gdbus_modem3gpp_ussd_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModem3gppUssdProxyPrivate));
#endif
}

static void
mm_gdbus_modem3gpp_ussd_proxy_iface_init (MmGdbusModem3gppUssdIface *iface)
{
  iface->get_state = mm_gdbus_modem3gpp_ussd_proxy_get_state;
  iface->get_network_notification = mm_gdbus_modem3gpp_ussd_proxy_get_network_notification;
  iface->get_network_request = mm_gdbus_modem3gpp_ussd_proxy_get_network_request;
}

/**
 * mm_gdbus_modem3gpp_ussd_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_ussd_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_ussd_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem3gpp_ussd_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM3GPP_USSD_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd", NULL);
}

/**
 * mm_gdbus_modem3gpp_ussd_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_ussd_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_ussd_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModem3gppUssdProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gppUssd *
mm_gdbus_modem3gpp_ussd_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP_USSD (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem3gpp_ussd_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_ussd_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppUssdProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gppUssd *
mm_gdbus_modem3gpp_ussd_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM3GPP_USSD_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP_USSD (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem3gpp_ussd_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem3gpp_ussd_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_ussd_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_ussd_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem3gpp_ussd_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM3GPP_USSD_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd", NULL);
}

/**
 * mm_gdbus_modem3gpp_ussd_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_ussd_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_ussd_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModem3gppUssdProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gppUssd *
mm_gdbus_modem3gpp_ussd_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP_USSD (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem3gpp_ussd_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem3gpp_ussd_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_ussd_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppUssdProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gppUssd *
mm_gdbus_modem3gpp_ussd_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM3GPP_USSD_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP_USSD (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModem3gppUssdSkeleton:
 *
 * The #MmGdbusModem3gppUssdSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModem3gppUssdSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModem3gppUssdSkeleton.
 */

struct _MmGdbusModem3gppUssdSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem3gpp_ussd_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM3GPP_USSD);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM3GPP_USSD);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem3gpp_ussd_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_ussd_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem3gpp_ussd_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_ussd_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem3gpp_ussd_skeleton_vtable =
{
  _mm_gdbus_modem3gpp_ussd_skeleton_handle_method_call,
  _mm_gdbus_modem3gpp_ussd_skeleton_handle_get_property,
  _mm_gdbus_modem3gpp_ussd_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem3gpp_ussd_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem3gpp_ussd_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem3gpp_ussd_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem3gpp_ussd_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem3gpp_ussd_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem3gpp_ussd_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem3gpp_ussd_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem3gpp_ussd_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem3gpp_ussd_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem3gpp_ussd_emit_changed (gpointer user_data);

static void
mm_gdbus_modem3gpp_ussd_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem3gpp_ussd_emit_changed (skeleton);
}

static void mm_gdbus_modem3gpp_ussd_skeleton_iface_init (MmGdbusModem3gppUssdIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppUssdSkeleton, mm_gdbus_modem3gpp_ussd_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModem3gppUssdSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP_USSD, mm_gdbus_modem3gpp_ussd_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppUssdSkeleton, mm_gdbus_modem3gpp_ussd_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP_USSD, mm_gdbus_modem3gpp_ussd_skeleton_iface_init))

#endif
static void
mm_gdbus_modem3gpp_ussd_skeleton_finalize (GObject *object)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem3gpp_ussd_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem3gpp_ussd_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem3gpp_ussd_emit_changed (gpointer user_data)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem3gpp_ussd_schedule_emit_changed (MmGdbusModem3gppUssdSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem3gpp_ussd_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem3gpp_ussd_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem3gpp_ussd_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem3gpp_ussd_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_ussd_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem3gpp_ussd_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem3gpp_ussd_skeleton_init (MmGdbusModem3gppUssdSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem3gpp_ussd_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM3GPP_USSD_SKELETON, MmGdbusModem3gppUssdSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
}

static guint 
mm_gdbus_modem3gpp_ussd_skeleton_get_state (MmGdbusModem3gppUssd *object)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_ussd_skeleton_get_network_notification (MmGdbusModem3gppUssd *object)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_ussd_skeleton_get_network_request (MmGdbusModem3gppUssd *object)
{
  MmGdbusModem3gppUssdSkeleton *skeleton = MM_GDBUS_MODEM3GPP_USSD_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem3gpp_ussd_skeleton_class_init (MmGdbusModem3gppUssdSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem3gpp_ussd_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem3gpp_ussd_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem3gpp_ussd_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem3gpp_ussd_skeleton_notify;


  mm_gdbus_modem3gpp_ussd_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem3gpp_ussd_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem3gpp_ussd_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem3gpp_ussd_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem3gpp_ussd_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModem3gppUssdSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem3gpp_ussd_skeleton_iface_init (MmGdbusModem3gppUssdIface *iface)
{
  iface->get_state = mm_gdbus_modem3gpp_ussd_skeleton_get_state;
  iface->get_network_notification = mm_gdbus_modem3gpp_ussd_skeleton_get_network_notification;
  iface->get_network_request = mm_gdbus_modem3gpp_ussd_skeleton_get_network_request;
}

/**
 * mm_gdbus_modem3gpp_ussd_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp-Ussd.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd</link>.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppUssdSkeleton): The skeleton object.
 */
MmGdbusModem3gppUssd *
mm_gdbus_modem3gpp_ussd_skeleton_new (void)
{
  return MM_GDBUS_MODEM3GPP_USSD (g_object_new (MM_GDBUS_TYPE_MODEM3GPP_USSD_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Modem3gpp
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModem3gpp
 * @title: MmGdbusModem3gpp
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Modem3gpp D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Modem3gpp ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_method_info_register_IN_ARG_operator_id =
{
  {
    -1,
    (gchar *) "operator_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_method_info_register_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_method_info_register_IN_ARG_operator_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_method_info_register =
{
  {
    -1,
    (gchar *) "Register",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_method_info_register_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_method_info_scan_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "aa{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_method_info_scan_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_method_info_scan_OUT_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_method_info_scan =
{
  {
    -1,
    (gchar *) "Scan",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_method_info_scan_OUT_ARG_pointers,
    NULL
  },
  "handle-scan",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_method_info_set_eps_ue_mode_operation_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_method_info_set_eps_ue_mode_operation_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_method_info_set_eps_ue_mode_operation_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_method_info_set_eps_ue_mode_operation =
{
  {
    -1,
    (gchar *) "SetEpsUeModeOperation",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_method_info_set_eps_ue_mode_operation_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-eps-ue-mode-operation",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_method_info_set_initial_eps_bearer_settings_IN_ARG_settings =
{
  {
    -1,
    (gchar *) "settings",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_method_info_set_initial_eps_bearer_settings_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_method_info_set_initial_eps_bearer_settings_IN_ARG_settings.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_method_info_set_initial_eps_bearer_settings =
{
  {
    -1,
    (gchar *) "SetInitialEpsBearerSettings",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_method_info_set_initial_eps_bearer_settings_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-initial-eps-bearer-settings",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_method_info_set_nr5g_registration_settings_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_method_info_set_nr5g_registration_settings_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_method_info_set_nr5g_registration_settings_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_method_info_set_nr5g_registration_settings =
{
  {
    -1,
    (gchar *) "SetNr5gRegistrationSettings",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_method_info_set_nr5g_registration_settings_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-nr5g-registration-settings",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_method_info_disable_facility_lock_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "(us)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_method_info_disable_facility_lock_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_method_info_disable_facility_lock_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_method_info_disable_facility_lock =
{
  {
    -1,
    (gchar *) "DisableFacilityLock",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_method_info_disable_facility_lock_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-disable-facility-lock",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem3gpp_method_info_set_packet_service_state_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem3gpp_method_info_set_packet_service_state_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem3gpp_method_info_set_packet_service_state_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem3gpp_method_info_set_packet_service_state =
{
  {
    -1,
    (gchar *) "SetPacketServiceState",
    (GDBusArgInfo **) &_mm_gdbus_modem3gpp_method_info_set_packet_service_state_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-packet-service-state",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem3gpp_method_info_pointers[] =
{
  &_mm_gdbus_modem3gpp_method_info_register.parent_struct,
  &_mm_gdbus_modem3gpp_method_info_scan.parent_struct,
  &_mm_gdbus_modem3gpp_method_info_set_eps_ue_mode_operation.parent_struct,
  &_mm_gdbus_modem3gpp_method_info_set_initial_eps_bearer_settings.parent_struct,
  &_mm_gdbus_modem3gpp_method_info_set_nr5g_registration_settings.parent_struct,
  &_mm_gdbus_modem3gpp_method_info_disable_facility_lock.parent_struct,
  &_mm_gdbus_modem3gpp_method_info_set_packet_service_state.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_imei =
{
  {
    -1,
    (gchar *) "Imei",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "imei",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_registration_state =
{
  {
    -1,
    (gchar *) "RegistrationState",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "registration-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_operator_code =
{
  {
    -1,
    (gchar *) "OperatorCode",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "operator-code",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_operator_name =
{
  {
    -1,
    (gchar *) "OperatorName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "operator-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_enabled_facility_locks =
{
  {
    -1,
    (gchar *) "EnabledFacilityLocks",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "enabled-facility-locks",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_subscription_state =
{
  {
    -1,
    (gchar *) "SubscriptionState",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "subscription-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_eps_ue_mode_operation =
{
  {
    -1,
    (gchar *) "EpsUeModeOperation",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "eps-ue-mode-operation",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_pco =
{
  {
    -1,
    (gchar *) "Pco",
    (gchar *) "a(ubay)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "pco",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_initial_eps_bearer =
{
  {
    -1,
    (gchar *) "InitialEpsBearer",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "initial-eps-bearer",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_initial_eps_bearer_settings =
{
  {
    -1,
    (gchar *) "InitialEpsBearerSettings",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "initial-eps-bearer-settings",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_packet_service_state =
{
  {
    -1,
    (gchar *) "PacketServiceState",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "packet-service-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem3gpp_property_info_nr5g_registration_settings =
{
  {
    -1,
    (gchar *) "Nr5gRegistrationSettings",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "nr5g-registration-settings",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem3gpp_property_info_pointers[] =
{
  &_mm_gdbus_modem3gpp_property_info_imei.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_registration_state.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_operator_code.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_operator_name.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_enabled_facility_locks.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_subscription_state.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_eps_ue_mode_operation.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_pco.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_initial_eps_bearer.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_initial_eps_bearer_settings.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_packet_service_state.parent_struct,
  &_mm_gdbus_modem3gpp_property_info_nr5g_registration_settings.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem3gpp_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Modem3gpp",
    (GDBusMethodInfo **) &_mm_gdbus_modem3gpp_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_modem3gpp_property_info_pointers,
    NULL
  },
  "modem3gpp",
};


/**
 * mm_gdbus_modem3gpp_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem3gpp_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem3gpp_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModem3gpp interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem3gpp_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "imei");
  g_object_class_override_property (klass, property_id_begin++, "registration-state");
  g_object_class_override_property (klass, property_id_begin++, "operator-code");
  g_object_class_override_property (klass, property_id_begin++, "operator-name");
  g_object_class_override_property (klass, property_id_begin++, "enabled-facility-locks");
  g_object_class_override_property (klass, property_id_begin++, "subscription-state");
  g_object_class_override_property (klass, property_id_begin++, "eps-ue-mode-operation");
  g_object_class_override_property (klass, property_id_begin++, "pco");
  g_object_class_override_property (klass, property_id_begin++, "initial-eps-bearer");
  g_object_class_override_property (klass, property_id_begin++, "initial-eps-bearer-settings");
  g_object_class_override_property (klass, property_id_begin++, "packet-service-state");
  g_object_class_override_property (klass, property_id_begin++, "nr5g-registration-settings");
  return property_id_begin - 1;
}



/**
 * MmGdbusModem3gpp:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp</link>.
 */

/**
 * MmGdbusModem3gppIface:
 * @parent_iface: The parent interface.
 * @handle_disable_facility_lock: Handler for the #MmGdbusModem3gpp::handle-disable-facility-lock signal.
 * @handle_register: Handler for the #MmGdbusModem3gpp::handle-register signal.
 * @handle_scan: Handler for the #MmGdbusModem3gpp::handle-scan signal.
 * @handle_set_eps_ue_mode_operation: Handler for the #MmGdbusModem3gpp::handle-set-eps-ue-mode-operation signal.
 * @handle_set_initial_eps_bearer_settings: Handler for the #MmGdbusModem3gpp::handle-set-initial-eps-bearer-settings signal.
 * @handle_set_nr5g_registration_settings: Handler for the #MmGdbusModem3gpp::handle-set-nr5g-registration-settings signal.
 * @handle_set_packet_service_state: Handler for the #MmGdbusModem3gpp::handle-set-packet-service-state signal.
 * @get_enabled_facility_locks: Getter for the #MmGdbusModem3gpp:enabled-facility-locks property.
 * @get_eps_ue_mode_operation: Getter for the #MmGdbusModem3gpp:eps-ue-mode-operation property.
 * @get_imei: Getter for the #MmGdbusModem3gpp:imei property.
 * @get_initial_eps_bearer: Getter for the #MmGdbusModem3gpp:initial-eps-bearer property.
 * @get_initial_eps_bearer_settings: Getter for the #MmGdbusModem3gpp:initial-eps-bearer-settings property.
 * @get_nr5g_registration_settings: Getter for the #MmGdbusModem3gpp:nr5g-registration-settings property.
 * @get_operator_code: Getter for the #MmGdbusModem3gpp:operator-code property.
 * @get_operator_name: Getter for the #MmGdbusModem3gpp:operator-name property.
 * @get_packet_service_state: Getter for the #MmGdbusModem3gpp:packet-service-state property.
 * @get_pco: Getter for the #MmGdbusModem3gpp:pco property.
 * @get_registration_state: Getter for the #MmGdbusModem3gpp:registration-state property.
 * @get_subscription_state: Getter for the #MmGdbusModem3gpp:subscription-state property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp</link>.
 */

typedef MmGdbusModem3gppIface MmGdbusModem3gppInterface;
G_DEFINE_INTERFACE (MmGdbusModem3gpp, mm_gdbus_modem3gpp, G_TYPE_OBJECT)

static void
mm_gdbus_modem3gpp_default_init (MmGdbusModem3gppIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModem3gpp::handle-register:
   * @object: A #MmGdbusModem3gpp.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_operator_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.Register">Register()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_complete_register() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppIface, handle_register),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusModem3gpp::handle-scan:
   * @object: A #MmGdbusModem3gpp.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.Scan">Scan()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_complete_scan() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-scan",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppIface, handle_scan),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModem3gpp::handle-set-eps-ue-mode-operation:
   * @object: A #MmGdbusModem3gpp.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetEpsUeModeOperation">SetEpsUeModeOperation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_complete_set_eps_ue_mode_operation() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-eps-ue-mode-operation",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppIface, handle_set_eps_ue_mode_operation),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MmGdbusModem3gpp::handle-set-initial-eps-bearer-settings:
   * @object: A #MmGdbusModem3gpp.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_settings: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetInitialEpsBearerSettings">SetInitialEpsBearerSettings()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_complete_set_initial_eps_bearer_settings() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-initial-eps-bearer-settings",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppIface, handle_set_initial_eps_bearer_settings),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MmGdbusModem3gpp::handle-set-nr5g-registration-settings:
   * @object: A #MmGdbusModem3gpp.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetNr5gRegistrationSettings">SetNr5gRegistrationSettings()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_complete_set_nr5g_registration_settings() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-nr5g-registration-settings",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppIface, handle_set_nr5g_registration_settings),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MmGdbusModem3gpp::handle-disable-facility-lock:
   * @object: A #MmGdbusModem3gpp.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.DisableFacilityLock">DisableFacilityLock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_complete_disable_facility_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable-facility-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppIface, handle_disable_facility_lock),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MmGdbusModem3gpp::handle-set-packet-service-state:
   * @object: A #MmGdbusModem3gpp.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetPacketServiceState">SetPacketServiceState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem3gpp_complete_set_packet_service_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-packet-service-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModem3gppIface, handle_set_packet_service_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModem3gpp:imei:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Imei">"Imei"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("imei", "Imei", "Imei", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:registration-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.RegistrationState">"RegistrationState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("registration-state", "RegistrationState", "RegistrationState", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:operator-code:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.OperatorCode">"OperatorCode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("operator-code", "OperatorCode", "OperatorCode", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:operator-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.OperatorName">"OperatorName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("operator-name", "OperatorName", "OperatorName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:enabled-facility-locks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.EnabledFacilityLocks">"EnabledFacilityLocks"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("enabled-facility-locks", "EnabledFacilityLocks", "EnabledFacilityLocks", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:subscription-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.SubscriptionState">"SubscriptionState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("subscription-state", "SubscriptionState", "SubscriptionState", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:eps-ue-mode-operation:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.EpsUeModeOperation">"EpsUeModeOperation"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("eps-ue-mode-operation", "EpsUeModeOperation", "EpsUeModeOperation", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:pco:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Pco">"Pco"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("pco", "Pco", "Pco", G_VARIANT_TYPE ("a(ubay)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:initial-eps-bearer:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.InitialEpsBearer">"InitialEpsBearer"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("initial-eps-bearer", "InitialEpsBearer", "InitialEpsBearer", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:initial-eps-bearer-settings:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.InitialEpsBearerSettings">"InitialEpsBearerSettings"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("initial-eps-bearer-settings", "InitialEpsBearerSettings", "InitialEpsBearerSettings", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:packet-service-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.PacketServiceState">"PacketServiceState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("packet-service-state", "PacketServiceState", "PacketServiceState", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModem3gpp:nr5g-registration-settings:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Nr5gRegistrationSettings">"Nr5gRegistrationSettings"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("nr5g-registration-settings", "Nr5gRegistrationSettings", "Nr5gRegistrationSettings", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem3gpp_get_imei: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Imei">"Imei"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_dup_imei() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem3gpp_get_imei (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_imei (object);
}

/**
 * mm_gdbus_modem3gpp_dup_imei: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Imei">"Imei"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem3gpp_dup_imei (MmGdbusModem3gpp *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "imei", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_set_imei: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Imei">"Imei"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_imei (MmGdbusModem3gpp *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "imei", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_registration_state: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.RegistrationState">"RegistrationState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem3gpp_get_registration_state (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_registration_state (object);
}

/**
 * mm_gdbus_modem3gpp_set_registration_state: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.RegistrationState">"RegistrationState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_registration_state (MmGdbusModem3gpp *object, guint value)
{
  g_object_set (G_OBJECT (object), "registration-state", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_operator_code: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.OperatorCode">"OperatorCode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_dup_operator_code() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem3gpp_get_operator_code (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_operator_code (object);
}

/**
 * mm_gdbus_modem3gpp_dup_operator_code: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.OperatorCode">"OperatorCode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem3gpp_dup_operator_code (MmGdbusModem3gpp *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "operator-code", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_set_operator_code: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.OperatorCode">"OperatorCode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_operator_code (MmGdbusModem3gpp *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "operator-code", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_operator_name: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.OperatorName">"OperatorName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_dup_operator_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem3gpp_get_operator_name (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_operator_name (object);
}

/**
 * mm_gdbus_modem3gpp_dup_operator_name: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.OperatorName">"OperatorName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem3gpp_dup_operator_name (MmGdbusModem3gpp *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "operator-name", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_set_operator_name: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.OperatorName">"OperatorName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_operator_name (MmGdbusModem3gpp *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "operator-name", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_enabled_facility_locks: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.EnabledFacilityLocks">"EnabledFacilityLocks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem3gpp_get_enabled_facility_locks (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_enabled_facility_locks (object);
}

/**
 * mm_gdbus_modem3gpp_set_enabled_facility_locks: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.EnabledFacilityLocks">"EnabledFacilityLocks"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_enabled_facility_locks (MmGdbusModem3gpp *object, guint value)
{
  g_object_set (G_OBJECT (object), "enabled-facility-locks", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_subscription_state: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.SubscriptionState">"SubscriptionState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem3gpp_get_subscription_state (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_subscription_state (object);
}

/**
 * mm_gdbus_modem3gpp_set_subscription_state: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.SubscriptionState">"SubscriptionState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_subscription_state (MmGdbusModem3gpp *object, guint value)
{
  g_object_set (G_OBJECT (object), "subscription-state", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_eps_ue_mode_operation: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.EpsUeModeOperation">"EpsUeModeOperation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem3gpp_get_eps_ue_mode_operation (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_eps_ue_mode_operation (object);
}

/**
 * mm_gdbus_modem3gpp_set_eps_ue_mode_operation: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.EpsUeModeOperation">"EpsUeModeOperation"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_eps_ue_mode_operation (MmGdbusModem3gpp *object, guint value)
{
  g_object_set (G_OBJECT (object), "eps-ue-mode-operation", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_pco: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Pco">"Pco"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_dup_pco() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem3gpp_get_pco (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_pco (object);
}

/**
 * mm_gdbus_modem3gpp_dup_pco: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Pco">"Pco"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem3gpp_dup_pco (MmGdbusModem3gpp *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "pco", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_set_pco: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Pco">"Pco"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_pco (MmGdbusModem3gpp *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "pco", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_initial_eps_bearer: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.InitialEpsBearer">"InitialEpsBearer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_dup_initial_eps_bearer() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem3gpp_get_initial_eps_bearer (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_initial_eps_bearer (object);
}

/**
 * mm_gdbus_modem3gpp_dup_initial_eps_bearer: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.InitialEpsBearer">"InitialEpsBearer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem3gpp_dup_initial_eps_bearer (MmGdbusModem3gpp *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "initial-eps-bearer", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_set_initial_eps_bearer: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.InitialEpsBearer">"InitialEpsBearer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_initial_eps_bearer (MmGdbusModem3gpp *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "initial-eps-bearer", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_initial_eps_bearer_settings: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.InitialEpsBearerSettings">"InitialEpsBearerSettings"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_dup_initial_eps_bearer_settings() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem3gpp_get_initial_eps_bearer_settings (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_initial_eps_bearer_settings (object);
}

/**
 * mm_gdbus_modem3gpp_dup_initial_eps_bearer_settings: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.InitialEpsBearerSettings">"InitialEpsBearerSettings"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem3gpp_dup_initial_eps_bearer_settings (MmGdbusModem3gpp *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "initial-eps-bearer-settings", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_set_initial_eps_bearer_settings: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.InitialEpsBearerSettings">"InitialEpsBearerSettings"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_initial_eps_bearer_settings (MmGdbusModem3gpp *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "initial-eps-bearer-settings", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_packet_service_state: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.PacketServiceState">"PacketServiceState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem3gpp_get_packet_service_state (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_packet_service_state (object);
}

/**
 * mm_gdbus_modem3gpp_set_packet_service_state: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.PacketServiceState">"PacketServiceState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_packet_service_state (MmGdbusModem3gpp *object, guint value)
{
  g_object_set (G_OBJECT (object), "packet-service-state", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_get_nr5g_registration_settings: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Nr5gRegistrationSettings">"Nr5gRegistrationSettings"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem3gpp_dup_nr5g_registration_settings() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem3gpp_get_nr5g_registration_settings (MmGdbusModem3gpp *object)
{
  return MM_GDBUS_MODEM3GPP_GET_IFACE (object)->get_nr5g_registration_settings (object);
}

/**
 * mm_gdbus_modem3gpp_dup_nr5g_registration_settings: (skip)
 * @object: A #MmGdbusModem3gpp.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Nr5gRegistrationSettings">"Nr5gRegistrationSettings"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem3gpp_dup_nr5g_registration_settings (MmGdbusModem3gpp *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "nr5g-registration-settings", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem3gpp_set_nr5g_registration_settings: (skip)
 * @object: A #MmGdbusModem3gpp.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Modem3gpp.Nr5gRegistrationSettings">"Nr5gRegistrationSettings"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem3gpp_set_nr5g_registration_settings (MmGdbusModem3gpp *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "nr5g-registration-settings", value, NULL);
}

/**
 * mm_gdbus_modem3gpp_call_register:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_operator_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.Register">Register()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_call_register_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_call_register_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_call_register (
    MmGdbusModem3gpp *proxy,
    const gchar *arg_operator_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Register",
    g_variant_new ("(s)",
                   arg_operator_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_call_register_finish:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_call_register().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_call_register().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_register_finish (
    MmGdbusModem3gpp *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_register_sync:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_operator_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.Register">Register()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_call_register() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_register_sync (
    MmGdbusModem3gpp *proxy,
    const gchar *arg_operator_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Register",
    g_variant_new ("(s)",
                   arg_operator_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_scan:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.Scan">Scan()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_call_scan_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_call_scan_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_call_scan (
    MmGdbusModem3gpp *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Scan",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_call_scan_finish:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_call_scan().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_call_scan().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_scan_finish (
    MmGdbusModem3gpp *proxy,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_scan_sync:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.Scan">Scan()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_call_scan() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_scan_sync (
    MmGdbusModem3gpp *proxy,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Scan",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetEpsUeModeOperation">SetEpsUeModeOperation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation (
    MmGdbusModem3gpp *proxy,
    guint arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEpsUeModeOperation",
    g_variant_new ("(u)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation_finish:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation_finish (
    MmGdbusModem3gpp *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation_sync:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetEpsUeModeOperation">SetEpsUeModeOperation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_set_eps_ue_mode_operation_sync (
    MmGdbusModem3gpp *proxy,
    guint arg_mode,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEpsUeModeOperation",
    g_variant_new ("(u)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_settings: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetInitialEpsBearerSettings">SetInitialEpsBearerSettings()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings (
    MmGdbusModem3gpp *proxy,
    GVariant *arg_settings,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetInitialEpsBearerSettings",
    g_variant_new ("(@a{sv})",
                   arg_settings),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings_finish:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings_finish (
    MmGdbusModem3gpp *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings_sync:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_settings: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetInitialEpsBearerSettings">SetInitialEpsBearerSettings()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_set_initial_eps_bearer_settings_sync (
    MmGdbusModem3gpp *proxy,
    GVariant *arg_settings,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetInitialEpsBearerSettings",
    g_variant_new ("(@a{sv})",
                   arg_settings),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_set_nr5g_registration_settings:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetNr5gRegistrationSettings">SetNr5gRegistrationSettings()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_call_set_nr5g_registration_settings_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_call_set_nr5g_registration_settings_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_call_set_nr5g_registration_settings (
    MmGdbusModem3gpp *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetNr5gRegistrationSettings",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_call_set_nr5g_registration_settings_finish:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_call_set_nr5g_registration_settings().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_call_set_nr5g_registration_settings().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_set_nr5g_registration_settings_finish (
    MmGdbusModem3gpp *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_set_nr5g_registration_settings_sync:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetNr5gRegistrationSettings">SetNr5gRegistrationSettings()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_call_set_nr5g_registration_settings() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_set_nr5g_registration_settings_sync (
    MmGdbusModem3gpp *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetNr5gRegistrationSettings",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_disable_facility_lock:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.DisableFacilityLock">DisableFacilityLock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_call_disable_facility_lock_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_call_disable_facility_lock_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_call_disable_facility_lock (
    MmGdbusModem3gpp *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisableFacilityLock",
    g_variant_new ("(@(us))",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_call_disable_facility_lock_finish:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_call_disable_facility_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_call_disable_facility_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_disable_facility_lock_finish (
    MmGdbusModem3gpp *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_disable_facility_lock_sync:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.DisableFacilityLock">DisableFacilityLock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_call_disable_facility_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_disable_facility_lock_sync (
    MmGdbusModem3gpp *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisableFacilityLock",
    g_variant_new ("(@(us))",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_set_packet_service_state:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetPacketServiceState">SetPacketServiceState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_call_set_packet_service_state_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_call_set_packet_service_state_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem3gpp_call_set_packet_service_state (
    MmGdbusModem3gpp *proxy,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPacketServiceState",
    g_variant_new ("(u)",
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem3gpp_call_set_packet_service_state_finish:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_call_set_packet_service_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_call_set_packet_service_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_set_packet_service_state_finish (
    MmGdbusModem3gpp *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_call_set_packet_service_state_sync:
 * @proxy: A #MmGdbusModem3gppProxy.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetPacketServiceState">SetPacketServiceState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_call_set_packet_service_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem3gpp_call_set_packet_service_state_sync (
    MmGdbusModem3gpp *proxy,
    guint arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPacketServiceState",
    g_variant_new ("(u)",
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem3gpp_complete_register:
 * @object: A #MmGdbusModem3gpp.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.Register">Register()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_complete_register (
    MmGdbusModem3gpp *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem3gpp_complete_scan:
 * @object: A #MmGdbusModem3gpp.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.Scan">Scan()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_complete_scan (
    MmGdbusModem3gpp *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@aa{sv})",
                   results));
}

/**
 * mm_gdbus_modem3gpp_complete_set_eps_ue_mode_operation:
 * @object: A #MmGdbusModem3gpp.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetEpsUeModeOperation">SetEpsUeModeOperation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_complete_set_eps_ue_mode_operation (
    MmGdbusModem3gpp *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem3gpp_complete_set_initial_eps_bearer_settings:
 * @object: A #MmGdbusModem3gpp.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetInitialEpsBearerSettings">SetInitialEpsBearerSettings()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_complete_set_initial_eps_bearer_settings (
    MmGdbusModem3gpp *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem3gpp_complete_set_nr5g_registration_settings:
 * @object: A #MmGdbusModem3gpp.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetNr5gRegistrationSettings">SetNr5gRegistrationSettings()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_complete_set_nr5g_registration_settings (
    MmGdbusModem3gpp *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem3gpp_complete_disable_facility_lock:
 * @object: A #MmGdbusModem3gpp.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.DisableFacilityLock">DisableFacilityLock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_complete_disable_facility_lock (
    MmGdbusModem3gpp *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem3gpp_complete_set_packet_service_state:
 * @object: A #MmGdbusModem3gpp.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Modem3gpp.SetPacketServiceState">SetPacketServiceState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem3gpp_complete_set_packet_service_state (
    MmGdbusModem3gpp *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModem3gppProxy:
 *
 * The #MmGdbusModem3gppProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModem3gppProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModem3gppProxy.
 */

struct _MmGdbusModem3gppProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem3gpp_proxy_iface_init (MmGdbusModem3gppIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppProxy, mm_gdbus_modem3gpp_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModem3gppProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP, mm_gdbus_modem3gpp_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppProxy, mm_gdbus_modem3gpp_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP, mm_gdbus_modem3gpp_proxy_iface_init))

#endif
static void
mm_gdbus_modem3gpp_proxy_finalize (GObject *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem3gpp_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem3gpp_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 12);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem3gpp_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Modem3gpp: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem3gpp_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 12);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Modem3gpp", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem3gpp_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem3gpp_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM3GPP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM3GPP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem3gpp_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
mm_gdbus_modem3gpp_proxy_get_imei (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Imei");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem3gpp_proxy_get_registration_state (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RegistrationState");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_proxy_get_operator_code (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OperatorCode");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_proxy_get_operator_name (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OperatorName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem3gpp_proxy_get_enabled_facility_locks (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EnabledFacilityLocks");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem3gpp_proxy_get_subscription_state (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SubscriptionState");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem3gpp_proxy_get_eps_ue_mode_operation (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EpsUeModeOperation");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_modem3gpp_proxy_get_pco (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Pco");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_proxy_get_initial_eps_bearer (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitialEpsBearer");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_modem3gpp_proxy_get_initial_eps_bearer_settings (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InitialEpsBearerSettings");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static guint 
mm_gdbus_modem3gpp_proxy_get_packet_service_state (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PacketServiceState");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_modem3gpp_proxy_get_nr5g_registration_settings (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppProxy *proxy = MM_GDBUS_MODEM3GPP_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Nr5gRegistrationSettings");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
mm_gdbus_modem3gpp_proxy_init (MmGdbusModem3gppProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem3gpp_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM3GPP_PROXY, MmGdbusModem3gppProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem3gpp_interface_info ());
}

static void
mm_gdbus_modem3gpp_proxy_class_init (MmGdbusModem3gppProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem3gpp_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem3gpp_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem3gpp_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem3gpp_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem3gpp_proxy_g_properties_changed;

  mm_gdbus_modem3gpp_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModem3gppProxyPrivate));
#endif
}

static void
mm_gdbus_modem3gpp_proxy_iface_init (MmGdbusModem3gppIface *iface)
{
  iface->get_imei = mm_gdbus_modem3gpp_proxy_get_imei;
  iface->get_registration_state = mm_gdbus_modem3gpp_proxy_get_registration_state;
  iface->get_operator_code = mm_gdbus_modem3gpp_proxy_get_operator_code;
  iface->get_operator_name = mm_gdbus_modem3gpp_proxy_get_operator_name;
  iface->get_enabled_facility_locks = mm_gdbus_modem3gpp_proxy_get_enabled_facility_locks;
  iface->get_subscription_state = mm_gdbus_modem3gpp_proxy_get_subscription_state;
  iface->get_eps_ue_mode_operation = mm_gdbus_modem3gpp_proxy_get_eps_ue_mode_operation;
  iface->get_pco = mm_gdbus_modem3gpp_proxy_get_pco;
  iface->get_initial_eps_bearer = mm_gdbus_modem3gpp_proxy_get_initial_eps_bearer;
  iface->get_initial_eps_bearer_settings = mm_gdbus_modem3gpp_proxy_get_initial_eps_bearer_settings;
  iface->get_packet_service_state = mm_gdbus_modem3gpp_proxy_get_packet_service_state;
  iface->get_nr5g_registration_settings = mm_gdbus_modem3gpp_proxy_get_nr5g_registration_settings;
}

/**
 * mm_gdbus_modem3gpp_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem3gpp_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM3GPP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp", NULL);
}

/**
 * mm_gdbus_modem3gpp_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gpp *
mm_gdbus_modem3gpp_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem3gpp_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gpp *
mm_gdbus_modem3gpp_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM3GPP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem3gpp_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem3gpp_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem3gpp_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem3gpp_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem3gpp_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM3GPP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp", NULL);
}

/**
 * mm_gdbus_modem3gpp_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem3gpp_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem3gpp_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gpp *
mm_gdbus_modem3gpp_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem3gpp_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem3gpp_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem3gpp_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModem3gpp *
mm_gdbus_modem3gpp_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM3GPP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Modem3gpp", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM3GPP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModem3gppSkeleton:
 *
 * The #MmGdbusModem3gppSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModem3gppSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModem3gppSkeleton.
 */

struct _MmGdbusModem3gppSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem3gpp_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM3GPP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM3GPP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem3gpp_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem3gpp_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem3gpp_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem3gpp_skeleton_vtable =
{
  _mm_gdbus_modem3gpp_skeleton_handle_method_call,
  _mm_gdbus_modem3gpp_skeleton_handle_get_property,
  _mm_gdbus_modem3gpp_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem3gpp_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem3gpp_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem3gpp_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem3gpp_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem3gpp_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem3gpp_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem3gpp_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem3gpp_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem3gpp_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Modem3gpp", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem3gpp_emit_changed (gpointer user_data);

static void
mm_gdbus_modem3gpp_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem3gpp_emit_changed (skeleton);
}

static void mm_gdbus_modem3gpp_skeleton_iface_init (MmGdbusModem3gppIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppSkeleton, mm_gdbus_modem3gpp_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModem3gppSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP, mm_gdbus_modem3gpp_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModem3gppSkeleton, mm_gdbus_modem3gpp_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM3GPP, mm_gdbus_modem3gpp_skeleton_iface_init))

#endif
static void
mm_gdbus_modem3gpp_skeleton_finalize (GObject *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  guint n;
  for (n = 0; n < 12; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem3gpp_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem3gpp_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 12);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem3gpp_emit_changed (gpointer user_data)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Modem3gpp",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem3gpp_schedule_emit_changed (MmGdbusModem3gppSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem3gpp_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem3gpp_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem3gpp_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem3gpp_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 12);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem3gpp_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem3gpp_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem3gpp_skeleton_init (MmGdbusModem3gppSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem3gpp_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM3GPP_SKELETON, MmGdbusModem3gppSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 12);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_VARIANT);
}

static const gchar *
mm_gdbus_modem3gpp_skeleton_get_imei (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem3gpp_skeleton_get_registration_state (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_skeleton_get_operator_code (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_skeleton_get_operator_name (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem3gpp_skeleton_get_enabled_facility_locks (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem3gpp_skeleton_get_subscription_state (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem3gpp_skeleton_get_eps_ue_mode_operation (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem3gpp_skeleton_get_pco (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_modem3gpp_skeleton_get_initial_eps_bearer (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem3gpp_skeleton_get_initial_eps_bearer_settings (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem3gpp_skeleton_get_packet_service_state (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem3gpp_skeleton_get_nr5g_registration_settings (MmGdbusModem3gpp *object)
{
  MmGdbusModem3gppSkeleton *skeleton = MM_GDBUS_MODEM3GPP_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem3gpp_skeleton_class_init (MmGdbusModem3gppSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem3gpp_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem3gpp_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem3gpp_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem3gpp_skeleton_notify;


  mm_gdbus_modem3gpp_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem3gpp_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem3gpp_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem3gpp_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem3gpp_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModem3gppSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem3gpp_skeleton_iface_init (MmGdbusModem3gppIface *iface)
{
  iface->get_imei = mm_gdbus_modem3gpp_skeleton_get_imei;
  iface->get_registration_state = mm_gdbus_modem3gpp_skeleton_get_registration_state;
  iface->get_operator_code = mm_gdbus_modem3gpp_skeleton_get_operator_code;
  iface->get_operator_name = mm_gdbus_modem3gpp_skeleton_get_operator_name;
  iface->get_enabled_facility_locks = mm_gdbus_modem3gpp_skeleton_get_enabled_facility_locks;
  iface->get_subscription_state = mm_gdbus_modem3gpp_skeleton_get_subscription_state;
  iface->get_eps_ue_mode_operation = mm_gdbus_modem3gpp_skeleton_get_eps_ue_mode_operation;
  iface->get_pco = mm_gdbus_modem3gpp_skeleton_get_pco;
  iface->get_initial_eps_bearer = mm_gdbus_modem3gpp_skeleton_get_initial_eps_bearer;
  iface->get_initial_eps_bearer_settings = mm_gdbus_modem3gpp_skeleton_get_initial_eps_bearer_settings;
  iface->get_packet_service_state = mm_gdbus_modem3gpp_skeleton_get_packet_service_state;
  iface->get_nr5g_registration_settings = mm_gdbus_modem3gpp_skeleton_get_nr5g_registration_settings;
}

/**
 * mm_gdbus_modem3gpp_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Modem3gpp.top_of_page">org.freedesktop.ModemManager1.Modem.Modem3gpp</link>.
 *
 * Returns: (transfer full) (type MmGdbusModem3gppSkeleton): The skeleton object.
 */
MmGdbusModem3gpp *
mm_gdbus_modem3gpp_skeleton_new (void)
{
  return MM_GDBUS_MODEM3GPP (g_object_new (MM_GDBUS_TYPE_MODEM3GPP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.ModemCdma
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemCdma
 * @title: MmGdbusModemCdma
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.ModemCdma D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-ModemCdma.top_of_page">org.freedesktop.ModemManager1.Modem.ModemCdma</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.ModemCdma ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_cdma_method_info_activate_IN_ARG_carrier_code =
{
  {
    -1,
    (gchar *) "carrier_code",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_cdma_method_info_activate_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_cdma_method_info_activate_IN_ARG_carrier_code.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_cdma_method_info_activate =
{
  {
    -1,
    (gchar *) "Activate",
    (GDBusArgInfo **) &_mm_gdbus_modem_cdma_method_info_activate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-activate",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_cdma_method_info_activate_manual_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_cdma_method_info_activate_manual_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_cdma_method_info_activate_manual_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_cdma_method_info_activate_manual =
{
  {
    -1,
    (gchar *) "ActivateManual",
    (GDBusArgInfo **) &_mm_gdbus_modem_cdma_method_info_activate_manual_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-activate-manual",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_cdma_method_info_pointers[] =
{
  &_mm_gdbus_modem_cdma_method_info_activate.parent_struct,
  &_mm_gdbus_modem_cdma_method_info_activate_manual.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_cdma_signal_info_activation_state_changed_ARG_activation_state =
{
  {
    -1,
    (gchar *) "activation_state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_cdma_signal_info_activation_state_changed_ARG_activation_error =
{
  {
    -1,
    (gchar *) "activation_error",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_cdma_signal_info_activation_state_changed_ARG_status_changes =
{
  {
    -1,
    (gchar *) "status_changes",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_cdma_signal_info_activation_state_changed_ARG_pointers[] =
{
  &_mm_gdbus_modem_cdma_signal_info_activation_state_changed_ARG_activation_state.parent_struct,
  &_mm_gdbus_modem_cdma_signal_info_activation_state_changed_ARG_activation_error.parent_struct,
  &_mm_gdbus_modem_cdma_signal_info_activation_state_changed_ARG_status_changes.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem_cdma_signal_info_activation_state_changed =
{
  {
    -1,
    (gchar *) "ActivationStateChanged",
    (GDBusArgInfo **) &_mm_gdbus_modem_cdma_signal_info_activation_state_changed_ARG_pointers,
    NULL
  },
  "activation-state-changed"
};

static const GDBusSignalInfo * const _mm_gdbus_modem_cdma_signal_info_pointers[] =
{
  &_mm_gdbus_modem_cdma_signal_info_activation_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_cdma_property_info_activation_state =
{
  {
    -1,
    (gchar *) "ActivationState",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "activation-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_cdma_property_info_meid =
{
  {
    -1,
    (gchar *) "Meid",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "meid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_cdma_property_info_esn =
{
  {
    -1,
    (gchar *) "Esn",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "esn",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_cdma_property_info_sid =
{
  {
    -1,
    (gchar *) "Sid",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_cdma_property_info_nid =
{
  {
    -1,
    (gchar *) "Nid",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "nid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_cdma_property_info_cdma1x_registration_state =
{
  {
    -1,
    (gchar *) "Cdma1xRegistrationState",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "cdma1x-registration-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_cdma_property_info_evdo_registration_state =
{
  {
    -1,
    (gchar *) "EvdoRegistrationState",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "evdo-registration-state",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_cdma_property_info_pointers[] =
{
  &_mm_gdbus_modem_cdma_property_info_activation_state.parent_struct,
  &_mm_gdbus_modem_cdma_property_info_meid.parent_struct,
  &_mm_gdbus_modem_cdma_property_info_esn.parent_struct,
  &_mm_gdbus_modem_cdma_property_info_sid.parent_struct,
  &_mm_gdbus_modem_cdma_property_info_nid.parent_struct,
  &_mm_gdbus_modem_cdma_property_info_cdma1x_registration_state.parent_struct,
  &_mm_gdbus_modem_cdma_property_info_evdo_registration_state.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_cdma_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.ModemCdma",
    (GDBusMethodInfo **) &_mm_gdbus_modem_cdma_method_info_pointers,
    (GDBusSignalInfo **) &_mm_gdbus_modem_cdma_signal_info_pointers,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_cdma_property_info_pointers,
    NULL
  },
  "modem-cdma",
};


/**
 * mm_gdbus_modem_cdma_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-ModemCdma.top_of_page">org.freedesktop.ModemManager1.Modem.ModemCdma</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_cdma_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_cdma_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_cdma_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemCdma interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_cdma_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "activation-state");
  g_object_class_override_property (klass, property_id_begin++, "meid");
  g_object_class_override_property (klass, property_id_begin++, "esn");
  g_object_class_override_property (klass, property_id_begin++, "sid");
  g_object_class_override_property (klass, property_id_begin++, "nid");
  g_object_class_override_property (klass, property_id_begin++, "cdma1x-registration-state");
  g_object_class_override_property (klass, property_id_begin++, "evdo-registration-state");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemCdma:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-ModemCdma.top_of_page">org.freedesktop.ModemManager1.Modem.ModemCdma</link>.
 */

/**
 * MmGdbusModemCdmaIface:
 * @parent_iface: The parent interface.
 * @handle_activate: Handler for the #MmGdbusModemCdma::handle-activate signal.
 * @handle_activate_manual: Handler for the #MmGdbusModemCdma::handle-activate-manual signal.
 * @get_activation_state: Getter for the #MmGdbusModemCdma:activation-state property.
 * @get_cdma1x_registration_state: Getter for the #MmGdbusModemCdma:cdma1x-registration-state property.
 * @get_esn: Getter for the #MmGdbusModemCdma:esn property.
 * @get_evdo_registration_state: Getter for the #MmGdbusModemCdma:evdo-registration-state property.
 * @get_meid: Getter for the #MmGdbusModemCdma:meid property.
 * @get_nid: Getter for the #MmGdbusModemCdma:nid property.
 * @get_sid: Getter for the #MmGdbusModemCdma:sid property.
 * @activation_state_changed: Handler for the #MmGdbusModemCdma::activation-state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-ModemCdma.top_of_page">org.freedesktop.ModemManager1.Modem.ModemCdma</link>.
 */

typedef MmGdbusModemCdmaIface MmGdbusModemCdmaInterface;
G_DEFINE_INTERFACE (MmGdbusModemCdma, mm_gdbus_modem_cdma, G_TYPE_OBJECT)

static void
mm_gdbus_modem_cdma_default_init (MmGdbusModemCdmaIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemCdma::handle-activate:
   * @object: A #MmGdbusModemCdma.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_carrier_code: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-ModemCdma.Activate">Activate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_cdma_complete_activate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemCdmaIface, handle_activate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusModemCdma::handle-activate-manual:
   * @object: A #MmGdbusModemCdma.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivateManual">ActivateManual()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_cdma_complete_activate_manual() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate-manual",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemCdmaIface, handle_activate_manual),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * MmGdbusModemCdma::activation-state-changed:
   * @object: A #MmGdbusModemCdma.
   * @arg_activation_state: Argument.
   * @arg_activation_error: Argument.
   * @arg_status_changes: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivationStateChanged">"ActivationStateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("activation-state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemCdmaIface, activation_state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemCdma:activation-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivationState">"ActivationState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("activation-state", "ActivationState", "ActivationState", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemCdma:meid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Meid">"Meid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("meid", "Meid", "Meid", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemCdma:esn:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Esn">"Esn"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("esn", "Esn", "Esn", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemCdma:sid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Sid">"Sid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("sid", "Sid", "Sid", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemCdma:nid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Nid">"Nid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("nid", "Nid", "Nid", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemCdma:cdma1x-registration-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Cdma1xRegistrationState">"Cdma1xRegistrationState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("cdma1x-registration-state", "Cdma1xRegistrationState", "Cdma1xRegistrationState", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemCdma:evdo-registration-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.EvdoRegistrationState">"EvdoRegistrationState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("evdo-registration-state", "EvdoRegistrationState", "EvdoRegistrationState", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_cdma_get_activation_state: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivationState">"ActivationState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_cdma_get_activation_state (MmGdbusModemCdma *object)
{
  return MM_GDBUS_MODEM_CDMA_GET_IFACE (object)->get_activation_state (object);
}

/**
 * mm_gdbus_modem_cdma_set_activation_state: (skip)
 * @object: A #MmGdbusModemCdma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivationState">"ActivationState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_cdma_set_activation_state (MmGdbusModemCdma *object, guint value)
{
  g_object_set (G_OBJECT (object), "activation-state", value, NULL);
}

/**
 * mm_gdbus_modem_cdma_get_meid: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Meid">"Meid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_cdma_dup_meid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem_cdma_get_meid (MmGdbusModemCdma *object)
{
  return MM_GDBUS_MODEM_CDMA_GET_IFACE (object)->get_meid (object);
}

/**
 * mm_gdbus_modem_cdma_dup_meid: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Meid">"Meid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem_cdma_dup_meid (MmGdbusModemCdma *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "meid", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_cdma_set_meid: (skip)
 * @object: A #MmGdbusModemCdma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Meid">"Meid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_cdma_set_meid (MmGdbusModemCdma *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "meid", value, NULL);
}

/**
 * mm_gdbus_modem_cdma_get_esn: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Esn">"Esn"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_cdma_dup_esn() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_modem_cdma_get_esn (MmGdbusModemCdma *object)
{
  return MM_GDBUS_MODEM_CDMA_GET_IFACE (object)->get_esn (object);
}

/**
 * mm_gdbus_modem_cdma_dup_esn: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Esn">"Esn"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_modem_cdma_dup_esn (MmGdbusModemCdma *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "esn", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_cdma_set_esn: (skip)
 * @object: A #MmGdbusModemCdma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Esn">"Esn"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_cdma_set_esn (MmGdbusModemCdma *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "esn", value, NULL);
}

/**
 * mm_gdbus_modem_cdma_get_sid: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Sid">"Sid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_cdma_get_sid (MmGdbusModemCdma *object)
{
  return MM_GDBUS_MODEM_CDMA_GET_IFACE (object)->get_sid (object);
}

/**
 * mm_gdbus_modem_cdma_set_sid: (skip)
 * @object: A #MmGdbusModemCdma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Sid">"Sid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_cdma_set_sid (MmGdbusModemCdma *object, guint value)
{
  g_object_set (G_OBJECT (object), "sid", value, NULL);
}

/**
 * mm_gdbus_modem_cdma_get_nid: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Nid">"Nid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_cdma_get_nid (MmGdbusModemCdma *object)
{
  return MM_GDBUS_MODEM_CDMA_GET_IFACE (object)->get_nid (object);
}

/**
 * mm_gdbus_modem_cdma_set_nid: (skip)
 * @object: A #MmGdbusModemCdma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Nid">"Nid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_cdma_set_nid (MmGdbusModemCdma *object, guint value)
{
  g_object_set (G_OBJECT (object), "nid", value, NULL);
}

/**
 * mm_gdbus_modem_cdma_get_cdma1x_registration_state: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Cdma1xRegistrationState">"Cdma1xRegistrationState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_cdma_get_cdma1x_registration_state (MmGdbusModemCdma *object)
{
  return MM_GDBUS_MODEM_CDMA_GET_IFACE (object)->get_cdma1x_registration_state (object);
}

/**
 * mm_gdbus_modem_cdma_set_cdma1x_registration_state: (skip)
 * @object: A #MmGdbusModemCdma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.Cdma1xRegistrationState">"Cdma1xRegistrationState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_cdma_set_cdma1x_registration_state (MmGdbusModemCdma *object, guint value)
{
  g_object_set (G_OBJECT (object), "cdma1x-registration-state", value, NULL);
}

/**
 * mm_gdbus_modem_cdma_get_evdo_registration_state: (skip)
 * @object: A #MmGdbusModemCdma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.EvdoRegistrationState">"EvdoRegistrationState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_cdma_get_evdo_registration_state (MmGdbusModemCdma *object)
{
  return MM_GDBUS_MODEM_CDMA_GET_IFACE (object)->get_evdo_registration_state (object);
}

/**
 * mm_gdbus_modem_cdma_set_evdo_registration_state: (skip)
 * @object: A #MmGdbusModemCdma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-ModemCdma.EvdoRegistrationState">"EvdoRegistrationState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_cdma_set_evdo_registration_state (MmGdbusModemCdma *object, guint value)
{
  g_object_set (G_OBJECT (object), "evdo-registration-state", value, NULL);
}

/**
 * mm_gdbus_modem_cdma_emit_activation_state_changed:
 * @object: A #MmGdbusModemCdma.
 * @arg_activation_state: Argument to pass with the signal.
 * @arg_activation_error: Argument to pass with the signal.
 * @arg_status_changes: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivationStateChanged">"ActivationStateChanged"</link> D-Bus signal.
 */
void
mm_gdbus_modem_cdma_emit_activation_state_changed (
    MmGdbusModemCdma *object,
    guint arg_activation_state,
    guint arg_activation_error,
    GVariant *arg_status_changes)
{
  g_signal_emit_by_name (object, "activation-state-changed", arg_activation_state, arg_activation_error, arg_status_changes);
}

/**
 * mm_gdbus_modem_cdma_call_activate:
 * @proxy: A #MmGdbusModemCdmaProxy.
 * @arg_carrier_code: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-ModemCdma.Activate">Activate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_cdma_call_activate_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_cdma_call_activate_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_cdma_call_activate (
    MmGdbusModemCdma *proxy,
    const gchar *arg_carrier_code,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("(s)",
                   arg_carrier_code),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_cdma_call_activate_finish:
 * @proxy: A #MmGdbusModemCdmaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_cdma_call_activate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_cdma_call_activate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_cdma_call_activate_finish (
    MmGdbusModemCdma *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_cdma_call_activate_sync:
 * @proxy: A #MmGdbusModemCdmaProxy.
 * @arg_carrier_code: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-ModemCdma.Activate">Activate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_cdma_call_activate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_cdma_call_activate_sync (
    MmGdbusModemCdma *proxy,
    const gchar *arg_carrier_code,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("(s)",
                   arg_carrier_code),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_cdma_call_activate_manual:
 * @proxy: A #MmGdbusModemCdmaProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivateManual">ActivateManual()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_cdma_call_activate_manual_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_cdma_call_activate_manual_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_cdma_call_activate_manual (
    MmGdbusModemCdma *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ActivateManual",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_cdma_call_activate_manual_finish:
 * @proxy: A #MmGdbusModemCdmaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_cdma_call_activate_manual().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_cdma_call_activate_manual().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_cdma_call_activate_manual_finish (
    MmGdbusModemCdma *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_cdma_call_activate_manual_sync:
 * @proxy: A #MmGdbusModemCdmaProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivateManual">ActivateManual()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_cdma_call_activate_manual() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_cdma_call_activate_manual_sync (
    MmGdbusModemCdma *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ActivateManual",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_cdma_complete_activate:
 * @object: A #MmGdbusModemCdma.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-ModemCdma.Activate">Activate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_cdma_complete_activate (
    MmGdbusModemCdma *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_cdma_complete_activate_manual:
 * @object: A #MmGdbusModemCdma.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-ModemCdma.ActivateManual">ActivateManual()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_cdma_complete_activate_manual (
    MmGdbusModemCdma *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemCdmaProxy:
 *
 * The #MmGdbusModemCdmaProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemCdmaProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemCdmaProxy.
 */

struct _MmGdbusModemCdmaProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_cdma_proxy_iface_init (MmGdbusModemCdmaIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemCdmaProxy, mm_gdbus_modem_cdma_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemCdmaProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_CDMA, mm_gdbus_modem_cdma_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemCdmaProxy, mm_gdbus_modem_cdma_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_CDMA, mm_gdbus_modem_cdma_proxy_iface_init))

#endif
static void
mm_gdbus_modem_cdma_proxy_finalize (GObject *object)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_cdma_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_cdma_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_cdma_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_cdma_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.ModemCdma: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_cdma_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_cdma_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.ModemCdma", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_cdma_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_cdma_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_cdma_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_CDMA);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_CDMA);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_cdma_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_cdma_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_cdma_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
mm_gdbus_modem_cdma_proxy_get_activation_state (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActivationState");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_modem_cdma_proxy_get_meid (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Meid");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_modem_cdma_proxy_get_esn (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Esn");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_cdma_proxy_get_sid (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Sid");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_cdma_proxy_get_nid (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Nid");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_cdma_proxy_get_cdma1x_registration_state (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Cdma1xRegistrationState");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_cdma_proxy_get_evdo_registration_state (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaProxy *proxy = MM_GDBUS_MODEM_CDMA_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EvdoRegistrationState");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_modem_cdma_proxy_init (MmGdbusModemCdmaProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_cdma_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_CDMA_PROXY, MmGdbusModemCdmaProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_cdma_interface_info ());
}

static void
mm_gdbus_modem_cdma_proxy_class_init (MmGdbusModemCdmaProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_cdma_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_cdma_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_cdma_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_cdma_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_cdma_proxy_g_properties_changed;

  mm_gdbus_modem_cdma_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemCdmaProxyPrivate));
#endif
}

static void
mm_gdbus_modem_cdma_proxy_iface_init (MmGdbusModemCdmaIface *iface)
{
  iface->get_activation_state = mm_gdbus_modem_cdma_proxy_get_activation_state;
  iface->get_meid = mm_gdbus_modem_cdma_proxy_get_meid;
  iface->get_esn = mm_gdbus_modem_cdma_proxy_get_esn;
  iface->get_sid = mm_gdbus_modem_cdma_proxy_get_sid;
  iface->get_nid = mm_gdbus_modem_cdma_proxy_get_nid;
  iface->get_cdma1x_registration_state = mm_gdbus_modem_cdma_proxy_get_cdma1x_registration_state;
  iface->get_evdo_registration_state = mm_gdbus_modem_cdma_proxy_get_evdo_registration_state;
}

/**
 * mm_gdbus_modem_cdma_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-ModemCdma.top_of_page">org.freedesktop.ModemManager1.Modem.ModemCdma</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_cdma_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_cdma_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_cdma_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_CDMA_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.ModemCdma", NULL);
}

/**
 * mm_gdbus_modem_cdma_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_cdma_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_cdma_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemCdmaProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemCdma *
mm_gdbus_modem_cdma_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_CDMA (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_cdma_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-ModemCdma.top_of_page">org.freedesktop.ModemManager1.Modem.ModemCdma</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_cdma_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemCdmaProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemCdma *
mm_gdbus_modem_cdma_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_CDMA_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.ModemCdma", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_CDMA (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_cdma_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_cdma_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_cdma_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_cdma_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_cdma_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_CDMA_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.ModemCdma", NULL);
}

/**
 * mm_gdbus_modem_cdma_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_cdma_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_cdma_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemCdmaProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemCdma *
mm_gdbus_modem_cdma_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_CDMA (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_cdma_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_cdma_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_cdma_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemCdmaProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemCdma *
mm_gdbus_modem_cdma_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_CDMA_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.ModemCdma", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_CDMA (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemCdmaSkeleton:
 *
 * The #MmGdbusModemCdmaSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemCdmaSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemCdmaSkeleton.
 */

struct _MmGdbusModemCdmaSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_cdma_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_CDMA);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_CDMA);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_cdma_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_cdma_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_cdma_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_cdma_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_cdma_skeleton_vtable =
{
  _mm_gdbus_modem_cdma_skeleton_handle_method_call,
  _mm_gdbus_modem_cdma_skeleton_handle_get_property,
  _mm_gdbus_modem_cdma_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_cdma_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_cdma_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_cdma_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_cdma_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_cdma_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_cdma_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_cdma_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_cdma_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_cdma_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.ModemCdma", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_cdma_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_cdma_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_cdma_emit_changed (skeleton);
}

static void
_mm_gdbus_modem_cdma_on_signal_activation_state_changed (
    MmGdbusModemCdma *object,
    guint arg_activation_state,
    guint arg_activation_error,
    GVariant *arg_status_changes)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu@a{sv})",
                   arg_activation_state,
                   arg_activation_error,
                   arg_status_changes));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.ModemCdma", "ActivationStateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mm_gdbus_modem_cdma_skeleton_iface_init (MmGdbusModemCdmaIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemCdmaSkeleton, mm_gdbus_modem_cdma_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemCdmaSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_CDMA, mm_gdbus_modem_cdma_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemCdmaSkeleton, mm_gdbus_modem_cdma_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_CDMA, mm_gdbus_modem_cdma_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_cdma_skeleton_finalize (GObject *object)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_cdma_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_cdma_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_cdma_emit_changed (gpointer user_data)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.ModemCdma",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_cdma_schedule_emit_changed (MmGdbusModemCdmaSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_cdma_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_cdma_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_cdma_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_cdma_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_cdma_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_cdma_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_cdma_skeleton_init (MmGdbusModemCdmaSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_cdma_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_CDMA_SKELETON, MmGdbusModemCdmaSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_UINT);
}

static guint 
mm_gdbus_modem_cdma_skeleton_get_activation_state (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_modem_cdma_skeleton_get_meid (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_modem_cdma_skeleton_get_esn (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_cdma_skeleton_get_sid (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_cdma_skeleton_get_nid (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_cdma_skeleton_get_cdma1x_registration_state (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_cdma_skeleton_get_evdo_registration_state (MmGdbusModemCdma *object)
{
  MmGdbusModemCdmaSkeleton *skeleton = MM_GDBUS_MODEM_CDMA_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_cdma_skeleton_class_init (MmGdbusModemCdmaSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_cdma_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_cdma_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_cdma_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_cdma_skeleton_notify;


  mm_gdbus_modem_cdma_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_cdma_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_cdma_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_cdma_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_cdma_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemCdmaSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_cdma_skeleton_iface_init (MmGdbusModemCdmaIface *iface)
{
  iface->activation_state_changed = _mm_gdbus_modem_cdma_on_signal_activation_state_changed;
  iface->get_activation_state = mm_gdbus_modem_cdma_skeleton_get_activation_state;
  iface->get_meid = mm_gdbus_modem_cdma_skeleton_get_meid;
  iface->get_esn = mm_gdbus_modem_cdma_skeleton_get_esn;
  iface->get_sid = mm_gdbus_modem_cdma_skeleton_get_sid;
  iface->get_nid = mm_gdbus_modem_cdma_skeleton_get_nid;
  iface->get_cdma1x_registration_state = mm_gdbus_modem_cdma_skeleton_get_cdma1x_registration_state;
  iface->get_evdo_registration_state = mm_gdbus_modem_cdma_skeleton_get_evdo_registration_state;
}

/**
 * mm_gdbus_modem_cdma_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-ModemCdma.top_of_page">org.freedesktop.ModemManager1.Modem.ModemCdma</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemCdmaSkeleton): The skeleton object.
 */
MmGdbusModemCdma *
mm_gdbus_modem_cdma_skeleton_new (void)
{
  return MM_GDBUS_MODEM_CDMA (g_object_new (MM_GDBUS_TYPE_MODEM_CDMA_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Oma
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemOma
 * @title: MmGdbusModemOma
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Oma D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Oma.top_of_page">org.freedesktop.ModemManager1.Modem.Oma</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Oma ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_oma_method_info_setup_IN_ARG_features =
{
  {
    -1,
    (gchar *) "features",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_oma_method_info_setup_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_oma_method_info_setup_IN_ARG_features.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_oma_method_info_setup =
{
  {
    -1,
    (gchar *) "Setup",
    (GDBusArgInfo **) &_mm_gdbus_modem_oma_method_info_setup_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-setup",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_oma_method_info_start_client_initiated_session_IN_ARG_session_type =
{
  {
    -1,
    (gchar *) "session_type",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_oma_method_info_start_client_initiated_session_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_oma_method_info_start_client_initiated_session_IN_ARG_session_type.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_oma_method_info_start_client_initiated_session =
{
  {
    -1,
    (gchar *) "StartClientInitiatedSession",
    (GDBusArgInfo **) &_mm_gdbus_modem_oma_method_info_start_client_initiated_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-start-client-initiated-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_oma_method_info_accept_network_initiated_session_IN_ARG_session_id =
{
  {
    -1,
    (gchar *) "session_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_oma_method_info_accept_network_initiated_session_IN_ARG_accept =
{
  {
    -1,
    (gchar *) "accept",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_oma_method_info_accept_network_initiated_session_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_oma_method_info_accept_network_initiated_session_IN_ARG_session_id.parent_struct,
  &_mm_gdbus_modem_oma_method_info_accept_network_initiated_session_IN_ARG_accept.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_oma_method_info_accept_network_initiated_session =
{
  {
    -1,
    (gchar *) "AcceptNetworkInitiatedSession",
    (GDBusArgInfo **) &_mm_gdbus_modem_oma_method_info_accept_network_initiated_session_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-accept-network-initiated-session",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_oma_method_info_cancel_session =
{
  {
    -1,
    (gchar *) "CancelSession",
    NULL,
    NULL,
    NULL
  },
  "handle-cancel-session",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_oma_method_info_pointers[] =
{
  &_mm_gdbus_modem_oma_method_info_setup.parent_struct,
  &_mm_gdbus_modem_oma_method_info_start_client_initiated_session.parent_struct,
  &_mm_gdbus_modem_oma_method_info_accept_network_initiated_session.parent_struct,
  &_mm_gdbus_modem_oma_method_info_cancel_session.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_oma_signal_info_session_state_changed_ARG_old_session_state =
{
  {
    -1,
    (gchar *) "old_session_state",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_oma_signal_info_session_state_changed_ARG_new_session_state =
{
  {
    -1,
    (gchar *) "new_session_state",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_oma_signal_info_session_state_changed_ARG_session_state_failed_reason =
{
  {
    -1,
    (gchar *) "session_state_failed_reason",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_oma_signal_info_session_state_changed_ARG_pointers[] =
{
  &_mm_gdbus_modem_oma_signal_info_session_state_changed_ARG_old_session_state.parent_struct,
  &_mm_gdbus_modem_oma_signal_info_session_state_changed_ARG_new_session_state.parent_struct,
  &_mm_gdbus_modem_oma_signal_info_session_state_changed_ARG_session_state_failed_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem_oma_signal_info_session_state_changed =
{
  {
    -1,
    (gchar *) "SessionStateChanged",
    (GDBusArgInfo **) &_mm_gdbus_modem_oma_signal_info_session_state_changed_ARG_pointers,
    NULL
  },
  "session-state-changed"
};

static const GDBusSignalInfo * const _mm_gdbus_modem_oma_signal_info_pointers[] =
{
  &_mm_gdbus_modem_oma_signal_info_session_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_oma_property_info_features =
{
  {
    -1,
    (gchar *) "Features",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "features",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_oma_property_info_pending_network_initiated_sessions =
{
  {
    -1,
    (gchar *) "PendingNetworkInitiatedSessions",
    (gchar *) "a(uu)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "pending-network-initiated-sessions",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_oma_property_info_session_type =
{
  {
    -1,
    (gchar *) "SessionType",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "session-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_oma_property_info_session_state =
{
  {
    -1,
    (gchar *) "SessionState",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "session-state",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_oma_property_info_pointers[] =
{
  &_mm_gdbus_modem_oma_property_info_features.parent_struct,
  &_mm_gdbus_modem_oma_property_info_pending_network_initiated_sessions.parent_struct,
  &_mm_gdbus_modem_oma_property_info_session_type.parent_struct,
  &_mm_gdbus_modem_oma_property_info_session_state.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_oma_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Oma",
    (GDBusMethodInfo **) &_mm_gdbus_modem_oma_method_info_pointers,
    (GDBusSignalInfo **) &_mm_gdbus_modem_oma_signal_info_pointers,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_oma_property_info_pointers,
    NULL
  },
  "modem-oma",
};


/**
 * mm_gdbus_modem_oma_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Oma.top_of_page">org.freedesktop.ModemManager1.Modem.Oma</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_oma_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_oma_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_oma_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemOma interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_oma_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "features");
  g_object_class_override_property (klass, property_id_begin++, "pending-network-initiated-sessions");
  g_object_class_override_property (klass, property_id_begin++, "session-type");
  g_object_class_override_property (klass, property_id_begin++, "session-state");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemOma:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Oma.top_of_page">org.freedesktop.ModemManager1.Modem.Oma</link>.
 */

/**
 * MmGdbusModemOmaIface:
 * @parent_iface: The parent interface.
 * @handle_accept_network_initiated_session: Handler for the #MmGdbusModemOma::handle-accept-network-initiated-session signal.
 * @handle_cancel_session: Handler for the #MmGdbusModemOma::handle-cancel-session signal.
 * @handle_setup: Handler for the #MmGdbusModemOma::handle-setup signal.
 * @handle_start_client_initiated_session: Handler for the #MmGdbusModemOma::handle-start-client-initiated-session signal.
 * @get_features: Getter for the #MmGdbusModemOma:features property.
 * @get_pending_network_initiated_sessions: Getter for the #MmGdbusModemOma:pending-network-initiated-sessions property.
 * @get_session_state: Getter for the #MmGdbusModemOma:session-state property.
 * @get_session_type: Getter for the #MmGdbusModemOma:session-type property.
 * @session_state_changed: Handler for the #MmGdbusModemOma::session-state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Oma.top_of_page">org.freedesktop.ModemManager1.Modem.Oma</link>.
 */

typedef MmGdbusModemOmaIface MmGdbusModemOmaInterface;
G_DEFINE_INTERFACE (MmGdbusModemOma, mm_gdbus_modem_oma, G_TYPE_OBJECT)

static void
mm_gdbus_modem_oma_default_init (MmGdbusModemOmaIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemOma::handle-setup:
   * @object: A #MmGdbusModemOma.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_features: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.Setup">Setup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_oma_complete_setup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-setup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemOmaIface, handle_setup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MmGdbusModemOma::handle-start-client-initiated-session:
   * @object: A #MmGdbusModemOma.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.StartClientInitiatedSession">StartClientInitiatedSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_oma_complete_start_client_initiated_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-client-initiated-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemOmaIface, handle_start_client_initiated_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MmGdbusModemOma::handle-accept-network-initiated-session:
   * @object: A #MmGdbusModemOma.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_id: Argument passed by remote caller.
   * @arg_accept: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.AcceptNetworkInitiatedSession">AcceptNetworkInitiatedSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_oma_complete_accept_network_initiated_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-accept-network-initiated-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemOmaIface, handle_accept_network_initiated_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * MmGdbusModemOma::handle-cancel-session:
   * @object: A #MmGdbusModemOma.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.CancelSession">CancelSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_oma_complete_cancel_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemOmaIface, handle_cancel_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * MmGdbusModemOma::session-state-changed:
   * @object: A #MmGdbusModemOma.
   * @arg_old_session_state: Argument.
   * @arg_new_session_state: Argument.
   * @arg_session_state_failed_reason: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Oma.SessionStateChanged">"SessionStateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("session-state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemOmaIface, session_state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_INT, G_TYPE_INT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemOma:features:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.Features">"Features"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("features", "Features", "Features", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemOma:pending-network-initiated-sessions:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.PendingNetworkInitiatedSessions">"PendingNetworkInitiatedSessions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("pending-network-initiated-sessions", "PendingNetworkInitiatedSessions", "PendingNetworkInitiatedSessions", G_VARIANT_TYPE ("a(uu)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemOma:session-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.SessionType">"SessionType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("session-type", "SessionType", "SessionType", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemOma:session-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.SessionState">"SessionState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("session-state", "SessionState", "SessionState", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_oma_get_features: (skip)
 * @object: A #MmGdbusModemOma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.Features">"Features"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_oma_get_features (MmGdbusModemOma *object)
{
  return MM_GDBUS_MODEM_OMA_GET_IFACE (object)->get_features (object);
}

/**
 * mm_gdbus_modem_oma_set_features: (skip)
 * @object: A #MmGdbusModemOma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.Features">"Features"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_oma_set_features (MmGdbusModemOma *object, guint value)
{
  g_object_set (G_OBJECT (object), "features", value, NULL);
}

/**
 * mm_gdbus_modem_oma_get_pending_network_initiated_sessions: (skip)
 * @object: A #MmGdbusModemOma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.PendingNetworkInitiatedSessions">"PendingNetworkInitiatedSessions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_oma_dup_pending_network_initiated_sessions() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_oma_get_pending_network_initiated_sessions (MmGdbusModemOma *object)
{
  return MM_GDBUS_MODEM_OMA_GET_IFACE (object)->get_pending_network_initiated_sessions (object);
}

/**
 * mm_gdbus_modem_oma_dup_pending_network_initiated_sessions: (skip)
 * @object: A #MmGdbusModemOma.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.PendingNetworkInitiatedSessions">"PendingNetworkInitiatedSessions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_oma_dup_pending_network_initiated_sessions (MmGdbusModemOma *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "pending-network-initiated-sessions", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_oma_set_pending_network_initiated_sessions: (skip)
 * @object: A #MmGdbusModemOma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.PendingNetworkInitiatedSessions">"PendingNetworkInitiatedSessions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_oma_set_pending_network_initiated_sessions (MmGdbusModemOma *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "pending-network-initiated-sessions", value, NULL);
}

/**
 * mm_gdbus_modem_oma_get_session_type: (skip)
 * @object: A #MmGdbusModemOma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.SessionType">"SessionType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_oma_get_session_type (MmGdbusModemOma *object)
{
  return MM_GDBUS_MODEM_OMA_GET_IFACE (object)->get_session_type (object);
}

/**
 * mm_gdbus_modem_oma_set_session_type: (skip)
 * @object: A #MmGdbusModemOma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.SessionType">"SessionType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_oma_set_session_type (MmGdbusModemOma *object, guint value)
{
  g_object_set (G_OBJECT (object), "session-type", value, NULL);
}

/**
 * mm_gdbus_modem_oma_get_session_state: (skip)
 * @object: A #MmGdbusModemOma.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.SessionState">"SessionState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
mm_gdbus_modem_oma_get_session_state (MmGdbusModemOma *object)
{
  return MM_GDBUS_MODEM_OMA_GET_IFACE (object)->get_session_state (object);
}

/**
 * mm_gdbus_modem_oma_set_session_state: (skip)
 * @object: A #MmGdbusModemOma.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Oma.SessionState">"SessionState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_oma_set_session_state (MmGdbusModemOma *object, gint value)
{
  g_object_set (G_OBJECT (object), "session-state", value, NULL);
}

/**
 * mm_gdbus_modem_oma_emit_session_state_changed:
 * @object: A #MmGdbusModemOma.
 * @arg_old_session_state: Argument to pass with the signal.
 * @arg_new_session_state: Argument to pass with the signal.
 * @arg_session_state_failed_reason: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Oma.SessionStateChanged">"SessionStateChanged"</link> D-Bus signal.
 */
void
mm_gdbus_modem_oma_emit_session_state_changed (
    MmGdbusModemOma *object,
    gint arg_old_session_state,
    gint arg_new_session_state,
    guint arg_session_state_failed_reason)
{
  g_signal_emit_by_name (object, "session-state-changed", arg_old_session_state, arg_new_session_state, arg_session_state_failed_reason);
}

/**
 * mm_gdbus_modem_oma_call_setup:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @arg_features: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.Setup">Setup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_oma_call_setup_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_oma_call_setup_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_oma_call_setup (
    MmGdbusModemOma *proxy,
    guint arg_features,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Setup",
    g_variant_new ("(u)",
                   arg_features),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_oma_call_setup_finish:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_oma_call_setup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_oma_call_setup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_oma_call_setup_finish (
    MmGdbusModemOma *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_oma_call_setup_sync:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @arg_features: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.Setup">Setup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_oma_call_setup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_oma_call_setup_sync (
    MmGdbusModemOma *proxy,
    guint arg_features,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Setup",
    g_variant_new ("(u)",
                   arg_features),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_oma_call_start_client_initiated_session:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @arg_session_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.StartClientInitiatedSession">StartClientInitiatedSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_oma_call_start_client_initiated_session_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_oma_call_start_client_initiated_session_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_oma_call_start_client_initiated_session (
    MmGdbusModemOma *proxy,
    guint arg_session_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartClientInitiatedSession",
    g_variant_new ("(u)",
                   arg_session_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_oma_call_start_client_initiated_session_finish:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_oma_call_start_client_initiated_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_oma_call_start_client_initiated_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_oma_call_start_client_initiated_session_finish (
    MmGdbusModemOma *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_oma_call_start_client_initiated_session_sync:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @arg_session_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.StartClientInitiatedSession">StartClientInitiatedSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_oma_call_start_client_initiated_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_oma_call_start_client_initiated_session_sync (
    MmGdbusModemOma *proxy,
    guint arg_session_type,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartClientInitiatedSession",
    g_variant_new ("(u)",
                   arg_session_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_oma_call_accept_network_initiated_session:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @arg_accept: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.AcceptNetworkInitiatedSession">AcceptNetworkInitiatedSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_oma_call_accept_network_initiated_session_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_oma_call_accept_network_initiated_session_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_oma_call_accept_network_initiated_session (
    MmGdbusModemOma *proxy,
    guint arg_session_id,
    gboolean arg_accept,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AcceptNetworkInitiatedSession",
    g_variant_new ("(ub)",
                   arg_session_id,
                   arg_accept),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_oma_call_accept_network_initiated_session_finish:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_oma_call_accept_network_initiated_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_oma_call_accept_network_initiated_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_oma_call_accept_network_initiated_session_finish (
    MmGdbusModemOma *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_oma_call_accept_network_initiated_session_sync:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @arg_session_id: Argument to pass with the method invocation.
 * @arg_accept: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.AcceptNetworkInitiatedSession">AcceptNetworkInitiatedSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_oma_call_accept_network_initiated_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_oma_call_accept_network_initiated_session_sync (
    MmGdbusModemOma *proxy,
    guint arg_session_id,
    gboolean arg_accept,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AcceptNetworkInitiatedSession",
    g_variant_new ("(ub)",
                   arg_session_id,
                   arg_accept),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_oma_call_cancel_session:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.CancelSession">CancelSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_oma_call_cancel_session_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_oma_call_cancel_session_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_oma_call_cancel_session (
    MmGdbusModemOma *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CancelSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_oma_call_cancel_session_finish:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_oma_call_cancel_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_oma_call_cancel_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_oma_call_cancel_session_finish (
    MmGdbusModemOma *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_oma_call_cancel_session_sync:
 * @proxy: A #MmGdbusModemOmaProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.CancelSession">CancelSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_oma_call_cancel_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_oma_call_cancel_session_sync (
    MmGdbusModemOma *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CancelSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_oma_complete_setup:
 * @object: A #MmGdbusModemOma.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.Setup">Setup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_oma_complete_setup (
    MmGdbusModemOma *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_oma_complete_start_client_initiated_session:
 * @object: A #MmGdbusModemOma.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.StartClientInitiatedSession">StartClientInitiatedSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_oma_complete_start_client_initiated_session (
    MmGdbusModemOma *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_oma_complete_accept_network_initiated_session:
 * @object: A #MmGdbusModemOma.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.AcceptNetworkInitiatedSession">AcceptNetworkInitiatedSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_oma_complete_accept_network_initiated_session (
    MmGdbusModemOma *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_oma_complete_cancel_session:
 * @object: A #MmGdbusModemOma.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Oma.CancelSession">CancelSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_oma_complete_cancel_session (
    MmGdbusModemOma *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemOmaProxy:
 *
 * The #MmGdbusModemOmaProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemOmaProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemOmaProxy.
 */

struct _MmGdbusModemOmaProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_oma_proxy_iface_init (MmGdbusModemOmaIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemOmaProxy, mm_gdbus_modem_oma_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemOmaProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_OMA, mm_gdbus_modem_oma_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemOmaProxy, mm_gdbus_modem_oma_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_OMA, mm_gdbus_modem_oma_proxy_iface_init))

#endif
static void
mm_gdbus_modem_oma_proxy_finalize (GObject *object)
{
  MmGdbusModemOmaProxy *proxy = MM_GDBUS_MODEM_OMA_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_oma_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_oma_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_oma_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_oma_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Oma: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_oma_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_oma_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Oma", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_oma_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_oma_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_oma_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_OMA);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_OMA);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_oma_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemOmaProxy *proxy = MM_GDBUS_MODEM_OMA_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_oma_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_oma_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
mm_gdbus_modem_oma_proxy_get_features (MmGdbusModemOma *object)
{
  MmGdbusModemOmaProxy *proxy = MM_GDBUS_MODEM_OMA_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Features");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_modem_oma_proxy_get_pending_network_initiated_sessions (MmGdbusModemOma *object)
{
  MmGdbusModemOmaProxy *proxy = MM_GDBUS_MODEM_OMA_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PendingNetworkInitiatedSessions");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static guint 
mm_gdbus_modem_oma_proxy_get_session_type (MmGdbusModemOma *object)
{
  MmGdbusModemOmaProxy *proxy = MM_GDBUS_MODEM_OMA_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionType");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
mm_gdbus_modem_oma_proxy_get_session_state (MmGdbusModemOma *object)
{
  MmGdbusModemOmaProxy *proxy = MM_GDBUS_MODEM_OMA_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionState");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_modem_oma_proxy_init (MmGdbusModemOmaProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_oma_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_OMA_PROXY, MmGdbusModemOmaProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_oma_interface_info ());
}

static void
mm_gdbus_modem_oma_proxy_class_init (MmGdbusModemOmaProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_oma_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_oma_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_oma_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_oma_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_oma_proxy_g_properties_changed;

  mm_gdbus_modem_oma_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemOmaProxyPrivate));
#endif
}

static void
mm_gdbus_modem_oma_proxy_iface_init (MmGdbusModemOmaIface *iface)
{
  iface->get_features = mm_gdbus_modem_oma_proxy_get_features;
  iface->get_pending_network_initiated_sessions = mm_gdbus_modem_oma_proxy_get_pending_network_initiated_sessions;
  iface->get_session_type = mm_gdbus_modem_oma_proxy_get_session_type;
  iface->get_session_state = mm_gdbus_modem_oma_proxy_get_session_state;
}

/**
 * mm_gdbus_modem_oma_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Oma.top_of_page">org.freedesktop.ModemManager1.Modem.Oma</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_oma_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_oma_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_oma_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_OMA_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Oma", NULL);
}

/**
 * mm_gdbus_modem_oma_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_oma_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_oma_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemOmaProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemOma *
mm_gdbus_modem_oma_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_OMA (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_oma_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Oma.top_of_page">org.freedesktop.ModemManager1.Modem.Oma</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_oma_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemOmaProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemOma *
mm_gdbus_modem_oma_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_OMA_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Oma", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_OMA (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_oma_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_oma_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_oma_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_oma_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_oma_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_OMA_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Oma", NULL);
}

/**
 * mm_gdbus_modem_oma_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_oma_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_oma_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemOmaProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemOma *
mm_gdbus_modem_oma_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_OMA (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_oma_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_oma_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_oma_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemOmaProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemOma *
mm_gdbus_modem_oma_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_OMA_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Oma", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_OMA (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemOmaSkeleton:
 *
 * The #MmGdbusModemOmaSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemOmaSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemOmaSkeleton.
 */

struct _MmGdbusModemOmaSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_oma_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_OMA);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_OMA);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_oma_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_oma_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_oma_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_oma_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_oma_skeleton_vtable =
{
  _mm_gdbus_modem_oma_skeleton_handle_method_call,
  _mm_gdbus_modem_oma_skeleton_handle_get_property,
  _mm_gdbus_modem_oma_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_oma_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_oma_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_oma_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_oma_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_oma_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_oma_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_oma_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_oma_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_oma_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Oma", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_oma_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_oma_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_oma_emit_changed (skeleton);
}

static void
_mm_gdbus_modem_oma_on_signal_session_state_changed (
    MmGdbusModemOma *object,
    gint arg_old_session_state,
    gint arg_new_session_state,
    guint arg_session_state_failed_reason)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(iiu)",
                   arg_old_session_state,
                   arg_new_session_state,
                   arg_session_state_failed_reason));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Oma", "SessionStateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mm_gdbus_modem_oma_skeleton_iface_init (MmGdbusModemOmaIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemOmaSkeleton, mm_gdbus_modem_oma_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemOmaSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_OMA, mm_gdbus_modem_oma_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemOmaSkeleton, mm_gdbus_modem_oma_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_OMA, mm_gdbus_modem_oma_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_oma_skeleton_finalize (GObject *object)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_oma_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_oma_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_oma_emit_changed (gpointer user_data)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Oma",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_oma_schedule_emit_changed (MmGdbusModemOmaSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_oma_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_oma_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_oma_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_oma_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_oma_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_oma_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_oma_skeleton_init (MmGdbusModemOmaSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_oma_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_OMA_SKELETON, MmGdbusModemOmaSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_INT);
}

static guint 
mm_gdbus_modem_oma_skeleton_get_features (MmGdbusModemOma *object)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_oma_skeleton_get_pending_network_initiated_sessions (MmGdbusModemOma *object)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_oma_skeleton_get_session_type (MmGdbusModemOma *object)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
mm_gdbus_modem_oma_skeleton_get_session_state (MmGdbusModemOma *object)
{
  MmGdbusModemOmaSkeleton *skeleton = MM_GDBUS_MODEM_OMA_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_oma_skeleton_class_init (MmGdbusModemOmaSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_oma_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_oma_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_oma_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_oma_skeleton_notify;


  mm_gdbus_modem_oma_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_oma_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_oma_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_oma_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_oma_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemOmaSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_oma_skeleton_iface_init (MmGdbusModemOmaIface *iface)
{
  iface->session_state_changed = _mm_gdbus_modem_oma_on_signal_session_state_changed;
  iface->get_features = mm_gdbus_modem_oma_skeleton_get_features;
  iface->get_pending_network_initiated_sessions = mm_gdbus_modem_oma_skeleton_get_pending_network_initiated_sessions;
  iface->get_session_type = mm_gdbus_modem_oma_skeleton_get_session_type;
  iface->get_session_state = mm_gdbus_modem_oma_skeleton_get_session_state;
}

/**
 * mm_gdbus_modem_oma_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Oma.top_of_page">org.freedesktop.ModemManager1.Modem.Oma</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemOmaSkeleton): The skeleton object.
 */
MmGdbusModemOma *
mm_gdbus_modem_oma_skeleton_new (void)
{
  return MM_GDBUS_MODEM_OMA (g_object_new (MM_GDBUS_TYPE_MODEM_OMA_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Sar
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemSar
 * @title: MmGdbusModemSar
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Sar D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Sar.top_of_page">org.freedesktop.ModemManager1.Modem.Sar</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Sar ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_sar_method_info_enable_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_sar_method_info_enable_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_sar_method_info_enable_IN_ARG_enable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_sar_method_info_enable =
{
  {
    -1,
    (gchar *) "Enable",
    (GDBusArgInfo **) &_mm_gdbus_modem_sar_method_info_enable_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_sar_method_info_set_power_level_IN_ARG_level =
{
  {
    -1,
    (gchar *) "level",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_sar_method_info_set_power_level_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_sar_method_info_set_power_level_IN_ARG_level.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_sar_method_info_set_power_level =
{
  {
    -1,
    (gchar *) "SetPowerLevel",
    (GDBusArgInfo **) &_mm_gdbus_modem_sar_method_info_set_power_level_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-power-level",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_sar_method_info_pointers[] =
{
  &_mm_gdbus_modem_sar_method_info_enable.parent_struct,
  &_mm_gdbus_modem_sar_method_info_set_power_level.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_sar_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_sar_property_info_power_level =
{
  {
    -1,
    (gchar *) "PowerLevel",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "power-level",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_sar_property_info_pointers[] =
{
  &_mm_gdbus_modem_sar_property_info_state.parent_struct,
  &_mm_gdbus_modem_sar_property_info_power_level.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_sar_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Sar",
    (GDBusMethodInfo **) &_mm_gdbus_modem_sar_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_sar_property_info_pointers,
    NULL
  },
  "modem-sar",
};


/**
 * mm_gdbus_modem_sar_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Sar.top_of_page">org.freedesktop.ModemManager1.Modem.Sar</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_sar_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_sar_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_sar_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemSar interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_sar_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "power-level");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemSar:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Sar.top_of_page">org.freedesktop.ModemManager1.Modem.Sar</link>.
 */

/**
 * MmGdbusModemSarIface:
 * @parent_iface: The parent interface.
 * @handle_enable: Handler for the #MmGdbusModemSar::handle-enable signal.
 * @handle_set_power_level: Handler for the #MmGdbusModemSar::handle-set-power-level signal.
 * @get_power_level: Getter for the #MmGdbusModemSar:power-level property.
 * @get_state: Getter for the #MmGdbusModemSar:state property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Sar.top_of_page">org.freedesktop.ModemManager1.Modem.Sar</link>.
 */

typedef MmGdbusModemSarIface MmGdbusModemSarInterface;
G_DEFINE_INTERFACE (MmGdbusModemSar, mm_gdbus_modem_sar, G_TYPE_OBJECT)

static void
mm_gdbus_modem_sar_default_init (MmGdbusModemSarIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemSar::handle-enable:
   * @object: A #MmGdbusModemSar.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_enable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Sar.Enable">Enable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_sar_complete_enable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemSarIface, handle_enable),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MmGdbusModemSar::handle-set-power-level:
   * @object: A #MmGdbusModemSar.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_level: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Sar.SetPowerLevel">SetPowerLevel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_sar_complete_set_power_level() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-power-level",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemSarIface, handle_set_power_level),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemSar:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Sar.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("state", "State", "State", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSar:power-level:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Sar.PowerLevel">"PowerLevel"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("power-level", "PowerLevel", "PowerLevel", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_sar_get_state: (skip)
 * @object: A #MmGdbusModemSar.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Sar.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mm_gdbus_modem_sar_get_state (MmGdbusModemSar *object)
{
  return MM_GDBUS_MODEM_SAR_GET_IFACE (object)->get_state (object);
}

/**
 * mm_gdbus_modem_sar_set_state: (skip)
 * @object: A #MmGdbusModemSar.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Sar.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_sar_set_state (MmGdbusModemSar *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * mm_gdbus_modem_sar_get_power_level: (skip)
 * @object: A #MmGdbusModemSar.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Sar.PowerLevel">"PowerLevel"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_sar_get_power_level (MmGdbusModemSar *object)
{
  return MM_GDBUS_MODEM_SAR_GET_IFACE (object)->get_power_level (object);
}

/**
 * mm_gdbus_modem_sar_set_power_level: (skip)
 * @object: A #MmGdbusModemSar.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Sar.PowerLevel">"PowerLevel"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_sar_set_power_level (MmGdbusModemSar *object, guint value)
{
  g_object_set (G_OBJECT (object), "power-level", value, NULL);
}

/**
 * mm_gdbus_modem_sar_call_enable:
 * @proxy: A #MmGdbusModemSarProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Sar.Enable">Enable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_sar_call_enable_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_sar_call_enable_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_sar_call_enable (
    MmGdbusModemSar *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_sar_call_enable_finish:
 * @proxy: A #MmGdbusModemSarProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_sar_call_enable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_sar_call_enable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_sar_call_enable_finish (
    MmGdbusModemSar *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_sar_call_enable_sync:
 * @proxy: A #MmGdbusModemSarProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Sar.Enable">Enable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_sar_call_enable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_sar_call_enable_sync (
    MmGdbusModemSar *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_sar_call_set_power_level:
 * @proxy: A #MmGdbusModemSarProxy.
 * @arg_level: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Sar.SetPowerLevel">SetPowerLevel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_sar_call_set_power_level_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_sar_call_set_power_level_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_sar_call_set_power_level (
    MmGdbusModemSar *proxy,
    guint arg_level,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPowerLevel",
    g_variant_new ("(u)",
                   arg_level),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_sar_call_set_power_level_finish:
 * @proxy: A #MmGdbusModemSarProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_sar_call_set_power_level().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_sar_call_set_power_level().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_sar_call_set_power_level_finish (
    MmGdbusModemSar *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_sar_call_set_power_level_sync:
 * @proxy: A #MmGdbusModemSarProxy.
 * @arg_level: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Sar.SetPowerLevel">SetPowerLevel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_sar_call_set_power_level() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_sar_call_set_power_level_sync (
    MmGdbusModemSar *proxy,
    guint arg_level,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPowerLevel",
    g_variant_new ("(u)",
                   arg_level),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_sar_complete_enable:
 * @object: A #MmGdbusModemSar.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Sar.Enable">Enable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_sar_complete_enable (
    MmGdbusModemSar *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_sar_complete_set_power_level:
 * @object: A #MmGdbusModemSar.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Sar.SetPowerLevel">SetPowerLevel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_sar_complete_set_power_level (
    MmGdbusModemSar *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemSarProxy:
 *
 * The #MmGdbusModemSarProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemSarProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemSarProxy.
 */

struct _MmGdbusModemSarProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_sar_proxy_iface_init (MmGdbusModemSarIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSarProxy, mm_gdbus_modem_sar_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemSarProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SAR, mm_gdbus_modem_sar_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSarProxy, mm_gdbus_modem_sar_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SAR, mm_gdbus_modem_sar_proxy_iface_init))

#endif
static void
mm_gdbus_modem_sar_proxy_finalize (GObject *object)
{
  MmGdbusModemSarProxy *proxy = MM_GDBUS_MODEM_SAR_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_sar_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_sar_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_sar_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_sar_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Sar: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_sar_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_sar_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Sar", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_sar_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_sar_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_sar_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_SAR);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_SAR);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_sar_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemSarProxy *proxy = MM_GDBUS_MODEM_SAR_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_sar_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_sar_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
mm_gdbus_modem_sar_proxy_get_state (MmGdbusModemSar *object)
{
  MmGdbusModemSarProxy *proxy = MM_GDBUS_MODEM_SAR_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_sar_proxy_get_power_level (MmGdbusModemSar *object)
{
  MmGdbusModemSarProxy *proxy = MM_GDBUS_MODEM_SAR_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PowerLevel");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_modem_sar_proxy_init (MmGdbusModemSarProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_sar_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_SAR_PROXY, MmGdbusModemSarProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_sar_interface_info ());
}

static void
mm_gdbus_modem_sar_proxy_class_init (MmGdbusModemSarProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_sar_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_sar_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_sar_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_sar_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_sar_proxy_g_properties_changed;

  mm_gdbus_modem_sar_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemSarProxyPrivate));
#endif
}

static void
mm_gdbus_modem_sar_proxy_iface_init (MmGdbusModemSarIface *iface)
{
  iface->get_state = mm_gdbus_modem_sar_proxy_get_state;
  iface->get_power_level = mm_gdbus_modem_sar_proxy_get_power_level;
}

/**
 * mm_gdbus_modem_sar_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Sar.top_of_page">org.freedesktop.ModemManager1.Modem.Sar</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_sar_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_sar_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_sar_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_SAR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Sar", NULL);
}

/**
 * mm_gdbus_modem_sar_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_sar_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_sar_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemSarProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSar *
mm_gdbus_modem_sar_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SAR (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_sar_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Sar.top_of_page">org.freedesktop.ModemManager1.Modem.Sar</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_sar_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemSarProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSar *
mm_gdbus_modem_sar_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_SAR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Sar", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SAR (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_sar_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_sar_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_sar_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_sar_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_sar_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_SAR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Sar", NULL);
}

/**
 * mm_gdbus_modem_sar_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_sar_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_sar_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemSarProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSar *
mm_gdbus_modem_sar_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SAR (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_sar_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_sar_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_sar_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemSarProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSar *
mm_gdbus_modem_sar_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_SAR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Sar", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SAR (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemSarSkeleton:
 *
 * The #MmGdbusModemSarSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemSarSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemSarSkeleton.
 */

struct _MmGdbusModemSarSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_sar_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_SAR);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_SAR);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_sar_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_sar_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_sar_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_sar_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_sar_skeleton_vtable =
{
  _mm_gdbus_modem_sar_skeleton_handle_method_call,
  _mm_gdbus_modem_sar_skeleton_handle_get_property,
  _mm_gdbus_modem_sar_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_sar_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_sar_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_sar_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_sar_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_sar_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_sar_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_sar_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_sar_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_sar_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Sar", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_sar_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_sar_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_sar_emit_changed (skeleton);
}

static void mm_gdbus_modem_sar_skeleton_iface_init (MmGdbusModemSarIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSarSkeleton, mm_gdbus_modem_sar_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemSarSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SAR, mm_gdbus_modem_sar_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSarSkeleton, mm_gdbus_modem_sar_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SAR, mm_gdbus_modem_sar_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_sar_skeleton_finalize (GObject *object)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_sar_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_sar_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_sar_emit_changed (gpointer user_data)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Sar",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_sar_schedule_emit_changed (MmGdbusModemSarSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_sar_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_sar_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_sar_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_sar_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_sar_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_sar_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_sar_skeleton_init (MmGdbusModemSarSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_sar_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_SAR_SKELETON, MmGdbusModemSarSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static gboolean 
mm_gdbus_modem_sar_skeleton_get_state (MmGdbusModemSar *object)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_sar_skeleton_get_power_level (MmGdbusModemSar *object)
{
  MmGdbusModemSarSkeleton *skeleton = MM_GDBUS_MODEM_SAR_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_sar_skeleton_class_init (MmGdbusModemSarSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_sar_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_sar_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_sar_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_sar_skeleton_notify;


  mm_gdbus_modem_sar_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_sar_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_sar_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_sar_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_sar_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemSarSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_sar_skeleton_iface_init (MmGdbusModemSarIface *iface)
{
  iface->get_state = mm_gdbus_modem_sar_skeleton_get_state;
  iface->get_power_level = mm_gdbus_modem_sar_skeleton_get_power_level;
}

/**
 * mm_gdbus_modem_sar_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Sar.top_of_page">org.freedesktop.ModemManager1.Modem.Sar</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemSarSkeleton): The skeleton object.
 */
MmGdbusModemSar *
mm_gdbus_modem_sar_skeleton_new (void)
{
  return MM_GDBUS_MODEM_SAR (g_object_new (MM_GDBUS_TYPE_MODEM_SAR_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Signal
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemSignal
 * @title: MmGdbusModemSignal
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Signal D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Signal.top_of_page">org.freedesktop.ModemManager1.Modem.Signal</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Signal ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_signal_method_info_setup_IN_ARG_rate =
{
  {
    -1,
    (gchar *) "rate",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_signal_method_info_setup_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_signal_method_info_setup_IN_ARG_rate.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_signal_method_info_setup =
{
  {
    -1,
    (gchar *) "Setup",
    (GDBusArgInfo **) &_mm_gdbus_modem_signal_method_info_setup_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-setup",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_signal_method_info_setup_thresholds_IN_ARG_settings =
{
  {
    -1,
    (gchar *) "settings",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_signal_method_info_setup_thresholds_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_signal_method_info_setup_thresholds_IN_ARG_settings.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_signal_method_info_setup_thresholds =
{
  {
    -1,
    (gchar *) "SetupThresholds",
    (GDBusArgInfo **) &_mm_gdbus_modem_signal_method_info_setup_thresholds_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-setup-thresholds",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_signal_method_info_pointers[] =
{
  &_mm_gdbus_modem_signal_method_info_setup.parent_struct,
  &_mm_gdbus_modem_signal_method_info_setup_thresholds.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_rate =
{
  {
    -1,
    (gchar *) "Rate",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "rate",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_rssi_threshold =
{
  {
    -1,
    (gchar *) "RssiThreshold",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "rssi-threshold",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_error_rate_threshold =
{
  {
    -1,
    (gchar *) "ErrorRateThreshold",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "error-rate-threshold",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_cdma =
{
  {
    -1,
    (gchar *) "Cdma",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "cdma",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_evdo =
{
  {
    -1,
    (gchar *) "Evdo",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "evdo",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_gsm =
{
  {
    -1,
    (gchar *) "Gsm",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "gsm",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_umts =
{
  {
    -1,
    (gchar *) "Umts",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "umts",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_lte =
{
  {
    -1,
    (gchar *) "Lte",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "lte",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_signal_property_info_nr5g =
{
  {
    -1,
    (gchar *) "Nr5g",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "nr5g",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_signal_property_info_pointers[] =
{
  &_mm_gdbus_modem_signal_property_info_rate.parent_struct,
  &_mm_gdbus_modem_signal_property_info_rssi_threshold.parent_struct,
  &_mm_gdbus_modem_signal_property_info_error_rate_threshold.parent_struct,
  &_mm_gdbus_modem_signal_property_info_cdma.parent_struct,
  &_mm_gdbus_modem_signal_property_info_evdo.parent_struct,
  &_mm_gdbus_modem_signal_property_info_gsm.parent_struct,
  &_mm_gdbus_modem_signal_property_info_umts.parent_struct,
  &_mm_gdbus_modem_signal_property_info_lte.parent_struct,
  &_mm_gdbus_modem_signal_property_info_nr5g.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_signal_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Signal",
    (GDBusMethodInfo **) &_mm_gdbus_modem_signal_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_signal_property_info_pointers,
    NULL
  },
  "modem-signal",
};


/**
 * mm_gdbus_modem_signal_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Signal.top_of_page">org.freedesktop.ModemManager1.Modem.Signal</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_signal_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_signal_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_signal_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemSignal interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_signal_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "rate");
  g_object_class_override_property (klass, property_id_begin++, "rssi-threshold");
  g_object_class_override_property (klass, property_id_begin++, "error-rate-threshold");
  g_object_class_override_property (klass, property_id_begin++, "cdma");
  g_object_class_override_property (klass, property_id_begin++, "evdo");
  g_object_class_override_property (klass, property_id_begin++, "gsm");
  g_object_class_override_property (klass, property_id_begin++, "umts");
  g_object_class_override_property (klass, property_id_begin++, "lte");
  g_object_class_override_property (klass, property_id_begin++, "nr5g");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemSignal:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Signal.top_of_page">org.freedesktop.ModemManager1.Modem.Signal</link>.
 */

/**
 * MmGdbusModemSignalIface:
 * @parent_iface: The parent interface.
 * @handle_setup: Handler for the #MmGdbusModemSignal::handle-setup signal.
 * @handle_setup_thresholds: Handler for the #MmGdbusModemSignal::handle-setup-thresholds signal.
 * @get_cdma: Getter for the #MmGdbusModemSignal:cdma property.
 * @get_error_rate_threshold: Getter for the #MmGdbusModemSignal:error-rate-threshold property.
 * @get_evdo: Getter for the #MmGdbusModemSignal:evdo property.
 * @get_gsm: Getter for the #MmGdbusModemSignal:gsm property.
 * @get_lte: Getter for the #MmGdbusModemSignal:lte property.
 * @get_nr5g: Getter for the #MmGdbusModemSignal:nr5g property.
 * @get_rate: Getter for the #MmGdbusModemSignal:rate property.
 * @get_rssi_threshold: Getter for the #MmGdbusModemSignal:rssi-threshold property.
 * @get_umts: Getter for the #MmGdbusModemSignal:umts property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Signal.top_of_page">org.freedesktop.ModemManager1.Modem.Signal</link>.
 */

typedef MmGdbusModemSignalIface MmGdbusModemSignalInterface;
G_DEFINE_INTERFACE (MmGdbusModemSignal, mm_gdbus_modem_signal, G_TYPE_OBJECT)

static void
mm_gdbus_modem_signal_default_init (MmGdbusModemSignalIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemSignal::handle-setup:
   * @object: A #MmGdbusModemSignal.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_rate: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Signal.Setup">Setup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_signal_complete_setup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-setup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemSignalIface, handle_setup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MmGdbusModemSignal::handle-setup-thresholds:
   * @object: A #MmGdbusModemSignal.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_settings: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Signal.SetupThresholds">SetupThresholds()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_signal_complete_setup_thresholds() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-setup-thresholds",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemSignalIface, handle_setup_thresholds),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemSignal:rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Rate">"Rate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("rate", "Rate", "Rate", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSignal:rssi-threshold:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.RssiThreshold">"RssiThreshold"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("rssi-threshold", "RssiThreshold", "RssiThreshold", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSignal:error-rate-threshold:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.ErrorRateThreshold">"ErrorRateThreshold"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("error-rate-threshold", "ErrorRateThreshold", "ErrorRateThreshold", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSignal:cdma:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Cdma">"Cdma"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("cdma", "Cdma", "Cdma", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSignal:evdo:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Evdo">"Evdo"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("evdo", "Evdo", "Evdo", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSignal:gsm:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Gsm">"Gsm"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("gsm", "Gsm", "Gsm", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSignal:umts:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Umts">"Umts"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("umts", "Umts", "Umts", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSignal:lte:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Lte">"Lte"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("lte", "Lte", "Lte", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemSignal:nr5g:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Nr5g">"Nr5g"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("nr5g", "Nr5g", "Nr5g", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_signal_get_rate: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Rate">"Rate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_signal_get_rate (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_rate (object);
}

/**
 * mm_gdbus_modem_signal_set_rate: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Rate">"Rate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_rate (MmGdbusModemSignal *object, guint value)
{
  g_object_set (G_OBJECT (object), "rate", value, NULL);
}

/**
 * mm_gdbus_modem_signal_get_rssi_threshold: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.RssiThreshold">"RssiThreshold"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_modem_signal_get_rssi_threshold (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_rssi_threshold (object);
}

/**
 * mm_gdbus_modem_signal_set_rssi_threshold: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.RssiThreshold">"RssiThreshold"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_rssi_threshold (MmGdbusModemSignal *object, guint value)
{
  g_object_set (G_OBJECT (object), "rssi-threshold", value, NULL);
}

/**
 * mm_gdbus_modem_signal_get_error_rate_threshold: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.ErrorRateThreshold">"ErrorRateThreshold"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mm_gdbus_modem_signal_get_error_rate_threshold (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_error_rate_threshold (object);
}

/**
 * mm_gdbus_modem_signal_set_error_rate_threshold: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.ErrorRateThreshold">"ErrorRateThreshold"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_error_rate_threshold (MmGdbusModemSignal *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "error-rate-threshold", value, NULL);
}

/**
 * mm_gdbus_modem_signal_get_cdma: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Cdma">"Cdma"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_signal_dup_cdma() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_signal_get_cdma (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_cdma (object);
}

/**
 * mm_gdbus_modem_signal_dup_cdma: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Cdma">"Cdma"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_signal_dup_cdma (MmGdbusModemSignal *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "cdma", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_signal_set_cdma: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Cdma">"Cdma"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_cdma (MmGdbusModemSignal *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "cdma", value, NULL);
}

/**
 * mm_gdbus_modem_signal_get_evdo: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Evdo">"Evdo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_signal_dup_evdo() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_signal_get_evdo (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_evdo (object);
}

/**
 * mm_gdbus_modem_signal_dup_evdo: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Evdo">"Evdo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_signal_dup_evdo (MmGdbusModemSignal *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "evdo", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_signal_set_evdo: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Evdo">"Evdo"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_evdo (MmGdbusModemSignal *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "evdo", value, NULL);
}

/**
 * mm_gdbus_modem_signal_get_gsm: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Gsm">"Gsm"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_signal_dup_gsm() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_signal_get_gsm (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_gsm (object);
}

/**
 * mm_gdbus_modem_signal_dup_gsm: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Gsm">"Gsm"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_signal_dup_gsm (MmGdbusModemSignal *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "gsm", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_signal_set_gsm: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Gsm">"Gsm"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_gsm (MmGdbusModemSignal *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "gsm", value, NULL);
}

/**
 * mm_gdbus_modem_signal_get_umts: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Umts">"Umts"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_signal_dup_umts() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_signal_get_umts (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_umts (object);
}

/**
 * mm_gdbus_modem_signal_dup_umts: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Umts">"Umts"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_signal_dup_umts (MmGdbusModemSignal *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "umts", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_signal_set_umts: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Umts">"Umts"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_umts (MmGdbusModemSignal *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "umts", value, NULL);
}

/**
 * mm_gdbus_modem_signal_get_lte: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Lte">"Lte"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_signal_dup_lte() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_signal_get_lte (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_lte (object);
}

/**
 * mm_gdbus_modem_signal_dup_lte: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Lte">"Lte"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_signal_dup_lte (MmGdbusModemSignal *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "lte", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_signal_set_lte: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Lte">"Lte"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_lte (MmGdbusModemSignal *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "lte", value, NULL);
}

/**
 * mm_gdbus_modem_signal_get_nr5g: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Nr5g">"Nr5g"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_signal_dup_nr5g() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_signal_get_nr5g (MmGdbusModemSignal *object)
{
  return MM_GDBUS_MODEM_SIGNAL_GET_IFACE (object)->get_nr5g (object);
}

/**
 * mm_gdbus_modem_signal_dup_nr5g: (skip)
 * @object: A #MmGdbusModemSignal.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Nr5g">"Nr5g"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_signal_dup_nr5g (MmGdbusModemSignal *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "nr5g", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_signal_set_nr5g: (skip)
 * @object: A #MmGdbusModemSignal.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Signal.Nr5g">"Nr5g"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_signal_set_nr5g (MmGdbusModemSignal *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "nr5g", value, NULL);
}

/**
 * mm_gdbus_modem_signal_call_setup:
 * @proxy: A #MmGdbusModemSignalProxy.
 * @arg_rate: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Signal.Setup">Setup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_signal_call_setup_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_signal_call_setup_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_signal_call_setup (
    MmGdbusModemSignal *proxy,
    guint arg_rate,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Setup",
    g_variant_new ("(u)",
                   arg_rate),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_signal_call_setup_finish:
 * @proxy: A #MmGdbusModemSignalProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_signal_call_setup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_signal_call_setup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_signal_call_setup_finish (
    MmGdbusModemSignal *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_signal_call_setup_sync:
 * @proxy: A #MmGdbusModemSignalProxy.
 * @arg_rate: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Signal.Setup">Setup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_signal_call_setup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_signal_call_setup_sync (
    MmGdbusModemSignal *proxy,
    guint arg_rate,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Setup",
    g_variant_new ("(u)",
                   arg_rate),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_signal_call_setup_thresholds:
 * @proxy: A #MmGdbusModemSignalProxy.
 * @arg_settings: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Signal.SetupThresholds">SetupThresholds()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_signal_call_setup_thresholds_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_signal_call_setup_thresholds_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_signal_call_setup_thresholds (
    MmGdbusModemSignal *proxy,
    GVariant *arg_settings,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetupThresholds",
    g_variant_new ("(@a{sv})",
                   arg_settings),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_signal_call_setup_thresholds_finish:
 * @proxy: A #MmGdbusModemSignalProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_signal_call_setup_thresholds().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_signal_call_setup_thresholds().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_signal_call_setup_thresholds_finish (
    MmGdbusModemSignal *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_signal_call_setup_thresholds_sync:
 * @proxy: A #MmGdbusModemSignalProxy.
 * @arg_settings: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Signal.SetupThresholds">SetupThresholds()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_signal_call_setup_thresholds() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_signal_call_setup_thresholds_sync (
    MmGdbusModemSignal *proxy,
    GVariant *arg_settings,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetupThresholds",
    g_variant_new ("(@a{sv})",
                   arg_settings),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_signal_complete_setup:
 * @object: A #MmGdbusModemSignal.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Signal.Setup">Setup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_signal_complete_setup (
    MmGdbusModemSignal *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_signal_complete_setup_thresholds:
 * @object: A #MmGdbusModemSignal.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Signal.SetupThresholds">SetupThresholds()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_signal_complete_setup_thresholds (
    MmGdbusModemSignal *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemSignalProxy:
 *
 * The #MmGdbusModemSignalProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemSignalProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemSignalProxy.
 */

struct _MmGdbusModemSignalProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_signal_proxy_iface_init (MmGdbusModemSignalIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSignalProxy, mm_gdbus_modem_signal_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemSignalProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SIGNAL, mm_gdbus_modem_signal_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSignalProxy, mm_gdbus_modem_signal_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SIGNAL, mm_gdbus_modem_signal_proxy_iface_init))

#endif
static void
mm_gdbus_modem_signal_proxy_finalize (GObject *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_signal_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_signal_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_signal_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_signal_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Signal: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_signal_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_signal_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Signal", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_signal_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_signal_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_signal_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_SIGNAL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_SIGNAL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_signal_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_signal_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_signal_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
mm_gdbus_modem_signal_proxy_get_rate (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Rate");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_modem_signal_proxy_get_rssi_threshold (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RssiThreshold");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mm_gdbus_modem_signal_proxy_get_error_rate_threshold (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ErrorRateThreshold");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_modem_signal_proxy_get_cdma (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Cdma");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_proxy_get_evdo (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Evdo");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_proxy_get_gsm (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Gsm");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_proxy_get_umts (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Umts");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_proxy_get_lte (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Lte");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_proxy_get_nr5g (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalProxy *proxy = MM_GDBUS_MODEM_SIGNAL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Nr5g");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
mm_gdbus_modem_signal_proxy_init (MmGdbusModemSignalProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_signal_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_SIGNAL_PROXY, MmGdbusModemSignalProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_signal_interface_info ());
}

static void
mm_gdbus_modem_signal_proxy_class_init (MmGdbusModemSignalProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_signal_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_signal_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_signal_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_signal_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_signal_proxy_g_properties_changed;

  mm_gdbus_modem_signal_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemSignalProxyPrivate));
#endif
}

static void
mm_gdbus_modem_signal_proxy_iface_init (MmGdbusModemSignalIface *iface)
{
  iface->get_rate = mm_gdbus_modem_signal_proxy_get_rate;
  iface->get_rssi_threshold = mm_gdbus_modem_signal_proxy_get_rssi_threshold;
  iface->get_error_rate_threshold = mm_gdbus_modem_signal_proxy_get_error_rate_threshold;
  iface->get_cdma = mm_gdbus_modem_signal_proxy_get_cdma;
  iface->get_evdo = mm_gdbus_modem_signal_proxy_get_evdo;
  iface->get_gsm = mm_gdbus_modem_signal_proxy_get_gsm;
  iface->get_umts = mm_gdbus_modem_signal_proxy_get_umts;
  iface->get_lte = mm_gdbus_modem_signal_proxy_get_lte;
  iface->get_nr5g = mm_gdbus_modem_signal_proxy_get_nr5g;
}

/**
 * mm_gdbus_modem_signal_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Signal.top_of_page">org.freedesktop.ModemManager1.Modem.Signal</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_signal_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_signal_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_signal_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_SIGNAL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Signal", NULL);
}

/**
 * mm_gdbus_modem_signal_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_signal_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_signal_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemSignalProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSignal *
mm_gdbus_modem_signal_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SIGNAL (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_signal_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Signal.top_of_page">org.freedesktop.ModemManager1.Modem.Signal</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_signal_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemSignalProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSignal *
mm_gdbus_modem_signal_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_SIGNAL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Signal", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SIGNAL (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_signal_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_signal_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_signal_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_signal_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_signal_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_SIGNAL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Signal", NULL);
}

/**
 * mm_gdbus_modem_signal_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_signal_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_signal_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemSignalProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSignal *
mm_gdbus_modem_signal_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SIGNAL (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_signal_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_signal_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_signal_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemSignalProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSignal *
mm_gdbus_modem_signal_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_SIGNAL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Signal", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SIGNAL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemSignalSkeleton:
 *
 * The #MmGdbusModemSignalSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemSignalSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemSignalSkeleton.
 */

struct _MmGdbusModemSignalSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_signal_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_SIGNAL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_SIGNAL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_signal_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_signal_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_signal_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_signal_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_signal_skeleton_vtable =
{
  _mm_gdbus_modem_signal_skeleton_handle_method_call,
  _mm_gdbus_modem_signal_skeleton_handle_get_property,
  _mm_gdbus_modem_signal_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_signal_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_signal_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_signal_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_signal_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_signal_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_signal_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_signal_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_signal_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_signal_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Signal", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_signal_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_signal_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_signal_emit_changed (skeleton);
}

static void mm_gdbus_modem_signal_skeleton_iface_init (MmGdbusModemSignalIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSignalSkeleton, mm_gdbus_modem_signal_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemSignalSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SIGNAL, mm_gdbus_modem_signal_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSignalSkeleton, mm_gdbus_modem_signal_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SIGNAL, mm_gdbus_modem_signal_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_signal_skeleton_finalize (GObject *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  guint n;
  for (n = 0; n < 9; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_signal_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_signal_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_signal_emit_changed (gpointer user_data)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Signal",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_signal_schedule_emit_changed (MmGdbusModemSignalSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_signal_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_signal_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_signal_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_signal_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_signal_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_signal_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_signal_skeleton_init (MmGdbusModemSignalSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_signal_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_SIGNAL_SKELETON, MmGdbusModemSignalSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 9);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_VARIANT);
}

static guint 
mm_gdbus_modem_signal_skeleton_get_rate (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_modem_signal_skeleton_get_rssi_threshold (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mm_gdbus_modem_signal_skeleton_get_error_rate_threshold (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_skeleton_get_cdma (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_skeleton_get_evdo (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_skeleton_get_gsm (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_skeleton_get_umts (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_skeleton_get_lte (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_modem_signal_skeleton_get_nr5g (MmGdbusModemSignal *object)
{
  MmGdbusModemSignalSkeleton *skeleton = MM_GDBUS_MODEM_SIGNAL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_signal_skeleton_class_init (MmGdbusModemSignalSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_signal_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_signal_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_signal_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_signal_skeleton_notify;


  mm_gdbus_modem_signal_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_signal_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_signal_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_signal_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_signal_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemSignalSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_signal_skeleton_iface_init (MmGdbusModemSignalIface *iface)
{
  iface->get_rate = mm_gdbus_modem_signal_skeleton_get_rate;
  iface->get_rssi_threshold = mm_gdbus_modem_signal_skeleton_get_rssi_threshold;
  iface->get_error_rate_threshold = mm_gdbus_modem_signal_skeleton_get_error_rate_threshold;
  iface->get_cdma = mm_gdbus_modem_signal_skeleton_get_cdma;
  iface->get_evdo = mm_gdbus_modem_signal_skeleton_get_evdo;
  iface->get_gsm = mm_gdbus_modem_signal_skeleton_get_gsm;
  iface->get_umts = mm_gdbus_modem_signal_skeleton_get_umts;
  iface->get_lte = mm_gdbus_modem_signal_skeleton_get_lte;
  iface->get_nr5g = mm_gdbus_modem_signal_skeleton_get_nr5g;
}

/**
 * mm_gdbus_modem_signal_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Signal.top_of_page">org.freedesktop.ModemManager1.Modem.Signal</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemSignalSkeleton): The skeleton object.
 */
MmGdbusModemSignal *
mm_gdbus_modem_signal_skeleton_new (void)
{
  return MM_GDBUS_MODEM_SIGNAL (g_object_new (MM_GDBUS_TYPE_MODEM_SIGNAL_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Simple
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemSimple
 * @title: MmGdbusModemSimple
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Simple D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Simple.top_of_page">org.freedesktop.ModemManager1.Modem.Simple</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Simple ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_simple_method_info_connect_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_simple_method_info_connect_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_simple_method_info_connect_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_simple_method_info_connect_OUT_ARG_bearer =
{
  {
    -1,
    (gchar *) "bearer",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_simple_method_info_connect_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_simple_method_info_connect_OUT_ARG_bearer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_simple_method_info_connect =
{
  {
    -1,
    (gchar *) "Connect",
    (GDBusArgInfo **) &_mm_gdbus_modem_simple_method_info_connect_IN_ARG_pointers,
    (GDBusArgInfo **) &_mm_gdbus_modem_simple_method_info_connect_OUT_ARG_pointers,
    NULL
  },
  "handle-connect",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_simple_method_info_disconnect_IN_ARG_bearer =
{
  {
    -1,
    (gchar *) "bearer",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_simple_method_info_disconnect_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_simple_method_info_disconnect_IN_ARG_bearer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_simple_method_info_disconnect =
{
  {
    -1,
    (gchar *) "Disconnect",
    (GDBusArgInfo **) &_mm_gdbus_modem_simple_method_info_disconnect_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-disconnect",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_simple_method_info_get_status_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_simple_method_info_get_status_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_simple_method_info_get_status_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_simple_method_info_get_status =
{
  {
    -1,
    (gchar *) "GetStatus",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_simple_method_info_get_status_OUT_ARG_pointers,
    NULL
  },
  "handle-get-status",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_simple_method_info_pointers[] =
{
  &_mm_gdbus_modem_simple_method_info_connect.parent_struct,
  &_mm_gdbus_modem_simple_method_info_disconnect.parent_struct,
  &_mm_gdbus_modem_simple_method_info_get_status.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_simple_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Simple",
    (GDBusMethodInfo **) &_mm_gdbus_modem_simple_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "modem-simple",
};


/**
 * mm_gdbus_modem_simple_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Simple.top_of_page">org.freedesktop.ModemManager1.Modem.Simple</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_simple_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_simple_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_simple_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemSimple interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_simple_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * MmGdbusModemSimple:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Simple.top_of_page">org.freedesktop.ModemManager1.Modem.Simple</link>.
 */

/**
 * MmGdbusModemSimpleIface:
 * @parent_iface: The parent interface.
 * @handle_connect: Handler for the #MmGdbusModemSimple::handle-connect signal.
 * @handle_disconnect: Handler for the #MmGdbusModemSimple::handle-disconnect signal.
 * @handle_get_status: Handler for the #MmGdbusModemSimple::handle-get-status signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Simple.top_of_page">org.freedesktop.ModemManager1.Modem.Simple</link>.
 */

typedef MmGdbusModemSimpleIface MmGdbusModemSimpleInterface;
G_DEFINE_INTERFACE (MmGdbusModemSimple, mm_gdbus_modem_simple, G_TYPE_OBJECT)

static void
mm_gdbus_modem_simple_default_init (MmGdbusModemSimpleIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemSimple::handle-connect:
   * @object: A #MmGdbusModemSimple.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.Connect">Connect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_simple_complete_connect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-connect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemSimpleIface, handle_connect),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MmGdbusModemSimple::handle-disconnect:
   * @object: A #MmGdbusModemSimple.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_bearer: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.Disconnect">Disconnect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_simple_complete_disconnect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disconnect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemSimpleIface, handle_disconnect),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusModemSimple::handle-get-status:
   * @object: A #MmGdbusModemSimple.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.GetStatus">GetStatus()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_simple_complete_get_status() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemSimpleIface, handle_get_status),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * mm_gdbus_modem_simple_call_connect:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.Connect">Connect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_simple_call_connect_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_simple_call_connect_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_simple_call_connect (
    MmGdbusModemSimple *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Connect",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_simple_call_connect_finish:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @out_bearer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_simple_call_connect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_simple_call_connect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_simple_call_connect_finish (
    MmGdbusModemSimple *proxy,
    gchar **out_bearer,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_bearer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_simple_call_connect_sync:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_bearer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.Connect">Connect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_simple_call_connect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_simple_call_connect_sync (
    MmGdbusModemSimple *proxy,
    GVariant *arg_properties,
    gchar **out_bearer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Connect",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_bearer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_simple_call_disconnect:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @arg_bearer: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.Disconnect">Disconnect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_simple_call_disconnect_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_simple_call_disconnect_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_simple_call_disconnect (
    MmGdbusModemSimple *proxy,
    const gchar *arg_bearer,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("(o)",
                   arg_bearer),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_simple_call_disconnect_finish:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_simple_call_disconnect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_simple_call_disconnect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_simple_call_disconnect_finish (
    MmGdbusModemSimple *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_simple_call_disconnect_sync:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @arg_bearer: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.Disconnect">Disconnect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_simple_call_disconnect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_simple_call_disconnect_sync (
    MmGdbusModemSimple *proxy,
    const gchar *arg_bearer,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("(o)",
                   arg_bearer),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_simple_call_get_status:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.GetStatus">GetStatus()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_simple_call_get_status_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_simple_call_get_status_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_simple_call_get_status (
    MmGdbusModemSimple *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetStatus",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_simple_call_get_status_finish:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_simple_call_get_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_simple_call_get_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_simple_call_get_status_finish (
    MmGdbusModemSimple *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_simple_call_get_status_sync:
 * @proxy: A #MmGdbusModemSimpleProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.GetStatus">GetStatus()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_simple_call_get_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_simple_call_get_status_sync (
    MmGdbusModemSimple *proxy,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetStatus",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_simple_complete_connect:
 * @object: A #MmGdbusModemSimple.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @bearer: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.Connect">Connect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_simple_complete_connect (
    MmGdbusModemSimple *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *bearer)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   bearer));
}

/**
 * mm_gdbus_modem_simple_complete_disconnect:
 * @object: A #MmGdbusModemSimple.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.Disconnect">Disconnect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_simple_complete_disconnect (
    MmGdbusModemSimple *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_simple_complete_get_status:
 * @object: A #MmGdbusModemSimple.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Simple.GetStatus">GetStatus()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_simple_complete_get_status (
    MmGdbusModemSimple *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   properties));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemSimpleProxy:
 *
 * The #MmGdbusModemSimpleProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemSimpleProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemSimpleProxy.
 */

struct _MmGdbusModemSimpleProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_simple_proxy_iface_init (MmGdbusModemSimpleIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSimpleProxy, mm_gdbus_modem_simple_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemSimpleProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SIMPLE, mm_gdbus_modem_simple_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSimpleProxy, mm_gdbus_modem_simple_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SIMPLE, mm_gdbus_modem_simple_proxy_iface_init))

#endif
static void
mm_gdbus_modem_simple_proxy_finalize (GObject *object)
{
  MmGdbusModemSimpleProxy *proxy = MM_GDBUS_MODEM_SIMPLE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_simple_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_simple_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
mm_gdbus_modem_simple_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
mm_gdbus_modem_simple_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_simple_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_SIMPLE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_SIMPLE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_simple_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemSimpleProxy *proxy = MM_GDBUS_MODEM_SIMPLE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_simple_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_simple_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
mm_gdbus_modem_simple_proxy_init (MmGdbusModemSimpleProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_simple_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_SIMPLE_PROXY, MmGdbusModemSimpleProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_simple_interface_info ());
}

static void
mm_gdbus_modem_simple_proxy_class_init (MmGdbusModemSimpleProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_simple_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_simple_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_simple_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_simple_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_simple_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemSimpleProxyPrivate));
#endif
}

static void
mm_gdbus_modem_simple_proxy_iface_init (MmGdbusModemSimpleIface *iface G_GNUC_UNUSED)
{
}

/**
 * mm_gdbus_modem_simple_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Simple.top_of_page">org.freedesktop.ModemManager1.Modem.Simple</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_simple_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_simple_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_simple_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_SIMPLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Simple", NULL);
}

/**
 * mm_gdbus_modem_simple_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_simple_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_simple_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemSimpleProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSimple *
mm_gdbus_modem_simple_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SIMPLE (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_simple_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Simple.top_of_page">org.freedesktop.ModemManager1.Modem.Simple</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_simple_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemSimpleProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSimple *
mm_gdbus_modem_simple_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_SIMPLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Simple", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SIMPLE (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_simple_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_simple_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_simple_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_simple_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_simple_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_SIMPLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Simple", NULL);
}

/**
 * mm_gdbus_modem_simple_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_simple_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_simple_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemSimpleProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSimple *
mm_gdbus_modem_simple_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SIMPLE (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_simple_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_simple_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_simple_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemSimpleProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemSimple *
mm_gdbus_modem_simple_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_SIMPLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Simple", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_SIMPLE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemSimpleSkeleton:
 *
 * The #MmGdbusModemSimpleSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemSimpleSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemSimpleSkeleton.
 */

struct _MmGdbusModemSimpleSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_simple_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemSimpleSkeleton *skeleton = MM_GDBUS_MODEM_SIMPLE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_SIMPLE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_SIMPLE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_simple_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemSimpleSkeleton *skeleton = MM_GDBUS_MODEM_SIMPLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_simple_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_simple_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemSimpleSkeleton *skeleton = MM_GDBUS_MODEM_SIMPLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_simple_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_simple_skeleton_vtable =
{
  _mm_gdbus_modem_simple_skeleton_handle_method_call,
  _mm_gdbus_modem_simple_skeleton_handle_get_property,
  _mm_gdbus_modem_simple_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_simple_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_simple_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_simple_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_simple_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_simple_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemSimpleSkeleton *skeleton = MM_GDBUS_MODEM_SIMPLE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_simple_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_simple_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_simple_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_simple_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Simple", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
mm_gdbus_modem_simple_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void mm_gdbus_modem_simple_skeleton_iface_init (MmGdbusModemSimpleIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSimpleSkeleton, mm_gdbus_modem_simple_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemSimpleSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SIMPLE, mm_gdbus_modem_simple_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemSimpleSkeleton, mm_gdbus_modem_simple_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_SIMPLE, mm_gdbus_modem_simple_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_simple_skeleton_finalize (GObject *object)
{
  MmGdbusModemSimpleSkeleton *skeleton = MM_GDBUS_MODEM_SIMPLE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_simple_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_simple_skeleton_init (MmGdbusModemSimpleSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_simple_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_SIMPLE_SKELETON, MmGdbusModemSimpleSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
mm_gdbus_modem_simple_skeleton_class_init (MmGdbusModemSimpleSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_simple_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_simple_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_simple_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_simple_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_simple_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemSimpleSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_simple_skeleton_iface_init (MmGdbusModemSimpleIface *iface G_GNUC_UNUSED)
{
}

/**
 * mm_gdbus_modem_simple_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Simple.top_of_page">org.freedesktop.ModemManager1.Modem.Simple</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemSimpleSkeleton): The skeleton object.
 */
MmGdbusModemSimple *
mm_gdbus_modem_simple_skeleton_new (void)
{
  return MM_GDBUS_MODEM_SIMPLE (g_object_new (MM_GDBUS_TYPE_MODEM_SIMPLE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Time
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemTime
 * @title: MmGdbusModemTime
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Time D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Time.top_of_page">org.freedesktop.ModemManager1.Modem.Time</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Time ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_time_method_info_get_network_time_OUT_ARG_time =
{
  {
    -1,
    (gchar *) "time",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_time_method_info_get_network_time_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_time_method_info_get_network_time_OUT_ARG_time.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_time_method_info_get_network_time =
{
  {
    -1,
    (gchar *) "GetNetworkTime",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_time_method_info_get_network_time_OUT_ARG_pointers,
    NULL
  },
  "handle-get-network-time",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_time_method_info_pointers[] =
{
  &_mm_gdbus_modem_time_method_info_get_network_time.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_time_signal_info_network_time_changed_ARG_time =
{
  {
    -1,
    (gchar *) "time",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_time_signal_info_network_time_changed_ARG_pointers[] =
{
  &_mm_gdbus_modem_time_signal_info_network_time_changed_ARG_time.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem_time_signal_info_network_time_changed =
{
  {
    -1,
    (gchar *) "NetworkTimeChanged",
    (GDBusArgInfo **) &_mm_gdbus_modem_time_signal_info_network_time_changed_ARG_pointers,
    NULL
  },
  "network-time-changed"
};

static const GDBusSignalInfo * const _mm_gdbus_modem_time_signal_info_pointers[] =
{
  &_mm_gdbus_modem_time_signal_info_network_time_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_time_property_info_network_timezone =
{
  {
    -1,
    (gchar *) "NetworkTimezone",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "network-timezone",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_time_property_info_pointers[] =
{
  &_mm_gdbus_modem_time_property_info_network_timezone.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_time_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Time",
    (GDBusMethodInfo **) &_mm_gdbus_modem_time_method_info_pointers,
    (GDBusSignalInfo **) &_mm_gdbus_modem_time_signal_info_pointers,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_time_property_info_pointers,
    NULL
  },
  "modem-time",
};


/**
 * mm_gdbus_modem_time_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Time.top_of_page">org.freedesktop.ModemManager1.Modem.Time</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_time_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_time_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_time_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemTime interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_time_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "network-timezone");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemTime:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Time.top_of_page">org.freedesktop.ModemManager1.Modem.Time</link>.
 */

/**
 * MmGdbusModemTimeIface:
 * @parent_iface: The parent interface.
 * @handle_get_network_time: Handler for the #MmGdbusModemTime::handle-get-network-time signal.
 * @get_network_timezone: Getter for the #MmGdbusModemTime:network-timezone property.
 * @network_time_changed: Handler for the #MmGdbusModemTime::network-time-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Time.top_of_page">org.freedesktop.ModemManager1.Modem.Time</link>.
 */

typedef MmGdbusModemTimeIface MmGdbusModemTimeInterface;
G_DEFINE_INTERFACE (MmGdbusModemTime, mm_gdbus_modem_time, G_TYPE_OBJECT)

static void
mm_gdbus_modem_time_default_init (MmGdbusModemTimeIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemTime::handle-get-network-time:
   * @object: A #MmGdbusModemTime.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Time.GetNetworkTime">GetNetworkTime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_time_complete_get_network_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-network-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemTimeIface, handle_get_network_time),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * MmGdbusModemTime::network-time-changed:
   * @object: A #MmGdbusModemTime.
   * @arg_time: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Time.NetworkTimeChanged">"NetworkTimeChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("network-time-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemTimeIface, network_time_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemTime:network-timezone:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Time.NetworkTimezone">"NetworkTimezone"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("network-timezone", "NetworkTimezone", "NetworkTimezone", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_time_get_network_timezone: (skip)
 * @object: A #MmGdbusModemTime.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Time.NetworkTimezone">"NetworkTimezone"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_time_dup_network_timezone() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_modem_time_get_network_timezone (MmGdbusModemTime *object)
{
  return MM_GDBUS_MODEM_TIME_GET_IFACE (object)->get_network_timezone (object);
}

/**
 * mm_gdbus_modem_time_dup_network_timezone: (skip)
 * @object: A #MmGdbusModemTime.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Time.NetworkTimezone">"NetworkTimezone"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_modem_time_dup_network_timezone (MmGdbusModemTime *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "network-timezone", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_time_set_network_timezone: (skip)
 * @object: A #MmGdbusModemTime.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Time.NetworkTimezone">"NetworkTimezone"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_time_set_network_timezone (MmGdbusModemTime *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "network-timezone", value, NULL);
}

/**
 * mm_gdbus_modem_time_emit_network_time_changed:
 * @object: A #MmGdbusModemTime.
 * @arg_time: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Time.NetworkTimeChanged">"NetworkTimeChanged"</link> D-Bus signal.
 */
void
mm_gdbus_modem_time_emit_network_time_changed (
    MmGdbusModemTime *object,
    const gchar *arg_time)
{
  g_signal_emit_by_name (object, "network-time-changed", arg_time);
}

/**
 * mm_gdbus_modem_time_call_get_network_time:
 * @proxy: A #MmGdbusModemTimeProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Time.GetNetworkTime">GetNetworkTime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_time_call_get_network_time_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_time_call_get_network_time_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_time_call_get_network_time (
    MmGdbusModemTime *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetNetworkTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_time_call_get_network_time_finish:
 * @proxy: A #MmGdbusModemTimeProxy.
 * @out_time: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_time_call_get_network_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_time_call_get_network_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_time_call_get_network_time_finish (
    MmGdbusModemTime *proxy,
    gchar **out_time,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_time);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_time_call_get_network_time_sync:
 * @proxy: A #MmGdbusModemTimeProxy.
 * @out_time: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Time.GetNetworkTime">GetNetworkTime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_time_call_get_network_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_time_call_get_network_time_sync (
    MmGdbusModemTime *proxy,
    gchar **out_time,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetNetworkTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_time);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_time_complete_get_network_time:
 * @object: A #MmGdbusModemTime.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @time: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Time.GetNetworkTime">GetNetworkTime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_time_complete_get_network_time (
    MmGdbusModemTime *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *time)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   time));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemTimeProxy:
 *
 * The #MmGdbusModemTimeProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemTimeProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemTimeProxy.
 */

struct _MmGdbusModemTimeProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_time_proxy_iface_init (MmGdbusModemTimeIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemTimeProxy, mm_gdbus_modem_time_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemTimeProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_TIME, mm_gdbus_modem_time_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemTimeProxy, mm_gdbus_modem_time_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_TIME, mm_gdbus_modem_time_proxy_iface_init))

#endif
static void
mm_gdbus_modem_time_proxy_finalize (GObject *object)
{
  MmGdbusModemTimeProxy *proxy = MM_GDBUS_MODEM_TIME_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_time_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_time_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_time_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_time_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Time: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_time_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_time_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Time", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_time_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_time_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_time_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_TIME);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_TIME);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_time_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemTimeProxy *proxy = MM_GDBUS_MODEM_TIME_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_time_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_time_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static GVariant *
mm_gdbus_modem_time_proxy_get_network_timezone (MmGdbusModemTime *object)
{
  MmGdbusModemTimeProxy *proxy = MM_GDBUS_MODEM_TIME_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NetworkTimezone");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
mm_gdbus_modem_time_proxy_init (MmGdbusModemTimeProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_time_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_TIME_PROXY, MmGdbusModemTimeProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_time_interface_info ());
}

static void
mm_gdbus_modem_time_proxy_class_init (MmGdbusModemTimeProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_time_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_time_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_time_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_time_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_time_proxy_g_properties_changed;

  mm_gdbus_modem_time_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemTimeProxyPrivate));
#endif
}

static void
mm_gdbus_modem_time_proxy_iface_init (MmGdbusModemTimeIface *iface)
{
  iface->get_network_timezone = mm_gdbus_modem_time_proxy_get_network_timezone;
}

/**
 * mm_gdbus_modem_time_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Time.top_of_page">org.freedesktop.ModemManager1.Modem.Time</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_time_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_time_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_time_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_TIME_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Time", NULL);
}

/**
 * mm_gdbus_modem_time_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_time_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_time_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemTimeProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemTime *
mm_gdbus_modem_time_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_TIME (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_time_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Time.top_of_page">org.freedesktop.ModemManager1.Modem.Time</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_time_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemTimeProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemTime *
mm_gdbus_modem_time_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_TIME_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Time", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_TIME (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_time_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_time_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_time_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_time_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_time_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_TIME_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Time", NULL);
}

/**
 * mm_gdbus_modem_time_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_time_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_time_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemTimeProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemTime *
mm_gdbus_modem_time_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_TIME (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_time_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_time_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_time_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemTimeProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemTime *
mm_gdbus_modem_time_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_TIME_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Time", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_TIME (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemTimeSkeleton:
 *
 * The #MmGdbusModemTimeSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemTimeSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemTimeSkeleton.
 */

struct _MmGdbusModemTimeSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_time_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_TIME);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_TIME);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_time_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_time_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_time_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_time_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_time_skeleton_vtable =
{
  _mm_gdbus_modem_time_skeleton_handle_method_call,
  _mm_gdbus_modem_time_skeleton_handle_get_property,
  _mm_gdbus_modem_time_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_time_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_time_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_time_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_time_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_time_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_time_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_time_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_time_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_time_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Time", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_time_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_time_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_time_emit_changed (skeleton);
}

static void
_mm_gdbus_modem_time_on_signal_network_time_changed (
    MmGdbusModemTime *object,
    const gchar *arg_time)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_time));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Time", "NetworkTimeChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mm_gdbus_modem_time_skeleton_iface_init (MmGdbusModemTimeIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemTimeSkeleton, mm_gdbus_modem_time_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemTimeSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_TIME, mm_gdbus_modem_time_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemTimeSkeleton, mm_gdbus_modem_time_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_TIME, mm_gdbus_modem_time_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_time_skeleton_finalize (GObject *object)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_time_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_time_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_time_emit_changed (gpointer user_data)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Time",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_time_schedule_emit_changed (MmGdbusModemTimeSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_time_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_time_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_time_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_time_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_time_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_time_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_time_skeleton_init (MmGdbusModemTimeSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_time_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_TIME_SKELETON, MmGdbusModemTimeSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_VARIANT);
}

static GVariant *
mm_gdbus_modem_time_skeleton_get_network_timezone (MmGdbusModemTime *object)
{
  MmGdbusModemTimeSkeleton *skeleton = MM_GDBUS_MODEM_TIME_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_time_skeleton_class_init (MmGdbusModemTimeSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_time_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_time_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_time_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_time_skeleton_notify;


  mm_gdbus_modem_time_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_time_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_time_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_time_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_time_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemTimeSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_time_skeleton_iface_init (MmGdbusModemTimeIface *iface)
{
  iface->network_time_changed = _mm_gdbus_modem_time_on_signal_network_time_changed;
  iface->get_network_timezone = mm_gdbus_modem_time_skeleton_get_network_timezone;
}

/**
 * mm_gdbus_modem_time_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Time.top_of_page">org.freedesktop.ModemManager1.Modem.Time</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemTimeSkeleton): The skeleton object.
 */
MmGdbusModemTime *
mm_gdbus_modem_time_skeleton_new (void)
{
  return MM_GDBUS_MODEM_TIME (g_object_new (MM_GDBUS_TYPE_MODEM_TIME_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem.Voice
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModemVoice
 * @title: MmGdbusModemVoice
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem.Voice D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Voice.top_of_page">org.freedesktop.ModemManager1.Modem.Voice</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem.Voice ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_voice_method_info_list_calls_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_voice_method_info_list_calls_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_voice_method_info_list_calls_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_list_calls =
{
  {
    -1,
    (gchar *) "ListCalls",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_voice_method_info_list_calls_OUT_ARG_pointers,
    NULL
  },
  "handle-list-calls",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_voice_method_info_delete_call_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_voice_method_info_delete_call_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_voice_method_info_delete_call_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_delete_call =
{
  {
    -1,
    (gchar *) "DeleteCall",
    (GDBusArgInfo **) &_mm_gdbus_modem_voice_method_info_delete_call_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-call",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_voice_method_info_create_call_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_voice_method_info_create_call_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_voice_method_info_create_call_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_voice_method_info_create_call_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_voice_method_info_create_call_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_voice_method_info_create_call_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_create_call =
{
  {
    -1,
    (gchar *) "CreateCall",
    (GDBusArgInfo **) &_mm_gdbus_modem_voice_method_info_create_call_IN_ARG_pointers,
    (GDBusArgInfo **) &_mm_gdbus_modem_voice_method_info_create_call_OUT_ARG_pointers,
    NULL
  },
  "handle-create-call",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_hold_and_accept =
{
  {
    -1,
    (gchar *) "HoldAndAccept",
    NULL,
    NULL,
    NULL
  },
  "handle-hold-and-accept",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_hangup_and_accept =
{
  {
    -1,
    (gchar *) "HangupAndAccept",
    NULL,
    NULL,
    NULL
  },
  "handle-hangup-and-accept",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_hangup_all =
{
  {
    -1,
    (gchar *) "HangupAll",
    NULL,
    NULL,
    NULL
  },
  "handle-hangup-all",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_transfer =
{
  {
    -1,
    (gchar *) "Transfer",
    NULL,
    NULL,
    NULL
  },
  "handle-transfer",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_voice_method_info_call_waiting_setup_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_voice_method_info_call_waiting_setup_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_voice_method_info_call_waiting_setup_IN_ARG_enable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_call_waiting_setup =
{
  {
    -1,
    (gchar *) "CallWaitingSetup",
    (GDBusArgInfo **) &_mm_gdbus_modem_voice_method_info_call_waiting_setup_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-call-waiting-setup",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_voice_method_info_call_waiting_query_OUT_ARG_status =
{
  {
    -1,
    (gchar *) "status",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_voice_method_info_call_waiting_query_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_voice_method_info_call_waiting_query_OUT_ARG_status.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_voice_method_info_call_waiting_query =
{
  {
    -1,
    (gchar *) "CallWaitingQuery",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_voice_method_info_call_waiting_query_OUT_ARG_pointers,
    NULL
  },
  "handle-call-waiting-query",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_voice_method_info_pointers[] =
{
  &_mm_gdbus_modem_voice_method_info_list_calls.parent_struct,
  &_mm_gdbus_modem_voice_method_info_delete_call.parent_struct,
  &_mm_gdbus_modem_voice_method_info_create_call.parent_struct,
  &_mm_gdbus_modem_voice_method_info_hold_and_accept.parent_struct,
  &_mm_gdbus_modem_voice_method_info_hangup_and_accept.parent_struct,
  &_mm_gdbus_modem_voice_method_info_hangup_all.parent_struct,
  &_mm_gdbus_modem_voice_method_info_transfer.parent_struct,
  &_mm_gdbus_modem_voice_method_info_call_waiting_setup.parent_struct,
  &_mm_gdbus_modem_voice_method_info_call_waiting_query.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_voice_signal_info_call_added_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_voice_signal_info_call_added_ARG_pointers[] =
{
  &_mm_gdbus_modem_voice_signal_info_call_added_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem_voice_signal_info_call_added =
{
  {
    -1,
    (gchar *) "CallAdded",
    (GDBusArgInfo **) &_mm_gdbus_modem_voice_signal_info_call_added_ARG_pointers,
    NULL
  },
  "call-added"
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_voice_signal_info_call_deleted_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_voice_signal_info_call_deleted_ARG_pointers[] =
{
  &_mm_gdbus_modem_voice_signal_info_call_deleted_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem_voice_signal_info_call_deleted =
{
  {
    -1,
    (gchar *) "CallDeleted",
    (GDBusArgInfo **) &_mm_gdbus_modem_voice_signal_info_call_deleted_ARG_pointers,
    NULL
  },
  "call-deleted"
};

static const GDBusSignalInfo * const _mm_gdbus_modem_voice_signal_info_pointers[] =
{
  &_mm_gdbus_modem_voice_signal_info_call_added.parent_struct,
  &_mm_gdbus_modem_voice_signal_info_call_deleted.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_voice_property_info_calls =
{
  {
    -1,
    (gchar *) "Calls",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "calls",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_voice_property_info_emergency_only =
{
  {
    -1,
    (gchar *) "EmergencyOnly",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "emergency-only",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_voice_property_info_pointers[] =
{
  &_mm_gdbus_modem_voice_property_info_calls.parent_struct,
  &_mm_gdbus_modem_voice_property_info_emergency_only.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_voice_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem.Voice",
    (GDBusMethodInfo **) &_mm_gdbus_modem_voice_method_info_pointers,
    (GDBusSignalInfo **) &_mm_gdbus_modem_voice_signal_info_pointers,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_voice_property_info_pointers,
    NULL
  },
  "modem-voice",
};


/**
 * mm_gdbus_modem_voice_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Voice.top_of_page">org.freedesktop.ModemManager1.Modem.Voice</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_voice_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_voice_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_voice_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusModemVoice interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_modem_voice_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "calls");
  g_object_class_override_property (klass, property_id_begin++, "emergency-only");
  return property_id_begin - 1;
}



/**
 * MmGdbusModemVoice:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Voice.top_of_page">org.freedesktop.ModemManager1.Modem.Voice</link>.
 */

/**
 * MmGdbusModemVoiceIface:
 * @parent_iface: The parent interface.
 * @handle_call_waiting_query: Handler for the #MmGdbusModemVoice::handle-call-waiting-query signal.
 * @handle_call_waiting_setup: Handler for the #MmGdbusModemVoice::handle-call-waiting-setup signal.
 * @handle_create_call: Handler for the #MmGdbusModemVoice::handle-create-call signal.
 * @handle_delete_call: Handler for the #MmGdbusModemVoice::handle-delete-call signal.
 * @handle_hangup_all: Handler for the #MmGdbusModemVoice::handle-hangup-all signal.
 * @handle_hangup_and_accept: Handler for the #MmGdbusModemVoice::handle-hangup-and-accept signal.
 * @handle_hold_and_accept: Handler for the #MmGdbusModemVoice::handle-hold-and-accept signal.
 * @handle_list_calls: Handler for the #MmGdbusModemVoice::handle-list-calls signal.
 * @handle_transfer: Handler for the #MmGdbusModemVoice::handle-transfer signal.
 * @get_calls: Getter for the #MmGdbusModemVoice:calls property.
 * @get_emergency_only: Getter for the #MmGdbusModemVoice:emergency-only property.
 * @call_added: Handler for the #MmGdbusModemVoice::call-added signal.
 * @call_deleted: Handler for the #MmGdbusModemVoice::call-deleted signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Voice.top_of_page">org.freedesktop.ModemManager1.Modem.Voice</link>.
 */

typedef MmGdbusModemVoiceIface MmGdbusModemVoiceInterface;
G_DEFINE_INTERFACE (MmGdbusModemVoice, mm_gdbus_modem_voice, G_TYPE_OBJECT)

static void
mm_gdbus_modem_voice_default_init (MmGdbusModemVoiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusModemVoice::handle-list-calls:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.ListCalls">ListCalls()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_list_calls() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-calls",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_list_calls),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModemVoice::handle-delete-call:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.DeleteCall">DeleteCall()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_delete_call() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-call",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_delete_call),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusModemVoice::handle-create-call:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CreateCall">CreateCall()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_create_call() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-call",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_create_call),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MmGdbusModemVoice::handle-hold-and-accept:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HoldAndAccept">HoldAndAccept()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_hold_and_accept() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hold-and-accept",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_hold_and_accept),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModemVoice::handle-hangup-and-accept:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HangupAndAccept">HangupAndAccept()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_hangup_and_accept() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hangup-and-accept",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_hangup_and_accept),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModemVoice::handle-hangup-all:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HangupAll">HangupAll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_hangup_all() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hangup-all",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_hangup_all),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModemVoice::handle-transfer:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.Transfer">Transfer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_transfer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-transfer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_transfer),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusModemVoice::handle-call-waiting-setup:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_enable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CallWaitingSetup">CallWaitingSetup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_call_waiting_setup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-call-waiting-setup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_call_waiting_setup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MmGdbusModemVoice::handle-call-waiting-query:
   * @object: A #MmGdbusModemVoice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CallWaitingQuery">CallWaitingQuery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_modem_voice_complete_call_waiting_query() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-call-waiting-query",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, handle_call_waiting_query),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * MmGdbusModemVoice::call-added:
   * @object: A #MmGdbusModemVoice.
   * @arg_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Voice.CallAdded">"CallAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("call-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, call_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * MmGdbusModemVoice::call-deleted:
   * @object: A #MmGdbusModemVoice.
   * @arg_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Voice.CallDeleted">"CallDeleted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("call-deleted",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusModemVoiceIface, call_deleted),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusModemVoice:calls:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Voice.Calls">"Calls"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("calls", "Calls", "Calls", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusModemVoice:emergency-only:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Voice.EmergencyOnly">"EmergencyOnly"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("emergency-only", "EmergencyOnly", "EmergencyOnly", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_modem_voice_get_calls: (skip)
 * @object: A #MmGdbusModemVoice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Voice.Calls">"Calls"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_modem_voice_dup_calls() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
mm_gdbus_modem_voice_get_calls (MmGdbusModemVoice *object)
{
  return MM_GDBUS_MODEM_VOICE_GET_IFACE (object)->get_calls (object);
}

/**
 * mm_gdbus_modem_voice_dup_calls: (skip)
 * @object: A #MmGdbusModemVoice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Voice.Calls">"Calls"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
mm_gdbus_modem_voice_dup_calls (MmGdbusModemVoice *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "calls", &value, NULL);
  return value;
}

/**
 * mm_gdbus_modem_voice_set_calls: (skip)
 * @object: A #MmGdbusModemVoice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Voice.Calls">"Calls"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_voice_set_calls (MmGdbusModemVoice *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "calls", value, NULL);
}

/**
 * mm_gdbus_modem_voice_get_emergency_only: (skip)
 * @object: A #MmGdbusModemVoice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Voice.EmergencyOnly">"EmergencyOnly"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mm_gdbus_modem_voice_get_emergency_only (MmGdbusModemVoice *object)
{
  return MM_GDBUS_MODEM_VOICE_GET_IFACE (object)->get_emergency_only (object);
}

/**
 * mm_gdbus_modem_voice_set_emergency_only: (skip)
 * @object: A #MmGdbusModemVoice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Modem-Voice.EmergencyOnly">"EmergencyOnly"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_modem_voice_set_emergency_only (MmGdbusModemVoice *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "emergency-only", value, NULL);
}

/**
 * mm_gdbus_modem_voice_emit_call_added:
 * @object: A #MmGdbusModemVoice.
 * @arg_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Voice.CallAdded">"CallAdded"</link> D-Bus signal.
 */
void
mm_gdbus_modem_voice_emit_call_added (
    MmGdbusModemVoice *object,
    const gchar *arg_path)
{
  g_signal_emit_by_name (object, "call-added", arg_path);
}

/**
 * mm_gdbus_modem_voice_emit_call_deleted:
 * @object: A #MmGdbusModemVoice.
 * @arg_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-ModemManager1-Modem-Voice.CallDeleted">"CallDeleted"</link> D-Bus signal.
 */
void
mm_gdbus_modem_voice_emit_call_deleted (
    MmGdbusModemVoice *object,
    const gchar *arg_path)
{
  g_signal_emit_by_name (object, "call-deleted", arg_path);
}

/**
 * mm_gdbus_modem_voice_call_list_calls:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.ListCalls">ListCalls()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_list_calls_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_list_calls_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_list_calls (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListCalls",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_list_calls_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @out_result: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_list_calls().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_list_calls().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_list_calls_finish (
    MmGdbusModemVoice *proxy,
    gchar ***out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_list_calls_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @out_result: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.ListCalls">ListCalls()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_list_calls() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_list_calls_sync (
    MmGdbusModemVoice *proxy,
    gchar ***out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListCalls",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_delete_call:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.DeleteCall">DeleteCall()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_delete_call_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_delete_call_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_delete_call (
    MmGdbusModemVoice *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeleteCall",
    g_variant_new ("(o)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_delete_call_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_delete_call().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_delete_call().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_delete_call_finish (
    MmGdbusModemVoice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_delete_call_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.DeleteCall">DeleteCall()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_delete_call() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_delete_call_sync (
    MmGdbusModemVoice *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeleteCall",
    g_variant_new ("(o)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_create_call:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CreateCall">CreateCall()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_create_call_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_create_call_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_create_call (
    MmGdbusModemVoice *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateCall",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_create_call_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_create_call().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_create_call().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_create_call_finish (
    MmGdbusModemVoice *proxy,
    gchar **out_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_create_call_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CreateCall">CreateCall()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_create_call() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_create_call_sync (
    MmGdbusModemVoice *proxy,
    GVariant *arg_properties,
    gchar **out_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateCall",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_hold_and_accept:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HoldAndAccept">HoldAndAccept()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_hold_and_accept_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_hold_and_accept_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_hold_and_accept (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HoldAndAccept",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_hold_and_accept_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_hold_and_accept().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_hold_and_accept().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_hold_and_accept_finish (
    MmGdbusModemVoice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_hold_and_accept_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HoldAndAccept">HoldAndAccept()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_hold_and_accept() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_hold_and_accept_sync (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HoldAndAccept",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_hangup_and_accept:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HangupAndAccept">HangupAndAccept()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_hangup_and_accept_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_hangup_and_accept_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_hangup_and_accept (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HangupAndAccept",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_hangup_and_accept_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_hangup_and_accept().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_hangup_and_accept().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_hangup_and_accept_finish (
    MmGdbusModemVoice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_hangup_and_accept_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HangupAndAccept">HangupAndAccept()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_hangup_and_accept() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_hangup_and_accept_sync (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HangupAndAccept",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_hangup_all:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HangupAll">HangupAll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_hangup_all_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_hangup_all_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_hangup_all (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HangupAll",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_hangup_all_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_hangup_all().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_hangup_all().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_hangup_all_finish (
    MmGdbusModemVoice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_hangup_all_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HangupAll">HangupAll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_hangup_all() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_hangup_all_sync (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HangupAll",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_transfer:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.Transfer">Transfer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_transfer_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_transfer_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_transfer (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Transfer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_transfer_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_transfer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_transfer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_transfer_finish (
    MmGdbusModemVoice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_transfer_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.Transfer">Transfer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_transfer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_transfer_sync (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Transfer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_call_waiting_setup:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CallWaitingSetup">CallWaitingSetup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_call_waiting_setup_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_call_waiting_setup_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_call_waiting_setup (
    MmGdbusModemVoice *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CallWaitingSetup",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_call_waiting_setup_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_call_waiting_setup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_call_waiting_setup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_call_waiting_setup_finish (
    MmGdbusModemVoice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_call_waiting_setup_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CallWaitingSetup">CallWaitingSetup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_call_waiting_setup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_call_waiting_setup_sync (
    MmGdbusModemVoice *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CallWaitingSetup",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_call_waiting_query:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CallWaitingQuery">CallWaitingQuery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_call_call_waiting_query_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_call_call_waiting_query_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_modem_voice_call_call_waiting_query (
    MmGdbusModemVoice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CallWaitingQuery",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_modem_voice_call_call_waiting_query_finish:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @out_status: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_call_call_waiting_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_modem_voice_call_call_waiting_query().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_call_waiting_query_finish (
    MmGdbusModemVoice *proxy,
    gboolean *out_status,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_status);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_call_call_waiting_query_sync:
 * @proxy: A #MmGdbusModemVoiceProxy.
 * @out_status: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CallWaitingQuery">CallWaitingQuery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_call_call_waiting_query() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_modem_voice_call_call_waiting_query_sync (
    MmGdbusModemVoice *proxy,
    gboolean *out_status,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CallWaitingQuery",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_status);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_modem_voice_complete_list_calls:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.ListCalls">ListCalls()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_list_calls (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   result));
}

/**
 * mm_gdbus_modem_voice_complete_delete_call:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.DeleteCall">DeleteCall()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_delete_call (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_voice_complete_create_call:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CreateCall">CreateCall()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_create_call (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   path));
}

/**
 * mm_gdbus_modem_voice_complete_hold_and_accept:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HoldAndAccept">HoldAndAccept()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_hold_and_accept (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_voice_complete_hangup_and_accept:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HangupAndAccept">HangupAndAccept()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_hangup_and_accept (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_voice_complete_hangup_all:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.HangupAll">HangupAll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_hangup_all (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_voice_complete_transfer:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.Transfer">Transfer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_transfer (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_voice_complete_call_waiting_setup:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CallWaitingSetup">CallWaitingSetup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_call_waiting_setup (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_modem_voice_complete_call_waiting_query:
 * @object: A #MmGdbusModemVoice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @status: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Modem-Voice.CallWaitingQuery">CallWaitingQuery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_modem_voice_complete_call_waiting_query (
    MmGdbusModemVoice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean status)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   status));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemVoiceProxy:
 *
 * The #MmGdbusModemVoiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemVoiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemVoiceProxy.
 */

struct _MmGdbusModemVoiceProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_modem_voice_proxy_iface_init (MmGdbusModemVoiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemVoiceProxy, mm_gdbus_modem_voice_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusModemVoiceProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_VOICE, mm_gdbus_modem_voice_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemVoiceProxy, mm_gdbus_modem_voice_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_VOICE, mm_gdbus_modem_voice_proxy_iface_init))

#endif
static void
mm_gdbus_modem_voice_proxy_finalize (GObject *object)
{
  MmGdbusModemVoiceProxy *proxy = MM_GDBUS_MODEM_VOICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_modem_voice_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_voice_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_voice_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_modem_voice_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Modem.Voice: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_modem_voice_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_voice_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Modem.Voice", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_modem_voice_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_modem_voice_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_modem_voice_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_MODEM_VOICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_VOICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_modem_voice_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusModemVoiceProxy *proxy = MM_GDBUS_MODEM_VOICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_voice_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_voice_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
mm_gdbus_modem_voice_proxy_get_calls (MmGdbusModemVoice *object)
{
  MmGdbusModemVoiceProxy *proxy = MM_GDBUS_MODEM_VOICE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Calls");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Calls");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Calls", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mm_gdbus_modem_voice_proxy_get_emergency_only (MmGdbusModemVoice *object)
{
  MmGdbusModemVoiceProxy *proxy = MM_GDBUS_MODEM_VOICE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EmergencyOnly");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_modem_voice_proxy_init (MmGdbusModemVoiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_modem_voice_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_MODEM_VOICE_PROXY, MmGdbusModemVoiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_modem_voice_interface_info ());
}

static void
mm_gdbus_modem_voice_proxy_class_init (MmGdbusModemVoiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_modem_voice_proxy_finalize;
  gobject_class->get_property = mm_gdbus_modem_voice_proxy_get_property;
  gobject_class->set_property = mm_gdbus_modem_voice_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_modem_voice_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_modem_voice_proxy_g_properties_changed;

  mm_gdbus_modem_voice_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemVoiceProxyPrivate));
#endif
}

static void
mm_gdbus_modem_voice_proxy_iface_init (MmGdbusModemVoiceIface *iface)
{
  iface->get_calls = mm_gdbus_modem_voice_proxy_get_calls;
  iface->get_emergency_only = mm_gdbus_modem_voice_proxy_get_emergency_only;
}

/**
 * mm_gdbus_modem_voice_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Voice.top_of_page">org.freedesktop.ModemManager1.Modem.Voice</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_voice_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_VOICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Voice", NULL);
}

/**
 * mm_gdbus_modem_voice_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_voice_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusModemVoiceProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemVoice *
mm_gdbus_modem_voice_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_VOICE (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_voice_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Voice.top_of_page">org.freedesktop.ModemManager1.Modem.Voice</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemVoiceProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemVoice *
mm_gdbus_modem_voice_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_VOICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Voice", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_VOICE (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_modem_voice_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_modem_voice_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_modem_voice_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_modem_voice_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_modem_voice_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_MODEM_VOICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Voice", NULL);
}

/**
 * mm_gdbus_modem_voice_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_modem_voice_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_modem_voice_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusModemVoiceProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemVoice *
mm_gdbus_modem_voice_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_MODEM_VOICE (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_modem_voice_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_modem_voice_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_modem_voice_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusModemVoiceProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusModemVoice *
mm_gdbus_modem_voice_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_MODEM_VOICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Modem.Voice", NULL);
  if (ret != NULL)
    return MM_GDBUS_MODEM_VOICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusModemVoiceSkeleton:
 *
 * The #MmGdbusModemVoiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusModemVoiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusModemVoiceSkeleton.
 */

struct _MmGdbusModemVoiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_modem_voice_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_MODEM_VOICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_MODEM_VOICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_modem_voice_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_voice_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_modem_voice_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_modem_voice_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_modem_voice_skeleton_vtable =
{
  _mm_gdbus_modem_voice_skeleton_handle_method_call,
  _mm_gdbus_modem_voice_skeleton_handle_get_property,
  _mm_gdbus_modem_voice_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_modem_voice_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_modem_voice_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_modem_voice_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_modem_voice_skeleton_vtable;
}

static GVariant *
mm_gdbus_modem_voice_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mm_gdbus_modem_voice_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_modem_voice_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_modem_voice_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_modem_voice_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Voice", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_modem_voice_emit_changed (gpointer user_data);

static void
mm_gdbus_modem_voice_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_modem_voice_emit_changed (skeleton);
}

static void
_mm_gdbus_modem_voice_on_signal_call_added (
    MmGdbusModemVoice *object,
    const gchar *arg_path)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Voice", "CallAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_mm_gdbus_modem_voice_on_signal_call_deleted (
    MmGdbusModemVoice *object,
    const gchar *arg_path)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Modem.Voice", "CallDeleted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mm_gdbus_modem_voice_skeleton_iface_init (MmGdbusModemVoiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemVoiceSkeleton, mm_gdbus_modem_voice_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusModemVoiceSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_VOICE, mm_gdbus_modem_voice_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusModemVoiceSkeleton, mm_gdbus_modem_voice_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_MODEM_VOICE, mm_gdbus_modem_voice_skeleton_iface_init))

#endif
static void
mm_gdbus_modem_voice_skeleton_finalize (GObject *object)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_modem_voice_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_modem_voice_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_modem_voice_emit_changed (gpointer user_data)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Modem.Voice",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_modem_voice_schedule_emit_changed (MmGdbusModemVoiceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_modem_voice_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_modem_voice_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_modem_voice_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_modem_voice_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_modem_voice_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_modem_voice_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_modem_voice_skeleton_init (MmGdbusModemVoiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_modem_voice_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_MODEM_VOICE_SKELETON, MmGdbusModemVoiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
}

static const gchar *const *
mm_gdbus_modem_voice_skeleton_get_calls (MmGdbusModemVoice *object)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mm_gdbus_modem_voice_skeleton_get_emergency_only (MmGdbusModemVoice *object)
{
  MmGdbusModemVoiceSkeleton *skeleton = MM_GDBUS_MODEM_VOICE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_modem_voice_skeleton_class_init (MmGdbusModemVoiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_modem_voice_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_modem_voice_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_modem_voice_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_modem_voice_skeleton_notify;


  mm_gdbus_modem_voice_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_modem_voice_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_modem_voice_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_modem_voice_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_modem_voice_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusModemVoiceSkeletonPrivate));
#endif
}

static void
mm_gdbus_modem_voice_skeleton_iface_init (MmGdbusModemVoiceIface *iface)
{
  iface->call_added = _mm_gdbus_modem_voice_on_signal_call_added;
  iface->call_deleted = _mm_gdbus_modem_voice_on_signal_call_deleted;
  iface->get_calls = mm_gdbus_modem_voice_skeleton_get_calls;
  iface->get_emergency_only = mm_gdbus_modem_voice_skeleton_get_emergency_only;
}

/**
 * mm_gdbus_modem_voice_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem-Voice.top_of_page">org.freedesktop.ModemManager1.Modem.Voice</link>.
 *
 * Returns: (transfer full) (type MmGdbusModemVoiceSkeleton): The skeleton object.
 */
MmGdbusModemVoice *
mm_gdbus_modem_voice_skeleton_new (void)
{
  return MM_GDBUS_MODEM_VOICE (g_object_new (MM_GDBUS_TYPE_MODEM_VOICE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Modem
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusModem
 * @title: MmGdbusModem
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Modem D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem.top_of_page">org.freedesktop.ModemManager1.Modem</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Modem ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_enable_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_enable_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_enable_IN_ARG_enable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_enable =
{
  {
    -1,
    (gchar *) "Enable",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_enable_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_list_bearers_OUT_ARG_bearers =
{
  {
    -1,
    (gchar *) "bearers",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_list_bearers_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_list_bearers_OUT_ARG_bearers.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_list_bearers =
{
  {
    -1,
    (gchar *) "ListBearers",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_list_bearers_OUT_ARG_pointers,
    NULL
  },
  "handle-list-bearers",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_create_bearer_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_create_bearer_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_create_bearer_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_create_bearer_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_create_bearer_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_create_bearer_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_create_bearer =
{
  {
    -1,
    (gchar *) "CreateBearer",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_create_bearer_IN_ARG_pointers,
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_create_bearer_OUT_ARG_pointers,
    NULL
  },
  "handle-create-bearer",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_delete_bearer_IN_ARG_bearer =
{
  {
    -1,
    (gchar *) "bearer",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_delete_bearer_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_delete_bearer_IN_ARG_bearer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_delete_bearer =
{
  {
    -1,
    (gchar *) "DeleteBearer",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_delete_bearer_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-bearer",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_reset =
{
  {
    -1,
    (gchar *) "Reset",
    NULL,
    NULL,
    NULL
  },
  "handle-reset",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_factory_reset_IN_ARG_code =
{
  {
    -1,
    (gchar *) "code",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_factory_reset_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_factory_reset_IN_ARG_code.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_factory_reset =
{
  {
    -1,
    (gchar *) "FactoryReset",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_factory_reset_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-factory-reset",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_set_power_state_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_set_power_state_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_set_power_state_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_set_power_state =
{
  {
    -1,
    (gchar *) "SetPowerState",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_set_power_state_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-power-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_set_current_capabilities_IN_ARG_capabilities =
{
  {
    -1,
    (gchar *) "capabilities",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_set_current_capabilities_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_set_current_capabilities_IN_ARG_capabilities.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_set_current_capabilities =
{
  {
    -1,
    (gchar *) "SetCurrentCapabilities",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_set_current_capabilities_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-current-capabilities",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_set_current_modes_IN_ARG_modes =
{
  {
    -1,
    (gchar *) "modes",
    (gchar *) "(uu)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_set_current_modes_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_set_current_modes_IN_ARG_modes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_set_current_modes =
{
  {
    -1,
    (gchar *) "SetCurrentModes",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_set_current_modes_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-current-modes",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_set_current_bands_IN_ARG_bands =
{
  {
    -1,
    (gchar *) "bands",
    (gchar *) "au",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_set_current_bands_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_set_current_bands_IN_ARG_bands.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_set_current_bands =
{
  {
    -1,
    (gchar *) "SetCurrentBands",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_set_current_bands_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-current-bands",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_set_primary_sim_slot_IN_ARG_sim_slot =
{
  {
    -1,
    (gchar *) "sim_slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_set_primary_sim_slot_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_set_primary_sim_slot_IN_ARG_sim_slot.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_set_primary_sim_slot =
{
  {
    -1,
    (gchar *) "SetPrimarySimSlot",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_set_primary_sim_slot_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-primary-sim-slot",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_get_cell_info_OUT_ARG_cell_info =
{
  {
    -1,
    (gchar *) "cell_info",
    (gchar *) "aa{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_get_cell_info_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_get_cell_info_OUT_ARG_cell_info.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_get_cell_info =
{
  {
    -1,
    (gchar *) "GetCellInfo",
    NULL,
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_get_cell_info_OUT_ARG_pointers,
    NULL
  },
  "handle-get-cell-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_command_IN_ARG_cmd =
{
  {
    -1,
    (gchar *) "cmd",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_command_IN_ARG_timeout =
{
  {
    -1,
    (gchar *) "timeout",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_command_IN_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_command_IN_ARG_cmd.parent_struct,
  &_mm_gdbus_modem_method_info_command_IN_ARG_timeout.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_method_info_command_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_method_info_command_OUT_ARG_pointers[] =
{
  &_mm_gdbus_modem_method_info_command_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_modem_method_info_command =
{
  {
    -1,
    (gchar *) "Command",
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_command_IN_ARG_pointers,
    (GDBusArgInfo **) &_mm_gdbus_modem_method_info_command_OUT_ARG_pointers,
    NULL
  },
  "handle-command",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_modem_method_info_pointers[] =
{
  &_mm_gdbus_modem_method_info_enable.parent_struct,
  &_mm_gdbus_modem_method_info_list_bearers.parent_struct,
  &_mm_gdbus_modem_method_info_create_bearer.parent_struct,
  &_mm_gdbus_modem_method_info_delete_bearer.parent_struct,
  &_mm_gdbus_modem_method_info_reset.parent_struct,
  &_mm_gdbus_modem_method_info_factory_reset.parent_struct,
  &_mm_gdbus_modem_method_info_set_power_state.parent_struct,
  &_mm_gdbus_modem_method_info_set_current_capabilities.parent_struct,
  &_mm_gdbus_modem_method_info_set_current_modes.parent_struct,
  &_mm_gdbus_modem_method_info_set_current_bands.parent_struct,
  &_mm_gdbus_modem_method_info_set_primary_sim_slot.parent_struct,
  &_mm_gdbus_modem_method_info_get_cell_info.parent_struct,
  &_mm_gdbus_modem_method_info_command.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_signal_info_state_changed_ARG_old =
{
  {
    -1,
    (gchar *) "old",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_signal_info_state_changed_ARG_new =
{
  {
    -1,
    (gchar *) "new",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_modem_signal_info_state_changed_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_modem_signal_info_state_changed_ARG_pointers[] =
{
  &_mm_gdbus_modem_signal_info_state_changed_ARG_old.parent_struct,
  &_mm_gdbus_modem_signal_info_state_changed_ARG_new.parent_struct,
  &_mm_gdbus_modem_signal_info_state_changed_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mm_gdbus_modem_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_mm_gdbus_modem_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const GDBusSignalInfo * const _mm_gdbus_modem_signal_info_pointers[] =
{
  &_mm_gdbus_modem_signal_info_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_sim =
{
  {
    -1,
    (gchar *) "Sim",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sim",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_sim_slots =
{
  {
    -1,
    (gchar *) "SimSlots",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sim-slots",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_primary_sim_slot =
{
  {
    -1,
    (gchar *) "PrimarySimSlot",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "primary-sim-slot",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_bearers =
{
  {
    -1,
    (gchar *) "Bearers",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "bearers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_supported_capabilities =
{
  {
    -1,
    (gchar *) "SupportedCapabilities",
    (gchar *) "au",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-capabilities",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_current_capabilities =
{
  {
    -1,
    (gchar *) "CurrentCapabilities",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "current-capabilities",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_max_bearers =
{
  {
    -1,
    (gchar *) "MaxBearers",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "max-bearers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_max_active_bearers =
{
  {
    -1,
    (gchar *) "MaxActiveBearers",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "max-active-bearers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_max_active_multiplexed_bearers =
{
  {
    -1,
    (gchar *) "MaxActiveMultiplexedBearers",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "max-active-multiplexed-bearers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_manufacturer =
{
  {
    -1,
    (gchar *) "Manufacturer",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "manufacturer",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_model =
{
  {
    -1,
    (gchar *) "Model",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "model",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_revision =
{
  {
    -1,
    (gchar *) "Revision",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "revision",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_carrier_configuration =
{
  {
    -1,
    (gchar *) "CarrierConfiguration",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "carrier-configuration",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_carrier_configuration_revision =
{
  {
    -1,
    (gchar *) "CarrierConfigurationRevision",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "carrier-configuration-revision",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_hardware_revision =
{
  {
    -1,
    (gchar *) "HardwareRevision",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hardware-revision",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_device_identifier =
{
  {
    -1,
    (gchar *) "DeviceIdentifier",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device-identifier",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_device =
{
  {
    -1,
    (gchar *) "Device",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_drivers =
{
  {
    -1,
    (gchar *) "Drivers",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "drivers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_plugin =
{
  {
    -1,
    (gchar *) "Plugin",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "plugin",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_primary_port =
{
  {
    -1,
    (gchar *) "PrimaryPort",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "primary-port",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_ports =
{
  {
    -1,
    (gchar *) "Ports",
    (gchar *) "a(su)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ports",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_equipment_identifier =
{
  {
    -1,
    (gchar *) "EquipmentIdentifier",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "equipment-identifier",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_unlock_required =
{
  {
    -1,
    (gchar *) "UnlockRequired",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "unlock-required",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_unlock_retries =
{
  {
    -1,
    (gchar *) "UnlockRetries",
    (gchar *) "a{uu}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "unlock-retries",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_state_failed_reason =
{
  {
    -1,
    (gchar *) "StateFailedReason",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state-failed-reason",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_access_technologies =
{
  {
    -1,
    (gchar *) "AccessTechnologies",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "access-technologies",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_signal_quality =
{
  {
    -1,
    (gchar *) "SignalQuality",
    (gchar *) "(ub)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "signal-quality",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_own_numbers =
{
  {
    -1,
    (gchar *) "OwnNumbers",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "own-numbers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_power_state =
{
  {
    -1,
    (gchar *) "PowerState",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "power-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_supported_modes =
{
  {
    -1,
    (gchar *) "SupportedModes",
    (gchar *) "a(uu)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-modes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_current_modes =
{
  {
    -1,
    (gchar *) "CurrentModes",
    (gchar *) "(uu)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "current-modes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_supported_bands =
{
  {
    -1,
    (gchar *) "SupportedBands",
    (gchar *) "au",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-bands",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_current_bands =
{
  {
    -1,
    (gchar *) "CurrentBands",
    (gchar *) "au",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "current-bands",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_modem_property_info_supported_ip_families =
{
  {
    -1,
    (gchar *) "SupportedIpFamilies",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-ip-families",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_modem_property_info_pointers[] =
{
  &_mm_gdbus_modem_property_info_sim.parent_struct,
  &_mm_gdbus_modem_property_info_sim_slots.parent_struct,
  &_mm_gdbus_modem_property_info_primary_sim_slot.parent_struct,
  &_mm_gdbus_modem_property_info_bearers.parent_struct,
  &_mm_gdbus_modem_property_info_supported_capabilities.parent_struct,
  &_mm_gdbus_modem_property_info_current_capabilities.parent_struct,
  &_mm_gdbus_modem_property_info_max_bearers.parent_struct,
  &_mm_gdbus_modem_property_info_max_active_bearers.parent_struct,
  &_mm_gdbus_modem_property_info_max_active_multiplexed_bearers.parent_struct,
  &_mm_gdbus_modem_property_info_manufacturer.parent_struct,
  &_mm_gdbus_modem_property_info_model.parent_struct,
  &_mm_gdbus_modem_property_info_revision.parent_struct,
  &_mm_gdbus_modem_property_info_carrier_configuration.parent_struct,
  &_mm_gdbus_modem_property_info_carrier_configuration_revision.parent_struct,
  &_mm_gdbus_modem_property_info_hardware_revision.parent_struct,
  &_mm_gdbus_modem_property_info_device_identifier.parent_struct,
  &_mm_gdbus_modem_property_info_device.parent_struct,
  &_mm_gdbus_modem_property_info_drivers.parent_struct,
  &_mm_gdbus_modem_property_info_plugin.parent_struct,
  &_mm_gdbus_modem_property_info_primary_port.parent_struct,
  &_mm_gdbus_modem_property_info_ports.parent_struct,
  &_mm_gdbus_modem_property_info_equipment_identifier.parent_struct,
  &_mm_gdbus_modem_property_info_unlock_required.parent_struct,
  &_mm_gdbus_modem_property_info_unlock_retries.parent_struct,
  &_mm_gdbus_modem_property_info_state.parent_struct,
  &_mm_gdbus_modem_property_info_state_failed_reason.parent_struct,
  &_mm_gdbus_modem_property_info_access_technologies.parent_struct,
  &_mm_gdbus_modem_property_info_signal_quality.parent_struct,
  &_mm_gdbus_modem_property_info_own_numbers.parent_struct,
  &_mm_gdbus_modem_property_info_power_state.parent_struct,
  &_mm_gdbus_modem_property_info_supported_modes.parent_struct,
  &_mm_gdbus_modem_property_info_current_modes.parent_struct,
  &_mm_gdbus_modem_property_info_supported_bands.parent_struct,
  &_mm_gdbus_modem_property_info_current_bands.parent_struct,
  &_mm_gdbus_modem_property_info_supported_ip_families.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_modem_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Modem",
    (GDBusMethodInfo **) &_mm_gdbus_modem_method_info_pointers,
    (GDBusSignalInfo **) &_mm_gdbus_modem_signal_info_pointers,
    (GDBusPropertyInfo **) &_mm_gdbus_modem_property_info_pointers,
    NULL
  },
  "modem",
};


/**
 * mm_gdbus_modem_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Modem.top_of_page">org.freedesktop.ModemManager1.Modem</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_modem_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_modem_interface_info.parent_struct;
}

/**
 * mm_gdbus_modem_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Override