/* rygel-basic-management-test-traceroute.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-basic-management-test-traceroute.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT ((guint) 30000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT ((guint) 5000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE ((guint) 20)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE ((guint) 32)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP ((guint) 64)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP ((guint) 30)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS ((guint) 64)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS ((guint) 30)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOSTS ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_RESULT_SIZE ((guint) 4)

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE (rygel_basic_management_test_traceroute_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))

typedef struct _RygelBasicManagementTestTraceroute RygelBasicManagementTestTraceroute;
typedef struct _RygelBasicManagementTestTracerouteClass RygelBasicManagementTestTracerouteClass;
typedef struct _RygelBasicManagementTestTraceroutePrivate RygelBasicManagementTestTraceroutePrivate;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER
} RygelBasicManagementTestTracerouteStatus;

#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_TYPE_STATUS (rygel_basic_management_test_traceroute_status_get_type ())
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS
} RygelBasicManagementTestTracerouteProcessState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_TYPE_PROCESS_STATE (rygel_basic_management_test_traceroute_process_state_get_type ())
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_0_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_NUM_PROPERTIES
};
static GParamSpec* rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestTraceroute {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestTraceroutePrivate * priv;
};

struct _RygelBasicManagementTestTracerouteClass {
	RygelBasicManagementTestClass parent_class;
};

struct _RygelBasicManagementTestTraceroutePrivate {
	gchar* _host;
	guint32 _wait_time_out;
	guint _data_block_size;
	guint _max_hop_count;
	guint _dscp;
	GRegex* regex;
	GRegex* rtt_regex;
	RygelBasicManagementTestTracerouteStatus status;
	gboolean error_set;
	RygelBasicManagementTestTracerouteProcessState state;
	gchar* host_ip;
	gchar* additional_info;
	guint32 response_time;
	gchar* hop_ips;
};

static gint RygelBasicManagementTestTraceroute_private_offset;
static gpointer rygel_basic_management_test_traceroute_parent_class = NULL;

VALA_EXTERN GType rygel_basic_management_test_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_basic_management_test_traceroute_get_type (void) G_GNUC_CONST ;
static GType rygel_basic_management_test_traceroute_status_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType rygel_basic_management_test_traceroute_process_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN void rygel_basic_management_test_handle_error (RygelBasicManagementTest* self,
                                               const gchar* line);
VALA_EXTERN void rygel_basic_management_test_handle_output (RygelBasicManagementTest* self,
                                                const gchar* line);
VALA_EXTERN const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
VALA_EXTERN const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static gchar* rygel_basic_management_test_traceroute_status_to_string (RygelBasicManagementTestTracerouteStatus self);
VALA_EXTERN RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host,
                                                                                guint32 wait_time_out,
                                                                                guint data_block_size,
                                                                                guint max_hop_count,
                                                                                guint dscp);
VALA_EXTERN RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type,
                                                                                      const gchar* host,
                                                                                      guint32 wait_time_out,
                                                                                      guint data_block_size,
                                                                                      guint max_hop_count,
                                                                                      guint dscp);
static void rygel_basic_management_test_traceroute_real_constructed (GObject* base);
VALA_EXTERN guint rygel_basic_management_test_traceroute_get_max_hop_count (RygelBasicManagementTestTraceroute* self);
VALA_EXTERN guint32 rygel_basic_management_test_traceroute_get_wait_time_out (RygelBasicManagementTestTraceroute* self);
VALA_EXTERN guint rygel_basic_management_test_traceroute_get_dscp (RygelBasicManagementTestTraceroute* self);
VALA_EXTERN const gchar* rygel_basic_management_test_traceroute_get_host (RygelBasicManagementTestTraceroute* self);
VALA_EXTERN guint rygel_basic_management_test_traceroute_get_data_block_size (RygelBasicManagementTestTraceroute* self);
static void rygel_basic_management_test_traceroute_set_error (RygelBasicManagementTestTraceroute* self,
                                                       RygelBasicManagementTestTracerouteStatus status,
                                                       const gchar* info);
static void rygel_basic_management_test_traceroute_real_handle_error (RygelBasicManagementTest* base,
                                                               const gchar* line);
static void rygel_basic_management_test_traceroute_real_handle_output (RygelBasicManagementTest* base,
                                                                const gchar* line);
VALA_EXTERN void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self,
                                                         gchar** status,
                                                         gchar** additional_info,
                                                         guint32* response_time,
                                                         gchar** hop_ips);
static void rygel_basic_management_test_traceroute_set_host (RygelBasicManagementTestTraceroute* self,
                                                      const gchar* value);
static void rygel_basic_management_test_traceroute_set_wait_time_out (RygelBasicManagementTestTraceroute* self,
                                                               guint32 value);
static void rygel_basic_management_test_traceroute_set_data_block_size (RygelBasicManagementTestTraceroute* self,
                                                                 guint value);
static void rygel_basic_management_test_traceroute_set_max_hop_count (RygelBasicManagementTestTraceroute* self,
                                                               guint value);
static void rygel_basic_management_test_traceroute_set_dscp (RygelBasicManagementTestTraceroute* self,
                                                      guint value);
static void rygel_basic_management_test_traceroute_finalize (GObject * obj);
static GType rygel_basic_management_test_traceroute_get_type_once (void);
static void _vala_rygel_basic_management_test_traceroute_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_rygel_basic_management_test_traceroute_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_basic_management_test_traceroute_get_instance_private (RygelBasicManagementTestTraceroute* self)
{
	return G_STRUCT_MEMBER_P (self, RygelBasicManagementTestTraceroute_private_offset);
}

 G_GNUC_NO_INLINE static GType
rygel_basic_management_test_traceroute_process_state_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS", "hops"}, {0, NULL, NULL}};
	GType rygel_basic_management_test_traceroute_process_state_type_id;
	rygel_basic_management_test_traceroute_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestTracerouteProcessState", values);
	return rygel_basic_management_test_traceroute_process_state_type_id;
}

static GType
rygel_basic_management_test_traceroute_process_state_get_type (void)
{
	static volatile gsize rygel_basic_management_test_traceroute_process_state_type_id__once = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_process_state_type_id__once)) {
		GType rygel_basic_management_test_traceroute_process_state_type_id;
		rygel_basic_management_test_traceroute_process_state_type_id = rygel_basic_management_test_traceroute_process_state_get_type_once ();
		g_once_init_leave (&rygel_basic_management_test_traceroute_process_state_type_id__once, rygel_basic_management_test_traceroute_process_state_type_id);
	}
	return rygel_basic_management_test_traceroute_process_state_type_id__once;
}

static gchar*
rygel_basic_management_test_traceroute_status_to_string (RygelBasicManagementTestTracerouteStatus self)
{
	gchar* result;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Success");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Error_CannotResolveHostName");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Error_MaxHopCountExceeded");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Error_Internal");
			result = _tmp3_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Error_Other");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

 G_GNUC_NO_INLINE static GType
rygel_basic_management_test_traceroute_status_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME", "error-cannot-resolve-hostname"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED", "error-max-hop-count-exceeded"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
	GType rygel_basic_management_test_traceroute_status_type_id;
	rygel_basic_management_test_traceroute_status_type_id = g_enum_register_static ("RygelBasicManagementTestTracerouteStatus", values);
	return rygel_basic_management_test_traceroute_status_type_id;
}

static GType
rygel_basic_management_test_traceroute_status_get_type (void)
{
	static volatile gsize rygel_basic_management_test_traceroute_status_type_id__once = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_status_type_id__once)) {
		GType rygel_basic_management_test_traceroute_status_type_id;
		rygel_basic_management_test_traceroute_status_type_id = rygel_basic_management_test_traceroute_status_get_type_once ();
		g_once_init_leave (&rygel_basic_management_test_traceroute_status_type_id__once, rygel_basic_management_test_traceroute_status_type_id);
	}
	return rygel_basic_management_test_traceroute_status_type_id__once;
}

RygelBasicManagementTestTraceroute*
rygel_basic_management_test_traceroute_construct (GType object_type,
                                                  const gchar* host,
                                                  guint32 wait_time_out,
                                                  guint data_block_size,
                                                  guint max_hop_count,
                                                  guint dscp)
{
	RygelBasicManagementTestTraceroute * self = NULL;
	g_return_val_if_fail (host != NULL, NULL);
	self = (RygelBasicManagementTestTraceroute*) g_object_new (object_type, "host", host, "wait-time-out", wait_time_out, "data-block-size", data_block_size, "max-hop-count", max_hop_count, "dscp", dscp, NULL);
	return self;
}

RygelBasicManagementTestTraceroute*
rygel_basic_management_test_traceroute_new (const gchar* host,
                                            guint32 wait_time_out,
                                            guint data_block_size,
                                            guint max_hop_count,
                                            guint dscp)
{
	return rygel_basic_management_test_traceroute_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, host, wait_time_out, data_block_size, max_hop_count, dscp);
}

static void
rygel_basic_management_test_traceroute_real_constructed (GObject* base)
{
	RygelBasicManagementTestTraceroute * self;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	guint32 _tmp13_;
	guint32 _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gboolean _tmp27_ = FALSE;
	guint32 _tmp28_;
	guint32 _tmp29_;
	GError* _inner_error0_ = NULL;
	self = (RygelBasicManagementTestTraceroute*) base;
	G_OBJECT_CLASS (rygel_basic_management_test_traceroute_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp1_ = g_regex_new ("^\\s*(\\d+)\\s+(\\S+)\\s*(.*)$", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->regex);
		self->priv->regex = _tmp2_;
		_tmp4_ = g_regex_new ("(\\S+)\\s+ms\\b", 0, 0, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (self->priv->rtt_regex);
		self->priv->rtt_regex = _tmp5_;
		_g_regex_unref0 (_tmp3_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT;
	self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL;
	self->priv->error_set = FALSE;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->hop_ips);
	self->priv->hop_ips = _tmp6_;
	_tmp7_ = g_strdup ("traceroute");
	_tmp8_ = g_strdup ("-m");
	_tmp9_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%u", _tmp10_);
	_tmp12_ = g_strdup ("-w");
	_tmp13_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%u", _tmp14_ / 1000);
	_tmp16_ = g_strdup ("-t");
	_tmp17_ = rygel_basic_management_test_traceroute_get_dscp (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%u", _tmp18_ >> 2);
	_tmp20_ = g_strdup ("-n");
	_tmp21_ = self->priv->_host;
	_tmp22_ = g_strdup (_tmp21_);
	_tmp23_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf ("%u", _tmp24_);
	_tmp26_ = g_new0 (gchar*, 10 + 1);
	_tmp26_[0] = _tmp7_;
	_tmp26_[1] = _tmp8_;
	_tmp26_[2] = _tmp11_;
	_tmp26_[3] = _tmp12_;
	_tmp26_[4] = _tmp15_;
	_tmp26_[5] = _tmp16_;
	_tmp26_[6] = _tmp19_;
	_tmp26_[7] = _tmp20_;
	_tmp26_[8] = _tmp22_;
	_tmp26_[9] = _tmp25_;
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
	((RygelBasicManagementTest*) self)->command = _tmp26_;
	((RygelBasicManagementTest*) self)->command_length1 = 10;
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
	_tmp28_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
	_tmp29_ = _tmp28_;
	if (_tmp29_ < ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT)) {
		_tmp27_ = TRUE;
	} else {
		guint32 _tmp30_;
		guint32 _tmp31_;
		_tmp30_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
		_tmp31_ = _tmp30_;
		_tmp27_ = _tmp31_ > ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT);
	}
	if (_tmp27_) {
		gchar* msg = NULL;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		guint32 _tmp34_;
		guint32 _tmp35_;
		gchar* _tmp36_;
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
		_tmp32_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
		msg = _tmp32_;
		_tmp33_ = msg;
		_tmp34_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf (_tmp33_, _tmp35_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT);
		_g_free0 (self->priv->additional_info);
		self->priv->additional_info = _tmp36_;
		_g_free0 (msg);
	} else {
		gboolean _tmp37_ = FALSE;
		guint _tmp38_;
		guint _tmp39_;
		_tmp38_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
		_tmp39_ = _tmp38_;
		if (_tmp39_ < RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE) {
			_tmp37_ = TRUE;
		} else {
			guint _tmp40_;
			guint _tmp41_;
			_tmp40_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
			_tmp41_ = _tmp40_;
			_tmp37_ = _tmp41_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE;
		}
		if (_tmp37_) {
			gchar* msg = NULL;
			gchar* _tmp42_;
			const gchar* _tmp43_;
			guint _tmp44_;
			guint _tmp45_;
			gchar* _tmp46_;
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
			_tmp42_ = g_strdup ("DataBlockSize %u is not in allowed range [%u, %u]");
			msg = _tmp42_;
			_tmp43_ = msg;
			_tmp44_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strdup_printf (_tmp43_, _tmp45_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE);
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp46_;
			_g_free0 (msg);
		} else {
			guint _tmp47_;
			guint _tmp48_;
			_tmp47_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
			_tmp48_ = _tmp47_;
			if (_tmp48_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS) {
				gchar* msg = NULL;
				gchar* _tmp49_;
				const gchar* _tmp50_;
				guint _tmp51_;
				guint _tmp52_;
				gchar* _tmp53_;
				((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
				_tmp49_ = g_strdup ("MaxHopCount %u is not in allowed range [0, %u]");
				msg = _tmp49_;
				_tmp50_ = msg;
				_tmp51_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
				_tmp52_ = _tmp51_;
				_tmp53_ = g_strdup_printf (_tmp50_, _tmp52_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS);
				_g_free0 (self->priv->additional_info);
				self->priv->additional_info = _tmp53_;
				_g_free0 (msg);
			} else {
				guint _tmp54_;
				guint _tmp55_;
				_tmp54_ = rygel_basic_management_test_traceroute_get_dscp (self);
				_tmp55_ = _tmp54_;
				if (_tmp55_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP) {
					gchar* msg = NULL;
					gchar* _tmp56_;
					const gchar* _tmp57_;
					guint _tmp58_;
					guint _tmp59_;
					gchar* _tmp60_;
					((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
					_tmp56_ = g_strdup ("DSCP %u is not in allowed range [0, %u]");
					msg = _tmp56_;
					_tmp57_ = msg;
					_tmp58_ = rygel_basic_management_test_traceroute_get_dscp (self);
					_tmp59_ = _tmp58_;
					_tmp60_ = g_strdup_printf (_tmp57_, _tmp59_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP);
					_g_free0 (self->priv->additional_info);
					self->priv->additional_info = _tmp60_;
					_g_free0 (msg);
				}
			}
		}
	}
}

static void
rygel_basic_management_test_traceroute_set_error (RygelBasicManagementTestTraceroute* self,
                                                  RygelBasicManagementTestTracerouteStatus status,
                                                  const gchar* info)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	self->priv->error_set = TRUE;
	_tmp0_ = g_strdup (info);
	_g_free0 (self->priv->additional_info);
	self->priv->additional_info = _tmp0_;
	self->priv->status = status;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
rygel_basic_management_test_traceroute_real_handle_error (RygelBasicManagementTest* base,
                                                          const gchar* line)
{
	RygelBasicManagementTestTraceroute * self;
	self = (RygelBasicManagementTestTraceroute*) base;
	g_return_if_fail (line != NULL);
	if (string_contains (line, "Cannot handle \"host\" cmdline arg")) {
		rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "");
	} else {
		if (string_contains (line, "Network is unreachable")) {
			rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, "Network is unreachable.");
		} else {
			rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL, line);
		}
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
rygel_basic_management_test_traceroute_real_handle_output (RygelBasicManagementTest* base,
                                                           const gchar* line)
{
	RygelBasicManagementTestTraceroute * self;
	gchar* _error_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (RygelBasicManagementTestTraceroute*) base;
	g_return_if_fail (line != NULL);
	_error_ = NULL;
	_tmp0_ = string_strip (line);
	_tmp1_ = _tmp0_;
	_g_free0 (_tmp1_);
	switch (self->priv->state) {
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT:
		{
			if (string_contains (line, "traceroute to ")) {
				gint start = 0;
				gint end = 0;
				self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS;
				start = string_index_of_char (line, (gunichar) '(', 0);
				end = string_index_of_char (line, (gunichar) ')', start);
				if (end > start) {
					gchar* _tmp2_;
					_tmp2_ = string_slice (line, (glong) (start + 1), (glong) end);
					_g_free0 (self->priv->host_ip);
					self->priv->host_ip = _tmp2_;
				}
			} else {
				g_debug ("rygel-basic-management-test-traceroute.vala:247: traceroute parser: Un" \
"expected line '%s'", line);
			}
			break;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS:
		{
			const gchar* _tmp9_;
			GMatchInfo* info = NULL;
			GRegex* _tmp11_;
			GMatchInfo* _tmp12_ = NULL;
			gboolean _tmp13_;
			gchar* ip_address = NULL;
			GMatchInfo* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp18_;
			gchar* rtt_string = NULL;
			GMatchInfo* _tmp20_;
			gchar* _tmp21_;
			GRegex* _tmp22_;
			const gchar* _tmp23_;
			GMatchInfo* _tmp24_ = NULL;
			gint rtt_count = 0;
			gdouble rtt_average = 0.0;
			const gchar* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			if (string_contains (line, " !H ")) {
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("Host is unreachable.");
				_g_free0 (_error_);
				_error_ = _tmp3_;
			} else {
				if (string_contains (line, " !N ")) {
					gchar* _tmp4_;
					_tmp4_ = g_strdup ("Network is unreachable.");
					_g_free0 (_error_);
					_error_ = _tmp4_;
				} else {
					if (string_contains (line, " !P ")) {
						gchar* _tmp5_;
						_tmp5_ = g_strdup ("Protocol is unreachable.");
						_g_free0 (_error_);
						_error_ = _tmp5_;
					} else {
						if (string_contains (line, " !S ")) {
							gchar* _tmp6_;
							_tmp6_ = g_strdup ("Source route failed.");
							_g_free0 (_error_);
							_error_ = _tmp6_;
						} else {
							if (string_contains (line, " !F ")) {
								gchar* _tmp7_;
								_tmp7_ = g_strdup ("Fragmentation needed.");
								_g_free0 (_error_);
								_error_ = _tmp7_;
							} else {
								if (string_contains (line, " !X ")) {
									gchar* _tmp8_;
									_tmp8_ = g_strdup ("Network blocks traceroute.");
									_g_free0 (_error_);
									_error_ = _tmp8_;
								}
							}
						}
					}
				}
			}
			_tmp9_ = _error_;
			if (_tmp9_ != NULL) {
				const gchar* _tmp10_;
				_tmp10_ = _error_;
				rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, _tmp10_);
				_g_free0 (_error_);
				return;
			}
			_tmp11_ = self->priv->regex;
			_tmp13_ = g_regex_match (_tmp11_, line, 0, &_tmp12_);
			_g_match_info_unref0 (info);
			info = _tmp12_;
			if (!_tmp13_) {
				g_debug ("rygel-basic-management-test-traceroute.vala:272: traceroute parser: Un" \
"expected line '%s'", line);
				_g_match_info_unref0 (info);
				_g_free0 (_error_);
				return;
			}
			_tmp14_ = info;
			_tmp15_ = g_match_info_fetch (_tmp14_, 2);
			ip_address = _tmp15_;
			if (!self->priv->error_set) {
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = ip_address;
				_tmp17_ = self->priv->host_ip;
				if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS;
				} else {
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED;
				}
			}
			_tmp18_ = ip_address;
			if (g_strcmp0 (_tmp18_, "*") == 0) {
				gchar* _tmp19_;
				_tmp19_ = g_strdup ("");
				_g_free0 (ip_address);
				ip_address = _tmp19_;
			}
			_tmp20_ = info;
			_tmp21_ = g_match_info_fetch (_tmp20_, 3);
			rtt_string = _tmp21_;
			_tmp22_ = self->priv->rtt_regex;
			_tmp23_ = rtt_string;
			g_regex_match (_tmp22_, _tmp23_, 0, &_tmp24_);
			_g_match_info_unref0 (info);
			info = _tmp24_;
			rtt_count = 0;
			rtt_average = 0.0;
			{
				while (TRUE) {
					GMatchInfo* _tmp25_;
					gint _tmp26_;
					GMatchInfo* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					GMatchInfo* _tmp30_;
					_tmp25_ = info;
					if (!g_match_info_matches (_tmp25_)) {
						break;
					}
					_tmp26_ = rtt_count;
					rtt_count = _tmp26_ + 1;
					_tmp27_ = info;
					_tmp28_ = g_match_info_fetch (_tmp27_, 1);
					_tmp29_ = _tmp28_;
					rtt_average += double_parse (_tmp29_);
					_g_free0 (_tmp29_);
					_tmp30_ = info;
					g_match_info_next (_tmp30_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch0_g_regex_error;
						}
						_g_free0 (rtt_string);
						_g_free0 (ip_address);
						_g_match_info_unref0 (info);
						_g_free0 (_error_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			goto __finally0;
			__catch0_g_regex_error:
			{
				GError* e = NULL;
				const gchar* _tmp31_;
				GError* _tmp32_;
				const gchar* _tmp33_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp31_ = rtt_string;
				_tmp32_ = e;
				_tmp33_ = _tmp32_->message;
				g_debug ("rygel-basic-management-test-traceroute.vala:303: Failed to parse round" \
" trip time values '%s': %s", _tmp31_, _tmp33_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (rtt_string);
				_g_free0 (ip_address);
				_g_match_info_unref0 (info);
				_g_free0 (_error_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (rtt_count > 0) {
				rtt_average = rtt_average / rtt_count;
			}
			self->priv->response_time = (guint32) ((guint) round (rtt_average));
			_tmp34_ = self->priv->hop_ips;
			_tmp35_ = strlen (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ != 0) {
				const gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp37_ = self->priv->hop_ips;
				_tmp38_ = g_strconcat (_tmp37_, ",", NULL);
				_g_free0 (self->priv->hop_ips);
				self->priv->hop_ips = _tmp38_;
			}
			_tmp39_ = self->priv->hop_ips;
			_tmp40_ = ip_address;
			_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
			_g_free0 (self->priv->hop_ips);
			self->priv->hop_ips = _tmp41_;
			_g_free0 (rtt_string);
			_g_free0 (ip_address);
			_g_match_info_unref0 (info);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_g_free0 (_error_);
}

void
rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self,
                                                    gchar** status,
                                                    gchar** additional_info,
                                                    guint32* response_time,
                                                    gchar** hop_ips)
{
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint32 _vala_response_time = 0U;
	gchar* _vala_hop_ips = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_basic_management_test_traceroute_status_to_string (self->priv->status);
	_g_free0 (_vala_status);
	_vala_status = _tmp0_;
	_tmp1_ = self->priv->additional_info;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_vala_additional_info);
	_vala_additional_info = _tmp2_;
	_vala_response_time = self->priv->response_time;
	_tmp3_ = self->priv->hop_ips;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_hop_ips);
	_vala_hop_ips = _tmp4_;
	if (status) {
		*status = _vala_status;
	} else {
		_g_free0 (_vala_status);
	}
	if (additional_info) {
		*additional_info = _vala_additional_info;
	} else {
		_g_free0 (_vala_additional_info);
	}
	if (response_time) {
		*response_time = _vala_response_time;
	}
	if (hop_ips) {
		*hop_ips = _vala_hop_ips;
	} else {
		_g_free0 (_vala_hop_ips);
	}
}

const gchar*
rygel_basic_management_test_traceroute_get_host (RygelBasicManagementTestTraceroute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host;
	result = _tmp0_;
	return result;
}

static void
rygel_basic_management_test_traceroute_set_host (RygelBasicManagementTestTraceroute* self,
                                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_basic_management_test_traceroute_get_host (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_host);
		self->priv->_host = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST_PROPERTY]);
	}
}

guint32
rygel_basic_management_test_traceroute_get_wait_time_out (RygelBasicManagementTestTraceroute* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_wait_time_out;
	return result;
}

static void
rygel_basic_management_test_traceroute_set_wait_time_out (RygelBasicManagementTestTraceroute* self,
                                                          guint32 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_wait_time_out = value;
	if (self->priv->_wait_time_out == ((guint32) 0)) {
		self->priv->_wait_time_out = (guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT_PROPERTY]);
}

guint
rygel_basic_management_test_traceroute_get_data_block_size (RygelBasicManagementTestTraceroute* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_data_block_size;
	return result;
}

static void
rygel_basic_management_test_traceroute_set_data_block_size (RygelBasicManagementTestTraceroute* self,
                                                            guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_data_block_size = value;
	if (self->priv->_data_block_size == ((guint) 0)) {
		self->priv->_data_block_size = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE_PROPERTY]);
}

guint
rygel_basic_management_test_traceroute_get_max_hop_count (RygelBasicManagementTestTraceroute* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_max_hop_count;
	return result;
}

static void
rygel_basic_management_test_traceroute_set_max_hop_count (RygelBasicManagementTestTraceroute* self,
                                                          guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_max_hop_count = value;
	if (self->priv->_max_hop_count == ((guint) 0)) {
		self->priv->_max_hop_count = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT_PROPERTY]);
}

guint
rygel_basic_management_test_traceroute_get_dscp (RygelBasicManagementTestTraceroute* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_dscp;
	return result;
}

static void
rygel_basic_management_test_traceroute_set_dscp (RygelBasicManagementTestTraceroute* self,
                                                 guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_dscp = value;
	if (self->priv->_dscp == ((guint) 0)) {
		self->priv->_dscp = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP_PROPERTY]);
}

static const gchar*
rygel_basic_management_test_traceroute_real_get_method_type (RygelBasicManagementTest* base)
{
	const gchar* result;
	RygelBasicManagementTestTraceroute* self;
	self = (RygelBasicManagementTestTraceroute*) base;
	result = "Traceroute";
	return result;
}

static const gchar*
rygel_basic_management_test_traceroute_real_get_results_type (RygelBasicManagementTest* base)
{
	const gchar* result;
	RygelBasicManagementTestTraceroute* self;
	self = (RygelBasicManagementTestTraceroute*) base;
	result = "GetTracerouteResult";
	return result;
}

static void
rygel_basic_management_test_traceroute_class_init (RygelBasicManagementTestTracerouteClass * klass,
                                                   gpointer klass_data)
{
	rygel_basic_management_test_traceroute_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelBasicManagementTestTraceroute_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_basic_management_test_traceroute_real_constructed;
	((RygelBasicManagementTestClass *) klass)->handle_error = (void (*) (RygelBasicManagementTest*, const gchar*)) rygel_basic_management_test_traceroute_real_handle_error;
	((RygelBasicManagementTestClass *) klass)->handle_output = (void (*) (RygelBasicManagementTest*, const gchar*)) rygel_basic_management_test_traceroute_real_handle_output;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = rygel_basic_management_test_traceroute_real_get_method_type;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = rygel_basic_management_test_traceroute_real_get_results_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_traceroute_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_traceroute_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_traceroute_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST_PROPERTY, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST_PROPERTY] = g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT_PROPERTY, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT_PROPERTY] = g_param_spec_uint ("wait-time-out", "wait-time-out", "wait-time-out", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE_PROPERTY, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE_PROPERTY] = g_param_spec_uint ("data-block-size", "data-block-size", "data-block-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT_PROPERTY, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT_PROPERTY] = g_param_spec_uint ("max-hop-count", "max-hop-count", "max-hop-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP_PROPERTY, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP_PROPERTY] = g_param_spec_uint ("dscp", "dscp", "dscp", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE_PROPERTY, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE_PROPERTY] = g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE_PROPERTY, rygel_basic_management_test_traceroute_properties[RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE_PROPERTY] = g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_basic_management_test_traceroute_instance_init (RygelBasicManagementTestTraceroute * self,
                                                      gpointer klass)
{
	gchar* _tmp0_;
	self->priv = rygel_basic_management_test_traceroute_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_host = _tmp0_;
	self->priv->_wait_time_out = (guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT;
	self->priv->_data_block_size = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE;
	self->priv->_max_hop_count = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS;
	self->priv->_dscp = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP;
}

static void
rygel_basic_management_test_traceroute_finalize (GObject * obj)
{
	RygelBasicManagementTestTraceroute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
	_g_free0 (self->priv->_host);
	_g_regex_unref0 (self->priv->regex);
	_g_regex_unref0 (self->priv->rtt_regex);
	_g_free0 (self->priv->host_ip);
	_g_free0 (self->priv->additional_info);
	_g_free0 (self->priv->hop_ips);
	G_OBJECT_CLASS (rygel_basic_management_test_traceroute_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_basic_management_test_traceroute_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestTracerouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_traceroute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestTraceroute), 0, (GInstanceInitFunc) rygel_basic_management_test_traceroute_instance_init, NULL };
	GType rygel_basic_management_test_traceroute_type_id;
	rygel_basic_management_test_traceroute_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestTraceroute", &g_define_type_info, 0);
	RygelBasicManagementTestTraceroute_private_offset = g_type_add_instance_private (rygel_basic_management_test_traceroute_type_id, sizeof (RygelBasicManagementTestTraceroutePrivate));
	return rygel_basic_management_test_traceroute_type_id;
}

GType
rygel_basic_management_test_traceroute_get_type (void)
{
	static volatile gsize rygel_basic_management_test_traceroute_type_id__once = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_type_id__once)) {
		GType rygel_basic_management_test_traceroute_type_id;
		rygel_basic_management_test_traceroute_type_id = rygel_basic_management_test_traceroute_get_type_once ();
		g_once_init_leave (&rygel_basic_management_test_traceroute_type_id__once, rygel_basic_management_test_traceroute_type_id);
	}
	return rygel_basic_management_test_traceroute_type_id__once;
}

static void
_vala_rygel_basic_management_test_traceroute_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	RygelBasicManagementTestTraceroute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_traceroute_get_host (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_wait_time_out (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_data_block_size (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_max_hop_count (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_dscp (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_basic_management_test_traceroute_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	RygelBasicManagementTestTraceroute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST_PROPERTY:
		rygel_basic_management_test_traceroute_set_host (self, g_value_get_string (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT_PROPERTY:
		rygel_basic_management_test_traceroute_set_wait_time_out (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE_PROPERTY:
		rygel_basic_management_test_traceroute_set_data_block_size (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT_PROPERTY:
		rygel_basic_management_test_traceroute_set_max_hop_count (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP_PROPERTY:
		rygel_basic_management_test_traceroute_set_dscp (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

