/* rygel-http-subtitle-handler.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-http-subtitle-handler.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_TYPE_HTTP_SUBTITLE_HANDLER (rygel_http_subtitle_handler_get_type ())
#define RYGEL_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandler))
#define RYGEL_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_HTTP_SUBTITLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))

typedef struct _RygelHTTPSubtitleHandler RygelHTTPSubtitleHandler;
typedef struct _RygelHTTPSubtitleHandlerClass RygelHTTPSubtitleHandlerClass;
typedef struct _RygelHTTPSubtitleHandlerPrivate RygelHTTPSubtitleHandlerPrivate;
enum  {
	RYGEL_HTTP_SUBTITLE_HANDLER_0_PROPERTY,
	RYGEL_HTTP_SUBTITLE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* rygel_http_subtitle_handler_properties[RYGEL_HTTP_SUBTITLE_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSubtitleHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPSubtitleHandlerPrivate * priv;
	RygelSubtitle* subtitle;
};

struct _RygelHTTPSubtitleHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPSubtitleHandlerPrivate {
	RygelMediaFileItem* media_item;
	gint subtitle_index;
};

static gint RygelHTTPSubtitleHandler_private_offset;
static gpointer rygel_http_subtitle_handler_parent_class = NULL;

VALA_EXTERN GType rygel_http_subtitle_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_new (RygelMediaFileItem* media_item,
                                                           gint subtitle_index,
                                                           GCancellable* cancellable,
                                                           GError** error);
VALA_EXTERN RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_construct (GType object_type,
                                                                 RygelMediaFileItem* media_item,
                                                                 gint subtitle_index,
                                                                 GCancellable* cancellable,
                                                                 GError** error);
static gboolean rygel_http_subtitle_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                                  const gchar* mode);
static void rygel_http_subtitle_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                            RygelHTTPGet* request,
                                                            GError** error);
static RygelHTTPResponse* rygel_http_subtitle_handler_real_render_body (RygelHTTPGetHandler* base,
                                                                 RygelHTTPGet* request,
                                                                 GError** error);
static gint64 rygel_http_subtitle_handler_real_get_resource_size (RygelHTTPGetHandler* base);
static gboolean rygel_http_subtitle_handler_real_supports_byte_seek (RygelHTTPGetHandler* base);
static void rygel_http_subtitle_handler_finalize (GObject * obj);
static GType rygel_http_subtitle_handler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_subtitle_handler_get_instance_private (RygelHTTPSubtitleHandler* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPSubtitleHandler_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelHTTPSubtitleHandler*
rygel_http_subtitle_handler_construct (GType object_type,
                                       RygelMediaFileItem* media_item,
                                       gint subtitle_index,
                                       GCancellable* cancellable,
                                       GError** error)
{
	RygelHTTPSubtitleHandler * self = NULL;
	RygelMediaFileItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelSubtitle* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (media_item != NULL, NULL);
	self = (RygelHTTPSubtitleHandler*) rygel_http_get_handler_construct (object_type);
	_tmp0_ = _g_object_ref0 (media_item);
	_g_object_unref0 (self->priv->media_item);
	self->priv->media_item = _tmp0_;
	self->priv->subtitle_index = subtitle_index;
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, cancellable);
	if (subtitle_index >= 0) {
		_tmp1_ = RYGEL_IS_VIDEO_ITEM (media_item);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		RygelVideoItem* video_item = NULL;
		RygelVideoItem* _tmp2_;
		RygelVideoItem* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp2_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (media_item) ? ((RygelVideoItem*) media_item) : NULL);
		video_item = _tmp2_;
		_tmp3_ = video_item;
		_tmp4_ = rygel_video_item_get_subtitles (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (subtitle_index < _tmp7_) {
			RygelVideoItem* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			_tmp8_ = video_item;
			_tmp9_ = rygel_video_item_get_subtitles (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, subtitle_index);
			_rygel_subtitle_unref0 (self->subtitle);
			self->subtitle = (RygelSubtitle*) _tmp11_;
		}
		_g_object_unref0 (video_item);
	}
	_tmp12_ = self->subtitle;
	if (_tmp12_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
		_tmp13_ = g_strdup ("Subtitle index %d not found for item '%s");
		msg = _tmp13_;
		_tmp14_ = msg;
		_tmp15_ = rygel_media_object_get_id ((RygelMediaObject*) media_item);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp14_, subtitle_index, _tmp16_);
		_inner_error0_ = _tmp17_;
		if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	return self;
}

RygelHTTPSubtitleHandler*
rygel_http_subtitle_handler_new (RygelMediaFileItem* media_item,
                                 gint subtitle_index,
                                 GCancellable* cancellable,
                                 GError** error)
{
	return rygel_http_subtitle_handler_construct (RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, media_item, subtitle_index, cancellable, error);
}

static gboolean
rygel_http_subtitle_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                         const gchar* mode)
{
	RygelHTTPSubtitleHandler * self;
	gboolean result;
	self = (RygelHTTPSubtitleHandler*) base;
	g_return_val_if_fail (mode != NULL, FALSE);
	result = g_strcmp0 (mode, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING) != 0;
	return result;
}

static void
rygel_http_subtitle_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                       RygelHTTPGet* request,
                                                       GError** error)
{
	RygelHTTPSubtitleHandler * self;
	SoupServerMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	RygelSubtitle* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaResource* res = NULL;
	RygelMediaFileItem* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	gpointer _tmp7_;
	RygelMediaResource* _tmp8_;
	gchar* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp9_;
	GUPnPProtocolInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** pi_fields = NULL;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint pi_fields_length1;
	gint _pi_fields_size_;
	SoupServerMessage* _tmp15_;
	SoupMessageHeaders* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	self = (RygelHTTPSubtitleHandler*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = ((RygelHTTPRequest*) request)->msg;
	_tmp1_ = soup_server_message_get_response_headers (_tmp0_);
	_tmp2_ = self->subtitle;
	_tmp3_ = _tmp2_->mime_type;
	soup_message_headers_append (_tmp1_, "Content-Type", _tmp3_);
	_tmp4_ = self->priv->media_item;
	_tmp5_ = rygel_media_object_get_resource_list ((RygelMediaObject*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_list_get (_tmp6_, 0);
	_tmp8_ = (RygelMediaResource*) _tmp7_;
	_g_object_unref0 (_tmp6_);
	res = _tmp8_;
	_tmp9_ = rygel_media_resource_get_protocol_info (res, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = gupnp_protocol_info_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	protocol_info = _tmp12_;
	_tmp14_ = _tmp13_ = g_strsplit (protocol_info, ":", 4);
	pi_fields = _tmp14_;
	pi_fields_length1 = _vala_array_length (_tmp13_);
	_pi_fields_size_ = pi_fields_length1;
	_tmp15_ = ((RygelHTTPRequest*) request)->msg;
	_tmp16_ = soup_server_message_get_response_headers (_tmp15_);
	_tmp17_ = pi_fields[3];
	soup_message_headers_append (_tmp16_, "contentFeatures.dlna.org", _tmp17_);
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_subtitle_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), request, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (protocol_info);
			_g_object_unref0 (res);
			return;
		} else {
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (protocol_info);
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (protocol_info);
	_g_object_unref0 (res);
}

static RygelHTTPResponse*
rygel_http_subtitle_handler_real_render_body (RygelHTTPGetHandler* base,
                                              RygelHTTPGet* request,
                                              GError** error)
{
	RygelHTTPSubtitleHandler * self;
	RygelDataSource* src = NULL;
	GError* _inner_error0_ = NULL;
	RygelHTTPResponse* result;
	self = (RygelHTTPSubtitleHandler*) base;
	g_return_val_if_fail (request != NULL, NULL);
	{
		RygelMediaEngine* engine = NULL;
		RygelMediaEngine* _tmp0_;
		RygelDataSource* _tmp1_ = NULL;
		RygelMediaEngine* _tmp2_;
		RygelSubtitle* _tmp3_;
		const gchar* _tmp4_;
		RygelDataSource* _tmp5_;
		RygelDataSource* _tmp6_;
		RygelHTTPResponse* _tmp7_ = NULL;
		RygelDataSource* _tmp8_;
		RygelHTTPResponse* _tmp9_;
		RygelHTTPResponse* _tmp10_;
		_tmp0_ = rygel_media_engine_get_default ();
		engine = _tmp0_;
		_tmp2_ = engine;
		_tmp3_ = self->subtitle;
		_tmp4_ = _tmp3_->uri;
		_tmp5_ = rygel_media_engine_create_data_source_for_uri (_tmp2_, _tmp4_, &_inner_error0_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (engine);
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (src);
		src = _tmp6_;
		_tmp8_ = src;
		_tmp9_ = rygel_http_response_new (request, (RygelHTTPGetHandler*) self, _tmp8_, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (engine);
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (engine);
		_g_object_unref0 (src);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp12_);
		_inner_error0_ = _tmp13_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (src);
		return NULL;
	} else {
		_g_object_unref0 (src);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gint64
rygel_http_subtitle_handler_real_get_resource_size (RygelHTTPGetHandler* base)
{
	RygelHTTPSubtitleHandler * self;
	RygelSubtitle* _tmp0_;
	gint64 result;
	self = (RygelHTTPSubtitleHandler*) base;
	_tmp0_ = self->subtitle;
	result = _tmp0_->size;
	return result;
}

static gboolean
rygel_http_subtitle_handler_real_supports_byte_seek (RygelHTTPGetHandler* base)
{
	RygelHTTPSubtitleHandler * self;
	gboolean result;
	self = (RygelHTTPSubtitleHandler*) base;
	result = TRUE;
	return result;
}

static void
rygel_http_subtitle_handler_class_init (RygelHTTPSubtitleHandlerClass * klass,
                                        gpointer klass_data)
{
	rygel_http_subtitle_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPSubtitleHandler_private_offset);
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = (gboolean (*) (RygelHTTPGetHandler*, const gchar*)) rygel_http_subtitle_handler_real_supports_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = (void (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_subtitle_handler_real_add_response_headers;
	((RygelHTTPGetHandlerClass *) klass)->render_body = (RygelHTTPResponse* (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_subtitle_handler_real_render_body;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = (gint64 (*) (RygelHTTPGetHandler*)) rygel_http_subtitle_handler_real_get_resource_size;
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_subtitle_handler_real_supports_byte_seek;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_subtitle_handler_finalize;
}

static void
rygel_http_subtitle_handler_instance_init (RygelHTTPSubtitleHandler * self,
                                           gpointer klass)
{
	self->priv = rygel_http_subtitle_handler_get_instance_private (self);
}

static void
rygel_http_subtitle_handler_finalize (GObject * obj)
{
	RygelHTTPSubtitleHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandler);
	_g_object_unref0 (self->priv->media_item);
	_rygel_subtitle_unref0 (self->subtitle);
	G_OBJECT_CLASS (rygel_http_subtitle_handler_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_http_subtitle_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPSubtitleHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_subtitle_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPSubtitleHandler), 0, (GInstanceInitFunc) rygel_http_subtitle_handler_instance_init, NULL };
	GType rygel_http_subtitle_handler_type_id;
	rygel_http_subtitle_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPSubtitleHandler", &g_define_type_info, 0);
	RygelHTTPSubtitleHandler_private_offset = g_type_add_instance_private (rygel_http_subtitle_handler_type_id, sizeof (RygelHTTPSubtitleHandlerPrivate));
	return rygel_http_subtitle_handler_type_id;
}

GType
rygel_http_subtitle_handler_get_type (void)
{
	static volatile gsize rygel_http_subtitle_handler_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_subtitle_handler_type_id__once)) {
		GType rygel_http_subtitle_handler_type_id;
		rygel_http_subtitle_handler_type_id = rygel_http_subtitle_handler_get_type_once ();
		g_once_init_leave (&rygel_http_subtitle_handler_type_id__once, rygel_http_subtitle_handler_type_id);
	}
	return rygel_http_subtitle_handler_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

