/* rygel-http-time-seek-request.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-http-time-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <libsoup/soup.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>

enum  {
	RYGEL_HTTP_TIME_SEEK_REQUEST_0_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_REQUEST_NUM_PROPERTIES
};
static GParamSpec* rygel_http_time_seek_request_properties[RYGEL_HTTP_TIME_SEEK_REQUEST_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_CLIENT_HACKS_ERROR (rygel_client_hacks_error_get_type ())

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_http_time_seek_request_parent_class = NULL;

VALA_EXTERN RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (SoupServerMessage* message,
                                                            RygelHTTPGetHandler* handler,
                                                            RygelPlaySpeed* speed,
                                                            GError** error);
VALA_EXTERN RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type,
                                                                  SoupServerMessage* message,
                                                                  RygelHTTPGetHandler* handler,
                                                                  RygelPlaySpeed* speed,
                                                                  GError** error);
static gboolean rygel_http_time_seek_request_parse_npt_time (const gchar* range_token,
                                                      gint64* value);
VALA_EXTERN GType rygel_client_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark rygel_client_hacks_error_quark (void);
GType rygel_client_hacks_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelClientHacks* rygel_client_hacks_create (SoupServerMessage* message,
                                             GError** error);
VALA_EXTERN gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
static gboolean rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token,
                                                         gint64* value);
static void rygel_http_time_seek_request_finalize (GObject * obj);
static GType rygel_http_time_seek_request_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
     * Create a HTTPTimeSeekRequest corresponding with a HTTPGet that contains a
     * TimeSeekRange.dlna.org header value.
     *
     * Note: This constructor will check the syntax of the request (per DLNA
     * 7.5.4.3.2.24.3) as well as perform some range validation. If the
     * provided request is associated with a handler that can provide content
     * duration, the start and end time will be checked for out-of-bounds
     * conditions. Additionally, the start and end will be checked according
     * to playspeed direction (with rate +1.0 assumed when speed is not
     * provided). When speed is provided, the range end parameter check is
     * relaxed when the rate is not +1.0 (per DLNA 7.5.4.3.2.24.4).
     *
     * @param request The HTTP GET/HEAD request
     * @param speed An associated speed request
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

RygelHTTPTimeSeekRequest*
rygel_http_time_seek_request_construct (GType object_type,
                                        SoupServerMessage* message,
                                        RygelHTTPGetHandler* handler,
                                        RygelPlaySpeed* speed,
                                        GError** error)
{
	RygelHTTPTimeSeekRequest * self = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean positive_rate = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean trick_mode = FALSE;
	gchar* range = NULL;
	SoupMessageHeaders* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp7_;
	gchar* parsed_range = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar** range_tokens = NULL;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint range_tokens_length1;
	gint _range_tokens_size_;
	gint64 start = 0LL;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp23_ = FALSE;
	gint64 end = 0LL;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	gboolean _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelHTTPTimeSeekRequest*) rygel_http_seek_request_construct (object_type);
	if (speed == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = rygel_play_speed_is_positive (speed);
	}
	positive_rate = _tmp0_;
	if (speed != NULL) {
		_tmp1_ = !rygel_play_speed_is_normal_rate (speed);
	} else {
		_tmp1_ = FALSE;
	}
	trick_mode = _tmp1_;
	self->total_duration = rygel_http_get_handler_get_resource_duration (handler);
	if (self->total_duration <= ((gint64) 0)) {
		self->total_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp2_ = soup_server_message_get_request_headers (message);
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
	_tmp4_ = g_strdup (_tmp3_);
	range = _tmp4_;
	_tmp5_ = range;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "%s not present", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = range;
	if (!g_str_has_prefix (_tmp7_, "npt=")) {
		const gchar* _tmp8_;
		GError* _tmp9_;
		_tmp8_ = range;
		_tmp9_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (missing npt field): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp8_);
		_inner_error0_ = _tmp9_;
		if (_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = range;
	_tmp11_ = string_substring (_tmp10_, (glong) 4, (glong) -1);
	parsed_range = _tmp11_;
	_tmp12_ = parsed_range;
	if (!string_contains (_tmp12_, "-")) {
		const gchar* _tmp13_;
		GError* _tmp14_;
		_tmp13_ = range;
		_tmp14_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s request with no '-': '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp13_);
		_inner_error0_ = _tmp14_;
		if (_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (parsed_range);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (parsed_range);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = parsed_range;
	_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "-", 2);
	range_tokens = _tmp17_;
	range_tokens_length1 = _vala_array_length (_tmp16_);
	_range_tokens_size_ = range_tokens_length1;
	start = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	_tmp18_ = range_tokens;
	_tmp18__length1 = range_tokens_length1;
	_tmp19_ = _tmp18_[0];
	_tmp20_ = rygel_http_time_seek_request_parse_npt_time (_tmp19_, &start);
	if (!_tmp20_) {
		const gchar* _tmp21_;
		GError* _tmp22_;
		_tmp21_ = range;
		_tmp22_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (no start): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp21_);
		_inner_error0_ = _tmp22_;
		if (_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (self->total_duration != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp23_ = start > self->total_duration;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gboolean _tmp24_ = FALSE;
		if (trick_mode) {
			_tmp24_ = !positive_rate;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			self->start_time = self->total_duration;
		} else {
			gchar* msg = NULL;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			GError* _tmp27_;
			_tmp25_ = g_strdup ("Invalid %s start time %lldns is beyond the content duration of %lldns");
			msg = _tmp25_;
			_tmp26_ = msg;
			_tmp27_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp26_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, start, self->total_duration);
			_inner_error0_ = _tmp27_;
			if (_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (msg);
		}
	} else {
		self->start_time = start;
	}
	end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	_tmp28_ = range_tokens;
	_tmp28__length1 = range_tokens_length1;
	_tmp29_ = _tmp28_[1];
	_tmp30_ = rygel_http_time_seek_request_parse_npt_time (_tmp29_, &end);
	if (_tmp30_) {
		if (positive_rate) {
			gboolean _tmp31_ = FALSE;
			if (self->total_duration != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
				_tmp31_ = end > self->total_duration;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				if (trick_mode) {
					self->end_time = self->total_duration;
				} else {
					gchar* msg = NULL;
					gchar* _tmp32_;
					const gchar* _tmp33_;
					GError* _tmp34_;
					_tmp32_ = g_strdup ("Invalid %s start time %lldns is beyond the content duration of %lldns");
					msg = _tmp32_;
					_tmp33_ = msg;
					_tmp34_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp33_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, end, self->total_duration);
					_inner_error0_ = _tmp34_;
					if (_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (msg);
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (parsed_range);
						_g_free0 (range);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_free0 (msg);
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (parsed_range);
						_g_free0 (range);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_g_free0 (msg);
				}
			} else {
				self->end_time = end;
			}
			self->range_duration = self->end_time - self->start_time;
			if (self->range_duration <= ((gint64) 0)) {
				gchar* msg = NULL;
				gchar* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				GError* _tmp38_;
				_tmp35_ = g_strdup ("Invalid %s value (start time after end time - forward scan): '%s'");
				msg = _tmp35_;
				_tmp36_ = msg;
				_tmp37_ = range;
				_tmp38_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp36_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp37_);
				_inner_error0_ = _tmp38_;
				if (_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (msg);
			}
		} else {
			self->end_time = end;
			self->range_duration = self->start_time - self->end_time;
			if (self->range_duration <= ((gint64) 0)) {
				gchar* msg = NULL;
				gchar* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				GError* _tmp42_;
				_tmp39_ = g_strdup ("Invalid %s value (start time before end time - reverse scan): '%s'");
				msg = _tmp39_;
				_tmp40_ = msg;
				_tmp41_ = range;
				_tmp42_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp40_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp41_);
				_inner_error0_ = _tmp42_;
				if (_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (msg);
			}
		}
	} else {
		self->end_time = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		if (self->total_duration == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			self->range_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		} else {
			if (positive_rate) {
				self->end_time = self->total_duration - G_TIME_SPAN_MILLISECOND;
				self->range_duration = self->total_duration - self->start_time;
			} else {
				self->end_time = (gint64) 0;
				self->range_duration = self->start_time;
			}
		}
	}
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parsed_range);
	_g_free0 (range);
	return self;
}

RygelHTTPTimeSeekRequest*
rygel_http_time_seek_request_new (SoupServerMessage* message,
                                  RygelHTTPGetHandler* handler,
                                  RygelPlaySpeed* speed,
                                  GError** error)
{
	return rygel_http_time_seek_request_construct (RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, message, handler, speed, error);
}

gchar*
rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->end_time != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, self->end_time);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("*");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup_printf ("HTTPTimeSeekRequest (npt=%lld-%s)", self->start_time, _tmp0_);
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

/**
     * Return true if time-seek is supported.
     *
     * This method utilizes elements associated with the request to determine if
     * a TimeSeekRange request is supported for the given request/resource.
     */
gboolean
rygel_http_time_seek_request_supported (SoupServerMessage* message,
                                        RygelHTTPGetHandler* handler)
{
	gboolean force_seek = FALSE;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelClientHacks* hack = NULL;
		RygelClientHacks* _tmp0_;
		_tmp0_ = rygel_client_hacks_create (message, &_inner_error0_);
		hack = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		force_seek = rygel_client_hacks_force_seek (hack);
		_g_object_unref0 (hack);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp1_;
	}
	if (force_seek) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = rygel_http_get_handler_supports_time_seek (handler);
	}
	result = _tmp2_;
	return result;
}

/**
     * Return true of the HTTPGet contains a TimeSeekRange request.
     */
gboolean
rygel_http_time_seek_request_requested (SoupServerMessage* message)
{
	gchar* header = NULL;
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = soup_server_message_get_request_headers (message);
	_tmp1_ = soup_message_headers_get_one (_tmp0_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
	_tmp2_ = g_strdup (_tmp1_);
	header = _tmp2_;
	result = header != NULL;
	_g_free0 (header);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gboolean
rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token,
                                                gint64* value)
{
	gboolean result;
	g_return_val_if_fail (range_token != NULL, FALSE);
	if (g_ascii_isdigit (string_get (range_token, (glong) 0))) {
		*value = (gint64) (double_parse (range_token) * G_TIME_SPAN_SECOND);
	} else {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
rygel_http_time_seek_request_parse_npt_time (const gchar* range_token,
                                             gint64* value)
{
	gint64 seconds_sum = 0LL;
	gint time_factor = 0;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gboolean result;
	if (range_token == NULL) {
		result = FALSE;
		return result;
	}
	if (string_index_of (range_token, ":", 0) == -1) {
		gboolean _tmp0_;
		_tmp0_ = rygel_http_time_seek_request_parse_npt_seconds (range_token, value);
		result = _tmp0_;
		return result;
	}
	seconds_sum = (gint64) 0;
	time_factor = 0;
	seconds_sum = (gint64) 0;
	time_factor = 3600;
	_tmp2_ = _tmp1_ = g_strsplit (range_token, ":", 3);
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	time_tokens = _tmp2_;
	time_tokens_length1 = _vala_array_length (_tmp1_);
	_time_tokens_size_ = time_tokens_length1;
	_tmp5_ = time_tokens;
	_tmp5__length1 = time_tokens_length1;
	_tmp6_ = _tmp5_[0];
	if (_tmp6_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		_tmp7_ = time_tokens;
		_tmp7__length1 = time_tokens_length1;
		_tmp8_ = _tmp7_[1];
		_tmp4_ = _tmp8_ == NULL;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = time_tokens;
		_tmp9__length1 = time_tokens_length1;
		_tmp10_ = _tmp9_[2];
		_tmp3_ = _tmp10_ == NULL;
	}
	if (_tmp3_) {
		result = FALSE;
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = time_tokens;
	_tmp11__length1 = time_tokens_length1;
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
		time_collection = _tmp11_;
		time_collection_length1 = _tmp11__length1;
		for (time_it = 0; time_it < time_collection_length1; time_it = time_it + 1) {
			gchar* _tmp12_;
			gchar* time = NULL;
			_tmp12_ = g_strdup (time_collection[time_it]);
			time = _tmp12_;
			{
				const gchar* _tmp13_;
				_tmp13_ = time;
				if (g_ascii_isdigit (string_get (_tmp13_, (glong) 0))) {
					const gchar* _tmp14_;
					_tmp14_ = time;
					seconds_sum += (gint64) ((double_parse (_tmp14_) * G_TIME_SPAN_SECOND) * time_factor);
				} else {
					result = FALSE;
					_g_free0 (time);
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				time_factor /= 60;
				_g_free0 (time);
			}
		}
	}
	*value = seconds_sum;
	result = TRUE;
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
rygel_http_time_seek_request_class_init (RygelHTTPTimeSeekRequestClass * klass,
                                         gpointer klass_data)
{
	rygel_http_time_seek_request_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_request_finalize;
}

static void
rygel_http_time_seek_request_instance_init (RygelHTTPTimeSeekRequest * self,
                                            gpointer klass)
{
}

static void
rygel_http_time_seek_request_finalize (GObject * obj)
{
	RygelHTTPTimeSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest);
	G_OBJECT_CLASS (rygel_http_time_seek_request_parent_class)->finalize (obj);
}

/**
 * This class represents a DLNA TimeSeekRange request.
 *
 * A TimeSeekRange request can only have a time range ("npt=start-end").
 */
 G_GNUC_NO_INLINE static GType
rygel_http_time_seek_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekRequest), 0, (GInstanceInitFunc) rygel_http_time_seek_request_instance_init, NULL };
	GType rygel_http_time_seek_request_type_id;
	rygel_http_time_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPTimeSeekRequest", &g_define_type_info, 0);
	return rygel_http_time_seek_request_type_id;
}

GType
rygel_http_time_seek_request_get_type (void)
{
	static volatile gsize rygel_http_time_seek_request_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_time_seek_request_type_id__once)) {
		GType rygel_http_time_seek_request_type_id;
		rygel_http_time_seek_request_type_id = rygel_http_time_seek_request_get_type_once ();
		g_once_init_leave (&rygel_http_time_seek_request_type_id__once, rygel_http_time_seek_request_type_id);
	}
	return rygel_http_time_seek_request_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

