/* rygel-playlist-item.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-playlist-item.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Krzesimir Nowak <krnowak@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <libgupnp-av/gupnp-av.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

enum  {
	RYGEL_PLAYLIST_ITEM_0_PROPERTY,
	RYGEL_PLAYLIST_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_playlist_item_properties[RYGEL_PLAYLIST_ITEM_NUM_PROPERTIES];

static gpointer rygel_playlist_item_parent_class = NULL;

static GUPnPDIDLLiteObject* rygel_playlist_item_real_serialize (RygelMediaObject* base,
                                                         RygelSerializer* serializer,
                                                         RygelHTTPServer* http_server,
                                                         GError** error);
static RygelMediaResource* rygel_playlist_item_real_get_primary_resource (RygelMediaFileItem* base);
static GType rygel_playlist_item_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

RygelPlaylistItem*
rygel_playlist_item_construct (GType object_type,
                               const gchar* id,
                               RygelMediaContainer* parent,
                               const gchar* title,
                               const gchar* upnp_class)
{
	RygelPlaylistItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelPlaylistItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

RygelPlaylistItem*
rygel_playlist_item_new (const gchar* id,
                         RygelMediaContainer* parent,
                         const gchar* title,
                         const gchar* upnp_class)
{
	return rygel_playlist_item_construct (RYGEL_TYPE_PLAYLIST_ITEM, id, parent, title, upnp_class);
}

static GUPnPDIDLLiteObject*
rygel_playlist_item_real_serialize (RygelMediaObject* base,
                                    RygelSerializer* serializer,
                                    RygelHTTPServer* http_server,
                                    GError** error)
{
	RygelPlaylistItem * self;
	GUPnPDIDLLiteObject* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp0_;
	GError* _inner_error0_ = NULL;
	GUPnPDIDLLiteObject* result;
	self = (RygelPlaylistItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_playlist_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), serializer, http_server, &_inner_error0_);
	didl_item = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	result = didl_item;
	return result;
}

static RygelMediaResource*
rygel_playlist_item_real_get_primary_resource (RygelMediaFileItem* base)
{
	RygelPlaylistItem * self;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_;
	GUPnPDLNAFlags _tmp1_;
	GUPnPDLNAFlags _tmp2_;
	RygelMediaResource* result;
	self = (RygelPlaylistItem*) base;
	_tmp0_ = RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_playlist_item_parent_class)->get_primary_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem));
	res = _tmp0_;
	_tmp1_ = rygel_media_resource_get_dlna_flags (res);
	_tmp2_ = _tmp1_;
	rygel_media_resource_set_dlna_flags (res, _tmp2_ | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
	result = res;
	return result;
}

static void
rygel_playlist_item_class_init (RygelPlaylistItemClass * klass,
                                gpointer klass_data)
{
	rygel_playlist_item_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_playlist_item_real_serialize;
	((RygelMediaFileItemClass *) klass)->get_primary_resource = (RygelMediaResource* (*) (RygelMediaFileItem*)) rygel_playlist_item_real_get_primary_resource;
}

static void
rygel_playlist_item_instance_init (RygelPlaylistItem * self,
                                   gpointer klass)
{
}

/**
 * Represents a playlist item.
 *
 * These objects correspond to DLNA's DIDL_S items.
 */
 G_GNUC_NO_INLINE static GType
rygel_playlist_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPlaylistItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playlist_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaylistItem), 0, (GInstanceInitFunc) rygel_playlist_item_instance_init, NULL };
	GType rygel_playlist_item_type_id;
	rygel_playlist_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_FILE_ITEM, "RygelPlaylistItem", &g_define_type_info, 0);
	return rygel_playlist_item_type_id;
}

GType
rygel_playlist_item_get_type (void)
{
	static volatile gsize rygel_playlist_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_playlist_item_type_id__once)) {
		GType rygel_playlist_item_type_id;
		rygel_playlist_item_type_id = rygel_playlist_item_get_type_once ();
		g_once_init_leave (&rygel_playlist_item_type_id__once, rygel_playlist_item_type_id);
	}
	return rygel_playlist_item_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

