/* rygel-tracker-picture-item-factory.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-tracker-picture-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-tracker3.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libtracker-sparql/tracker-sparql.h>
#include "rygel-server.h"
#include <glib-object.h>
#include "rygel-core.h"
#include <gee.h>

#define RYGEL_TRACKER_PICTURE_ITEM_FACTORY_CATEGORY "nmm:Photo"
#define RYGEL_TRACKER_PICTURE_ITEM_FACTORY_CATEGORY_IRI "http://www.tracker-project.org/" "temp/nmm#Photo"
#define RYGEL_TRACKER_PICTURE_ITEM_FACTORY_GRAPH "tracker:Pictures"

typedef enum  {
	RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT = RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY,
	RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH,
	RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_LAST_KEY
} RygelTrackerPictureItemFactoryPictureMetadata;

#define RYGEL_TRACKER_PICTURE_ITEM_FACTORY_TYPE_PICTURE_METADATA (rygel_tracker_picture_item_factory_picture_metadata_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_tracker_picture_item_factory_parent_class = NULL;

static GType rygel_tracker_picture_item_factory_picture_metadata_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static RygelMediaFileItem* rygel_tracker_picture_item_factory_real_create (RygelTrackerItemFactory* base,
                                                                    const gchar* id,
                                                                    const gchar* uri,
                                                                    RygelTrackerSearchContainer* parent,
                                                                    TrackerSparqlCursor* metadata,
                                                                    GError** error);
static void rygel_tracker_picture_item_factory_real_set_metadata (RygelTrackerItemFactory* base,
                                                           RygelMediaFileItem* item,
                                                           const gchar* uri,
                                                           TrackerSparqlCursor* metadata,
                                                           GError** error);
static GType rygel_tracker_picture_item_factory_get_type_once (void);

 G_GNUC_NO_INLINE static GType
rygel_tracker_picture_item_factory_picture_metadata_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT, "RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT", "height"}, {RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH, "RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH", "width"}, {RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_LAST_KEY, "RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
	GType rygel_tracker_picture_item_factory_picture_metadata_type_id;
	rygel_tracker_picture_item_factory_picture_metadata_type_id = g_enum_register_static ("RygelTrackerPictureItemFactoryPictureMetadata", values);
	return rygel_tracker_picture_item_factory_picture_metadata_type_id;
}

static GType
rygel_tracker_picture_item_factory_picture_metadata_get_type (void)
{
	static volatile gsize rygel_tracker_picture_item_factory_picture_metadata_type_id__once = 0;
	if (g_once_init_enter (&rygel_tracker_picture_item_factory_picture_metadata_type_id__once)) {
		GType rygel_tracker_picture_item_factory_picture_metadata_type_id;
		rygel_tracker_picture_item_factory_picture_metadata_type_id = rygel_tracker_picture_item_factory_picture_metadata_get_type_once ();
		g_once_init_leave (&rygel_tracker_picture_item_factory_picture_metadata_type_id__once, rygel_tracker_picture_item_factory_picture_metadata_type_id);
	}
	return rygel_tracker_picture_item_factory_picture_metadata_type_id__once;
}

RygelTrackerPictureItemFactory*
rygel_tracker_picture_item_factory_construct (GType object_type)
{
	RygelTrackerPictureItemFactory* self = NULL;
	gchar* upload_folder = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp1_ = g_strdup (_tmp0_);
	upload_folder = _tmp1_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		_tmp4_ = rygel_configuration_get_picture_upload_folder ((RygelConfiguration*) config, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (upload_folder);
		upload_folder = _tmp5_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (upload_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = upload_folder;
	self = (RygelTrackerPictureItemFactory*) rygel_tracker_item_factory_construct (object_type, RYGEL_TRACKER_PICTURE_ITEM_FACTORY_CATEGORY, RYGEL_TRACKER_PICTURE_ITEM_FACTORY_CATEGORY_IRI, RYGEL_TRACKER_PICTURE_ITEM_FACTORY_GRAPH, RYGEL_PHOTO_ITEM_UPNP_CLASS, _tmp6_);
	_tmp7_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "height");
	_tmp8_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "width");
	_g_free0 (upload_folder);
	return self;
}

RygelTrackerPictureItemFactory*
rygel_tracker_picture_item_factory_new (void)
{
	return rygel_tracker_picture_item_factory_construct (RYGEL_TRACKER_TYPE_PICTURE_ITEM_FACTORY);
}

static RygelMediaFileItem*
rygel_tracker_picture_item_factory_real_create (RygelTrackerItemFactory* base,
                                                const gchar* id,
                                                const gchar* uri,
                                                RygelTrackerSearchContainer* parent,
                                                TrackerSparqlCursor* metadata,
                                                GError** error)
{
	RygelTrackerPictureItemFactory * self;
	RygelPhotoItem* item = NULL;
	RygelPhotoItem* _tmp0_;
	GError* _inner_error0_ = NULL;
	RygelMediaFileItem* result;
	self = (RygelTrackerPictureItemFactory*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = rygel_photo_item_new (id, (RygelMediaContainer*) parent, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
	item = _tmp0_;
	rygel_tracker_item_factory_set_metadata ((RygelTrackerItemFactory*) self, (RygelMediaFileItem*) item, uri, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (item);
		return NULL;
	}
	result = (RygelMediaFileItem*) item;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_tracker_picture_item_factory_real_set_metadata (RygelTrackerItemFactory* base,
                                                      RygelMediaFileItem* item,
                                                      const gchar* uri,
                                                      TrackerSparqlCursor* metadata,
                                                      GError** error)
{
	RygelTrackerPictureItemFactory * self;
	RygelPhotoItem* photo = NULL;
	RygelPhotoItem* _tmp0_;
	RygelPhotoItem* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (RygelTrackerPictureItemFactory*) base;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_picture_item_factory_parent_class)->set_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory), item, uri, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	rygel_tracker_item_factory_set_ref_id ((RygelTrackerItemFactory*) self, item, "AllPictures");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_PHOTO_ITEM) ? ((RygelPhotoItem*) item) : NULL);
	photo = _tmp0_;
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH)) {
		RygelPhotoItem* _tmp1_;
		_tmp1_ = photo;
		rygel_visual_item_set_width ((RygelVisualItem*) _tmp1_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_WIDTH));
	}
	if (tracker_sparql_cursor_is_bound (metadata, (gint) RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT)) {
		RygelPhotoItem* _tmp2_;
		_tmp2_ = photo;
		rygel_visual_item_set_height ((RygelVisualItem*) _tmp2_, (gint) tracker_sparql_cursor_get_integer (metadata, (gint) RYGEL_TRACKER_PICTURE_ITEM_FACTORY_PICTURE_METADATA_HEIGHT));
	}
	_tmp3_ = photo;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_picture_item_factory_parent_class)->add_resources (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory), (RygelMediaFileItem*) _tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (photo);
		return;
	}
	_g_object_unref0 (photo);
}

static void
rygel_tracker_picture_item_factory_class_init (RygelTrackerPictureItemFactoryClass * klass,
                                               gpointer klass_data)
{
	rygel_tracker_picture_item_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelTrackerItemFactoryClass *) klass)->create = (RygelMediaFileItem* (*) (RygelTrackerItemFactory*, const gchar*, const gchar*, RygelTrackerSearchContainer*, TrackerSparqlCursor*, GError**)) rygel_tracker_picture_item_factory_real_create;
	((RygelTrackerItemFactoryClass *) klass)->set_metadata = (void (*) (RygelTrackerItemFactory*, RygelMediaFileItem*, const gchar*, TrackerSparqlCursor*, GError**)) rygel_tracker_picture_item_factory_real_set_metadata;
}

static void
rygel_tracker_picture_item_factory_instance_init (RygelTrackerPictureItemFactory * self,
                                                  gpointer klass)
{
}

/**
 * Tracker picture item factory.
 */
 G_GNUC_NO_INLINE static GType
rygel_tracker_picture_item_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerPictureItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_picture_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerPictureItemFactory), 0, (GInstanceInitFunc) rygel_tracker_picture_item_factory_instance_init, NULL };
	GType rygel_tracker_picture_item_factory_type_id;
	rygel_tracker_picture_item_factory_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_ITEM_FACTORY, "RygelTrackerPictureItemFactory", &g_define_type_info, 0);
	return rygel_tracker_picture_item_factory_type_id;
}

GType
rygel_tracker_picture_item_factory_get_type (void)
{
	static volatile gsize rygel_tracker_picture_item_factory_type_id__once = 0;
	if (g_once_init_enter (&rygel_tracker_picture_item_factory_type_id__once)) {
		GType rygel_tracker_picture_item_factory_type_id;
		rygel_tracker_picture_item_factory_type_id = rygel_tracker_picture_item_factory_get_type_once ();
		g_once_init_leave (&rygel_tracker_picture_item_factory_type_id__once, rygel_tracker_picture_item_factory_type_id);
	}
	return rygel_tracker_picture_item_factory_type_id__once;
}

