/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.runtime.InstanceManagerFactory;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.tomcat.InstanceManager;

public class TagHandlerPool {
    private Tag[] handlers;
    public static final String OPTION_TAGPOOL = "tagpoolClassName";
    public static final String OPTION_MAXSIZE = "tagpoolMaxSize";
    public static final String OPTION_USEIMFORTAGS = "useInstanceManagerForTags";
    private int current;
    protected InstanceManager instanceManager = null;
    protected boolean useInstanceManagerForTags;

    public static TagHandlerPool getTagHandlerPool(ServletConfig servletConfig) {
        TagHandlerPool tagHandlerPool = null;
        String string = TagHandlerPool.getOption(servletConfig, OPTION_TAGPOOL, null);
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                tagHandlerPool = (TagHandlerPool)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                tagHandlerPool = null;
            }
        }
        if (tagHandlerPool == null) {
            tagHandlerPool = new TagHandlerPool();
        }
        tagHandlerPool.init(servletConfig);
        return tagHandlerPool;
    }

    protected void init(ServletConfig servletConfig) {
        int n = -1;
        String string = TagHandlerPool.getOption(servletConfig, OPTION_MAXSIZE, null);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        if (n < 0) {
            n = 5;
        }
        String string2 = TagHandlerPool.getOption(servletConfig, OPTION_USEIMFORTAGS, "false");
        this.useInstanceManagerForTags = Boolean.valueOf(string2);
        this.handlers = new Tag[n];
        this.current = -1;
        this.instanceManager = InstanceManagerFactory.getInstanceManager(servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag get(Class<? extends Tag> clazz) throws JspException {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current >= 0) {
                Tag tag = this.handlers[this.current--];
                return tag;
            }
        }
        try {
            if (this.useInstanceManagerForTags) {
                return (Tag)this.instanceManager.newInstance(clazz.getName(), clazz.getClassLoader());
            }
            tagHandlerPool = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.instanceManager.newInstance((Object)tagHandlerPool);
            return tagHandlerPool;
        }
        catch (Exception exception) {
            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(exception);
            ExceptionUtils.handleThrowable(throwable);
            throw new JspException(exception.getMessage(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reuse(Tag tag) {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current < this.handlers.length - 1) {
                this.handlers[++this.current] = tag;
                return;
            }
        }
        JspRuntimeLibrary.releaseTag(tag, this.instanceManager);
    }

    public synchronized void release() {
        for (int i = this.current; i >= 0; --i) {
            JspRuntimeLibrary.releaseTag(this.handlers[i], this.instanceManager);
        }
    }

    protected static String getOption(ServletConfig servletConfig, String string, String string2) {
        if (servletConfig == null) {
            return string2;
        }
        String string3 = servletConfig.getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        if (servletConfig.getServletContext() == null) {
            return string2;
        }
        string3 = servletConfig.getServletContext().getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }
}

