/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileItemHeaders;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.ParameterParser;
import org.apache.tomcat.util.http.fileupload.ProgressListener;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.impl.FileItemIteratorImpl;
import org.apache.tomcat.util.http.fileupload.impl.FileUploadIOException;
import org.apache.tomcat.util.http.fileupload.impl.IOFileUploadException;
import org.apache.tomcat.util.http.fileupload.util.FileItemHeadersImpl;
import org.apache.tomcat.util.http.fileupload.util.Streams;

public abstract class FileUploadBase {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;
    private String headerEncoding;
    private ProgressListener listener;

    public abstract FileItemFactory getFileItemFactory();

    public abstract void setFileItemFactory(FileItemFactory var1);

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long l) {
        this.sizeMax = l;
    }

    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public void setFileSizeMax(long l) {
        this.fileSizeMax = l;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String string) {
        this.headerEncoding = string;
    }

    public FileItemIterator getItemIterator(RequestContext requestContext) throws FileUploadException, IOException {
        try {
            return new FileItemIteratorImpl(this, requestContext);
        }
        catch (FileUploadIOException fileUploadIOException) {
            throw (FileUploadException)fileUploadIOException.getCause();
        }
    }

    public List<FileItem> parseRequest(RequestContext requestContext) throws FileUploadException {
        ArrayList<FileItem> arrayList = new ArrayList<FileItem>();
        boolean bl = false;
        try {
            Object object;
            FileItemIterator fileItemIterator = this.getItemIterator(requestContext);
            FileItemFactory fileItemFactory = Objects.requireNonNull(this.getFileItemFactory(), "No FileItemFactory has been set.");
            byte[] byArray = new byte[8192];
            while (fileItemIterator.hasNext()) {
                object = fileItemIterator.next();
                String string = object.getName();
                FileItem fileItem = fileItemFactory.createItem(object.getFieldName(), object.getContentType(), object.isFormField(), string);
                arrayList.add(fileItem);
                try {
                    Streams.copy(object.openStream(), fileItem.getOutputStream(), true, byArray);
                }
                catch (FileUploadIOException fileUploadIOException) {
                    throw (FileUploadException)fileUploadIOException.getCause();
                }
                catch (IOException iOException) {
                    throw new IOFileUploadException(String.format("Processing of %s request failed. %s", MULTIPART_FORM_DATA, iOException.getMessage()), iOException);
                }
                FileItemHeaders fileItemHeaders = object.getHeaders();
                fileItem.setHeaders(fileItemHeaders);
            }
            bl = true;
            object = arrayList;
            return object;
        }
        catch (FileUploadException fileUploadException) {
            throw fileUploadException;
        }
        catch (IOException iOException) {
            throw new FileUploadException(iOException.getMessage(), iOException);
        }
        finally {
            if (!bl) {
                for (FileItem fileItem : arrayList) {
                    try {
                        fileItem.delete();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public byte[] getBoundary(String string) {
        ParameterParser parameterParser = new ParameterParser();
        parameterParser.setLowerCaseNames(true);
        Map<String, String> map = parameterParser.parse(string, new char[]{';', ','});
        String string2 = map.get("boundary");
        if (string2 == null) {
            return null;
        }
        byte[] byArray = string2.getBytes(StandardCharsets.ISO_8859_1);
        return byArray;
    }

    public String getFileName(FileItemHeaders fileItemHeaders) {
        return this.getFileName(fileItemHeaders.getHeader(CONTENT_DISPOSITION));
    }

    private String getFileName(String string) {
        String string2;
        String string3 = null;
        if (string != null && ((string2 = string.toLowerCase(Locale.ENGLISH)).startsWith(FORM_DATA) || string2.startsWith(ATTACHMENT))) {
            ParameterParser parameterParser = new ParameterParser();
            parameterParser.setLowerCaseNames(true);
            Map<String, String> map = parameterParser.parse(string, ';');
            if (map.containsKey("filename")) {
                string3 = map.get("filename");
                string3 = string3 != null ? string3.trim() : "";
            }
        }
        return string3;
    }

    public String getFieldName(FileItemHeaders fileItemHeaders) {
        return this.getFieldName(fileItemHeaders.getHeader(CONTENT_DISPOSITION));
    }

    private String getFieldName(String string) {
        String string2 = null;
        if (string != null && string.toLowerCase(Locale.ENGLISH).startsWith(FORM_DATA)) {
            ParameterParser parameterParser = new ParameterParser();
            parameterParser.setLowerCaseNames(true);
            Map<String, String> map = parameterParser.parse(string, ';');
            string2 = map.get("name");
            if (string2 != null) {
                string2 = string2.trim();
            }
        }
        return string2;
    }

    public FileItemHeaders getParsedHeaders(String string) {
        int n;
        int n2 = string.length();
        FileItemHeadersImpl fileItemHeadersImpl = this.newFileItemHeaders();
        int n3 = 0;
        while (n3 != (n = this.parseEndOfLine(string, n3))) {
            StringBuilder stringBuilder = new StringBuilder(string.substring(n3, n));
            n3 = n + 2;
            while (n3 < n2) {
                char c;
                int n4;
                for (n4 = n3; n4 < n2 && ((c = string.charAt(n4)) == ' ' || c == '\t'); ++n4) {
                }
                if (n4 == n3) break;
                n = this.parseEndOfLine(string, n4);
                stringBuilder.append(' ').append(string, n4, n);
                n3 = n + 2;
            }
            this.parseHeaderLine(fileItemHeadersImpl, stringBuilder.toString());
        }
        return fileItemHeadersImpl;
    }

    protected FileItemHeadersImpl newFileItemHeaders() {
        return new FileItemHeadersImpl();
    }

    private int parseEndOfLine(String string, int n) {
        int n2 = n;
        while (true) {
            int n3;
            if ((n3 = string.indexOf(13, n2)) == -1 || n3 + 1 >= string.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (string.charAt(n3 + 1) == '\n') {
                return n3;
            }
            n2 = n3 + 1;
        }
    }

    private void parseHeaderLine(FileItemHeadersImpl fileItemHeadersImpl, String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        fileItemHeadersImpl.addHeader(string2, string3);
    }

    public ProgressListener getProgressListener() {
        return this.listener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }
}

