/*
* THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
*
* Copyright (C) 2018 Apple Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
* THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "config.h"
#include "WebPreferences.h"

#include "WebPreferencesDefinitions.h"
#include "WebPreferencesKeys.h"

namespace WebKit {

const Vector<RefPtr<API::Object>>& WebPreferences::internalDebugFeatures()
{
    static NeverDestroyed<Vector<RefPtr<API::Object>>> features(std::initializer_list<RefPtr<API::Object>> {
#if USE(CORE_IMAGE)
        API::InternalDebugFeature::create("Accelerated Filter Rendering"""_s, "AcceleratedFiltersEnabled"_s, "Accelerated CSS and SVG filter rendering"""_s, DEFAULT_VALUE_FOR_AcceleratedFiltersEnabled, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("Allow Viewport Shrink to Fit Content"""_s, "AllowViewportShrinkToFitContent"_s, "Allow the viewport shrink to fit content heuristic when appropriate"""_s, DEFAULT_VALUE_FOR_AllowViewportShrinkToFitContent, false),
#endif
#if ENABLE(ALTERNATE_WEBM_PLAYER)
        API::InternalDebugFeature::create("Alternate WebM Player"""_s, "AlternateWebMPlayerEnabled"_s, "Enable Alternate WebM Player"""_s, DEFAULT_VALUE_FOR_AlternateWebMPlayerEnabled, false),
#endif
        API::InternalDebugFeature::create("Async Frame Scrolling"""_s, "AsyncFrameScrollingEnabled"_s, "Perform frame scrolling off the main thread"""_s, DEFAULT_VALUE_FOR_AsyncFrameScrollingEnabled, false),
        API::InternalDebugFeature::create("Async Overflow Scrolling"""_s, "AsyncOverflowScrollingEnabled"_s, "Perform overflow scrolling off the main thread"""_s, DEFAULT_VALUE_FOR_AsyncOverflowScrollingEnabled, false),
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        API::InternalDebugFeature::create("CG Display Lists: DOM Rendering"""_s, "UseCGDisplayListsForDOMRendering"_s, "Use CG Display Lists for DOM rendering"""_s, DEFAULT_VALUE_FOR_UseCGDisplayListsForDOMRendering, false),
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        API::InternalDebugFeature::create("CG Display Lists: Out-of-line Surfaces"""_s, "UseCGDisplayListOutOfLineSurfaces"_s, "Encode surfaces out-of-line for CG Display List image buffers."""_s, DEFAULT_VALUE_FOR_UseCGDisplayListOutOfLineSurfaces, false),
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        API::InternalDebugFeature::create("CG Display Lists: Replay for Testing"""_s, "ReplayCGDisplayListsIntoBackingStore"_s, "Replay CG Display Lists into layer contents for testing"""_s, DEFAULT_VALUE_FOR_ReplayCGDisplayListsIntoBackingStore, false),
#endif
        API::InternalDebugFeature::create("CSS Logical Properties and Values"""_s, "CSSLogicalEnabled"_s, "Enable CSS Logical Properties and Values"""_s, DEFAULT_VALUE_FOR_CSSLogicalEnabled, false),
        API::InternalDebugFeature::create("CSSOM View Scrolling API"""_s, "CSSOMViewScrollingAPIEnabled"_s, "Implement standard behavior for scrollLeft, scrollTop, scrollWidth, scrollHeight, scrollTo, scrollBy and scrollingElement."""_s, DEFAULT_VALUE_FOR_CSSOMViewScrollingAPIEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Capture audio in UI Process"""_s, "CaptureAudioInUIProcessEnabled"_s, "Enable audio capture in UI Process"""_s, DEFAULT_VALUE_FOR_CaptureAudioInUIProcessEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Capture video in UI Process"""_s, "CaptureVideoInUIProcessEnabled"_s, "Enable video capture in UI Process"""_s, DEFAULT_VALUE_FOR_CaptureVideoInUIProcessEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        API::InternalDebugFeature::create("Color Inputs"""_s, "InputTypeColorEnabled"_s, "Enable input elements of type color"""_s, DEFAULT_VALUE_FOR_InputTypeColorEnabled, false),
#endif
#if HAVE(AVCONTENTKEYSPECIFIER)
        API::InternalDebugFeature::create("ContentKeySession support for SampleBuffer Renderers"""_s, "SampleBufferContentKeySessionSupportEnabled"_s, "ContentKeySession support for SampleBuffer Renderers Enabled"""_s, DEFAULT_VALUE_FOR_SampleBufferContentKeySessionSupportEnabled, false),
#endif
        API::InternalDebugFeature::create("Cookie Consent API"""_s, "CookieConsentAPIEnabled"_s, "Enable cookie consent API"""_s, DEFAULT_VALUE_FOR_CookieConsentAPIEnabled, false),
        API::InternalDebugFeature::create("DOM Paste Access Requests"""_s, "DOMPasteAccessRequestsEnabled"_s, "Enable DOM Paste Access Requests"""_s, DEFAULT_VALUE_FOR_DOMPasteAccessRequestsEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("DTTZ also when root"""_s, "ZoomOnDoubleTapWhenRoot"_s, "Double taps zoom, even if we dispatched a click on the root nodes"""_s, DEFAULT_VALUE_FOR_ZoomOnDoubleTapWhenRoot, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("DTTZ always"""_s, "AlwaysZoomOnDoubleTap"_s, "Double taps zoom, even if we dispatched a click anywhere"""_s, DEFAULT_VALUE_FOR_AlwaysZoomOnDoubleTap, false),
#endif
#if ENABLE(DATALIST_ELEMENT)
        API::InternalDebugFeature::create("DataList Element"""_s, "DataListElementEnabled"_s, "Enable datalist elements"""_s, DEFAULT_VALUE_FOR_DataListElementEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_DATE)
        API::InternalDebugFeature::create("Date Input"""_s, "InputTypeDateEnabled"_s, "Enable input elements of type date"""_s, DEFAULT_VALUE_FOR_InputTypeDateEnabled, false),
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        API::InternalDebugFeature::create("Date/Time inputs have editable components"""_s, "DateTimeInputsEditableComponentsEnabled"_s, "Enable multiple editable components in date/time inputs"""_s, DEFAULT_VALUE_FOR_DateTimeInputsEditableComponentsEnabled, false),
#endif
        API::InternalDebugFeature::create("Enable Automatic Live Resize"""_s, "AutomaticLiveResizeEnabled"_s, "Automatically synchronize web view resize with painting"""_s, DEFAULT_VALUE_FOR_AutomaticLiveResizeEnabled, false),
        API::InternalDebugFeature::create("Enable ICE Candidate Filtering"""_s, "ICECandidateFilteringEnabled"_s, "Enable ICE Candidate Filtering"""_s, DEFAULT_VALUE_FOR_ICECandidateFilteringEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Enable Mock Capture Devices"""_s, "MockCaptureDevicesEnabled"_s, "Enable Mock Capture Devices"""_s, DEFAULT_VALUE_FOR_MockCaptureDevicesEnabled, false),
#endif
#if ENABLE(PDFJS)
        API::InternalDebugFeature::create("Enable PDF.js viewer"""_s, "PdfJSViewerEnabled"_s, "Enable PDF.js viewer"""_s, DEFAULT_VALUE_FOR_PdfJSViewerEnabled, false),
#endif
        API::InternalDebugFeature::create("Enter Key Hint"""_s, "EnterKeyHintEnabled"_s, "Enable the enterKeyHint HTML attribute"""_s, DEFAULT_VALUE_FOR_EnterKeyHintEnabled, false),
        API::InternalDebugFeature::create("EventHandler driven smooth keyboard scrolling"""_s, "EventHandlerDrivenSmoothKeyboardScrollingEnabled"_s, "Enable EventHandler driven smooth keyboard scrolling"""_s, DEFAULT_VALUE_FOR_EventHandlerDrivenSmoothKeyboardScrollingEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("Fast clicks beat DTTZ"""_s, "PreferFasterClickOverDoubleTap"_s, "Prefer a faster click over a double tap"""_s, DEFAULT_VALUE_FOR_PreferFasterClickOverDoubleTap, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("Fast clicks"""_s, "FasterClicksEnabled"_s, "Support faster clicks on zoomable pages"""_s, DEFAULT_VALUE_FOR_FasterClicksEnabled, false),
#endif
        API::InternalDebugFeature::create("Filter HTTP Response for Web Processes"""_s, "RestrictedHTTPResponseAccess"_s, "Enable HTTP Response filtering for Web Processes"""_s, DEFAULT_VALUE_FOR_RestrictedHTTPResponseAccess, false),
        API::InternalDebugFeature::create("Frame flattening"""_s, "FrameFlatteningEnabled"_s, "Enable frame flattening, which adjusts the height of an iframe to fit its contents"""_s, DEFAULT_VALUE_FOR_FrameFlatteningEnabled, false),
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        API::InternalDebugFeature::create("Full next-generation layout (LFC)"""_s, "LayoutFormattingContextEnabled"_s, "Enable full next-generation layout (LFC)"""_s, DEFAULT_VALUE_FOR_LayoutFormattingContextEnabled, false),
#endif
#if ENABLE(FULLSCREEN_API)
        API::InternalDebugFeature::create("Fullscreen API"""_s, "FullScreenEnabled"_s, "Fullscreen API"""_s, DEFAULT_VALUE_FOR_FullScreenEnabled, EXPERIMENTAL_FULLSCREEN_API_HIDDEN),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("GPU Process: Audio Capture"""_s, "CaptureAudioInGPUProcessEnabled"_s, "Enable audio capture in GPU Process"""_s, DEFAULT_VALUE_FOR_CaptureAudioInGPUProcessEnabled, false),
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        API::InternalDebugFeature::create("GPU Process: Canvas Rendering"""_s, "UseGPUProcessForCanvasRenderingEnabled"_s, "Enable canvas rendering in GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForCanvasRenderingEnabled, false),
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        API::InternalDebugFeature::create("GPU Process: Media"""_s, "UseGPUProcessForMediaEnabled"_s, "Do all media loading and playback in the GPU Process"""_s, DEFAULT_VALUE_FOR_UseGPUProcessForMediaEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("GPU Process: Video Capture"""_s, "CaptureVideoInGPUProcessEnabled"_s, "Enable video capture in GPU Process"""_s, DEFAULT_VALUE_FOR_CaptureVideoInGPUProcessEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("GPU Process: WebRTC Platform Codecs"""_s, "WebRTCPlatformCodecsInGPUProcessEnabled"_s, "Enable WebRTC Platform Codecs in GPU Process"""_s, DEFAULT_VALUE_FOR_WebRTCPlatformCodecsInGPUProcessEnabled, false),
#endif
        API::InternalDebugFeature::create("IOKit blocking in the WebContent sandbox"""_s, "BlockIOKitInWebContentSandbox"_s, "Block IOKit access in the WebContent sandbox"""_s, DEFAULT_VALUE_FOR_BlockIOKitInWebContentSandbox, false),
#if ENABLE(IPC_TESTING_API)
        API::InternalDebugFeature::create("IPC Testing API"""_s, "IPCTestingAPIEnabled"_s, "Enable IPC Testing API for JavaScript"""_s, DEFAULT_VALUE_FOR_IPCTestingAPIEnabled, false),
#endif
#if ENABLE(TEXT_AUTOSIZING)
        API::InternalDebugFeature::create("Idempotent Text Autosizing"""_s, "TextAutosizingUsesIdempotentMode"_s, "Use idempotent text autosizing mode"""_s, DEFAULT_VALUE_FOR_TextAutosizingUsesIdempotentMode, false),
#endif
        API::InternalDebugFeature::create("Image Analysis for Find-in-Page"""_s, "ImageAnalysisDuringFindInPageEnabled"_s, "Trigger image analysis when performing Find-in-Page"""_s, DEFAULT_VALUE_FOR_ImageAnalysisDuringFindInPageEnabled, false),
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
        API::InternalDebugFeature::create("Interaction Regions"""_s, "InteractionRegionsEnabled"_s, "Generate and visualize interaction regions"""_s, DEFAULT_VALUE_FOR_InteractionRegionsEnabled, false),
#endif
#if ENABLE(LAYER_BASED_SVG_ENGINE)
        API::InternalDebugFeature::create("Layer-based SVG Engine (LBSE)"""_s, "LayerBasedSVGEngineEnabled"_s, "Enable next-generation layer-based SVG Engine (LBSE)"""_s, DEFAULT_VALUE_FOR_LayerBasedSVGEngineEnabled, false),
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        API::InternalDebugFeature::create("Legacy -webkit-overflow-scrolling property"""_s, "LegacyOverflowScrollingTouchEnabled"_s, "Support the legacy -webkit-overflow-scrolling CSS property"""_s, DEFAULT_VALUE_FOR_LegacyOverflowScrollingTouchEnabled, false),
#endif
        API::InternalDebugFeature::create("Legacy showModalDialog() API"""_s, "ShowModalDialogEnabled"_s, "Legacy showModalDialog() API"""_s, DEFAULT_VALUE_FOR_ShowModalDialogEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Limit Media Capture to Secure Sites"""_s, "MediaCaptureRequiresSecureConnection"_s, "Limit Media Capture to Secure Sites"""_s, DEFAULT_VALUE_FOR_MediaCaptureRequiresSecureConnection, false),
#endif
        API::InternalDebugFeature::create("Live Ranges in Selection"""_s, "LiveRangeSelectionEnabled"_s, "Live range behavior for ranges in the Selection object"""_s, DEFAULT_VALUE_FOR_LiveRangeSelectionEnabled, false),
        API::InternalDebugFeature::create("Momentum Scrolling Animator"""_s, "MomentumScrollingAnimatorEnabled"_s, "Generate momentum events in WebKit instead of using those delivered by the system"""_s, DEFAULT_VALUE_FOR_MomentumScrollingAnimatorEnabled, false),
#if ENABLE(INPUT_TYPE_MONTH)
        API::InternalDebugFeature::create("Month Input"""_s, "InputTypeMonthEnabled"_s, "Enable input elements of type month"""_s, DEFAULT_VALUE_FOR_InputTypeMonthEnabled, false),
#endif
#if ENABLE(TOUCH_EVENTS)
        API::InternalDebugFeature::create("Mouse events simulation"""_s, "MouseEventsSimulationEnabled"_s, "Enable mouse events dispatch along with touch events on iOS"""_s, DEFAULT_VALUE_FOR_MouseEventsSimulationEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Mute Camera on Microphone Interruption"""_s, "MuteCameraOnMicrophoneInterruptionEnabled"_s, "Mute Camera on Microphone Interruption"""_s, DEFAULT_VALUE_FOR_MuteCameraOnMicrophoneInterruptionEnabled, false),
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        API::InternalDebugFeature::create("Next-generation flex layout integration (FFC)"""_s, "FlexFormattingContextIntegrationEnabled"_s, "Enable next-generation flex layout integration (FFC)"""_s, DEFAULT_VALUE_FOR_FlexFormattingContextIntegrationEnabled, false),
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        API::InternalDebugFeature::create("Next-generation inline layout integration (IFC)"""_s, "InlineFormattingContextIntegrationEnabled"_s, "Enable next-generation inline layout integration (IFC)"""_s, DEFAULT_VALUE_FOR_InlineFormattingContextIntegrationEnabled, false),
#endif
#if ENABLE(NOTIFICATION_EVENT)
        API::InternalDebugFeature::create("NotificationEvent support"""_s, "NotificationEventEnabled"_s, "NotificationEvent and ServiceWorkerRegistration.showNotification() support"""_s, DEFAULT_VALUE_FOR_NotificationEventEnabled, false),
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        API::InternalDebugFeature::create("OffscreenCanvas in Workers"""_s, "OffscreenCanvasInWorkersEnabled"_s, "Support for the OffscreenCanvas APIs in Workers"""_s, DEFAULT_VALUE_FOR_OffscreenCanvasInWorkersEnabled, false),
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        API::InternalDebugFeature::create("OffscreenCanvas"""_s, "OffscreenCanvasEnabled"_s, "Support for the OffscreenCanvas APIs"""_s, DEFAULT_VALUE_FOR_OffscreenCanvasEnabled, false),
#endif
#if ENABLE(VIDEO)
        API::InternalDebugFeature::create("Prefer Sandboxed Parsing of Media"""_s, "PreferSandboxedMediaParsing"_s, "Prefer parsing media out-of-process in a sandboxed service"""_s, DEFAULT_VALUE_FOR_PreferSandboxedMediaParsing, false),
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        API::InternalDebugFeature::create("Remove Background"""_s, "RemoveBackgroundEnabled"_s, "Enable Remove Background"""_s, DEFAULT_VALUE_FOR_RemoveBackgroundEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Require a user gesture for speaker selection"""_s, "SpeakerSelectionRequiresUserGesture"_s, "Require a user gesture for speaker selection"""_s, DEFAULT_VALUE_FOR_SpeakerSelectionRequiresUserGesture, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Require focus to start getUserMedia"""_s, "GetUserMediaRequiresFocus"_s, "Require focus to start getUserMedia"""_s, DEFAULT_VALUE_FOR_GetUserMediaRequiresFocus, false),
#endif
        API::InternalDebugFeature::create("Resource Load Scheduling"""_s, "ResourceLoadSchedulingEnabled"_s, "Network process side priority and visibility based resource load scheduling"""_s, DEFAULT_VALUE_FOR_ResourceLoadSchedulingEnabled, false),
        API::InternalDebugFeature::create("Scroll Performance Testing Enabled"""_s, "ScrollingPerformanceTestingEnabled"_s, "Enable behaviors used by scrolling performance tests"""_s, DEFAULT_VALUE_FOR_ScrollingPerformanceTestingEnabled, false),
        API::InternalDebugFeature::create("Secure Context Checks"""_s, "SecureContextChecksEnabled"_s, "Allow access to HTTPS-only Web APIs over HTTP"""_s, DEFAULT_VALUE_FOR_SecureContextChecksEnabled, false),
        API::InternalDebugFeature::create("Selection Flipping"""_s, "SelectionFlippingEnabled"_s, "Enable Selection Flipping"""_s, DEFAULT_VALUE_FOR_SelectionFlippingEnabled, false),
#if ENABLE(SERVICE_WORKER)
        API::InternalDebugFeature::create("Service Workers"""_s, "ServiceWorkersEnabled"_s, "Enable Service Workers"""_s, DEFAULT_VALUE_FOR_ServiceWorkersEnabled, false),
#endif
#if ENABLE(IMAGE_ANALYSIS)
        API::InternalDebugFeature::create("Text Recognition in Videos"""_s, "TextRecognitionInVideosEnabled"_s, "Enable Text Recognition in Videos"""_s, DEFAULT_VALUE_FOR_TextRecognitionInVideosEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_TIME)
        API::InternalDebugFeature::create("Time Input"""_s, "InputTypeTimeEnabled"_s, "Enable input elements of type time"""_s, DEFAULT_VALUE_FOR_InputTypeTimeEnabled, false),
#endif
        API::InternalDebugFeature::create("UndoManager DOM API"""_s, "UndoManagerAPIEnabled"_s, "Enable the UndoManager DOM API"""_s, DEFAULT_VALUE_FOR_UndoManagerAPIEnabled, false),
        API::InternalDebugFeature::create("Upgrade known hosts to HTTPS"""_s, "UpgradeKnownHostsToHTTPSEnabled"_s, "Upgrade known hosts to HTTPS"""_s, DEFAULT_VALUE_FOR_UpgradeKnownHostsToHTTPSEnabled, false),
#if ENABLE(ARKIT_INLINE_PREVIEW)
        API::InternalDebugFeature::create("Use ARKit for <model>"""_s, "UseARKitForModel"_s, "Use ARKit for <model>"""_s, DEFAULT_VALUE_FOR_UseARKitForModel, false),
#endif
        API::InternalDebugFeature::create("Use General Directory For Storage"""_s, "UseGeneralDirectoryForStorage"_s, "Use general storage directory for IndexedDB and LocalStorage"""_s, DEFAULT_VALUE_FOR_UseGeneralDirectoryForStorage, false),
#if HAVE(SCENEKIT)
        API::InternalDebugFeature::create("Use SceneKit for <model>"""_s, "UseSceneKitForModel"_s, "Use SceneKit for <model>"""_s, DEFAULT_VALUE_FOR_UseSceneKitForModel, false),
#endif
#if ENABLE(SERVICE_WORKER)
        API::InternalDebugFeature::create("Validate UserGesture requirements in Service Workers"""_s, "ServiceWorkersUserGestureEnabled"_s, "Validate UserGesture requirements in Service Workers"""_s, DEFAULT_VALUE_FOR_ServiceWorkersUserGestureEnabled, false),
#endif
#if ENABLE(IMAGE_ANALYSIS)
        API::InternalDebugFeature::create("Visual Translation"""_s, "VisualTranslationEnabled"_s, "Enable Visual Translation"""_s, DEFAULT_VALUE_FOR_VisualTranslationEnabled, false),
#endif
        API::InternalDebugFeature::create("Web API Statistics"""_s, "WebAPIStatisticsEnabled"_s, "Enable Web API Statistics"""_s, DEFAULT_VALUE_FOR_WebAPIStatisticsEnabled, false),
        API::InternalDebugFeature::create("WebRTC Audio Latency Adaptation"""_s, "WebRTCAudioLatencyAdaptationEnabled"_s, "Enable WebRTC Audio Latency Adaptation"""_s, DEFAULT_VALUE_FOR_WebRTCAudioLatencyAdaptationEnabled, false),
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC DTMF"""_s, "WebRTCDTMFEnabled"_s, "Enable WebRTC DTMF"""_s, DEFAULT_VALUE_FOR_WebRTCDTMFEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC H264 Hardware encoder"""_s, "WebRTCH264HardwareEncoderEnabled"_s, "Enable H264 Hardware encoder"""_s, DEFAULT_VALUE_FOR_WebRTCH264HardwareEncoderEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC H264 Simulcast"""_s, "WebRTCH264SimulcastEnabled"_s, "Enable WebRTC H264 Simulcast"""_s, DEFAULT_VALUE_FOR_WebRTCH264SimulcastEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC Remote Video Frame"""_s, "WebRTCRemoteVideoFrameEnabled"_s, "Enable WebRTC Remote Video Frame"""_s, DEFAULT_VALUE_FOR_WebRTCRemoteVideoFrameEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC mDNS ICE candidates"""_s, "WebRTCMDNSICECandidatesEnabled"_s, "Enable WebRTC mDNS ICE candidates"""_s, DEFAULT_VALUE_FOR_WebRTCMDNSICECandidatesEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        API::InternalDebugFeature::create("Week Input"""_s, "InputTypeWeekEnabled"_s, "Enable input elements of type week"""_s, DEFAULT_VALUE_FOR_InputTypeWeekEnabled, false),
#endif
        API::InternalDebugFeature::create("[ITP Live-On] 1 Hour Timeout For Non-Cookie Data Removal"""_s, "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled"_s, "Remove all non-cookie website data after just one hour of no user interaction when Intelligent Tracking Prevention is enabled"""_s, DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled, false),
        API::InternalDebugFeature::create("[ITP Repro] 30 Second Timeout For Non-Cookie Data Removal"""_s, "IsFirstPartyWebsiteDataRemovalReproTestingEnabled"_s, "Remove all non-cookie website data after just 30 seconds of no user interaction when Intelligent Tracking Prevention is enabled"""_s, DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalReproTestingEnabled, false),
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        API::InternalDebugFeature::create("datetime-local Inputs"""_s, "InputTypeDateTimeLocalEnabled"_s, "Enable input elements of type datetime-local"""_s, DEFAULT_VALUE_FOR_InputTypeDateTimeLocalEnabled, false),
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
        API::InternalDebugFeature::create("iOS Form Control Refresh"""_s, "IOSFormControlRefreshEnabled"_s, "Enable the new appearance for form controls on iOS"""_s, DEFAULT_VALUE_FOR_IOSFormControlRefreshEnabled, false),
#endif
        API::InternalDebugFeature::create("lh / rlh units"""_s, "LineHeightUnitsEnabled"_s, "Enable the lh and lhr units"""_s, DEFAULT_VALUE_FOR_LineHeightUnitsEnabled, false),
    });

    return features;
}

bool WebPreferences::isFeatureEnabled(const API::InternalDebugFeature& feature) const
{
    struct FeatureGetterMapping {
        ASCIILiteral name;
        bool (WebPreferences::*function) () const;
    };

    static FeatureGetterMapping getters[] = {
#if USE(CORE_IMAGE)
        { "AcceleratedFiltersEnabled"_s, &WebPreferences::acceleratedFiltersEnabled },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AllowViewportShrinkToFitContent"_s, &WebPreferences::allowViewportShrinkToFitContent },
#endif
#if ENABLE(ALTERNATE_WEBM_PLAYER)
        { "AlternateWebMPlayerEnabled"_s, &WebPreferences::alternateWebMPlayerEnabled },
#endif
        { "AsyncFrameScrollingEnabled"_s, &WebPreferences::asyncFrameScrollingEnabled },
        { "AsyncOverflowScrollingEnabled"_s, &WebPreferences::asyncOverflowScrollingEnabled },
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "UseCGDisplayListsForDOMRendering"_s, &WebPreferences::useCGDisplayListsForDOMRendering },
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "UseCGDisplayListOutOfLineSurfaces"_s, &WebPreferences::useCGDisplayListOutOfLineSurfaces },
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "ReplayCGDisplayListsIntoBackingStore"_s, &WebPreferences::replayCGDisplayListsIntoBackingStore },
#endif
        { "CSSLogicalEnabled"_s, &WebPreferences::cssLogicalEnabled },
        { "CSSOMViewScrollingAPIEnabled"_s, &WebPreferences::cssOMViewScrollingAPIEnabled },
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInUIProcessEnabled"_s, &WebPreferences::captureAudioInUIProcessEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInUIProcessEnabled"_s, &WebPreferences::captureVideoInUIProcessEnabled },
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        { "InputTypeColorEnabled"_s, &WebPreferences::inputTypeColorEnabled },
#endif
#if HAVE(AVCONTENTKEYSPECIFIER)
        { "SampleBufferContentKeySessionSupportEnabled"_s, &WebPreferences::sampleBufferContentKeySessionSupportEnabled },
#endif
        { "CookieConsentAPIEnabled"_s, &WebPreferences::cookieConsentAPIEnabled },
        { "DOMPasteAccessRequestsEnabled"_s, &WebPreferences::domPasteAccessRequestsEnabled },
#if PLATFORM(IOS_FAMILY)
        { "ZoomOnDoubleTapWhenRoot"_s, &WebPreferences::zoomOnDoubleTapWhenRoot },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AlwaysZoomOnDoubleTap"_s, &WebPreferences::alwaysZoomOnDoubleTap },
#endif
#if ENABLE(DATALIST_ELEMENT)
        { "DataListElementEnabled"_s, &WebPreferences::dataListElementEnabled },
#endif
#if ENABLE(INPUT_TYPE_DATE)
        { "InputTypeDateEnabled"_s, &WebPreferences::inputTypeDateEnabled },
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        { "DateTimeInputsEditableComponentsEnabled"_s, &WebPreferences::dateTimeInputsEditableComponentsEnabled },
#endif
        { "AutomaticLiveResizeEnabled"_s, &WebPreferences::automaticLiveResizeEnabled },
        { "ICECandidateFilteringEnabled"_s, &WebPreferences::iceCandidateFilteringEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MockCaptureDevicesEnabled"_s, &WebPreferences::mockCaptureDevicesEnabled },
#endif
#if ENABLE(PDFJS)
        { "PdfJSViewerEnabled"_s, &WebPreferences::pdfJSViewerEnabled },
#endif
        { "EnterKeyHintEnabled"_s, &WebPreferences::enterKeyHintEnabled },
        { "EventHandlerDrivenSmoothKeyboardScrollingEnabled"_s, &WebPreferences::eventHandlerDrivenSmoothKeyboardScrollingEnabled },
#if PLATFORM(IOS_FAMILY)
        { "PreferFasterClickOverDoubleTap"_s, &WebPreferences::preferFasterClickOverDoubleTap },
#endif
#if PLATFORM(IOS_FAMILY)
        { "FasterClicksEnabled"_s, &WebPreferences::fasterClicksEnabled },
#endif
        { "RestrictedHTTPResponseAccess"_s, &WebPreferences::restrictedHTTPResponseAccess },
        { "FrameFlatteningEnabled"_s, &WebPreferences::frameFlatteningEnabled },
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "LayoutFormattingContextEnabled"_s, &WebPreferences::layoutFormattingContextEnabled },
#endif
#if ENABLE(FULLSCREEN_API)
        { "FullScreenEnabled"_s, &WebPreferences::fullScreenEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInGPUProcessEnabled"_s, &WebPreferences::captureAudioInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        { "UseGPUProcessForCanvasRenderingEnabled"_s, &WebPreferences::useGPUProcessForCanvasRenderingEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        { "UseGPUProcessForMediaEnabled"_s, &WebPreferences::useGPUProcessForMediaEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInGPUProcessEnabled"_s, &WebPreferences::captureVideoInGPUProcessEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformCodecsInGPUProcessEnabled"_s, &WebPreferences::webRTCPlatformCodecsInGPUProcessEnabled },
#endif
        { "BlockIOKitInWebContentSandbox"_s, &WebPreferences::blockIOKitInWebContentSandbox },
#if ENABLE(IPC_TESTING_API)
        { "IPCTestingAPIEnabled"_s, &WebPreferences::ipcTestingAPIEnabled },
#endif
#if ENABLE(TEXT_AUTOSIZING)
        { "TextAutosizingUsesIdempotentMode"_s, &WebPreferences::textAutosizingUsesIdempotentMode },
#endif
        { "ImageAnalysisDuringFindInPageEnabled"_s, &WebPreferences::imageAnalysisDuringFindInPageEnabled },
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
        { "InteractionRegionsEnabled"_s, &WebPreferences::interactionRegionsEnabled },
#endif
#if ENABLE(LAYER_BASED_SVG_ENGINE)
        { "LayerBasedSVGEngineEnabled"_s, &WebPreferences::layerBasedSVGEngineEnabled },
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        { "LegacyOverflowScrollingTouchEnabled"_s, &WebPreferences::legacyOverflowScrollingTouchEnabled },
#endif
        { "ShowModalDialogEnabled"_s, &WebPreferences::showModalDialogEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MediaCaptureRequiresSecureConnection"_s, &WebPreferences::mediaCaptureRequiresSecureConnection },
#endif
        { "LiveRangeSelectionEnabled"_s, &WebPreferences::liveRangeSelectionEnabled },
        { "MomentumScrollingAnimatorEnabled"_s, &WebPreferences::momentumScrollingAnimatorEnabled },
#if ENABLE(INPUT_TYPE_MONTH)
        { "InputTypeMonthEnabled"_s, &WebPreferences::inputTypeMonthEnabled },
#endif
#if ENABLE(TOUCH_EVENTS)
        { "MouseEventsSimulationEnabled"_s, &WebPreferences::mouseEventsSimulationEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MuteCameraOnMicrophoneInterruptionEnabled"_s, &WebPreferences::muteCameraOnMicrophoneInterruptionEnabled },
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "FlexFormattingContextIntegrationEnabled"_s, &WebPreferences::flexFormattingContextIntegrationEnabled },
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "InlineFormattingContextIntegrationEnabled"_s, &WebPreferences::inlineFormattingContextIntegrationEnabled },
#endif
#if ENABLE(NOTIFICATION_EVENT)
        { "NotificationEventEnabled"_s, &WebPreferences::notificationEventEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        { "OffscreenCanvasInWorkersEnabled"_s, &WebPreferences::offscreenCanvasInWorkersEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        { "OffscreenCanvasEnabled"_s, &WebPreferences::offscreenCanvasEnabled },
#endif
#if ENABLE(VIDEO)
        { "PreferSandboxedMediaParsing"_s, &WebPreferences::preferSandboxedMediaParsing },
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        { "RemoveBackgroundEnabled"_s, &WebPreferences::removeBackgroundEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "SpeakerSelectionRequiresUserGesture"_s, &WebPreferences::speakerSelectionRequiresUserGesture },
#endif
#if ENABLE(MEDIA_STREAM)
        { "GetUserMediaRequiresFocus"_s, &WebPreferences::getUserMediaRequiresFocus },
#endif
        { "ResourceLoadSchedulingEnabled"_s, &WebPreferences::resourceLoadSchedulingEnabled },
        { "ScrollingPerformanceTestingEnabled"_s, &WebPreferences::scrollingPerformanceTestingEnabled },
        { "SecureContextChecksEnabled"_s, &WebPreferences::secureContextChecksEnabled },
        { "SelectionFlippingEnabled"_s, &WebPreferences::selectionFlippingEnabled },
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkersEnabled"_s, &WebPreferences::serviceWorkersEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "TextRecognitionInVideosEnabled"_s, &WebPreferences::textRecognitionInVideosEnabled },
#endif
#if ENABLE(INPUT_TYPE_TIME)
        { "InputTypeTimeEnabled"_s, &WebPreferences::inputTypeTimeEnabled },
#endif
        { "UndoManagerAPIEnabled"_s, &WebPreferences::undoManagerAPIEnabled },
        { "UpgradeKnownHostsToHTTPSEnabled"_s, &WebPreferences::upgradeKnownHostsToHTTPSEnabled },
#if ENABLE(ARKIT_INLINE_PREVIEW)
        { "UseARKitForModel"_s, &WebPreferences::useARKitForModel },
#endif
        { "UseGeneralDirectoryForStorage"_s, &WebPreferences::useGeneralDirectoryForStorage },
#if HAVE(SCENEKIT)
        { "UseSceneKitForModel"_s, &WebPreferences::useSceneKitForModel },
#endif
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkersUserGestureEnabled"_s, &WebPreferences::serviceWorkersUserGestureEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "VisualTranslationEnabled"_s, &WebPreferences::visualTranslationEnabled },
#endif
        { "WebAPIStatisticsEnabled"_s, &WebPreferences::webAPIStatisticsEnabled },
        { "WebRTCAudioLatencyAdaptationEnabled"_s, &WebPreferences::webRTCAudioLatencyAdaptationEnabled },
#if ENABLE(WEB_RTC)
        { "WebRTCDTMFEnabled"_s, &WebPreferences::webRTCDTMFEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264HardwareEncoderEnabled"_s, &WebPreferences::webRTCH264HardwareEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264SimulcastEnabled"_s, &WebPreferences::webRTCH264SimulcastEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCRemoteVideoFrameEnabled"_s, &WebPreferences::webRTCRemoteVideoFrameEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCMDNSICECandidatesEnabled"_s, &WebPreferences::webRTCMDNSICECandidatesEnabled },
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        { "InputTypeWeekEnabled"_s, &WebPreferences::inputTypeWeekEnabled },
#endif
        { "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled"_s, &WebPreferences::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled },
        { "IsFirstPartyWebsiteDataRemovalReproTestingEnabled"_s, &WebPreferences::isFirstPartyWebsiteDataRemovalReproTestingEnabled },
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        { "InputTypeDateTimeLocalEnabled"_s, &WebPreferences::inputTypeDateTimeLocalEnabled },
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
        { "IOSFormControlRefreshEnabled"_s, &WebPreferences::iOSFormControlRefreshEnabled },
#endif
        { "LineHeightUnitsEnabled"_s, &WebPreferences::lineHeightUnitsEnabled },
    };

    const String& key = feature.key();

    for (auto& getter : getters) {
        if (key == getter.name)
            return (this->*getter.function)();
    }

    return false;
}

void WebPreferences::setFeatureEnabled(const API::InternalDebugFeature& feature, bool value)
{
    setInternalDebugFeatureEnabledForKey(feature.key(), value);
}

void WebPreferences::setInternalDebugFeatureEnabledForKey(const String& key, bool value)
{
    struct FeatureSetterMapping {
        ASCIILiteral name;
        void (WebPreferences::*function) (const bool&);
    };

    static FeatureSetterMapping setters[] = {
#if USE(CORE_IMAGE)
        { "AcceleratedFiltersEnabled"_s, &WebPreferences::setAcceleratedFiltersEnabled },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AllowViewportShrinkToFitContent"_s, &WebPreferences::setAllowViewportShrinkToFitContent },
#endif
#if ENABLE(ALTERNATE_WEBM_PLAYER)
        { "AlternateWebMPlayerEnabled"_s, &WebPreferences::setAlternateWebMPlayerEnabled },
#endif
        { "AsyncFrameScrollingEnabled"_s, &WebPreferences::setAsyncFrameScrollingEnabled },
        { "AsyncOverflowScrollingEnabled"_s, &WebPreferences::setAsyncOverflowScrollingEnabled },
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "UseCGDisplayListsForDOMRendering"_s, &WebPreferences::setUseCGDisplayListsForDOMRendering },
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "UseCGDisplayListOutOfLineSurfaces"_s, &WebPreferences::setUseCGDisplayListOutOfLineSurfaces },
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "ReplayCGDisplayListsIntoBackingStore"_s, &WebPreferences::setReplayCGDisplayListsIntoBackingStore },
#endif
        { "CSSLogicalEnabled"_s, &WebPreferences::setCSSLogicalEnabled },
        { "CSSOMViewScrollingAPIEnabled"_s, &WebPreferences::setCSSOMViewScrollingAPIEnabled },
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInUIProcessEnabled"_s, &WebPreferences::setCaptureAudioInUIProcessEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInUIProcessEnabled"_s, &WebPreferences::setCaptureVideoInUIProcessEnabled },
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        { "InputTypeColorEnabled"_s, &WebPreferences::setInputTypeColorEnabled },
#endif
#if HAVE(AVCONTENTKEYSPECIFIER)
        { "SampleBufferContentKeySessionSupportEnabled"_s, &WebPreferences::setSampleBufferContentKeySessionSupportEnabled },
#endif
        { "CookieConsentAPIEnabled"_s, &WebPreferences::setCookieConsentAPIEnabled },
        { "DOMPasteAccessRequestsEnabled"_s, &WebPreferences::setDOMPasteAccessRequestsEnabled },
#if PLATFORM(IOS_FAMILY)
        { "ZoomOnDoubleTapWhenRoot"_s, &WebPreferences::setZoomOnDoubleTapWhenRoot },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AlwaysZoomOnDoubleTap"_s, &WebPreferences::setAlwaysZoomOnDoubleTap },
#endif
#if ENABLE(DATALIST_ELEMENT)
        { "DataListElementEnabled"_s, &WebPreferences::setDataListElementEnabled },
#endif
#if ENABLE(INPUT_TYPE_DATE)
        { "InputTypeDateEnabled"_s, &WebPreferences::setInputTypeDateEnabled },
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        { "DateTimeInputsEditableComponentsEnabled"_s, &WebPreferences::setDateTimeInputsEditableComponentsEnabled },
#endif
        { "AutomaticLiveResizeEnabled"_s, &WebPreferences::setAutomaticLiveResizeEnabled },
        { "ICECandidateFilteringEnabled"_s, &WebPreferences::setICECandidateFilteringEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MockCaptureDevicesEnabled"_s, &WebPreferences::setMockCaptureDevicesEnabled },
#endif
#if ENABLE(PDFJS)
        { "PdfJSViewerEnabled"_s, &WebPreferences::setPdfJSViewerEnabled },
#endif
        { "EnterKeyHintEnabled"_s, &WebPreferences::setEnterKeyHintEnabled },
        { "EventHandlerDrivenSmoothKeyboardScrollingEnabled"_s, &WebPreferences::setEventHandlerDrivenSmoothKeyboardScrollingEnabled },
#if PLATFORM(IOS_FAMILY)
        { "PreferFasterClickOverDoubleTap"_s, &WebPreferences::setPreferFasterClickOverDoubleTap },
#endif
#if PLATFORM(IOS_FAMILY)
        { "FasterClicksEnabled"_s, &WebPreferences::setFasterClicksEnabled },
#endif
        { "RestrictedHTTPResponseAccess"_s, &WebPreferences::setRestrictedHTTPResponseAccess },
        { "FrameFlatteningEnabled"_s, &WebPreferences::setFrameFlatteningEnabled },
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "LayoutFormattingContextEnabled"_s, &WebPreferences::setLayoutFormattingContextEnabled },
#endif
#if ENABLE(FULLSCREEN_API)
        { "FullScreenEnabled"_s, &WebPreferences::setFullScreenEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInGPUProcessEnabled"_s, &WebPreferences::setCaptureAudioInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        { "UseGPUProcessForCanvasRenderingEnabled"_s, &WebPreferences::setUseGPUProcessForCanvasRenderingEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        { "UseGPUProcessForMediaEnabled"_s, &WebPreferences::setUseGPUProcessForMediaEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInGPUProcessEnabled"_s, &WebPreferences::setCaptureVideoInGPUProcessEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformCodecsInGPUProcessEnabled"_s, &WebPreferences::setWebRTCPlatformCodecsInGPUProcessEnabled },
#endif
        { "BlockIOKitInWebContentSandbox"_s, &WebPreferences::setBlockIOKitInWebContentSandbox },
#if ENABLE(IPC_TESTING_API)
        { "IPCTestingAPIEnabled"_s, &WebPreferences::setIPCTestingAPIEnabled },
#endif
#if ENABLE(TEXT_AUTOSIZING)
        { "TextAutosizingUsesIdempotentMode"_s, &WebPreferences::setTextAutosizingUsesIdempotentMode },
#endif
        { "ImageAnalysisDuringFindInPageEnabled"_s, &WebPreferences::setImageAnalysisDuringFindInPageEnabled },
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
        { "InteractionRegionsEnabled"_s, &WebPreferences::setInteractionRegionsEnabled },
#endif
#if ENABLE(LAYER_BASED_SVG_ENGINE)
        { "LayerBasedSVGEngineEnabled"_s, &WebPreferences::setLayerBasedSVGEngineEnabled },
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        { "LegacyOverflowScrollingTouchEnabled"_s, &WebPreferences::setLegacyOverflowScrollingTouchEnabled },
#endif
        { "ShowModalDialogEnabled"_s, &WebPreferences::setShowModalDialogEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MediaCaptureRequiresSecureConnection"_s, &WebPreferences::setMediaCaptureRequiresSecureConnection },
#endif
        { "LiveRangeSelectionEnabled"_s, &WebPreferences::setLiveRangeSelectionEnabled },
        { "MomentumScrollingAnimatorEnabled"_s, &WebPreferences::setMomentumScrollingAnimatorEnabled },
#if ENABLE(INPUT_TYPE_MONTH)
        { "InputTypeMonthEnabled"_s, &WebPreferences::setInputTypeMonthEnabled },
#endif
#if ENABLE(TOUCH_EVENTS)
        { "MouseEventsSimulationEnabled"_s, &WebPreferences::setMouseEventsSimulationEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MuteCameraOnMicrophoneInterruptionEnabled"_s, &WebPreferences::setMuteCameraOnMicrophoneInterruptionEnabled },
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "FlexFormattingContextIntegrationEnabled"_s, &WebPreferences::setFlexFormattingContextIntegrationEnabled },
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "InlineFormattingContextIntegrationEnabled"_s, &WebPreferences::setInlineFormattingContextIntegrationEnabled },
#endif
#if ENABLE(NOTIFICATION_EVENT)
        { "NotificationEventEnabled"_s, &WebPreferences::setNotificationEventEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        { "OffscreenCanvasInWorkersEnabled"_s, &WebPreferences::setOffscreenCanvasInWorkersEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        { "OffscreenCanvasEnabled"_s, &WebPreferences::setOffscreenCanvasEnabled },
#endif
#if ENABLE(VIDEO)
        { "PreferSandboxedMediaParsing"_s, &WebPreferences::setPreferSandboxedMediaParsing },
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        { "RemoveBackgroundEnabled"_s, &WebPreferences::setRemoveBackgroundEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "SpeakerSelectionRequiresUserGesture"_s, &WebPreferences::setSpeakerSelectionRequiresUserGesture },
#endif
#if ENABLE(MEDIA_STREAM)
        { "GetUserMediaRequiresFocus"_s, &WebPreferences::setGetUserMediaRequiresFocus },
#endif
        { "ResourceLoadSchedulingEnabled"_s, &WebPreferences::setResourceLoadSchedulingEnabled },
        { "ScrollingPerformanceTestingEnabled"_s, &WebPreferences::setScrollingPerformanceTestingEnabled },
        { "SecureContextChecksEnabled"_s, &WebPreferences::setSecureContextChecksEnabled },
        { "SelectionFlippingEnabled"_s, &WebPreferences::setSelectionFlippingEnabled },
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkersEnabled"_s, &WebPreferences::setServiceWorkersEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "TextRecognitionInVideosEnabled"_s, &WebPreferences::setTextRecognitionInVideosEnabled },
#endif
#if ENABLE(INPUT_TYPE_TIME)
        { "InputTypeTimeEnabled"_s, &WebPreferences::setInputTypeTimeEnabled },
#endif
        { "UndoManagerAPIEnabled"_s, &WebPreferences::setUndoManagerAPIEnabled },
        { "UpgradeKnownHostsToHTTPSEnabled"_s, &WebPreferences::setUpgradeKnownHostsToHTTPSEnabled },
#if ENABLE(ARKIT_INLINE_PREVIEW)
        { "UseARKitForModel"_s, &WebPreferences::setUseARKitForModel },
#endif
        { "UseGeneralDirectoryForStorage"_s, &WebPreferences::setUseGeneralDirectoryForStorage },
#if HAVE(SCENEKIT)
        { "UseSceneKitForModel"_s, &WebPreferences::setUseSceneKitForModel },
#endif
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkersUserGestureEnabled"_s, &WebPreferences::setServiceWorkersUserGestureEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "VisualTranslationEnabled"_s, &WebPreferences::setVisualTranslationEnabled },
#endif
        { "WebAPIStatisticsEnabled"_s, &WebPreferences::setWebAPIStatisticsEnabled },
        { "WebRTCAudioLatencyAdaptationEnabled"_s, &WebPreferences::setWebRTCAudioLatencyAdaptationEnabled },
#if ENABLE(WEB_RTC)
        { "WebRTCDTMFEnabled"_s, &WebPreferences::setWebRTCDTMFEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264HardwareEncoderEnabled"_s, &WebPreferences::setWebRTCH264HardwareEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264SimulcastEnabled"_s, &WebPreferences::setWebRTCH264SimulcastEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCRemoteVideoFrameEnabled"_s, &WebPreferences::setWebRTCRemoteVideoFrameEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCMDNSICECandidatesEnabled"_s, &WebPreferences::setWebRTCMDNSICECandidatesEnabled },
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        { "InputTypeWeekEnabled"_s, &WebPreferences::setInputTypeWeekEnabled },
#endif
        { "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled"_s, &WebPreferences::setIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled },
        { "IsFirstPartyWebsiteDataRemovalReproTestingEnabled"_s, &WebPreferences::setIsFirstPartyWebsiteDataRemovalReproTestingEnabled },
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        { "InputTypeDateTimeLocalEnabled"_s, &WebPreferences::setInputTypeDateTimeLocalEnabled },
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
        { "IOSFormControlRefreshEnabled"_s, &WebPreferences::setIOSFormControlRefreshEnabled },
#endif
        { "LineHeightUnitsEnabled"_s, &WebPreferences::setLineHeightUnitsEnabled },
    };

    for (auto& setter : setters) {
        if (key == setter.name) {
            (this->*setter.function)(value);
            return;
        }
    }
}

void WebPreferences::resetAllInternalDebugFeatures()
{
    UpdateBatch batch(*this);
#if USE(CORE_IMAGE)
    setAcceleratedFiltersEnabled(DEFAULT_VALUE_FOR_AcceleratedFiltersEnabled);
#endif
#if PLATFORM(IOS_FAMILY)
    setAllowViewportShrinkToFitContent(DEFAULT_VALUE_FOR_AllowViewportShrinkToFitContent);
#endif
#if ENABLE(ALTERNATE_WEBM_PLAYER)
    setAlternateWebMPlayerEnabled(DEFAULT_VALUE_FOR_AlternateWebMPlayerEnabled);
#endif
    setAsyncFrameScrollingEnabled(DEFAULT_VALUE_FOR_AsyncFrameScrollingEnabled);
    setAsyncOverflowScrollingEnabled(DEFAULT_VALUE_FOR_AsyncOverflowScrollingEnabled);
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
    setUseCGDisplayListsForDOMRendering(DEFAULT_VALUE_FOR_UseCGDisplayListsForDOMRendering);
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
    setUseCGDisplayListOutOfLineSurfaces(DEFAULT_VALUE_FOR_UseCGDisplayListOutOfLineSurfaces);
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
    setReplayCGDisplayListsIntoBackingStore(DEFAULT_VALUE_FOR_ReplayCGDisplayListsIntoBackingStore);
#endif
    setCSSLogicalEnabled(DEFAULT_VALUE_FOR_CSSLogicalEnabled);
    setCSSOMViewScrollingAPIEnabled(DEFAULT_VALUE_FOR_CSSOMViewScrollingAPIEnabled);
#if ENABLE(MEDIA_STREAM)
    setCaptureAudioInUIProcessEnabled(DEFAULT_VALUE_FOR_CaptureAudioInUIProcessEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureVideoInUIProcessEnabled(DEFAULT_VALUE_FOR_CaptureVideoInUIProcessEnabled);
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    setInputTypeColorEnabled(DEFAULT_VALUE_FOR_InputTypeColorEnabled);
#endif
#if HAVE(AVCONTENTKEYSPECIFIER)
    setSampleBufferContentKeySessionSupportEnabled(DEFAULT_VALUE_FOR_SampleBufferContentKeySessionSupportEnabled);
#endif
    setCookieConsentAPIEnabled(DEFAULT_VALUE_FOR_CookieConsentAPIEnabled);
    setDOMPasteAccessRequestsEnabled(DEFAULT_VALUE_FOR_DOMPasteAccessRequestsEnabled);
#if PLATFORM(IOS_FAMILY)
    setZoomOnDoubleTapWhenRoot(DEFAULT_VALUE_FOR_ZoomOnDoubleTapWhenRoot);
#endif
#if PLATFORM(IOS_FAMILY)
    setAlwaysZoomOnDoubleTap(DEFAULT_VALUE_FOR_AlwaysZoomOnDoubleTap);
#endif
#if ENABLE(DATALIST_ELEMENT)
    setDataListElementEnabled(DEFAULT_VALUE_FOR_DataListElementEnabled);
#endif
#if ENABLE(INPUT_TYPE_DATE)
    setInputTypeDateEnabled(DEFAULT_VALUE_FOR_InputTypeDateEnabled);
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
    setDateTimeInputsEditableComponentsEnabled(DEFAULT_VALUE_FOR_DateTimeInputsEditableComponentsEnabled);
#endif
    setAutomaticLiveResizeEnabled(DEFAULT_VALUE_FOR_AutomaticLiveResizeEnabled);
    setICECandidateFilteringEnabled(DEFAULT_VALUE_FOR_ICECandidateFilteringEnabled);
#if ENABLE(MEDIA_STREAM)
    setMockCaptureDevicesEnabled(DEFAULT_VALUE_FOR_MockCaptureDevicesEnabled);
#endif
#if ENABLE(PDFJS)
    setPdfJSViewerEnabled(DEFAULT_VALUE_FOR_PdfJSViewerEnabled);
#endif
    setEnterKeyHintEnabled(DEFAULT_VALUE_FOR_EnterKeyHintEnabled);
    setEventHandlerDrivenSmoothKeyboardScrollingEnabled(DEFAULT_VALUE_FOR_EventHandlerDrivenSmoothKeyboardScrollingEnabled);
#if PLATFORM(IOS_FAMILY)
    setPreferFasterClickOverDoubleTap(DEFAULT_VALUE_FOR_PreferFasterClickOverDoubleTap);
#endif
#if PLATFORM(IOS_FAMILY)
    setFasterClicksEnabled(DEFAULT_VALUE_FOR_FasterClicksEnabled);
#endif
    setRestrictedHTTPResponseAccess(DEFAULT_VALUE_FOR_RestrictedHTTPResponseAccess);
    setFrameFlatteningEnabled(DEFAULT_VALUE_FOR_FrameFlatteningEnabled);
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
    setLayoutFormattingContextEnabled(DEFAULT_VALUE_FOR_LayoutFormattingContextEnabled);
#endif
#if ENABLE(FULLSCREEN_API)
    setFullScreenEnabled(DEFAULT_VALUE_FOR_FullScreenEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureAudioInGPUProcessEnabled(DEFAULT_VALUE_FOR_CaptureAudioInGPUProcessEnabled);
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
    setUseGPUProcessForCanvasRenderingEnabled(DEFAULT_VALUE_FOR_UseGPUProcessForCanvasRenderingEnabled);
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
    setUseGPUProcessForMediaEnabled(DEFAULT_VALUE_FOR_UseGPUProcessForMediaEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureVideoInGPUProcessEnabled(DEFAULT_VALUE_FOR_CaptureVideoInGPUProcessEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCPlatformCodecsInGPUProcessEnabled(DEFAULT_VALUE_FOR_WebRTCPlatformCodecsInGPUProcessEnabled);
#endif
    setBlockIOKitInWebContentSandbox(DEFAULT_VALUE_FOR_BlockIOKitInWebContentSandbox);
#if ENABLE(IPC_TESTING_API)
    setIPCTestingAPIEnabled(DEFAULT_VALUE_FOR_IPCTestingAPIEnabled);
#endif
#if ENABLE(TEXT_AUTOSIZING)
    setTextAutosizingUsesIdempotentMode(DEFAULT_VALUE_FOR_TextAutosizingUsesIdempotentMode);
#endif
    setImageAnalysisDuringFindInPageEnabled(DEFAULT_VALUE_FOR_ImageAnalysisDuringFindInPageEnabled);
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
    setInteractionRegionsEnabled(DEFAULT_VALUE_FOR_InteractionRegionsEnabled);
#endif
#if ENABLE(LAYER_BASED_SVG_ENGINE)
    setLayerBasedSVGEngineEnabled(DEFAULT_VALUE_FOR_LayerBasedSVGEngineEnabled);
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
    setLegacyOverflowScrollingTouchEnabled(DEFAULT_VALUE_FOR_LegacyOverflowScrollingTouchEnabled);
#endif
    setShowModalDialogEnabled(DEFAULT_VALUE_FOR_ShowModalDialogEnabled);
#if ENABLE(MEDIA_STREAM)
    setMediaCaptureRequiresSecureConnection(DEFAULT_VALUE_FOR_MediaCaptureRequiresSecureConnection);
#endif
    setLiveRangeSelectionEnabled(DEFAULT_VALUE_FOR_LiveRangeSelectionEnabled);
    setMomentumScrollingAnimatorEnabled(DEFAULT_VALUE_FOR_MomentumScrollingAnimatorEnabled);
#if ENABLE(INPUT_TYPE_MONTH)
    setInputTypeMonthEnabled(DEFAULT_VALUE_FOR_InputTypeMonthEnabled);
#endif
#if ENABLE(TOUCH_EVENTS)
    setMouseEventsSimulationEnabled(DEFAULT_VALUE_FOR_MouseEventsSimulationEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setMuteCameraOnMicrophoneInterruptionEnabled(DEFAULT_VALUE_FOR_MuteCameraOnMicrophoneInterruptionEnabled);
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
    setFlexFormattingContextIntegrationEnabled(DEFAULT_VALUE_FOR_FlexFormattingContextIntegrationEnabled);
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
    setInlineFormattingContextIntegrationEnabled(DEFAULT_VALUE_FOR_InlineFormattingContextIntegrationEnabled);
#endif
#if ENABLE(NOTIFICATION_EVENT)
    setNotificationEventEnabled(DEFAULT_VALUE_FOR_NotificationEventEnabled);
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    setOffscreenCanvasInWorkersEnabled(DEFAULT_VALUE_FOR_OffscreenCanvasInWorkersEnabled);
#endif
#if ENABLE(OFFSCREEN_CANVAS)
    setOffscreenCanvasEnabled(DEFAULT_VALUE_FOR_OffscreenCanvasEnabled);
#endif
#if ENABLE(VIDEO)
    setPreferSandboxedMediaParsing(DEFAULT_VALUE_FOR_PreferSandboxedMediaParsing);
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    setRemoveBackgroundEnabled(DEFAULT_VALUE_FOR_RemoveBackgroundEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setSpeakerSelectionRequiresUserGesture(DEFAULT_VALUE_FOR_SpeakerSelectionRequiresUserGesture);
#endif
#if ENABLE(MEDIA_STREAM)
    setGetUserMediaRequiresFocus(DEFAULT_VALUE_FOR_GetUserMediaRequiresFocus);
#endif
    setResourceLoadSchedulingEnabled(DEFAULT_VALUE_FOR_ResourceLoadSchedulingEnabled);
    setScrollingPerformanceTestingEnabled(DEFAULT_VALUE_FOR_ScrollingPerformanceTestingEnabled);
    setSecureContextChecksEnabled(DEFAULT_VALUE_FOR_SecureContextChecksEnabled);
    setSelectionFlippingEnabled(DEFAULT_VALUE_FOR_SelectionFlippingEnabled);
#if ENABLE(SERVICE_WORKER)
    setServiceWorkersEnabled(DEFAULT_VALUE_FOR_ServiceWorkersEnabled);
#endif
#if ENABLE(IMAGE_ANALYSIS)
    setTextRecognitionInVideosEnabled(DEFAULT_VALUE_FOR_TextRecognitionInVideosEnabled);
#endif
#if ENABLE(INPUT_TYPE_TIME)
    setInputTypeTimeEnabled(DEFAULT_VALUE_FOR_InputTypeTimeEnabled);
#endif
    setUndoManagerAPIEnabled(DEFAULT_VALUE_FOR_UndoManagerAPIEnabled);
    setUpgradeKnownHostsToHTTPSEnabled(DEFAULT_VALUE_FOR_UpgradeKnownHostsToHTTPSEnabled);
#if ENABLE(ARKIT_INLINE_PREVIEW)
    setUseARKitForModel(DEFAULT_VALUE_FOR_UseARKitForModel);
#endif
    setUseGeneralDirectoryForStorage(DEFAULT_VALUE_FOR_UseGeneralDirectoryForStorage);
#if HAVE(SCENEKIT)
    setUseSceneKitForModel(DEFAULT_VALUE_FOR_UseSceneKitForModel);
#endif
#if ENABLE(SERVICE_WORKER)
    setServiceWorkersUserGestureEnabled(DEFAULT_VALUE_FOR_ServiceWorkersUserGestureEnabled);
#endif
#if ENABLE(IMAGE_ANALYSIS)
    setVisualTranslationEnabled(DEFAULT_VALUE_FOR_VisualTranslationEnabled);
#endif
    setWebAPIStatisticsEnabled(DEFAULT_VALUE_FOR_WebAPIStatisticsEnabled);
    setWebRTCAudioLatencyAdaptationEnabled(DEFAULT_VALUE_FOR_WebRTCAudioLatencyAdaptationEnabled);
#if ENABLE(WEB_RTC)
    setWebRTCDTMFEnabled(DEFAULT_VALUE_FOR_WebRTCDTMFEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH264HardwareEncoderEnabled(DEFAULT_VALUE_FOR_WebRTCH264HardwareEncoderEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH264SimulcastEnabled(DEFAULT_VALUE_FOR_WebRTCH264SimulcastEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCRemoteVideoFrameEnabled(DEFAULT_VALUE_FOR_WebRTCRemoteVideoFrameEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCMDNSICECandidatesEnabled(DEFAULT_VALUE_FOR_WebRTCMDNSICECandidatesEnabled);
#endif
#if ENABLE(INPUT_TYPE_WEEK)
    setInputTypeWeekEnabled(DEFAULT_VALUE_FOR_InputTypeWeekEnabled);
#endif
    setIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled(DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled);
    setIsFirstPartyWebsiteDataRemovalReproTestingEnabled(DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalReproTestingEnabled);
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
    setInputTypeDateTimeLocalEnabled(DEFAULT_VALUE_FOR_InputTypeDateTimeLocalEnabled);
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
    setIOSFormControlRefreshEnabled(DEFAULT_VALUE_FOR_IOSFormControlRefreshEnabled);
#endif
    setLineHeightUnitsEnabled(DEFAULT_VALUE_FOR_LineHeightUnitsEnabled);
}

}
