/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebSocketStream.h"

#include "DataReference.h" // NOLINT
#include "Decoder.h" // NOLINT
#include "HandleMessage.h" // NOLINT
#include "WebCoreArgumentCoders.h" // NOLINT
#include "WebSocketStreamMessages.h" // NOLINT
#include <WebCore/SocketStreamError.h> // NOLINT

#if ENABLE(IPC_TESTING_API)
#include "JSIPCBinding.h"
#endif

namespace WebKit {

void WebSocketStream::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    Ref protectedThis { *this };
    if (decoder.messageName() == Messages::WebSocketStream::DidOpenSocketStream::name())
        return IPC::handleMessage<Messages::WebSocketStream::DidOpenSocketStream>(connection, decoder, this, &WebSocketStream::didOpenSocketStream);
    if (decoder.messageName() == Messages::WebSocketStream::DidCloseSocketStream::name())
        return IPC::handleMessage<Messages::WebSocketStream::DidCloseSocketStream>(connection, decoder, this, &WebSocketStream::didCloseSocketStream);
    if (decoder.messageName() == Messages::WebSocketStream::DidReceiveSocketStreamData::name())
        return IPC::handleMessage<Messages::WebSocketStream::DidReceiveSocketStreamData>(connection, decoder, this, &WebSocketStream::didReceiveSocketStreamData);
    if (decoder.messageName() == Messages::WebSocketStream::DidFailToReceiveSocketStreamData::name())
        return IPC::handleMessage<Messages::WebSocketStream::DidFailToReceiveSocketStreamData>(connection, decoder, this, &WebSocketStream::didFailToReceiveSocketStreamData);
    if (decoder.messageName() == Messages::WebSocketStream::DidUpdateBufferedAmount::name())
        return IPC::handleMessage<Messages::WebSocketStream::DidUpdateBufferedAmount>(connection, decoder, this, &WebSocketStream::didUpdateBufferedAmount);
    if (decoder.messageName() == Messages::WebSocketStream::DidFailSocketStream::name())
        return IPC::handleMessage<Messages::WebSocketStream::DidFailSocketStream>(connection, decoder, this, &WebSocketStream::didFailSocketStream);
    if (decoder.messageName() == Messages::WebSocketStream::DidSendData::name())
        return IPC::handleMessage<Messages::WebSocketStream::DidSendData>(connection, decoder, this, &WebSocketStream::didSendData);
    if (decoder.messageName() == Messages::WebSocketStream::DidSendHandshake::name())
        return IPC::handleMessage<Messages::WebSocketStream::DidSendHandshake>(connection, decoder, this, &WebSocketStream::didSendHandshake);
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()), decoder.destinationID());
}

} // namespace WebKit

#if ENABLE(IPC_TESTING_API)

namespace IPC {

template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebSocketStream_DidOpenSocketStream>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebSocketStream::DidOpenSocketStream::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebSocketStream_DidCloseSocketStream>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebSocketStream::DidCloseSocketStream::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebSocketStream_DidReceiveSocketStreamData>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebSocketStream::DidReceiveSocketStreamData::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebSocketStream_DidFailToReceiveSocketStreamData>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebSocketStream::DidFailToReceiveSocketStreamData::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebSocketStream_DidUpdateBufferedAmount>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebSocketStream::DidUpdateBufferedAmount::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebSocketStream_DidFailSocketStream>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebSocketStream::DidFailSocketStream::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebSocketStream_DidSendData>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebSocketStream::DidSendData::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebSocketStream_DidSendHandshake>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebSocketStream::DidSendHandshake::Arguments>(globalObject, decoder);
}

}

#endif

