# frozen_string_literal: true

require_relative "lib/ruby_memcheck/version"

Gem::Specification.new do |spec|
  spec.name          = "ruby_memcheck"
  spec.version       = RubyMemcheck::VERSION
  spec.authors       = ["Peter Zhu"]
  spec.email         = ["peter@peterzhu.ca"]

  spec.summary       = "Use Valgrind memcheck without going crazy"
  spec.homepage      = "https://github.com/peterzhu2118/ruby_memcheck"
  spec.license       = "MIT"
  spec.required_ruby_version = Gem::Requirement.new(">= 2.3.0")

  spec.metadata["homepage_uri"] = spec.homepage

  # Specify which files should be added to the gem when it is released.
  # The `find . -type f -not -path "*/.git/*" -printf "%P\\0"` loads the files in the RubyGem that have been added into git.
  spec.files = Dir.chdir(File.expand_path("..", __FILE__)) do
    %x(find . -type f -not -path "*/.git/*" -printf "%P\\0").split("\x0").reject { |f| f.match(%r{^(test|spec|features)/}) }
  end
  spec.bindir        = "exe"
  spec.executables   = spec.files.grep(%r{^exe/}) { |f| File.basename(f) }
  spec.require_paths = ["lib"]

  spec.add_dependency("nokogiri")

  spec.add_development_dependency("minitest", "~> 5.0")
  spec.add_development_dependency("minitest-parallel_fork", "~> 1.2")
  spec.add_development_dependency("rake", "~> 13.0")
  spec.add_development_dependency("rake-compiler", "~> 1.1")
  spec.add_development_dependency("rspec-core")
end
