/* cheese-window.c generated by valac 0.56.3, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "cheese-fileutil.h"
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include "thumbview/eog-thumb-nav.h"
#include "thumbview/cheese-thumb-view.h"
#include "cheese-camera.h"
#include "cheese-flash.h"
#include "cheese-effect.h"
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include "cheese-camera-device.h"
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include "canberra-gtk.h"
#include <canberra.h>

#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE ((guint) 9)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;
enum  {
	CHEESE_MAIN_WINDOW_0_PROPERTY,
	CHEESE_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* cheese_main_window_properties[CHEESE_MAIN_WINDOW_NUM_PROPERTIES];
typedef enum  {
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP = 1,
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL = 2
} CheeseMainWindowDeleteResponse;

#define CHEESE_MAIN_WINDOW_TYPE_DELETE_RESPONSE (cheese_main_window_delete_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef void (*CheeseCountdownCountdownCallback) (gpointer user_data);
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _CheeseMainWindow {
	GtkApplicationWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	ClutterScript* clutter_builder;
	GtkBuilder* header_bar_ui;
	GtkHeaderBar* header_bar;
	GSettings* settings;
	GtkClutterEmbed* viewport_widget;
	GtkWidget* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkBox* thumbnails_right;
	GtkBox* thumbnails_bottom;
	GtkWidget* leave_fullscreen_button_box;
	GtkButton* take_action_button;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkWidget* buttons_area;
	GtkButton* switch_camera_button;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterActor* viewport_layout;
	ClutterActor* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterActor* background_layer;
	ClutterText* error_layer;
	ClutterText* timeout_layer;
	ClutterActor* current_effects_grid;
	guint current_effects_page;
	GList* effects_grids;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean action_cancelled;
	gboolean was_maximized;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheeseEffect* selected_effect;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
};

struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};

static gint CheeseMainWindow_private_offset;
static gpointer cheese_main_window_parent_class = NULL;

VALA_EXTERN GType cheese_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheeseMainWindow, g_object_unref)
VALA_EXTERN GType cheese_effects_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheeseEffectsManager, g_object_unref)
VALA_EXTERN GType cheese_countdown_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheeseCountdown, g_object_unref)
static GType cheese_main_window_delete_response_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void cheese_main_window_on_file_open (CheeseMainWindow* self);
static void _cheese_main_window_on_file_open_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void cheese_main_window_on_file_saveas (CheeseMainWindow* self);
static void _cheese_main_window_on_file_saveas_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void cheese_main_window_on_file_trash (CheeseMainWindow* self);
static void _cheese_main_window_on_file_trash_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void cheese_main_window_on_file_delete (CheeseMainWindow* self);
static void _cheese_main_window_on_file_delete_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void cheese_main_window_on_effects_next (CheeseMainWindow* self);
static void _cheese_main_window_on_effects_next_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void cheese_main_window_on_effects_previous (CheeseMainWindow* self);
static void _cheese_main_window_on_effects_previous_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
VALA_EXTERN CheeseMainWindow* cheese_main_window_construct (GType object_type,
                                                GtkApplication* application);
static void cheese_main_window_set_window_title (CheeseMainWindow* self,
                                          const gchar* title);
static gboolean cheese_main_window_on_window_state_change_event (CheeseMainWindow* self,
                                                          GtkWidget* widget,
                                                          GdkEventWindowState* event);
static gboolean _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                         GdkEventWindowState* event,
                                                                                         gpointer self);
static void cheese_main_window_do_thumb_view_popup_menu (CheeseMainWindow* self);
static gboolean cheese_main_window_on_thumb_view_popup_menu (CheeseMainWindow* self);
VALA_EXTERN gboolean cheese_main_window_on_thumbnail_button_press_event (CheeseMainWindow* self,
                                                             GtkWidget* iconview,
                                                             GdkEventButton* event);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN void cheese_main_window_set_fullscreen (CheeseMainWindow* self,
                                        gboolean fullscreen);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self,
                                             gboolean fullscreen);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self,
                                        CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean __lambda4_ (CheeseMainWindow* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self,
                                                               GtkWidget* viewport,
                                                               GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                               GdkEventMotion* event,
                                                                                               gpointer self);
VALA_EXTERN void cheese_main_window_set_wide_mode (CheeseMainWindow* self,
                                       gboolean wide_mode);
VALA_EXTERN void cheese_main_window_on_stage_resize (CheeseMainWindow* self,
                                         ClutterActor* actor,
                                         ClutterActorBox* box,
                                         ClutterAllocationFlags flags);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_take_photo (CheeseMainWindow* self);
VALA_EXTERN CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
VALA_EXTERN CheeseCountdown* cheese_countdown_construct (GType object_type,
                                             ClutterText* countdown_actor);
VALA_EXTERN void cheese_countdown_start (CheeseCountdown* self,
                             CheeseCountdownCountdownCallback completed_callback,
                             gpointer completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self,
                                               gboolean is_start);
static gboolean cheese_main_window_cancel_running_action (CheeseMainWindow* self);
VALA_EXTERN void cheese_countdown_stop (CheeseCountdown* self);
VALA_EXTERN void cheese_main_window_toggle_video_recording (CheeseMainWindow* self,
                                                gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self,
                                            GdkEventKey* event);
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self);
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
VALA_EXTERN void cheese_main_window_shoot (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_show_error (CheeseMainWindow* self,
                                    const gchar* _error_);
VALA_EXTERN void cheese_main_window_set_effects (CheeseMainWindow* self,
                                     gboolean effects);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self,
                                                 gboolean active);
VALA_EXTERN void cheese_main_window_on_selected_effect_change (CheeseMainWindow* self,
                                                   ClutterTapAction* tap,
                                                   ClutterActor* source);
static gboolean cheese_main_window_is_previous_effects_page (CheeseMainWindow* self);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self,
                                               gint number);
static gboolean cheese_main_window_is_next_effects_page (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_update_header_bar_title (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
VALA_EXTERN CheeseEffectsManager* cheese_effects_manager_new (void);
VALA_EXTERN CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
VALA_EXTERN void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static void _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap (ClutterTapAction* _sender,
                                                                           ClutterActor* actor,
                                                                           gpointer self);
VALA_EXTERN void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
VALA_EXTERN CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self,
                                                 const gchar* name);
VALA_EXTERN void cheese_main_window_camera_state_change_null (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_on_switch_camera_clicked (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_set_switch_camera_button_state (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_setup_ui (CheeseMainWindow* self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender,
                                                                           ClutterActorBox* box,
                                                                           ClutterAllocationFlags flags,
                                                                           gpointer self);
static gboolean _cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                             gpointer self);
static gboolean _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                            GdkEventButton* event,
                                                                                            gpointer self);
static void _cheese_main_window_on_switch_camera_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                          GdkEventKey* event,
                                                                          gpointer self);
VALA_EXTERN ClutterActor* cheese_main_window_get_video_preview (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_set_current_mode (CheeseMainWindow* self,
                                          CheeseMediaMode mode);
VALA_EXTERN void cheese_main_window_set_camera (CheeseMainWindow* self,
                                    CheeseCamera* camera);
static void cheese_main_window_finalize (GObject * obj);
static GType cheese_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry CHEESE_MAIN_WINDOW_actions[6] = {{"file-open", _cheese_main_window_on_file_open_gsimple_action_activate_callback}, {"file-saveas", _cheese_main_window_on_file_saveas_gsimple_action_activate_callback}, {"file-trash", _cheese_main_window_on_file_trash_gsimple_action_activate_callback}, {"file-delete", _cheese_main_window_on_file_delete_gsimple_action_activate_callback}, {"effects-next", _cheese_main_window_on_effects_next_gsimple_action_activate_callback}, {"effects-previous", _cheese_main_window_on_effects_previous_gsimple_action_activate_callback}};

static inline gpointer
cheese_main_window_get_instance_private (CheeseMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, CheeseMainWindow_private_offset);
}

/**
   * Responses from the delete files confirmation dialog.
   *
   * @param SKIP skip a single file
   * @param SKIP_ALL skill all following files
   */
static GType
cheese_main_window_delete_response_get_type_once (void)
{
	static const GEnumValue values[] = {{CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP", "skip"}, {CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL", "skip-all"}, {0, NULL, NULL}};
	GType cheese_main_window_delete_response_type_id;
	cheese_main_window_delete_response_type_id = g_enum_register_static ("CheeseMainWindowDeleteResponse", values);
	return cheese_main_window_delete_response_type_id;
}

static GType
cheese_main_window_delete_response_get_type (void)
{
	static volatile gsize cheese_main_window_delete_response_type_id__once = 0;
	if (g_once_init_enter (&cheese_main_window_delete_response_type_id__once)) {
		GType cheese_main_window_delete_response_type_id;
		cheese_main_window_delete_response_type_id = cheese_main_window_delete_response_get_type_once ();
		g_once_init_leave (&cheese_main_window_delete_response_type_id__once, cheese_main_window_delete_response_type_id);
	}
	return cheese_main_window_delete_response_type_id__once;
}

static void
_cheese_main_window_on_file_open_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	cheese_main_window_on_file_open ((CheeseMainWindow*) self);
}

static void
_cheese_main_window_on_file_saveas_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	cheese_main_window_on_file_saveas ((CheeseMainWindow*) self);
}

static void
_cheese_main_window_on_file_trash_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	cheese_main_window_on_file_trash ((CheeseMainWindow*) self);
}

static void
_cheese_main_window_on_file_delete_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	cheese_main_window_on_file_delete ((CheeseMainWindow*) self);
}

static void
_cheese_main_window_on_effects_next_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	cheese_main_window_on_effects_next ((CheeseMainWindow*) self);
}

static void
_cheese_main_window_on_effects_previous_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	cheese_main_window_on_effects_previous ((CheeseMainWindow*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CheeseMainWindow*
cheese_main_window_construct (GType object_type,
                              GtkApplication* application)
{
	CheeseMainWindow * self = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkHeaderBar* _tmp3_;
	GtkHeaderBar* _tmp4_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (CheeseMainWindow*) g_object_new (object_type, "application", application, NULL);
	_tmp0_ = self->priv->header_bar_ui;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "header_bar");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp1_) : NULL);
	_g_object_unref0 (self->priv->header_bar);
	self->priv->header_bar = _tmp2_;
	_tmp3_ = self->priv->header_bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->header_bar;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp4_);
	return self;
}

CheeseMainWindow*
cheese_main_window_new (GtkApplication* application)
{
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW, application);
}

static void
cheese_main_window_set_window_title (CheeseMainWindow* self,
                                     const gchar* title)
{
	GtkHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->header_bar;
	gtk_header_bar_set_title (_tmp0_, title);
	gtk_window_set_title ((GtkWindow*) self, title);
}

static gboolean
_cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                GdkEventWindowState* event,
                                                                                gpointer self)
{
	gboolean result;
	result = cheese_main_window_on_window_state_change_event ((CheeseMainWindow*) self, _sender, event);
	return result;
}

static gboolean
cheese_main_window_on_window_state_change_event (CheeseMainWindow* self,
                                                 GtkWidget* widget,
                                                 GdkEventWindowState* event)
{
	guint _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->was_maximized = ((event->new_window_state - event->changed_mask) & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	g_signal_parse_name ("window-state-event", gtk_widget_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event, self);
	result = FALSE;
	return result;
}

static void
cheese_main_window_do_thumb_view_popup_menu (CheeseMainWindow* self)
{
	GtkMenu* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumbnail_popup;
	gtk_menu_popup_at_pointer (_tmp0_, NULL);
}

static gboolean
cheese_main_window_on_thumb_view_popup_menu (CheeseMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	cheese_main_window_do_thumb_view_popup_menu (self);
	result = TRUE;
	return result;
}

/**
    * Popup a context menu when right-clicking on a thumbnail.
    *
    * @param iconview the thumbnail view that emitted the signal
    * @param event the event
    * @return false to allow further processing of the event, true to indicate
    * that the event was handled completely
    */
static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

gboolean
cheese_main_window_on_thumbnail_button_press_event (CheeseMainWindow* self,
                                                    GtkWidget* iconview,
                                                    GdkEventButton* event)
{
	GtkTreePath* path = NULL;
	CheeseThumbView* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	CheeseThumbView* _tmp3_;
	GtkTreePath* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) _tmp0_, (gint) event->x, (gint) event->y);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ == NULL) {
		result = FALSE;
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = path;
	if (!gtk_icon_view_path_is_selected ((GtkIconView*) _tmp3_, _tmp4_)) {
		CheeseThumbView* _tmp5_;
		CheeseThumbView* _tmp6_;
		GtkTreePath* _tmp7_;
		CheeseThumbView* _tmp8_;
		GtkTreePath* _tmp9_;
		_tmp5_ = self->priv->thumb_view;
		gtk_icon_view_unselect_all ((GtkIconView*) _tmp5_);
		_tmp6_ = self->priv->thumb_view;
		_tmp7_ = path;
		gtk_icon_view_select_path ((GtkIconView*) _tmp6_, _tmp7_);
		_tmp8_ = self->priv->thumb_view;
		_tmp9_ = path;
		gtk_icon_view_set_cursor ((GtkIconView*) _tmp8_, _tmp9_, NULL, FALSE);
	}
	if (event->type == GDK_BUTTON_PRESS) {
		GdkEvent* button_press = NULL;
		GdkEvent* _tmp10_;
		button_press = (GdkEvent*) event;
		_tmp10_ = button_press;
		if (gdk_event_triggers_context_menu (_tmp10_)) {
			cheese_main_window_do_thumb_view_popup_menu (self);
			result = TRUE;
			__vala_GtkTreePath_free0 (path);
			return result;
		}
	} else {
		if (event->type == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (self);
			result = TRUE;
			__vala_GtkTreePath_free0 (path);
			return result;
		}
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (path);
	return result;
}

/**
   * Open an image associated with a thumbnail in the default application.
   */
static void
cheese_main_window_on_file_open (CheeseMainWindow* self)
{
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	{
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GdkScreen* _tmp7_;
		GdkScreen* _tmp8_;
		GdkScreen* _tmp9_;
		const gchar* _tmp10_;
		_tmp4_ = filename;
		_tmp5_ = g_filename_to_uri (_tmp4_, NULL, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (uri);
		uri = _tmp6_;
		_tmp7_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (screen);
		screen = _tmp8_;
		_tmp9_ = screen;
		_tmp10_ = uri;
		gtk_show_uri (_tmp9_, _tmp10_, gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp3_);
			goto __catch0_g_error;
		}
		_g_free0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GtkMessageDialog* error_dialog = NULL;
		const gchar* _tmp11_;
		GtkMessageDialog* _tmp12_;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* _tmp14_;
		g_clear_error (&_inner_error0_);
		_tmp11_ = filename;
		_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not open %s"), _tmp11_);
		g_object_ref_sink (_tmp12_);
		error_dialog = _tmp12_;
		_tmp13_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp13_);
		_tmp14_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp14_);
		_g_object_unref0 (error_dialog);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}

/**
   * Delete the requested image or images in the thumbview from storage.
   *
   * A confirmation dialog is shown to the user before deleting any files.
   */
static void
cheese_main_window_on_file_delete (CheeseMainWindow* self)
{
	gint response = 0;
	gint error_response = 0;
	gboolean skip_all_errors = FALSE;
	GList* files = NULL;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_;
	guint files_length = 0U;
	GList* _tmp2_;
	GtkMessageDialog* confirmation_dialog = NULL;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkMessageDialog* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	skip_all_errors = FALSE;
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	_tmp2_ = files;
	files_length = g_list_length (_tmp2_);
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, ngettext ("Are you sure you want to permanently delete the file?", "Are you sure you want to permanently delete %d files?", (gulong) files_length), files_length);
	g_object_ref_sink (_tmp3_);
	confirmation_dialog = _tmp3_;
	_tmp4_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp4_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp5_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp5_, _ ("_Delete"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp6_ = confirmation_dialog;
	gtk_message_dialog_format_secondary_text (_tmp6_, "%s", ngettext ("If you delete an item, it will be permanently lost", "If you delete the items, they will be permanently lost", (gulong) files_length));
	_tmp7_ = confirmation_dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp7_);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		GList* _tmp8_;
		_tmp8_ = files;
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _tmp8_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* _tmp9_;
				GFile* file = NULL;
				_tmp9_ = _g_object_ref0 ((GFile*) file_it->data);
				file = _tmp9_;
				{
					GFile* _tmp10_;
					_tmp10_ = file;
					if (_tmp10_ == NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
						return;
					}
					{
						GFile* _tmp11_;
						_tmp11_ = file;
						g_file_delete (_tmp11_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* err = NULL;
						GError* _tmp12_;
						const gchar* _tmp13_;
						err = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp12_ = err;
						_tmp13_ = _tmp12_->message;
						g_warning ("cheese-window.vala:278: Unable to delete file: %s", _tmp13_);
						if (!skip_all_errors) {
							GtkMessageDialog* error_dialog = NULL;
							GFile* _tmp14_;
							gchar* _tmp15_;
							gchar* _tmp16_;
							GtkMessageDialog* _tmp17_;
							GtkMessageDialog* _tmp18_;
							GtkMessageDialog* _tmp19_;
							GtkMessageDialog* _tmp20_;
							GtkMessageDialog* _tmp21_;
							GtkMessageDialog* _tmp22_;
							GtkMessageDialog* _tmp23_;
							_tmp14_ = file;
							_tmp15_ = g_file_get_path (_tmp14_);
							_tmp16_ = _tmp15_;
							_tmp17_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, _ ("Could not delete %s"), _tmp16_);
							g_object_ref_sink (_tmp17_);
							_tmp18_ = _tmp17_;
							_g_free0 (_tmp16_);
							error_dialog = _tmp18_;
							_tmp19_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp19_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
							_tmp20_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp20_, _ ("Skip"), (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP);
							_tmp21_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp21_, _ ("Skip all"), (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL);
							_tmp22_ = error_dialog;
							error_response = gtk_dialog_run ((GtkDialog*) _tmp22_);
							if (error_response == ((gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL)) {
								skip_all_errors = TRUE;
							} else {
								if (error_response == ((gint) GTK_RESPONSE_CANCEL)) {
									_g_object_unref0 (error_dialog);
									_g_error_free0 (err);
									_g_object_unref0 (file);
									break;
								}
							}
							_tmp23_ = error_dialog;
							gtk_widget_destroy ((GtkWidget*) _tmp23_);
							_g_object_unref0 (error_dialog);
						}
						_g_error_free0 (err);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	_tmp24_ = confirmation_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp24_);
	_g_object_unref0 (confirmation_dialog);
	(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
}

/**
   * Move the requested image in the thumbview to the trash.
   *
   * A confirmation dialog is shown to the user before moving the file.
   */
static void
cheese_main_window_on_file_trash (CheeseMainWindow* self)
{
	GFile* file = NULL;
	GList* files = NULL;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GList* _tmp4_;
				GList* _tmp5_;
				GList* _tmp6_;
				gconstpointer _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = files;
				if (!(((guint) i) < g_list_length (_tmp4_))) {
					break;
				}
				_tmp5_ = files;
				_tmp6_ = g_list_nth (_tmp5_, (guint) i);
				_tmp7_ = _tmp6_->data;
				_tmp8_ = _g_object_ref0 ((GFile*) _tmp7_);
				_g_object_unref0 (file);
				file = _tmp8_;
				_tmp9_ = file;
				if (_tmp9_ == NULL) {
					(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
					_g_object_unref0 (file);
					return;
				}
				{
					GFile* _tmp10_;
					_tmp10_ = file;
					g_file_trash (_tmp10_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GtkMessageDialog* error_dialog = NULL;
					GFile* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					GtkMessageDialog* _tmp14_;
					GtkMessageDialog* _tmp15_;
					GtkMessageDialog* _tmp16_;
					GtkMessageDialog* _tmp17_;
					g_clear_error (&_inner_error0_);
					_tmp11_ = file;
					_tmp12_ = g_file_get_path (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not move %s to trash"), _tmp13_);
					g_object_ref_sink (_tmp14_);
					_tmp15_ = _tmp14_;
					_g_free0 (_tmp13_);
					error_dialog = _tmp15_;
					_tmp16_ = error_dialog;
					gtk_dialog_run ((GtkDialog*) _tmp16_);
					_tmp17_ = error_dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp17_);
					_g_object_unref0 (error_dialog);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
	(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
	_g_object_unref0 (file);
}

/**
   * Save the selected file in the thumbview to an alternate storage location.
   *
   * A file chooser dialog is shown to the user, asking where the file should
   * be saved and the filename.
   */
static void
cheese_main_window_on_file_saveas (CheeseMainWindow* self)
{
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	const gchar* _tmp8_;
	GtkFileChooserDialog* _tmp9_;
	const gchar* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	GtkFileChooserDialog* _tmp12_;
	GtkFileChooserDialog* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("Save"), GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp3_;
	_tmp4_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp4_, TRUE);
	_tmp5_ = filename;
	_tmp6_ = g_filename_display_basename (_tmp5_);
	_g_free0 (basename);
	basename = _tmp6_;
	_tmp7_ = save_as_dialog;
	_tmp8_ = basename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp7_, _tmp8_);
	_tmp9_ = save_as_dialog;
	_tmp10_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp9_, _tmp10_);
	_tmp11_ = save_as_dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp11_);
	_tmp12_ = save_as_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp12_);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* target_filename = NULL;
		GtkFileChooserDialog* _tmp13_;
		gchar* _tmp14_;
		GFile* src = NULL;
		const gchar* _tmp15_;
		GFile* _tmp16_;
		GFile* dest = NULL;
		const gchar* _tmp17_;
		GFile* _tmp18_;
		_tmp13_ = save_as_dialog;
		_tmp14_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp13_);
		_g_free0 (target_filename);
		target_filename = _tmp14_;
		_tmp15_ = filename;
		_tmp16_ = g_file_new_for_path (_tmp15_);
		src = _tmp16_;
		_tmp17_ = target_filename;
		_tmp18_ = g_file_new_for_path (_tmp17_);
		dest = _tmp18_;
		{
			GFile* _tmp19_;
			GFile* _tmp20_;
			_tmp19_ = src;
			_tmp20_ = dest;
			g_file_copy (_tmp19_, _tmp20_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GtkMessageDialog* error_dialog = NULL;
			const gchar* _tmp21_;
			GtkMessageDialog* _tmp22_;
			GtkMessageDialog* _tmp23_;
			GtkMessageDialog* _tmp24_;
			g_clear_error (&_inner_error0_);
			_tmp21_ = target_filename;
			_tmp22_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not save %s"), _tmp21_);
			g_object_ref_sink (_tmp22_);
			error_dialog = _tmp22_;
			_tmp23_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp23_);
			_tmp24_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp24_);
			_g_object_unref0 (error_dialog);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	_tmp25_ = save_as_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp25_);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}

/**
     * Toggle fullscreen mode.
     *
     * @param fullscreen whether the window should be fullscreen
     */
void
cheese_main_window_set_fullscreen (CheeseMainWindow* self,
                                   gboolean fullscreen)
{
	g_return_if_fail (self != NULL);
	cheese_main_window_set_fullscreen_mode (self, fullscreen);
}

/**
     * Make the media capture mode actions sensitive.
     */
static void
cheese_main_window_enable_mode_change (CheeseMainWindow* self)
{
	GSimpleAction* mode = NULL;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* effects = NULL;
	GtkApplication* _tmp4_;
	GtkApplication* _tmp5_;
	GAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* preferences = NULL;
	GtkApplication* _tmp8_;
	GtkApplication* _tmp9_;
	GAction* _tmp10_;
	GSimpleAction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (mode, TRUE);
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) _tmp5_, "effects");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	effects = _tmp7_;
	g_simple_action_set_enabled (effects, TRUE);
	_tmp8_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) _tmp9_, "preferences");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp10_) : NULL);
	preferences = _tmp11_;
	g_simple_action_set_enabled (preferences, TRUE);
	_g_object_unref0 (preferences);
	_g_object_unref0 (effects);
	_g_object_unref0 (mode);
}

/**
     * Make the media capture mode actions insensitive.
     */
static void
cheese_main_window_disable_mode_change (CheeseMainWindow* self)
{
	GSimpleAction* mode = NULL;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* effects = NULL;
	GtkApplication* _tmp4_;
	GtkApplication* _tmp5_;
	GAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* preferences = NULL;
	GtkApplication* _tmp8_;
	GtkApplication* _tmp9_;
	GAction* _tmp10_;
	GSimpleAction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (mode, FALSE);
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) _tmp5_, "effects");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	effects = _tmp7_;
	g_simple_action_set_enabled (effects, FALSE);
	_tmp8_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) _tmp9_, "preferences");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp10_) : NULL);
	preferences = _tmp11_;
	g_simple_action_set_enabled (preferences, FALSE);
	_g_object_unref0 (preferences);
	_g_object_unref0 (effects);
	_g_object_unref0 (mode);
}

/**
   * Set the capture resolution, based on the current capture mode.
   *
   * @param mode the current capture mode (photo, video or burst)
   */
static void
cheese_main_window_set_resolution (CheeseMainWindow* self,
                                   CheeseMediaMode mode)
{
	CheeseCamera* _tmp0_;
	GList* formats = NULL;
	CheeseCamera* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	CheeseVideoFormat* format = NULL;
	gint width = 0;
	gint height = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_video_formats (_tmp1_);
	formats = _tmp2_;
	_tmp3_ = formats;
	if (_tmp3_ == NULL) {
		(formats == NULL) ? NULL : (formats = (g_list_free (formats), NULL));
		return;
	}
	width = 0;
	height = 0;
	switch (mode) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			GSettings* _tmp4_;
			GSettings* _tmp5_;
			_tmp4_ = self->priv->settings;
			width = g_settings_get_int (_tmp4_, "photo-x-resolution");
			_tmp5_ = self->priv->settings;
			height = g_settings_get_int (_tmp5_, "photo-y-resolution");
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GSettings* _tmp6_;
			GSettings* _tmp7_;
			_tmp6_ = self->priv->settings;
			width = g_settings_get_int (_tmp6_, "video-x-resolution");
			_tmp7_ = self->priv->settings;
			height = g_settings_get_int (_tmp7_, "video-y-resolution");
			break;
		}
		default:
		break;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GList* _tmp10_;
				GList* _tmp11_;
				GList* _tmp12_;
				gconstpointer _tmp13_;
				gboolean _tmp14_ = FALSE;
				CheeseVideoFormat* _tmp15_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = formats;
				if (!(((guint) i) < g_list_length (_tmp10_))) {
					break;
				}
				_tmp11_ = formats;
				_tmp12_ = g_list_nth (_tmp11_, (guint) i);
				_tmp13_ = _tmp12_->data;
				format = (CheeseVideoFormat*) _tmp13_;
				_tmp15_ = format;
				if (width == _tmp15_->width) {
					CheeseVideoFormat* _tmp16_;
					_tmp16_ = format;
					_tmp14_ = height == _tmp16_->height;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					CheeseCamera* _tmp17_;
					CheeseVideoFormat* _tmp18_;
					_tmp17_ = self->priv->camera;
					_tmp18_ = format;
					cheese_camera_set_video_format (_tmp17_, _tmp18_);
					break;
				}
			}
		}
	}
	(formats == NULL) ? NULL : (formats = (g_list_free (formats), NULL));
}

/**
   * Clear the fullscreen activity timeout.
   */
static void
cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self)
{
	GSource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fullscreen_timeout;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_;
		_tmp1_ = self->priv->fullscreen_timeout;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = NULL;
	}
}

/**
   * Set the fullscreen timeout, for hiding the UI if there is no mouse
   * movement.
   */
static gboolean
__lambda4_ (CheeseMainWindow* self)
{
	GtkWidget* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_hide (_tmp0_);
	cheese_main_window_clear_fullscreen_timeout (self);
	gtk_window_fullscreen ((GtkWindow*) self);
	result = TRUE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((CheeseMainWindow*) self);
	return result;
}

static void
cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self)
{
	GSource* _tmp0_;
	GSource* _tmp1_;
	GSource* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp0_;
	_tmp1_ = self->priv->fullscreen_timeout;
	g_source_attach (_tmp1_, NULL);
	_tmp2_ = self->priv->fullscreen_timeout;
	g_source_set_callback (_tmp2_, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}

/**
     * Show the UI in fullscreen if there is any mouse activity.
     *
     * Start a new timeout at the end of every mouse pointer movement. All
     * timeouts will be cancelled, except one created during the last movement
     * event. Show() is called even if the button is not hidden.
     *
     * @param viewport the widget to check for mouse activity on
     * @param e the (unused) event
     */
static gboolean
cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self,
                                                      GtkWidget* viewport,
                                                      GdkEventMotion* e)
{
	GtkWidget* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	gtk_window_unfullscreen ((GtkWindow*) self);
	gtk_window_maximize ((GtkWindow*) self);
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_show (_tmp0_);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}

/**
   * Enable or disable fullscreen mode to the requested state.
   *
   * @param fullscreen_mode whether to enable or disable fullscreen mode
   */
static gboolean
_cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                      GdkEventMotion* event,
                                                                                      gpointer self)
{
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback ((CheeseMainWindow*) self, _sender, event);
	return result;
}

static void
cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self,
                                        gboolean fullscreen)
{
	g_return_if_fail (self != NULL);
	self->priv->is_fullscreen = fullscreen;
	if (fullscreen) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkClutterEmbed* _tmp4_;
		g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event, self, 0);
		if (self->priv->is_wide_mode) {
			GtkBox* _tmp0_;
			_tmp0_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp0_);
		} else {
			GtkBox* _tmp1_;
			_tmp1_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp1_);
		}
		_tmp2_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_set_no_show_all (_tmp2_, FALSE);
		_tmp3_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_show_all (_tmp3_);
		gtk_window_fullscreen ((GtkWindow*) self);
		_tmp4_ = self->priv->viewport_widget;
		g_signal_connect_object ((GtkWidget*) _tmp4_, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		GtkClutterEmbed* _tmp9_;
		guint _tmp10_;
		if (self->priv->is_wide_mode) {
			GtkBox* _tmp5_;
			_tmp5_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp5_);
		} else {
			GtkBox* _tmp6_;
			_tmp6_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp6_);
		}
		_tmp7_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_hide (_tmp7_);
		cheese_main_window_clear_fullscreen_timeout (self);
		_tmp8_ = self->priv->buttons_area;
		gtk_widget_show (_tmp8_);
		_tmp9_ = self->priv->viewport_widget;
		g_signal_parse_name ("motion-notify-event", gtk_widget_get_type (), &_tmp10_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
		if (self->priv->was_maximized) {
			gtk_window_maximize ((GtkWindow*) self);
		} else {
			gtk_window_unmaximize ((GtkWindow*) self);
		}
	}
}

/**
   * Enable or disable wide mode to the requested state.
   *
   * @param wide_mode whether to enable or disable wide mode
   */
void
cheese_main_window_set_wide_mode (CheeseMainWindow* self,
                                  gboolean wide_mode)
{
	GtkAllocation alloc = {0};
	GtkClutterEmbed* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GtkClutterEmbed* _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	GtkRequisition req = {0};
	GtkRequisition _tmp29_ = {0};
	GtkRequisition _tmp30_ = {0};
	GtkRequisition _tmp31_;
	GtkRequisition _tmp32_;
	GtkClutterEmbed* _tmp33_;
	g_return_if_fail (self != NULL);
	self->priv->is_wide_mode = wide_mode;
	_tmp0_ = self->priv->viewport_widget;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	alloc = _tmp1_;
	_tmp2_ = self->priv->viewport_widget;
	_tmp3_ = alloc;
	_tmp4_ = alloc;
	gtk_widget_set_size_request ((GtkWidget*) _tmp2_, _tmp3_.width, _tmp4_.height);
	if (self->priv->is_wide_mode) {
		CheeseThumbView* _tmp5_;
		EogThumbNav* _tmp6_;
		GtkBox* _tmp7_;
		GList* _tmp8_;
		GList* _tmp9_;
		gboolean _tmp10_;
		GtkBox* _tmp13_;
		EogThumbNav* _tmp14_;
		_tmp5_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp5_, TRUE);
		_tmp6_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp6_, TRUE);
		_tmp7_ = self->priv->thumbnails_bottom;
		_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ != NULL;
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (g_list_free (_tmp9_), NULL));
		if (_tmp10_) {
			GtkBox* _tmp11_;
			EogThumbNav* _tmp12_;
			_tmp11_ = self->priv->thumbnails_bottom;
			_tmp12_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
		}
		_tmp13_ = self->priv->thumbnails_right;
		_tmp14_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		if (!self->priv->is_fullscreen) {
			GtkBox* _tmp15_;
			GtkBox* _tmp16_;
			_tmp15_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp15_);
			_tmp16_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp16_);
		}
	} else {
		CheeseThumbView* _tmp17_;
		EogThumbNav* _tmp18_;
		GtkBox* _tmp19_;
		GList* _tmp20_;
		GList* _tmp21_;
		gboolean _tmp22_;
		GtkBox* _tmp25_;
		EogThumbNav* _tmp26_;
		_tmp17_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp17_, FALSE);
		_tmp18_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp18_, FALSE);
		_tmp19_ = self->priv->thumbnails_right;
		_tmp20_ = gtk_container_get_children ((GtkContainer*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_ != NULL;
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (g_list_free (_tmp21_), NULL));
		if (_tmp22_) {
			GtkBox* _tmp23_;
			EogThumbNav* _tmp24_;
			_tmp23_ = self->priv->thumbnails_right;
			_tmp24_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
		}
		_tmp25_ = self->priv->thumbnails_bottom;
		_tmp26_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
		if (!self->priv->is_fullscreen) {
			GtkBox* _tmp27_;
			GtkBox* _tmp28_;
			_tmp27_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp27_);
			_tmp28_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp28_);
		}
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp29_, &_tmp30_);
	req = _tmp29_;
	req = _tmp30_;
	_tmp31_ = req;
	_tmp32_ = req;
	gtk_window_resize ((GtkWindow*) self, _tmp31_.width, _tmp32_.height);
	_tmp33_ = self->priv->viewport_widget;
	gtk_widget_set_size_request ((GtkWidget*) _tmp33_, -1, -1);
}

/**
   * Make sure that the layout manager manages the entire stage.
   *
   * @param actor unused
   * @param box unused
   * @param flags unused
   */
void
cheese_main_window_on_stage_resize (CheeseMainWindow* self,
                                    ClutterActor* actor,
                                    ClutterActorBox* box,
                                    ClutterAllocationFlags flags)
{
	ClutterActor* _tmp0_;
	ClutterStage* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	ClutterStage* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	ClutterActor* _tmp7_;
	ClutterStage* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterStage* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	ClutterText* _tmp14_;
	ClutterActor* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	ClutterStage* _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	ClutterStage* _tmp21_;
	gfloat _tmp22_;
	gfloat _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = self->priv->viewport;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	clutter_actor_set_size (_tmp0_, _tmp3_, _tmp6_);
	_tmp7_ = self->priv->background_layer;
	_tmp8_ = self->priv->viewport;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->viewport;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_set_size (_tmp7_, _tmp10_, _tmp13_);
	_tmp14_ = self->priv->timeout_layer;
	_tmp15_ = self->priv->video_preview;
	_tmp16_ = clutter_actor_get_width (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->viewport;
	_tmp19_ = clutter_actor_get_width ((ClutterActor*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->viewport;
	_tmp22_ = clutter_actor_get_height ((ClutterActor*) _tmp21_);
	_tmp23_ = _tmp22_;
	clutter_actor_set_position ((ClutterActor*) _tmp14_, (_tmp17_ / 3) + (_tmp20_ / 2), _tmp23_ - 20);
}

/**
   * The method to call when the countdown is finished.
   */
static void
cheese_main_window_finish_countdown_callback (CheeseMainWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->action_cancelled == FALSE) {
		gchar* file_name = NULL;
		CheeseFileUtil* _tmp0_;
		gchar* _tmp1_;
		GSettings* _tmp2_;
		GtkWidget* _tmp4_;
		CheeseCamera* _tmp5_;
		const gchar* _tmp6_;
		_tmp0_ = self->priv->fileutil;
		_tmp1_ = cheese_fileutil_get_new_media_filename (_tmp0_, self->priv->current_mode);
		file_name = _tmp1_;
		_tmp2_ = self->priv->settings;
		if (g_settings_get_boolean (_tmp2_, "flash")) {
			CheeseFlash* _tmp3_;
			_tmp3_ = self->priv->flash;
			cheese_flash_fire (_tmp3_);
		}
		_tmp4_ = self->priv->main_vbox;
		ca_gtk_play_for_widget (_tmp4_, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _ ("Shutter sound"), NULL, NULL);
		_tmp5_ = self->priv->camera;
		_tmp6_ = file_name;
		cheese_camera_take_photo (_tmp5_, _tmp6_);
		_g_free0 (file_name);
	}
	if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_enable_mode_change (self);
	}
}

/**
   * Start to take a photo, starting a countdown if it is enabled.
   */
static void
_cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self)
{
	cheese_main_window_finish_countdown_callback ((CheeseMainWindow*) self);
}

void
cheese_main_window_take_photo (CheeseMainWindow* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp0_, "countdown")) {
		ClutterText* _tmp1_;
		CheeseCountdown* _tmp2_;
		CheeseCountdown* _tmp3_;
		if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
			cheese_main_window_disable_mode_change (self);
		}
		_tmp1_ = self->priv->countdown_layer;
		_tmp2_ = cheese_countdown_new (_tmp1_);
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp2_;
		_tmp3_ = self->priv->current_countdown;
		cheese_countdown_start (_tmp3_, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}

/**
   * Take a photo during burst mode, and increment the burst count.
   *
   * @return true if there are more photos to be taken in the current burst,
   * false otherwise
   */
static gboolean
cheese_main_window_burst_take_photo (CheeseMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->is_bursting) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->settings;
		_tmp0_ = self->priv->burst_count < g_settings_get_int (_tmp1_, "burst-repeat");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp2_;
		cheese_main_window_take_photo (self);
		_tmp2_ = self->priv->burst_count;
		self->priv->burst_count = _tmp2_ + 1;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}

/**
     * Cancel the current action (if any)
     */
static gboolean
cheese_main_window_cancel_running_action (CheeseMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	CheeseCountdown* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current_countdown;
	if (_tmp3_ != NULL) {
		CheeseCountdown* _tmp4_;
		_tmp4_ = self->priv->current_countdown;
		_tmp2_ = _tmp4_->running;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->is_bursting;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->is_recording;
	}
	if (_tmp0_) {
		self->priv->action_cancelled = TRUE;
		switch (self->priv->current_mode) {
			case CHEESE_MEDIA_MODE_PHOTO:
			{
				CheeseCountdown* _tmp5_;
				_tmp5_ = self->priv->current_countdown;
				cheese_countdown_stop (_tmp5_);
				cheese_main_window_finish_countdown_callback (self);
				break;
			}
			case CHEESE_MEDIA_MODE_BURST:
			{
				cheese_main_window_toggle_photo_bursting (self, FALSE);
				break;
			}
			case CHEESE_MEDIA_MODE_VIDEO:
			{
				cheese_main_window_toggle_video_recording (self, FALSE);
				break;
			}
			default:
			break;
		}
		self->priv->action_cancelled = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
   * Cancel the current activity if the escape key is pressed.
   *
   * @param event the key event, to check which key was pressed
   * @return false, to allow further processing of the event
   */
static gboolean
cheese_main_window_on_key_release (CheeseMainWindow* self,
                                   GdkEventKey* event)
{
	gchar* key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GCompareFunc _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (key);
	key = _tmp1_;
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = key;
	if (_tmp2_ (_tmp3_, "Escape") == 0) {
		if (cheese_main_window_cancel_running_action (self)) {
			result = FALSE;
			_g_free0 (key);
			return result;
		} else {
			if (self->priv->is_effects_selector_active) {
				GtkToggleButton* _tmp4_;
				_tmp4_ = self->priv->effects_toggle_button;
				gtk_toggle_button_set_active (_tmp4_, FALSE);
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}

/**
   * Toggle whether video recording is active.
   *
   * @param is_start whether to start video recording
   */
static gboolean
_cheese_main_window_update_timeout_layer_gsource_func (gpointer self)
{
	gboolean result;
	result = cheese_main_window_update_timeout_layer ((CheeseMainWindow*) self);
	return result;
}

void
cheese_main_window_toggle_video_recording (CheeseMainWindow* self,
                                           gboolean is_start)
{
	g_return_if_fail (self != NULL);
	if (is_start) {
		CheeseCamera* _tmp0_;
		CheeseFileUtil* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GtkButton* _tmp4_;
		GtkImage* _tmp5_;
		_tmp0_ = self->priv->camera;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = cheese_fileutil_get_new_media_filename (_tmp1_, self->priv->current_mode);
		_tmp3_ = _tmp2_;
		cheese_camera_start_video_recording (_tmp0_, _tmp3_);
		_g_free0 (_tmp3_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _cheese_main_window_update_timeout_layer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp4_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _ ("Stop recording"));
		_tmp5_ = self->priv->take_action_button_image;
		gtk_image_set_from_icon_name (_tmp5_, "media-playback-stop-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		CheeseCamera* _tmp6_;
		ClutterText* _tmp7_;
		GtkButton* _tmp8_;
		GtkImage* _tmp9_;
		_tmp6_ = self->priv->camera;
		cheese_camera_stop_video_recording (_tmp6_);
		_tmp7_ = self->priv->timeout_layer;
		clutter_text_set_text (_tmp7_, "00:00:00");
		_tmp8_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _ ("Record a video"));
		_tmp9_ = self->priv->take_action_button_image;
		gtk_image_set_from_icon_name (_tmp9_, "camera-web-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}

/**
   * Update the timeout layer displayed timer.
   *
   * @return false, if the source, Timeout.add_seconds (used
   * in the toogle_video_recording method), should be removed.
   */
static gboolean
cheese_main_window_update_timeout_layer (CheeseMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->is_recording) {
		ClutterText* _tmp0_;
		CheeseCamera* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = self->priv->timeout_layer;
		_tmp1_ = self->priv->camera;
		_tmp2_ = cheese_camera_get_recorded_time (_tmp1_);
		_tmp3_ = _tmp2_;
		clutter_text_set_text (_tmp0_, _tmp3_);
		_g_free0 (_tmp3_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

/**
   * Toggle whether photo bursting is active.
   *
   * @param is_start whether to start capturing a photo burst
   */
static gboolean
_cheese_main_window_burst_take_photo_gsource_func (gpointer self)
{
	gboolean result;
	result = cheese_main_window_burst_take_photo ((CheeseMainWindow*) self);
	return result;
}

void
cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self,
                                          gboolean is_start)
{
	g_return_if_fail (self != NULL);
	if (is_start) {
		GtkButton* _tmp0_;
		gint burst_delay = 0;
		GSettings* _tmp1_;
		gint countdown_duration = 0;
		GSettings* _tmp2_;
		gboolean _tmp3_ = FALSE;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		_tmp0_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _ ("Stop taking pictures"));
		cheese_main_window_burst_take_photo (self);
		_tmp1_ = self->priv->settings;
		burst_delay = g_settings_get_int (_tmp1_, "burst-delay");
		_tmp2_ = self->priv->settings;
		countdown_duration = 500 + (g_settings_get_int (_tmp2_, "countdown-duration") * 1000);
		if ((burst_delay - countdown_duration) < 1000) {
			GSettings* _tmp4_;
			_tmp4_ = self->priv->settings;
			_tmp3_ = g_settings_get_boolean (_tmp4_, "countdown");
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			self->priv->burst_callback_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) countdown_duration, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
		} else {
			self->priv->burst_callback_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) burst_delay, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
		}
	} else {
		gboolean _tmp5_ = FALSE;
		CheeseCountdown* _tmp6_;
		GtkButton* _tmp9_;
		CheeseFileUtil* _tmp10_;
		_tmp6_ = self->priv->current_countdown;
		if (_tmp6_ != NULL) {
			CheeseCountdown* _tmp7_;
			_tmp7_ = self->priv->current_countdown;
			_tmp5_ = _tmp7_->running;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			CheeseCountdown* _tmp8_;
			_tmp8_ = self->priv->current_countdown;
			cheese_countdown_stop (_tmp8_);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp9_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp9_, _ ("Take multiple photos"));
		self->priv->burst_count = 0;
		_tmp10_ = self->priv->fileutil;
		cheese_fileutil_reset_burst (_tmp10_);
		g_source_remove (self->priv->burst_callback_id);
	}
}

/**
     * Take a photo or burst of photos, or record a video, based on the current
     * capture mode.
     */
void
cheese_main_window_shoot (CheeseMainWindow* self)
{
	g_return_if_fail (self != NULL);
	switch (self->priv->current_mode) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			cheese_main_window_take_photo (self);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			cheese_main_window_toggle_video_recording (self, !self->priv->is_recording);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			cheese_main_window_toggle_photo_bursting (self, !self->priv->is_bursting);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

/**
     * Show an error.
     *
     * @param error the error to display, or null to hide the error layer
     */
void
cheese_main_window_show_error (CheeseMainWindow* self,
                               const gchar* _error_)
{
	g_return_if_fail (self != NULL);
	if (_error_ != NULL) {
		ClutterActor* _tmp0_;
		ClutterActor* _tmp1_;
		ClutterText* _tmp2_;
		ClutterText* _tmp3_;
		_tmp0_ = self->priv->current_effects_grid;
		clutter_actor_hide (_tmp0_);
		_tmp1_ = self->priv->video_preview;
		clutter_actor_hide (_tmp1_);
		_tmp2_ = self->priv->error_layer;
		clutter_text_set_text (_tmp2_, _error_);
		_tmp3_ = self->priv->error_layer;
		clutter_actor_show ((ClutterActor*) _tmp3_);
	} else {
		ClutterText* _tmp4_;
		_tmp4_ = self->priv->error_layer;
		clutter_actor_hide ((ClutterActor*) _tmp4_);
		if (self->priv->is_effects_selector_active) {
			ClutterActor* _tmp5_;
			_tmp5_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp5_);
		} else {
			ClutterActor* _tmp6_;
			_tmp6_ = self->priv->video_preview;
			clutter_actor_show (_tmp6_);
		}
	}
}

/**
     * Toggle the display of the effect selector.
     *
     * @param effects whether effects should be enabled
     */
void
cheese_main_window_set_effects (CheeseMainWindow* self,
                                gboolean effects)
{
	g_return_if_fail (self != NULL);
	cheese_main_window_toggle_effects_selector (self, effects);
}

/**
   * Change the selected effect, as a new one was selected.
   *
   * @param tap unused
   * @param source the actor (with associated effect) that was selected
   */
void
cheese_main_window_on_selected_effect_change (CheeseMainWindow* self,
                                              ClutterTapAction* tap,
                                              ClutterActor* source)
{
	GtkToggleButton* _tmp0_;
	gconstpointer _tmp1_;
	CheeseEffect* _tmp2_;
	CheeseCamera* _tmp3_;
	CheeseEffect* _tmp4_;
	GSettings* _tmp5_;
	CheeseEffect* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tap != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->effects_toggle_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
	_tmp1_ = g_object_get_data ((GObject*) source, "effect");
	_tmp2_ = _g_object_ref0 ((CheeseEffect*) _tmp1_);
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp2_;
	_tmp3_ = self->priv->camera;
	_tmp4_ = self->priv->selected_effect;
	cheese_camera_set_effect (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->selected_effect;
	_tmp7_ = cheese_effect_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	g_settings_set_string (_tmp5_, "selected-effect", _tmp8_);
}

/**
     * Navigate back one page of effects.
     */
static void
cheese_main_window_on_effects_previous (CheeseMainWindow* self)
{
	g_return_if_fail (self != NULL);
	if (cheese_main_window_is_previous_effects_page (self)) {
		cheese_main_window_activate_effects_page (self, ((gint) self->priv->current_effects_page) - 1);
	}
}

/**
     * Navigate forward one page of effects.
     */
static void
cheese_main_window_on_effects_next (CheeseMainWindow* self)
{
	g_return_if_fail (self != NULL);
	if (cheese_main_window_is_next_effects_page (self)) {
		cheese_main_window_activate_effects_page (self, ((gint) self->priv->current_effects_page) + 1);
	}
}

/**
   * Switch to the supplied page of effects.
   *
   * @param number the effects page to switch to
   */
static void
cheese_main_window_activate_effects_page (CheeseMainWindow* self,
                                          gint number)
{
	ClutterActor* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	ClutterActor* _tmp3_;
	gboolean _tmp4_;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterActor* _tmp12_;
	ClutterActor* _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	ClutterActor* _tmp16_;
	ClutterActor* _tmp17_;
	guint i = 0U;
	CheeseEffectsManager* _tmp18_;
	GList* _tmp19_;
	g_return_if_fail (self != NULL);
	if (!self->priv->is_effects_selector_active) {
		return;
	}
	self->priv->current_effects_page = (guint) number;
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = clutter_actor_get_children (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->current_effects_grid;
	_tmp4_ = g_list_index (_tmp2_, _tmp3_) != -1;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	if (_tmp4_) {
		ClutterActor* _tmp5_;
		ClutterActor* _tmp6_;
		_tmp5_ = self->priv->viewport_layout;
		_tmp6_ = self->priv->current_effects_grid;
		clutter_actor_remove_child (_tmp5_, _tmp6_);
	}
	_tmp7_ = self->priv->effects_grids;
	_tmp8_ = g_list_nth_data (_tmp7_, (guint) number);
	_tmp9_ = _g_object_ref0 ((ClutterActor*) _tmp8_);
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = _tmp9_;
	_tmp10_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp10_, (guint) 0);
	_tmp11_ = self->priv->viewport_layout;
	_tmp12_ = self->priv->current_effects_grid;
	clutter_actor_add_child (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->current_effects_grid;
	clutter_actor_save_easing_state (_tmp13_);
	_tmp14_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_mode (_tmp14_, CLUTTER_LINEAR);
	_tmp15_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_duration (_tmp15_, (guint) 500);
	_tmp16_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp16_, (guint) 255);
	_tmp17_ = self->priv->current_effects_grid;
	clutter_actor_restore_easing_state (_tmp17_);
	i = (guint) 0;
	_tmp18_ = self->priv->effects_manager;
	_tmp19_ = _tmp18_->effects;
	{
		GList* effect_collection = NULL;
		GList* effect_it = NULL;
		effect_collection = _tmp19_;
		for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
			CheeseEffect* _tmp20_;
			CheeseEffect* effect = NULL;
			_tmp20_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
			effect = _tmp20_;
			{
				guint page_nr = 0U;
				guint _tmp31_;
				page_nr = i / EFFECTS_PER_PAGE;
				if (page_nr == ((guint) number)) {
					CheeseEffect* _tmp21_;
					CheeseEffect* _tmp28_;
					_tmp21_ = effect;
					if (!cheese_effect_is_preview_connected (_tmp21_)) {
						ClutterActor* texture = NULL;
						CheeseEffect* _tmp22_;
						gconstpointer _tmp23_;
						ClutterActor* _tmp24_;
						CheeseCamera* _tmp25_;
						CheeseEffect* _tmp26_;
						ClutterActor* _tmp27_;
						_tmp22_ = effect;
						_tmp23_ = g_object_get_data ((GObject*) _tmp22_, "texture");
						_tmp24_ = _g_object_ref0 ((ClutterActor*) _tmp23_);
						texture = _tmp24_;
						_tmp25_ = self->priv->camera;
						_tmp26_ = effect;
						_tmp27_ = texture;
						cheese_camera_connect_effect_texture (_tmp25_, _tmp26_, _tmp27_);
						_g_object_unref0 (texture);
					}
					_tmp28_ = effect;
					cheese_effect_enable_preview (_tmp28_);
				} else {
					CheeseEffect* _tmp29_;
					_tmp29_ = effect;
					if (cheese_effect_is_preview_connected (_tmp29_)) {
						CheeseEffect* _tmp30_;
						_tmp30_ = effect;
						cheese_effect_disable_preview (_tmp30_);
					}
				}
				_tmp31_ = i;
				i = _tmp31_ + 1;
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}

/**
     * Control the sensitivity of the effects page navigation buttons.
     */
static void
cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self)
{
	GSimpleAction* effects_next = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* effects_previous = NULL;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GSimpleAction* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GSimpleAction* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "effects-next");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	effects_next = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "effects-previous");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	effects_previous = _tmp3_;
	if (self->priv->is_effects_selector_active) {
		_tmp4_ = cheese_main_window_is_next_effects_page (self);
	} else {
		_tmp4_ = FALSE;
	}
	_tmp5_ = effects_next;
	g_simple_action_set_enabled (_tmp5_, _tmp4_);
	if (self->priv->is_effects_selector_active) {
		_tmp6_ = cheese_main_window_is_previous_effects_page (self);
	} else {
		_tmp6_ = FALSE;
	}
	_tmp7_ = effects_previous;
	g_simple_action_set_enabled (_tmp7_, _tmp6_);
	_g_object_unref0 (effects_previous);
	_g_object_unref0 (effects_next);
}

static gboolean
cheese_main_window_is_next_effects_page (CheeseMainWindow* self)
{
	CheeseEffectsManager* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->effects_manager;
	_tmp1_ = _tmp0_->effects;
	result = ((self->priv->current_effects_page + 1) * EFFECTS_PER_PAGE) < g_list_length (_tmp1_);
	return result;
}

static gboolean
cheese_main_window_is_previous_effects_page (CheeseMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->current_effects_page != ((guint) 0);
	return result;
}

/**
     * Toggle the visibility of the effects selector.
     *
     * @param active whether the selector should be active
     */
static void
cheese_main_window_toggle_effects_selector (CheeseMainWindow* self,
                                            gboolean active)
{
	GList* _tmp0_;
	CheeseCamera* _tmp6_;
	g_return_if_fail (self != NULL);
	self->priv->is_effects_selector_active = active;
	_tmp0_ = self->priv->effects_grids;
	if (g_list_length (_tmp0_) == ((guint) 0)) {
		const gchar* _tmp1_ = NULL;
		if (active) {
			_tmp1_ = _ ("No effects found");
		} else {
			_tmp1_ = NULL;
		}
		cheese_main_window_show_error (self, _tmp1_);
	} else {
		if (active) {
			ClutterActor* _tmp2_;
			ClutterActor* _tmp3_;
			_tmp2_ = self->priv->video_preview;
			clutter_actor_hide (_tmp2_);
			_tmp3_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp3_);
			cheese_main_window_activate_effects_page (self, (gint) self->priv->current_effects_page);
		} else {
			ClutterActor* _tmp4_;
			ClutterActor* _tmp5_;
			_tmp4_ = self->priv->current_effects_grid;
			clutter_actor_hide (_tmp4_);
			_tmp5_ = self->priv->video_preview;
			clutter_actor_show (_tmp5_);
		}
	}
	_tmp6_ = self->priv->camera;
	cheese_camera_toggle_effects_pipeline (_tmp6_, active);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
	cheese_main_window_update_header_bar_title (self);
}

/**
   * Create the effects selector.
   */
static void
_cheese_main_window_on_selected_effect_change_clutter_tap_action_tap (ClutterTapAction* _sender,
                                                                      ClutterActor* actor,
                                                                      gpointer self)
{
	cheese_main_window_on_selected_effect_change ((CheeseMainWindow*) self, _sender, actor);
}

static void
cheese_main_window_setup_effects_selector (CheeseMainWindow* self)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_grid;
	if (_tmp0_ == NULL) {
		CheeseEffectsManager* _tmp1_;
		CheeseEffectsManager* _tmp2_;
		CheeseEffectsManager* _tmp3_;
		GList* _tmp4_;
		CheeseEffectsManager* _tmp5_;
		GList* _tmp6_;
		guint i = 0U;
		CheeseEffectsManager* _tmp16_;
		GList* _tmp17_;
		GList* _tmp75_;
		gconstpointer _tmp76_;
		ClutterActor* _tmp77_;
		_tmp1_ = cheese_effects_manager_new ();
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		_tmp2_ = self->priv->effects_manager;
		cheese_effects_manager_load_effects (_tmp2_);
		(self->priv->effects_grids == NULL) ? NULL : (self->priv->effects_grids = (_g_list_free__g_object_unref0_ (self->priv->effects_grids), NULL));
		self->priv->effects_grids = NULL;
		_tmp3_ = self->priv->effects_manager;
		_tmp4_ = _tmp3_->effects;
		if (g_list_length (_tmp4_) == ((guint) 0)) {
			g_warning ("cheese-window.vala:1114: gnome-video-effects is not installed.");
			return;
		}
		_tmp5_ = self->priv->effects_manager;
		_tmp6_ = _tmp5_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp6_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp7_;
				CheeseEffect* effect = NULL;
				_tmp7_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp7_;
				{
					ClutterGridLayout* grid_layout = NULL;
					ClutterGridLayout* _tmp8_;
					ClutterActor* grid = NULL;
					ClutterActor* _tmp9_;
					ClutterActor* _tmp10_;
					ClutterGridLayout* _tmp11_;
					ClutterActor* _tmp12_;
					ClutterActor* _tmp13_;
					ClutterGridLayout* _tmp14_;
					ClutterGridLayout* _tmp15_;
					_tmp8_ = (ClutterGridLayout*) clutter_grid_layout_new ();
					g_object_ref_sink (_tmp8_);
					grid_layout = _tmp8_;
					_tmp9_ = clutter_actor_new ();
					g_object_ref_sink (_tmp9_);
					grid = _tmp9_;
					_tmp10_ = grid;
					_tmp11_ = grid_layout;
					clutter_actor_set_layout_manager (_tmp10_, (ClutterLayoutManager*) _tmp11_);
					_tmp12_ = grid;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					self->priv->effects_grids = g_list_append (self->priv->effects_grids, _tmp13_);
					_tmp14_ = grid_layout;
					clutter_grid_layout_set_column_spacing (_tmp14_, (guint) 10);
					_tmp15_ = grid_layout;
					clutter_grid_layout_set_row_spacing (_tmp15_, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (grid_layout);
					_g_object_unref0 (effect);
				}
			}
		}
		i = (guint) 0;
		_tmp16_ = self->priv->effects_manager;
		_tmp17_ = _tmp16_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp17_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp18_;
				CheeseEffect* effect = NULL;
				_tmp18_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp18_;
				{
					ClutterActor* texture = NULL;
					ClutterActor* _tmp19_;
					ClutterBinLayout* layout = NULL;
					ClutterBinLayout* _tmp20_;
					ClutterActor* box = NULL;
					ClutterActor* _tmp21_;
					ClutterActor* _tmp22_;
					ClutterBinLayout* _tmp23_;
					ClutterText* text = NULL;
					ClutterText* _tmp24_;
					ClutterActor* rect = NULL;
					ClutterActor* _tmp25_;
					ClutterActor* _tmp26_;
					ClutterActor* _tmp27_;
					ClutterColor _tmp28_ = {0};
					ClutterActor* _tmp29_;
					ClutterActor* _tmp30_;
					ClutterActor* _tmp31_;
					ClutterActor* _tmp32_;
					ClutterActor* _tmp33_;
					ClutterActor* _tmp34_;
					ClutterTapAction* tap = NULL;
					ClutterTapAction* _tmp35_;
					ClutterActor* _tmp36_;
					ClutterTapAction* _tmp37_;
					ClutterTapAction* _tmp38_;
					ClutterActor* _tmp39_;
					CheeseEffect* _tmp40_;
					CheeseEffect* _tmp41_;
					CheeseEffect* _tmp42_;
					ClutterActor* _tmp43_;
					ClutterActor* _tmp44_;
					ClutterText* _tmp45_;
					CheeseEffect* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					ClutterText* _tmp49_;
					ClutterColor _tmp50_ = {0};
					ClutterActor* _tmp51_;
					ClutterText* _tmp52_;
					gfloat _tmp53_;
					gfloat _tmp54_;
					ClutterActor* _tmp55_;
					ClutterActor* _tmp56_;
					ClutterActor* _tmp57_;
					ClutterActor* _tmp58_;
					ClutterActor* _tmp59_;
					ClutterActor* _tmp60_;
					ClutterText* _tmp61_;
					ClutterText* _tmp62_;
					ClutterText* _tmp63_;
					ClutterText* _tmp64_;
					ClutterActor* _tmp65_;
					ClutterText* _tmp66_;
					ClutterGridLayout* grid_layout = NULL;
					GList* _tmp67_;
					gconstpointer _tmp68_;
					ClutterLayoutManager* _tmp69_;
					ClutterLayoutManager* _tmp70_;
					ClutterGridLayout* _tmp71_;
					ClutterGridLayout* _tmp72_;
					ClutterActor* _tmp73_;
					guint _tmp74_;
					_tmp19_ = clutter_actor_new ();
					g_object_ref_sink (_tmp19_);
					texture = _tmp19_;
					_tmp20_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
					g_object_ref_sink (_tmp20_);
					layout = _tmp20_;
					_tmp21_ = clutter_actor_new ();
					g_object_ref_sink (_tmp21_);
					box = _tmp21_;
					_tmp22_ = box;
					_tmp23_ = layout;
					clutter_actor_set_layout_manager (_tmp22_, (ClutterLayoutManager*) _tmp23_);
					_tmp24_ = (ClutterText*) clutter_text_new ();
					g_object_ref_sink (_tmp24_);
					text = _tmp24_;
					_tmp25_ = clutter_actor_new ();
					g_object_ref_sink (_tmp25_);
					rect = _tmp25_;
					_tmp26_ = rect;
					clutter_actor_set_opacity (_tmp26_, (guint) 128);
					_tmp27_ = rect;
					clutter_color_from_string (&_tmp28_, "black");
					clutter_actor_set_background_color (_tmp27_, &_tmp28_);
					_tmp29_ = texture;
					clutter_actor_set_content_gravity (_tmp29_, CLUTTER_CONTENT_GRAVITY_RESIZE_ASPECT);
					_tmp30_ = box;
					_tmp31_ = texture;
					clutter_actor_add_child (_tmp30_, _tmp31_);
					_tmp32_ = box;
					clutter_actor_set_reactive (_tmp32_, TRUE);
					_tmp33_ = box;
					g_object_set (_tmp33_, "min-height", (gfloat) 40, NULL);
					_tmp34_ = box;
					g_object_set (_tmp34_, "min-width", (gfloat) 50, NULL);
					_tmp35_ = (ClutterTapAction*) clutter_tap_action_new ();
					g_object_ref_sink (_tmp35_);
					tap = _tmp35_;
					_tmp36_ = box;
					_tmp37_ = tap;
					clutter_actor_add_action (_tmp36_, (ClutterAction*) _tmp37_);
					_tmp38_ = tap;
					g_signal_connect_object (_tmp38_, "tap", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap, self, 0);
					_tmp39_ = box;
					_tmp40_ = effect;
					_tmp41_ = _g_object_ref0 (_tmp40_);
					g_object_set_data_full ((GObject*) _tmp39_, "effect", _tmp41_, g_object_unref);
					_tmp42_ = effect;
					_tmp43_ = texture;
					_tmp44_ = _g_object_ref0 (_tmp43_);
					g_object_set_data_full ((GObject*) _tmp42_, "texture", _tmp44_, g_object_unref);
					_tmp45_ = text;
					_tmp46_ = effect;
					_tmp47_ = cheese_effect_get_name (_tmp46_);
					_tmp48_ = _tmp47_;
					clutter_text_set_text (_tmp45_, _tmp48_);
					_tmp49_ = text;
					clutter_color_from_string (&_tmp50_, "white");
					clutter_text_set_color (_tmp49_, &_tmp50_);
					_tmp51_ = rect;
					_tmp52_ = text;
					_tmp53_ = clutter_actor_get_height ((ClutterActor*) _tmp52_);
					_tmp54_ = _tmp53_;
					clutter_actor_set_height (_tmp51_, _tmp54_ + 5);
					_tmp55_ = rect;
					clutter_actor_set_x_align (_tmp55_, CLUTTER_ACTOR_ALIGN_FILL);
					_tmp56_ = rect;
					clutter_actor_set_y_align (_tmp56_, CLUTTER_ACTOR_ALIGN_END);
					_tmp57_ = rect;
					clutter_actor_set_x_expand (_tmp57_, TRUE);
					_tmp58_ = rect;
					clutter_actor_set_y_expand (_tmp58_, TRUE);
					_tmp59_ = box;
					_tmp60_ = rect;
					clutter_actor_add_child (_tmp59_, _tmp60_);
					_tmp61_ = text;
					clutter_actor_set_x_align ((ClutterActor*) _tmp61_, CLUTTER_ACTOR_ALIGN_CENTER);
					_tmp62_ = text;
					clutter_actor_set_y_align ((ClutterActor*) _tmp62_, CLUTTER_ACTOR_ALIGN_END);
					_tmp63_ = text;
					clutter_actor_set_x_expand ((ClutterActor*) _tmp63_, TRUE);
					_tmp64_ = text;
					clutter_actor_set_y_expand ((ClutterActor*) _tmp64_, TRUE);
					_tmp65_ = box;
					_tmp66_ = text;
					clutter_actor_add_child (_tmp65_, (ClutterActor*) _tmp66_);
					_tmp67_ = self->priv->effects_grids;
					_tmp68_ = g_list_nth_data (_tmp67_, i / EFFECTS_PER_PAGE);
					_tmp69_ = clutter_actor_get_layout_manager ((ClutterActor*) _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, clutter_grid_layout_get_type ()) ? ((ClutterGridLayout*) _tmp70_) : NULL);
					grid_layout = _tmp71_;
					_tmp72_ = grid_layout;
					_tmp73_ = box;
					clutter_grid_layout_attach (_tmp72_, _tmp73_, ((gint) (i % EFFECTS_PER_PAGE)) % 3, ((gint) (i % EFFECTS_PER_PAGE)) / 3, 1, 1);
					_tmp74_ = i;
					i = _tmp74_ + 1;
					_g_object_unref0 (grid_layout);
					_g_object_unref0 (tap);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp75_ = self->priv->effects_grids;
		_tmp76_ = g_list_nth_data (_tmp75_, (guint) 0);
		_tmp77_ = _g_object_ref0 ((ClutterActor*) _tmp76_);
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = _tmp77_;
	}
}

/**
     * Update the UI when the camera starts playing.
     */
void
cheese_main_window_camera_state_change_playing (CheeseMainWindow* self)
{
	CheeseEffect* effect = NULL;
	CheeseEffectsManager* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	CheeseEffect* _tmp4_;
	CheeseEffect* _tmp5_;
	CheeseEffect* _tmp6_;
	g_return_if_fail (self != NULL);
	cheese_main_window_show_error (self, NULL);
	_tmp0_ = self->priv->effects_manager;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "selected-effect");
	_tmp3_ = _tmp2_;
	_tmp4_ = cheese_effects_manager_get_effect (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	effect = _tmp5_;
	_tmp6_ = effect;
	if (_tmp6_ != NULL) {
		CheeseCamera* _tmp7_;
		CheeseEffect* _tmp8_;
		_tmp7_ = self->priv->camera;
		_tmp8_ = effect;
		cheese_camera_set_effect (_tmp7_, _tmp8_);
	}
	_g_object_unref0 (effect);
}

/**
     * Report an error as the camerabin switched to the NULL state.
     */
void
cheese_main_window_camera_state_change_null (CheeseMainWindow* self)
{
	ClutterText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	cheese_main_window_cancel_running_action (self);
	_tmp0_ = self->priv->error_layer;
	g_object_get ((ClutterActor*) _tmp0_, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		cheese_main_window_show_error (self, _ ("There was an error playing video from the webcam"));
	}
}

/**
   * Select next camera in list and activate it.
   */
static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

void
cheese_main_window_on_switch_camera_clicked (CheeseMainWindow* self)
{
	CheeseCameraDevice* selected = NULL;
	CheeseCameraDevice* next = NULL;
	GPtrArray* cameras = NULL;
	guint i = 0U;
	CheeseCamera* _tmp0_;
	CheeseCamera* _tmp1_;
	CheeseCameraDevice* _tmp2_;
	CheeseCameraDevice* _tmp3_;
	CheeseCamera* _tmp4_;
	GPtrArray* _tmp5_;
	GPtrArray* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	CheeseCameraDevice* _tmp22_;
	CheeseCameraDevice* _tmp23_;
	CheeseCamera* _tmp24_;
	CheeseCameraDevice* _tmp25_;
	CheeseCamera* _tmp26_;
	g_return_if_fail (self != NULL);
	next = NULL;
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		_g_ptr_array_unref0 (cameras);
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_selected_device (_tmp1_);
	selected = _tmp2_;
	_tmp3_ = selected;
	if (_tmp3_ == NULL) {
		_g_ptr_array_unref0 (cameras);
		return;
	}
	_tmp4_ = self->priv->camera;
	_tmp5_ = cheese_camera_get_camera_devices (_tmp4_);
	_g_ptr_array_unref0 (cameras);
	cameras = _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		i = (guint) 0;
		_tmp6_ = TRUE;
		while (TRUE) {
			GPtrArray* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GPtrArray* _tmp11_;
			gconstpointer _tmp12_;
			CheeseCameraDevice* _tmp13_;
			CheeseCameraDevice* _tmp14_;
			if (!_tmp6_) {
				guint _tmp7_;
				_tmp7_ = i;
				i = _tmp7_ + 1;
			}
			_tmp6_ = FALSE;
			_tmp8_ = cameras;
			_tmp9_ = vala_g_ptr_array_get_length (_tmp8_);
			_tmp10_ = _tmp9_;
			if (!(i < ((guint) _tmp10_))) {
				break;
			}
			_tmp11_ = cameras;
			_tmp12_ = g_ptr_array_index (_tmp11_, i);
			next = (CheeseCameraDevice*) _tmp12_;
			_tmp13_ = next;
			_tmp14_ = selected;
			if (_tmp13_ == _tmp14_) {
				break;
			}
		}
	}
	_tmp15_ = cameras;
	_tmp16_ = vala_g_ptr_array_get_length (_tmp15_);
	_tmp17_ = _tmp16_;
	if ((i + 1) < ((guint) _tmp17_)) {
		GPtrArray* _tmp18_;
		gconstpointer _tmp19_;
		_tmp18_ = cameras;
		_tmp19_ = g_ptr_array_index (_tmp18_, i + 1);
		next = (CheeseCameraDevice*) _tmp19_;
	} else {
		GPtrArray* _tmp20_;
		gconstpointer _tmp21_;
		_tmp20_ = cameras;
		_tmp21_ = g_ptr_array_index (_tmp20_, (guint) 0);
		next = (CheeseCameraDevice*) _tmp21_;
	}
	_tmp22_ = next;
	_tmp23_ = selected;
	if (_tmp22_ == _tmp23_) {
		_g_ptr_array_unref0 (cameras);
		return;
	}
	_tmp24_ = self->priv->camera;
	_tmp25_ = next;
	cheese_camera_set_device (_tmp24_, _tmp25_);
	_tmp26_ = self->priv->camera;
	cheese_camera_switch_camera_device (_tmp26_);
	_g_ptr_array_unref0 (cameras);
}

/**
   * Set switch camera buttons visible state.
   */
void
cheese_main_window_set_switch_camera_button_state (CheeseMainWindow* self)
{
	CheeseCameraDevice* selected = NULL;
	GPtrArray* cameras = NULL;
	CheeseCamera* _tmp0_;
	CheeseCamera* _tmp2_;
	CheeseCameraDevice* _tmp3_;
	CheeseCameraDevice* _tmp4_;
	CheeseCamera* _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GtkButton* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->switch_camera_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
		_g_ptr_array_unref0 (cameras);
		return;
	}
	_tmp2_ = self->priv->camera;
	_tmp3_ = cheese_camera_get_selected_device (_tmp2_);
	selected = _tmp3_;
	_tmp4_ = selected;
	if (_tmp4_ == NULL) {
		GtkButton* _tmp5_;
		_tmp5_ = self->priv->switch_camera_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
		_g_ptr_array_unref0 (cameras);
		return;
	}
	_tmp6_ = self->priv->camera;
	_tmp7_ = cheese_camera_get_camera_devices (_tmp6_);
	_g_ptr_array_unref0 (cameras);
	cameras = _tmp7_;
	_tmp8_ = cameras;
	_tmp9_ = vala_g_ptr_array_get_length (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 1) {
		GtkButton* _tmp11_;
		_tmp11_ = self->priv->switch_camera_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp11_, TRUE);
		_g_ptr_array_unref0 (cameras);
		return;
	}
	_tmp12_ = self->priv->switch_camera_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, FALSE);
	_g_ptr_array_unref0 (cameras);
}

/**
   * Load the UI from the GtkBuilder description.
   */
static void
_cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender,
                                                                      ClutterActorBox* box,
                                                                      ClutterAllocationFlags flags,
                                                                      gpointer self)
{
	cheese_main_window_on_stage_resize ((CheeseMainWindow*) self, _sender, box, flags);
}

static gboolean
_cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                    gpointer self)
{
	gboolean result;
	result = cheese_main_window_on_thumb_view_popup_menu ((CheeseMainWindow*) self);
	return result;
}

static gboolean
_cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                   GdkEventButton* event,
                                                                                   gpointer self)
{
	gboolean result;
	result = cheese_main_window_on_thumbnail_button_press_event ((CheeseMainWindow*) self, _sender, event);
	return result;
}

static void
_cheese_main_window_on_switch_camera_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	cheese_main_window_on_switch_camera_clicked ((CheeseMainWindow*) self);
}

static gboolean
_cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                 GdkEventKey* event,
                                                                 gpointer self)
{
	gboolean result;
	result = cheese_main_window_on_key_release ((CheeseMainWindow*) self, event);
	return result;
}

void
cheese_main_window_setup_ui (CheeseMainWindow* self)
{
	ClutterScript* _tmp0_;
	CheeseFileUtil* _tmp1_;
	CheeseFlash* _tmp2_;
	GSettings* _tmp3_;
	GMenu* menu = NULL;
	GtkApplication* _tmp4_;
	GtkApplication* _tmp5_;
	GMenu* _tmp6_;
	GMenu* _tmp7_;
	GtkMenu* _tmp8_;
	GtkApplication* _tmp9_;
	GtkApplication* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GtkApplication* _tmp14_;
	GtkApplication* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GtkApplication* _tmp19_;
	GtkApplication* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	GtkApplication* _tmp24_;
	GtkApplication* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	GtkApplication* _tmp29_;
	GtkApplication* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	GtkApplication* _tmp34_;
	GtkApplication* _tmp35_;
	gchar* _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	GtkClutterEmbed* _tmp41_;
	ClutterActor* _tmp42_;
	ClutterStage* _tmp43_;
	ClutterScript* _tmp44_;
	GObject* _tmp45_;
	ClutterActor* _tmp46_;
	ClutterScript* _tmp47_;
	GObject* _tmp48_;
	ClutterActor* _tmp49_;
	ClutterScript* _tmp50_;
	GObject* _tmp51_;
	ClutterBinLayout* _tmp52_;
	ClutterScript* _tmp53_;
	GObject* _tmp54_;
	ClutterText* _tmp55_;
	ClutterScript* _tmp56_;
	GObject* _tmp57_;
	ClutterActor* _tmp58_;
	ClutterScript* _tmp59_;
	GObject* _tmp60_;
	ClutterText* _tmp61_;
	ClutterScript* _tmp62_;
	GObject* _tmp63_;
	ClutterText* _tmp64_;
	ClutterActor* _tmp65_;
	ClutterStage* _tmp66_;
	ClutterActor* _tmp67_;
	ClutterActor* _tmp68_;
	ClutterBinLayout* _tmp69_;
	ClutterStage* _tmp70_;
	ClutterActor* _tmp71_;
	ClutterStage* _tmp72_;
	ClutterText* _tmp73_;
	ClutterStage* _tmp74_;
	CheeseThumbView* _tmp75_;
	CheeseThumbView* _tmp76_;
	EogThumbNav* _tmp77_;
	GtkMenu* _tmp78_;
	CheeseThumbView* _tmp79_;
	CheeseThumbView* _tmp80_;
	GtkCssProvider* css = NULL;
	GdkScreen* _tmp84_;
	GdkScreen* _tmp85_;
	CheeseThumbView* _tmp86_;
	GtkButton* _tmp87_;
	GtkClutterEmbed* _tmp88_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_script_new ();
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp0_;
	_tmp1_ = cheese_fileutil_new ();
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp1_;
	_tmp2_ = cheese_flash_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_application_get_menu_by_id (_tmp5_, "thumbview-menu");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	menu = _tmp7_;
	_tmp8_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) menu);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp8_;
	_tmp9_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup ("<Primary>q");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action (_tmp10_, "app.quit", _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup ("F11");
	_tmp17_ = g_new0 (gchar*, 1 + 1);
	_tmp17_[0] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 1;
	gtk_application_set_accels_for_action (_tmp15_, "app.fullscreen", _tmp18_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup ("<Primary>o");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_application_set_accels_for_action (_tmp20_, "win.file-open", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup ("<Primary>s");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action (_tmp25_, "win.file-saveas", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup ("Delete");
	_tmp32_ = g_new0 (gchar*, 1 + 1);
	_tmp32_[0] = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = 1;
	gtk_application_set_accels_for_action (_tmp30_, "win.file-trash", _tmp33_);
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
	_tmp34_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strdup ("<Shift>Delete");
	_tmp37_ = g_new0 (gchar*, 1 + 1);
	_tmp37_[0] = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 1;
	gtk_application_set_accels_for_action (_tmp35_, "win.file-delete", _tmp38_);
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
	g_action_map_add_action_entries ((GActionMap*) self, CHEESE_MAIN_WINDOW_actions, (gint) G_N_ELEMENTS (CHEESE_MAIN_WINDOW_actions), self);
	{
		ClutterScript* _tmp39_;
		_tmp39_ = self->priv->clutter_builder;
		clutter_script_load_from_resource (_tmp39_, "/org/gnome/Cheese/cheese-viewport.json", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp40_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = err->message;
		g_error ("cheese-window.vala:1322: Error: %s", _tmp40_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp41_ = self->priv->viewport_widget;
	_tmp42_ = gtk_clutter_embed_get_stage (_tmp41_);
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, clutter_stage_get_type ()) ? ((ClutterStage*) _tmp42_) : NULL);
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp43_;
	_tmp44_ = self->priv->clutter_builder;
	_tmp45_ = clutter_script_get_object (_tmp44_, "video_preview");
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp45_) : NULL);
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp46_;
	_tmp47_ = self->priv->clutter_builder;
	_tmp48_ = clutter_script_get_object (_tmp47_, "viewport_layout");
	_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp48_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp49_;
	_tmp50_ = self->priv->clutter_builder;
	_tmp51_ = clutter_script_get_object (_tmp50_, "viewport_layout_manager");
	_tmp52_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, clutter_bin_layout_get_type ()) ? ((ClutterBinLayout*) _tmp51_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp52_;
	_tmp53_ = self->priv->clutter_builder;
	_tmp54_ = clutter_script_get_object (_tmp53_, "countdown_layer");
	_tmp55_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, clutter_text_get_type ()) ? ((ClutterText*) _tmp54_) : NULL);
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp55_;
	_tmp56_ = self->priv->clutter_builder;
	_tmp57_ = clutter_script_get_object (_tmp56_, "background");
	_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp57_) : NULL);
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp58_;
	_tmp59_ = self->priv->clutter_builder;
	_tmp60_ = clutter_script_get_object (_tmp59_, "error_layer");
	_tmp61_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, clutter_text_get_type ()) ? ((ClutterText*) _tmp60_) : NULL);
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp61_;
	_tmp62_ = self->priv->clutter_builder;
	_tmp63_ = clutter_script_get_object (_tmp62_, "timeout_layer");
	_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, clutter_text_get_type ()) ? ((ClutterText*) _tmp63_) : NULL);
	_g_object_unref0 (self->priv->timeout_layer);
	self->priv->timeout_layer = _tmp64_;
	_tmp65_ = self->priv->video_preview;
	clutter_actor_set_request_mode (_tmp65_, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	_tmp66_ = self->priv->viewport;
	_tmp67_ = self->priv->background_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp66_, _tmp67_);
	_tmp68_ = self->priv->viewport_layout;
	_tmp69_ = self->priv->viewport_layout_manager;
	clutter_actor_set_layout_manager (_tmp68_, (ClutterLayoutManager*) _tmp69_);
	_tmp70_ = self->priv->viewport;
	_tmp71_ = self->priv->viewport_layout;
	clutter_actor_add_child ((ClutterActor*) _tmp70_, _tmp71_);
	_tmp72_ = self->priv->viewport;
	_tmp73_ = self->priv->timeout_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp72_, (ClutterActor*) _tmp73_);
	_tmp74_ = self->priv->viewport;
	g_signal_connect_object ((ClutterActor*) _tmp74_, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp75_ = cheese_thumb_view_new ();
	g_object_ref_sink (_tmp75_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp75_;
	_tmp76_ = self->priv->thumb_view;
	_tmp77_ = eog_thumb_nav_new ((GtkWidget*) _tmp76_, FALSE);
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp77_;
	_tmp78_ = self->priv->thumbnail_popup;
	_tmp79_ = self->priv->thumb_view;
	gtk_menu_attach_to_widget (_tmp78_, (GtkWidget*) _tmp79_, NULL);
	_tmp80_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp80_, "popup-menu", (GCallback) _cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu, self, 0);
	{
		GFile* file = NULL;
		GFile* _tmp81_;
		GtkCssProvider* _tmp82_;
		_tmp81_ = g_file_new_for_uri ("resource:///org/gnome/Cheese/cheese.css");
		file = _tmp81_;
		_tmp82_ = gtk_css_provider_new ();
		_g_object_unref0 (css);
		css = _tmp82_;
		gtk_css_provider_load_from_file (css, file, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch1_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp83_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp83_ = e->message;
		g_error ("cheese-window.vala:1359: Error parsing CSS: %s\n", _tmp83_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (css);
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp84_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp85_ = _tmp84_;
	gtk_style_context_add_provider_for_screen (_tmp85_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp86_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp86_, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp87_ = self->priv->switch_camera_button;
	g_signal_connect_object (_tmp87_, "clicked", (GCallback) _cheese_main_window_on_switch_camera_clicked_gtk_button_clicked, self, 0);
	_tmp88_ = self->priv->viewport_widget;
	gtk_widget_realize ((GtkWidget*) _tmp88_);
	cheese_main_window_set_wide_mode (self, FALSE);
	cheese_main_window_setup_effects_selector (self);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (css);
	_g_object_unref0 (menu);
}

ClutterActor*
cheese_main_window_get_video_preview (CheeseMainWindow* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->video_preview;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
   * Setup the thumbview thumbnail monitors.
   */
void
cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self)
{
	CheeseThumbView* _tmp0_;
	CheeseFileUtil* _tmp1_;
	const gchar* _tmp2_;
	CheeseThumbView* _tmp3_;
	CheeseFileUtil* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = self->priv->fileutil;
	_tmp2_ = cheese_fileutil_get_video_path (_tmp1_);
	cheese_thumb_view_start_monitoring_video_path (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = self->priv->fileutil;
	_tmp5_ = cheese_fileutil_get_photo_path (_tmp4_);
	cheese_thumb_view_start_monitoring_photo_path (_tmp3_, _tmp5_);
}

/**
     * Set the current media mode (photo, video or burst).
     *
     * @param mode the media mode to set
     */
void
cheese_main_window_set_current_mode (CheeseMainWindow* self,
                                     CheeseMediaMode mode)
{
	ClutterText* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->current_mode = mode;
	cheese_main_window_set_resolution (self, self->priv->current_mode);
	cheese_main_window_update_header_bar_title (self);
	_tmp0_ = self->priv->timeout_layer;
	clutter_actor_hide ((ClutterActor*) _tmp0_);
	switch (self->priv->current_mode) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			GtkButton* _tmp1_;
			_tmp1_ = self->priv->take_action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _ ("Take a photo using a webcam"));
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GtkButton* _tmp2_;
			ClutterText* _tmp3_;
			ClutterText* _tmp4_;
			_tmp2_ = self->priv->take_action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Record a video using a webcam"));
			_tmp3_ = self->priv->timeout_layer;
			clutter_text_set_text (_tmp3_, "00:00:00");
			_tmp4_ = self->priv->timeout_layer;
			clutter_actor_show ((ClutterActor*) _tmp4_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			GtkButton* _tmp5_;
			_tmp5_ = self->priv->take_action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _ ("Take multiple photos using a webcam"));
			break;
		}
		default:
		break;
	}
}

/**
     * Set the header bar title.
     */
static void
cheese_main_window_update_header_bar_title (CheeseMainWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->is_effects_selector_active) {
		cheese_main_window_set_window_title (self, _ ("Choose an Effect"));
	} else {
		switch (self->priv->current_mode) {
			case CHEESE_MEDIA_MODE_PHOTO:
			{
				cheese_main_window_set_window_title (self, _ ("Take a Photo"));
				break;
			}
			case CHEESE_MEDIA_MODE_VIDEO:
			{
				cheese_main_window_set_window_title (self, _ ("Record a Video"));
				break;
			}
			case CHEESE_MEDIA_MODE_BURST:
			{
				cheese_main_window_set_window_title (self, _ ("Take Multiple Photos"));
				break;
			}
			default:
			break;
		}
	}
}

/**
     * Set the camera.
     *
     * @param camera the camera to set
     */
void
cheese_main_window_set_camera (CheeseMainWindow* self,
                               CheeseCamera* camera)
{
	CheeseCamera* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = _g_object_ref0 (camera);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp0_;
	cheese_main_window_set_switch_camera_button_state (self);
}

static void
cheese_main_window_class_init (CheeseMainWindowClass * klass,
                               gpointer klass_data)
{
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheeseMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Cheese/cheese-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "viewport_widget", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, viewport_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_vbox", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, main_vbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thumbnails_right", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, thumbnails_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thumbnails_bottom", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, thumbnails_bottom));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "leave_fullscreen_button_box", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, leave_fullscreen_button_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "take_action_button", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, take_action_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "take_action_button_image", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, take_action_button_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "effects_toggle_button", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, effects_toggle_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "buttons_area", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, buttons_area));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_camera_button", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, switch_camera_button));
}

static void
cheese_main_window_instance_init (CheeseMainWindow * self,
                                  gpointer klass)
{
	GtkBuilder* _tmp0_;
	self->priv = cheese_main_window_get_instance_private (self);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Cheese/headerbar.ui");
	self->priv->header_bar_ui = _tmp0_;
	self->priv->current_effects_page = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
cheese_main_window_finalize (GObject * obj)
{
	CheeseMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->header_bar_ui);
	_g_object_unref0 (self->priv->header_bar);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->timeout_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	(self->priv->effects_grids == NULL) ? NULL : (self->priv->effects_grids = (_g_list_free__g_object_unref0_ (self->priv->effects_grids), NULL));
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->selected_effect);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}

static GType
cheese_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
	GType cheese_main_window_type_id;
	cheese_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "CheeseMainWindow", &g_define_type_info, 0);
	CheeseMainWindow_private_offset = g_type_add_instance_private (cheese_main_window_type_id, sizeof (CheeseMainWindowPrivate));
	return cheese_main_window_type_id;
}

GType
cheese_main_window_get_type (void)
{
	static volatile gsize cheese_main_window_type_id__once = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__once)) {
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = cheese_main_window_get_type_once ();
		g_once_init_leave (&cheese_main_window_type_id__once, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

