/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 130 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qcborstream.sip"
#include <qcborstream.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQCborStreamReader.cpp"

#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQCborStreamReader.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qiodevice.sip"
#include <qiodevice.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQCborStreamReader.cpp"
#line 45 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qcborcommon.sip"
#include <qcborcommon.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQCborStreamReader.cpp"


PyDoc_STRVAR(doc_QCborStreamReader_setDevice, "setDevice(self, QIODevice)");

extern "C" {static PyObject *meth_QCborStreamReader_setDevice(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_setDevice(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QIODevice* a0;
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QCborStreamReader, &sipCpp, sipType_QIODevice, &a0))
        {
            sipCpp->setDevice(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_setDevice, doc_QCborStreamReader_setDevice);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_device, "device(self) -> QIODevice");

extern "C" {static PyObject *meth_QCborStreamReader_device(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_device(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::QIODevice*sipRes;

            sipRes = sipCpp->device();

            return sipConvertFromType(sipRes,sipType_QIODevice,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_device, doc_QCborStreamReader_device);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_addData, "addData(self, Union[QByteArray, bytes, bytearray])");

extern "C" {static PyObject *meth_QCborStreamReader_addData(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_addData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray* a0;
        int a0State = 0;
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QCborStreamReader, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            sipCpp->addData(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_addData, doc_QCborStreamReader_addData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_reparse, "reparse(self)");

extern "C" {static PyObject *meth_QCborStreamReader_reparse(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_reparse(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            sipCpp->reparse();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_reparse, doc_QCborStreamReader_reparse);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_clear, "clear(self)");

extern "C" {static PyObject *meth_QCborStreamReader_clear(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            sipCpp->clear();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_clear, doc_QCborStreamReader_clear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_reset, "reset(self)");

extern "C" {static PyObject *meth_QCborStreamReader_reset(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            sipCpp->reset();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_reset, doc_QCborStreamReader_reset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_lastError, "lastError(self) -> QCborError");

extern "C" {static PyObject *meth_QCborStreamReader_lastError(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_lastError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::QCborError*sipRes;

            sipRes = new  ::QCborError(sipCpp->lastError());

            return sipConvertFromNewType(sipRes,sipType_QCborError,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_lastError, doc_QCborStreamReader_lastError);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_currentOffset, "currentOffset(self) -> int");

extern "C" {static PyObject *meth_QCborStreamReader_currentOffset(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_currentOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->currentOffset();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_currentOffset, doc_QCborStreamReader_currentOffset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isValid(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isValid, doc_QCborStreamReader_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_containerDepth, "containerDepth(self) -> int");

extern "C" {static PyObject *meth_QCborStreamReader_containerDepth(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_containerDepth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->containerDepth();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_containerDepth, doc_QCborStreamReader_containerDepth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_parentContainerType, "parentContainerType(self) -> QCborStreamReader.Type");

extern "C" {static PyObject *meth_QCborStreamReader_parentContainerType(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_parentContainerType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::QCborStreamReader::Type sipRes;

            sipRes = sipCpp->parentContainerType();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QCborStreamReader_Type);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_parentContainerType, doc_QCborStreamReader_parentContainerType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_hasNext, "hasNext(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_hasNext(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_hasNext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->hasNext();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_hasNext, doc_QCborStreamReader_hasNext);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_next, "next(self, maxRecursion: int = 10000) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_next(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_next(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0 = 10000;
         ::QCborStreamReader *sipCpp;

        static const char *sipKwdList[] = {
            sipName_maxRecursion,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QCborStreamReader, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->next(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_next, doc_QCborStreamReader_next);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_type, "type(self) -> QCborStreamReader.Type");

extern "C" {static PyObject *meth_QCborStreamReader_type(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::QCborStreamReader::Type sipRes;

            sipRes = sipCpp->type();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QCborStreamReader_Type);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_type, doc_QCborStreamReader_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isUnsignedInteger, "isUnsignedInteger(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isUnsignedInteger(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isUnsignedInteger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isUnsignedInteger();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isUnsignedInteger, doc_QCborStreamReader_isUnsignedInteger);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isNegativeInteger, "isNegativeInteger(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isNegativeInteger(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isNegativeInteger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNegativeInteger();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isNegativeInteger, doc_QCborStreamReader_isNegativeInteger);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isInteger, "isInteger(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isInteger(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isInteger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isInteger();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isInteger, doc_QCborStreamReader_isInteger);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isByteArray, "isByteArray(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isByteArray(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isByteArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isByteArray();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isByteArray, doc_QCborStreamReader_isByteArray);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isString, "isString(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isString(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isString();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isString, doc_QCborStreamReader_isString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isArray, "isArray(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isArray(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isArray();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isArray, doc_QCborStreamReader_isArray);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isMap, "isMap(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isMap(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isMap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isMap();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isMap, doc_QCborStreamReader_isMap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isTag, "isTag(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isTag(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isTag(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isTag();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isTag, doc_QCborStreamReader_isTag);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isSimpleType, "isSimpleType(self) -> bool\n"
"isSimpleType(self, QCborSimpleType) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isSimpleType(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isSimpleType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isSimpleType();

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::QCborSimpleType a0;
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QCborStreamReader, &sipCpp, sipType_QCborSimpleType, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->isSimpleType(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isSimpleType, doc_QCborStreamReader_isSimpleType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isFloat16, "isFloat16(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isFloat16(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isFloat16(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isFloat16();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isFloat16, doc_QCborStreamReader_isFloat16);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isFloat, "isFloat(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isFloat(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isFloat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isFloat();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isFloat, doc_QCborStreamReader_isFloat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isDouble, "isDouble(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isDouble(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isDouble(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isDouble();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isDouble, doc_QCborStreamReader_isDouble);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isInvalid, "isInvalid(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isInvalid(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isInvalid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isInvalid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isInvalid, doc_QCborStreamReader_isInvalid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isFalse, "isFalse(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isFalse(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isFalse(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isFalse();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isFalse, doc_QCborStreamReader_isFalse);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isTrue, "isTrue(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isTrue(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isTrue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isTrue();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isTrue, doc_QCborStreamReader_isTrue);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isBool, "isBool(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isBool(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isBool(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isBool();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isBool, doc_QCborStreamReader_isBool);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isNull(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isNull, doc_QCborStreamReader_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isUndefined, "isUndefined(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isUndefined(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isUndefined(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isUndefined();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isUndefined, doc_QCborStreamReader_isUndefined);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isLengthKnown, "isLengthKnown(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isLengthKnown(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isLengthKnown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isLengthKnown();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isLengthKnown, doc_QCborStreamReader_isLengthKnown);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_length, "length(self) -> int");

extern "C" {static PyObject *meth_QCborStreamReader_length(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::quint64 sipRes;

            sipRes = sipCpp->length();

            return PyLong_FromUnsignedLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_length, doc_QCborStreamReader_length);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_isContainer, "isContainer(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_isContainer(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_isContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isContainer();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_isContainer, doc_QCborStreamReader_isContainer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_enterContainer, "enterContainer(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_enterContainer(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_enterContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->enterContainer();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_enterContainer, doc_QCborStreamReader_enterContainer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_leaveContainer, "leaveContainer(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_leaveContainer(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_leaveContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->leaveContainer();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_leaveContainer, doc_QCborStreamReader_leaveContainer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_readString, "readString(self) -> Tuple[str, QCborStreamReader.StringResultCode]");

extern "C" {static PyObject *meth_QCborStreamReader_readString(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_readString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 204 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qcborstream.sip"
        QCborStreamReader::StringResult<QString> res = sipCpp->readString();
        
        QString *qs = new QString;
        if (res.status != QCborStreamReader::Error)
            *qs = res.data;
        
        sipRes = sipBuildResult(NULL, "NF", qs, sipType_QString, NULL, res.status, sipType_QCborStreamReader_StringResultCode);
#line 1084 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQCborStreamReader.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_readString, doc_QCborStreamReader_readString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_readByteArray, "readByteArray(self) -> Tuple[QByteArray, QCborStreamReader.StringResultCode]");

extern "C" {static PyObject *meth_QCborStreamReader_readByteArray(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_readByteArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 215 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qcborstream.sip"
        QCborStreamReader::StringResult<QByteArray> res = sipCpp->readByteArray();
        
        QByteArray *qba = new QByteArray;
        if (res.status != QCborStreamReader::Error)
            *qba = res.data;
        
        sipRes = sipBuildResult(NULL, "NF", qba, sipType_QByteArray, NULL, res.status, sipType_QCborStreamReader_StringResultCode);
#line 1119 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQCborStreamReader.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_readByteArray, doc_QCborStreamReader_readByteArray);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_toBool, "toBool(self) -> bool");

extern "C" {static PyObject *meth_QCborStreamReader_toBool(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_toBool(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->toBool();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_toBool, doc_QCborStreamReader_toBool);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_toUnsignedInteger, "toUnsignedInteger(self) -> int");

extern "C" {static PyObject *meth_QCborStreamReader_toUnsignedInteger(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_toUnsignedInteger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::quint64 sipRes;

            sipRes = sipCpp->toUnsignedInteger();

            return PyLong_FromUnsignedLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_toUnsignedInteger, doc_QCborStreamReader_toUnsignedInteger);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_toSimpleType, "toSimpleType(self) -> QCborSimpleType");

extern "C" {static PyObject *meth_QCborStreamReader_toSimpleType(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_toSimpleType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::QCborSimpleType sipRes;

            sipRes = sipCpp->toSimpleType();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QCborSimpleType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_toSimpleType, doc_QCborStreamReader_toSimpleType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_toDouble, "toDouble(self) -> float");

extern "C" {static PyObject *meth_QCborStreamReader_toDouble(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_toDouble(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
            double sipRes;

            sipRes = sipCpp->toDouble();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_toDouble, doc_QCborStreamReader_toDouble);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCborStreamReader_toInteger, "toInteger(self) -> int");

extern "C" {static PyObject *meth_QCborStreamReader_toInteger(PyObject *, PyObject *);}
static PyObject *meth_QCborStreamReader_toInteger(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QCborStreamReader *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCborStreamReader, &sipCpp))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->toInteger();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCborStreamReader, sipName_toInteger, doc_QCborStreamReader_toInteger);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_QCborStreamReader___len__(PyObject *);}
static Py_ssize_t slot_QCborStreamReader___len__(PyObject *sipSelf)
{
     ::QCborStreamReader *sipCpp = reinterpret_cast< ::QCborStreamReader *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QCborStreamReader));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->length();
#line 1281 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQCborStreamReader.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QCborStreamReader(void *, int);}
static void release_QCborStreamReader(void *sipCppV, int)
{
    delete reinterpret_cast< ::QCborStreamReader *>(sipCppV);
}


extern "C" {static void *array_QCborStreamReader(Py_ssize_t);}
static void *array_QCborStreamReader(Py_ssize_t sipNrElem)
{
    return new  ::QCborStreamReader[sipNrElem];
}


extern "C" {static void array_delete_QCborStreamReader(void *);}
static void array_delete_QCborStreamReader(void *sipCpp)
{
    delete[] reinterpret_cast< ::QCborStreamReader *>(sipCpp);
}


extern "C" {static void dealloc_QCborStreamReader(sipSimpleWrapper *);}
static void dealloc_QCborStreamReader(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QCborStreamReader(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QCborStreamReader(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QCborStreamReader(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QCborStreamReader *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QCborStreamReader();

            return sipCpp;
        }
    }

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QByteArray, &a0, &a0State))
        {
            sipCpp = new  ::QCborStreamReader(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipCpp;
        }
    }

    {
         ::QIODevice* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J8", sipType_QIODevice, &a0))
        {
            sipCpp = new  ::QCborStreamReader(a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QCborStreamReader[] = {
    {(void *)slot_QCborStreamReader___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QCborStreamReader[] = {
    {sipName_addData, meth_QCborStreamReader_addData, METH_VARARGS, doc_QCborStreamReader_addData},
    {sipName_clear, meth_QCborStreamReader_clear, METH_VARARGS, doc_QCborStreamReader_clear},
    {sipName_containerDepth, meth_QCborStreamReader_containerDepth, METH_VARARGS, doc_QCborStreamReader_containerDepth},
    {sipName_currentOffset, meth_QCborStreamReader_currentOffset, METH_VARARGS, doc_QCborStreamReader_currentOffset},
    {sipName_device, meth_QCborStreamReader_device, METH_VARARGS, doc_QCborStreamReader_device},
    {sipName_enterContainer, meth_QCborStreamReader_enterContainer, METH_VARARGS, doc_QCborStreamReader_enterContainer},
    {sipName_hasNext, meth_QCborStreamReader_hasNext, METH_VARARGS, doc_QCborStreamReader_hasNext},
    {sipName_isArray, meth_QCborStreamReader_isArray, METH_VARARGS, doc_QCborStreamReader_isArray},
    {sipName_isBool, meth_QCborStreamReader_isBool, METH_VARARGS, doc_QCborStreamReader_isBool},
    {sipName_isByteArray, meth_QCborStreamReader_isByteArray, METH_VARARGS, doc_QCborStreamReader_isByteArray},
    {sipName_isContainer, meth_QCborStreamReader_isContainer, METH_VARARGS, doc_QCborStreamReader_isContainer},
    {sipName_isDouble, meth_QCborStreamReader_isDouble, METH_VARARGS, doc_QCborStreamReader_isDouble},
    {sipName_isFalse, meth_QCborStreamReader_isFalse, METH_VARARGS, doc_QCborStreamReader_isFalse},
    {sipName_isFloat, meth_QCborStreamReader_isFloat, METH_VARARGS, doc_QCborStreamReader_isFloat},
    {sipName_isFloat16, meth_QCborStreamReader_isFloat16, METH_VARARGS, doc_QCborStreamReader_isFloat16},
    {sipName_isInteger, meth_QCborStreamReader_isInteger, METH_VARARGS, doc_QCborStreamReader_isInteger},
    {sipName_isInvalid, meth_QCborStreamReader_isInvalid, METH_VARARGS, doc_QCborStreamReader_isInvalid},
    {sipName_isLengthKnown, meth_QCborStreamReader_isLengthKnown, METH_VARARGS, doc_QCborStreamReader_isLengthKnown},
    {sipName_isMap, meth_QCborStreamReader_isMap, METH_VARARGS, doc_QCborStreamReader_isMap},
    {sipName_isNegativeInteger, meth_QCborStreamReader_isNegativeInteger, METH_VARARGS, doc_QCborStreamReader_isNegativeInteger},
    {sipName_isNull, meth_QCborStreamReader_isNull, METH_VARARGS, doc_QCborStreamReader_isNull},
    {sipName_isSimpleType, meth_QCborStreamReader_isSimpleType, METH_VARARGS, doc_QCborStreamReader_isSimpleType},
    {sipName_isString, meth_QCborStreamReader_isString, METH_VARARGS, doc_QCborStreamReader_isString},
    {sipName_isTag, meth_QCborStreamReader_isTag, METH_VARARGS, doc_QCborStreamReader_isTag},
    {sipName_isTrue, meth_QCborStreamReader_isTrue, METH_VARARGS, doc_QCborStreamReader_isTrue},
    {sipName_isUndefined, meth_QCborStreamReader_isUndefined, METH_VARARGS, doc_QCborStreamReader_isUndefined},
    {sipName_isUnsignedInteger, meth_QCborStreamReader_isUnsignedInteger, METH_VARARGS, doc_QCborStreamReader_isUnsignedInteger},
    {sipName_isValid, meth_QCborStreamReader_isValid, METH_VARARGS, doc_QCborStreamReader_isValid},
    {sipName_lastError, meth_QCborStreamReader_lastError, METH_VARARGS, doc_QCborStreamReader_lastError},
    {sipName_leaveContainer, meth_QCborStreamReader_leaveContainer, METH_VARARGS, doc_QCborStreamReader_leaveContainer},
    {sipName_length, meth_QCborStreamReader_length, METH_VARARGS, doc_QCborStreamReader_length},
    {sipName_next, SIP_MLMETH_CAST(meth_QCborStreamReader_next), METH_VARARGS|METH_KEYWORDS, doc_QCborStreamReader_next},
    {sipName_parentContainerType, meth_QCborStreamReader_parentContainerType, METH_VARARGS, doc_QCborStreamReader_parentContainerType},
    {sipName_readByteArray, meth_QCborStreamReader_readByteArray, METH_VARARGS, doc_QCborStreamReader_readByteArray},
    {sipName_readString, meth_QCborStreamReader_readString, METH_VARARGS, doc_QCborStreamReader_readString},
    {sipName_reparse, meth_QCborStreamReader_reparse, METH_VARARGS, doc_QCborStreamReader_reparse},
    {sipName_reset, meth_QCborStreamReader_reset, METH_VARARGS, doc_QCborStreamReader_reset},
    {sipName_setDevice, meth_QCborStreamReader_setDevice, METH_VARARGS, doc_QCborStreamReader_setDevice},
    {sipName_toBool, meth_QCborStreamReader_toBool, METH_VARARGS, doc_QCborStreamReader_toBool},
    {sipName_toDouble, meth_QCborStreamReader_toDouble, METH_VARARGS, doc_QCborStreamReader_toDouble},
    {sipName_toInteger, meth_QCborStreamReader_toInteger, METH_VARARGS, doc_QCborStreamReader_toInteger},
    {sipName_toSimpleType, meth_QCborStreamReader_toSimpleType, METH_VARARGS, doc_QCborStreamReader_toSimpleType},
    {sipName_toUnsignedInteger, meth_QCborStreamReader_toUnsignedInteger, METH_VARARGS, doc_QCborStreamReader_toUnsignedInteger},
    {sipName_type, meth_QCborStreamReader_type, METH_VARARGS, doc_QCborStreamReader_type}
};

static sipEnumMemberDef enummembers_QCborStreamReader[] = {
    {sipName_Array, static_cast<int>( ::QCborStreamReader::Array), 36},
    {sipName_ByteArray, static_cast<int>( ::QCborStreamReader::ByteArray), 36},
    {sipName_ByteString, static_cast<int>( ::QCborStreamReader::ByteString), 36},
    {sipName_Double, static_cast<int>( ::QCborStreamReader::Double), 36},
    {sipName_EndOfString, static_cast<int>( ::QCborStreamReader::EndOfString), 35},
    {sipName_Error, static_cast<int>( ::QCborStreamReader::Error), 35},
    {sipName_Float, static_cast<int>( ::QCborStreamReader::Float), 36},
    {sipName_Float16, static_cast<int>( ::QCborStreamReader::Float16), 36},
    {sipName_HalfFloat, static_cast<int>( ::QCborStreamReader::HalfFloat), 36},
    {sipName_Invalid, static_cast<int>( ::QCborStreamReader::Invalid), 36},
    {sipName_Map, static_cast<int>( ::QCborStreamReader::Map), 36},
    {sipName_NegativeInteger, static_cast<int>( ::QCborStreamReader::NegativeInteger), 36},
    {sipName_Ok, static_cast<int>( ::QCborStreamReader::Ok), 35},
    {sipName_SimpleType, static_cast<int>( ::QCborStreamReader::SimpleType), 36},
    {sipName_String, static_cast<int>( ::QCborStreamReader::String), 36},
    {sipName_Tag, static_cast<int>( ::QCborStreamReader::Tag), 36},
    {sipName_TextString, static_cast<int>( ::QCborStreamReader::TextString), 36},
    {sipName_UnsignedInteger, static_cast<int>( ::QCborStreamReader::UnsignedInteger), 36},
};

PyDoc_STRVAR(doc_QCborStreamReader, "\1QCborStreamReader()\n"
"QCborStreamReader(Union[QByteArray, bytes, bytearray])\n"
"QCborStreamReader(QIODevice)");


static pyqt5ClassPluginDef plugin_QCborStreamReader = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QCborStreamReader = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QCborStreamReader,
        SIP_NULLPTR,
        &plugin_QCborStreamReader
    },
    {
        sipNameNr_QCborStreamReader,
        {0, 0, 1},
        44, methods_QCborStreamReader,
        18, enummembers_QCborStreamReader,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QCborStreamReader,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QCborStreamReader,
    init_type_QCborStreamReader,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QCborStreamReader,
    SIP_NULLPTR,
    array_QCborStreamReader,
    SIP_NULLPTR,
    release_QCborStreamReader,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QCborStreamReader,
    sizeof ( ::QCborStreamReader),
};
