/* rygel-basic-management.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-basic-management.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-core.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
enum  {
	RYGEL_BASIC_MANAGEMENT_0_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_NUM_PROPERTIES
};
static GParamSpec* rygel_basic_management_properties[RYGEL_BASIC_MANAGEMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())
typedef struct _Block1Data Block1Data;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED
} RygelBasicManagementTestExecutionState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE (rygel_basic_management_test_execution_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING (rygel_basic_management_test_ping_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))

typedef struct _RygelBasicManagementTestPing RygelBasicManagementTestPing;
typedef struct _RygelBasicManagementTestPingClass RygelBasicManagementTestPingClass;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP (rygel_basic_management_test_ns_lookup_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))

typedef struct _RygelBasicManagementTestNSLookup RygelBasicManagementTestNSLookup;
typedef struct _RygelBasicManagementTestNSLookupClass RygelBasicManagementTestNSLookupClass;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE (rygel_basic_management_test_traceroute_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))

typedef struct _RygelBasicManagementTestTraceroute RygelBasicManagementTestTraceroute;
typedef struct _RygelBasicManagementTestTracerouteClass RygelBasicManagementTestTracerouteClass;

struct _RygelBasicManagementPrivate {
	guint _max_history_size;
	GeeHashMap* tests_map;
	GeeHashMap* test_ids_by_type;
	guint current_id;
};

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _Block1Data {
	int _ref_count_;
	RygelBasicManagement* self;
	RygelBasicManagementTest* bm_test;
};

static gint RygelBasicManagement_private_offset;
static gpointer rygel_basic_management_parent_class = NULL;

VALA_EXTERN GType rygel_basic_management_test_get_type (void) G_GNUC_CONST ;
static void rygel_basic_management_real_constructed (GObject* base);
static void rygel_basic_management_query_device_status_cb (RygelBasicManagement* self,
                                                    GUPnPService* bm,
                                                    const gchar* var,
                                                    GValue* val);
static void _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                  const gchar* variable,
                                                                                  GValue* value,
                                                                                  gpointer self);
static void rygel_basic_management_query_test_ids_cb (RygelBasicManagement* self,
                                               GUPnPService* bm,
                                               const gchar* var,
                                               GValue* val);
static void _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                             const gchar* variable,
                                                                             GValue* value,
                                                                             gpointer self);
static void rygel_basic_management_query_active_test_ids_cb (RygelBasicManagement* self,
                                                      GUPnPService* bm,
                                                      const gchar* var,
                                                      GValue* val);
static void _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                                    const gchar* variable,
                                                                                    GValue* value,
                                                                                    gpointer self);
static void rygel_basic_management_get_device_status_cb (RygelBasicManagement* self,
                                                  GUPnPService* bm,
                                                  GUPnPServiceAction* action);
static void _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                GUPnPServiceAction* action,
                                                                                gpointer self);
static void rygel_basic_management_ping_cb (RygelBasicManagement* self,
                                     GUPnPService* bm,
                                     GUPnPServiceAction* action);
static void _rygel_basic_management_ping_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                   GUPnPServiceAction* action,
                                                                   gpointer self);
static void rygel_basic_management_ping_result_cb (RygelBasicManagement* self,
                                            GUPnPService* bm,
                                            GUPnPServiceAction* action);
static void _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                          GUPnPServiceAction* action,
                                                                          gpointer self);
static void rygel_basic_management_nslookup_cb (RygelBasicManagement* self,
                                         GUPnPService* bm,
                                         GUPnPServiceAction* action);
static void _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                       GUPnPServiceAction* action,
                                                                       gpointer self);
static void rygel_basic_management_nslookup_result_cb (RygelBasicManagement* self,
                                                GUPnPService* bm,
                                                GUPnPServiceAction* action);
static void _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                              GUPnPServiceAction* action,
                                                                              gpointer self);
static void rygel_basic_management_traceroute_cb (RygelBasicManagement* self,
                                           GUPnPService* bm,
                                           GUPnPServiceAction* action);
static void _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                         GUPnPServiceAction* action,
                                                                         gpointer self);
static void rygel_basic_management_traceroute_result_cb (RygelBasicManagement* self,
                                                  GUPnPService* bm,
                                                  GUPnPServiceAction* action);
static void _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                GUPnPServiceAction* action,
                                                                                gpointer self);
static void rygel_basic_management_get_test_ids_cb (RygelBasicManagement* self,
                                             GUPnPService* bm,
                                             GUPnPServiceAction* action);
static void _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                           GUPnPServiceAction* action,
                                                                           gpointer self);
static void rygel_basic_management_get_active_test_ids_cb (RygelBasicManagement* self,
                                                    GUPnPService* bm,
                                                    GUPnPServiceAction* action);
static void _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                  GUPnPServiceAction* action,
                                                                                  gpointer self);
static void rygel_basic_management_get_test_info_cb (RygelBasicManagement* self,
                                              GUPnPService* bm,
                                              GUPnPServiceAction* action);
static void _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                            GUPnPServiceAction* action,
                                                                            gpointer self);
static void rygel_basic_management_cancel_test_cb (RygelBasicManagement* self,
                                            GUPnPService* bm,
                                            GUPnPServiceAction* action);
static void _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                          GUPnPServiceAction* action,
                                                                          gpointer self);
static gchar* rygel_basic_management_create_test_ids_list (RygelBasicManagement* self,
                                                    gboolean active_only);
VALA_EXTERN gboolean rygel_basic_management_test_is_active (RygelBasicManagementTest* self);
VALA_EXTERN GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST ;
static gchar* rygel_basic_management_add_test (RygelBasicManagement* self,
                                        RygelBasicManagementTest* test);
VALA_EXTERN const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
static void rygel_basic_management_add_test_and_return_action (RygelBasicManagement* self,
                                                        RygelBasicManagementTest* bm_test,
                                                        GUPnPServiceAction* action);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN void rygel_basic_management_test_run (RygelBasicManagementTest* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN void rygel_basic_management_test_run_finish (RygelBasicManagementTest* self,
                                             GAsyncResult* _res_);
static void __lambda5_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static gboolean rygel_basic_management_ensure_test_exists (RygelBasicManagement* self,
                                                    GUPnPServiceAction* action,
                                                    RygelBasicManagementTest** bm_test);
VALA_EXTERN const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
VALA_EXTERN GType rygel_basic_management_test_execution_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelBasicManagementTestExecutionState rygel_basic_management_test_get_execution_state (RygelBasicManagementTest* self);
VALA_EXTERN gchar* rygel_basic_management_test_execution_state_to_string (RygelBasicManagementTestExecutionState self);
VALA_EXTERN GType rygel_basic_management_test_ping_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host,
                                                                    guint repeat_count,
                                                                    guint32 interval_time_out,
                                                                    guint data_block_size,
                                                                    guint dscp);
VALA_EXTERN RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type,
                                                                          const gchar* host,
                                                                          guint repeat_count,
                                                                          guint32 interval_time_out,
                                                                          guint data_block_size,
                                                                          guint dscp);
VALA_EXTERN void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self,
                                                   gchar** status,
                                                   gchar** additional_info,
                                                   guint* success_count,
                                                   guint* failure_count,
                                                   guint32* avg_response_time,
                                                   guint32* min_response_time,
                                                   guint32* max_response_time);
VALA_EXTERN GType rygel_basic_management_test_ns_lookup_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name,
                                                                             const gchar* name_server,
                                                                             guint repetitions,
                                                                             guint32 interval_time_out);
VALA_EXTERN RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type,
                                                                                   const gchar* host_name,
                                                                                   const gchar* name_server,
                                                                                   guint repetitions,
                                                                                   guint32 interval_time_out);
VALA_EXTERN void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self,
                                                        gchar** status,
                                                        gchar** additional_info,
                                                        guint* success_count,
                                                        gchar** result_string);
VALA_EXTERN GType rygel_basic_management_test_traceroute_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host,
                                                                                guint32 wait_time_out,
                                                                                guint data_block_size,
                                                                                guint max_hop_count,
                                                                                guint dscp);
VALA_EXTERN RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type,
                                                                                      const gchar* host,
                                                                                      guint32 wait_time_out,
                                                                                      guint data_block_size,
                                                                                      guint max_hop_count,
                                                                                      guint dscp);
VALA_EXTERN void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self,
                                                         gchar** status,
                                                         gchar** additional_info,
                                                         guint32* response_time,
                                                         gchar** hop_ips);
static void rygel_basic_management_finalize (GObject * obj);
static GType rygel_basic_management_get_type_once (void);
static void _vala_rygel_basic_management_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_rygel_basic_management_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
rygel_basic_management_get_instance_private (RygelBasicManagement* self)
{
	return G_STRUCT_MEMBER_P (self, RygelBasicManagement_private_offset);
}

static void
_rygel_basic_management_query_device_status_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                             const gchar* variable,
                                                                             GValue* value,
                                                                             gpointer self)
{
	rygel_basic_management_query_device_status_cb ((RygelBasicManagement*) self, _sender, variable, value);
}

static void
_rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                        const gchar* variable,
                                                                        GValue* value,
                                                                        gpointer self)
{
	rygel_basic_management_query_test_ids_cb ((RygelBasicManagement*) self, _sender, variable, value);
}

static void
_rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                               const gchar* variable,
                                                                               GValue* value,
                                                                               gpointer self)
{
	rygel_basic_management_query_active_test_ids_cb ((RygelBasicManagement*) self, _sender, variable, value);
}

static void
_rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                           GUPnPServiceAction* action,
                                                                           gpointer self)
{
	rygel_basic_management_get_device_status_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_ping_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                              GUPnPServiceAction* action,
                                                              gpointer self)
{
	rygel_basic_management_ping_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_ping_result_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                     GUPnPServiceAction* action,
                                                                     gpointer self)
{
	rygel_basic_management_ping_result_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_nslookup_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                  GUPnPServiceAction* action,
                                                                  gpointer self)
{
	rygel_basic_management_nslookup_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                         GUPnPServiceAction* action,
                                                                         gpointer self)
{
	rygel_basic_management_nslookup_result_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_traceroute_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                    GUPnPServiceAction* action,
                                                                    gpointer self)
{
	rygel_basic_management_traceroute_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                           GUPnPServiceAction* action,
                                                                           gpointer self)
{
	rygel_basic_management_traceroute_result_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                      GUPnPServiceAction* action,
                                                                      gpointer self)
{
	rygel_basic_management_get_test_ids_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                             GUPnPServiceAction* action,
                                                                             gpointer self)
{
	rygel_basic_management_get_active_test_ids_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                       GUPnPServiceAction* action,
                                                                       gpointer self)
{
	rygel_basic_management_get_test_info_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
_rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                     GUPnPServiceAction* action,
                                                                     gpointer self)
{
	rygel_basic_management_cancel_test_cb ((RygelBasicManagement*) self, _sender, action);
}

static void
rygel_basic_management_real_constructed (GObject* base)
{
	RygelBasicManagement * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GDateTime* now = NULL;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (RygelBasicManagement*) base;
	G_OBJECT_CLASS (rygel_basic_management_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tests_map);
	self->priv->tests_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->test_ids_by_type);
	self->priv->test_ids_by_type = _tmp1_;
	_tmp2_ = g_date_time_new_now_utc ();
	now = _tmp2_;
	_tmp3_ = g_date_time_format (now, "%Y-%m-%dT%H:%M:%S");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("OK,%sZ", _tmp4_);
	_g_free0 (self->device_status);
	self->device_status = _tmp5_;
	_g_free0 (_tmp4_);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::DeviceStatus", (GCallback) _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TestIDs", (GCallback) _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ActiveTestIDs", (GCallback) _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceStatus", (GCallback) _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Ping", (GCallback) _rygel_basic_management_ping_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPingResult", (GCallback) _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::NSLookup", (GCallback) _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetNSLookupResult", (GCallback) _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Traceroute", (GCallback) _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTracerouteResult", (GCallback) _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTestIDs", (GCallback) _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetActiveTestIDs", (GCallback) _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTestInfo", (GCallback) _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CancelTest", (GCallback) _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked, self, 0);
	_g_date_time_unref0 (now);
}

static gchar*
rygel_basic_management_create_test_ids_list (RygelBasicManagement* self,
                                             gboolean active_only)
{
	gchar* test_ids_list = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	test_ids_list = _tmp0_;
	{
		GeeIterator* _test_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->tests_map;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_test_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			RygelBasicManagementTest* test = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			const gchar* _tmp17_;
			RygelBasicManagementTest* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp7_ = _test_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _test_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			test = (RygelBasicManagementTest*) _tmp9_;
			if (active_only) {
				RygelBasicManagementTest* _tmp11_;
				_tmp11_ = test;
				_tmp10_ = !rygel_basic_management_test_is_active (_tmp11_);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				_g_object_unref0 (test);
				continue;
			}
			_tmp12_ = test_ids_list;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ > 0) {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = test_ids_list;
				_tmp16_ = g_strconcat (_tmp15_, ",", NULL);
				_g_free0 (test_ids_list);
				test_ids_list = _tmp16_;
			}
			_tmp17_ = test_ids_list;
			_tmp18_ = test;
			_tmp19_ = _tmp18_->id;
			_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
			_g_free0 (test_ids_list);
			test_ids_list = _tmp20_;
			_g_object_unref0 (test);
		}
		_g_object_unref0 (_test_it);
	}
	result = test_ids_list;
	return result;
}

static gchar*
rygel_basic_management_add_test (RygelBasicManagement* self,
                                 RygelBasicManagementTest* test)
{
	guint _tmp0_;
	gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	GeeLinkedList* type_test_ids = NULL;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_;
	GeeLinkedList* _tmp8_;
	GeeLinkedList* _tmp14_;
	const gchar* _tmp15_;
	GeeLinkedList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	guint _tmp19_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (test != NULL, NULL);
	_tmp0_ = self->priv->current_id;
	self->priv->current_id = _tmp0_ + 1;
	_tmp1_ = g_strdup_printf ("%u", self->priv->current_id);
	_g_free0 (test->id);
	test->id = _tmp1_;
	_tmp2_ = self->priv->tests_map;
	_tmp3_ = test->id;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp3_, test);
	_tmp4_ = self->priv->test_ids_by_type;
	_tmp5_ = rygel_basic_management_test_get_method_type (test);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp6_);
	_g_object_unref0 (type_test_ids);
	type_test_ids = (GeeLinkedList*) _tmp7_;
	_tmp8_ = type_test_ids;
	if (_tmp8_ == NULL) {
		GeeLinkedList* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GeeLinkedList* _tmp13_;
		_tmp9_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (type_test_ids);
		type_test_ids = _tmp9_;
		_tmp10_ = self->priv->test_ids_by_type;
		_tmp11_ = rygel_basic_management_test_get_method_type (test);
		_tmp12_ = _tmp11_;
		_tmp13_ = type_test_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp12_, _tmp13_);
	}
	_tmp14_ = type_test_ids;
	_tmp15_ = test->id;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
	_tmp16_ = type_test_ids;
	_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_max_history_size;
	if (((guint) _tmp18_) > _tmp19_) {
		gchar* old_id = NULL;
		GeeLinkedList* _tmp20_;
		gpointer _tmp21_;
		GeeHashMap* _tmp22_;
		const gchar* _tmp23_;
		gpointer _tmp24_;
		RygelBasicManagementTest* _tmp25_;
		GCancellable* _tmp26_;
		GCancellable* _tmp27_;
		GeeHashMap* _tmp28_;
		const gchar* _tmp29_;
		_tmp20_ = type_test_ids;
		_tmp21_ = gee_deque_poll_head ((GeeDeque*) _tmp20_);
		old_id = (gchar*) _tmp21_;
		_tmp22_ = self->priv->tests_map;
		_tmp23_ = old_id;
		_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
		_tmp25_ = (RygelBasicManagementTest*) _tmp24_;
		_tmp26_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp25_);
		_tmp27_ = _tmp26_;
		g_cancellable_cancel (_tmp27_);
		_g_object_unref0 (_tmp25_);
		_tmp28_ = self->priv->tests_map;
		_tmp29_ = old_id;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp28_, _tmp29_, NULL);
		_g_free0 (old_id);
	}
	_tmp30_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp31_ = _tmp30_;
	gupnp_service_notify ((GUPnPService*) self, "TestIDs", G_TYPE_STRING, _tmp31_, NULL);
	_g_free0 (_tmp31_);
	_tmp32_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp33_ = _tmp32_;
	gupnp_service_notify ((GUPnPService*) self, "ActiveTestIDs", G_TYPE_STRING, _tmp33_, NULL);
	_g_free0 (_tmp33_);
	_tmp34_ = test->id;
	_tmp35_ = g_strdup (_tmp34_);
	result = _tmp35_;
	_g_object_unref0 (type_test_ids);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelBasicManagement* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->bm_test);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda5_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* res)
{
	RygelBasicManagement* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	rygel_basic_management_test_run_finish (_data1_->bm_test, res);
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp1_ = _tmp0_;
	gupnp_service_notify ((GUPnPService*) self, "ActiveTestIDs", G_TYPE_STRING, _tmp1_, NULL);
	_g_free0 (_tmp1_);
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda5_ (self, source_object, res);
	block1_data_unref (self);
}

static void
rygel_basic_management_add_test_and_return_action (RygelBasicManagement* self,
                                                   RygelBasicManagementTest* bm_test,
                                                   GUPnPServiceAction* action)
{
	Block1Data* _data1_;
	RygelBasicManagementTest* _tmp0_;
	gchar* id = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm_test != NULL);
	g_return_if_fail (action != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (bm_test);
	_g_object_unref0 (_data1_->bm_test);
	_data1_->bm_test = _tmp0_;
	_tmp1_ = rygel_basic_management_add_test (self, _data1_->bm_test);
	id = _tmp1_;
	rygel_basic_management_test_run (_data1_->bm_test, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
	gupnp_service_action_set (action, "TestID", G_TYPE_STRING, id, NULL);
	gupnp_service_action_return_success (action);
	_g_free0 (id);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gboolean
rygel_basic_management_ensure_test_exists (RygelBasicManagement* self,
                                           GUPnPServiceAction* action,
                                           RygelBasicManagementTest** bm_test)
{
	RygelBasicManagementTest* _vala_bm_test = NULL;
	gchar* test_id = NULL;
	gchar* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	gchar* action_name = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	RygelBasicManagementTest* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	gupnp_service_action_get (action, "TestID", G_TYPE_STRING, &_tmp0_, NULL);
	_g_free0 (test_id);
	test_id = _tmp0_;
	_tmp1_ = self->priv->tests_map;
	_tmp2_ = test_id;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	_g_object_unref0 (_vala_bm_test);
	_vala_bm_test = (RygelBasicManagementTest*) _tmp3_;
	_tmp4_ = gupnp_service_action_get_name (action);
	_tmp5_ = g_strdup (_tmp4_);
	action_name = _tmp5_;
	_tmp6_ = _vala_bm_test;
	if (_tmp6_ == NULL) {
		gupnp_service_action_return_error (action, (guint) 706, _ ("No Such Test"));
		result = FALSE;
		_g_free0 (action_name);
		_g_free0 (test_id);
		if (bm_test) {
			*bm_test = _vala_bm_test;
		} else {
			_g_object_unref0 (_vala_bm_test);
		}
		return result;
	} else {
		gboolean _tmp7_ = FALSE;
		RygelBasicManagementTest* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = _vala_bm_test;
		_tmp9_ = rygel_basic_management_test_get_results_type (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = action_name;
		if (g_strcmp0 (_tmp10_, _tmp11_) != 0) {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = action_name;
			if (g_strcmp0 (_tmp14_, "GetPingResult") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = action_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "GetNSLookupResult") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = action_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "GetTracerouteResult") == 0;
			}
			_tmp7_ = _tmp12_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gupnp_service_action_return_error (action, (guint) 707, _ ("Wrong Test Type"));
			result = FALSE;
			_g_free0 (action_name);
			_g_free0 (test_id);
			if (bm_test) {
				*bm_test = _vala_bm_test;
			} else {
				_g_object_unref0 (_vala_bm_test);
			}
			return result;
		} else {
			gboolean _tmp17_ = FALSE;
			RygelBasicManagementTest* _tmp18_;
			RygelBasicManagementTestExecutionState _tmp19_;
			RygelBasicManagementTestExecutionState _tmp20_;
			_tmp18_ = _vala_bm_test;
			_tmp19_ = rygel_basic_management_test_get_execution_state (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ != RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED) {
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				const gchar* _tmp23_;
				_tmp23_ = action_name;
				if (g_strcmp0 (_tmp23_, "GetPingResult") == 0) {
					_tmp22_ = TRUE;
				} else {
					const gchar* _tmp24_;
					_tmp24_ = action_name;
					_tmp22_ = g_strcmp0 (_tmp24_, "GetNSLookupResult") == 0;
				}
				if (_tmp22_) {
					_tmp21_ = TRUE;
				} else {
					const gchar* _tmp25_;
					_tmp25_ = action_name;
					_tmp21_ = g_strcmp0 (_tmp25_, "GetTracerouteResult") == 0;
				}
				_tmp17_ = _tmp21_;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				RygelBasicManagementTest* _tmp26_;
				RygelBasicManagementTestExecutionState _tmp27_;
				RygelBasicManagementTestExecutionState _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp26_ = _vala_bm_test;
				_tmp27_ = rygel_basic_management_test_get_execution_state (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = rygel_basic_management_test_execution_state_to_string (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf (_ ("Invalid Test State “%s”"), _tmp30_);
				_tmp32_ = _tmp31_;
				gupnp_service_action_return_error (action, (guint) 708, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_g_free0 (action_name);
				_g_free0 (test_id);
				if (bm_test) {
					*bm_test = _vala_bm_test;
				} else {
					_g_object_unref0 (_vala_bm_test);
				}
				return result;
			} else {
				gboolean _tmp33_ = FALSE;
				const gchar* _tmp34_;
				_tmp34_ = action_name;
				if (g_strcmp0 (_tmp34_, "CancelTest") == 0) {
					RygelBasicManagementTest* _tmp35_;
					_tmp35_ = _vala_bm_test;
					_tmp33_ = !rygel_basic_management_test_is_active (_tmp35_);
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					RygelBasicManagementTest* _tmp36_;
					RygelBasicManagementTestExecutionState _tmp37_;
					RygelBasicManagementTestExecutionState _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp36_ = _vala_bm_test;
					_tmp37_ = rygel_basic_management_test_get_execution_state (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = rygel_basic_management_test_execution_state_to_string (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strdup_printf (_ ("State “%s” Precludes Cancel"), _tmp40_);
					_tmp42_ = _tmp41_;
					gupnp_service_action_return_error (action, (guint) 709, _tmp42_);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp40_);
					result = FALSE;
					_g_free0 (action_name);
					_g_free0 (test_id);
					if (bm_test) {
						*bm_test = _vala_bm_test;
					} else {
						_g_object_unref0 (_vala_bm_test);
					}
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (action_name);
	_g_free0 (test_id);
	if (bm_test) {
		*bm_test = _vala_bm_test;
	} else {
		_g_object_unref0 (_vala_bm_test);
	}
	return result;
}

static void
rygel_basic_management_query_device_status_cb (RygelBasicManagement* self,
                                               GUPnPService* bm,
                                               const gchar* var,
                                               GValue* val)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = self->device_status;
	g_value_set_string (val, _tmp0_);
}

static void
rygel_basic_management_query_test_ids_cb (RygelBasicManagement* self,
                                          GUPnPService* bm,
                                          const gchar* var,
                                          GValue* val)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp1_ = _tmp0_;
	g_value_set_string (val, _tmp1_);
	_g_free0 (_tmp1_);
}

static void
rygel_basic_management_query_active_test_ids_cb (RygelBasicManagement* self,
                                                 GUPnPService* bm,
                                                 const gchar* var,
                                                 GValue* val)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp1_ = _tmp0_;
	g_value_set_string (val, _tmp1_);
	_g_free0 (_tmp1_);
}

static void
rygel_basic_management_get_device_status_cb (RygelBasicManagement* self,
                                             GUPnPService* bm,
                                             GUPnPServiceAction* action)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 0)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp0_ = self->device_status;
	gupnp_service_action_set (action, "DeviceStatus", G_TYPE_STRING, _tmp0_, NULL);
	gupnp_service_action_return_success (action);
}

static void
rygel_basic_management_ping_cb (RygelBasicManagement* self,
                                GUPnPService* bm,
                                GUPnPServiceAction* action)
{
	gchar* host = NULL;
	guint repeat_count = 0U;
	guint data_block_size = 0U;
	guint dscp = 0U;
	guint32 interval_time_out = 0U;
	gchar* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint32 _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_;
	RygelBasicManagementTestPing* ping = NULL;
	const gchar* _tmp6_;
	RygelBasicManagementTestPing* _tmp7_;
	RygelBasicManagementTestPing* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 5)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	gupnp_service_action_get (action, "Host", G_TYPE_STRING, &_tmp0_, "NumberOfRepetitions", G_TYPE_UINT, &_tmp1_, "Timeout", G_TYPE_UINT, &_tmp2_, "DataBlockSize", G_TYPE_UINT, &_tmp3_, "DSCP", G_TYPE_UINT, &_tmp4_, NULL);
	_g_free0 (host);
	host = _tmp0_;
	repeat_count = _tmp1_;
	interval_time_out = _tmp2_;
	data_block_size = _tmp3_;
	dscp = _tmp4_;
	_tmp5_ = host;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		g_warning ("rygel-basic-management.vala:254: %s", _ ("Cannot run “Ping” action: Host is empty"));
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		_g_free0 (host);
		return;
	}
	_tmp6_ = host;
	_tmp7_ = rygel_basic_management_test_ping_new (_tmp6_, repeat_count, interval_time_out, data_block_size, dscp);
	ping = _tmp7_;
	_tmp8_ = ping;
	rygel_basic_management_add_test_and_return_action (self, RYGEL_IS_BASIC_MANAGEMENT_TEST (_tmp8_) ? ((RygelBasicManagementTest*) _tmp8_) : NULL, action);
	_g_object_unref0 (ping);
	_g_free0 (host);
}

static void
rygel_basic_management_ping_result_cb (RygelBasicManagement* self,
                                       GUPnPService* bm,
                                       GUPnPServiceAction* action)
{
	RygelBasicManagementTest* bm_test = NULL;
	RygelBasicManagementTest* _tmp0_ = NULL;
	gboolean _tmp1_;
	RygelBasicManagementTestPing* ping = NULL;
	RygelBasicManagementTest* _tmp2_;
	RygelBasicManagementTestPing* _tmp3_;
	RygelBasicManagementTestPing* _tmp4_;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	guint success_count = 0U;
	guint failure_count = 0U;
	guint32 avg_response_time = 0U;
	guint32 min_response_time = 0U;
	guint32 max_response_time = 0U;
	RygelBasicManagementTestPing* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint32 _tmp10_ = 0U;
	guint32 _tmp11_ = 0U;
	guint32 _tmp12_ = 0U;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 1)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp1_ = rygel_basic_management_ensure_test_exists (self, action, &_tmp0_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp0_;
	if (!_tmp1_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp2_ = bm_test;
	_tmp3_ = _g_object_ref0 (RYGEL_IS_BASIC_MANAGEMENT_TEST_PING (_tmp2_) ? ((RygelBasicManagementTestPing*) _tmp2_) : NULL);
	ping = _tmp3_;
	_tmp4_ = ping;
	if (_tmp4_ == NULL) {
		gupnp_service_action_return_error (action, (guint) 707, _ ("Wrong Test Type"));
		_g_object_unref0 (ping);
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp5_ = ping;
	rygel_basic_management_test_ping_get_results (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (status);
	status = _tmp6_;
	_g_free0 (additional_info);
	additional_info = _tmp7_;
	success_count = _tmp8_;
	failure_count = _tmp9_;
	avg_response_time = _tmp10_;
	min_response_time = _tmp11_;
	max_response_time = _tmp12_;
	_tmp13_ = status;
	_tmp14_ = additional_info;
	gupnp_service_action_set (action, "Status", G_TYPE_STRING, _tmp13_, "AdditionalInfo", G_TYPE_STRING, _tmp14_, "SuccessCount", G_TYPE_UINT, success_count, "FailureCount", G_TYPE_UINT, failure_count, "AverageResponseTime", G_TYPE_UINT, avg_response_time, "MinimumResponseTime", G_TYPE_UINT, min_response_time, "MaximumResponseTime", G_TYPE_UINT, max_response_time, NULL);
	gupnp_service_action_return_success (action);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (ping);
	_g_object_unref0 (bm_test);
}

static void
rygel_basic_management_nslookup_cb (RygelBasicManagement* self,
                                    GUPnPService* bm,
                                    GUPnPServiceAction* action)
{
	gchar* hostname = NULL;
	gchar* dns_server = NULL;
	guint repeat_count = 0U;
	guint32 interval_time_out = 0U;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint32 _tmp3_ = 0U;
	const gchar* _tmp4_;
	RygelBasicManagementTestNSLookup* nslookup = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	RygelBasicManagementTestNSLookup* _tmp7_;
	RygelBasicManagementTestNSLookup* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 4)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	gupnp_service_action_get (action, "HostName", G_TYPE_STRING, &_tmp0_, "DNSServer", G_TYPE_STRING, &_tmp1_, "NumberOfRepetitions", G_TYPE_UINT, &_tmp2_, "Timeout", G_TYPE_UINT, &_tmp3_, NULL);
	_g_free0 (hostname);
	hostname = _tmp0_;
	_g_free0 (dns_server);
	dns_server = _tmp1_;
	repeat_count = _tmp2_;
	interval_time_out = _tmp3_;
	_tmp4_ = hostname;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		g_warning ("rygel-basic-management.vala:352: %s", _ ("Cannot run “NSLookup” action: HostName is empty"));
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		_g_free0 (dns_server);
		_g_free0 (hostname);
		return;
	}
	_tmp5_ = hostname;
	_tmp6_ = dns_server;
	_tmp7_ = rygel_basic_management_test_ns_lookup_new (_tmp5_, _tmp6_, repeat_count, interval_time_out);
	nslookup = _tmp7_;
	_tmp8_ = nslookup;
	rygel_basic_management_add_test_and_return_action (self, RYGEL_IS_BASIC_MANAGEMENT_TEST (_tmp8_) ? ((RygelBasicManagementTest*) _tmp8_) : NULL, action);
	_g_object_unref0 (nslookup);
	_g_free0 (dns_server);
	_g_free0 (hostname);
}

static void
rygel_basic_management_nslookup_result_cb (RygelBasicManagement* self,
                                           GUPnPService* bm,
                                           GUPnPServiceAction* action)
{
	RygelBasicManagementTest* bm_test = NULL;
	RygelBasicManagementTest* _tmp0_ = NULL;
	gboolean _tmp1_;
	RygelBasicManagementTestNSLookup* nslookup = NULL;
	RygelBasicManagementTest* _tmp2_;
	RygelBasicManagementTestNSLookup* _tmp3_;
	RygelBasicManagementTestNSLookup* _tmp4_;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	gchar* _result_ = NULL;
	guint success_count = 0U;
	RygelBasicManagementTestNSLookup* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 1)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp1_ = rygel_basic_management_ensure_test_exists (self, action, &_tmp0_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp0_;
	if (!_tmp1_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp2_ = bm_test;
	_tmp3_ = _g_object_ref0 (RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP (_tmp2_) ? ((RygelBasicManagementTestNSLookup*) _tmp2_) : NULL);
	nslookup = _tmp3_;
	_tmp4_ = nslookup;
	if (_tmp4_ == NULL) {
		gupnp_service_action_return_error (action, (guint) 707, _ ("Wrong Test Type"));
		_g_object_unref0 (nslookup);
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp5_ = nslookup;
	rygel_basic_management_test_ns_lookup_get_results (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	_g_free0 (status);
	status = _tmp6_;
	_g_free0 (additional_info);
	additional_info = _tmp7_;
	success_count = _tmp8_;
	_g_free0 (_result_);
	_result_ = _tmp9_;
	_tmp10_ = status;
	_tmp11_ = additional_info;
	_tmp12_ = _result_;
	gupnp_service_action_set (action, "Status", G_TYPE_STRING, _tmp10_, "AdditionalInfo", G_TYPE_STRING, _tmp11_, "SuccessCount", G_TYPE_UINT, success_count, "Result", G_TYPE_STRING, _tmp12_, NULL);
	gupnp_service_action_return_success (action);
	_g_free0 (_result_);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (nslookup);
	_g_object_unref0 (bm_test);
}

static void
rygel_basic_management_traceroute_cb (RygelBasicManagement* self,
                                      GUPnPService* bm,
                                      GUPnPServiceAction* action)
{
	gchar* host = NULL;
	guint32 wait_time_out = 0U;
	guint data_block_size = 0U;
	guint max_hop_count = 0U;
	guint dscp = 0U;
	gchar* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_;
	RygelBasicManagementTestTraceroute* traceroute = NULL;
	const gchar* _tmp6_;
	RygelBasicManagementTestTraceroute* _tmp7_;
	RygelBasicManagementTestTraceroute* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 5)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	gupnp_service_action_get (action, "Host", G_TYPE_STRING, &_tmp0_, "Timeout", G_TYPE_UINT, &_tmp1_, "DataBlockSize", G_TYPE_UINT, &_tmp2_, "MaxHopCount", G_TYPE_UINT, &_tmp3_, "DSCP", G_TYPE_UINT, &_tmp4_, NULL);
	_g_free0 (host);
	host = _tmp0_;
	wait_time_out = _tmp1_;
	data_block_size = _tmp2_;
	max_hop_count = _tmp3_;
	dscp = _tmp4_;
	_tmp5_ = host;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		g_warning ("rygel-basic-management.vala:440: %s", _ ("Cannot run “Traceroute” action: Host is empty"));
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		_g_free0 (host);
		return;
	}
	_tmp6_ = host;
	_tmp7_ = rygel_basic_management_test_traceroute_new (_tmp6_, wait_time_out, data_block_size, max_hop_count, dscp);
	traceroute = _tmp7_;
	_tmp8_ = traceroute;
	rygel_basic_management_add_test_and_return_action (self, RYGEL_IS_BASIC_MANAGEMENT_TEST (_tmp8_) ? ((RygelBasicManagementTest*) _tmp8_) : NULL, action);
	_g_object_unref0 (traceroute);
	_g_free0 (host);
}

static void
rygel_basic_management_traceroute_result_cb (RygelBasicManagement* self,
                                             GUPnPService* bm,
                                             GUPnPServiceAction* action)
{
	RygelBasicManagementTest* bm_test = NULL;
	RygelBasicManagementTest* _tmp0_ = NULL;
	gboolean _tmp1_;
	RygelBasicManagementTestTraceroute* traceroute = NULL;
	RygelBasicManagementTest* _tmp2_;
	RygelBasicManagementTestTraceroute* _tmp3_;
	RygelBasicManagementTestTraceroute* _tmp4_;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	gchar* hop_hosts = NULL;
	guint32 response_time = 0U;
	RygelBasicManagementTestTraceroute* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint32 _tmp8_ = 0U;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 1)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp1_ = rygel_basic_management_ensure_test_exists (self, action, &_tmp0_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp0_;
	if (!_tmp1_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp2_ = bm_test;
	_tmp3_ = _g_object_ref0 (RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE (_tmp2_) ? ((RygelBasicManagementTestTraceroute*) _tmp2_) : NULL);
	traceroute = _tmp3_;
	_tmp4_ = traceroute;
	if (_tmp4_ == NULL) {
		gupnp_service_action_return_error (action, (guint) 707, _ ("Wrong Test Type"));
		_g_object_unref0 (traceroute);
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp5_ = traceroute;
	rygel_basic_management_test_traceroute_get_results (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	_g_free0 (status);
	status = _tmp6_;
	_g_free0 (additional_info);
	additional_info = _tmp7_;
	response_time = _tmp8_;
	_g_free0 (hop_hosts);
	hop_hosts = _tmp9_;
	_tmp10_ = status;
	_tmp11_ = additional_info;
	_tmp12_ = hop_hosts;
	gupnp_service_action_set (action, "Status", G_TYPE_STRING, _tmp10_, "AdditionalInfo", G_TYPE_STRING, _tmp11_, "ResponseTime", G_TYPE_UINT, response_time, "HopHosts", G_TYPE_STRING, _tmp12_, NULL);
	gupnp_service_action_return_success (action);
	_g_free0 (hop_hosts);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (traceroute);
	_g_object_unref0 (bm_test);
}

static void
rygel_basic_management_get_test_ids_cb (RygelBasicManagement* self,
                                        GUPnPService* bm,
                                        GUPnPServiceAction* action)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 0)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp1_ = _tmp0_;
	gupnp_service_action_set (action, "TestIDs", G_TYPE_STRING, _tmp1_, NULL);
	_g_free0 (_tmp1_);
	gupnp_service_action_return_success (action);
}

static void
rygel_basic_management_get_active_test_ids_cb (RygelBasicManagement* self,
                                               GUPnPService* bm,
                                               GUPnPServiceAction* action)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 0)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp1_ = _tmp0_;
	gupnp_service_action_set (action, "TestIDs", G_TYPE_STRING, _tmp1_, NULL);
	_g_free0 (_tmp1_);
	gupnp_service_action_return_success (action);
}

static void
rygel_basic_management_get_test_info_cb (RygelBasicManagement* self,
                                         GUPnPService* bm,
                                         GUPnPServiceAction* action)
{
	RygelBasicManagementTest* bm_test = NULL;
	RygelBasicManagementTest* _tmp0_ = NULL;
	gboolean _tmp1_;
	RygelBasicManagementTest* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelBasicManagementTest* _tmp5_;
	RygelBasicManagementTestExecutionState _tmp6_;
	RygelBasicManagementTestExecutionState _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 1)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp1_ = rygel_basic_management_ensure_test_exists (self, action, &_tmp0_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp0_;
	if (!_tmp1_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp2_ = bm_test;
	_tmp3_ = rygel_basic_management_test_get_method_type (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = bm_test;
	_tmp6_ = rygel_basic_management_test_get_execution_state (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = rygel_basic_management_test_execution_state_to_string (_tmp7_);
	_tmp9_ = _tmp8_;
	gupnp_service_action_set (action, "Type", G_TYPE_STRING, _tmp4_, "State", G_TYPE_STRING, _tmp9_, NULL);
	_g_free0 (_tmp9_);
	gupnp_service_action_return_success (action);
	_g_object_unref0 (bm_test);
}

static void
rygel_basic_management_cancel_test_cb (RygelBasicManagement* self,
                                       GUPnPService* bm,
                                       GUPnPServiceAction* action)
{
	RygelBasicManagementTest* bm_test = NULL;
	RygelBasicManagementTest* _tmp0_ = NULL;
	gboolean _tmp1_;
	RygelBasicManagementTest* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	if (gupnp_service_action_get_argument_count (action) != ((guint) 1)) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		return;
	}
	_tmp1_ = rygel_basic_management_ensure_test_exists (self, action, &_tmp0_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp0_;
	if (!_tmp1_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp2_ = bm_test;
	_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_cancellable_cancel (_tmp4_);
	gupnp_service_action_return_success (action);
	_g_object_unref0 (bm_test);
}

RygelBasicManagement*
rygel_basic_management_construct (GType object_type)
{
	RygelBasicManagement * self = NULL;
	self = (RygelBasicManagement*) g_object_new (object_type, NULL);
	return self;
}

RygelBasicManagement*
rygel_basic_management_new (void)
{
	return rygel_basic_management_construct (RYGEL_TYPE_BASIC_MANAGEMENT);
}

guint
rygel_basic_management_get_max_history_size (RygelBasicManagement* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_max_history_size;
	return result;
}

void
rygel_basic_management_set_max_history_size (RygelBasicManagement* self,
                                             guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_basic_management_get_max_history_size (self);
	if (old_value != value) {
		self->priv->_max_history_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_properties[RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY]);
	}
}

static void
rygel_basic_management_class_init (RygelBasicManagementClass * klass,
                                   gpointer klass_data)
{
	rygel_basic_management_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelBasicManagement_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_basic_management_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY, rygel_basic_management_properties[RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY] = g_param_spec_uint ("max-history-size", "max-history-size", "max-history-size", 0, G_MAXUINT, (guint) 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_basic_management_instance_init (RygelBasicManagement * self,
                                      gpointer klass)
{
	self->priv = rygel_basic_management_get_instance_private (self);
	self->priv->_max_history_size = (guint) 10;
}

static void
rygel_basic_management_finalize (GObject * obj)
{
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	_g_object_unref0 (self->priv->tests_map);
	_g_object_unref0 (self->priv->test_ids_by_type);
	_g_free0 (self->device_status);
	G_OBJECT_CLASS (rygel_basic_management_parent_class)->finalize (obj);
}

/**
 * Basic implementation of UPnP BasicManagement service version 2.
 */
 G_GNUC_NO_INLINE static GType
rygel_basic_management_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagement), 0, (GInstanceInitFunc) rygel_basic_management_instance_init, NULL };
	GType rygel_basic_management_type_id;
	rygel_basic_management_type_id = g_type_register_static (gupnp_service_get_type (), "RygelBasicManagement", &g_define_type_info, 0);
	RygelBasicManagement_private_offset = g_type_add_instance_private (rygel_basic_management_type_id, sizeof (RygelBasicManagementPrivate));
	return rygel_basic_management_type_id;
}

GType
rygel_basic_management_get_type (void)
{
	static volatile gsize rygel_basic_management_type_id__once = 0;
	if (g_once_init_enter (&rygel_basic_management_type_id__once)) {
		GType rygel_basic_management_type_id;
		rygel_basic_management_type_id = rygel_basic_management_get_type_once ();
		g_once_init_leave (&rygel_basic_management_type_id__once, rygel_basic_management_type_id);
	}
	return rygel_basic_management_type_id__once;
}

static void
_vala_rygel_basic_management_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_get_max_history_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_basic_management_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE_PROPERTY:
		rygel_basic_management_set_max_history_size (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

