/* rygel-changelog.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-changelog.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <libgupnp/gupnp.h>
#include "rygel-renderer.h"

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;
typedef struct _RygelChangeLogPrivate RygelChangeLogPrivate;
enum  {
	RYGEL_CHANGE_LOG_0_PROPERTY,
	RYGEL_CHANGE_LOG_NUM_PROPERTIES
};
static GParamSpec* rygel_change_log_properties[RYGEL_CHANGE_LOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelChangeLog {
	GObject parent_instance;
	RygelChangeLogPrivate * priv;
};

struct _RygelChangeLogClass {
	GObjectClass parent_class;
};

struct _RygelChangeLogPrivate {
	GWeakRef service;
	gchar* service_ns;
	GString* str;
	GeeHashMap* hash;
	guint timeout_id;
};

static gint RygelChangeLog_private_offset;
static gpointer rygel_change_log_parent_class = NULL;

VALA_EXTERN GType rygel_change_log_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelChangeLog* rygel_change_log_new (GUPnPService* service,
                                      const gchar* service_ns);
VALA_EXTERN RygelChangeLog* rygel_change_log_construct (GType object_type,
                                            GUPnPService* service,
                                            const gchar* service_ns);
static gboolean rygel_change_log_timeout (RygelChangeLog* self);
VALA_EXTERN gchar* rygel_change_log_finish (RygelChangeLog* self);
static void rygel_change_log_ensure_timeout (RygelChangeLog* self);
static gboolean _rygel_change_log_timeout_gsource_func (gpointer self);
VALA_EXTERN void rygel_change_log_log (RygelChangeLog* self,
                           const gchar* variable,
                           const gchar* value);
VALA_EXTERN void rygel_change_log_log_with_channel (RygelChangeLog* self,
                                        const gchar* variable,
                                        const gchar* value,
                                        const gchar* channel);
static void rygel_change_log_finalize (GObject * obj);
static GType rygel_change_log_get_type_once (void);

static inline gpointer
rygel_change_log_get_instance_private (RygelChangeLog* self)
{
	return G_STRUCT_MEMBER_P (self, RygelChangeLog_private_offset);
}

RygelChangeLog*
rygel_change_log_construct (GType object_type,
                            GUPnPService* service,
                            const gchar* service_ns)
{
	RygelChangeLog * self = NULL;
	gchar* _tmp0_;
	GString* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_val_if_fail (service_ns != NULL, NULL);
	self = (RygelChangeLog*) g_object_new (object_type, NULL);
	g_weak_ref_clear (&self->priv->service);
	g_weak_ref_init (&self->priv->service, (GObject*) service);
	_tmp0_ = g_strdup (service_ns);
	_g_free0 (self->priv->service_ns);
	self->priv->service_ns = _tmp0_;
	_tmp1_ = g_string_new ("");
	_g_string_free0 (self->priv->str);
	self->priv->str = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->hash);
	self->priv->hash = _tmp2_;
	return self;
}

RygelChangeLog*
rygel_change_log_new (GUPnPService* service,
                      const gchar* service_ns)
{
	return rygel_change_log_construct (RYGEL_TYPE_CHANGE_LOG, service, service_ns);
}

static gboolean
rygel_change_log_timeout (RygelChangeLog* self)
{
	GUPnPService* service = NULL;
	GObject* _tmp0_;
	GUPnPService* _tmp1_;
	GUPnPService* _tmp2_;
	GUPnPService* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	GString* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_weak_ref_get (&self->priv->service);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_service_get_type ()) ? ((GUPnPService*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	service = _tmp1_;
	_tmp2_ = service;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (service);
		return result;
	}
	_tmp3_ = service;
	_tmp4_ = rygel_change_log_finish (self);
	_tmp5_ = _tmp4_;
	gupnp_service_notify (_tmp3_, "LastChange", G_TYPE_STRING, _tmp5_, NULL);
	_g_free0 (_tmp5_);
	g_debug ("rygel-changelog.vala:60: LastChange sent");
	_tmp6_ = self->priv->hash;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp6_);
	_tmp7_ = self->priv->str;
	g_string_erase (_tmp7_, (gssize) 0, (gssize) -1);
	self->priv->timeout_id = (guint) 0;
	result = FALSE;
	_g_object_unref0 (service);
	return result;
}

static gboolean
_rygel_change_log_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = rygel_change_log_timeout ((RygelChangeLog*) self);
	return result;
}

static void
rygel_change_log_ensure_timeout (RygelChangeLog* self)
{
	gboolean _tmp0_ = FALSE;
	GObject* _tmp1_;
	GObject* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = g_weak_ref_get (&self->priv->service);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = self->priv->timeout_id == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_debug ("rygel-changelog.vala:73: Setting up timeout for LastChange");
		self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _rygel_change_log_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
}

void
rygel_change_log_log (RygelChangeLog* self,
                      const gchar* variable,
                      const gchar* value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("rygel-changelog.vala:79: '%s = %s' logged", variable, value);
	_tmp0_ = self->priv->hash;
	_tmp1_ = g_markup_escape_text (value, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("<%s val=\"%s\"/>", variable, _tmp2_);
	_tmp4_ = _tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, variable, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	rygel_change_log_ensure_timeout (self);
}

void
rygel_change_log_log_with_channel (RygelChangeLog* self,
                                   const gchar* variable,
                                   const gchar* value,
                                   const gchar* channel)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = g_markup_escape_text (value, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_markup_escape_text (channel, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("<%s val=\"%s\" channel=\"%s\"/>", variable, _tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	text = _tmp5_;
	_tmp6_ = self->priv->hash;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, variable, text);
	rygel_change_log_ensure_timeout (self);
	_g_free0 (text);
}

gchar*
rygel_change_log_finish (RygelChangeLog* self)
{
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GString* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->str;
	_tmp1_ = self->priv->service_ns;
	_tmp2_ = g_strconcat ("<Event xmlns=\"", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "\"><InstanceID val=\"0\">", NULL);
	_tmp5_ = _tmp4_;
	g_string_append (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	{
		GeeIterator* _line_it = NULL;
		GeeHashMap* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp6_ = self->priv->hash;
		_tmp7_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_line_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* line = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			GString* _tmp15_;
			const gchar* _tmp16_;
			_tmp12_ = _line_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _line_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			line = (gchar*) _tmp14_;
			_tmp15_ = self->priv->str;
			_tmp16_ = line;
			g_string_append (_tmp15_, _tmp16_);
			_g_free0 (line);
		}
		_g_object_unref0 (_line_it);
	}
	_tmp17_ = self->priv->str;
	g_string_append (_tmp17_, "</InstanceID></Event>");
	_tmp18_ = self->priv->str;
	_tmp19_ = _tmp18_->str;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	return result;
}

static void
rygel_change_log_class_init (RygelChangeLogClass * klass,
                             gpointer klass_data)
{
	rygel_change_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelChangeLog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_change_log_finalize;
}

static void
rygel_change_log_instance_init (RygelChangeLog * self,
                                gpointer klass)
{
	self->priv = rygel_change_log_get_instance_private (self);
	self->priv->timeout_id = (guint) 0;
}

static void
rygel_change_log_finalize (GObject * obj)
{
	RygelChangeLog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CHANGE_LOG, RygelChangeLog);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
	}
	g_weak_ref_clear (&self->priv->service);
	_g_free0 (self->priv->service_ns);
	_g_string_free0 (self->priv->str);
	_g_object_unref0 (self->priv->hash);
	G_OBJECT_CLASS (rygel_change_log_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_change_log_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelChangeLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_change_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelChangeLog), 0, (GInstanceInitFunc) rygel_change_log_instance_init, NULL };
	GType rygel_change_log_type_id;
	rygel_change_log_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelChangeLog", &g_define_type_info, 0);
	RygelChangeLog_private_offset = g_type_add_instance_private (rygel_change_log_type_id, sizeof (RygelChangeLogPrivate));
	return rygel_change_log_type_id;
}

GType
rygel_change_log_get_type (void)
{
	static volatile gsize rygel_change_log_type_id__once = 0;
	if (g_once_init_enter (&rygel_change_log_type_id__once)) {
		GType rygel_change_log_type_id;
		rygel_change_log_type_id = rygel_change_log_get_type_once ();
		g_once_init_leave (&rygel_change_log_type_id__once, rygel_change_log_type_id);
	}
	return rygel_change_log_type_id__once;
}

