/* rygel-media-query-action.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-media-query-action.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include "rygel-core.h"
#include <glib.h>
#include <gio/gio.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
enum  {
	RYGEL_MEDIA_QUERY_ACTION_0_PROPERTY,
	RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE_PROPERTY,
	RYGEL_MEDIA_QUERY_ACTION_NUM_PROPERTIES
};
static GParamSpec* rygel_media_query_action_properties[RYGEL_MEDIA_QUERY_ACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))

#define RYGEL_TYPE_CLIENT_HACKS_ERROR (rygel_client_hacks_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaQueryActionRunData RygelMediaQueryActionRunData;

#define RYGEL_TYPE_CONTENT_DIRECTORY_ERROR (rygel_content_directory_error_get_type ())
typedef struct _RygelMediaQueryActionFetchMediaObjectData RygelMediaQueryActionFetchMediaObjectData;

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	RygelSerializer* serializer;
	RygelClientHacks* hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelMediaQueryActionPrivate {
	GCancellable* _cancellable;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

struct _RygelMediaQueryActionRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp0_;
	RygelMediaObjects* results;
	RygelMediaObject* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaObject* _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelSerializer* _tmp9_;
	RygelHTTPServer* _tmp10_;
	RygelClientHacks* _tmp11_;
	GError* err;
	GError* _tmp12_;
	GError* _inner_error0_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()

struct _RygelMediaQueryActionFetchMediaObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelMediaObject* _tmp5_;
	const gchar* _tmp6_;
	RygelMediaObject* media_object;
	RygelMediaContainer* _tmp7_;
	const gchar* _tmp8_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

static gint RygelMediaQueryAction_private_offset;
static gpointer rygel_media_query_action_parent_class = NULL;
static RygelStateMachineIface * rygel_media_query_action_rygel_state_machine_parent_iface = NULL;

VALA_EXTERN GType rygel_media_query_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_client_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_media_query_action_parse_args (RygelMediaQueryAction* self,
                                          GError** error);
VALA_EXTERN void rygel_media_query_action_handle_error (RygelMediaQueryAction* self,
                                            GError* _error_);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
VALA_EXTERN RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type,
                                                           RygelContentDirectory* content_dir,
                                                           GUPnPServiceAction* action);
VALA_EXTERN GQuark rygel_client_hacks_error_quark (void);
GType rygel_client_hacks_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelClientHacks* rygel_client_hacks_create (SoupServerMessage* message,
                                             GError** error);
static void rygel_media_query_action_real_run_data_free (gpointer _data);
static void rygel_media_query_action_real_run (RygelStateMachine* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* _data_);
static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static void rygel_media_query_action_run_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
VALA_EXTERN void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self,
                                             RygelMediaObject* media_object,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
VALA_EXTERN void rygel_media_objects_serialize (RygelMediaObjects* self,
                                    RygelSerializer* serializer,
                                    RygelHTTPServer* http_server,
                                    RygelClientHacks* hacks,
                                    GError** error);
static void rygel_media_query_action_conclude (RygelMediaQueryAction* self);
static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self,
                                               GError** error);
VALA_EXTERN GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_client_hacks_filter_sort_criteria (RygelClientHacks* self,
                                              gchar** sort_criteria);
static void rygel_media_query_action_validate_sort_criteria (RygelMediaQueryAction* self,
                                                      GError** error);
VALA_EXTERN void rygel_client_hacks_translate_container_id (RygelClientHacks* self,
                                                RygelMediaQueryAction* action,
                                                gchar** container_id);
static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data);
static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* _data_);
static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self,
                                                 GError* _error_);
static void rygel_media_query_action_finalize (GObject * obj);
static GType rygel_media_query_action_get_type_once (void);
static void _vala_rygel_media_query_action_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_rygel_media_query_action_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_media_query_action_get_instance_private (RygelMediaQueryAction* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaQueryAction_private_offset);
}

static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMediaQueryAction*
rygel_media_query_action_construct (GType object_type,
                                    RygelContentDirectory* content_dir,
                                    GUPnPServiceAction* action)
{
	RygelMediaQueryAction * self = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPServer* _tmp3_;
	GCancellable* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	RygelSerializer* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelMediaQueryAction*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir->root_container;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->root_container);
	self->root_container = _tmp1_;
	_tmp2_ = content_dir->http_server;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp3_;
	self->system_update_id = content_dir->system_update_id;
	_tmp4_ = content_dir->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp4_);
	_tmp5_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->action);
	self->action = _tmp5_;
	_tmp6_ = rygel_serializer_new (RYGEL_SERIALIZER_TYPE_GENERIC_DIDL);
	_g_object_unref0 (self->serializer);
	self->serializer = _tmp6_;
	{
		RygelClientHacks* _tmp7_ = NULL;
		GUPnPServiceAction* _tmp8_;
		SoupServerMessage* _tmp9_;
		SoupServerMessage* _tmp10_;
		RygelClientHacks* _tmp11_;
		RygelClientHacks* _tmp12_;
		RygelClientHacks* _tmp13_;
		_tmp8_ = self->action;
		_tmp9_ = gupnp_service_action_get_message (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = rygel_client_hacks_create (_tmp10_, &_inner_error0_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp7_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->hacks);
		self->hacks = _tmp13_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		__vala_GUPnPServiceAction_free0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}

static void
rygel_media_query_action_real_run_data_free (gpointer _data)
{
	RygelMediaQueryActionRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaQueryActionRunData, _data_);
}

static void
rygel_media_query_action_real_run (RygelStateMachine* base,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RygelMediaQueryAction * self;
	RygelMediaQueryActionRunData* _data_;
	RygelMediaQueryAction* _tmp0_;
	self = (RygelMediaQueryAction*) base;
	_data_ = g_slice_new0 (RygelMediaQueryActionRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_query_action_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_query_action_real_run_co (_data_);
}

static void
rygel_media_query_action_run_finish (RygelStateMachine* base,
                                     GAsyncResult* _res_)
{
	RygelMediaQueryActionRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_media_query_action_run_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	RygelMediaQueryActionRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_query_action_real_run_co (_data_);
}

static gboolean
rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		rygel_media_query_action_parse_args (_data_->self, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_state_ = 1;
		rygel_media_query_action_fetch_media_object (_data_->self, rygel_media_query_action_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = rygel_media_query_action_fetch_media_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->media_object = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->media_object;
		_data_->_state_ = 2;
		rygel_media_query_action_fetch_results (_data_->self, _data_->_tmp1_, rygel_media_query_action_run_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp2_ = rygel_media_query_action_fetch_results_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->results = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->media_object);
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->results;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->self->number_returned = (guint) _data_->_tmp5_;
		_data_->_tmp6_ = _data_->media_object;
		if (RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp6_)) {
			_data_->_tmp7_ = _data_->media_object;
			_data_->self->update_id = (guint) G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer)->update_id;
		} else {
			_data_->self->update_id = (guint) G_MAXUINT32;
		}
		_data_->_tmp8_ = _data_->results;
		_data_->_tmp9_ = _data_->self->serializer;
		_data_->_tmp10_ = _data_->self->http_server;
		_data_->_tmp11_ = _data_->self->hacks;
		rygel_media_objects_serialize (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->results);
			_g_object_unref0 (_data_->media_object);
			goto __catch0_g_error;
		}
		rygel_media_query_action_conclude (_data_->self);
		_g_object_unref0 (_data_->results);
		_g_object_unref0 (_data_->media_object);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->err;
		rygel_media_query_action_handle_error (_data_->self, _data_->_tmp12_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self,
                                          GError** error)
{
	gint64 index = 0LL;
	gint64 requested_count = 0LL;
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp13_;
	const gchar* _tmp15_;
	gboolean _tmp16_ = FALSE;
	RygelClientHacks* _tmp17_;
	RygelClientHacks* _tmp20_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->action;
	if (gupnp_service_action_get_argument_count (_tmp0_) != ((guint) 6)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Invalid number of arguments"));
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = self->action;
	_tmp3_ = self->object_id_arg;
	gupnp_service_action_get (_tmp2_, _tmp3_, G_TYPE_STRING, &_tmp4_, "Filter", G_TYPE_STRING, &_tmp5_, "StartingIndex", G_TYPE_INT64, &_tmp6_, "RequestedCount", G_TYPE_INT64, &_tmp7_, "SortCriteria", G_TYPE_STRING, &_tmp8_, NULL);
	_g_free0 (self->object_id);
	self->object_id = _tmp4_;
	_g_free0 (self->filter);
	self->filter = _tmp5_;
	index = _tmp6_;
	requested_count = _tmp7_;
	_g_free0 (self->sort_criteria);
	self->sort_criteria = _tmp8_;
	_tmp9_ = self->object_id;
	if (_tmp9_ == NULL) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("ObjectID argument missing"));
		_inner_error0_ = _tmp10_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (index < ((gint64) 0)) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = requested_count < ((gint64) 0);
	}
	if (_tmp11_) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Invalid range"));
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp13_ = self->filter;
	if (_tmp13_ == NULL) {
		GError* _tmp14_;
		_tmp14_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Missing filter"));
		_inner_error0_ = _tmp14_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->index = (guint) index;
	self->requested_count = (guint) requested_count;
	_tmp15_ = self->sort_criteria;
	if (g_strcmp0 (_tmp15_, "") == 0) {
		_g_free0 (self->sort_criteria);
		self->sort_criteria = NULL;
	}
	_tmp17_ = self->hacks;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		_tmp18_ = self->sort_criteria;
		_tmp16_ = _tmp18_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		RygelClientHacks* _tmp19_;
		_tmp19_ = self->hacks;
		rygel_client_hacks_filter_sort_criteria (_tmp19_, &self->sort_criteria);
	}
	rygel_media_query_action_validate_sort_criteria (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp20_ = self->hacks;
	if (_tmp20_ != NULL) {
		RygelClientHacks* _tmp21_;
		_tmp21_ = self->hacks;
		rygel_client_hacks_translate_container_id (_tmp21_, self, &self->object_id);
	}
}

void
rygel_media_query_action_parse_args (RygelMediaQueryAction* self,
                                     GError** error)
{
	RygelMediaQueryActionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self);
	if (_klass_->parse_args) {
		_klass_->parse_args (self, error);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
rygel_media_query_action_validate_sort_criteria (RygelMediaQueryAction* self,
                                                 GError** error)
{
	const gchar* _tmp0_;
	GeeHashSet* supported_props = NULL;
	GeeHashSet* _tmp1_;
	gchar** requested_sort_props = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint requested_sort_props_length1;
	gint _requested_sort_props_size_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->sort_criteria;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	supported_props = _tmp1_;
	_tmp2_ = self->sort_criteria;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
	requested_sort_props = _tmp4_;
	requested_sort_props_length1 = _vala_array_length (_tmp3_);
	_requested_sort_props_size_ = requested_sort_props_length1;
	_tmp6_ = _tmp5_ = g_strsplit (RYGEL_MEDIA_OBJECTS_SORT_CAPS, ",", 0);
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
		property_collection = _tmp6_;
		property_collection_length1 = _vala_array_length (_tmp5_);
		for (property_it = 0; property_it < property_collection_length1; property_it = property_it + 1) {
			gchar* _tmp7_;
			gchar* property = NULL;
			_tmp7_ = g_strdup (property_collection[property_it]);
			property = _tmp7_;
			{
				GeeHashSet* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = supported_props;
				_tmp9_ = property;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				_g_free0 (property);
			}
		}
		property_collection = (_vala_array_free (property_collection, property_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp10_ = requested_sort_props;
	_tmp10__length1 = requested_sort_props_length1;
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
		property_collection = _tmp10_;
		property_collection_length1 = _tmp10__length1;
		for (property_it = 0; property_it < property_collection_length1; property_it = property_it + 1) {
			gchar* _tmp11_;
			gchar* property = NULL;
			_tmp11_ = g_strdup (property_collection[property_it]);
			property = _tmp11_;
			{
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_;
				GeeHashSet* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				_tmp13_ = property;
				if (g_str_has_prefix (_tmp13_, "+")) {
					_tmp12_ = TRUE;
				} else {
					const gchar* _tmp14_;
					_tmp14_ = property;
					_tmp12_ = g_str_has_prefix (_tmp14_, "-");
				}
				if (!_tmp12_) {
					const gchar* _tmp15_;
					GError* _tmp16_;
					_tmp15_ = property;
					_tmp16_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA, "%s is missing + or - modifier", _tmp15_);
					_inner_error0_ = _tmp16_;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (property);
					requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (supported_props);
					return;
				}
				_tmp17_ = supported_props;
				_tmp18_ = property;
				_tmp19_ = property;
				_tmp20_ = strlen (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_slice (_tmp18_, (glong) 1, (glong) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp17_, _tmp23_);
				_g_free0 (_tmp23_);
				if (_tmp24_) {
					const gchar* _tmp25_;
					GError* _tmp26_;
					_tmp25_ = property;
					_tmp26_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA, "%s is invalid or not supported", _tmp25_);
					_inner_error0_ = _tmp26_;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (property);
					requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (supported_props);
					return;
				}
				_g_free0 (property);
			}
		}
	}
	requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (supported_props);
}

void
rygel_media_query_action_fetch_results (RygelMediaQueryAction* self,
                                        RygelMediaObject* media_object,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RygelMediaQueryActionClass* _klass_;
	_klass_ = RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self);
	if (_klass_->fetch_results) {
		_klass_->fetch_results (self, media_object, _callback_, _user_data_);
	}
}

RygelMediaObjects*
rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	RygelMediaQueryActionClass* _klass_;
	_klass_ = RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self);
	if (_klass_->fetch_results_finish) {
		return _klass_->fetch_results_finish (self, _res_, error);
	}
	return NULL;
}

static void
rygel_media_query_action_fetch_media_object_data_free (gpointer _data)
{
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaQueryActionFetchMediaObjectData, _data_);
}

static void
rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	RygelMediaQueryAction* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelMediaQueryActionFetchMediaObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_query_action_fetch_media_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_query_action_fetch_media_object_co (_data_);
}

static RygelMediaObject*
rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	RygelMediaObject* result;
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_media_query_action_fetch_media_object_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_query_action_fetch_media_object_co (_data_);
}

static gboolean
rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->object_id;
	_data_->_tmp1_ = _data_->self->root_container;
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (g_strcmp0 (_data_->_tmp0_, _data_->_tmp3_) == 0) {
		_data_->_tmp4_ = _data_->self->root_container;
		_data_->_tmp5_ = _g_object_ref0 ((RygelMediaObject*) _data_->_tmp4_);
		_data_->result = _data_->_tmp5_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp6_ = _data_->self->object_id;
		g_debug ("rygel-media-query-action.vala:188: searching for object '%s'..", _data_->_tmp6_);
		_data_->_tmp7_ = _data_->self->root_container;
		_data_->_tmp8_ = _data_->self->object_id;
		_data_->_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_state_ = 1;
		rygel_media_container_find_object (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp10_, rygel_media_query_action_fetch_media_object_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = rygel_media_container_find_object_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		_data_->media_object = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = _data_->media_object;
		if (_data_->_tmp12_ == NULL) {
			_data_->_tmp13_ = _data_->self->object_id_arg;
			if (g_strcmp0 (_data_->_tmp13_, "ObjectID") == 0) {
				_data_->_tmp14_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("No such object"));
				_data_->_inner_error0_ = _data_->_tmp14_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_tmp15_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER, _ ("No such container"));
				_data_->_inner_error0_ = _data_->_tmp15_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp16_ = _data_->self->object_id;
		g_debug ("rygel-media-query-action.vala:200: object '%s' found.", _data_->_tmp16_);
		_data_->result = _data_->media_object;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
rygel_media_query_action_conclude (RygelMediaQueryAction* self)
{
	RygelSerializer* _tmp0_;
	const gchar* _tmp1_;
	gchar* didl = NULL;
	RygelSerializer* _tmp2_;
	gchar* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->serializer;
	_tmp1_ = self->filter;
	rygel_serializer_filter (_tmp0_, _tmp1_);
	_tmp2_ = self->serializer;
	_tmp3_ = rygel_serializer_get_string (_tmp2_);
	didl = _tmp3_;
	if (self->update_id == ((guint) G_MAXUINT32)) {
		self->update_id = (guint) self->system_update_id;
	}
	_tmp4_ = self->action;
	_tmp5_ = didl;
	gupnp_service_action_set (_tmp4_, "Result", G_TYPE_STRING, _tmp5_, "NumberReturned", G_TYPE_UINT, self->number_returned, "TotalMatches", G_TYPE_UINT, self->total_matches, "UpdateID", G_TYPE_UINT, self->update_id, NULL);
	_tmp6_ = self->action;
	gupnp_service_action_return_success (_tmp6_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}

static void
rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self,
                                            GError* _error_)
{
	g_return_if_fail (_error_ != NULL);
	if (_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		GUPnPServiceAction* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->action;
		_tmp1_ = _error_->message;
		gupnp_service_action_return_error (_tmp0_, (guint) _error_->code, _tmp1_);
	} else {
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->action;
		_tmp3_ = _error_->message;
		gupnp_service_action_return_error (_tmp2_, (guint) 701, _tmp3_);
	}
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}

void
rygel_media_query_action_handle_error (RygelMediaQueryAction* self,
                                       GError* _error_)
{
	RygelMediaQueryActionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self);
	if (_klass_->handle_error) {
		_klass_->handle_error (self, _error_);
	}
}

static GCancellable*
rygel_media_query_action_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_;
	self = (RygelMediaQueryAction*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_media_query_action_real_set_cancellable (RygelStateMachine* base,
                                               GCancellable* value)
{
	RygelMediaQueryAction* self;
	GCancellable* old_value;
	self = (RygelMediaQueryAction*) base;
	old_value = rygel_media_query_action_real_get_cancellable (base);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_query_action_properties[RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_media_query_action_class_init (RygelMediaQueryActionClass * klass,
                                     gpointer klass_data)
{
	rygel_media_query_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaQueryAction_private_offset);
	((RygelMediaQueryActionClass *) klass)->parse_args = (void (*) (RygelMediaQueryAction*, GError**)) rygel_media_query_action_real_parse_args;
	((RygelMediaQueryActionClass *) klass)->handle_error = (void (*) (RygelMediaQueryAction*, GError*)) rygel_media_query_action_real_handle_error;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_query_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_query_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_query_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE_PROPERTY, rygel_media_query_action_properties[RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_media_query_action_rygel_state_machine_interface_init (RygelStateMachineIface * iface,
                                                             gpointer iface_data)
{
	rygel_media_query_action_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_media_query_action_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_media_query_action_run_finish;
	iface->get_cancellable = rygel_media_query_action_real_get_cancellable;
	iface->set_cancellable = rygel_media_query_action_real_set_cancellable;
}

static void
rygel_media_query_action_instance_init (RygelMediaQueryAction * self,
                                        gpointer klass)
{
	self->priv = rygel_media_query_action_get_instance_private (self);
}

static void
rygel_media_query_action_finalize (GObject * obj)
{
	RygelMediaQueryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
	_g_free0 (self->object_id);
	_g_free0 (self->browse_flag);
	_g_free0 (self->filter);
	_g_free0 (self->sort_criteria);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->http_server);
	__vala_GUPnPServiceAction_free0 (self->action);
	_g_object_unref0 (self->serializer);
	_g_object_unref0 (self->hacks);
	_g_free0 (self->object_id_arg);
	G_OBJECT_CLASS (rygel_media_query_action_parent_class)->finalize (obj);
}

/**
 * Base class of Browse and Search actions.
 */
 G_GNUC_NO_INLINE static GType
rygel_media_query_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaQueryActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_query_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaQueryAction), 0, (GInstanceInitFunc) rygel_media_query_action_instance_init, NULL };
	static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_query_action_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_media_query_action_type_id;
	rygel_media_query_action_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaQueryAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (rygel_media_query_action_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	RygelMediaQueryAction_private_offset = g_type_add_instance_private (rygel_media_query_action_type_id, sizeof (RygelMediaQueryActionPrivate));
	return rygel_media_query_action_type_id;
}

GType
rygel_media_query_action_get_type (void)
{
	static volatile gsize rygel_media_query_action_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_query_action_type_id__once)) {
		GType rygel_media_query_action_type_id;
		rygel_media_query_action_type_id = rygel_media_query_action_get_type_once ();
		g_once_init_leave (&rygel_media_query_action_type_id__once, rygel_media_query_action_type_id);
	}
	return rygel_media_query_action_type_id__once;
}

static void
_vala_rygel_media_query_action_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	RygelMediaQueryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
	switch (property_id) {
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_query_action_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	RygelMediaQueryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
	switch (property_id) {
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

