/* rygel-reference-creator.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-reference-creator.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-server.h"
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define RYGEL_TYPE_REFERENCE_CREATOR (rygel_reference_creator_get_type ())
#define RYGEL_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator))
#define RYGEL_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))
#define RYGEL_IS_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_IS_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_REFERENCE_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))

typedef struct _RygelReferenceCreator RygelReferenceCreator;
typedef struct _RygelReferenceCreatorClass RygelReferenceCreatorClass;
typedef struct _RygelReferenceCreatorPrivate RygelReferenceCreatorPrivate;
enum  {
	RYGEL_REFERENCE_CREATOR_0_PROPERTY,
	RYGEL_REFERENCE_CREATOR_CANCELLABLE_PROPERTY,
	RYGEL_REFERENCE_CREATOR_NUM_PROPERTIES
};
static GParamSpec* rygel_reference_creator_properties[RYGEL_REFERENCE_CREATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CONTENT_DIRECTORY_ERROR (rygel_content_directory_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelReferenceCreatorRunData RygelReferenceCreatorRunData;
typedef struct _RygelReferenceCreatorFetchContainerData RygelReferenceCreatorFetchContainerData;

struct _RygelReferenceCreator {
	GObject parent_instance;
	RygelReferenceCreatorPrivate * priv;
	gchar* container_id;
	gchar* object_id;
};

struct _RygelReferenceCreatorClass {
	GObjectClass parent_class;
};

struct _RygelReferenceCreatorPrivate {
	RygelContentDirectory* content_directory;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()

struct _RygelReferenceCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelReferenceCreator* self;
	RygelMediaContainer* root_container;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaObject* object;
	RygelMediaContainer* _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	RygelMediaObject* _tmp7_;
	RygelMediaObject* _tmp8_;
	GError* _tmp9_;
	RygelWritableContainer* container;
	RygelWritableContainer* _tmp10_;
	gchar* new_id;
	RygelWritableContainer* _tmp11_;
	RygelMediaObject* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	gchar* _tmp15_;
	GUPnPServiceAction* _tmp16_;
	const gchar* _tmp17_;
	GUPnPServiceAction* _tmp18_;
	GError* _error_;
	GError* _tmp19_;
	GUPnPServiceAction* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GUPnPServiceAction* _tmp24_;
	GError* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError* _inner_error0_;
};

struct _RygelReferenceCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelReferenceCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	RygelMediaContainer* root_container;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelMediaContainer* _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObject* _tmp8_;
	RygelMediaObject* _tmp9_;
	gboolean _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	GError* _tmp13_;
	RygelMediaObject* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	RygelMediaObject* _tmp19_;
	RygelWritableContainer* _tmp20_;
	GError* _inner_error0_;
};

static gint RygelReferenceCreator_private_offset;
static gpointer rygel_reference_creator_parent_class = NULL;
static RygelStateMachineIface * rygel_reference_creator_rygel_state_machine_parent_iface = NULL;

VALA_EXTERN GType rygel_reference_creator_get_type (void) G_GNUC_CONST ;
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
VALA_EXTERN RygelReferenceCreator* rygel_reference_creator_new (RygelContentDirectory* content_dir,
                                                    GUPnPServiceAction* action);
VALA_EXTERN RygelReferenceCreator* rygel_reference_creator_construct (GType object_type,
                                                          RygelContentDirectory* content_dir,
                                                          GUPnPServiceAction* action);
VALA_EXTERN void rygel_reference_creator_parse_arguments (RygelReferenceCreator* self,
                                              GError** error);
VALA_EXTERN GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_error_get_type (void) G_GNUC_CONST ;
static void rygel_reference_creator_real_run_data_free (gpointer _data);
static void rygel_reference_creator_real_run (RygelStateMachine* base,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean rygel_reference_creator_real_run_co (RygelReferenceCreatorRunData* _data_);
static void rygel_reference_creator_run_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void rygel_reference_creator_fetch_container (RygelReferenceCreator* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static RygelWritableContainer* rygel_reference_creator_fetch_container_finish (RygelReferenceCreator* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error);
static void rygel_reference_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_reference_creator_fetch_container_co (RygelReferenceCreatorFetchContainerData* _data_);
static void rygel_reference_creator_fetch_container_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void rygel_reference_creator_finalize (GObject * obj);
static GType rygel_reference_creator_get_type_once (void);
static void _vala_rygel_reference_creator_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_rygel_reference_creator_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_reference_creator_get_instance_private (RygelReferenceCreator* self)
{
	return G_STRUCT_MEMBER_P (self, RygelReferenceCreator_private_offset);
}

static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelReferenceCreator*
rygel_reference_creator_construct (GType object_type,
                                   RygelContentDirectory* content_dir,
                                   GUPnPServiceAction* action)
{
	RygelReferenceCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	GCancellable* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelReferenceCreator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (content_dir);
	_g_object_unref0 (self->priv->content_directory);
	self->priv->content_directory = _tmp0_;
	_tmp1_ = content_dir->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_tmp2_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = _tmp2_;
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}

RygelReferenceCreator*
rygel_reference_creator_new (RygelContentDirectory* content_dir,
                             GUPnPServiceAction* action)
{
	return rygel_reference_creator_construct (RYGEL_TYPE_REFERENCE_CREATOR, content_dir, action);
}

void
rygel_reference_creator_parse_arguments (RygelReferenceCreator* self,
                                         GError** error)
{
	GUPnPServiceAction* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action;
	gupnp_service_action_get (_tmp0_, "ContainerID", G_TYPE_STRING, &_tmp1_, "ObjectID", G_TYPE_STRING, &_tmp2_, NULL);
	_g_free0 (self->container_id);
	self->container_id = _tmp1_;
	_g_free0 (self->object_id);
	self->object_id = _tmp2_;
	_tmp3_ = self->container_id;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("“ContainerID” agument missing."));
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp5_ = self->object_id;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("“ObjectID” argument missing."));
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
rygel_reference_creator_real_run_data_free (gpointer _data)
{
	RygelReferenceCreatorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelReferenceCreatorRunData, _data_);
}

static void
rygel_reference_creator_real_run (RygelStateMachine* base,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	RygelReferenceCreator * self;
	RygelReferenceCreatorRunData* _data_;
	RygelReferenceCreator* _tmp0_;
	self = (RygelReferenceCreator*) base;
	_data_ = g_slice_new0 (RygelReferenceCreatorRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_reference_creator_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_reference_creator_real_run_co (_data_);
}

static void
rygel_reference_creator_run_finish (RygelStateMachine* base,
                                    GAsyncResult* _res_)
{
	RygelReferenceCreatorRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_reference_creator_run_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	RygelReferenceCreatorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_reference_creator_real_run_co (_data_);
}

static gboolean
rygel_reference_creator_real_run_co (RygelReferenceCreatorRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		rygel_reference_creator_parse_arguments (_data_->self, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp0_ = _data_->self->priv->content_directory;
		_data_->_tmp1_ = _data_->_tmp0_->root_container;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->root_container = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->root_container;
		_data_->_tmp4_ = _data_->self->object_id;
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 1;
		rygel_media_container_find_object (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp6_, rygel_reference_creator_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = rygel_media_container_find_object_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->object = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->root_container);
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->object;
		if (_data_->_tmp8_ == NULL) {
			_data_->_tmp9_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("No such object"));
			_data_->_inner_error0_ = _data_->_tmp9_;
			_g_object_unref0 (_data_->object);
			_g_object_unref0 (_data_->root_container);
			goto __catch0_g_error;
		}
		_data_->_state_ = 2;
		rygel_reference_creator_fetch_container (_data_->self, rygel_reference_creator_run_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp10_ = rygel_reference_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->container = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->object);
			_g_object_unref0 (_data_->root_container);
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = _data_->container;
		_data_->_tmp12_ = _data_->object;
		_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_state_ = 3;
		rygel_writable_container_add_reference (_data_->_tmp11_, _data_->_tmp12_, _data_->_tmp14_, rygel_reference_creator_run_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp15_ = rygel_writable_container_add_reference_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
		_data_->new_id = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->container);
			_g_object_unref0 (_data_->object);
			_g_object_unref0 (_data_->root_container);
			goto __catch0_g_error;
		}
		_data_->_tmp16_ = _data_->self->priv->action;
		_data_->_tmp17_ = _data_->new_id;
		gupnp_service_action_set (_data_->_tmp16_, "NewID", G_TYPE_STRING, _data_->_tmp17_, NULL);
		_data_->_tmp18_ = _data_->self->priv->action;
		gupnp_service_action_return_success (_data_->_tmp18_);
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		_g_free0 (_data_->new_id);
		_g_object_unref0 (_data_->container);
		_g_object_unref0 (_data_->object);
		_g_object_unref0 (_data_->root_container);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->_error_;
		if (_data_->_tmp19_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			_data_->_tmp20_ = _data_->self->priv->action;
			_data_->_tmp21_ = _data_->_error_;
			_data_->_tmp22_ = _data_->_error_;
			_data_->_tmp23_ = _data_->_tmp22_->message;
			gupnp_service_action_return_error (_data_->_tmp20_, (guint) _data_->_tmp21_->code, _data_->_tmp23_);
		} else {
			_data_->_tmp24_ = _data_->self->priv->action;
			_data_->_tmp25_ = _data_->_error_;
			_data_->_tmp26_ = _data_->_tmp25_->message;
			gupnp_service_action_return_error (_data_->_tmp24_, (guint) 402, _data_->_tmp26_);
		}
		_data_->_tmp27_ = _data_->self->container_id;
		_data_->_tmp28_ = _data_->_error_;
		_data_->_tmp29_ = _data_->_tmp28_->message;
		g_warning (_ ("Failed to create object under “%s”: %s"), _data_->_tmp27_, _data_->_tmp29_);
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		_g_error_free0 (_data_->_error_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_reference_creator_fetch_container_data_free (gpointer _data)
{
	RygelReferenceCreatorFetchContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelReferenceCreatorFetchContainerData, _data_);
}

static void
rygel_reference_creator_fetch_container (RygelReferenceCreator* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	RygelReferenceCreatorFetchContainerData* _data_;
	RygelReferenceCreator* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelReferenceCreatorFetchContainerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_reference_creator_fetch_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_reference_creator_fetch_container_co (_data_);
}

static RygelWritableContainer*
rygel_reference_creator_fetch_container_finish (RygelReferenceCreator* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	RygelWritableContainer* result;
	RygelReferenceCreatorFetchContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Get the container to create the item in.
     *
     * This will either try to fetch the container supplied by the caller or
     * search for a container if the caller supplied the "DLNA.ORG_AnyContainer"
     * id.
     *
     * @return an instance of WritableContainer matching the criteria
     * @throws ContentDirectoryError for various problems
     */
static void
rygel_reference_creator_fetch_container_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	RygelReferenceCreatorFetchContainerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_reference_creator_fetch_container_co (_data_);
}

static gboolean
rygel_reference_creator_fetch_container_co (RygelReferenceCreatorFetchContainerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->media_object = NULL;
	_data_->_tmp0_ = _data_->self->priv->content_directory;
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->root_container = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->root_container;
	_data_->_tmp5_ = _data_->self->container_id;
	_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_state_ = 1;
	rygel_media_container_find_object (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_, rygel_reference_creator_fetch_container_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = rygel_media_container_find_object_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp3_ = _data_->_tmp8_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->root_container);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->_tmp3_;
	_data_->_tmp3_ = NULL;
	_g_object_unref0 (_data_->media_object);
	_data_->media_object = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->media_object;
	if (_data_->_tmp11_ == NULL) {
		_data_->_tmp10_ = TRUE;
	} else {
		_data_->_tmp12_ = _data_->media_object;
		_data_->_tmp10_ = !RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp12_);
	}
	if (_data_->_tmp10_) {
		_data_->_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER, _ ("No such object"));
		_data_->_inner_error0_ = _data_->_tmp13_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->root_container);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp14_ = _data_->media_object;
		if (!RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp14_)) {
			_data_->_tmp15_ = _data_->media_object;
			_data_->_tmp16_ = rygel_media_object_get_id (_data_->_tmp15_);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_tmp18_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _ ("Object creation in %s not allowed"), _data_->_tmp17_);
			_data_->_inner_error0_ = _data_->_tmp18_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->_tmp3_);
			_g_object_unref0 (_data_->root_container);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp19_ = _data_->media_object;
	_data_->_tmp20_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp19_) ? ((RygelWritableContainer*) _data_->_tmp19_) : NULL);
	_data_->result = _data_->_tmp20_;
	_g_object_unref0 (_data_->_tmp3_);
	_g_object_unref0 (_data_->root_container);
	_g_object_unref0 (_data_->media_object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GCancellable*
rygel_reference_creator_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelReferenceCreator* self;
	GCancellable* _tmp0_;
	self = (RygelReferenceCreator*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_reference_creator_real_set_cancellable (RygelStateMachine* base,
                                              GCancellable* value)
{
	RygelReferenceCreator* self;
	GCancellable* old_value;
	self = (RygelReferenceCreator*) base;
	old_value = rygel_reference_creator_real_get_cancellable (base);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_reference_creator_properties[RYGEL_REFERENCE_CREATOR_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_reference_creator_class_init (RygelReferenceCreatorClass * klass,
                                    gpointer klass_data)
{
	rygel_reference_creator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelReferenceCreator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_reference_creator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_reference_creator_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_reference_creator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_REFERENCE_CREATOR_CANCELLABLE_PROPERTY, rygel_reference_creator_properties[RYGEL_REFERENCE_CREATOR_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_reference_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface,
                                                            gpointer iface_data)
{
	rygel_reference_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_reference_creator_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_reference_creator_run_finish;
	iface->get_cancellable = rygel_reference_creator_real_get_cancellable;
	iface->set_cancellable = rygel_reference_creator_real_set_cancellable;
}

static void
rygel_reference_creator_instance_init (RygelReferenceCreator * self,
                                       gpointer klass)
{
	self->priv = rygel_reference_creator_get_instance_private (self);
}

static void
rygel_reference_creator_finalize (GObject * obj)
{
	RygelReferenceCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator);
	_g_object_unref0 (self->priv->content_directory);
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	_g_object_unref0 (self->priv->_cancellable);
	_g_free0 (self->container_id);
	_g_free0 (self->object_id);
	G_OBJECT_CLASS (rygel_reference_creator_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_reference_creator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelReferenceCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_reference_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelReferenceCreator), 0, (GInstanceInitFunc) rygel_reference_creator_instance_init, NULL };
	static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_reference_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_reference_creator_type_id;
	rygel_reference_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelReferenceCreator", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_reference_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	RygelReferenceCreator_private_offset = g_type_add_instance_private (rygel_reference_creator_type_id, sizeof (RygelReferenceCreatorPrivate));
	return rygel_reference_creator_type_id;
}

GType
rygel_reference_creator_get_type (void)
{
	static volatile gsize rygel_reference_creator_type_id__once = 0;
	if (g_once_init_enter (&rygel_reference_creator_type_id__once)) {
		GType rygel_reference_creator_type_id;
		rygel_reference_creator_type_id = rygel_reference_creator_get_type_once ();
		g_once_init_leave (&rygel_reference_creator_type_id__once, rygel_reference_creator_type_id);
	}
	return rygel_reference_creator_type_id__once;
}

static void
_vala_rygel_reference_creator_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	RygelReferenceCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator);
	switch (property_id) {
		case RYGEL_REFERENCE_CREATOR_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_reference_creator_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	RygelReferenceCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator);
	switch (property_id) {
		case RYGEL_REFERENCE_CREATOR_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

