/* rygel-seek-hacks.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-seek-hacks.vala, do not modify */

/*
 * Copyright (C) 2013 Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <libsoup/soup.h>

#define RYGEL_SEEK_HACKS_AGENT ".*Mediabolic-IMHTTP.*|" ".*PLAYSTATION 3.*|" ".*SHARP-AQUOS-DMP.*|" ".*alphanetworks.*|" ".*KnOS/3.2.*"

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_SEEK_HACKS (rygel_seek_hacks_get_type ())
#define RYGEL_SEEK_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEEK_HACKS, RygelSeekHacks))
#define RYGEL_SEEK_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEEK_HACKS, RygelSeekHacksClass))
#define RYGEL_IS_SEEK_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEEK_HACKS))
#define RYGEL_IS_SEEK_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEEK_HACKS))
#define RYGEL_SEEK_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEEK_HACKS, RygelSeekHacksClass))

typedef struct _RygelSeekHacks RygelSeekHacks;
typedef struct _RygelSeekHacksClass RygelSeekHacksClass;
typedef struct _RygelSeekHacksPrivate RygelSeekHacksPrivate;
enum  {
	RYGEL_SEEK_HACKS_0_PROPERTY,
	RYGEL_SEEK_HACKS_NUM_PROPERTIES
};
static GParamSpec* rygel_seek_hacks_properties[RYGEL_SEEK_HACKS_NUM_PROPERTIES];

#define RYGEL_TYPE_CLIENT_HACKS_ERROR (rygel_client_hacks_error_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaObject* object);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar** sort_criteria);
	gboolean (*force_seek) (RygelClientHacks* self);
	void (*modify_headers) (RygelClientHacks* self, RygelHTTPRequest* request);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelSeekHacks {
	RygelClientHacks parent_instance;
	RygelSeekHacksPrivate * priv;
};

struct _RygelSeekHacksClass {
	RygelClientHacksClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_seek_hacks_parent_class = NULL;

VALA_EXTERN GType rygel_client_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_query_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_seek_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
VALA_EXTERN GQuark rygel_client_hacks_error_quark (void);
GType rygel_client_hacks_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelSeekHacks* rygel_seek_hacks_new (SoupServerMessage* message,
                                      GError** error);
VALA_EXTERN RygelSeekHacks* rygel_seek_hacks_construct (GType object_type,
                                            SoupServerMessage* message,
                                            GError** error);
VALA_EXTERN RygelClientHacks* rygel_client_hacks_construct (GType object_type,
                                                const gchar* agent,
                                                SoupServerMessage* message,
                                                GError** error);
static gboolean rygel_seek_hacks_real_force_seek (RygelClientHacks* base);
static GType rygel_seek_hacks_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

RygelSeekHacks*
rygel_seek_hacks_construct (GType object_type,
                            SoupServerMessage* message,
                            GError** error)
{
	RygelSeekHacks * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (RygelSeekHacks*) rygel_client_hacks_construct (object_type, RYGEL_SEEK_HACKS_AGENT, message, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

RygelSeekHacks*
rygel_seek_hacks_new (SoupServerMessage* message,
                      GError** error)
{
	return rygel_seek_hacks_construct (RYGEL_TYPE_SEEK_HACKS, message, error);
}

static gboolean
rygel_seek_hacks_real_force_seek (RygelClientHacks* base)
{
	RygelSeekHacks * self;
	gboolean result;
	self = (RygelSeekHacks*) base;
	result = TRUE;
	return result;
}

static void
rygel_seek_hacks_class_init (RygelSeekHacksClass * klass,
                             gpointer klass_data)
{
	rygel_seek_hacks_parent_class = g_type_class_peek_parent (klass);
	((RygelClientHacksClass *) klass)->force_seek = (gboolean (*) (RygelClientHacks*)) rygel_seek_hacks_real_force_seek;
}

static void
rygel_seek_hacks_instance_init (RygelSeekHacks * self,
                                gpointer klass)
{
}

/**
 * Hacks class to accept seeks that are invalid according to DLNA.
 *
 * Some devices always request the full range on a non-seekable stream, be it
 * transcoded or live, regardless of what DLNA.ORG_OP says. This hack just
 * accepts this seek request.
 *
 * Supported devices are:
 *  - Onkyo (Mediabolic-IMHTTP)
 *  - PS3
 *  - Sharp TVs
 *  - WD TV Live (alphanetworks)
 *  - Musical Fidelity/Marantz devices (KnOS/3.2)
 *
 * Samsung devices are also affected but they need other hacks as well to
 * that's handled in the Samsung-specific class.
 */
 G_GNUC_NO_INLINE static GType
rygel_seek_hacks_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelSeekHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_seek_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSeekHacks), 0, (GInstanceInitFunc) rygel_seek_hacks_instance_init, NULL };
	GType rygel_seek_hacks_type_id;
	rygel_seek_hacks_type_id = g_type_register_static (RYGEL_TYPE_CLIENT_HACKS, "RygelSeekHacks", &g_define_type_info, 0);
	return rygel_seek_hacks_type_id;
}

GType
rygel_seek_hacks_get_type (void)
{
	static volatile gsize rygel_seek_hacks_type_id__once = 0;
	if (g_once_init_enter (&rygel_seek_hacks_type_id__once)) {
		GType rygel_seek_hacks_type_id;
		rygel_seek_hacks_type_id = rygel_seek_hacks_get_type_once ();
		g_once_init_leave (&rygel_seek_hacks_type_id__once, rygel_seek_hacks_type_id);
	}
	return rygel_seek_hacks_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

