/* rygel-media-export-dvd-parser.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-media-export-dvd-parser.vala, do not modify */

/*
 * Copyright (C) 2013,2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include "mx-constants.h"
#include <libxml/xpath.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_PLAYLIST_CONTAINER_DVD "object.container.playlistContainer.DVD"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DVD_PARSER_ERROR (dvd_parser_error_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
typedef struct _RygelMediaExportExtractorPrivate RygelMediaExportExtractorPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER (rygel_media_export_dvd_parser_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParser))
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER))
#define RYGEL_MEDIA_EXPORT_IS_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER))
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserClass))

typedef struct _RygelMediaExportDVDParser RygelMediaExportDVDParser;
typedef struct _RygelMediaExportDVDParserClass RygelMediaExportDVDParserClass;
typedef struct _RygelMediaExportDVDParserPrivate RygelMediaExportDVDParserPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_DVD_PARSER_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_DVD_PARSER_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_dvd_parser_properties[RYGEL_MEDIA_EXPORT_DVD_PARSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _xmlXPathFreeObject0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeObject (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
typedef struct _RygelMediaExportDvdParserRunData RygelMediaExportDvdParserRunData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportDvdParserGetInformationData RygelMediaExportDvdParserGetInformationData;

typedef enum  {
	DVD_PARSER_ERROR_GENERAL,
	DVD_PARSER_ERROR_NOT_AVAILABLE
} DVDParserError;
#define DVD_PARSER_ERROR dvd_parser_error_quark ()

struct _RygelMediaExportExtractor {
	GObject parent_instance;
	RygelMediaExportExtractorPrivate * priv;
	GVariantDict* serialized_info;
};

struct _RygelMediaExportExtractorClass {
	GObjectClass parent_class;
	void (*run) (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportDVDParser {
	RygelMediaExportExtractor parent_instance;
	RygelMediaExportDVDParserPrivate * priv;
};

struct _RygelMediaExportDVDParserClass {
	RygelMediaExportExtractorClass parent_class;
};

struct _RygelMediaExportDVDParserPrivate {
	GFile* cache_file;
};

struct _RygelMediaExportDvdParserRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportDVDParser* self;
	const gchar* _tmp0_;
	GError* _tmp1_;
	xmlDoc* doc;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	GError* _tmp4_;
	GVariant* id;
	GVariantDict* _tmp5_;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	GVariant* uri;
	GVariantDict* _tmp8_;
	const GVariantType* _tmp9_;
	GVariant* _tmp10_;
	GUri* file_uri;
	GVariant* _tmp11_;
	const gchar* _tmp12_;
	GUri* _tmp13_;
	GVariantDict* _tmp14_;
	xmlXPathContext* context;
	xmlDoc* _tmp15_;
	xmlXPathContext* _tmp16_;
	xmlXPathObject* xpo;
	xmlXPathContext* _tmp17_;
	xmlXPathObject* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	xmlXPathObject* _tmp21_;
	xmlXPathObject* _tmp22_;
	xmlXPathObject* _tmp23_;
	xmlNodeSet* _tmp24_;
	GUri* new_uri;
	GUri* _tmp25_;
	GUri* _tmp26_;
	GVariantDict* _tmp27_;
	GVariantDict* _tmp28_;
	GVariant* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GVariantDict* _tmp35_;
	GVariantDict* _tmp36_;
	GUri* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	xmlNode* node;
	xmlXPathObject* _tmp40_;
	xmlNodeSet* _tmp41_;
	xmlNode* _tmp42_;
	xmlNode* it;
	xmlNode* _tmp43_;
	xmlNode* _tmp44_;
	xmlNode* _tmp45_;
	xmlNode* _tmp46_;
	const gchar* _tmp47_;
	gint duration;
	xmlNode* _tmp48_;
	xmlNode* _tmp49_;
	const gchar* _tmp50_;
	GVariantDict* _tmp51_;
	xmlNode* _tmp52_;
	const gchar* _tmp53_;
	gint width;
	xmlNode* _tmp54_;
	xmlNode* _tmp55_;
	const gchar* _tmp56_;
	GVariantDict* _tmp57_;
	xmlNode* _tmp58_;
	const gchar* _tmp59_;
	gint height;
	xmlNode* _tmp60_;
	xmlNode* _tmp61_;
	const gchar* _tmp62_;
	GVariantDict* _tmp63_;
	xmlNode* _tmp64_;
	const gchar* _tmp65_;
	gchar* dlna_profile;
	xmlNode* _tmp66_;
	xmlNode* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	GVariantDict* _tmp70_;
	const gchar* _tmp71_;
	xmlNode* _tmp72_;
	xmlNode* _tmp73_;
	GVariantDict* _tmp74_;
	GVariant* _tmp75_;
	const gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	GVariantDict* _tmp79_;
	GVariantDict* _tmp80_;
	xmlXPathObject* _tmp81_;
	xmlXPathObject* _tmp82_;
	xmlDoc* _tmp83_;
	GError* _inner_error0_;
};

struct _RygelMediaExportDvdParserGetInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportDVDParser* self;
	xmlDoc* result;
	GFile* _tmp0_;
	GSubprocessLauncher* launcher;
	GSubprocessLauncher* _tmp1_;
	GSubprocessLauncher* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** args;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint args_length1;
	gint _args_size_;
	GSubprocess* process;
	GSubprocessLauncher* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GSubprocess* _tmp18_;
	GSubprocess* _tmp19_;
	gboolean _tmp20_;
	GSubprocess* _tmp21_;
	GSubprocess* _tmp22_;
	GFile* _tmp23_;
	GError* _error_;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GError* _tmp26_;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	xmlDoc* _tmp30_;
	xmlDoc* _tmp31_;
	GError* _inner_error0_;
};

static gint RygelMediaExportDVDParser_private_offset;
static gpointer rygel_media_export_dvd_parser_parent_class = NULL;
static gchar* rygel_media_export_dvd_parser_lsdvd_binary_path;
static gchar* rygel_media_export_dvd_parser_lsdvd_binary_path = NULL;

VALA_EXTERN GQuark dvd_parser_error_quark (void);
GType dvd_parser_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportExtractor, g_object_unref)
VALA_EXTERN GType rygel_media_export_dvd_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportDVDParser, g_object_unref)
VALA_EXTERN void rygel_media_export_extractor_run (RygelMediaExportExtractor* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self,
                                              GAsyncResult* _res_,
                                              GError** error);
VALA_EXTERN RygelMediaExportDVDParser* rygel_media_export_dvd_parser_new (GFile* file);
VALA_EXTERN RygelMediaExportDVDParser* rygel_media_export_dvd_parser_construct (GType object_type,
                                                                    GFile* file);
VALA_EXTERN gchar* rygel_media_export_dvd_parser_get_cache_path (const gchar* image_path);
static void rygel_media_export_dvd_parser_real_constructed (GObject* base);
VALA_EXTERN GFile* rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self);
static void rygel_media_export_dvd_parser_real_run_data_free (gpointer _data);
static void rygel_media_export_dvd_parser_real_run (RygelMediaExportExtractor* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean rygel_media_export_dvd_parser_real_run_co (RygelMediaExportDvdParserRunData* _data_);
static void rygel_media_export_dvd_parser_run_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN void rygel_media_export_dvd_parser_get_information (RygelMediaExportDVDParser* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN xmlDoc* rygel_media_export_dvd_parser_get_information_finish (RygelMediaExportDVDParser* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static void rygel_media_export_dvd_parser_get_information_data_free (gpointer _data);
static gboolean rygel_media_export_dvd_parser_get_information_co (RygelMediaExportDvdParserGetInformationData* _data_);
static void rygel_media_export_dvd_parser_get_information_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void rygel_media_export_dvd_parser_finalize (GObject * obj);
static GType rygel_media_export_dvd_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GQuark
dvd_parser_error_quark (void)
{
	return g_quark_from_static_string ("dvd-parser-error-quark");
}

 G_GNUC_NO_INLINE static GType
dvd_parser_error_get_type_once (void)
{
	static const GEnumValue values[] = {{DVD_PARSER_ERROR_GENERAL, "DVD_PARSER_ERROR_GENERAL", "general"}, {DVD_PARSER_ERROR_NOT_AVAILABLE, "DVD_PARSER_ERROR_NOT_AVAILABLE", "not-available"}, {0, NULL, NULL}};
	GType dvd_parser_error_type_id;
	dvd_parser_error_type_id = g_enum_register_static ("DVDParserError", values);
	return dvd_parser_error_type_id;
}

GType
dvd_parser_error_get_type (void)
{
	static volatile gsize dvd_parser_error_type_id__once = 0;
	if (g_once_init_enter (&dvd_parser_error_type_id__once)) {
		GType dvd_parser_error_type_id;
		dvd_parser_error_type_id = dvd_parser_error_get_type_once ();
		g_once_init_leave (&dvd_parser_error_type_id__once, dvd_parser_error_type_id);
	}
	return dvd_parser_error_type_id__once;
}

static inline gpointer
rygel_media_export_dvd_parser_get_instance_private (RygelMediaExportDVDParser* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportDVDParser_private_offset);
}

RygelMediaExportDVDParser*
rygel_media_export_dvd_parser_construct (GType object_type,
                                         GFile* file)
{
	RygelMediaExportDVDParser * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (RygelMediaExportDVDParser*) g_object_new (object_type, "file", file, NULL);
	return self;
}

RygelMediaExportDVDParser*
rygel_media_export_dvd_parser_new (GFile* file)
{
	return rygel_media_export_dvd_parser_construct (RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, file);
}

gchar*
rygel_media_export_dvd_parser_get_cache_path (const gchar* image_path)
{
	const gchar* user_cache = NULL;
	const gchar* _tmp0_;
	gchar* id = NULL;
	gchar* _tmp1_;
	gchar* cache_folder = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (image_path != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	user_cache = _tmp0_;
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, image_path, (gsize) -1);
	id = _tmp1_;
	_tmp2_ = g_build_filename (user_cache, "rygel", "dvd-content", NULL);
	cache_folder = _tmp2_;
	g_mkdir_with_parents (cache_folder, 0700);
	_tmp3_ = g_build_filename (cache_folder, id, NULL);
	result = _tmp3_;
	_g_free0 (cache_folder);
	_g_free0 (id);
	return result;
}

static void
rygel_media_export_dvd_parser_real_constructed (GObject* base)
{
	RygelMediaExportDVDParser * self;
	gchar* path = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	self = (RygelMediaExportDVDParser*) base;
	G_OBJECT_CLASS (rygel_media_export_dvd_parser_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor));
	_tmp0_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_media_export_dvd_parser_get_cache_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	path = _tmp5_;
	_tmp6_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->cache_file);
	self->priv->cache_file = _tmp6_;
	_g_free0 (path);
}

static void
rygel_media_export_dvd_parser_real_run_data_free (gpointer _data)
{
	RygelMediaExportDvdParserRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportDvdParserRunData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_media_export_dvd_parser_real_run (RygelMediaExportExtractor* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RygelMediaExportDVDParser * self;
	RygelMediaExportDvdParserRunData* _data_;
	RygelMediaExportDVDParser* _tmp0_;
	self = (RygelMediaExportDVDParser*) base;
	_data_ = g_slice_new0 (RygelMediaExportDvdParserRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_dvd_parser_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_dvd_parser_real_run_co (_data_);
}

static void
rygel_media_export_dvd_parser_run_finish (RygelMediaExportExtractor* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	RygelMediaExportDvdParserRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_media_export_dvd_parser_run_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	RygelMediaExportDvdParserRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_dvd_parser_real_run_co (_data_);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gboolean
rygel_media_export_dvd_parser_real_run_co (RygelMediaExportDvdParserRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_dvd_parser_parent_class)->run (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), rygel_media_export_dvd_parser_run_ready, _data_);
	return FALSE;
	_state_1:
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_dvd_parser_parent_class)->run_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = rygel_media_export_dvd_parser_lsdvd_binary_path;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (DVD_PARSER_ERROR, DVD_PARSER_ERROR_NOT_AVAILABLE, "No DVD extractor found");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	rygel_media_export_dvd_parser_get_information (_data_->self, rygel_media_export_dvd_parser_run_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp2_ = rygel_media_export_dvd_parser_get_information_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->doc = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->doc;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = g_error_new_literal (DVD_PARSER_ERROR, DVD_PARSER_ERROR_GENERAL, "Failed to read cache file");
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	_data_->_tmp6_ = G_VARIANT_TYPE_STRING;
	_data_->_tmp7_ = g_variant_dict_lookup_value (_data_->_tmp5_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, _data_->_tmp6_);
	_data_->id = _data_->_tmp7_;
	_data_->_tmp8_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	_data_->_tmp9_ = G_VARIANT_TYPE_STRING;
	_data_->_tmp10_ = g_variant_dict_lookup_value (_data_->_tmp8_, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, _data_->_tmp9_);
	_data_->uri = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->uri;
	_data_->_tmp12_ = g_variant_get_string (_data_->_tmp11_, NULL);
	_data_->_tmp13_ = g_uri_parse (_data_->_tmp12_, G_URI_FLAGS_NONE, &_data_->_inner_error0_);
	_data_->file_uri = _data_->_tmp13_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->uri);
		_g_variant_unref0 (_data_->id);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	g_variant_dict_insert (_data_->_tmp14_, RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE, "i", -1, NULL);
	_data_->_tmp15_ = _data_->doc;
	_data_->_tmp16_ = xmlXPathNewContext (_data_->_tmp15_);
	_data_->context = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->context;
	_data_->_tmp18_ = xmlXPathEval ((xmlChar*) "/lsdvd/track", _data_->_tmp17_);
	_data_->xpo = _data_->_tmp18_;
	_data_->_tmp21_ = _data_->xpo;
	if (_data_->_tmp21_ != NULL) {
		_data_->_tmp22_ = _data_->xpo;
		_data_->_tmp20_ = _data_->_tmp22_->type == XPATH_NODESET;
	} else {
		_data_->_tmp20_ = FALSE;
	}
	if (_data_->_tmp20_) {
		_data_->_tmp23_ = _data_->xpo;
		_data_->_tmp24_ = _data_->_tmp23_->nodesetval;
		_data_->_tmp19_ = xmlXPathNodeSetGetLength (_data_->_tmp24_) == 1;
	} else {
		_data_->_tmp19_ = FALSE;
	}
	if (_data_->_tmp19_) {
		_data_->_tmp25_ = _data_->file_uri;
		_data_->_tmp26_ = soup_uri_copy (_data_->_tmp25_, SOUP_URI_SCHEME, "dvd", SOUP_URI_QUERY, "title=1", SOUP_URI_NONE, NULL);
		_data_->new_uri = _data_->_tmp26_;
		_data_->_tmp27_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp27_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", UPNP_CLASS_VIDEO, NULL);
		_data_->_tmp28_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp29_ = _data_->id;
		_data_->_tmp30_ = g_variant_get_string (_data_->_tmp29_, NULL);
		_data_->_tmp31_ = g_strconcat ("dvd-track:", _data_->_tmp30_, NULL);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = g_strconcat (_data_->_tmp32_, ":0", NULL);
		_data_->_tmp34_ = _data_->_tmp33_;
		g_variant_dict_insert (_data_->_tmp28_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, "s", _data_->_tmp34_, NULL);
		_g_free0 (_data_->_tmp34_);
		_g_free0 (_data_->_tmp32_);
		_data_->_tmp35_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp35_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", "video/mpeg", NULL);
		_data_->_tmp36_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp37_ = _data_->new_uri;
		_data_->_tmp38_ = g_uri_to_string (_data_->_tmp37_);
		_data_->_tmp39_ = _data_->_tmp38_;
		g_variant_dict_insert (_data_->_tmp36_, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, "s", _data_->_tmp39_, NULL);
		_g_free0 (_data_->_tmp39_);
		_data_->_tmp40_ = _data_->xpo;
		_data_->_tmp41_ = _data_->_tmp40_->nodesetval;
		_data_->_tmp42_ = xmlXPathNodeSetItem (_data_->_tmp41_, 0);
		_data_->node = _data_->_tmp42_;
		_data_->_tmp43_ = _data_->node;
		_data_->_tmp44_ = _data_->_tmp43_->children;
		_data_->it = _data_->_tmp44_;
		while (TRUE) {
			_data_->_tmp45_ = _data_->it;
			if (!(_data_->_tmp45_ != NULL)) {
				break;
			}
			_data_->_tmp46_ = _data_->it;
			_data_->_tmp47_ = _data_->_tmp46_->name;
			if (g_strcmp0 (_data_->_tmp47_, "length") == 0) {
				_data_->_tmp48_ = _data_->it;
				_data_->_tmp49_ = _data_->_tmp48_->children;
				_data_->_tmp50_ = _data_->_tmp49_->content;
				_data_->duration = (gint) double_parse (_data_->_tmp50_);
				_data_->_tmp51_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				g_variant_dict_insert (_data_->_tmp51_, RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION, "i", _data_->duration, NULL);
			} else {
				_data_->_tmp52_ = _data_->it;
				_data_->_tmp53_ = _data_->_tmp52_->name;
				if (g_strcmp0 (_data_->_tmp53_, "width") == 0) {
					_data_->_tmp54_ = _data_->it;
					_data_->_tmp55_ = _data_->_tmp54_->children;
					_data_->_tmp56_ = _data_->_tmp55_->content;
					_data_->width = atoi (_data_->_tmp56_);
					_data_->_tmp57_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
					g_variant_dict_insert (_data_->_tmp57_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH, "i", _data_->width, NULL);
				} else {
					_data_->_tmp58_ = _data_->it;
					_data_->_tmp59_ = _data_->_tmp58_->name;
					if (g_strcmp0 (_data_->_tmp59_, "height") == 0) {
						_data_->_tmp60_ = _data_->it;
						_data_->_tmp61_ = _data_->_tmp60_->children;
						_data_->_tmp62_ = _data_->_tmp61_->content;
						_data_->height = atoi (_data_->_tmp62_);
						_data_->_tmp63_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
						g_variant_dict_insert (_data_->_tmp63_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT, "i", _data_->height, NULL);
					} else {
						_data_->_tmp64_ = _data_->it;
						_data_->_tmp65_ = _data_->_tmp64_->name;
						if (g_strcmp0 (_data_->_tmp65_, "format") == 0) {
							_data_->_tmp66_ = _data_->it;
							_data_->_tmp67_ = _data_->_tmp66_->children;
							_data_->_tmp68_ = _data_->_tmp67_->content;
							_data_->_tmp69_ = g_strconcat ("MPEG_PS_", _data_->_tmp68_, NULL);
							_data_->dlna_profile = _data_->_tmp69_;
							_data_->_tmp70_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
							_data_->_tmp71_ = _data_->dlna_profile;
							g_variant_dict_insert (_data_->_tmp70_, RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE, "s", _data_->_tmp71_, NULL);
							_g_free0 (_data_->dlna_profile);
						}
					}
				}
			}
			_data_->_tmp72_ = _data_->it;
			_data_->_tmp73_ = _data_->_tmp72_->next;
			_data_->it = _data_->_tmp73_;
		}
		_g_uri_unref0 (_data_->new_uri);
	} else {
		_data_->_tmp74_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp75_ = _data_->id;
		_data_->_tmp76_ = g_variant_get_string (_data_->_tmp75_, NULL);
		_data_->_tmp77_ = g_strconcat ("dvd:", _data_->_tmp76_, NULL);
		_data_->_tmp78_ = _data_->_tmp77_;
		g_variant_dict_insert (_data_->_tmp74_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, "s", _data_->_tmp78_, NULL);
		_g_free0 (_data_->_tmp78_);
		_data_->_tmp79_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp79_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", UPNP_CLASS_PLAYLIST_CONTAINER_DVD, NULL);
		_data_->_tmp80_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp80_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", "application/x-cd-image", NULL);
	}
	_data_->_tmp81_ = _data_->xpo;
	if (_data_->_tmp81_ != NULL) {
		_data_->_tmp82_ = _data_->xpo;
		_xmlXPathFreeObject0 (_data_->_tmp82_);
	}
	_data_->_tmp83_ = _data_->doc;
	_xmlFreeDoc0 (_data_->_tmp83_);
	_xmlXPathFreeContext0 (_data_->context);
	_g_uri_unref0 (_data_->file_uri);
	_g_variant_unref0 (_data_->uri);
	_g_variant_unref0 (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_export_dvd_parser_get_information_data_free (gpointer _data)
{
	RygelMediaExportDvdParserGetInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportDvdParserGetInformationData, _data_);
}

void
rygel_media_export_dvd_parser_get_information (RygelMediaExportDVDParser* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelMediaExportDvdParserGetInformationData* _data_;
	RygelMediaExportDVDParser* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelMediaExportDvdParserGetInformationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_dvd_parser_get_information_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_dvd_parser_get_information_co (_data_);
}

xmlDoc*
rygel_media_export_dvd_parser_get_information_finish (RygelMediaExportDVDParser* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	xmlDoc* result;
	RygelMediaExportDvdParserGetInformationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_media_export_dvd_parser_get_information_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	RygelMediaExportDvdParserGetInformationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_dvd_parser_get_information_co (_data_);
}

static gboolean
rygel_media_export_dvd_parser_get_information_co (RygelMediaExportDvdParserGetInformationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cache_file;
	if (!g_file_query_exists (_data_->_tmp0_, NULL)) {
		_data_->_tmp1_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_STDERR_SILENCE);
		_data_->launcher = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->launcher;
		_data_->_tmp3_ = _data_->self->priv->cache_file;
		_data_->_tmp4_ = g_file_get_path (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		g_subprocess_launcher_set_stdout_file_path (_data_->_tmp2_, _data_->_tmp5_);
		_g_free0 (_data_->_tmp5_);
		_data_->_tmp6_ = rygel_media_export_dvd_parser_lsdvd_binary_path;
		_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
		_data_->_tmp8_ = g_strdup ("-Ox");
		_data_->_tmp9_ = g_strdup ("-a");
		_data_->_tmp10_ = g_strdup ("-v");
		_data_->_tmp11_ = g_strdup ("-q");
		_data_->_tmp12_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = g_file_get_path (_data_->_tmp13_);
		_data_->_tmp15_ = g_new0 (gchar*, 7 + 1);
		_data_->_tmp15_[0] = _data_->_tmp7_;
		_data_->_tmp15_[1] = _data_->_tmp8_;
		_data_->_tmp15_[2] = _data_->_tmp9_;
		_data_->_tmp15_[3] = _data_->_tmp10_;
		_data_->_tmp15_[4] = _data_->_tmp11_;
		_data_->_tmp15_[5] = _data_->_tmp14_;
		_data_->_tmp15_[6] = NULL;
		_data_->args = _data_->_tmp15_;
		_data_->args_length1 = 7;
		_data_->_args_size_ = _data_->args_length1;
		_data_->_tmp16_ = _data_->launcher;
		_data_->_tmp17_ = _data_->args;
		_data_->_tmp17__length1 = _data_->args_length1;
		_data_->_tmp18_ = g_subprocess_launcher_spawnv (_data_->_tmp16_, _data_->_tmp17_, &_data_->_inner_error0_);
		_data_->process = _data_->_tmp18_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp19_ = _data_->process;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp19_, NULL, rygel_media_export_dvd_parser_get_information_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->process);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp21_ = _data_->process;
		if (g_subprocess_get_if_exited (_data_->_tmp21_)) {
			_data_->_tmp22_ = _data_->process;
			_data_->_tmp20_ = g_subprocess_get_exit_status (_data_->_tmp22_) == 0;
		} else {
			_data_->_tmp20_ = FALSE;
		}
		if (!_data_->_tmp20_) {
			{
				_data_->_tmp23_ = _data_->self->priv->cache_file;
				g_file_delete (_data_->_tmp23_, NULL, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->_error_ = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp24_ = _data_->_error_;
				_data_->_tmp25_ = _data_->_tmp24_->message;
				g_debug ("rygel-media-export-dvd-parser.vala:174: Failed to delete cache file: %" \
"s", _data_->_tmp25_);
				_g_error_free0 (_data_->_error_);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->process);
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_data_->launcher);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp26_ = g_error_new_literal (DVD_PARSER_ERROR, DVD_PARSER_ERROR_GENERAL, "lsdvd did die or file is not a DVD");
			_data_->_inner_error0_ = _data_->_tmp26_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->process);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->process);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->launcher);
	}
	_data_->_tmp27_ = _data_->self->priv->cache_file;
	_data_->_tmp28_ = g_file_get_path (_data_->_tmp27_);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = xmlReadFile (_data_->_tmp29_, NULL, (gint) ((XML_PARSE_NOERROR | XML_PARSE_NOWARNING) | XML_PARSE_NONET));
	_data_->_tmp31_ = _data_->_tmp30_;
	_g_free0 (_data_->_tmp29_);
	_data_->result = _data_->_tmp31_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_export_dvd_parser_class_init (RygelMediaExportDVDParserClass * klass,
                                          gpointer klass_data)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	rygel_media_export_dvd_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportDVDParser_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_media_export_dvd_parser_real_constructed;
	((RygelMediaExportExtractorClass *) klass)->run = (void (*) (RygelMediaExportExtractor*, GAsyncReadyCallback, gpointer)) rygel_media_export_dvd_parser_real_run;
	((RygelMediaExportExtractorClass *) klass)->run_finish = (void (*) (RygelMediaExportExtractor*, GAsyncResult*, GError**)) rygel_media_export_dvd_parser_run_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_dvd_parser_finalize;
	_tmp0_ = g_find_program_in_path ("lsdvd");
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = g_strdup (_ ("Failed to find lsdvd binary in path. DVD extraction will not be availa" \
"ble"));
		msg = _tmp2_;
		_tmp3_ = msg;
		g_warning ("rygel-media-export-dvd-parser.vala:40: %s", _tmp3_);
		_g_free0 (msg);
	}
	_tmp4_ = path;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (rygel_media_export_dvd_parser_lsdvd_binary_path);
	rygel_media_export_dvd_parser_lsdvd_binary_path = _tmp5_;
	_g_free0 (path);
}

static void
rygel_media_export_dvd_parser_instance_init (RygelMediaExportDVDParser * self,
                                             gpointer klass)
{
	self->priv = rygel_media_export_dvd_parser_get_instance_private (self);
}

static void
rygel_media_export_dvd_parser_finalize (GObject * obj)
{
	RygelMediaExportDVDParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParser);
	_g_object_unref0 (self->priv->cache_file);
	G_OBJECT_CLASS (rygel_media_export_dvd_parser_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_media_export_dvd_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDVDParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_dvd_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDVDParser), 0, (GInstanceInitFunc) rygel_media_export_dvd_parser_instance_init, NULL };
	GType rygel_media_export_dvd_parser_type_id;
	rygel_media_export_dvd_parser_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, "RygelMediaExportDVDParser", &g_define_type_info, 0);
	RygelMediaExportDVDParser_private_offset = g_type_add_instance_private (rygel_media_export_dvd_parser_type_id, sizeof (RygelMediaExportDVDParserPrivate));
	return rygel_media_export_dvd_parser_type_id;
}

GType
rygel_media_export_dvd_parser_get_type (void)
{
	static volatile gsize rygel_media_export_dvd_parser_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_dvd_parser_type_id__once)) {
		GType rygel_media_export_dvd_parser_type_id;
		rygel_media_export_dvd_parser_type_id = rygel_media_export_dvd_parser_get_type_once ();
		g_once_init_leave (&rygel_media_export_dvd_parser_type_id__once, rygel_media_export_dvd_parser_type_id);
	}
	return rygel_media_export_dvd_parser_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

