/* rygel-media-export-extract.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-media-export-extract.vala, do not modify */

/*
 * Copyright (C) 2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gst/gst.h>
#include <unistd.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>

#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_PLAYLIST "object.item.playlistItem"
#define UPNP_CLASS_PLAYLIST_CONTAINER_DVD "object.container.playlistContainer.DVD"
#define UPNP_CLASS_DVD_TRACK UPNP_CLASS_VIDEO ".dvdTrack"
#define STATUS_LINE_TEMPLATE "RESULT|%s|%" G_GSIZE_FORMAT "|%s\n"
#define ERROR_LINE_TEMPLATE "ERROR|%s|%d|%s\n"
#define SKIPPED_LINE_TEMPLATE "SKIP|%s|-1|0\n"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_METADATA_EXTRACTOR_ERROR (metadata_extractor_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_DVD_PARSER_ERROR (dvd_parser_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RunData RunData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

typedef enum  {
	METADATA_EXTRACTOR_ERROR_GENERAL
} MetadataExtractorError;
#define METADATA_EXTRACTOR_ERROR metadata_extractor_error_quark ()

typedef enum  {
	DVD_PARSER_ERROR_GENERAL,
	DVD_PARSER_ERROR_NOT_AVAILABLE
} DVDParserError;
#define DVD_PARSER_ERROR dvd_parser_error_quark ()

struct _RunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* line;
	GDataInputStream* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* data;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** parts;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GFile* file;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	RygelMediaExportExtractor* extractor;
	GFile* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	RygelMediaExportExtractor* _tmp20_;
	RygelMediaExportExtractor* _tmp21_;
	GFile* _tmp22_;
	RygelMediaExportExtractor* _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	GError* _error_;
	GError* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	const gchar* _tmp32_;
	GError* _tmp33_;
	const gchar* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	const gchar* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	GError* _tmp39_;
	const gchar* _tmp40_;
	gchar* command;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	GError* _vala1__error_;
	GError* _tmp49_;
	const gchar* _tmp50_;
	GMainLoop* _tmp51_;
	GError* _inner_error0_;
};

VALA_EXTERN gint in_fd;
gint in_fd = 0;
VALA_EXTERN gint out_fd;
gint out_fd = 1;
VALA_EXTERN gboolean metadata;
gboolean metadata = FALSE;
VALA_EXTERN GMainLoop* loop;
GMainLoop* loop = NULL;
VALA_EXTERN GDataInputStream* input_stream;
GDataInputStream* input_stream = NULL;
VALA_EXTERN GOutputStream* output_stream;
GOutputStream* output_stream = NULL;

VALA_EXTERN GQuark metadata_extractor_error_quark (void);
GType metadata_extractor_error_get_type (void) G_GNUC_CONST ;
static void run_data_free (gpointer _data);
VALA_EXTERN void run (GAsyncReadyCallback _callback_,
          gpointer _user_data_);
VALA_EXTERN void run_finish (GAsyncResult* _res_);
static gboolean run_co (RunData* _data_);
static void run_ready (GObject* source_object,
                GAsyncResult* _res_,
                gpointer _user_data_);
VALA_EXTERN GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportExtractor, g_object_unref)
VALA_EXTERN RygelMediaExportExtractor* rygel_media_export_extractor_create_for_file (GFile* file,
                                                                         const gchar* content_type,
                                                                         gboolean extract_metadata);
VALA_EXTERN void rygel_media_export_extractor_run (RygelMediaExportExtractor* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self,
                                              GAsyncResult* _res_,
                                              GError** error);
VALA_EXTERN void send_extraction_done (GFile* file,
                           GVariant* v,
                           GError** error);
VALA_EXTERN GVariant* rygel_media_export_extractor_get (RygelMediaExportExtractor* self);
VALA_EXTERN GQuark dvd_parser_error_quark (void);
GType dvd_parser_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void send_skip (GFile* file);
VALA_EXTERN void send_error (GFile* file,
                 GError* err);
VALA_EXTERN gboolean vaapi_filter (GstPluginFeature* feature);
static gint _vala_main (gchar** args,
                 gint args_length1);
static gboolean _vaapi_filter_gst_plugin_feature_filter (GstPluginFeature* feature,
                                                  gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const GOptionEntry options[4] = {{"input-fd", 'i', (gint) 0, G_OPTION_ARG_INT, &in_fd, "File descriptor used for input", NULL}, {"output-fd", 'o', (gint) 0, G_OPTION_ARG_INT, &out_fd, "File descriptor used for output", NULL}, {"extract-metadata", 'm', (gint) 0, G_OPTION_ARG_NONE, &metadata, "Whether to extract all metadata from the files or just basic informati" \
"on", NULL}, {NULL}};

GQuark
metadata_extractor_error_quark (void)
{
	return g_quark_from_static_string ("metadata-extractor-error-quark");
}

 G_GNUC_NO_INLINE static GType
metadata_extractor_error_get_type_once (void)
{
	static const GEnumValue values[] = {{METADATA_EXTRACTOR_ERROR_GENERAL, "METADATA_EXTRACTOR_ERROR_GENERAL", "general"}, {0, NULL, NULL}};
	GType metadata_extractor_error_type_id;
	metadata_extractor_error_type_id = g_enum_register_static ("MetadataExtractorError", values);
	return metadata_extractor_error_type_id;
}

GType
metadata_extractor_error_get_type (void)
{
	static volatile gsize metadata_extractor_error_type_id__once = 0;
	if (g_once_init_enter (&metadata_extractor_error_type_id__once)) {
		GType metadata_extractor_error_type_id;
		metadata_extractor_error_type_id = metadata_extractor_error_get_type_once ();
		g_once_init_leave (&metadata_extractor_error_type_id__once, metadata_extractor_error_type_id);
	}
	return metadata_extractor_error_type_id__once;
}

static void
run_data_free (gpointer _data)
{
	RunData* _data_;
	_data_ = _data;
	g_slice_free (RunData, _data_);
}

void
run (GAsyncReadyCallback _callback_,
     gpointer _user_data_)
{
	RunData* _data_;
	_data_ = g_slice_new0 (RunData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, run_data_free);
	run_co (_data_);
}

void
run_finish (GAsyncResult* _res_)
{
	RunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
run_ready (GObject* source_object,
           GAsyncResult* _res_,
           gpointer _user_data_)
{
	RunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	run_co (_data_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
run_co (RunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		{
			_data_->_tmp0_ = input_stream;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, NULL, run_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = g_data_input_stream_read_line_finish (_data_->_tmp0_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->line = _data_->_tmp1_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp2_ = _data_->line;
			if (_data_->_tmp2_ == NULL) {
				_g_free0 (_data_->line);
				break;
			}
			_data_->_tmp3_ = _data_->line;
			if (g_str_has_prefix (_data_->_tmp3_, "EXTRACT ")) {
				_data_->_tmp4_ = _data_->line;
				g_debug ("rygel-media-export-extract.vala:69: Got command to extract file: %s", _data_->_tmp4_);
				_data_->_tmp5_ = _data_->line;
				_data_->_tmp6_ = string_replace (_data_->_tmp5_, "EXTRACT ", "");
				_data_->_tmp7_ = _data_->_tmp6_;
				_data_->_tmp8_ = string_strip (_data_->_tmp7_);
				_data_->_tmp9_ = _data_->_tmp8_;
				_g_free0 (_data_->_tmp7_);
				_data_->data = _data_->_tmp9_;
				_data_->_tmp10_ = _data_->data;
				_data_->_tmp12_ = _data_->_tmp11_ = g_strsplit (_data_->_tmp10_, "|", 0);
				_data_->parts = _data_->_tmp12_;
				_data_->parts_length1 = _vala_array_length (_data_->_tmp11_);
				_data_->_parts_size_ = _data_->parts_length1;
				_data_->_tmp13_ = _data_->parts;
				_data_->_tmp13__length1 = _data_->parts_length1;
				if (_data_->_tmp13__length1 != 2) {
					g_warning ("rygel-media-export-extract.vala:73: %s", _ ("Invalid command received, ignoring"));
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					continue;
				}
				{
					_data_->_tmp14_ = _data_->parts;
					_data_->_tmp14__length1 = _data_->parts_length1;
					_data_->_tmp15_ = _data_->_tmp14_[0];
					_data_->_tmp16_ = g_file_new_for_uri (_data_->_tmp15_);
					_data_->file = _data_->_tmp16_;
					_data_->_tmp17_ = _data_->file;
					_data_->_tmp18_ = _data_->parts;
					_data_->_tmp18__length1 = _data_->parts_length1;
					_data_->_tmp19_ = _data_->_tmp18_[1];
					_data_->_tmp20_ = rygel_media_export_extractor_create_for_file (_data_->_tmp17_, _data_->_tmp19_, metadata);
					_data_->extractor = _data_->_tmp20_;
					_data_->_tmp21_ = _data_->extractor;
					_data_->_state_ = 2;
					rygel_media_export_extractor_run (_data_->_tmp21_, run_ready, _data_);
					return FALSE;
					_state_2:
					rygel_media_export_extractor_run_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->extractor);
						_g_object_unref0 (_data_->file);
						goto __catch1_g_error;
					}
					_data_->_tmp22_ = _data_->file;
					_data_->_tmp23_ = _data_->extractor;
					_data_->_tmp24_ = rygel_media_export_extractor_get (_data_->_tmp23_);
					_data_->_tmp25_ = _data_->_tmp24_;
					send_extraction_done (_data_->_tmp22_, _data_->_tmp25_, &_data_->_inner_error0_);
					_g_variant_unref0 (_data_->_tmp25_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->extractor);
						_g_object_unref0 (_data_->file);
						goto __catch1_g_error;
					}
					_g_object_unref0 (_data_->extractor);
					_g_object_unref0 (_data_->file);
				}
				goto __finally1;
				__catch1_g_error:
				{
					_data_->_error_ = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp26_ = _data_->_error_;
					if (g_error_matches (_data_->_tmp26_, DVD_PARSER_ERROR, DVD_PARSER_ERROR_NOT_AVAILABLE)) {
						_data_->_tmp27_ = _data_->parts;
						_data_->_tmp27__length1 = _data_->parts_length1;
						_data_->_tmp28_ = _data_->_tmp27_[0];
						_data_->_tmp29_ = g_file_new_for_uri (_data_->_tmp28_);
						_data_->_tmp30_ = _data_->_tmp29_;
						send_skip (_data_->_tmp30_);
						_g_object_unref0 (_data_->_tmp30_);
					} else {
						_data_->_tmp31_ = _data_->parts;
						_data_->_tmp31__length1 = _data_->parts_length1;
						_data_->_tmp32_ = _data_->_tmp31_[0];
						_data_->_tmp33_ = _data_->_error_;
						_data_->_tmp34_ = _data_->_tmp33_->message;
						g_warning (_ ("Failed to discover URI %s: %s"), _data_->_tmp32_, _data_->_tmp34_);
						_data_->_tmp35_ = _data_->parts;
						_data_->_tmp35__length1 = _data_->parts_length1;
						_data_->_tmp36_ = _data_->_tmp35_[0];
						_data_->_tmp37_ = g_file_new_for_uri (_data_->_tmp36_);
						_data_->_tmp38_ = _data_->_tmp37_;
						_data_->_tmp39_ = _data_->_error_;
						send_error (_data_->_tmp38_, _data_->_tmp39_);
						_g_object_unref0 (_data_->_tmp38_);
					}
					_g_error_free0 (_data_->_error_);
				}
				__finally1:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					goto __catch0_g_error;
				}
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->data);
			} else {
				_data_->_tmp40_ = _data_->line;
				if (g_str_has_prefix (_data_->_tmp40_, "METADATA ")) {
					_data_->_tmp41_ = _data_->line;
					_data_->_tmp42_ = string_replace (_data_->_tmp41_, "METADATA ", "");
					_data_->_tmp43_ = _data_->_tmp42_;
					_data_->_tmp44_ = string_strip (_data_->_tmp43_);
					_data_->_tmp45_ = _data_->_tmp44_;
					_g_free0 (_data_->_tmp43_);
					_data_->command = _data_->_tmp45_;
					_data_->_tmp46_ = _data_->command;
					metadata = bool_parse (_data_->_tmp46_);
					if (metadata) {
						_data_->_tmp47_ = "enabled";
					} else {
						_data_->_tmp47_ = "disabled";
					}
					g_debug ("rygel-media-export-extract.vala:99: Meta-data extraction was %s", _data_->_tmp47_);
					_g_free0 (_data_->command);
				} else {
					_data_->_tmp48_ = _data_->line;
					if (g_str_has_prefix (_data_->_tmp48_, "QUIT")) {
						_g_free0 (_data_->line);
						break;
					}
				}
			}
			_g_free0 (_data_->line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_vala1__error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp49_ = _data_->_vala1__error_;
			_data_->_tmp50_ = _data_->_tmp49_->message;
			g_warning (_ ("Failed to read from pipe: %s"), _data_->_tmp50_);
			_g_error_free0 (_data_->_vala1__error_);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp51_ = loop;
	g_main_loop_quit (_data_->_tmp51_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
send_extraction_done (GFile* file,
                      GVariant* v,
                      GError** error)
{
	GBytes* data = NULL;
	GBytes* _tmp0_;
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GBytes* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GOutputStream* _tmp8_;
	const gchar* _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gsize _tmp13_ = 0UL;
	GOutputStream* _tmp14_;
	GBytes* _tmp15_;
	gsize _tmp16_ = 0;
	guint8* _tmp17_;
	gsize _tmp18_ = 0UL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = g_variant_get_data_as_bytes (v);
	data = _tmp0_;
	bytes_written = (gsize) 0;
	_tmp1_ = g_file_get_uri (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = data;
	_tmp4_ = g_file_get_uri (file);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (STATUS_LINE_TEMPLATE, _tmp2_, g_bytes_get_size (_tmp3_), _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	status = _tmp7_;
	_tmp8_ = output_stream;
	_tmp9_ = status;
	_tmp10_ = string_get_data (_tmp9_, &_tmp11_);
	_tmp10__length1 = _tmp11_;
	_tmp12_ = _tmp10_;
	_tmp12__length1 = _tmp10__length1;
	g_output_stream_write_all (_tmp8_, _tmp12_, (gsize) _tmp12__length1, &_tmp13_, NULL, &_inner_error0_);
	bytes_written = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_tmp14_ = output_stream;
	_tmp15_ = data;
	_tmp17_ = g_bytes_get_data (_tmp15_, &_tmp16_);
	g_output_stream_write_all (_tmp14_, _tmp17_, (gsize) _tmp16_, &_tmp18_, NULL, &_inner_error0_);
	bytes_written = _tmp18_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_g_free0 (status);
	_g_bytes_unref0 (data);
}

void
send_skip (GFile* file)
{
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (SKIPPED_LINE_TEMPLATE, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	status = _tmp3_;
	{
		GOutputStream* _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_ = 0;
		guint8* _tmp7_;
		gint _tmp7__length1;
		gsize _tmp8_ = 0UL;
		_tmp4_ = output_stream;
		_tmp5_ = string_get_data (status, &_tmp6_);
		_tmp5__length1 = _tmp6_;
		_tmp7_ = _tmp5_;
		_tmp7__length1 = _tmp5__length1;
		g_output_stream_write_all (_tmp4_, _tmp7_, (gsize) _tmp7__length1, &_tmp8_, NULL, &_inner_error0_);
		bytes_written = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = _error_;
		_tmp10_ = _tmp9_->message;
		g_warning (_ ("Failed to send error to parent: %s"), _tmp10_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (status);
}

void
send_error (GFile* file,
            GError* err)
{
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	g_return_if_fail (err != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = err->message;
	_tmp3_ = g_strdup_printf (ERROR_LINE_TEMPLATE, _tmp1_, err->code, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	status = _tmp4_;
	{
		GOutputStream* _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_ = 0;
		guint8* _tmp8_;
		gint _tmp8__length1;
		gsize _tmp9_ = 0UL;
		_tmp5_ = output_stream;
		_tmp6_ = string_get_data (status, &_tmp7_);
		_tmp6__length1 = _tmp7_;
		_tmp8_ = _tmp6_;
		_tmp8__length1 = _tmp6__length1;
		g_output_stream_write_all (_tmp5_, _tmp8_, (gsize) _tmp8__length1, &_tmp9_, NULL, &_inner_error0_);
		bytes_written = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning (_ ("Failed to send error to parent: %s"), _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (status);
}

gboolean
vaapi_filter (GstPluginFeature* feature)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (feature != NULL, FALSE);
	_tmp0_ = gst_object_get_name ((GstObject*) feature);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_prefix (_tmp1_, "vaapi");
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_vaapi_filter_gst_plugin_feature_filter (GstPluginFeature* feature,
                                         gpointer self)
{
	gboolean result;
	result = vaapi_filter (feature);
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	GOptionContext* ctx = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp8_;
	GstRegistry* _tmp9_;
	GList* features = NULL;
	GstRegistry* _tmp10_;
	GList* _tmp11_;
	GList* _tmp12_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GUnixInputStream* _tmp21_;
	GUnixInputStream* _tmp22_;
	GDataInputStream* _tmp23_;
	GUnixOutputStream* _tmp24_;
	GMainLoop* _tmp25_;
	GMainLoop* _tmp26_;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (_ ("— helper binary for Rygel to extract metadata"));
	ctx = _tmp0_;
	_tmp1_ = ctx;
	g_option_context_add_main_entries (_tmp1_, options, NULL);
	_tmp2_ = ctx;
	_tmp3_ = gst_init_get_option_group ();
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_;
		_tmp4_ = ctx;
		g_option_context_parse (_tmp4_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning (_ ("Failed to parse commandline args: %s"), _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (_error_);
		_g_option_context_free0 (ctx);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	if (nice (19) < 0) {
		g_debug ("rygel-media-export-extract.vala:170: Failed to reduce nice level of th" \
"umbnailer, continuing anyway");
	}
	_tmp8_ = gst_registry_get ();
	_tmp9_ = _g_object_ref0 (_tmp8_);
	registry = _tmp9_;
	_tmp10_ = registry;
	_tmp11_ = gst_registry_feature_filter (_tmp10_, _vaapi_filter_gst_plugin_feature_filter, FALSE, NULL);
	features = _tmp11_;
	_tmp12_ = features;
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
		feature_collection = _tmp12_;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GstPluginFeature* _tmp13_;
			GstPluginFeature* feature = NULL;
			_tmp13_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
			feature = _tmp13_;
			{
				GstPluginFeature* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GstRegistry* _tmp17_;
				GstPluginFeature* _tmp18_;
				_tmp14_ = feature;
				_tmp15_ = gst_object_get_name ((GstObject*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_debug ("rygel-media-export-extract.vala:176: Removing registry feature %s", _tmp16_);
				_g_free0 (_tmp16_);
				_tmp17_ = registry;
				_tmp18_ = feature;
				gst_registry_remove_feature (_tmp17_, _tmp18_);
				_g_object_unref0 (feature);
			}
		}
	}
	_tmp19_ = bool_to_string (metadata);
	_tmp20_ = _tmp19_;
	g_message ("rygel-media-export-extract.vala:180: Started with descriptors %d (in) " \
"%d (out), extracting meta-data: %s", in_fd, out_fd, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = (GUnixInputStream*) g_unix_input_stream_new (in_fd, TRUE);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_data_input_stream_new ((GInputStream*) _tmp22_);
	_g_object_unref0 (input_stream);
	input_stream = _tmp23_;
	_g_object_unref0 (_tmp22_);
	_tmp24_ = (GUnixOutputStream*) g_unix_output_stream_new (out_fd, TRUE);
	_g_object_unref0 (output_stream);
	output_stream = (GOutputStream*) _tmp24_;
	_tmp25_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp25_;
	run (NULL, NULL);
	_tmp26_ = loop;
	g_main_loop_run (_tmp26_);
	result = 0;
	(features == NULL) ? NULL : (features = (_g_list_free__g_object_unref0_ (features), NULL));
	_g_object_unref0 (registry);
	_g_option_context_free0 (ctx);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

