
/* GENERATED CODE... DO NOT EDIT */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Copyright (C) 2012 Lanedo GmbH
 * Copyright (C) 2012-2022 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "qmi-wds.h"
#include "qmi-enum-types.h"
#include "qmi-enum-types-private.h"
#include "qmi-flags64-types.h"
#include "qmi-error-types.h"
#include "qmi-device.h"
#include "qmi-helpers.h"

#define QMI_STATUS_SUCCESS 0x0000
#define QMI_STATUS_FAILURE 0x0001


typedef enum {
    QMI_MESSAGE_WDS_RESET = 0x0000,
    QMI_MESSAGE_WDS_SET_EVENT_REPORT = 0x0001,
    QMI_MESSAGE_WDS_ABORT = 0x0002,
    QMI_MESSAGE_WDS_INDICATION_REGISTER = 0x0003,
    QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES = 0x001E,
    QMI_MESSAGE_WDS_START_NETWORK = 0x0020,
    QMI_MESSAGE_WDS_STOP_NETWORK = 0x0021,
    QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS = 0x0022,
    QMI_MESSAGE_WDS_GET_CHANNEL_RATES = 0x0023,
    QMI_MESSAGE_WDS_GET_PACKET_STATISTICS = 0x0024,
    QMI_MESSAGE_WDS_GO_DORMANT = 0x0025,
    QMI_MESSAGE_WDS_GO_ACTIVE = 0x0026,
    QMI_MESSAGE_WDS_CREATE_PROFILE = 0x0027,
    QMI_MESSAGE_WDS_MODIFY_PROFILE = 0x0028,
    QMI_MESSAGE_WDS_DELETE_PROFILE = 0x0029,
    QMI_MESSAGE_WDS_GET_PROFILE_LIST = 0x002A,
    QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS = 0x002B,
    QMI_MESSAGE_WDS_GET_DEFAULT_SETTINGS = 0x002C,
    QMI_MESSAGE_WDS_GET_CURRENT_SETTINGS = 0x002D,
    QMI_MESSAGE_WDS_GET_DORMANCY_STATUS = 0x0030,
    QMI_MESSAGE_WDS_GET_AUTOCONNECT_SETTINGS = 0x0034,
    QMI_MESSAGE_WDS_GET_DATA_BEARER_TECHNOLOGY = 0x0037,
    QMI_MESSAGE_WDS_GET_CURRENT_DATA_BEARER_TECHNOLOGY = 0x0044,
    QMI_MESSAGE_WDS_GET_DEFAULT_PROFILE_NUMBER = 0x0049,
    QMI_MESSAGE_WDS_SET_DEFAULT_PROFILE_NUMBER = 0x004A,
    QMI_MESSAGE_WDS_SET_IP_FAMILY = 0x004D,
    QMI_MESSAGE_WDS_SET_AUTOCONNECT_SETTINGS = 0x0051,
    QMI_MESSAGE_WDS_GET_PDN_THROTTLE_INFO = 0x006C,
    QMI_MESSAGE_WDS_GET_LTE_ATTACH_PARAMETERS = 0x0085,
    QMI_MESSAGE_WDS_BIND_DATA_PORT = 0x0089,
    QMI_MESSAGE_WDS_GET_MAX_LTE_ATTACH_PDN_NUMBER = 0x0092,
    QMI_MESSAGE_WDS_SET_LTE_ATTACH_PDN_LIST = 0x0093,
    QMI_MESSAGE_WDS_GET_LTE_ATTACH_PDN_LIST = 0x0094,
    QMI_MESSAGE_WDS_BIND_MUX_DATA_PORT = 0x00A2,
    QMI_MESSAGE_WDS_SWI_CREATE_PROFILE_INDEXED = 0x5558,
} QmiMessageWds;


typedef enum {
    QMI_INDICATION_WDS_EVENT_REPORT = 0x0001,
    QMI_INDICATION_WDS_PACKET_SERVICE_STATUS = 0x0022,
    QMI_INDICATION_WDS_EXTENDED_IP_CONFIG = 0x008C,
    QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST = 0x0093,
} QmiIndicationWds;


/*****************************************************************************/
/* INDICATION: Qmi Indication WDS Event Report */


/* --- Output -- */

static void
__qmi_indication_wds_event_report_output_data_systems_networks_network_free (QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork *value)
{
    g_slice_free (QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork, value);
}

static QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork *
__qmi_indication_wds_event_report_output_data_systems_networks_network_new (void)
{
    return g_slice_new0 (QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork);
}

static QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork *
__qmi_indication_wds_event_report_output_data_systems_networks_network_copy (const QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork *value)
{
    QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork *copy;

    copy = __qmi_indication_wds_event_report_output_data_systems_networks_network_new ();
    copy->network_type = value->network_type;
    copy->rat_mask = value->rat_mask;
    copy->so_mask = value->so_mask;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork, qmi_indication_wds_event_report_output_data_systems_networks_network, (GBoxedCopyFunc)__qmi_indication_wds_event_report_output_data_systems_networks_network_copy, (GBoxedFreeFunc)__qmi_indication_wds_event_report_output_data_systems_networks_network_free)

struct _QmiIndicationWdsEventReportOutput {
    volatile gint ref_count;

    /* Extended Data Bearer Technology */
    gboolean arg_extended_data_bearer_technology_set;
    guint32 arg_extended_data_bearer_technology_data_bearer_technology;
    guint32 arg_extended_data_bearer_technology_radio_access_technology;
    guint16 arg_extended_data_bearer_technology_extended_data_bearer_technology_3gpp;
    guint8 arg_extended_data_bearer_technology_reserved1;
    guint16 arg_extended_data_bearer_technology_extended_data_bearer_technology_3gpp2;
    guint8 arg_extended_data_bearer_technology_reserved2;
    guint8 arg_extended_data_bearer_technology_reserved3;
    guint8 arg_extended_data_bearer_technology_reserved4;

    /* PDN Filters Removed */
    gboolean arg_pdn_filters_removed_set;
    GArray *arg_pdn_filters_removed_pdn_filter_handler;

    /* Data Call Address Family */
    gboolean arg_data_call_address_family_set;
    guint32 arg_data_call_address_family;

    /* Uplink Flow Control Enabled */
    gboolean arg_uplink_flow_control_enabled_set;
    gint8 arg_uplink_flow_control_enabled;

    /* Rx Packets Dropped */
    gboolean arg_rx_packets_dropped_set;
    guint32 arg_rx_packets_dropped;

    /* Tx Packets Dropped */
    gboolean arg_tx_packets_dropped_set;
    guint32 arg_tx_packets_dropped;

    /* Data Systems */
    gboolean arg_data_systems_set;
    guint8 arg_data_systems_preferred_network_type;
    GArray *arg_data_systems_networks;
    GPtrArray *arg_data_systems_networks_ptr;

    /* EVDO Page Monitor Period Change */
    gboolean arg_evdo_page_monitor_period_change_set;
    guint8 arg_evdo_page_monitor_period_change_period_change;
    guint8 arg_evdo_page_monitor_period_change_force_long_sleep;

    /* Data Call Type */
    gboolean arg_data_call_type_set;
    guint8 arg_data_call_type_data_call_type;
    guint8 arg_data_call_type_tethered_call_type;

    /* Preferred Data System */
    gboolean arg_preferred_data_system_set;
    guint32 arg_preferred_data_system;

    /* Data Call Status */
    gboolean arg_data_call_status_set;
    guint8 arg_data_call_status;

    /* Current Data Bearer Technology */
    gboolean arg_current_data_bearer_technology_set;
    guint8 arg_current_data_bearer_technology_network_type;
    guint32 arg_current_data_bearer_technology_rat_mask;
    guint32 arg_current_data_bearer_technology_so_mask;

    /* MIP Status */
    gboolean arg_mip_status_set;
    guint8 arg_mip_status;

    /* Rx Bytes Ok */
    gboolean arg_rx_bytes_ok_set;
    guint64 arg_rx_bytes_ok;

    /* Tx Bytes Ok */
    gboolean arg_tx_bytes_ok_set;
    guint64 arg_tx_bytes_ok;

    /* Dormancy Status */
    gboolean arg_dormancy_status_set;
    guint8 arg_dormancy_status;

    /* Data Bearer Technology */
    gboolean arg_data_bearer_technology_set;
    gint8 arg_data_bearer_technology;

    /* Channel Rates */
    gboolean arg_channel_rates_set;
    gint32 arg_channel_rates_tx_rate_bps;
    gint32 arg_channel_rates_rx_rate_bps;

    /* Rx Overflows */
    gboolean arg_rx_overflows_set;
    guint32 arg_rx_overflows;

    /* Tx Overflows */
    gboolean arg_tx_overflows_set;
    guint32 arg_tx_overflows;

    /* Rx Packets Error */
    gboolean arg_rx_packets_error_set;
    guint32 arg_rx_packets_error;

    /* Tx Packets Error */
    gboolean arg_tx_packets_error_set;
    guint32 arg_tx_packets_error;

    /* Rx Packets Ok */
    gboolean arg_rx_packets_ok_set;
    guint32 arg_rx_packets_ok;

    /* Tx Packets Ok */
    gboolean arg_tx_packets_ok_set;
    guint32 arg_tx_packets_ok;
};

#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_EXTENDED_DATA_BEARER_TECHNOLOGY 0x2A
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_PDN_FILTERS_REMOVED 0x29
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_ADDRESS_FAMILY 0x28
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_UPLINK_FLOW_CONTROL_ENABLED 0x27
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_DROPPED 0x26
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_DROPPED 0x25
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_SYSTEMS 0x24
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_EVDO_PAGE_MONITOR_PERIOD_CHANGE 0x23
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_TYPE 0x22
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_PREFERRED_DATA_SYSTEM 0x20
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_STATUS 0x1F
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_CURRENT_DATA_BEARER_TECHNOLOGY 0x1D
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_MIP_STATUS 0x1B
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_BYTES_OK 0x1A
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_BYTES_OK 0x19
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DORMANCY_STATUS 0x18
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_BEARER_TECHNOLOGY 0x17
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_CHANNEL_RATES 0x16
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_OVERFLOWS 0x15
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_OVERFLOWS 0x14
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_ERROR 0x13
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_ERROR 0x12
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_OK 0x11
#define QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_OK 0x10

gboolean
qmi_indication_wds_event_report_output_get_extended_data_bearer_technology (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsDataSystemNetworkType *value_extended_data_bearer_technology_data_bearer_technology,
    QmiWdsRadioAccessTechnology *value_extended_data_bearer_technology_radio_access_technology,
    QmiWdsExtendedDataBearerTechnology3gpp *value_extended_data_bearer_technology_extended_data_bearer_technology_3gpp,
    QmiWdsExtendedDataBearerTechnology3gpp2 *value_extended_data_bearer_technology_extended_data_bearer_technology_3gpp2,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_data_bearer_technology_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended Data Bearer Technology' was not found in the message");
        return FALSE;
    }

    if (value_extended_data_bearer_technology_data_bearer_technology)
        *value_extended_data_bearer_technology_data_bearer_technology = (QmiWdsDataSystemNetworkType)(self->arg_extended_data_bearer_technology_data_bearer_technology);
    if (value_extended_data_bearer_technology_radio_access_technology)
        *value_extended_data_bearer_technology_radio_access_technology = (QmiWdsRadioAccessTechnology)(self->arg_extended_data_bearer_technology_radio_access_technology);
    if (value_extended_data_bearer_technology_extended_data_bearer_technology_3gpp)
        *value_extended_data_bearer_technology_extended_data_bearer_technology_3gpp = (QmiWdsExtendedDataBearerTechnology3gpp)(self->arg_extended_data_bearer_technology_extended_data_bearer_technology_3gpp);
    if (value_extended_data_bearer_technology_extended_data_bearer_technology_3gpp2)
        *value_extended_data_bearer_technology_extended_data_bearer_technology_3gpp2 = (QmiWdsExtendedDataBearerTechnology3gpp2)(self->arg_extended_data_bearer_technology_extended_data_bearer_technology_3gpp2);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_pdn_filters_removed (
    QmiIndicationWdsEventReportOutput *self,
    GArray **value_pdn_filters_removed_pdn_filter_handler,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdn_filters_removed_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDN Filters Removed' was not found in the message");
        return FALSE;
    }

    if (value_pdn_filters_removed_pdn_filter_handler)
        *value_pdn_filters_removed_pdn_filter_handler = self->arg_pdn_filters_removed_pdn_filter_handler;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_data_call_address_family (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsIpFamily *value_data_call_address_family,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_call_address_family_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Call Address Family' was not found in the message");
        return FALSE;
    }

    if (value_data_call_address_family)
        *value_data_call_address_family = (QmiWdsIpFamily)(self->arg_data_call_address_family);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_uplink_flow_control_enabled (
    QmiIndicationWdsEventReportOutput *self,
    gboolean *value_uplink_flow_control_enabled,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_uplink_flow_control_enabled_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Uplink Flow Control Enabled' was not found in the message");
        return FALSE;
    }

    if (value_uplink_flow_control_enabled)
        *value_uplink_flow_control_enabled = (gboolean)(self->arg_uplink_flow_control_enabled);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_rx_packets_dropped (
    QmiIndicationWdsEventReportOutput *self,
    guint32 *value_rx_packets_dropped,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_packets_dropped_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Packets Dropped' was not found in the message");
        return FALSE;
    }

    if (value_rx_packets_dropped)
        *value_rx_packets_dropped = self->arg_rx_packets_dropped;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_tx_packets_dropped (
    QmiIndicationWdsEventReportOutput *self,
    guint32 *value_tx_packets_dropped,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_packets_dropped_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Packets Dropped' was not found in the message");
        return FALSE;
    }

    if (value_tx_packets_dropped)
        *value_tx_packets_dropped = self->arg_tx_packets_dropped;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_data_systems (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsDataSystemNetworkType *value_data_systems_preferred_network_type,
    GArray **value_data_systems_networks,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_systems_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Systems' was not found in the message");
        return FALSE;
    }

    if (value_data_systems_preferred_network_type)
        *value_data_systems_preferred_network_type = (QmiWdsDataSystemNetworkType)(self->arg_data_systems_preferred_network_type);
    if (value_data_systems_networks)
        *value_data_systems_networks = self->arg_data_systems_networks;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_data_systems_gir (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsDataSystemNetworkType *value_data_systems_preferred_network_type,
    GPtrArray **value_data_systems_networks_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_systems_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Systems' was not found in the message");
        return FALSE;
    }

    if (value_data_systems_preferred_network_type)
        *value_data_systems_preferred_network_type = (QmiWdsDataSystemNetworkType)(self->arg_data_systems_preferred_network_type);
    if (value_data_systems_networks_ptr) {
        if (!self->arg_data_systems_networks_ptr) {
            {
                guint networks_i;

                self->arg_data_systems_networks_ptr = g_ptr_array_new_full (self->arg_data_systems_networks->len, (GDestroyNotify)__qmi_indication_wds_event_report_output_data_systems_networks_network_free);
                for (networks_i = 0; networks_i < self->arg_data_systems_networks->len; networks_i++) {
                    QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork *networks_aux_from;
                    QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork *networks_aux_to;

                    networks_aux_from = &g_array_index (self->arg_data_systems_networks, QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork, networks_i);

                    networks_aux_to = __qmi_indication_wds_event_report_output_data_systems_networks_network_new ();
                    networks_aux_to->network_type = (*networks_aux_from).network_type;
                    networks_aux_to->rat_mask = (*networks_aux_from).rat_mask;
                    networks_aux_to->so_mask = (*networks_aux_from).so_mask;

                    g_ptr_array_add (self->arg_data_systems_networks_ptr, networks_aux_to);
                }
            }
        }
        *value_data_systems_networks_ptr = self->arg_data_systems_networks_ptr;
    }
    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_evdo_page_monitor_period_change (
    QmiIndicationWdsEventReportOutput *self,
    guint8 *value_evdo_page_monitor_period_change_period_change,
    gboolean *value_evdo_page_monitor_period_change_force_long_sleep,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_evdo_page_monitor_period_change_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'EVDO Page Monitor Period Change' was not found in the message");
        return FALSE;
    }

    if (value_evdo_page_monitor_period_change_period_change)
        *value_evdo_page_monitor_period_change_period_change = self->arg_evdo_page_monitor_period_change_period_change;
    if (value_evdo_page_monitor_period_change_force_long_sleep)
        *value_evdo_page_monitor_period_change_force_long_sleep = (gboolean)(self->arg_evdo_page_monitor_period_change_force_long_sleep);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_data_call_type (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsDataCallType *value_data_call_type_data_call_type,
    QmiWdsTetheredCallType *value_data_call_type_tethered_call_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_call_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Call Type' was not found in the message");
        return FALSE;
    }

    if (value_data_call_type_data_call_type)
        *value_data_call_type_data_call_type = (QmiWdsDataCallType)(self->arg_data_call_type_data_call_type);
    if (value_data_call_type_tethered_call_type)
        *value_data_call_type_tethered_call_type = (QmiWdsTetheredCallType)(self->arg_data_call_type_tethered_call_type);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_preferred_data_system (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsDataSystem *value_preferred_data_system,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_preferred_data_system_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Preferred Data System' was not found in the message");
        return FALSE;
    }

    if (value_preferred_data_system)
        *value_preferred_data_system = (QmiWdsDataSystem)(self->arg_preferred_data_system);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_data_call_status (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsDataCallStatus *value_data_call_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_call_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Call Status' was not found in the message");
        return FALSE;
    }

    if (value_data_call_status)
        *value_data_call_status = (QmiWdsDataCallStatus)(self->arg_data_call_status);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_current_data_bearer_technology (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsNetworkType *value_current_data_bearer_technology_network_type,
    guint32 *value_current_data_bearer_technology_rat_mask,
    guint32 *value_current_data_bearer_technology_so_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_current_data_bearer_technology_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Current Data Bearer Technology' was not found in the message");
        return FALSE;
    }

    if (value_current_data_bearer_technology_network_type)
        *value_current_data_bearer_technology_network_type = (QmiWdsNetworkType)(self->arg_current_data_bearer_technology_network_type);
    if (value_current_data_bearer_technology_rat_mask)
        *value_current_data_bearer_technology_rat_mask = self->arg_current_data_bearer_technology_rat_mask;
    if (value_current_data_bearer_technology_so_mask)
        *value_current_data_bearer_technology_so_mask = self->arg_current_data_bearer_technology_so_mask;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_mip_status (
    QmiIndicationWdsEventReportOutput *self,
    gboolean *value_mip_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mip_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MIP Status' was not found in the message");
        return FALSE;
    }

    if (value_mip_status)
        *value_mip_status = (gboolean)(self->arg_mip_status);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_rx_bytes_ok (
    QmiIndicationWdsEventReportOutput *self,
    guint64 *value_rx_bytes_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_bytes_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Bytes Ok' was not found in the message");
        return FALSE;
    }

    if (value_rx_bytes_ok)
        *value_rx_bytes_ok = self->arg_rx_bytes_ok;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_tx_bytes_ok (
    QmiIndicationWdsEventReportOutput *self,
    guint64 *value_tx_bytes_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_bytes_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Bytes Ok' was not found in the message");
        return FALSE;
    }

    if (value_tx_bytes_ok)
        *value_tx_bytes_ok = self->arg_tx_bytes_ok;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_dormancy_status (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsDormancyStatus *value_dormancy_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_dormancy_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Dormancy Status' was not found in the message");
        return FALSE;
    }

    if (value_dormancy_status)
        *value_dormancy_status = (QmiWdsDormancyStatus)(self->arg_dormancy_status);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_data_bearer_technology (
    QmiIndicationWdsEventReportOutput *self,
    QmiWdsDataBearerTechnology *value_data_bearer_technology,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_bearer_technology_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Bearer Technology' was not found in the message");
        return FALSE;
    }

    if (value_data_bearer_technology)
        *value_data_bearer_technology = (QmiWdsDataBearerTechnology)(self->arg_data_bearer_technology);

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_channel_rates (
    QmiIndicationWdsEventReportOutput *self,
    gint32 *value_channel_rates_tx_rate_bps,
    gint32 *value_channel_rates_rx_rate_bps,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_channel_rates_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Channel Rates' was not found in the message");
        return FALSE;
    }

    if (value_channel_rates_tx_rate_bps)
        *value_channel_rates_tx_rate_bps = self->arg_channel_rates_tx_rate_bps;
    if (value_channel_rates_rx_rate_bps)
        *value_channel_rates_rx_rate_bps = self->arg_channel_rates_rx_rate_bps;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_rx_overflows (
    QmiIndicationWdsEventReportOutput *self,
    guint32 *value_rx_overflows,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_overflows_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Overflows' was not found in the message");
        return FALSE;
    }

    if (value_rx_overflows)
        *value_rx_overflows = self->arg_rx_overflows;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_tx_overflows (
    QmiIndicationWdsEventReportOutput *self,
    guint32 *value_tx_overflows,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_overflows_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Overflows' was not found in the message");
        return FALSE;
    }

    if (value_tx_overflows)
        *value_tx_overflows = self->arg_tx_overflows;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_rx_packets_error (
    QmiIndicationWdsEventReportOutput *self,
    guint32 *value_rx_packets_error,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_packets_error_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Packets Error' was not found in the message");
        return FALSE;
    }

    if (value_rx_packets_error)
        *value_rx_packets_error = self->arg_rx_packets_error;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_tx_packets_error (
    QmiIndicationWdsEventReportOutput *self,
    guint32 *value_tx_packets_error,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_packets_error_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Packets Error' was not found in the message");
        return FALSE;
    }

    if (value_tx_packets_error)
        *value_tx_packets_error = self->arg_tx_packets_error;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_rx_packets_ok (
    QmiIndicationWdsEventReportOutput *self,
    guint32 *value_rx_packets_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_packets_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Packets Ok' was not found in the message");
        return FALSE;
    }

    if (value_rx_packets_ok)
        *value_rx_packets_ok = self->arg_rx_packets_ok;

    return TRUE;
}

gboolean
qmi_indication_wds_event_report_output_get_tx_packets_ok (
    QmiIndicationWdsEventReportOutput *self,
    guint32 *value_tx_packets_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_packets_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Packets Ok' was not found in the message");
        return FALSE;
    }

    if (value_tx_packets_ok)
        *value_tx_packets_ok = self->arg_tx_packets_ok;

    return TRUE;
}

GType
qmi_indication_wds_event_report_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationWdsEventReportOutput"),
                                          (GBoxedCopyFunc) qmi_indication_wds_event_report_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_wds_event_report_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationWdsEventReportOutput *
qmi_indication_wds_event_report_output_ref (QmiIndicationWdsEventReportOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_wds_event_report_output_unref (QmiIndicationWdsEventReportOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_pdn_filters_removed_pdn_filter_handler, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_data_systems_networks, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_data_systems_networks, (GDestroyNotify)g_ptr_array_unref);
        g_slice_free (QmiIndicationWdsEventReportOutput, self);
    }
}

static gchar *
qmi_indication_wds_event_report_output_extended_data_bearer_technology_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_EXTENDED_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " data_bearer_technology = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DATA_SYSTEM_NETWORK_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_data_system_network_type_get_string ((QmiWdsDataSystemNetworkType)tmp));
#elif defined  __QMI_WDS_DATA_SYSTEM_NETWORK_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_data_system_network_type_build_string_from_mask ((QmiWdsDataSystemNetworkType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDataSystemNetworkType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_access_technology = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_RADIO_ACCESS_TECHNOLOGY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_radio_access_technology_get_string ((QmiWdsRadioAccessTechnology)tmp));
#elif defined  __QMI_WDS_RADIO_ACCESS_TECHNOLOGY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_radio_access_technology_build_string_from_mask ((QmiWdsRadioAccessTechnology)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsRadioAccessTechnology
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " extended_data_bearer_technology_3gpp = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_EXTENDED_DATA_BEARER_TECHNOLOGY_3GPP_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_extended_data_bearer_technology_3gpp_get_string ((QmiWdsExtendedDataBearerTechnology3gpp)tmp));
#elif defined  __QMI_WDS_EXTENDED_DATA_BEARER_TECHNOLOGY_3GPP_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_extended_data_bearer_technology_3gpp_build_string_from_mask ((QmiWdsExtendedDataBearerTechnology3gpp)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsExtendedDataBearerTechnology3gpp
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reserved1 = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " extended_data_bearer_technology_3gpp2 = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_EXTENDED_DATA_BEARER_TECHNOLOGY_3GPP2_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_extended_data_bearer_technology_3gpp2_get_string ((QmiWdsExtendedDataBearerTechnology3gpp2)tmp));
#elif defined  __QMI_WDS_EXTENDED_DATA_BEARER_TECHNOLOGY_3GPP2_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_extended_data_bearer_technology_3gpp2_build_string_from_mask ((QmiWdsExtendedDataBearerTechnology3gpp2)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsExtendedDataBearerTechnology3gpp2
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reserved2 = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reserved3 = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reserved4 = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_pdn_filters_removed_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_PDN_FILTERS_REMOVED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " pdn_filter_handler = '");
    {
        guint pdn_filter_handler_i;
        guint8 pdn_filter_handler_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(pdn_filter_handler_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (pdn_filter_handler_i = 0; pdn_filter_handler_i < pdn_filter_handler_n_items; pdn_filter_handler_i++) {
            g_string_append_printf (printable, " [%u] = '", pdn_filter_handler_i);

            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_data_call_address_family_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_ADDRESS_FAMILY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_IP_FAMILY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_ip_family_get_string ((QmiWdsIpFamily)tmp));
#elif defined  __QMI_WDS_IP_FAMILY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_ip_family_build_string_from_mask ((QmiWdsIpFamily)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsIpFamily
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_uplink_flow_control_enabled_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_UPLINK_FLOW_CONTROL_ENABLED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_rx_packets_dropped_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_DROPPED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_tx_packets_dropped_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_DROPPED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_data_systems_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_SYSTEMS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " preferred_network_type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DATA_SYSTEM_NETWORK_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_data_system_network_type_get_string ((QmiWdsDataSystemNetworkType)tmp));
#elif defined  __QMI_WDS_DATA_SYSTEM_NETWORK_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_data_system_network_type_build_string_from_mask ((QmiWdsDataSystemNetworkType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDataSystemNetworkType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " networks = '");
    {
        guint networks_i;
        guint8 networks_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(networks_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (networks_i = 0; networks_i < networks_n_items; networks_i++) {
            g_string_append_printf (printable, " [%u] = '", networks_i);
            g_string_append (printable, "[");
            g_string_append (printable, " network_type = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_WDS_DATA_SYSTEM_NETWORK_TYPE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_wds_data_system_network_type_get_string ((QmiWdsDataSystemNetworkType)tmp));
#elif defined  __QMI_WDS_DATA_SYSTEM_NETWORK_TYPE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_wds_data_system_network_type_build_string_from_mask ((QmiWdsDataSystemNetworkType)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiWdsDataSystemNetworkType
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " rat_mask = '");

            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " so_mask = '");

            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_evdo_page_monitor_period_change_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_EVDO_PAGE_MONITOR_PERIOD_CHANGE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " period_change = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " force_long_sleep = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_data_call_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " data_call_type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DATA_CALL_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_data_call_type_get_string ((QmiWdsDataCallType)tmp));
#elif defined  __QMI_WDS_DATA_CALL_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_data_call_type_build_string_from_mask ((QmiWdsDataCallType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDataCallType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " tethered_call_type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TETHERED_CALL_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_tethered_call_type_get_string ((QmiWdsTetheredCallType)tmp));
#elif defined  __QMI_WDS_TETHERED_CALL_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_tethered_call_type_build_string_from_mask ((QmiWdsTetheredCallType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTetheredCallType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_preferred_data_system_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_PREFERRED_DATA_SYSTEM, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DATA_SYSTEM_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_data_system_get_string ((QmiWdsDataSystem)tmp));
#elif defined  __QMI_WDS_DATA_SYSTEM_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_data_system_build_string_from_mask ((QmiWdsDataSystem)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDataSystem
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_data_call_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DATA_CALL_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_data_call_status_get_string ((QmiWdsDataCallStatus)tmp));
#elif defined  __QMI_WDS_DATA_CALL_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_data_call_status_build_string_from_mask ((QmiWdsDataCallStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDataCallStatus
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_current_data_bearer_technology_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_CURRENT_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " network_type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_NETWORK_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_network_type_get_string ((QmiWdsNetworkType)tmp));
#elif defined  __QMI_WDS_NETWORK_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_network_type_build_string_from_mask ((QmiWdsNetworkType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsNetworkType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " rat_mask = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " so_mask = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_mip_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_MIP_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_rx_bytes_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_BYTES_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_tx_bytes_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_BYTES_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_dormancy_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DORMANCY_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DORMANCY_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_dormancy_status_get_string ((QmiWdsDormancyStatus)tmp));
#elif defined  __QMI_WDS_DORMANCY_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_dormancy_status_build_string_from_mask ((QmiWdsDormancyStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDormancyStatus
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_data_bearer_technology_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DATA_BEARER_TECHNOLOGY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_data_bearer_technology_get_string ((QmiWdsDataBearerTechnology)tmp));
#elif defined  __QMI_WDS_DATA_BEARER_TECHNOLOGY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_data_bearer_technology_build_string_from_mask ((QmiWdsDataBearerTechnology)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDataBearerTechnology
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_channel_rates_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_CHANNEL_RATES, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " tx_rate_bps = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " rx_rate_bps = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_rx_overflows_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_OVERFLOWS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_tx_overflows_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_OVERFLOWS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_rx_packets_error_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_ERROR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_tx_packets_error_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_ERROR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_rx_packets_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_event_report_output_tx_packets_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_event_report_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_event_report_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_event_report_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_EXTENDED_DATA_BEARER_TECHNOLOGY:
            tlv_type_str = "Extended Data Bearer Technology";
            translated_value = qmi_indication_wds_event_report_output_extended_data_bearer_technology_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_PDN_FILTERS_REMOVED:
            tlv_type_str = "PDN Filters Removed";
            translated_value = qmi_indication_wds_event_report_output_pdn_filters_removed_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_ADDRESS_FAMILY:
            tlv_type_str = "Data Call Address Family";
            translated_value = qmi_indication_wds_event_report_output_data_call_address_family_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_UPLINK_FLOW_CONTROL_ENABLED:
            tlv_type_str = "Uplink Flow Control Enabled";
            translated_value = qmi_indication_wds_event_report_output_uplink_flow_control_enabled_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_DROPPED:
            tlv_type_str = "Rx Packets Dropped";
            translated_value = qmi_indication_wds_event_report_output_rx_packets_dropped_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_DROPPED:
            tlv_type_str = "Tx Packets Dropped";
            translated_value = qmi_indication_wds_event_report_output_tx_packets_dropped_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_SYSTEMS:
            tlv_type_str = "Data Systems";
            translated_value = qmi_indication_wds_event_report_output_data_systems_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_EVDO_PAGE_MONITOR_PERIOD_CHANGE:
            tlv_type_str = "EVDO Page Monitor Period Change";
            translated_value = qmi_indication_wds_event_report_output_evdo_page_monitor_period_change_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_TYPE:
            tlv_type_str = "Data Call Type";
            translated_value = qmi_indication_wds_event_report_output_data_call_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_PREFERRED_DATA_SYSTEM:
            tlv_type_str = "Preferred Data System";
            translated_value = qmi_indication_wds_event_report_output_preferred_data_system_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_STATUS:
            tlv_type_str = "Data Call Status";
            translated_value = qmi_indication_wds_event_report_output_data_call_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_CURRENT_DATA_BEARER_TECHNOLOGY:
            tlv_type_str = "Current Data Bearer Technology";
            translated_value = qmi_indication_wds_event_report_output_current_data_bearer_technology_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_MIP_STATUS:
            tlv_type_str = "MIP Status";
            translated_value = qmi_indication_wds_event_report_output_mip_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_BYTES_OK:
            tlv_type_str = "Rx Bytes Ok";
            translated_value = qmi_indication_wds_event_report_output_rx_bytes_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_BYTES_OK:
            tlv_type_str = "Tx Bytes Ok";
            translated_value = qmi_indication_wds_event_report_output_tx_bytes_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DORMANCY_STATUS:
            tlv_type_str = "Dormancy Status";
            translated_value = qmi_indication_wds_event_report_output_dormancy_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_BEARER_TECHNOLOGY:
            tlv_type_str = "Data Bearer Technology";
            translated_value = qmi_indication_wds_event_report_output_data_bearer_technology_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_CHANNEL_RATES:
            tlv_type_str = "Channel Rates";
            translated_value = qmi_indication_wds_event_report_output_channel_rates_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_OVERFLOWS:
            tlv_type_str = "Rx Overflows";
            translated_value = qmi_indication_wds_event_report_output_rx_overflows_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_OVERFLOWS:
            tlv_type_str = "Tx Overflows";
            translated_value = qmi_indication_wds_event_report_output_tx_overflows_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_ERROR:
            tlv_type_str = "Rx Packets Error";
            translated_value = qmi_indication_wds_event_report_output_rx_packets_error_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_ERROR:
            tlv_type_str = "Tx Packets Error";
            translated_value = qmi_indication_wds_event_report_output_tx_packets_error_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_OK:
            tlv_type_str = "Rx Packets Ok";
            translated_value = qmi_indication_wds_event_report_output_rx_packets_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_OK:
            tlv_type_str = "Tx Packets Ok";
            translated_value = qmi_indication_wds_event_report_output_tx_packets_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_event_report_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Event Report\" (0x0001)\n",
                            line_prefix);

    {
        struct indication_event_report_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_event_report_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiIndicationWdsEventReportOutput *
__qmi_indication_wds_event_report_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationWdsEventReportOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_WDS_EVENT_REPORT);

    self = g_slice_new0 (QmiIndicationWdsEventReportOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_EXTENDED_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;
                self->arg_extended_data_bearer_technology_data_bearer_technology = (QmiWdsDataSystemNetworkType)tmp;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;
                self->arg_extended_data_bearer_technology_radio_access_technology = (QmiWdsRadioAccessTechnology)tmp;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;
                self->arg_extended_data_bearer_technology_extended_data_bearer_technology_3gpp = (QmiWdsExtendedDataBearerTechnology3gpp)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_extended_data_bearer_technology_reserved1), NULL))
                goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;
                self->arg_extended_data_bearer_technology_extended_data_bearer_technology_3gpp2 = (QmiWdsExtendedDataBearerTechnology3gpp2)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_extended_data_bearer_technology_reserved2), NULL))
                goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_extended_data_bearer_technology_reserved3), NULL))
                goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_extended_data_bearer_technology_reserved4), NULL))
                goto qmi_indication_wds_event_report_output_extended_data_bearer_technology_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Extended Data Bearer Technology' TLV", offset);
            }

            self->arg_extended_data_bearer_technology_set = TRUE;

qmi_indication_wds_event_report_output_extended_data_bearer_technology_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_PDN_FILTERS_REMOVED, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_pdn_filters_removed_out;
            }
            {
                guint pdn_filter_handler_i;
                guint8 pdn_filter_handler_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(pdn_filter_handler_n_items), NULL))
                    goto qmi_indication_wds_event_report_output_pdn_filters_removed_out;

                self->arg_pdn_filters_removed_pdn_filter_handler = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint32),
                    (guint)pdn_filter_handler_n_items);

                for (pdn_filter_handler_i = 0; pdn_filter_handler_i < pdn_filter_handler_n_items; pdn_filter_handler_i++) {
                    guint32 pdn_filter_handler_aux;

                    if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(pdn_filter_handler_aux), NULL))
                        goto qmi_indication_wds_event_report_output_pdn_filters_removed_out;
                    g_array_insert_val (self->arg_pdn_filters_removed_pdn_filter_handler, pdn_filter_handler_i, pdn_filter_handler_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PDN Filters Removed' TLV", offset);
            }

            self->arg_pdn_filters_removed_set = TRUE;

qmi_indication_wds_event_report_output_pdn_filters_removed_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_ADDRESS_FAMILY, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_data_call_address_family_out;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_data_call_address_family_out;
                self->arg_data_call_address_family = (QmiWdsIpFamily)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Data Call Address Family' TLV", offset);
            }

            self->arg_data_call_address_family_set = TRUE;

qmi_indication_wds_event_report_output_data_call_address_family_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_UPLINK_FLOW_CONTROL_ENABLED, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_uplink_flow_control_enabled_out;
            }
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_uplink_flow_control_enabled_out;
                self->arg_uplink_flow_control_enabled = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Uplink Flow Control Enabled' TLV", offset);
            }

            self->arg_uplink_flow_control_enabled_set = TRUE;

qmi_indication_wds_event_report_output_uplink_flow_control_enabled_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_DROPPED, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_rx_packets_dropped_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_packets_dropped), NULL))
                goto qmi_indication_wds_event_report_output_rx_packets_dropped_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Packets Dropped' TLV", offset);
            }

            self->arg_rx_packets_dropped_set = TRUE;

qmi_indication_wds_event_report_output_rx_packets_dropped_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_DROPPED, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_tx_packets_dropped_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_packets_dropped), NULL))
                goto qmi_indication_wds_event_report_output_tx_packets_dropped_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Packets Dropped' TLV", offset);
            }

            self->arg_tx_packets_dropped_set = TRUE;

qmi_indication_wds_event_report_output_tx_packets_dropped_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_SYSTEMS, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_data_systems_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_data_systems_out;
                self->arg_data_systems_preferred_network_type = (QmiWdsDataSystemNetworkType)tmp;
            }
            {
                guint networks_i;
                guint8 networks_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(networks_n_items), NULL))
                    goto qmi_indication_wds_event_report_output_data_systems_out;

                self->arg_data_systems_networks = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork),
                    (guint)networks_n_items);

                for (networks_i = 0; networks_i < networks_n_items; networks_i++) {
                    QmiIndicationWdsEventReportOutputDataSystemsNetworksNetwork networks_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_wds_event_report_output_data_systems_out;
                        networks_aux.network_type = (QmiWdsDataSystemNetworkType)tmp;
                    }
                    if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(networks_aux.rat_mask), NULL))
                        goto qmi_indication_wds_event_report_output_data_systems_out;
                    if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(networks_aux.so_mask), NULL))
                        goto qmi_indication_wds_event_report_output_data_systems_out;
                    g_array_insert_val (self->arg_data_systems_networks, networks_i, networks_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Data Systems' TLV", offset);
            }

            self->arg_data_systems_set = TRUE;

qmi_indication_wds_event_report_output_data_systems_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_EVDO_PAGE_MONITOR_PERIOD_CHANGE, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_evdo_page_monitor_period_change_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_evdo_page_monitor_period_change_period_change), NULL))
                goto qmi_indication_wds_event_report_output_evdo_page_monitor_period_change_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_evdo_page_monitor_period_change_out;
                self->arg_evdo_page_monitor_period_change_force_long_sleep = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'EVDO Page Monitor Period Change' TLV", offset);
            }

            self->arg_evdo_page_monitor_period_change_set = TRUE;

qmi_indication_wds_event_report_output_evdo_page_monitor_period_change_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_TYPE, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_data_call_type_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_data_call_type_out;
                self->arg_data_call_type_data_call_type = (QmiWdsDataCallType)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_data_call_type_out;
                self->arg_data_call_type_tethered_call_type = (QmiWdsTetheredCallType)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Data Call Type' TLV", offset);
            }

            self->arg_data_call_type_set = TRUE;

qmi_indication_wds_event_report_output_data_call_type_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_PREFERRED_DATA_SYSTEM, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_preferred_data_system_out;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_preferred_data_system_out;
                self->arg_preferred_data_system = (QmiWdsDataSystem)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Preferred Data System' TLV", offset);
            }

            self->arg_preferred_data_system_set = TRUE;

qmi_indication_wds_event_report_output_preferred_data_system_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_CALL_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_data_call_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_data_call_status_out;
                self->arg_data_call_status = (QmiWdsDataCallStatus)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Data Call Status' TLV", offset);
            }

            self->arg_data_call_status_set = TRUE;

qmi_indication_wds_event_report_output_data_call_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_CURRENT_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_current_data_bearer_technology_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_current_data_bearer_technology_out;
                self->arg_current_data_bearer_technology_network_type = (QmiWdsNetworkType)tmp;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_current_data_bearer_technology_rat_mask), NULL))
                goto qmi_indication_wds_event_report_output_current_data_bearer_technology_out;
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_current_data_bearer_technology_so_mask), NULL))
                goto qmi_indication_wds_event_report_output_current_data_bearer_technology_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Current Data Bearer Technology' TLV", offset);
            }

            self->arg_current_data_bearer_technology_set = TRUE;

qmi_indication_wds_event_report_output_current_data_bearer_technology_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_MIP_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_mip_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_mip_status_out;
                self->arg_mip_status = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'MIP Status' TLV", offset);
            }

            self->arg_mip_status_set = TRUE;

qmi_indication_wds_event_report_output_mip_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_BYTES_OK, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_rx_bytes_ok_out;
            }
            if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_bytes_ok), NULL))
                goto qmi_indication_wds_event_report_output_rx_bytes_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Bytes Ok' TLV", offset);
            }

            self->arg_rx_bytes_ok_set = TRUE;

qmi_indication_wds_event_report_output_rx_bytes_ok_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_BYTES_OK, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_tx_bytes_ok_out;
            }
            if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_bytes_ok), NULL))
                goto qmi_indication_wds_event_report_output_tx_bytes_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Bytes Ok' TLV", offset);
            }

            self->arg_tx_bytes_ok_set = TRUE;

qmi_indication_wds_event_report_output_tx_bytes_ok_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DORMANCY_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_dormancy_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_dormancy_status_out;
                self->arg_dormancy_status = (QmiWdsDormancyStatus)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Dormancy Status' TLV", offset);
            }

            self->arg_dormancy_status_set = TRUE;

qmi_indication_wds_event_report_output_dormancy_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_data_bearer_technology_out;
            }
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_event_report_output_data_bearer_technology_out;
                self->arg_data_bearer_technology = (QmiWdsDataBearerTechnology)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Data Bearer Technology' TLV", offset);
            }

            self->arg_data_bearer_technology_set = TRUE;

qmi_indication_wds_event_report_output_data_bearer_technology_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_CHANNEL_RATES, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_channel_rates_out;
            }
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_channel_rates_tx_rate_bps), NULL))
                goto qmi_indication_wds_event_report_output_channel_rates_out;
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_channel_rates_rx_rate_bps), NULL))
                goto qmi_indication_wds_event_report_output_channel_rates_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Channel Rates' TLV", offset);
            }

            self->arg_channel_rates_set = TRUE;

qmi_indication_wds_event_report_output_channel_rates_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_OVERFLOWS, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_rx_overflows_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_overflows), NULL))
                goto qmi_indication_wds_event_report_output_rx_overflows_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Overflows' TLV", offset);
            }

            self->arg_rx_overflows_set = TRUE;

qmi_indication_wds_event_report_output_rx_overflows_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_OVERFLOWS, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_tx_overflows_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_overflows), NULL))
                goto qmi_indication_wds_event_report_output_tx_overflows_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Overflows' TLV", offset);
            }

            self->arg_tx_overflows_set = TRUE;

qmi_indication_wds_event_report_output_tx_overflows_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_ERROR, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_rx_packets_error_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_packets_error), NULL))
                goto qmi_indication_wds_event_report_output_rx_packets_error_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Packets Error' TLV", offset);
            }

            self->arg_rx_packets_error_set = TRUE;

qmi_indication_wds_event_report_output_rx_packets_error_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_ERROR, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_tx_packets_error_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_packets_error), NULL))
                goto qmi_indication_wds_event_report_output_tx_packets_error_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Packets Error' TLV", offset);
            }

            self->arg_tx_packets_error_set = TRUE;

qmi_indication_wds_event_report_output_tx_packets_error_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_RX_PACKETS_OK, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_rx_packets_ok_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_packets_ok), NULL))
                goto qmi_indication_wds_event_report_output_rx_packets_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Packets Ok' TLV", offset);
            }

            self->arg_rx_packets_ok_set = TRUE;

qmi_indication_wds_event_report_output_rx_packets_ok_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EVENT_REPORT_OUTPUT_TLV_TX_PACKETS_OK, NULL, NULL)) == 0) {
                goto qmi_indication_wds_event_report_output_tx_packets_ok_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_packets_ok), NULL))
                goto qmi_indication_wds_event_report_output_tx_packets_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Packets Ok' TLV", offset);
            }

            self->arg_tx_packets_ok_set = TRUE;

qmi_indication_wds_event_report_output_tx_packets_ok_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication WDS Packet Service Status */


/* --- Output -- */

struct _QmiIndicationWdsPacketServiceStatusOutput {
    volatile gint ref_count;

    /* Extended Technology Preference */
    gboolean arg_extended_technology_preference_set;
    guint16 arg_extended_technology_preference;

    /* IP Family */
    gboolean arg_ip_family_set;
    guint8 arg_ip_family;

    /* Verbose Call End Reason */
    gboolean arg_verbose_call_end_reason_set;
    guint16 arg_verbose_call_end_reason_type;
    gint16 arg_verbose_call_end_reason_reason;

    /* Call End Reason */
    gboolean arg_call_end_reason_set;
    guint16 arg_call_end_reason;

    /* Connection Status */
    gboolean arg_connection_status_set;
    guint8 arg_connection_status_status;
    guint8 arg_connection_status_reconfiguration_required;
};

#define QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_EXTENDED_TECHNOLOGY_PREFERENCE 0x34
#define QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_IP_FAMILY 0x12
#define QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_VERBOSE_CALL_END_REASON 0x11
#define QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_CALL_END_REASON 0x10
#define QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_CONNECTION_STATUS 0x01

gboolean
qmi_indication_wds_packet_service_status_output_get_extended_technology_preference (
    QmiIndicationWdsPacketServiceStatusOutput *self,
    QmiWdsExtendedTechnologyPreference *value_extended_technology_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_technology_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended Technology Preference' was not found in the message");
        return FALSE;
    }

    if (value_extended_technology_preference)
        *value_extended_technology_preference = (QmiWdsExtendedTechnologyPreference)(self->arg_extended_technology_preference);

    return TRUE;
}

gboolean
qmi_indication_wds_packet_service_status_output_get_ip_family (
    QmiIndicationWdsPacketServiceStatusOutput *self,
    QmiWdsIpFamily *value_ip_family,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ip_family_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IP Family' was not found in the message");
        return FALSE;
    }

    if (value_ip_family)
        *value_ip_family = (QmiWdsIpFamily)(self->arg_ip_family);

    return TRUE;
}

gboolean
qmi_indication_wds_packet_service_status_output_get_verbose_call_end_reason (
    QmiIndicationWdsPacketServiceStatusOutput *self,
    QmiWdsVerboseCallEndReasonType *value_verbose_call_end_reason_type,
    gint16 *value_verbose_call_end_reason_reason,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_verbose_call_end_reason_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Verbose Call End Reason' was not found in the message");
        return FALSE;
    }

    if (value_verbose_call_end_reason_type)
        *value_verbose_call_end_reason_type = (QmiWdsVerboseCallEndReasonType)(self->arg_verbose_call_end_reason_type);
    if (value_verbose_call_end_reason_reason)
        *value_verbose_call_end_reason_reason = self->arg_verbose_call_end_reason_reason;

    return TRUE;
}

gboolean
qmi_indication_wds_packet_service_status_output_get_call_end_reason (
    QmiIndicationWdsPacketServiceStatusOutput *self,
    QmiWdsCallEndReason *value_call_end_reason,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_call_end_reason_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Call End Reason' was not found in the message");
        return FALSE;
    }

    if (value_call_end_reason)
        *value_call_end_reason = (QmiWdsCallEndReason)(self->arg_call_end_reason);

    return TRUE;
}

gboolean
qmi_indication_wds_packet_service_status_output_get_connection_status (
    QmiIndicationWdsPacketServiceStatusOutput *self,
    QmiWdsConnectionStatus *value_connection_status_status,
    gboolean *value_connection_status_reconfiguration_required,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_connection_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Connection Status' was not found in the message");
        return FALSE;
    }

    if (value_connection_status_status)
        *value_connection_status_status = (QmiWdsConnectionStatus)(self->arg_connection_status_status);
    if (value_connection_status_reconfiguration_required)
        *value_connection_status_reconfiguration_required = (gboolean)(self->arg_connection_status_reconfiguration_required);

    return TRUE;
}

GType
qmi_indication_wds_packet_service_status_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationWdsPacketServiceStatusOutput"),
                                          (GBoxedCopyFunc) qmi_indication_wds_packet_service_status_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_wds_packet_service_status_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationWdsPacketServiceStatusOutput *
qmi_indication_wds_packet_service_status_output_ref (QmiIndicationWdsPacketServiceStatusOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_wds_packet_service_status_output_unref (QmiIndicationWdsPacketServiceStatusOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiIndicationWdsPacketServiceStatusOutput, self);
    }
}

static gchar *
qmi_indication_wds_packet_service_status_output_extended_technology_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_EXTENDED_TECHNOLOGY_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_EXTENDED_TECHNOLOGY_PREFERENCE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_extended_technology_preference_get_string ((QmiWdsExtendedTechnologyPreference)tmp));
#elif defined  __QMI_WDS_EXTENDED_TECHNOLOGY_PREFERENCE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_extended_technology_preference_build_string_from_mask ((QmiWdsExtendedTechnologyPreference)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsExtendedTechnologyPreference
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_packet_service_status_output_ip_family_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_IP_FAMILY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_IP_FAMILY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_ip_family_get_string ((QmiWdsIpFamily)tmp));
#elif defined  __QMI_WDS_IP_FAMILY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_ip_family_build_string_from_mask ((QmiWdsIpFamily)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsIpFamily
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_packet_service_status_output_verbose_call_end_reason_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_VERBOSE_CALL_END_REASON, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " type = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_VERBOSE_CALL_END_REASON_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_verbose_call_end_reason_type_get_string ((QmiWdsVerboseCallEndReasonType)tmp));
#elif defined  __QMI_WDS_VERBOSE_CALL_END_REASON_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_verbose_call_end_reason_type_build_string_from_mask ((QmiWdsVerboseCallEndReasonType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsVerboseCallEndReasonType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reason = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_packet_service_status_output_call_end_reason_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_CALL_END_REASON, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_CALL_END_REASON_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_call_end_reason_get_string ((QmiWdsCallEndReason)tmp));
#elif defined  __QMI_WDS_CALL_END_REASON_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_call_end_reason_build_string_from_mask ((QmiWdsCallEndReason)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsCallEndReason
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_wds_packet_service_status_output_connection_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_CONNECTION_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_CONNECTION_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_connection_status_get_string ((QmiWdsConnectionStatus)tmp));
#elif defined  __QMI_WDS_CONNECTION_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_connection_status_build_string_from_mask ((QmiWdsConnectionStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsConnectionStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reconfiguration_required = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_packet_service_status_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_packet_service_status_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_packet_service_status_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_EXTENDED_TECHNOLOGY_PREFERENCE:
            tlv_type_str = "Extended Technology Preference";
            translated_value = qmi_indication_wds_packet_service_status_output_extended_technology_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_IP_FAMILY:
            tlv_type_str = "IP Family";
            translated_value = qmi_indication_wds_packet_service_status_output_ip_family_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_VERBOSE_CALL_END_REASON:
            tlv_type_str = "Verbose Call End Reason";
            translated_value = qmi_indication_wds_packet_service_status_output_verbose_call_end_reason_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_CALL_END_REASON:
            tlv_type_str = "Call End Reason";
            translated_value = qmi_indication_wds_packet_service_status_output_call_end_reason_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_CONNECTION_STATUS:
            tlv_type_str = "Connection Status";
            translated_value = qmi_indication_wds_packet_service_status_output_connection_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_packet_service_status_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Packet Service Status\" (0x0022)\n",
                            line_prefix);

    {
        struct indication_packet_service_status_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_packet_service_status_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiIndicationWdsPacketServiceStatusOutput *
__qmi_indication_wds_packet_service_status_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationWdsPacketServiceStatusOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS);

    self = g_slice_new0 (QmiIndicationWdsPacketServiceStatusOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_EXTENDED_TECHNOLOGY_PREFERENCE, NULL, NULL)) == 0) {
                goto qmi_indication_wds_packet_service_status_output_extended_technology_preference_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_packet_service_status_output_extended_technology_preference_out;
                self->arg_extended_technology_preference = (QmiWdsExtendedTechnologyPreference)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Extended Technology Preference' TLV", offset);
            }

            self->arg_extended_technology_preference_set = TRUE;

qmi_indication_wds_packet_service_status_output_extended_technology_preference_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_IP_FAMILY, NULL, NULL)) == 0) {
                goto qmi_indication_wds_packet_service_status_output_ip_family_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_wds_packet_service_status_output_ip_family_out;
                self->arg_ip_family = (QmiWdsIpFamily)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'IP Family' TLV", offset);
            }

            self->arg_ip_family_set = TRUE;

qmi_indication_wds_packet_service_status_output_ip_family_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_VERBOSE_CALL_END_REASON, NULL, NULL)) == 0) {
                goto qmi_indication_wds_packet_service_status_output_verbose_call_end_reason_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_packet_service_status_output_verbose_call_end_reason_out;
                self->arg_verbose_call_end_reason_type = (QmiWdsVerboseCallEndReasonType)tmp;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_verbose_call_end_reason_reason), NULL))
                goto qmi_indication_wds_packet_service_status_output_verbose_call_end_reason_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Verbose Call End Reason' TLV", offset);
            }

            self->arg_verbose_call_end_reason_set = TRUE;

qmi_indication_wds_packet_service_status_output_verbose_call_end_reason_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_CALL_END_REASON, NULL, NULL)) == 0) {
                goto qmi_indication_wds_packet_service_status_output_call_end_reason_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_packet_service_status_output_call_end_reason_out;
                self->arg_call_end_reason = (QmiWdsCallEndReason)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Call End Reason' TLV", offset);
            }

            self->arg_call_end_reason_set = TRUE;

qmi_indication_wds_packet_service_status_output_call_end_reason_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_PACKET_SERVICE_STATUS_OUTPUT_TLV_CONNECTION_STATUS, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Connection Status TLV: ");
                qmi_indication_wds_packet_service_status_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_wds_packet_service_status_output_connection_status_out;
                self->arg_connection_status_status = (QmiWdsConnectionStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_wds_packet_service_status_output_connection_status_out;
                self->arg_connection_status_reconfiguration_required = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Connection Status' TLV", offset);
            }

            self->arg_connection_status_set = TRUE;

qmi_indication_wds_packet_service_status_output_connection_status_out:
            if (!self->arg_connection_status_set) {
                qmi_indication_wds_packet_service_status_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication WDS Extended Ip Config */


/* --- Output -- */

struct _QmiIndicationWdsExtendedIpConfigOutput {
    volatile gint ref_count;

    /* Changed IP Configuration */
    gboolean arg_changed_ip_configuration_set;
    guint32 arg_changed_ip_configuration;
};

#define QMI_INDICATION_WDS_EXTENDED_IP_CONFIG_OUTPUT_TLV_CHANGED_IP_CONFIGURATION 0x10

gboolean
qmi_indication_wds_extended_ip_config_output_get_changed_ip_configuration (
    QmiIndicationWdsExtendedIpConfigOutput *self,
    QmiWdsRequestedSettings *value_changed_ip_configuration,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_changed_ip_configuration_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Changed IP Configuration' was not found in the message");
        return FALSE;
    }

    if (value_changed_ip_configuration)
        *value_changed_ip_configuration = (QmiWdsRequestedSettings)(self->arg_changed_ip_configuration);

    return TRUE;
}

GType
qmi_indication_wds_extended_ip_config_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationWdsExtendedIpConfigOutput"),
                                          (GBoxedCopyFunc) qmi_indication_wds_extended_ip_config_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_wds_extended_ip_config_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationWdsExtendedIpConfigOutput *
qmi_indication_wds_extended_ip_config_output_ref (QmiIndicationWdsExtendedIpConfigOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_wds_extended_ip_config_output_unref (QmiIndicationWdsExtendedIpConfigOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiIndicationWdsExtendedIpConfigOutput, self);
    }
}

static gchar *
qmi_indication_wds_extended_ip_config_output_changed_ip_configuration_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EXTENDED_IP_CONFIG_OUTPUT_TLV_CHANGED_IP_CONFIGURATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_REQUESTED_SETTINGS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_requested_settings_get_string ((QmiWdsRequestedSettings)tmp));
#elif defined  __QMI_WDS_REQUESTED_SETTINGS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_requested_settings_build_string_from_mask ((QmiWdsRequestedSettings)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsRequestedSettings
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_extended_ip_config_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_extended_ip_config_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_extended_ip_config_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_WDS_EXTENDED_IP_CONFIG_OUTPUT_TLV_CHANGED_IP_CONFIGURATION:
            tlv_type_str = "Changed IP Configuration";
            translated_value = qmi_indication_wds_extended_ip_config_output_changed_ip_configuration_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_extended_ip_config_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Extended Ip Config\" (0x008C)\n",
                            line_prefix);

    {
        struct indication_extended_ip_config_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_extended_ip_config_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiIndicationWdsExtendedIpConfigOutput *
__qmi_indication_wds_extended_ip_config_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationWdsExtendedIpConfigOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_WDS_EXTENDED_IP_CONFIG);

    self = g_slice_new0 (QmiIndicationWdsExtendedIpConfigOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_EXTENDED_IP_CONFIG_OUTPUT_TLV_CHANGED_IP_CONFIGURATION, NULL, NULL)) == 0) {
                goto qmi_indication_wds_extended_ip_config_output_changed_ip_configuration_out;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_wds_extended_ip_config_output_changed_ip_configuration_out;
                self->arg_changed_ip_configuration = (QmiWdsRequestedSettings)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Changed IP Configuration' TLV", offset);
            }

            self->arg_changed_ip_configuration_set = TRUE;

qmi_indication_wds_extended_ip_config_output_changed_ip_configuration_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication WDS Set LTE Attach PDN List */


/* --- Output -- */

struct _QmiIndicationWdsSetLteAttachPdnListOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Action Result */
    gboolean arg_action_result_set;
    guint8 arg_action_result;
};

#define QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST_OUTPUT_TLV_RESULT 0x02
#define QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST_OUTPUT_TLV_ACTION_RESULT 0x01

gboolean
qmi_indication_wds_set_lte_attach_pdn_list_output_get_result (
    QmiIndicationWdsSetLteAttachPdnListOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_indication_wds_set_lte_attach_pdn_list_output_get_action_result (
    QmiIndicationWdsSetLteAttachPdnListOutput *self,
    gboolean *value_action_result,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_action_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Action Result' was not found in the message");
        return FALSE;
    }

    if (value_action_result)
        *value_action_result = (gboolean)(self->arg_action_result);

    return TRUE;
}

GType
qmi_indication_wds_set_lte_attach_pdn_list_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationWdsSetLteAttachPdnListOutput"),
                                          (GBoxedCopyFunc) qmi_indication_wds_set_lte_attach_pdn_list_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_wds_set_lte_attach_pdn_list_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationWdsSetLteAttachPdnListOutput *
qmi_indication_wds_set_lte_attach_pdn_list_output_ref (QmiIndicationWdsSetLteAttachPdnListOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_wds_set_lte_attach_pdn_list_output_unref (QmiIndicationWdsSetLteAttachPdnListOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiIndicationWdsSetLteAttachPdnListOutput, self);
    }
}

static gboolean
qmi_message_result_validate (
    const guint8 *buffer,
    guint16 buffer_len)
{
    static const guint expected_len = 4;

    if (buffer_len < expected_len) {
        g_warning ("Cannot read the 'Result' TLV: expected '%u' bytes, but only got '%u' bytes",
                   expected_len, buffer_len);
        return FALSE;
    }

    return TRUE;
}

static gchar *
qmi_message_result_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    guint16 error_status;
    guint16 error_code;

    if ((init_offset = qmi_message_tlv_read_init (self, QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST_OUTPUT_TLV_RESULT, NULL, NULL)) == 0)
        return NULL;
    if (!qmi_message_tlv_read_guint16 (self, init_offset, &offset, QMI_ENDIAN_LITTLE, &error_status, NULL))
        return NULL;
    if (!qmi_message_tlv_read_guint16 (self, init_offset, &offset, QMI_ENDIAN_LITTLE, &error_code, NULL))
        return NULL;
    g_warn_if_fail (qmi_message_tlv_read_remaining_size (self, init_offset, offset) == 0);

    if (error_status == QMI_STATUS_SUCCESS)
        return g_strdup ("SUCCESS");

    return g_strdup_printf ("FAILURE: %s", qmi_protocol_error_get_string ((QmiProtocolError) error_code));
}

static gchar *
qmi_indication_wds_set_lte_attach_pdn_list_output_action_result_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST_OUTPUT_TLV_ACTION_RESULT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_set_lte_attach_pdn_list_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_set_lte_attach_pdn_list_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_set_lte_attach_pdn_list_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST_OUTPUT_TLV_ACTION_RESULT:
            tlv_type_str = "Action Result";
            translated_value = qmi_indication_wds_set_lte_attach_pdn_list_output_action_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_set_lte_attach_pdn_list_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set LTE Attach PDN List\" (0x0093)\n",
                            line_prefix);

    {
        struct indication_set_lte_attach_pdn_list_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_set_lte_attach_pdn_list_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiIndicationWdsSetLteAttachPdnListOutput *
__qmi_indication_wds_set_lte_attach_pdn_list_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationWdsSetLteAttachPdnListOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST);

    self = g_slice_new0 (QmiIndicationWdsSetLteAttachPdnListOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_indication_wds_set_lte_attach_pdn_list_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_indication_wds_set_lte_attach_pdn_list_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_WDS_SET_LTE_ATTACH_PDN_LIST_OUTPUT_TLV_ACTION_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Action Result TLV: ");
                qmi_indication_wds_set_lte_attach_pdn_list_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_wds_set_lte_attach_pdn_list_output_action_result_out;
                self->arg_action_result = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Action Result' TLV", offset);
            }

            self->arg_action_result_set = TRUE;

qmi_indication_wds_set_lte_attach_pdn_list_output_action_result_out:
            if (!self->arg_action_result_set) {
                qmi_indication_wds_set_lte_attach_pdn_list_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Reset */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_wds_reset_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_RESET);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsResetOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_WDS_RESET_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_wds_reset_output_get_result (
    QmiMessageWdsResetOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_wds_reset_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsResetOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_reset_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_reset_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsResetOutput *
qmi_message_wds_reset_output_ref (QmiMessageWdsResetOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_reset_output_unref (QmiMessageWdsResetOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsResetOutput, self);
    }
}

struct message_reset_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_reset_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_reset_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_RESET_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_reset_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Reset\" (0x0000)\n",
                            line_prefix);

    {
        struct message_reset_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_reset_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsResetOutput *
__qmi_message_wds_reset_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsResetOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_RESET);

    self = g_slice_new0 (QmiMessageWdsResetOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_RESET_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_reset_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_reset_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Set Event Report */


/* --- Input -- */

struct _QmiMessageWdsSetEventReportInput {
    volatile gint ref_count;

    /* Extended Data Bearer Technology */
    gboolean arg_extended_data_bearer_technology_set;
    guint8 arg_extended_data_bearer_technology;

    /* PDN Filter Removals */
    gboolean arg_pdn_filter_removals_set;
    guint8 arg_pdn_filter_removals;

    /* Limited Data System Status */
    gboolean arg_limited_data_system_status_set;
    guint8 arg_limited_data_system_status;

    /* Uplink Flow Control */
    gboolean arg_uplink_flow_control_set;
    guint8 arg_uplink_flow_control;

    /* Data Systems */
    gboolean arg_data_systems_set;
    guint8 arg_data_systems;

    /* EVDO PM Change */
    gboolean arg_evdo_pm_change_set;
    guint8 arg_evdo_pm_change;

    /* Preferred Data System */
    gboolean arg_preferred_data_system_set;
    guint8 arg_preferred_data_system;

    /* Data Call Status */
    gboolean arg_data_call_status_set;
    guint8 arg_data_call_status;

    /* Current Data Bearer Technology */
    gboolean arg_current_data_bearer_technology_set;
    guint8 arg_current_data_bearer_technology;

    /* MIP Status */
    gboolean arg_mip_status_set;
    guint8 arg_mip_status;

    /* Dormancy Status */
    gboolean arg_dormancy_status_set;
    guint8 arg_dormancy_status;

    /* Data Bearer Technology */
    gboolean arg_data_bearer_technology_set;
    guint8 arg_data_bearer_technology;

    /* Transfer Statistics */
    gboolean arg_transfer_statistics_set;
    guint8 arg_transfer_statistics_interval_seconds;
    gint32 arg_transfer_statistics_indicators;

    /* Channel Rate */
    gboolean arg_channel_rate_set;
    guint8 arg_channel_rate;
};

#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_EXTENDED_DATA_BEARER_TECHNOLOGY 0x1E
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_PDN_FILTER_REMOVALS 0x1D
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_LIMITED_DATA_SYSTEM_STATUS 0x1C
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_UPLINK_FLOW_CONTROL 0x1B
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_SYSTEMS 0x1A
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_EVDO_PM_CHANGE 0x19
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_PREFERRED_DATA_SYSTEM 0x18
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_CALL_STATUS 0x17
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_CURRENT_DATA_BEARER_TECHNOLOGY 0x15
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_MIP_STATUS 0x14
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DORMANCY_STATUS 0x13
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_BEARER_TECHNOLOGY 0x12
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_TRANSFER_STATISTICS 0x11
#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_CHANNEL_RATE 0x10

gboolean
qmi_message_wds_set_event_report_input_get_extended_data_bearer_technology (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_extended_data_bearer_technology,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_data_bearer_technology_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended Data Bearer Technology' was not found in the message");
        return FALSE;
    }

    if (value_extended_data_bearer_technology)
        *value_extended_data_bearer_technology = (gboolean)(self->arg_extended_data_bearer_technology);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_extended_data_bearer_technology (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_extended_data_bearer_technology,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_extended_data_bearer_technology = (guint8)(value_extended_data_bearer_technology);
    self->arg_extended_data_bearer_technology_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_pdn_filter_removals (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_pdn_filter_removals,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdn_filter_removals_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDN Filter Removals' was not found in the message");
        return FALSE;
    }

    if (value_pdn_filter_removals)
        *value_pdn_filter_removals = (gboolean)(self->arg_pdn_filter_removals);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_pdn_filter_removals (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_pdn_filter_removals,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdn_filter_removals = (guint8)(value_pdn_filter_removals);
    self->arg_pdn_filter_removals_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_limited_data_system_status (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_limited_data_system_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_limited_data_system_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Limited Data System Status' was not found in the message");
        return FALSE;
    }

    if (value_limited_data_system_status)
        *value_limited_data_system_status = (gboolean)(self->arg_limited_data_system_status);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_limited_data_system_status (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_limited_data_system_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_limited_data_system_status = (guint8)(value_limited_data_system_status);
    self->arg_limited_data_system_status_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_uplink_flow_control (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_uplink_flow_control,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_uplink_flow_control_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Uplink Flow Control' was not found in the message");
        return FALSE;
    }

    if (value_uplink_flow_control)
        *value_uplink_flow_control = (gboolean)(self->arg_uplink_flow_control);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_uplink_flow_control (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_uplink_flow_control,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_uplink_flow_control = (guint8)(value_uplink_flow_control);
    self->arg_uplink_flow_control_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_data_systems (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_data_systems,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_systems_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Systems' was not found in the message");
        return FALSE;
    }

    if (value_data_systems)
        *value_data_systems = (gboolean)(self->arg_data_systems);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_data_systems (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_data_systems,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_data_systems = (guint8)(value_data_systems);
    self->arg_data_systems_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_evdo_pm_change (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_evdo_pm_change,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_evdo_pm_change_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'EVDO PM Change' was not found in the message");
        return FALSE;
    }

    if (value_evdo_pm_change)
        *value_evdo_pm_change = (gboolean)(self->arg_evdo_pm_change);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_evdo_pm_change (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_evdo_pm_change,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_evdo_pm_change = (guint8)(value_evdo_pm_change);
    self->arg_evdo_pm_change_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_preferred_data_system (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_preferred_data_system,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_preferred_data_system_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Preferred Data System' was not found in the message");
        return FALSE;
    }

    if (value_preferred_data_system)
        *value_preferred_data_system = (gboolean)(self->arg_preferred_data_system);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_preferred_data_system (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_preferred_data_system,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_preferred_data_system = (guint8)(value_preferred_data_system);
    self->arg_preferred_data_system_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_data_call_status (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_data_call_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_call_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Call Status' was not found in the message");
        return FALSE;
    }

    if (value_data_call_status)
        *value_data_call_status = (gboolean)(self->arg_data_call_status);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_data_call_status (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_data_call_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_data_call_status = (guint8)(value_data_call_status);
    self->arg_data_call_status_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_current_data_bearer_technology (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_current_data_bearer_technology,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_current_data_bearer_technology_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Current Data Bearer Technology' was not found in the message");
        return FALSE;
    }

    if (value_current_data_bearer_technology)
        *value_current_data_bearer_technology = (gboolean)(self->arg_current_data_bearer_technology);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_current_data_bearer_technology (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_current_data_bearer_technology,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_current_data_bearer_technology = (guint8)(value_current_data_bearer_technology);
    self->arg_current_data_bearer_technology_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_mip_status (
    QmiMessageWdsSetEventReportInput *self,
    guint8 *value_mip_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mip_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MIP Status' was not found in the message");
        return FALSE;
    }

    if (value_mip_status)
        *value_mip_status = self->arg_mip_status;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_mip_status (
    QmiMessageWdsSetEventReportInput *self,
    guint8 value_mip_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_mip_status = value_mip_status;
    self->arg_mip_status_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_dormancy_status (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_dormancy_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_dormancy_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Dormancy Status' was not found in the message");
        return FALSE;
    }

    if (value_dormancy_status)
        *value_dormancy_status = (gboolean)(self->arg_dormancy_status);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_dormancy_status (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_dormancy_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_dormancy_status = (guint8)(value_dormancy_status);
    self->arg_dormancy_status_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_data_bearer_technology (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_data_bearer_technology,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_bearer_technology_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Bearer Technology' was not found in the message");
        return FALSE;
    }

    if (value_data_bearer_technology)
        *value_data_bearer_technology = (gboolean)(self->arg_data_bearer_technology);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_data_bearer_technology (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_data_bearer_technology,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_data_bearer_technology = (guint8)(value_data_bearer_technology);
    self->arg_data_bearer_technology_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_transfer_statistics (
    QmiMessageWdsSetEventReportInput *self,
    guint8 *value_transfer_statistics_interval_seconds,
    QmiWdsSetEventReportTransferStatistics *value_transfer_statistics_indicators,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_transfer_statistics_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Transfer Statistics' was not found in the message");
        return FALSE;
    }

    if (value_transfer_statistics_interval_seconds)
        *value_transfer_statistics_interval_seconds = self->arg_transfer_statistics_interval_seconds;
    if (value_transfer_statistics_indicators)
        *value_transfer_statistics_indicators = (QmiWdsSetEventReportTransferStatistics)(self->arg_transfer_statistics_indicators);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_transfer_statistics (
    QmiMessageWdsSetEventReportInput *self,
    guint8 value_transfer_statistics_interval_seconds,
    QmiWdsSetEventReportTransferStatistics value_transfer_statistics_indicators,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_transfer_statistics_interval_seconds = value_transfer_statistics_interval_seconds;
    self->arg_transfer_statistics_indicators = (gint32)(value_transfer_statistics_indicators);
    self->arg_transfer_statistics_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_get_channel_rate (
    QmiMessageWdsSetEventReportInput *self,
    gboolean *value_channel_rate,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_channel_rate_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Channel Rate' was not found in the message");
        return FALSE;
    }

    if (value_channel_rate)
        *value_channel_rate = (gboolean)(self->arg_channel_rate);

    return TRUE;
}

gboolean
qmi_message_wds_set_event_report_input_set_channel_rate (
    QmiMessageWdsSetEventReportInput *self,
    gboolean value_channel_rate,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_channel_rate = (guint8)(value_channel_rate);
    self->arg_channel_rate_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_set_event_report_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsSetEventReportInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_set_event_report_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_set_event_report_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsSetEventReportInput *
qmi_message_wds_set_event_report_input_ref (QmiMessageWdsSetEventReportInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_set_event_report_input_unref (QmiMessageWdsSetEventReportInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsSetEventReportInput, self);
    }
}

QmiMessageWdsSetEventReportInput *
qmi_message_wds_set_event_report_input_new (void)
{
    QmiMessageWdsSetEventReportInput *self;

    self = g_slice_new0 (QmiMessageWdsSetEventReportInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_set_event_report_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsSetEventReportInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_SET_EVENT_REPORT);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'Extended Data Bearer Technology' TLV */
    if (input->arg_extended_data_bearer_technology_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_EXTENDED_DATA_BEARER_TECHNOLOGY, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Extended Data Bearer Technology': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_extended_data_bearer_technology;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Extended Data Bearer Technology': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Extended Data Bearer Technology': ");
            return NULL;
        }
    }

    /* Try to add the 'PDN Filter Removals' TLV */
    if (input->arg_pdn_filter_removals_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_PDN_FILTER_REMOVALS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDN Filter Removals': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdn_filter_removals;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDN Filter Removals': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDN Filter Removals': ");
            return NULL;
        }
    }

    /* Try to add the 'Limited Data System Status' TLV */
    if (input->arg_limited_data_system_status_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_LIMITED_DATA_SYSTEM_STATUS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Limited Data System Status': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_limited_data_system_status;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Limited Data System Status': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Limited Data System Status': ");
            return NULL;
        }
    }

    /* Try to add the 'Uplink Flow Control' TLV */
    if (input->arg_uplink_flow_control_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_UPLINK_FLOW_CONTROL, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Uplink Flow Control': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_uplink_flow_control;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Uplink Flow Control': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Uplink Flow Control': ");
            return NULL;
        }
    }

    /* Try to add the 'Data Systems' TLV */
    if (input->arg_data_systems_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_SYSTEMS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Data Systems': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_data_systems;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Data Systems': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Data Systems': ");
            return NULL;
        }
    }

    /* Try to add the 'EVDO PM Change' TLV */
    if (input->arg_evdo_pm_change_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_EVDO_PM_CHANGE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'EVDO PM Change': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_evdo_pm_change;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'EVDO PM Change': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'EVDO PM Change': ");
            return NULL;
        }
    }

    /* Try to add the 'Preferred Data System' TLV */
    if (input->arg_preferred_data_system_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_PREFERRED_DATA_SYSTEM, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Preferred Data System': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_preferred_data_system;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Preferred Data System': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Preferred Data System': ");
            return NULL;
        }
    }

    /* Try to add the 'Data Call Status' TLV */
    if (input->arg_data_call_status_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_CALL_STATUS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Data Call Status': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_data_call_status;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Data Call Status': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Data Call Status': ");
            return NULL;
        }
    }

    /* Try to add the 'Current Data Bearer Technology' TLV */
    if (input->arg_current_data_bearer_technology_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_CURRENT_DATA_BEARER_TECHNOLOGY, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Current Data Bearer Technology': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_current_data_bearer_technology;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Current Data Bearer Technology': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Current Data Bearer Technology': ");
            return NULL;
        }
    }

    /* Try to add the 'MIP Status' TLV */
    if (input->arg_mip_status_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_MIP_STATUS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'MIP Status': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_mip_status, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'MIP Status': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'MIP Status': ");
            return NULL;
        }
    }

    /* Try to add the 'Dormancy Status' TLV */
    if (input->arg_dormancy_status_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DORMANCY_STATUS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Dormancy Status': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_dormancy_status;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Dormancy Status': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Dormancy Status': ");
            return NULL;
        }
    }

    /* Try to add the 'Data Bearer Technology' TLV */
    if (input->arg_data_bearer_technology_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_BEARER_TECHNOLOGY, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Data Bearer Technology': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_data_bearer_technology;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Data Bearer Technology': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Data Bearer Technology': ");
            return NULL;
        }
    }

    /* Try to add the 'Transfer Statistics' TLV */
    if (input->arg_transfer_statistics_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_TRANSFER_STATISTICS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Transfer Statistics': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_transfer_statistics_interval_seconds, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Transfer Statistics': ");
            return NULL;
        }
        {
            gint32 tmp;

            tmp = (gint32) input->arg_transfer_statistics_indicators;
            /* Write the gint32 variable to the buffer */
            if (!qmi_message_tlv_write_gint32 (self, QMI_ENDIAN_LITTLE, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Transfer Statistics': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Transfer Statistics': ");
            return NULL;
        }
    }

    /* Try to add the 'Channel Rate' TLV */
    if (input->arg_channel_rate_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_CHANNEL_RATE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Channel Rate': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_channel_rate;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Channel Rate': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Channel Rate': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsSetEventReportOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_WDS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_wds_set_event_report_output_get_result (
    QmiMessageWdsSetEventReportOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_wds_set_event_report_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsSetEventReportOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_set_event_report_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_set_event_report_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsSetEventReportOutput *
qmi_message_wds_set_event_report_output_ref (QmiMessageWdsSetEventReportOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_set_event_report_output_unref (QmiMessageWdsSetEventReportOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsSetEventReportOutput, self);
    }
}

static gchar *
qmi_message_wds_set_event_report_input_extended_data_bearer_technology_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_EXTENDED_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_pdn_filter_removals_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_PDN_FILTER_REMOVALS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_limited_data_system_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_LIMITED_DATA_SYSTEM_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_uplink_flow_control_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_UPLINK_FLOW_CONTROL, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_data_systems_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_SYSTEMS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_evdo_pm_change_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_EVDO_PM_CHANGE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_preferred_data_system_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_PREFERRED_DATA_SYSTEM, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_data_call_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_CALL_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_current_data_bearer_technology_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_CURRENT_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_mip_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_MIP_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_dormancy_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DORMANCY_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_data_bearer_technology_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_BEARER_TECHNOLOGY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_transfer_statistics_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_TRANSFER_STATISTICS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " interval_seconds = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " indicators = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SET_EVENT_REPORT_TRANSFER_STATISTICS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_set_event_report_transfer_statistics_get_string ((QmiWdsSetEventReportTransferStatistics)tmp));
#elif defined  __QMI_WDS_SET_EVENT_REPORT_TRANSFER_STATISTICS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_set_event_report_transfer_statistics_build_string_from_mask ((QmiWdsSetEventReportTransferStatistics)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSetEventReportTransferStatistics
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_set_event_report_input_channel_rate_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_CHANNEL_RATE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_event_report_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_event_report_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_event_report_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_EXTENDED_DATA_BEARER_TECHNOLOGY:
            tlv_type_str = "Extended Data Bearer Technology";
            translated_value = qmi_message_wds_set_event_report_input_extended_data_bearer_technology_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_PDN_FILTER_REMOVALS:
            tlv_type_str = "PDN Filter Removals";
            translated_value = qmi_message_wds_set_event_report_input_pdn_filter_removals_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_LIMITED_DATA_SYSTEM_STATUS:
            tlv_type_str = "Limited Data System Status";
            translated_value = qmi_message_wds_set_event_report_input_limited_data_system_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_UPLINK_FLOW_CONTROL:
            tlv_type_str = "Uplink Flow Control";
            translated_value = qmi_message_wds_set_event_report_input_uplink_flow_control_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_SYSTEMS:
            tlv_type_str = "Data Systems";
            translated_value = qmi_message_wds_set_event_report_input_data_systems_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_EVDO_PM_CHANGE:
            tlv_type_str = "EVDO PM Change";
            translated_value = qmi_message_wds_set_event_report_input_evdo_pm_change_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_PREFERRED_DATA_SYSTEM:
            tlv_type_str = "Preferred Data System";
            translated_value = qmi_message_wds_set_event_report_input_preferred_data_system_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_CALL_STATUS:
            tlv_type_str = "Data Call Status";
            translated_value = qmi_message_wds_set_event_report_input_data_call_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_CURRENT_DATA_BEARER_TECHNOLOGY:
            tlv_type_str = "Current Data Bearer Technology";
            translated_value = qmi_message_wds_set_event_report_input_current_data_bearer_technology_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_MIP_STATUS:
            tlv_type_str = "MIP Status";
            translated_value = qmi_message_wds_set_event_report_input_mip_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DORMANCY_STATUS:
            tlv_type_str = "Dormancy Status";
            translated_value = qmi_message_wds_set_event_report_input_dormancy_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_DATA_BEARER_TECHNOLOGY:
            tlv_type_str = "Data Bearer Technology";
            translated_value = qmi_message_wds_set_event_report_input_data_bearer_technology_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_TRANSFER_STATISTICS:
            tlv_type_str = "Transfer Statistics";
            translated_value = qmi_message_wds_set_event_report_input_transfer_statistics_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_INPUT_TLV_CHANNEL_RATE:
            tlv_type_str = "Channel Rate";
            translated_value = qmi_message_wds_set_event_report_input_channel_rate_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_event_report_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Event Report\" (0x0001)\n",
                            line_prefix);

    {
        struct message_set_event_report_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_event_report_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsSetEventReportOutput *
__qmi_message_wds_set_event_report_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsSetEventReportOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_SET_EVENT_REPORT);

    self = g_slice_new0 (QmiMessageWdsSetEventReportOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_set_event_report_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_set_event_report_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Abort */


/* --- Input -- */

typedef struct _QmiMessageWdsAbortInput QmiMessageWdsAbortInput;
static GType qmi_message_wds_abort_input_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_WDS_ABORT_INPUT (qmi_message_wds_abort_input_get_type ())

struct _QmiMessageWdsAbortInput {
    volatile gint ref_count;

    /* Transaction ID */
    gboolean arg_transaction_id_set;
    guint16 arg_transaction_id;
};

#define QMI_MESSAGE_WDS_ABORT_INPUT_TLV_TRANSACTION_ID 0x01

static gboolean qmi_message_wds_abort_input_get_transaction_id (
    QmiMessageWdsAbortInput *self,
    guint16 *value_transaction_id,
    GError **error);

static gboolean
qmi_message_wds_abort_input_get_transaction_id (
    QmiMessageWdsAbortInput *self,
    guint16 *value_transaction_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_transaction_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Transaction ID' was not found in the message");
        return FALSE;
    }

    if (value_transaction_id)
        *value_transaction_id = self->arg_transaction_id;

    return TRUE;
}

static gboolean qmi_message_wds_abort_input_set_transaction_id (
    QmiMessageWdsAbortInput *self,
    guint16 value_transaction_id,
    GError **error);

static gboolean
qmi_message_wds_abort_input_set_transaction_id (
    QmiMessageWdsAbortInput *self,
    guint16 value_transaction_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_transaction_id = value_transaction_id;
    self->arg_transaction_id_set = TRUE;

    return TRUE;
}

static QmiMessageWdsAbortInput *qmi_message_wds_abort_input_ref (QmiMessageWdsAbortInput *self);

static void qmi_message_wds_abort_input_unref (QmiMessageWdsAbortInput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessageWdsAbortInput, qmi_message_wds_abort_input_unref)
static QmiMessageWdsAbortInput *qmi_message_wds_abort_input_new (void);

static GType
qmi_message_wds_abort_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsAbortInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_abort_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_abort_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

static QmiMessageWdsAbortInput *
qmi_message_wds_abort_input_ref (QmiMessageWdsAbortInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

static void
qmi_message_wds_abort_input_unref (QmiMessageWdsAbortInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsAbortInput, self);
    }
}

static QmiMessageWdsAbortInput *
qmi_message_wds_abort_input_new (void)
{
    QmiMessageWdsAbortInput *self;

    self = g_slice_new0 (QmiMessageWdsAbortInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_abort_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsAbortInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_ABORT);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Abort' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Transaction ID' TLV */
    if (input->arg_transaction_id_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_ABORT_INPUT_TLV_TRANSACTION_ID, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Transaction ID': ");
            return NULL;
        }

        /* Write the guint16 variable to the buffer */
        if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, input->arg_transaction_id, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Transaction ID': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Transaction ID': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Transaction ID' in message 'Abort'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

typedef struct _QmiMessageWdsAbortOutput QmiMessageWdsAbortOutput;
static GType qmi_message_wds_abort_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_WDS_ABORT_OUTPUT (qmi_message_wds_abort_output_get_type ())

struct _QmiMessageWdsAbortOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_WDS_ABORT_OUTPUT_TLV_RESULT 0x02

gboolean qmi_message_wds_abort_output_get_result (
    QmiMessageWdsAbortOutput *self,
    GError **error);

gboolean
qmi_message_wds_abort_output_get_result (
    QmiMessageWdsAbortOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

static QmiMessageWdsAbortOutput *qmi_message_wds_abort_output_ref (QmiMessageWdsAbortOutput *self);

static void qmi_message_wds_abort_output_unref (QmiMessageWdsAbortOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessageWdsAbortOutput, qmi_message_wds_abort_output_unref)

static GType
qmi_message_wds_abort_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsAbortOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_abort_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_abort_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

static QmiMessageWdsAbortOutput *
qmi_message_wds_abort_output_ref (QmiMessageWdsAbortOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

static void
qmi_message_wds_abort_output_unref (QmiMessageWdsAbortOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsAbortOutput, self);
    }
}

static gchar *
qmi_message_wds_abort_input_transaction_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_ABORT_INPUT_TLV_TRANSACTION_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_abort_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_abort_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_abort_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_ABORT_INPUT_TLV_TRANSACTION_ID:
            tlv_type_str = "Transaction ID";
            translated_value = qmi_message_wds_abort_input_transaction_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_ABORT_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_abort_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Abort\" (0x0002)\n",
                            line_prefix);

    {
        struct message_abort_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_abort_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsAbortOutput *
__qmi_message_wds_abort_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsAbortOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_ABORT);

    self = g_slice_new0 (QmiMessageWdsAbortOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_ABORT_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_abort_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_abort_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Indication Register */


/* --- Input -- */

struct _QmiMessageWdsIndicationRegisterInput {
    volatile gint ref_count;

    /* Report Extended IP Configuration Change */
    gboolean arg_report_extended_ip_configuration_change_set;
    guint8 arg_report_extended_ip_configuration_change;
};

#define QMI_MESSAGE_WDS_INDICATION_REGISTER_INPUT_TLV_REPORT_EXTENDED_IP_CONFIGURATION_CHANGE 0x12

gboolean
qmi_message_wds_indication_register_input_get_report_extended_ip_configuration_change (
    QmiMessageWdsIndicationRegisterInput *self,
    gboolean *value_report_extended_ip_configuration_change,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_report_extended_ip_configuration_change_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Report Extended IP Configuration Change' was not found in the message");
        return FALSE;
    }

    if (value_report_extended_ip_configuration_change)
        *value_report_extended_ip_configuration_change = (gboolean)(self->arg_report_extended_ip_configuration_change);

    return TRUE;
}

gboolean
qmi_message_wds_indication_register_input_set_report_extended_ip_configuration_change (
    QmiMessageWdsIndicationRegisterInput *self,
    gboolean value_report_extended_ip_configuration_change,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_report_extended_ip_configuration_change = (guint8)(value_report_extended_ip_configuration_change);
    self->arg_report_extended_ip_configuration_change_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_indication_register_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsIndicationRegisterInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_indication_register_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_indication_register_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsIndicationRegisterInput *
qmi_message_wds_indication_register_input_ref (QmiMessageWdsIndicationRegisterInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_indication_register_input_unref (QmiMessageWdsIndicationRegisterInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsIndicationRegisterInput, self);
    }
}

QmiMessageWdsIndicationRegisterInput *
qmi_message_wds_indication_register_input_new (void)
{
    QmiMessageWdsIndicationRegisterInput *self;

    self = g_slice_new0 (QmiMessageWdsIndicationRegisterInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_indication_register_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsIndicationRegisterInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_INDICATION_REGISTER);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'Report Extended IP Configuration Change' TLV */
    if (input->arg_report_extended_ip_configuration_change_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_INDICATION_REGISTER_INPUT_TLV_REPORT_EXTENDED_IP_CONFIGURATION_CHANGE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Report Extended IP Configuration Change': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_report_extended_ip_configuration_change;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Report Extended IP Configuration Change': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Report Extended IP Configuration Change': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsIndicationRegisterOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_WDS_INDICATION_REGISTER_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_wds_indication_register_output_get_result (
    QmiMessageWdsIndicationRegisterOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_wds_indication_register_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsIndicationRegisterOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_indication_register_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_indication_register_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsIndicationRegisterOutput *
qmi_message_wds_indication_register_output_ref (QmiMessageWdsIndicationRegisterOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_indication_register_output_unref (QmiMessageWdsIndicationRegisterOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsIndicationRegisterOutput, self);
    }
}

static gchar *
qmi_message_wds_indication_register_input_report_extended_ip_configuration_change_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_INDICATION_REGISTER_INPUT_TLV_REPORT_EXTENDED_IP_CONFIGURATION_CHANGE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_indication_register_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_indication_register_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_indication_register_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_INDICATION_REGISTER_INPUT_TLV_REPORT_EXTENDED_IP_CONFIGURATION_CHANGE:
            tlv_type_str = "Report Extended IP Configuration Change";
            translated_value = qmi_message_wds_indication_register_input_report_extended_ip_configuration_change_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_INDICATION_REGISTER_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_indication_register_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Indication Register\" (0x0003)\n",
                            line_prefix);

    {
        struct message_indication_register_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_indication_register_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsIndicationRegisterOutput *
__qmi_message_wds_indication_register_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsIndicationRegisterOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_INDICATION_REGISTER);

    self = g_slice_new0 (QmiMessageWdsIndicationRegisterOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_INDICATION_REGISTER_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_indication_register_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_indication_register_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Get Supported Messages */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_wds_get_supported_messages_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsGetSupportedMessagesOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* List */
    gboolean arg_list_set;
    GArray *arg_list;
};

#define QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST 0x10

gboolean
qmi_message_wds_get_supported_messages_output_get_result (
    QmiMessageWdsGetSupportedMessagesOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_get_supported_messages_output_get_list (
    QmiMessageWdsGetSupportedMessagesOutput *self,
    GArray **value_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list)
        *value_list = self->arg_list;

    return TRUE;
}

GType
qmi_message_wds_get_supported_messages_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGetSupportedMessagesOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_get_supported_messages_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_get_supported_messages_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGetSupportedMessagesOutput *
qmi_message_wds_get_supported_messages_output_ref (QmiMessageWdsGetSupportedMessagesOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_get_supported_messages_output_unref (QmiMessageWdsGetSupportedMessagesOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageWdsGetSupportedMessagesOutput, self);
    }
}

static gchar *
qmi_message_wds_get_supported_messages_output_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint list_i;
        guint16 list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (list_i = 0; list_i < list_n_items; list_i++) {
            g_string_append_printf (printable, " [%u] = '", list_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_supported_messages_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_supported_messages_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_supported_messages_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST:
            tlv_type_str = "List";
            translated_value = qmi_message_wds_get_supported_messages_output_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_supported_messages_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Supported Messages\" (0x001E)\n",
                            line_prefix);

    {
        struct message_get_supported_messages_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_supported_messages_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsGetSupportedMessagesOutput *
__qmi_message_wds_get_supported_messages_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsGetSupportedMessagesOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES);

    self = g_slice_new0 (QmiMessageWdsGetSupportedMessagesOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_get_supported_messages_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_get_supported_messages_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_supported_messages_output_list_out;
            }
            {
                guint list_i;
                guint16 list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(list_n_items), NULL))
                    goto qmi_message_wds_get_supported_messages_output_list_out;

                self->arg_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)list_n_items);

                for (list_i = 0; list_i < list_n_items; list_i++) {
                    guint8 list_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_aux), NULL))
                        goto qmi_message_wds_get_supported_messages_output_list_out;
                    g_array_insert_val (self->arg_list, list_i, list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'List' TLV", offset);
            }

            self->arg_list_set = TRUE;

qmi_message_wds_get_supported_messages_output_list_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Start Network */


/* --- Input -- */

struct _QmiMessageWdsStartNetworkInput {
    volatile gint ref_count;

    /* Call Type */
    gboolean arg_call_type_set;
    guint8 arg_call_type;

    /* Extended Technology Preference */
    gboolean arg_extended_technology_preference_set;
    guint16 arg_extended_technology_preference;

    /* Enable Autoconnect */
    gboolean arg_enable_autoconnect_set;
    guint8 arg_enable_autoconnect;

    /* Profile Index 3GPP2 */
    gboolean arg_profile_index_3gpp2_set;
    guint8 arg_profile_index_3gpp2;

    /* Profile Index 3GPP */
    gboolean arg_profile_index_3gpp_set;
    guint8 arg_profile_index_3gpp;

    /* Technology Preference */
    gboolean arg_technology_preference_set;
    guint8 arg_technology_preference;

    /* IP Family Preference */
    gboolean arg_ip_family_preference_set;
    guint8 arg_ip_family_preference;

    /* Password */
    gboolean arg_password_set;
    gchar *arg_password;

    /* Username */
    gboolean arg_username_set;
    gchar *arg_username;

    /* Authentication Preference */
    gboolean arg_authentication_preference_set;
    guint8 arg_authentication_preference;

    /* IPv4 Address Preference */
    gboolean arg_ipv4_address_preference_set;
    guint32 arg_ipv4_address_preference;

    /* APN */
    gboolean arg_apn_set;
    gchar *arg_apn;

    /* Secondary NBNS Address Preference */
    gboolean arg_secondary_nbns_address_preference_set;
    guint32 arg_secondary_nbns_address_preference;

    /* Primary NBNS Address Preference */
    gboolean arg_primary_nbns_address_preference_set;
    guint32 arg_primary_nbns_address_preference;

    /* Secondary DNS Address Preference */
    gboolean arg_secondary_dns_address_preference_set;
    guint32 arg_secondary_dns_address_preference;

    /* Primary DNS Address Preference */
    gboolean arg_primary_dns_address_preference_set;
    guint32 arg_primary_dns_address_preference;
};

#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_CALL_TYPE 0x35
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_EXTENDED_TECHNOLOGY_PREFERENCE 0x34
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_ENABLE_AUTOCONNECT 0x33
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PROFILE_INDEX_3GPP2 0x32
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PROFILE_INDEX_3GPP 0x31
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_TECHNOLOGY_PREFERENCE 0x30
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_IP_FAMILY_PREFERENCE 0x19
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PASSWORD 0x18
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_USERNAME 0x17
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_AUTHENTICATION_PREFERENCE 0x16
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_IPV4_ADDRESS_PREFERENCE 0x15
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_APN 0x14
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_SECONDARY_NBNS_ADDRESS_PREFERENCE 0x13
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PRIMARY_NBNS_ADDRESS_PREFERENCE 0x12
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_SECONDARY_DNS_ADDRESS_PREFERENCE 0x11
#define QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PRIMARY_DNS_ADDRESS_PREFERENCE 0x10

gboolean
qmi_message_wds_start_network_input_get_call_type (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsCallType *value_call_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_call_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Call Type' was not found in the message");
        return FALSE;
    }

    if (value_call_type)
        *value_call_type = (QmiWdsCallType)(self->arg_call_type);

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_call_type (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsCallType value_call_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_call_type = (guint8)(value_call_type);
    self->arg_call_type_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_extended_technology_preference (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsExtendedTechnologyPreference *value_extended_technology_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_technology_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended Technology Preference' was not found in the message");
        return FALSE;
    }

    if (value_extended_technology_preference)
        *value_extended_technology_preference = (QmiWdsExtendedTechnologyPreference)(self->arg_extended_technology_preference);

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_extended_technology_preference (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsExtendedTechnologyPreference value_extended_technology_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_extended_technology_preference = (guint16)(value_extended_technology_preference);
    self->arg_extended_technology_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_enable_autoconnect (
    QmiMessageWdsStartNetworkInput *self,
    gboolean *value_enable_autoconnect,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_enable_autoconnect_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Enable Autoconnect' was not found in the message");
        return FALSE;
    }

    if (value_enable_autoconnect)
        *value_enable_autoconnect = (gboolean)(self->arg_enable_autoconnect);

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_enable_autoconnect (
    QmiMessageWdsStartNetworkInput *self,
    gboolean value_enable_autoconnect,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_enable_autoconnect = (guint8)(value_enable_autoconnect);
    self->arg_enable_autoconnect_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_profile_index_3gpp2 (
    QmiMessageWdsStartNetworkInput *self,
    guint8 *value_profile_index_3gpp2,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_index_3gpp2_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Index 3GPP2' was not found in the message");
        return FALSE;
    }

    if (value_profile_index_3gpp2)
        *value_profile_index_3gpp2 = self->arg_profile_index_3gpp2;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_profile_index_3gpp2 (
    QmiMessageWdsStartNetworkInput *self,
    guint8 value_profile_index_3gpp2,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_profile_index_3gpp2 = value_profile_index_3gpp2;
    self->arg_profile_index_3gpp2_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_profile_index_3gpp (
    QmiMessageWdsStartNetworkInput *self,
    guint8 *value_profile_index_3gpp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_index_3gpp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Index 3GPP' was not found in the message");
        return FALSE;
    }

    if (value_profile_index_3gpp)
        *value_profile_index_3gpp = self->arg_profile_index_3gpp;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_profile_index_3gpp (
    QmiMessageWdsStartNetworkInput *self,
    guint8 value_profile_index_3gpp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_profile_index_3gpp = value_profile_index_3gpp;
    self->arg_profile_index_3gpp_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_technology_preference (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsTechnologyPreference *value_technology_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_technology_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Technology Preference' was not found in the message");
        return FALSE;
    }

    if (value_technology_preference)
        *value_technology_preference = (QmiWdsTechnologyPreference)(self->arg_technology_preference);

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_technology_preference (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsTechnologyPreference value_technology_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_technology_preference = (guint8)(value_technology_preference);
    self->arg_technology_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_ip_family_preference (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsIpFamily *value_ip_family_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ip_family_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IP Family Preference' was not found in the message");
        return FALSE;
    }

    if (value_ip_family_preference)
        *value_ip_family_preference = (QmiWdsIpFamily)(self->arg_ip_family_preference);

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_ip_family_preference (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsIpFamily value_ip_family_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_ip_family_preference = (guint8)(value_ip_family_preference);
    self->arg_ip_family_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_password (
    QmiMessageWdsStartNetworkInput *self,
    const gchar **value_password,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_password_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Password' was not found in the message");
        return FALSE;
    }

    if (value_password)
        *value_password = self->arg_password;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_password (
    QmiMessageWdsStartNetworkInput *self,
    const gchar *value_password,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_password);
    self->arg_password = g_strdup (value_password ? value_password : "");
    self->arg_password_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_username (
    QmiMessageWdsStartNetworkInput *self,
    const gchar **value_username,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_username_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Username' was not found in the message");
        return FALSE;
    }

    if (value_username)
        *value_username = self->arg_username;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_username (
    QmiMessageWdsStartNetworkInput *self,
    const gchar *value_username,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_username);
    self->arg_username = g_strdup (value_username ? value_username : "");
    self->arg_username_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_authentication_preference (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsAuthentication *value_authentication_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_authentication_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Authentication Preference' was not found in the message");
        return FALSE;
    }

    if (value_authentication_preference)
        *value_authentication_preference = (QmiWdsAuthentication)(self->arg_authentication_preference);

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_authentication_preference (
    QmiMessageWdsStartNetworkInput *self,
    QmiWdsAuthentication value_authentication_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_authentication_preference = (guint8)(value_authentication_preference);
    self->arg_authentication_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_ipv4_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 *value_ipv4_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv4_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv4 Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv4_address_preference)
        *value_ipv4_address_preference = self->arg_ipv4_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_ipv4_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 value_ipv4_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_ipv4_address_preference = value_ipv4_address_preference;
    self->arg_ipv4_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_apn (
    QmiMessageWdsStartNetworkInput *self,
    const gchar **value_apn,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_apn_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'APN' was not found in the message");
        return FALSE;
    }

    if (value_apn)
        *value_apn = self->arg_apn;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_apn (
    QmiMessageWdsStartNetworkInput *self,
    const gchar *value_apn,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_apn);
    self->arg_apn = g_strdup (value_apn ? value_apn : "");
    self->arg_apn_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_secondary_nbns_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 *value_secondary_nbns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_secondary_nbns_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Secondary NBNS Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_secondary_nbns_address_preference)
        *value_secondary_nbns_address_preference = self->arg_secondary_nbns_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_secondary_nbns_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 value_secondary_nbns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_secondary_nbns_address_preference = value_secondary_nbns_address_preference;
    self->arg_secondary_nbns_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_primary_nbns_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 *value_primary_nbns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_primary_nbns_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Primary NBNS Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_primary_nbns_address_preference)
        *value_primary_nbns_address_preference = self->arg_primary_nbns_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_primary_nbns_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 value_primary_nbns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_primary_nbns_address_preference = value_primary_nbns_address_preference;
    self->arg_primary_nbns_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_secondary_dns_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 *value_secondary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_secondary_dns_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Secondary DNS Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_secondary_dns_address_preference)
        *value_secondary_dns_address_preference = self->arg_secondary_dns_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_secondary_dns_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 value_secondary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_secondary_dns_address_preference = value_secondary_dns_address_preference;
    self->arg_secondary_dns_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_get_primary_dns_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 *value_primary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_primary_dns_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Primary DNS Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_primary_dns_address_preference)
        *value_primary_dns_address_preference = self->arg_primary_dns_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_input_set_primary_dns_address_preference (
    QmiMessageWdsStartNetworkInput *self,
    guint32 value_primary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_primary_dns_address_preference = value_primary_dns_address_preference;
    self->arg_primary_dns_address_preference_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_start_network_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsStartNetworkInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_start_network_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_start_network_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsStartNetworkInput *
qmi_message_wds_start_network_input_ref (QmiMessageWdsStartNetworkInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_start_network_input_unref (QmiMessageWdsStartNetworkInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_password, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_username, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_apn, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageWdsStartNetworkInput, self);
    }
}

QmiMessageWdsStartNetworkInput *
qmi_message_wds_start_network_input_new (void)
{
    QmiMessageWdsStartNetworkInput *self;

    self = g_slice_new0 (QmiMessageWdsStartNetworkInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_start_network_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsStartNetworkInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_START_NETWORK);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'Call Type' TLV */
    if (input->arg_call_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_CALL_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Call Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_call_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Call Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Call Type': ");
            return NULL;
        }
    }

    /* Try to add the 'Extended Technology Preference' TLV */
    if (input->arg_extended_technology_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_EXTENDED_TECHNOLOGY_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Extended Technology Preference': ");
            return NULL;
        }

        {
            guint16 tmp;

            tmp = (guint16) input->arg_extended_technology_preference;
            /* Write the guint16 variable to the buffer */
            if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Extended Technology Preference': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Extended Technology Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'Enable Autoconnect' TLV */
    if (input->arg_enable_autoconnect_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_ENABLE_AUTOCONNECT, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Enable Autoconnect': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_enable_autoconnect;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Enable Autoconnect': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Enable Autoconnect': ");
            return NULL;
        }
    }

    /* Try to add the 'Profile Index 3GPP2' TLV */
    if (input->arg_profile_index_3gpp2_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PROFILE_INDEX_3GPP2, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile Index 3GPP2': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_profile_index_3gpp2, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Profile Index 3GPP2': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile Index 3GPP2': ");
            return NULL;
        }
    }

    /* Try to add the 'Profile Index 3GPP' TLV */
    if (input->arg_profile_index_3gpp_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PROFILE_INDEX_3GPP, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile Index 3GPP': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_profile_index_3gpp, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Profile Index 3GPP': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile Index 3GPP': ");
            return NULL;
        }
    }

    /* Try to add the 'Technology Preference' TLV */
    if (input->arg_technology_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_TECHNOLOGY_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Technology Preference': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_technology_preference;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Technology Preference': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Technology Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'IP Family Preference' TLV */
    if (input->arg_ip_family_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_IP_FAMILY_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IP Family Preference': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_ip_family_preference;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'IP Family Preference': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IP Family Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'Password' TLV */
    if (input->arg_password_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PASSWORD, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Password': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_password, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Password': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Password': ");
            return NULL;
        }
    }

    /* Try to add the 'Username' TLV */
    if (input->arg_username_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_USERNAME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Username': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_username, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Username': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Username': ");
            return NULL;
        }
    }

    /* Try to add the 'Authentication Preference' TLV */
    if (input->arg_authentication_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_AUTHENTICATION_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Authentication Preference': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_authentication_preference;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Authentication Preference': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Authentication Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv4 Address Preference' TLV */
    if (input->arg_ipv4_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_IPV4_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv4 Address Preference': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_ipv4_address_preference, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'IPv4 Address Preference': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv4 Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'APN' TLV */
    if (input->arg_apn_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_APN, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'APN': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_apn, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'APN': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'APN': ");
            return NULL;
        }
    }

    /* Try to add the 'Secondary NBNS Address Preference' TLV */
    if (input->arg_secondary_nbns_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_SECONDARY_NBNS_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Secondary NBNS Address Preference': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_secondary_nbns_address_preference, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Secondary NBNS Address Preference': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Secondary NBNS Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'Primary NBNS Address Preference' TLV */
    if (input->arg_primary_nbns_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PRIMARY_NBNS_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Primary NBNS Address Preference': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_primary_nbns_address_preference, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Primary NBNS Address Preference': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Primary NBNS Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'Secondary DNS Address Preference' TLV */
    if (input->arg_secondary_dns_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_SECONDARY_DNS_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Secondary DNS Address Preference': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_secondary_dns_address_preference, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Secondary DNS Address Preference': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Secondary DNS Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'Primary DNS Address Preference' TLV */
    if (input->arg_primary_dns_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PRIMARY_DNS_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Primary DNS Address Preference': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_primary_dns_address_preference, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Primary DNS Address Preference': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Primary DNS Address Preference': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsStartNetworkOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Packet Data Handle */
    gboolean arg_packet_data_handle_set;
    guint32 arg_packet_data_handle;

    /* Call End Reason */
    gboolean arg_call_end_reason_set;
    guint16 arg_call_end_reason;

    /* Verbose Call End Reason */
    gboolean arg_verbose_call_end_reason_set;
    guint16 arg_verbose_call_end_reason_type;
    gint16 arg_verbose_call_end_reason_reason;
};

#define QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_PACKET_DATA_HANDLE 0x01
#define QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_CALL_END_REASON 0x10
#define QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_VERBOSE_CALL_END_REASON 0x11

gboolean
qmi_message_wds_start_network_output_get_result (
    QmiMessageWdsStartNetworkOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_start_network_output_get_packet_data_handle (
    QmiMessageWdsStartNetworkOutput *self,
    guint32 *value_packet_data_handle,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_packet_data_handle_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Packet Data Handle' was not found in the message");
        return FALSE;
    }

    if (value_packet_data_handle)
        *value_packet_data_handle = self->arg_packet_data_handle;

    return TRUE;
}

gboolean
qmi_message_wds_start_network_output_get_call_end_reason (
    QmiMessageWdsStartNetworkOutput *self,
    QmiWdsCallEndReason *value_call_end_reason,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_call_end_reason_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Call End Reason' was not found in the message");
        return FALSE;
    }

    if (value_call_end_reason)
        *value_call_end_reason = (QmiWdsCallEndReason)(self->arg_call_end_reason);

    return TRUE;
}

gboolean
qmi_message_wds_start_network_output_get_verbose_call_end_reason (
    QmiMessageWdsStartNetworkOutput *self,
    QmiWdsVerboseCallEndReasonType *value_verbose_call_end_reason_type,
    gint16 *value_verbose_call_end_reason_reason,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_verbose_call_end_reason_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Verbose Call End Reason' was not found in the message");
        return FALSE;
    }

    if (value_verbose_call_end_reason_type)
        *value_verbose_call_end_reason_type = (QmiWdsVerboseCallEndReasonType)(self->arg_verbose_call_end_reason_type);
    if (value_verbose_call_end_reason_reason)
        *value_verbose_call_end_reason_reason = self->arg_verbose_call_end_reason_reason;

    return TRUE;
}

GType
qmi_message_wds_start_network_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsStartNetworkOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_start_network_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_start_network_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsStartNetworkOutput *
qmi_message_wds_start_network_output_ref (QmiMessageWdsStartNetworkOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_start_network_output_unref (QmiMessageWdsStartNetworkOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsStartNetworkOutput, self);
    }
}

static gchar *
qmi_message_wds_start_network_input_call_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_CALL_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_CALL_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_call_type_get_string ((QmiWdsCallType)tmp));
#elif defined  __QMI_WDS_CALL_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_call_type_build_string_from_mask ((QmiWdsCallType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsCallType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_extended_technology_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_EXTENDED_TECHNOLOGY_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_EXTENDED_TECHNOLOGY_PREFERENCE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_extended_technology_preference_get_string ((QmiWdsExtendedTechnologyPreference)tmp));
#elif defined  __QMI_WDS_EXTENDED_TECHNOLOGY_PREFERENCE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_extended_technology_preference_build_string_from_mask ((QmiWdsExtendedTechnologyPreference)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsExtendedTechnologyPreference
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_enable_autoconnect_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_ENABLE_AUTOCONNECT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_profile_index_3gpp2_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PROFILE_INDEX_3GPP2, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_profile_index_3gpp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PROFILE_INDEX_3GPP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_technology_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_TECHNOLOGY_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TECHNOLOGY_PREFERENCE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_technology_preference_get_string ((QmiWdsTechnologyPreference)tmp));
#elif defined  __QMI_WDS_TECHNOLOGY_PREFERENCE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_technology_preference_build_string_from_mask ((QmiWdsTechnologyPreference)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTechnologyPreference
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_ip_family_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_IP_FAMILY_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_IP_FAMILY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_ip_family_get_string ((QmiWdsIpFamily)tmp));
#elif defined  __QMI_WDS_IP_FAMILY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_ip_family_build_string_from_mask ((QmiWdsIpFamily)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsIpFamily
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_password_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PASSWORD, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_username_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_USERNAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_authentication_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_AUTHENTICATION_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_AUTHENTICATION_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_authentication_get_string ((QmiWdsAuthentication)tmp));
#elif defined  __QMI_WDS_AUTHENTICATION_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_authentication_build_string_from_mask ((QmiWdsAuthentication)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsAuthentication
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_ipv4_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_IPV4_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_apn_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_APN, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_secondary_nbns_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_SECONDARY_NBNS_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_primary_nbns_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PRIMARY_NBNS_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_secondary_dns_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_SECONDARY_DNS_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_input_primary_dns_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PRIMARY_DNS_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_output_packet_data_handle_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_PACKET_DATA_HANDLE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_output_call_end_reason_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_CALL_END_REASON, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_CALL_END_REASON_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_call_end_reason_get_string ((QmiWdsCallEndReason)tmp));
#elif defined  __QMI_WDS_CALL_END_REASON_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_call_end_reason_build_string_from_mask ((QmiWdsCallEndReason)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsCallEndReason
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_start_network_output_verbose_call_end_reason_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_VERBOSE_CALL_END_REASON, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " type = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_VERBOSE_CALL_END_REASON_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_verbose_call_end_reason_type_get_string ((QmiWdsVerboseCallEndReasonType)tmp));
#elif defined  __QMI_WDS_VERBOSE_CALL_END_REASON_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_verbose_call_end_reason_type_build_string_from_mask ((QmiWdsVerboseCallEndReasonType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsVerboseCallEndReasonType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reason = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_start_network_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_start_network_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_start_network_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_CALL_TYPE:
            tlv_type_str = "Call Type";
            translated_value = qmi_message_wds_start_network_input_call_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_EXTENDED_TECHNOLOGY_PREFERENCE:
            tlv_type_str = "Extended Technology Preference";
            translated_value = qmi_message_wds_start_network_input_extended_technology_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_ENABLE_AUTOCONNECT:
            tlv_type_str = "Enable Autoconnect";
            translated_value = qmi_message_wds_start_network_input_enable_autoconnect_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PROFILE_INDEX_3GPP2:
            tlv_type_str = "Profile Index 3GPP2";
            translated_value = qmi_message_wds_start_network_input_profile_index_3gpp2_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PROFILE_INDEX_3GPP:
            tlv_type_str = "Profile Index 3GPP";
            translated_value = qmi_message_wds_start_network_input_profile_index_3gpp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_TECHNOLOGY_PREFERENCE:
            tlv_type_str = "Technology Preference";
            translated_value = qmi_message_wds_start_network_input_technology_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_IP_FAMILY_PREFERENCE:
            tlv_type_str = "IP Family Preference";
            translated_value = qmi_message_wds_start_network_input_ip_family_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PASSWORD:
            tlv_type_str = "Password";
            translated_value = qmi_message_wds_start_network_input_password_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_USERNAME:
            tlv_type_str = "Username";
            translated_value = qmi_message_wds_start_network_input_username_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_AUTHENTICATION_PREFERENCE:
            tlv_type_str = "Authentication Preference";
            translated_value = qmi_message_wds_start_network_input_authentication_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_IPV4_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv4 Address Preference";
            translated_value = qmi_message_wds_start_network_input_ipv4_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_APN:
            tlv_type_str = "APN";
            translated_value = qmi_message_wds_start_network_input_apn_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_SECONDARY_NBNS_ADDRESS_PREFERENCE:
            tlv_type_str = "Secondary NBNS Address Preference";
            translated_value = qmi_message_wds_start_network_input_secondary_nbns_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PRIMARY_NBNS_ADDRESS_PREFERENCE:
            tlv_type_str = "Primary NBNS Address Preference";
            translated_value = qmi_message_wds_start_network_input_primary_nbns_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_SECONDARY_DNS_ADDRESS_PREFERENCE:
            tlv_type_str = "Secondary DNS Address Preference";
            translated_value = qmi_message_wds_start_network_input_secondary_dns_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_INPUT_TLV_PRIMARY_DNS_ADDRESS_PREFERENCE:
            tlv_type_str = "Primary DNS Address Preference";
            translated_value = qmi_message_wds_start_network_input_primary_dns_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_PACKET_DATA_HANDLE:
            tlv_type_str = "Packet Data Handle";
            translated_value = qmi_message_wds_start_network_output_packet_data_handle_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_CALL_END_REASON:
            tlv_type_str = "Call End Reason";
            translated_value = qmi_message_wds_start_network_output_call_end_reason_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_VERBOSE_CALL_END_REASON:
            tlv_type_str = "Verbose Call End Reason";
            translated_value = qmi_message_wds_start_network_output_verbose_call_end_reason_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_start_network_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Start Network\" (0x0020)\n",
                            line_prefix);

    {
        struct message_start_network_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_start_network_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsStartNetworkOutput *
__qmi_message_wds_start_network_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsStartNetworkOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_START_NETWORK);

    self = g_slice_new0 (QmiMessageWdsStartNetworkOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_start_network_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_start_network_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_PACKET_DATA_HANDLE, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Packet Data Handle TLV: ");
                qmi_message_wds_start_network_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_packet_data_handle), error))
                goto qmi_message_wds_start_network_output_packet_data_handle_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Packet Data Handle' TLV", offset);
            }

            self->arg_packet_data_handle_set = TRUE;

qmi_message_wds_start_network_output_packet_data_handle_out:
            if (!self->arg_packet_data_handle_set) {
                qmi_message_wds_start_network_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;
        /* Prerequisite.... */
        if (!(self->arg_result_error_code == QMI_PROTOCOL_ERROR_CALL_FAILED))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_CALL_END_REASON, NULL, NULL)) == 0) {
                goto qmi_message_wds_start_network_output_call_end_reason_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_wds_start_network_output_call_end_reason_out;
                self->arg_call_end_reason = (QmiWdsCallEndReason)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Call End Reason' TLV", offset);
            }

            self->arg_call_end_reason_set = TRUE;

qmi_message_wds_start_network_output_call_end_reason_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;
        /* Prerequisite.... */
        if (!(self->arg_result_error_code == QMI_PROTOCOL_ERROR_CALL_FAILED))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_START_NETWORK_OUTPUT_TLV_VERBOSE_CALL_END_REASON, NULL, NULL)) == 0) {
                goto qmi_message_wds_start_network_output_verbose_call_end_reason_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_wds_start_network_output_verbose_call_end_reason_out;
                self->arg_verbose_call_end_reason_type = (QmiWdsVerboseCallEndReasonType)tmp;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_verbose_call_end_reason_reason), NULL))
                goto qmi_message_wds_start_network_output_verbose_call_end_reason_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Verbose Call End Reason' TLV", offset);
            }

            self->arg_verbose_call_end_reason_set = TRUE;

qmi_message_wds_start_network_output_verbose_call_end_reason_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Stop Network */


/* --- Input -- */

struct _QmiMessageWdsStopNetworkInput {
    volatile gint ref_count;

    /* Disable Autoconnect */
    gboolean arg_disable_autoconnect_set;
    guint8 arg_disable_autoconnect;

    /* Packet Data Handle */
    gboolean arg_packet_data_handle_set;
    guint32 arg_packet_data_handle;
};

#define QMI_MESSAGE_WDS_STOP_NETWORK_INPUT_TLV_DISABLE_AUTOCONNECT 0x10
#define QMI_MESSAGE_WDS_STOP_NETWORK_INPUT_TLV_PACKET_DATA_HANDLE 0x01

gboolean
qmi_message_wds_stop_network_input_get_disable_autoconnect (
    QmiMessageWdsStopNetworkInput *self,
    gboolean *value_disable_autoconnect,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_disable_autoconnect_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Disable Autoconnect' was not found in the message");
        return FALSE;
    }

    if (value_disable_autoconnect)
        *value_disable_autoconnect = (gboolean)(self->arg_disable_autoconnect);

    return TRUE;
}

gboolean
qmi_message_wds_stop_network_input_set_disable_autoconnect (
    QmiMessageWdsStopNetworkInput *self,
    gboolean value_disable_autoconnect,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_disable_autoconnect = (guint8)(value_disable_autoconnect);
    self->arg_disable_autoconnect_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_stop_network_input_get_packet_data_handle (
    QmiMessageWdsStopNetworkInput *self,
    guint32 *value_packet_data_handle,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_packet_data_handle_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Packet Data Handle' was not found in the message");
        return FALSE;
    }

    if (value_packet_data_handle)
        *value_packet_data_handle = self->arg_packet_data_handle;

    return TRUE;
}

gboolean
qmi_message_wds_stop_network_input_set_packet_data_handle (
    QmiMessageWdsStopNetworkInput *self,
    guint32 value_packet_data_handle,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_packet_data_handle = value_packet_data_handle;
    self->arg_packet_data_handle_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_stop_network_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsStopNetworkInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_stop_network_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_stop_network_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsStopNetworkInput *
qmi_message_wds_stop_network_input_ref (QmiMessageWdsStopNetworkInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_stop_network_input_unref (QmiMessageWdsStopNetworkInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsStopNetworkInput, self);
    }
}

QmiMessageWdsStopNetworkInput *
qmi_message_wds_stop_network_input_new (void)
{
    QmiMessageWdsStopNetworkInput *self;

    self = g_slice_new0 (QmiMessageWdsStopNetworkInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_stop_network_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsStopNetworkInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_STOP_NETWORK);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Stop Network' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Disable Autoconnect' TLV */
    if (input->arg_disable_autoconnect_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_STOP_NETWORK_INPUT_TLV_DISABLE_AUTOCONNECT, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Disable Autoconnect': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_disable_autoconnect;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Disable Autoconnect': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Disable Autoconnect': ");
            return NULL;
        }
    }

    /* Try to add the 'Packet Data Handle' TLV */
    if (input->arg_packet_data_handle_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_STOP_NETWORK_INPUT_TLV_PACKET_DATA_HANDLE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Packet Data Handle': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_packet_data_handle, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Packet Data Handle': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Packet Data Handle': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Packet Data Handle' in message 'Stop Network'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsStopNetworkOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_WDS_STOP_NETWORK_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_wds_stop_network_output_get_result (
    QmiMessageWdsStopNetworkOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_wds_stop_network_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsStopNetworkOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_stop_network_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_stop_network_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsStopNetworkOutput *
qmi_message_wds_stop_network_output_ref (QmiMessageWdsStopNetworkOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_stop_network_output_unref (QmiMessageWdsStopNetworkOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsStopNetworkOutput, self);
    }
}

static gchar *
qmi_message_wds_stop_network_input_disable_autoconnect_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_STOP_NETWORK_INPUT_TLV_DISABLE_AUTOCONNECT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_stop_network_input_packet_data_handle_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_STOP_NETWORK_INPUT_TLV_PACKET_DATA_HANDLE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_stop_network_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_stop_network_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_stop_network_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_STOP_NETWORK_INPUT_TLV_DISABLE_AUTOCONNECT:
            tlv_type_str = "Disable Autoconnect";
            translated_value = qmi_message_wds_stop_network_input_disable_autoconnect_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_STOP_NETWORK_INPUT_TLV_PACKET_DATA_HANDLE:
            tlv_type_str = "Packet Data Handle";
            translated_value = qmi_message_wds_stop_network_input_packet_data_handle_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_STOP_NETWORK_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_stop_network_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Stop Network\" (0x0021)\n",
                            line_prefix);

    {
        struct message_stop_network_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_stop_network_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsStopNetworkOutput *
__qmi_message_wds_stop_network_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsStopNetworkOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_STOP_NETWORK);

    self = g_slice_new0 (QmiMessageWdsStopNetworkOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_STOP_NETWORK_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_stop_network_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_stop_network_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Get Packet Service Status */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_wds_get_packet_service_status_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsGetPacketServiceStatusOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Connection Status */
    gboolean arg_connection_status_set;
    guint8 arg_connection_status;
};

#define QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS_OUTPUT_TLV_CONNECTION_STATUS 0x01

gboolean
qmi_message_wds_get_packet_service_status_output_get_result (
    QmiMessageWdsGetPacketServiceStatusOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_get_packet_service_status_output_get_connection_status (
    QmiMessageWdsGetPacketServiceStatusOutput *self,
    QmiWdsConnectionStatus *value_connection_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_connection_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Connection Status' was not found in the message");
        return FALSE;
    }

    if (value_connection_status)
        *value_connection_status = (QmiWdsConnectionStatus)(self->arg_connection_status);

    return TRUE;
}

GType
qmi_message_wds_get_packet_service_status_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGetPacketServiceStatusOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_get_packet_service_status_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_get_packet_service_status_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGetPacketServiceStatusOutput *
qmi_message_wds_get_packet_service_status_output_ref (QmiMessageWdsGetPacketServiceStatusOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_get_packet_service_status_output_unref (QmiMessageWdsGetPacketServiceStatusOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsGetPacketServiceStatusOutput, self);
    }
}

static gchar *
qmi_message_wds_get_packet_service_status_output_connection_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS_OUTPUT_TLV_CONNECTION_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_CONNECTION_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_connection_status_get_string ((QmiWdsConnectionStatus)tmp));
#elif defined  __QMI_WDS_CONNECTION_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_connection_status_build_string_from_mask ((QmiWdsConnectionStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsConnectionStatus
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_packet_service_status_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_packet_service_status_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_packet_service_status_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS_OUTPUT_TLV_CONNECTION_STATUS:
            tlv_type_str = "Connection Status";
            translated_value = qmi_message_wds_get_packet_service_status_output_connection_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_packet_service_status_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Packet Service Status\" (0x0022)\n",
                            line_prefix);

    {
        struct message_get_packet_service_status_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_packet_service_status_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsGetPacketServiceStatusOutput *
__qmi_message_wds_get_packet_service_status_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsGetPacketServiceStatusOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS);

    self = g_slice_new0 (QmiMessageWdsGetPacketServiceStatusOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_get_packet_service_status_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_get_packet_service_status_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_SERVICE_STATUS_OUTPUT_TLV_CONNECTION_STATUS, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Connection Status TLV: ");
                qmi_message_wds_get_packet_service_status_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_wds_get_packet_service_status_output_connection_status_out;
                self->arg_connection_status = (QmiWdsConnectionStatus)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Connection Status' TLV", offset);
            }

            self->arg_connection_status_set = TRUE;

qmi_message_wds_get_packet_service_status_output_connection_status_out:
            if (!self->arg_connection_status_set) {
                qmi_message_wds_get_packet_service_status_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Get Channel Rates */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_wds_get_channel_rates_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_GET_CHANNEL_RATES);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsGetChannelRatesOutput {
    volatile gint ref_count;

    /* Channel Rates */
    gboolean arg_channel_rates_set;
    guint32 arg_channel_rates_channel_tx_rate_bps;
    guint32 arg_channel_rates_channel_rx_rate_bps;
    guint32 arg_channel_rates_max_channel_tx_rate_bps;
    guint32 arg_channel_rates_max_channel_rx_rate_bps;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_WDS_GET_CHANNEL_RATES_OUTPUT_TLV_CHANNEL_RATES 0x01
#define QMI_MESSAGE_WDS_GET_CHANNEL_RATES_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_wds_get_channel_rates_output_get_channel_rates (
    QmiMessageWdsGetChannelRatesOutput *self,
    guint32 *value_channel_rates_channel_tx_rate_bps,
    guint32 *value_channel_rates_channel_rx_rate_bps,
    guint32 *value_channel_rates_max_channel_tx_rate_bps,
    guint32 *value_channel_rates_max_channel_rx_rate_bps,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_channel_rates_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Channel Rates' was not found in the message");
        return FALSE;
    }

    if (value_channel_rates_channel_tx_rate_bps)
        *value_channel_rates_channel_tx_rate_bps = self->arg_channel_rates_channel_tx_rate_bps;
    if (value_channel_rates_channel_rx_rate_bps)
        *value_channel_rates_channel_rx_rate_bps = self->arg_channel_rates_channel_rx_rate_bps;
    if (value_channel_rates_max_channel_tx_rate_bps)
        *value_channel_rates_max_channel_tx_rate_bps = self->arg_channel_rates_max_channel_tx_rate_bps;
    if (value_channel_rates_max_channel_rx_rate_bps)
        *value_channel_rates_max_channel_rx_rate_bps = self->arg_channel_rates_max_channel_rx_rate_bps;

    return TRUE;
}

gboolean
qmi_message_wds_get_channel_rates_output_get_result (
    QmiMessageWdsGetChannelRatesOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_wds_get_channel_rates_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGetChannelRatesOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_get_channel_rates_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_get_channel_rates_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGetChannelRatesOutput *
qmi_message_wds_get_channel_rates_output_ref (QmiMessageWdsGetChannelRatesOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_get_channel_rates_output_unref (QmiMessageWdsGetChannelRatesOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsGetChannelRatesOutput, self);
    }
}

static gchar *
qmi_message_wds_get_channel_rates_output_channel_rates_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_CHANNEL_RATES_OUTPUT_TLV_CHANNEL_RATES, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " channel_tx_rate_bps = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " channel_rx_rate_bps = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_channel_tx_rate_bps = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_channel_rx_rate_bps = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_channel_rates_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_channel_rates_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_channel_rates_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_GET_CHANNEL_RATES_OUTPUT_TLV_CHANNEL_RATES:
            tlv_type_str = "Channel Rates";
            translated_value = qmi_message_wds_get_channel_rates_output_channel_rates_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_CHANNEL_RATES_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_channel_rates_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Channel Rates\" (0x0023)\n",
                            line_prefix);

    {
        struct message_get_channel_rates_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_channel_rates_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsGetChannelRatesOutput *
__qmi_message_wds_get_channel_rates_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsGetChannelRatesOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_GET_CHANNEL_RATES);

    self = g_slice_new0 (QmiMessageWdsGetChannelRatesOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_CHANNEL_RATES_OUTPUT_TLV_CHANNEL_RATES, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Channel Rates TLV: ");
                qmi_message_wds_get_channel_rates_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_channel_rates_channel_tx_rate_bps), error))
                goto qmi_message_wds_get_channel_rates_output_channel_rates_out;
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_channel_rates_channel_rx_rate_bps), error))
                goto qmi_message_wds_get_channel_rates_output_channel_rates_out;
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_channel_rates_max_channel_tx_rate_bps), error))
                goto qmi_message_wds_get_channel_rates_output_channel_rates_out;
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_channel_rates_max_channel_rx_rate_bps), error))
                goto qmi_message_wds_get_channel_rates_output_channel_rates_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Channel Rates' TLV", offset);
            }

            self->arg_channel_rates_set = TRUE;

qmi_message_wds_get_channel_rates_output_channel_rates_out:
            if (!self->arg_channel_rates_set) {
                qmi_message_wds_get_channel_rates_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_CHANNEL_RATES_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_get_channel_rates_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_get_channel_rates_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Get Packet Statistics */


/* --- Input -- */

struct _QmiMessageWdsGetPacketStatisticsInput {
    volatile gint ref_count;

    /* Mask */
    gboolean arg_mask_set;
    guint32 arg_mask;
};

#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_INPUT_TLV_MASK 0x01

gboolean
qmi_message_wds_get_packet_statistics_input_get_mask (
    QmiMessageWdsGetPacketStatisticsInput *self,
    QmiWdsPacketStatisticsMaskFlag *value_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mask_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Mask' was not found in the message");
        return FALSE;
    }

    if (value_mask)
        *value_mask = (QmiWdsPacketStatisticsMaskFlag)(self->arg_mask);

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_input_set_mask (
    QmiMessageWdsGetPacketStatisticsInput *self,
    QmiWdsPacketStatisticsMaskFlag value_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_mask = (guint32)(value_mask);
    self->arg_mask_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_get_packet_statistics_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGetPacketStatisticsInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_get_packet_statistics_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_get_packet_statistics_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGetPacketStatisticsInput *
qmi_message_wds_get_packet_statistics_input_ref (QmiMessageWdsGetPacketStatisticsInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_get_packet_statistics_input_unref (QmiMessageWdsGetPacketStatisticsInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsGetPacketStatisticsInput, self);
    }
}

QmiMessageWdsGetPacketStatisticsInput *
qmi_message_wds_get_packet_statistics_input_new (void)
{
    QmiMessageWdsGetPacketStatisticsInput *self;

    self = g_slice_new0 (QmiMessageWdsGetPacketStatisticsInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_get_packet_statistics_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsGetPacketStatisticsInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_GET_PACKET_STATISTICS);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Get Packet Statistics' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Mask' TLV */
    if (input->arg_mask_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_INPUT_TLV_MASK, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Mask': ");
            return NULL;
        }

        {
            guint32 tmp;

            tmp = (guint32) input->arg_mask;
            /* Write the guint32 variable to the buffer */
            if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Mask': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Mask': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Mask' in message 'Get Packet Statistics'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsGetPacketStatisticsOutput {
    volatile gint ref_count;

    /* Last Call Rx Bytes Ok */
    gboolean arg_last_call_rx_bytes_ok_set;
    guint64 arg_last_call_rx_bytes_ok;

    /* Last Call Tx Bytes Ok */
    gboolean arg_last_call_tx_bytes_ok_set;
    guint64 arg_last_call_tx_bytes_ok;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Tx Packets Ok */
    gboolean arg_tx_packets_ok_set;
    guint32 arg_tx_packets_ok;

    /* Rx Packets Ok */
    gboolean arg_rx_packets_ok_set;
    guint32 arg_rx_packets_ok;

    /* Tx Packets Error */
    gboolean arg_tx_packets_error_set;
    guint32 arg_tx_packets_error;

    /* Rx Packets Error */
    gboolean arg_rx_packets_error_set;
    guint32 arg_rx_packets_error;

    /* Tx Overflows */
    gboolean arg_tx_overflows_set;
    guint32 arg_tx_overflows;

    /* Rx Overflows */
    gboolean arg_rx_overflows_set;
    guint32 arg_rx_overflows;

    /* Tx Bytes Ok */
    gboolean arg_tx_bytes_ok_set;
    guint64 arg_tx_bytes_ok;

    /* Rx Bytes Ok */
    gboolean arg_rx_bytes_ok_set;
    guint64 arg_rx_bytes_ok;

    /* Tx Packets Dropped */
    gboolean arg_tx_packets_dropped_set;
    guint32 arg_tx_packets_dropped;

    /* Rx Packets Dropped */
    gboolean arg_rx_packets_dropped_set;
    guint32 arg_rx_packets_dropped;
};

#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_LAST_CALL_RX_BYTES_OK 0x1C
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_LAST_CALL_TX_BYTES_OK 0x1B
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_OK 0x10
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_OK 0x11
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_ERROR 0x12
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_ERROR 0x13
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_OVERFLOWS 0x14
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_OVERFLOWS 0x15
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_BYTES_OK 0x19
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_BYTES_OK 0x1A
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_DROPPED 0x1D
#define QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_DROPPED 0x1E

gboolean
qmi_message_wds_get_packet_statistics_output_get_last_call_rx_bytes_ok (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint64 *value_last_call_rx_bytes_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_last_call_rx_bytes_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Last Call Rx Bytes Ok' was not found in the message");
        return FALSE;
    }

    if (value_last_call_rx_bytes_ok)
        *value_last_call_rx_bytes_ok = self->arg_last_call_rx_bytes_ok;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_last_call_tx_bytes_ok (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint64 *value_last_call_tx_bytes_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_last_call_tx_bytes_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Last Call Tx Bytes Ok' was not found in the message");
        return FALSE;
    }

    if (value_last_call_tx_bytes_ok)
        *value_last_call_tx_bytes_ok = self->arg_last_call_tx_bytes_ok;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_result (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_tx_packets_ok (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint32 *value_tx_packets_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_packets_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Packets Ok' was not found in the message");
        return FALSE;
    }

    if (value_tx_packets_ok)
        *value_tx_packets_ok = self->arg_tx_packets_ok;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_rx_packets_ok (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint32 *value_rx_packets_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_packets_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Packets Ok' was not found in the message");
        return FALSE;
    }

    if (value_rx_packets_ok)
        *value_rx_packets_ok = self->arg_rx_packets_ok;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_tx_packets_error (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint32 *value_tx_packets_error,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_packets_error_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Packets Error' was not found in the message");
        return FALSE;
    }

    if (value_tx_packets_error)
        *value_tx_packets_error = self->arg_tx_packets_error;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_rx_packets_error (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint32 *value_rx_packets_error,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_packets_error_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Packets Error' was not found in the message");
        return FALSE;
    }

    if (value_rx_packets_error)
        *value_rx_packets_error = self->arg_rx_packets_error;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_tx_overflows (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint32 *value_tx_overflows,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_overflows_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Overflows' was not found in the message");
        return FALSE;
    }

    if (value_tx_overflows)
        *value_tx_overflows = self->arg_tx_overflows;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_rx_overflows (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint32 *value_rx_overflows,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_overflows_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Overflows' was not found in the message");
        return FALSE;
    }

    if (value_rx_overflows)
        *value_rx_overflows = self->arg_rx_overflows;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_tx_bytes_ok (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint64 *value_tx_bytes_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_bytes_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Bytes Ok' was not found in the message");
        return FALSE;
    }

    if (value_tx_bytes_ok)
        *value_tx_bytes_ok = self->arg_tx_bytes_ok;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_rx_bytes_ok (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint64 *value_rx_bytes_ok,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_bytes_ok_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Bytes Ok' was not found in the message");
        return FALSE;
    }

    if (value_rx_bytes_ok)
        *value_rx_bytes_ok = self->arg_rx_bytes_ok;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_tx_packets_dropped (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint32 *value_tx_packets_dropped,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tx_packets_dropped_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Tx Packets Dropped' was not found in the message");
        return FALSE;
    }

    if (value_tx_packets_dropped)
        *value_tx_packets_dropped = self->arg_tx_packets_dropped;

    return TRUE;
}

gboolean
qmi_message_wds_get_packet_statistics_output_get_rx_packets_dropped (
    QmiMessageWdsGetPacketStatisticsOutput *self,
    guint32 *value_rx_packets_dropped,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rx_packets_dropped_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Rx Packets Dropped' was not found in the message");
        return FALSE;
    }

    if (value_rx_packets_dropped)
        *value_rx_packets_dropped = self->arg_rx_packets_dropped;

    return TRUE;
}

GType
qmi_message_wds_get_packet_statistics_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGetPacketStatisticsOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_get_packet_statistics_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_get_packet_statistics_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGetPacketStatisticsOutput *
qmi_message_wds_get_packet_statistics_output_ref (QmiMessageWdsGetPacketStatisticsOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_get_packet_statistics_output_unref (QmiMessageWdsGetPacketStatisticsOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsGetPacketStatisticsOutput, self);
    }
}

static gchar *
qmi_message_wds_get_packet_statistics_input_mask_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_INPUT_TLV_MASK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PACKET_STATISTICS_MASK_FLAG_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_packet_statistics_mask_flag_get_string ((QmiWdsPacketStatisticsMaskFlag)tmp));
#elif defined  __QMI_WDS_PACKET_STATISTICS_MASK_FLAG_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_packet_statistics_mask_flag_build_string_from_mask ((QmiWdsPacketStatisticsMaskFlag)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsPacketStatisticsMaskFlag
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_last_call_rx_bytes_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_LAST_CALL_RX_BYTES_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_last_call_tx_bytes_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_LAST_CALL_TX_BYTES_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_tx_packets_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_rx_packets_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_tx_packets_error_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_ERROR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_rx_packets_error_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_ERROR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_tx_overflows_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_OVERFLOWS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_rx_overflows_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_OVERFLOWS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_tx_bytes_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_BYTES_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_rx_bytes_ok_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_BYTES_OK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT64_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_tx_packets_dropped_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_DROPPED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_packet_statistics_output_rx_packets_dropped_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_DROPPED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_packet_statistics_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_packet_statistics_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_packet_statistics_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_INPUT_TLV_MASK:
            tlv_type_str = "Mask";
            translated_value = qmi_message_wds_get_packet_statistics_input_mask_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_LAST_CALL_RX_BYTES_OK:
            tlv_type_str = "Last Call Rx Bytes Ok";
            translated_value = qmi_message_wds_get_packet_statistics_output_last_call_rx_bytes_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_LAST_CALL_TX_BYTES_OK:
            tlv_type_str = "Last Call Tx Bytes Ok";
            translated_value = qmi_message_wds_get_packet_statistics_output_last_call_tx_bytes_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_OK:
            tlv_type_str = "Tx Packets Ok";
            translated_value = qmi_message_wds_get_packet_statistics_output_tx_packets_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_OK:
            tlv_type_str = "Rx Packets Ok";
            translated_value = qmi_message_wds_get_packet_statistics_output_rx_packets_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_ERROR:
            tlv_type_str = "Tx Packets Error";
            translated_value = qmi_message_wds_get_packet_statistics_output_tx_packets_error_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_ERROR:
            tlv_type_str = "Rx Packets Error";
            translated_value = qmi_message_wds_get_packet_statistics_output_rx_packets_error_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_OVERFLOWS:
            tlv_type_str = "Tx Overflows";
            translated_value = qmi_message_wds_get_packet_statistics_output_tx_overflows_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_OVERFLOWS:
            tlv_type_str = "Rx Overflows";
            translated_value = qmi_message_wds_get_packet_statistics_output_rx_overflows_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_BYTES_OK:
            tlv_type_str = "Tx Bytes Ok";
            translated_value = qmi_message_wds_get_packet_statistics_output_tx_bytes_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_BYTES_OK:
            tlv_type_str = "Rx Bytes Ok";
            translated_value = qmi_message_wds_get_packet_statistics_output_rx_bytes_ok_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_DROPPED:
            tlv_type_str = "Tx Packets Dropped";
            translated_value = qmi_message_wds_get_packet_statistics_output_tx_packets_dropped_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_DROPPED:
            tlv_type_str = "Rx Packets Dropped";
            translated_value = qmi_message_wds_get_packet_statistics_output_rx_packets_dropped_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_packet_statistics_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Packet Statistics\" (0x0024)\n",
                            line_prefix);

    {
        struct message_get_packet_statistics_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_packet_statistics_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsGetPacketStatisticsOutput *
__qmi_message_wds_get_packet_statistics_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsGetPacketStatisticsOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS);

    self = g_slice_new0 (QmiMessageWdsGetPacketStatisticsOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_LAST_CALL_RX_BYTES_OK, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_last_call_rx_bytes_ok_out;
            }
            if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_last_call_rx_bytes_ok), NULL))
                goto qmi_message_wds_get_packet_statistics_output_last_call_rx_bytes_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Last Call Rx Bytes Ok' TLV", offset);
            }

            self->arg_last_call_rx_bytes_ok_set = TRUE;

qmi_message_wds_get_packet_statistics_output_last_call_rx_bytes_ok_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_LAST_CALL_TX_BYTES_OK, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_last_call_tx_bytes_ok_out;
            }
            if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_last_call_tx_bytes_ok), NULL))
                goto qmi_message_wds_get_packet_statistics_output_last_call_tx_bytes_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Last Call Tx Bytes Ok' TLV", offset);
            }

            self->arg_last_call_tx_bytes_ok_set = TRUE;

qmi_message_wds_get_packet_statistics_output_last_call_tx_bytes_ok_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_get_packet_statistics_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_get_packet_statistics_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_OK, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_tx_packets_ok_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_packets_ok), NULL))
                goto qmi_message_wds_get_packet_statistics_output_tx_packets_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Packets Ok' TLV", offset);
            }

            self->arg_tx_packets_ok_set = TRUE;

qmi_message_wds_get_packet_statistics_output_tx_packets_ok_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_OK, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_rx_packets_ok_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_packets_ok), NULL))
                goto qmi_message_wds_get_packet_statistics_output_rx_packets_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Packets Ok' TLV", offset);
            }

            self->arg_rx_packets_ok_set = TRUE;

qmi_message_wds_get_packet_statistics_output_rx_packets_ok_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_ERROR, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_tx_packets_error_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_packets_error), NULL))
                goto qmi_message_wds_get_packet_statistics_output_tx_packets_error_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Packets Error' TLV", offset);
            }

            self->arg_tx_packets_error_set = TRUE;

qmi_message_wds_get_packet_statistics_output_tx_packets_error_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_ERROR, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_rx_packets_error_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_packets_error), NULL))
                goto qmi_message_wds_get_packet_statistics_output_rx_packets_error_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Packets Error' TLV", offset);
            }

            self->arg_rx_packets_error_set = TRUE;

qmi_message_wds_get_packet_statistics_output_rx_packets_error_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_OVERFLOWS, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_tx_overflows_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_overflows), NULL))
                goto qmi_message_wds_get_packet_statistics_output_tx_overflows_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Overflows' TLV", offset);
            }

            self->arg_tx_overflows_set = TRUE;

qmi_message_wds_get_packet_statistics_output_tx_overflows_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_OVERFLOWS, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_rx_overflows_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_overflows), NULL))
                goto qmi_message_wds_get_packet_statistics_output_rx_overflows_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Overflows' TLV", offset);
            }

            self->arg_rx_overflows_set = TRUE;

qmi_message_wds_get_packet_statistics_output_rx_overflows_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_BYTES_OK, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_tx_bytes_ok_out;
            }
            if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_bytes_ok), NULL))
                goto qmi_message_wds_get_packet_statistics_output_tx_bytes_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Bytes Ok' TLV", offset);
            }

            self->arg_tx_bytes_ok_set = TRUE;

qmi_message_wds_get_packet_statistics_output_tx_bytes_ok_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_BYTES_OK, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_rx_bytes_ok_out;
            }
            if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_bytes_ok), NULL))
                goto qmi_message_wds_get_packet_statistics_output_rx_bytes_ok_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Bytes Ok' TLV", offset);
            }

            self->arg_rx_bytes_ok_set = TRUE;

qmi_message_wds_get_packet_statistics_output_rx_bytes_ok_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_TX_PACKETS_DROPPED, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_tx_packets_dropped_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_tx_packets_dropped), NULL))
                goto qmi_message_wds_get_packet_statistics_output_tx_packets_dropped_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Tx Packets Dropped' TLV", offset);
            }

            self->arg_tx_packets_dropped_set = TRUE;

qmi_message_wds_get_packet_statistics_output_tx_packets_dropped_out:
            ;

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PACKET_STATISTICS_OUTPUT_TLV_RX_PACKETS_DROPPED, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_packet_statistics_output_rx_packets_dropped_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_rx_packets_dropped), NULL))
                goto qmi_message_wds_get_packet_statistics_output_rx_packets_dropped_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Rx Packets Dropped' TLV", offset);
            }

            self->arg_rx_packets_dropped_set = TRUE;

qmi_message_wds_get_packet_statistics_output_rx_packets_dropped_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Go Dormant */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_wds_go_dormant_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_GO_DORMANT);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsGoDormantOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_WDS_GO_DORMANT_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_wds_go_dormant_output_get_result (
    QmiMessageWdsGoDormantOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_wds_go_dormant_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGoDormantOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_go_dormant_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_go_dormant_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGoDormantOutput *
qmi_message_wds_go_dormant_output_ref (QmiMessageWdsGoDormantOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_go_dormant_output_unref (QmiMessageWdsGoDormantOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsGoDormantOutput, self);
    }
}

struct message_go_dormant_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_go_dormant_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_go_dormant_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_GO_DORMANT_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_go_dormant_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Go Dormant\" (0x0025)\n",
                            line_prefix);

    {
        struct message_go_dormant_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_go_dormant_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsGoDormantOutput *
__qmi_message_wds_go_dormant_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsGoDormantOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_GO_DORMANT);

    self = g_slice_new0 (QmiMessageWdsGoDormantOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GO_DORMANT_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_go_dormant_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_go_dormant_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Go Active */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_wds_go_active_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_GO_ACTIVE);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsGoActiveOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_WDS_GO_ACTIVE_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_wds_go_active_output_get_result (
    QmiMessageWdsGoActiveOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_wds_go_active_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGoActiveOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_go_active_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_go_active_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGoActiveOutput *
qmi_message_wds_go_active_output_ref (QmiMessageWdsGoActiveOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_go_active_output_unref (QmiMessageWdsGoActiveOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsGoActiveOutput, self);
    }
}

struct message_go_active_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_go_active_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_go_active_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_GO_ACTIVE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_go_active_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Go Active\" (0x0026)\n",
                            line_prefix);

    {
        struct message_go_active_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_go_active_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsGoActiveOutput *
__qmi_message_wds_go_active_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsGoActiveOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_GO_ACTIVE);

    self = g_slice_new0 (QmiMessageWdsGoActiveOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GO_ACTIVE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_go_active_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_go_active_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Create Profile */


/* --- Input -- */

struct _QmiMessageWdsCreateProfileInput {
    volatile gint ref_count;

    /* APN Type Mask */
    gboolean arg_apn_type_mask_set;
    guint64 arg_apn_type_mask;

    /* Roaming Disallowed Flag */
    gboolean arg_roaming_disallowed_flag_set;
    guint8 arg_roaming_disallowed_flag;

    /* APN Disabled Flag */
    gboolean arg_apn_disabled_flag_set;
    guint8 arg_apn_disabled_flag;

    /* LTE QoS Parameters */
    gboolean arg_lte_qos_parameters_set;
    guint8 arg_lte_qos_parameters_qos_class_identifier;
    guint32 arg_lte_qos_parameters_guaranteed_downlink_bitrate;
    guint32 arg_lte_qos_parameters_max_downlink_bitrate;
    guint32 arg_lte_qos_parameters_guaranteed_uplink_bitrate;
    guint32 arg_lte_qos_parameters_max_uplink_bitrate;

    /* IPv6 Secondary DNS Address Preference */
    gboolean arg_ipv6_secondary_dns_address_preference_set;
    GArray *arg_ipv6_secondary_dns_address_preference;

    /* IPv6 Primary DNS Address Preference */
    gboolean arg_ipv6_primary_dns_address_preference_set;
    GArray *arg_ipv6_primary_dns_address_preference;

    /* UMTS Minimum QoS With Signaling Indication Flag */
    gboolean arg_umts_minimum_qos_with_signaling_indication_flag_set;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority;
    gint8 arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication;

    /* UMTS Requested QoS With Signaling Indication Flag */
    gboolean arg_umts_requested_qos_with_signaling_indication_flag_set;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_traffic_class;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority;
    gint8 arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication;

    /* IPv6 Address Preference */
    gboolean arg_ipv6_address_preference_set;
    GArray *arg_ipv6_address_preference_address;

    /* PDP Context Primary ID */
    gboolean arg_pdp_context_primary_id_set;
    guint8 arg_pdp_context_primary_id;

    /* PDP Context Secondary Flag */
    gboolean arg_pdp_context_secondary_flag_set;
    guint8 arg_pdp_context_secondary_flag;

    /* PDP Context Number */
    gboolean arg_pdp_context_number_set;
    guint8 arg_pdp_context_number;

    /* IMCN Flag */
    gboolean arg_imcn_flag_set;
    guint8 arg_imcn_flag;

    /* PCSCF Address Using DHCP */
    gboolean arg_pcscf_address_using_dhcp_set;
    guint8 arg_pcscf_address_using_dhcp;

    /* PCSCF Address Using PCO */
    gboolean arg_pcscf_address_using_pco_set;
    guint8 arg_pcscf_address_using_pco;

    /* IPv4 Address Preference */
    gboolean arg_ipv4_address_preference_set;
    guint32 arg_ipv4_address_preference;

    /* Authentication */
    gboolean arg_authentication_set;
    guint8 arg_authentication;

    /* Password */
    gboolean arg_password_set;
    gchar *arg_password;

    /* Username */
    gboolean arg_username_set;
    gchar *arg_username;

    /* GPRS Minimum QoS */
    gboolean arg_gprs_minimum_qos_set;
    guint32 arg_gprs_minimum_qos_precedence_class;
    guint32 arg_gprs_minimum_qos_delay_class;
    guint32 arg_gprs_minimum_qos_reliability_class;
    guint32 arg_gprs_minimum_qos_peak_throughput_class;
    guint32 arg_gprs_minimum_qos_mean_throughput_class;

    /* GPRS Requested QoS */
    gboolean arg_gprs_requested_qos_set;
    guint32 arg_gprs_requested_qos_precedence_class;
    guint32 arg_gprs_requested_qos_delay_class;
    guint32 arg_gprs_requested_qos_reliability_class;
    guint32 arg_gprs_requested_qos_peak_throughput_class;
    guint32 arg_gprs_requested_qos_mean_throughput_class;

    /* UMTS Minimum QoS */
    gboolean arg_umts_minimum_qos_set;
    guint8 arg_umts_minimum_qos_traffic_class;
    guint32 arg_umts_minimum_qos_max_uplink_bitrate;
    guint32 arg_umts_minimum_qos_max_downlink_bitrate;
    guint32 arg_umts_minimum_qos_guaranteed_uplink_bitrate;
    guint32 arg_umts_minimum_qos_guaranteed_downlink_bitrate;
    guint8 arg_umts_minimum_qos_qos_delivery_order;
    guint32 arg_umts_minimum_qos_maximum_sdu_size;
    guint8 arg_umts_minimum_qos_sdu_error_ratio;
    guint8 arg_umts_minimum_qos_residual_bit_error_ratio;
    guint8 arg_umts_minimum_qos_delivery_erroneous_sdu;
    guint32 arg_umts_minimum_qos_transfer_delay;
    guint32 arg_umts_minimum_qos_traffic_handling_priority;

    /* UMTS Requested QoS */
    gboolean arg_umts_requested_qos_set;
    guint8 arg_umts_requested_qos_traffic_class;
    guint32 arg_umts_requested_qos_max_uplink_bitrate;
    guint32 arg_umts_requested_qos_max_downlink_bitrate;
    guint32 arg_umts_requested_qos_guaranteed_uplink_bitrate;
    guint32 arg_umts_requested_qos_guaranteed_downlink_bitrate;
    guint8 arg_umts_requested_qos_qos_delivery_order;
    guint32 arg_umts_requested_qos_maximum_sdu_size;
    guint8 arg_umts_requested_qos_sdu_error_ratio;
    guint8 arg_umts_requested_qos_residual_bit_error_ratio;
    guint8 arg_umts_requested_qos_delivery_erroneous_sdu;
    guint32 arg_umts_requested_qos_transfer_delay;
    guint32 arg_umts_requested_qos_traffic_handling_priority;

    /* Secondary IPv4 DNS Address */
    gboolean arg_secondary_ipv4_dns_address_set;
    guint32 arg_secondary_ipv4_dns_address;

    /* Primary IPv4 DNS Address */
    gboolean arg_primary_ipv4_dns_address_set;
    guint32 arg_primary_ipv4_dns_address;

    /* APN Name */
    gboolean arg_apn_name_set;
    gchar *arg_apn_name;

    /* PDP Data Compression Type */
    gboolean arg_pdp_data_compression_type_set;
    guint8 arg_pdp_data_compression_type;

    /* PDP Header Compression Type */
    gboolean arg_pdp_header_compression_type_set;
    guint8 arg_pdp_header_compression_type;

    /* PDP Type */
    gboolean arg_pdp_type_set;
    guint8 arg_pdp_type;

    /* Profile Name */
    gboolean arg_profile_name_set;
    gchar *arg_profile_name;

    /* Profile Type */
    gboolean arg_profile_type_set;
    guint8 arg_profile_type;
};

#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_TYPE_MASK 0xDD
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_ROAMING_DISALLOWED_FLAG 0x3E
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_DISABLED_FLAG 0x2F
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_LTE_QOS_PARAMETERS 0x2E
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE 0x2C
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE 0x2B
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG 0x2A
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG 0x29
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_ADDRESS_PREFERENCE 0x28
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_PRIMARY_ID 0x27
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG 0x26
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_NUMBER 0x25
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IMCN_FLAG 0x22
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_DHCP 0x21
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_PCO 0x1F
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV4_ADDRESS_PREFERENCE 0x1E
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_AUTHENTICATION 0x1D
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PASSWORD 0x1C
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_USERNAME 0x1B
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_GPRS_MINIMUM_QOS 0x1A
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_GPRS_REQUESTED_QOS 0x19
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS 0x18
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS 0x17
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS 0x16
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS 0x15
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_NAME 0x14
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_DATA_COMPRESSION_TYPE 0x13
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_HEADER_COMPRESSION_TYPE 0x12
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_TYPE 0x11
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PROFILE_NAME 0x10
#define QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PROFILE_TYPE 0x01

gboolean
qmi_message_wds_create_profile_input_get_apn_type_mask (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsApnTypeMask *value_apn_type_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_apn_type_mask_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'APN Type Mask' was not found in the message");
        return FALSE;
    }

    if (value_apn_type_mask)
        *value_apn_type_mask = (QmiWdsApnTypeMask)(self->arg_apn_type_mask);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_apn_type_mask (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsApnTypeMask value_apn_type_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_apn_type_mask = (guint64)(value_apn_type_mask);
    self->arg_apn_type_mask_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_roaming_disallowed_flag (
    QmiMessageWdsCreateProfileInput *self,
    gboolean *value_roaming_disallowed_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_roaming_disallowed_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Roaming Disallowed Flag' was not found in the message");
        return FALSE;
    }

    if (value_roaming_disallowed_flag)
        *value_roaming_disallowed_flag = (gboolean)(self->arg_roaming_disallowed_flag);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_roaming_disallowed_flag (
    QmiMessageWdsCreateProfileInput *self,
    gboolean value_roaming_disallowed_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_roaming_disallowed_flag = (guint8)(value_roaming_disallowed_flag);
    self->arg_roaming_disallowed_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_apn_disabled_flag (
    QmiMessageWdsCreateProfileInput *self,
    gboolean *value_apn_disabled_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_apn_disabled_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'APN Disabled Flag' was not found in the message");
        return FALSE;
    }

    if (value_apn_disabled_flag)
        *value_apn_disabled_flag = (gboolean)(self->arg_apn_disabled_flag);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_apn_disabled_flag (
    QmiMessageWdsCreateProfileInput *self,
    gboolean value_apn_disabled_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_apn_disabled_flag = (guint8)(value_apn_disabled_flag);
    self->arg_apn_disabled_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_lte_qos_parameters (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsQosClassIdentifier *value_lte_qos_parameters_qos_class_identifier,
    guint32 *value_lte_qos_parameters_guaranteed_downlink_bitrate,
    guint32 *value_lte_qos_parameters_max_downlink_bitrate,
    guint32 *value_lte_qos_parameters_guaranteed_uplink_bitrate,
    guint32 *value_lte_qos_parameters_max_uplink_bitrate,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_qos_parameters_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE QoS Parameters' was not found in the message");
        return FALSE;
    }

    if (value_lte_qos_parameters_qos_class_identifier)
        *value_lte_qos_parameters_qos_class_identifier = (QmiWdsQosClassIdentifier)(self->arg_lte_qos_parameters_qos_class_identifier);
    if (value_lte_qos_parameters_guaranteed_downlink_bitrate)
        *value_lte_qos_parameters_guaranteed_downlink_bitrate = self->arg_lte_qos_parameters_guaranteed_downlink_bitrate;
    if (value_lte_qos_parameters_max_downlink_bitrate)
        *value_lte_qos_parameters_max_downlink_bitrate = self->arg_lte_qos_parameters_max_downlink_bitrate;
    if (value_lte_qos_parameters_guaranteed_uplink_bitrate)
        *value_lte_qos_parameters_guaranteed_uplink_bitrate = self->arg_lte_qos_parameters_guaranteed_uplink_bitrate;
    if (value_lte_qos_parameters_max_uplink_bitrate)
        *value_lte_qos_parameters_max_uplink_bitrate = self->arg_lte_qos_parameters_max_uplink_bitrate;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_lte_qos_parameters (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsQosClassIdentifier value_lte_qos_parameters_qos_class_identifier,
    guint32 value_lte_qos_parameters_guaranteed_downlink_bitrate,
    guint32 value_lte_qos_parameters_max_downlink_bitrate,
    guint32 value_lte_qos_parameters_guaranteed_uplink_bitrate,
    guint32 value_lte_qos_parameters_max_uplink_bitrate,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_lte_qos_parameters_qos_class_identifier = (guint8)(value_lte_qos_parameters_qos_class_identifier);
    self->arg_lte_qos_parameters_guaranteed_downlink_bitrate = value_lte_qos_parameters_guaranteed_downlink_bitrate;
    self->arg_lte_qos_parameters_max_downlink_bitrate = value_lte_qos_parameters_max_downlink_bitrate;
    self->arg_lte_qos_parameters_guaranteed_uplink_bitrate = value_lte_qos_parameters_guaranteed_uplink_bitrate;
    self->arg_lte_qos_parameters_max_uplink_bitrate = value_lte_qos_parameters_max_uplink_bitrate;
    self->arg_lte_qos_parameters_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_ipv6_secondary_dns_address_preference (
    QmiMessageWdsCreateProfileInput *self,
    GArray **value_ipv6_secondary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv6_secondary_dns_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv6 Secondary DNS Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv6_secondary_dns_address_preference)
        *value_ipv6_secondary_dns_address_preference = self->arg_ipv6_secondary_dns_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_ipv6_secondary_dns_address_preference (
    QmiMessageWdsCreateProfileInput *self,
    GArray *value_ipv6_secondary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_ipv6_secondary_dns_address_preference, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_ipv6_secondary_dns_address_preference, (GDestroyNotify)g_ptr_array_unref);
    self->arg_ipv6_secondary_dns_address_preference = g_array_ref (value_ipv6_secondary_dns_address_preference);
    self->arg_ipv6_secondary_dns_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_ipv6_primary_dns_address_preference (
    QmiMessageWdsCreateProfileInput *self,
    GArray **value_ipv6_primary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv6_primary_dns_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv6 Primary DNS Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv6_primary_dns_address_preference)
        *value_ipv6_primary_dns_address_preference = self->arg_ipv6_primary_dns_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_ipv6_primary_dns_address_preference (
    QmiMessageWdsCreateProfileInput *self,
    GArray *value_ipv6_primary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_ipv6_primary_dns_address_preference, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_ipv6_primary_dns_address_preference, (GDestroyNotify)g_ptr_array_unref);
    self->arg_ipv6_primary_dns_address_preference = g_array_ref (value_ipv6_primary_dns_address_preference);
    self->arg_ipv6_primary_dns_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_umts_minimum_qos_with_signaling_indication_flag (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsTrafficClass *value_umts_minimum_qos_with_signaling_indication_flag_traffic_class,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 *value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_minimum_qos_with_signaling_indication_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Minimum QoS With Signaling Indication Flag' was not found in the message");
        return FALSE;
    }

    if (value_umts_minimum_qos_with_signaling_indication_flag_traffic_class)
        *value_umts_minimum_qos_with_signaling_indication_flag_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class);
    if (value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate)
        *value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate = self->arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate;
    if (value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate)
        *value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate = self->arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate;
    if (value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate)
        *value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate = self->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    if (value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate)
        *value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate = self->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    if (value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order)
        *value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order);
    if (value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size)
        *value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size = self->arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size;
    if (value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio)
        *value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio);
    if (value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio)
        *value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio);
    if (value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu)
        *value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu);
    if (value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay)
        *value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay = self->arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay;
    if (value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority)
        *value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority = self->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority;
    if (value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication)
        *value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication = self->arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_umts_minimum_qos_with_signaling_indication_flag (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsTrafficClass value_umts_minimum_qos_with_signaling_indication_flag_traffic_class,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_traffic_class);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate = value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate = value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate = value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate = value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size = value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay = value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority = value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication = value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_umts_requested_qos_with_signaling_indication_flag (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsTrafficClass *value_umts_requested_qos_with_signaling_indication_flag_traffic_class,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_transfer_delay,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 *value_umts_requested_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_requested_qos_with_signaling_indication_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Requested QoS With Signaling Indication Flag' was not found in the message");
        return FALSE;
    }

    if (value_umts_requested_qos_with_signaling_indication_flag_traffic_class)
        *value_umts_requested_qos_with_signaling_indication_flag_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_requested_qos_with_signaling_indication_flag_traffic_class);
    if (value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate)
        *value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate = self->arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate;
    if (value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate)
        *value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate = self->arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate;
    if (value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate)
        *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate = self->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    if (value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate)
        *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate = self->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    if (value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order)
        *value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order);
    if (value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size)
        *value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size = self->arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size;
    if (value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio)
        *value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio);
    if (value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio)
        *value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio);
    if (value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu)
        *value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu);
    if (value_umts_requested_qos_with_signaling_indication_flag_transfer_delay)
        *value_umts_requested_qos_with_signaling_indication_flag_transfer_delay = self->arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay;
    if (value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority)
        *value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority = self->arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority;
    if (value_umts_requested_qos_with_signaling_indication_flag_signaling_indication)
        *value_umts_requested_qos_with_signaling_indication_flag_signaling_indication = self->arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_umts_requested_qos_with_signaling_indication_flag (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsTrafficClass value_umts_requested_qos_with_signaling_indication_flag_traffic_class,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_transfer_delay,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 value_umts_requested_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_umts_requested_qos_with_signaling_indication_flag_traffic_class = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_traffic_class);
    self->arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate = value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate;
    self->arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate = value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate;
    self->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate = value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    self->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate = value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    self->arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order);
    self->arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size = value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size;
    self->arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio);
    self->arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio);
    self->arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu);
    self->arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay = value_umts_requested_qos_with_signaling_indication_flag_transfer_delay;
    self->arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority = value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority;
    self->arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication = value_umts_requested_qos_with_signaling_indication_flag_signaling_indication;
    self->arg_umts_requested_qos_with_signaling_indication_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_ipv6_address_preference (
    QmiMessageWdsCreateProfileInput *self,
    GArray **value_ipv6_address_preference_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv6_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv6 Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv6_address_preference_address)
        *value_ipv6_address_preference_address = self->arg_ipv6_address_preference_address;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_ipv6_address_preference (
    QmiMessageWdsCreateProfileInput *self,
    GArray *value_ipv6_address_preference_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_ipv6_address_preference_address, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_ipv6_address_preference_address, (GDestroyNotify)g_ptr_array_unref);
    self->arg_ipv6_address_preference_address = g_array_ref (value_ipv6_address_preference_address);
    self->arg_ipv6_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_pdp_context_primary_id (
    QmiMessageWdsCreateProfileInput *self,
    guint8 *value_pdp_context_primary_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_primary_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Primary ID' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_primary_id)
        *value_pdp_context_primary_id = self->arg_pdp_context_primary_id;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_pdp_context_primary_id (
    QmiMessageWdsCreateProfileInput *self,
    guint8 value_pdp_context_primary_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_context_primary_id = value_pdp_context_primary_id;
    self->arg_pdp_context_primary_id_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_pdp_context_secondary_flag (
    QmiMessageWdsCreateProfileInput *self,
    gboolean *value_pdp_context_secondary_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_secondary_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Secondary Flag' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_secondary_flag)
        *value_pdp_context_secondary_flag = (gboolean)(self->arg_pdp_context_secondary_flag);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_pdp_context_secondary_flag (
    QmiMessageWdsCreateProfileInput *self,
    gboolean value_pdp_context_secondary_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_context_secondary_flag = (guint8)(value_pdp_context_secondary_flag);
    self->arg_pdp_context_secondary_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_pdp_context_number (
    QmiMessageWdsCreateProfileInput *self,
    guint8 *value_pdp_context_number,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_number_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Number' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_number)
        *value_pdp_context_number = self->arg_pdp_context_number;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_pdp_context_number (
    QmiMessageWdsCreateProfileInput *self,
    guint8 value_pdp_context_number,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_context_number = value_pdp_context_number;
    self->arg_pdp_context_number_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_imcn_flag (
    QmiMessageWdsCreateProfileInput *self,
    gboolean *value_imcn_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_imcn_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IMCN Flag' was not found in the message");
        return FALSE;
    }

    if (value_imcn_flag)
        *value_imcn_flag = (gboolean)(self->arg_imcn_flag);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_imcn_flag (
    QmiMessageWdsCreateProfileInput *self,
    gboolean value_imcn_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_imcn_flag = (guint8)(value_imcn_flag);
    self->arg_imcn_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_pcscf_address_using_dhcp (
    QmiMessageWdsCreateProfileInput *self,
    gboolean *value_pcscf_address_using_dhcp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pcscf_address_using_dhcp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PCSCF Address Using DHCP' was not found in the message");
        return FALSE;
    }

    if (value_pcscf_address_using_dhcp)
        *value_pcscf_address_using_dhcp = (gboolean)(self->arg_pcscf_address_using_dhcp);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_pcscf_address_using_dhcp (
    QmiMessageWdsCreateProfileInput *self,
    gboolean value_pcscf_address_using_dhcp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pcscf_address_using_dhcp = (guint8)(value_pcscf_address_using_dhcp);
    self->arg_pcscf_address_using_dhcp_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_pcscf_address_using_pco (
    QmiMessageWdsCreateProfileInput *self,
    gboolean *value_pcscf_address_using_pco,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pcscf_address_using_pco_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PCSCF Address Using PCO' was not found in the message");
        return FALSE;
    }

    if (value_pcscf_address_using_pco)
        *value_pcscf_address_using_pco = (gboolean)(self->arg_pcscf_address_using_pco);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_pcscf_address_using_pco (
    QmiMessageWdsCreateProfileInput *self,
    gboolean value_pcscf_address_using_pco,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pcscf_address_using_pco = (guint8)(value_pcscf_address_using_pco);
    self->arg_pcscf_address_using_pco_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_ipv4_address_preference (
    QmiMessageWdsCreateProfileInput *self,
    guint32 *value_ipv4_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv4_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv4 Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv4_address_preference)
        *value_ipv4_address_preference = self->arg_ipv4_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_ipv4_address_preference (
    QmiMessageWdsCreateProfileInput *self,
    guint32 value_ipv4_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_ipv4_address_preference = value_ipv4_address_preference;
    self->arg_ipv4_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_authentication (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsAuthentication *value_authentication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_authentication_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Authentication' was not found in the message");
        return FALSE;
    }

    if (value_authentication)
        *value_authentication = (QmiWdsAuthentication)(self->arg_authentication);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_authentication (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsAuthentication value_authentication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_authentication = (guint8)(value_authentication);
    self->arg_authentication_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_password (
    QmiMessageWdsCreateProfileInput *self,
    const gchar **value_password,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_password_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Password' was not found in the message");
        return FALSE;
    }

    if (value_password)
        *value_password = self->arg_password;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_password (
    QmiMessageWdsCreateProfileInput *self,
    const gchar *value_password,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_password);
    self->arg_password = g_strdup (value_password ? value_password : "");
    self->arg_password_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_username (
    QmiMessageWdsCreateProfileInput *self,
    const gchar **value_username,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_username_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Username' was not found in the message");
        return FALSE;
    }

    if (value_username)
        *value_username = self->arg_username;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_username (
    QmiMessageWdsCreateProfileInput *self,
    const gchar *value_username,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_username);
    self->arg_username = g_strdup (value_username ? value_username : "");
    self->arg_username_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_gprs_minimum_qos (
    QmiMessageWdsCreateProfileInput *self,
    guint32 *value_gprs_minimum_qos_precedence_class,
    guint32 *value_gprs_minimum_qos_delay_class,
    guint32 *value_gprs_minimum_qos_reliability_class,
    guint32 *value_gprs_minimum_qos_peak_throughput_class,
    guint32 *value_gprs_minimum_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gprs_minimum_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GPRS Minimum QoS' was not found in the message");
        return FALSE;
    }

    if (value_gprs_minimum_qos_precedence_class)
        *value_gprs_minimum_qos_precedence_class = self->arg_gprs_minimum_qos_precedence_class;
    if (value_gprs_minimum_qos_delay_class)
        *value_gprs_minimum_qos_delay_class = self->arg_gprs_minimum_qos_delay_class;
    if (value_gprs_minimum_qos_reliability_class)
        *value_gprs_minimum_qos_reliability_class = self->arg_gprs_minimum_qos_reliability_class;
    if (value_gprs_minimum_qos_peak_throughput_class)
        *value_gprs_minimum_qos_peak_throughput_class = self->arg_gprs_minimum_qos_peak_throughput_class;
    if (value_gprs_minimum_qos_mean_throughput_class)
        *value_gprs_minimum_qos_mean_throughput_class = self->arg_gprs_minimum_qos_mean_throughput_class;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_gprs_minimum_qos (
    QmiMessageWdsCreateProfileInput *self,
    guint32 value_gprs_minimum_qos_precedence_class,
    guint32 value_gprs_minimum_qos_delay_class,
    guint32 value_gprs_minimum_qos_reliability_class,
    guint32 value_gprs_minimum_qos_peak_throughput_class,
    guint32 value_gprs_minimum_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_gprs_minimum_qos_precedence_class = value_gprs_minimum_qos_precedence_class;
    self->arg_gprs_minimum_qos_delay_class = value_gprs_minimum_qos_delay_class;
    self->arg_gprs_minimum_qos_reliability_class = value_gprs_minimum_qos_reliability_class;
    self->arg_gprs_minimum_qos_peak_throughput_class = value_gprs_minimum_qos_peak_throughput_class;
    self->arg_gprs_minimum_qos_mean_throughput_class = value_gprs_minimum_qos_mean_throughput_class;
    self->arg_gprs_minimum_qos_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_gprs_requested_qos (
    QmiMessageWdsCreateProfileInput *self,
    guint32 *value_gprs_requested_qos_precedence_class,
    guint32 *value_gprs_requested_qos_delay_class,
    guint32 *value_gprs_requested_qos_reliability_class,
    guint32 *value_gprs_requested_qos_peak_throughput_class,
    guint32 *value_gprs_requested_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gprs_requested_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GPRS Requested QoS' was not found in the message");
        return FALSE;
    }

    if (value_gprs_requested_qos_precedence_class)
        *value_gprs_requested_qos_precedence_class = self->arg_gprs_requested_qos_precedence_class;
    if (value_gprs_requested_qos_delay_class)
        *value_gprs_requested_qos_delay_class = self->arg_gprs_requested_qos_delay_class;
    if (value_gprs_requested_qos_reliability_class)
        *value_gprs_requested_qos_reliability_class = self->arg_gprs_requested_qos_reliability_class;
    if (value_gprs_requested_qos_peak_throughput_class)
        *value_gprs_requested_qos_peak_throughput_class = self->arg_gprs_requested_qos_peak_throughput_class;
    if (value_gprs_requested_qos_mean_throughput_class)
        *value_gprs_requested_qos_mean_throughput_class = self->arg_gprs_requested_qos_mean_throughput_class;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_gprs_requested_qos (
    QmiMessageWdsCreateProfileInput *self,
    guint32 value_gprs_requested_qos_precedence_class,
    guint32 value_gprs_requested_qos_delay_class,
    guint32 value_gprs_requested_qos_reliability_class,
    guint32 value_gprs_requested_qos_peak_throughput_class,
    guint32 value_gprs_requested_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_gprs_requested_qos_precedence_class = value_gprs_requested_qos_precedence_class;
    self->arg_gprs_requested_qos_delay_class = value_gprs_requested_qos_delay_class;
    self->arg_gprs_requested_qos_reliability_class = value_gprs_requested_qos_reliability_class;
    self->arg_gprs_requested_qos_peak_throughput_class = value_gprs_requested_qos_peak_throughput_class;
    self->arg_gprs_requested_qos_mean_throughput_class = value_gprs_requested_qos_mean_throughput_class;
    self->arg_gprs_requested_qos_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_umts_minimum_qos (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsTrafficClass *value_umts_minimum_qos_traffic_class,
    guint32 *value_umts_minimum_qos_max_uplink_bitrate,
    guint32 *value_umts_minimum_qos_max_downlink_bitrate,
    guint32 *value_umts_minimum_qos_guaranteed_uplink_bitrate,
    guint32 *value_umts_minimum_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_minimum_qos_qos_delivery_order,
    guint32 *value_umts_minimum_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_minimum_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_minimum_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_minimum_qos_delivery_erroneous_sdu,
    guint32 *value_umts_minimum_qos_transfer_delay,
    guint32 *value_umts_minimum_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_minimum_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Minimum QoS' was not found in the message");
        return FALSE;
    }

    if (value_umts_minimum_qos_traffic_class)
        *value_umts_minimum_qos_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_minimum_qos_traffic_class);
    if (value_umts_minimum_qos_max_uplink_bitrate)
        *value_umts_minimum_qos_max_uplink_bitrate = self->arg_umts_minimum_qos_max_uplink_bitrate;
    if (value_umts_minimum_qos_max_downlink_bitrate)
        *value_umts_minimum_qos_max_downlink_bitrate = self->arg_umts_minimum_qos_max_downlink_bitrate;
    if (value_umts_minimum_qos_guaranteed_uplink_bitrate)
        *value_umts_minimum_qos_guaranteed_uplink_bitrate = self->arg_umts_minimum_qos_guaranteed_uplink_bitrate;
    if (value_umts_minimum_qos_guaranteed_downlink_bitrate)
        *value_umts_minimum_qos_guaranteed_downlink_bitrate = self->arg_umts_minimum_qos_guaranteed_downlink_bitrate;
    if (value_umts_minimum_qos_qos_delivery_order)
        *value_umts_minimum_qos_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_minimum_qos_qos_delivery_order);
    if (value_umts_minimum_qos_maximum_sdu_size)
        *value_umts_minimum_qos_maximum_sdu_size = self->arg_umts_minimum_qos_maximum_sdu_size;
    if (value_umts_minimum_qos_sdu_error_ratio)
        *value_umts_minimum_qos_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_minimum_qos_sdu_error_ratio);
    if (value_umts_minimum_qos_residual_bit_error_ratio)
        *value_umts_minimum_qos_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_minimum_qos_residual_bit_error_ratio);
    if (value_umts_minimum_qos_delivery_erroneous_sdu)
        *value_umts_minimum_qos_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_minimum_qos_delivery_erroneous_sdu);
    if (value_umts_minimum_qos_transfer_delay)
        *value_umts_minimum_qos_transfer_delay = self->arg_umts_minimum_qos_transfer_delay;
    if (value_umts_minimum_qos_traffic_handling_priority)
        *value_umts_minimum_qos_traffic_handling_priority = self->arg_umts_minimum_qos_traffic_handling_priority;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_umts_minimum_qos (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsTrafficClass value_umts_minimum_qos_traffic_class,
    guint32 value_umts_minimum_qos_max_uplink_bitrate,
    guint32 value_umts_minimum_qos_max_downlink_bitrate,
    guint32 value_umts_minimum_qos_guaranteed_uplink_bitrate,
    guint32 value_umts_minimum_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder value_umts_minimum_qos_qos_delivery_order,
    guint32 value_umts_minimum_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio value_umts_minimum_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio value_umts_minimum_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery value_umts_minimum_qos_delivery_erroneous_sdu,
    guint32 value_umts_minimum_qos_transfer_delay,
    guint32 value_umts_minimum_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_umts_minimum_qos_traffic_class = (guint8)(value_umts_minimum_qos_traffic_class);
    self->arg_umts_minimum_qos_max_uplink_bitrate = value_umts_minimum_qos_max_uplink_bitrate;
    self->arg_umts_minimum_qos_max_downlink_bitrate = value_umts_minimum_qos_max_downlink_bitrate;
    self->arg_umts_minimum_qos_guaranteed_uplink_bitrate = value_umts_minimum_qos_guaranteed_uplink_bitrate;
    self->arg_umts_minimum_qos_guaranteed_downlink_bitrate = value_umts_minimum_qos_guaranteed_downlink_bitrate;
    self->arg_umts_minimum_qos_qos_delivery_order = (guint8)(value_umts_minimum_qos_qos_delivery_order);
    self->arg_umts_minimum_qos_maximum_sdu_size = value_umts_minimum_qos_maximum_sdu_size;
    self->arg_umts_minimum_qos_sdu_error_ratio = (guint8)(value_umts_minimum_qos_sdu_error_ratio);
    self->arg_umts_minimum_qos_residual_bit_error_ratio = (guint8)(value_umts_minimum_qos_residual_bit_error_ratio);
    self->arg_umts_minimum_qos_delivery_erroneous_sdu = (guint8)(value_umts_minimum_qos_delivery_erroneous_sdu);
    self->arg_umts_minimum_qos_transfer_delay = value_umts_minimum_qos_transfer_delay;
    self->arg_umts_minimum_qos_traffic_handling_priority = value_umts_minimum_qos_traffic_handling_priority;
    self->arg_umts_minimum_qos_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_umts_requested_qos (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsTrafficClass *value_umts_requested_qos_traffic_class,
    guint32 *value_umts_requested_qos_max_uplink_bitrate,
    guint32 *value_umts_requested_qos_max_downlink_bitrate,
    guint32 *value_umts_requested_qos_guaranteed_uplink_bitrate,
    guint32 *value_umts_requested_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_requested_qos_qos_delivery_order,
    guint32 *value_umts_requested_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_requested_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_requested_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_requested_qos_delivery_erroneous_sdu,
    guint32 *value_umts_requested_qos_transfer_delay,
    guint32 *value_umts_requested_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_requested_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Requested QoS' was not found in the message");
        return FALSE;
    }

    if (value_umts_requested_qos_traffic_class)
        *value_umts_requested_qos_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_requested_qos_traffic_class);
    if (value_umts_requested_qos_max_uplink_bitrate)
        *value_umts_requested_qos_max_uplink_bitrate = self->arg_umts_requested_qos_max_uplink_bitrate;
    if (value_umts_requested_qos_max_downlink_bitrate)
        *value_umts_requested_qos_max_downlink_bitrate = self->arg_umts_requested_qos_max_downlink_bitrate;
    if (value_umts_requested_qos_guaranteed_uplink_bitrate)
        *value_umts_requested_qos_guaranteed_uplink_bitrate = self->arg_umts_requested_qos_guaranteed_uplink_bitrate;
    if (value_umts_requested_qos_guaranteed_downlink_bitrate)
        *value_umts_requested_qos_guaranteed_downlink_bitrate = self->arg_umts_requested_qos_guaranteed_downlink_bitrate;
    if (value_umts_requested_qos_qos_delivery_order)
        *value_umts_requested_qos_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_requested_qos_qos_delivery_order);
    if (value_umts_requested_qos_maximum_sdu_size)
        *value_umts_requested_qos_maximum_sdu_size = self->arg_umts_requested_qos_maximum_sdu_size;
    if (value_umts_requested_qos_sdu_error_ratio)
        *value_umts_requested_qos_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_requested_qos_sdu_error_ratio);
    if (value_umts_requested_qos_residual_bit_error_ratio)
        *value_umts_requested_qos_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_requested_qos_residual_bit_error_ratio);
    if (value_umts_requested_qos_delivery_erroneous_sdu)
        *value_umts_requested_qos_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_requested_qos_delivery_erroneous_sdu);
    if (value_umts_requested_qos_transfer_delay)
        *value_umts_requested_qos_transfer_delay = self->arg_umts_requested_qos_transfer_delay;
    if (value_umts_requested_qos_traffic_handling_priority)
        *value_umts_requested_qos_traffic_handling_priority = self->arg_umts_requested_qos_traffic_handling_priority;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_umts_requested_qos (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsTrafficClass value_umts_requested_qos_traffic_class,
    guint32 value_umts_requested_qos_max_uplink_bitrate,
    guint32 value_umts_requested_qos_max_downlink_bitrate,
    guint32 value_umts_requested_qos_guaranteed_uplink_bitrate,
    guint32 value_umts_requested_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder value_umts_requested_qos_qos_delivery_order,
    guint32 value_umts_requested_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio value_umts_requested_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio value_umts_requested_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery value_umts_requested_qos_delivery_erroneous_sdu,
    guint32 value_umts_requested_qos_transfer_delay,
    guint32 value_umts_requested_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_umts_requested_qos_traffic_class = (guint8)(value_umts_requested_qos_traffic_class);
    self->arg_umts_requested_qos_max_uplink_bitrate = value_umts_requested_qos_max_uplink_bitrate;
    self->arg_umts_requested_qos_max_downlink_bitrate = value_umts_requested_qos_max_downlink_bitrate;
    self->arg_umts_requested_qos_guaranteed_uplink_bitrate = value_umts_requested_qos_guaranteed_uplink_bitrate;
    self->arg_umts_requested_qos_guaranteed_downlink_bitrate = value_umts_requested_qos_guaranteed_downlink_bitrate;
    self->arg_umts_requested_qos_qos_delivery_order = (guint8)(value_umts_requested_qos_qos_delivery_order);
    self->arg_umts_requested_qos_maximum_sdu_size = value_umts_requested_qos_maximum_sdu_size;
    self->arg_umts_requested_qos_sdu_error_ratio = (guint8)(value_umts_requested_qos_sdu_error_ratio);
    self->arg_umts_requested_qos_residual_bit_error_ratio = (guint8)(value_umts_requested_qos_residual_bit_error_ratio);
    self->arg_umts_requested_qos_delivery_erroneous_sdu = (guint8)(value_umts_requested_qos_delivery_erroneous_sdu);
    self->arg_umts_requested_qos_transfer_delay = value_umts_requested_qos_transfer_delay;
    self->arg_umts_requested_qos_traffic_handling_priority = value_umts_requested_qos_traffic_handling_priority;
    self->arg_umts_requested_qos_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_secondary_ipv4_dns_address (
    QmiMessageWdsCreateProfileInput *self,
    guint32 *value_secondary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_secondary_ipv4_dns_address_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Secondary IPv4 DNS Address' was not found in the message");
        return FALSE;
    }

    if (value_secondary_ipv4_dns_address)
        *value_secondary_ipv4_dns_address = self->arg_secondary_ipv4_dns_address;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_secondary_ipv4_dns_address (
    QmiMessageWdsCreateProfileInput *self,
    guint32 value_secondary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_secondary_ipv4_dns_address = value_secondary_ipv4_dns_address;
    self->arg_secondary_ipv4_dns_address_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_primary_ipv4_dns_address (
    QmiMessageWdsCreateProfileInput *self,
    guint32 *value_primary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_primary_ipv4_dns_address_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Primary IPv4 DNS Address' was not found in the message");
        return FALSE;
    }

    if (value_primary_ipv4_dns_address)
        *value_primary_ipv4_dns_address = self->arg_primary_ipv4_dns_address;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_primary_ipv4_dns_address (
    QmiMessageWdsCreateProfileInput *self,
    guint32 value_primary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_primary_ipv4_dns_address = value_primary_ipv4_dns_address;
    self->arg_primary_ipv4_dns_address_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_apn_name (
    QmiMessageWdsCreateProfileInput *self,
    const gchar **value_apn_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_apn_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'APN Name' was not found in the message");
        return FALSE;
    }

    if (value_apn_name)
        *value_apn_name = self->arg_apn_name;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_apn_name (
    QmiMessageWdsCreateProfileInput *self,
    const gchar *value_apn_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_apn_name);
    self->arg_apn_name = g_strdup (value_apn_name ? value_apn_name : "");
    self->arg_apn_name_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_pdp_data_compression_type (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsPdpDataCompressionType *value_pdp_data_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_data_compression_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Data Compression Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_data_compression_type)
        *value_pdp_data_compression_type = (QmiWdsPdpDataCompressionType)(self->arg_pdp_data_compression_type);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_pdp_data_compression_type (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsPdpDataCompressionType value_pdp_data_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_data_compression_type = (guint8)(value_pdp_data_compression_type);
    self->arg_pdp_data_compression_type_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_pdp_header_compression_type (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsPdpHeaderCompressionType *value_pdp_header_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_header_compression_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Header Compression Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_header_compression_type)
        *value_pdp_header_compression_type = (QmiWdsPdpHeaderCompressionType)(self->arg_pdp_header_compression_type);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_pdp_header_compression_type (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsPdpHeaderCompressionType value_pdp_header_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_header_compression_type = (guint8)(value_pdp_header_compression_type);
    self->arg_pdp_header_compression_type_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_pdp_type (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsPdpType *value_pdp_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_type)
        *value_pdp_type = (QmiWdsPdpType)(self->arg_pdp_type);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_pdp_type (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsPdpType value_pdp_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_type = (guint8)(value_pdp_type);
    self->arg_pdp_type_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_profile_name (
    QmiMessageWdsCreateProfileInput *self,
    const gchar **value_profile_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Name' was not found in the message");
        return FALSE;
    }

    if (value_profile_name)
        *value_profile_name = self->arg_profile_name;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_profile_name (
    QmiMessageWdsCreateProfileInput *self,
    const gchar *value_profile_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_profile_name);
    self->arg_profile_name = g_strdup (value_profile_name ? value_profile_name : "");
    self->arg_profile_name_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_get_profile_type (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsProfileType *value_profile_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Type' was not found in the message");
        return FALSE;
    }

    if (value_profile_type)
        *value_profile_type = (QmiWdsProfileType)(self->arg_profile_type);

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_input_set_profile_type (
    QmiMessageWdsCreateProfileInput *self,
    QmiWdsProfileType value_profile_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_profile_type = (guint8)(value_profile_type);
    self->arg_profile_type_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_create_profile_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsCreateProfileInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_create_profile_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_create_profile_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsCreateProfileInput *
qmi_message_wds_create_profile_input_ref (QmiMessageWdsCreateProfileInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_create_profile_input_unref (QmiMessageWdsCreateProfileInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_ipv6_secondary_dns_address_preference, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_ipv6_primary_dns_address_preference, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_ipv6_address_preference_address, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_password, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_username, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_apn_name, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_profile_name, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageWdsCreateProfileInput, self);
    }
}

QmiMessageWdsCreateProfileInput *
qmi_message_wds_create_profile_input_new (void)
{
    QmiMessageWdsCreateProfileInput *self;

    self = g_slice_new0 (QmiMessageWdsCreateProfileInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_create_profile_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsCreateProfileInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_CREATE_PROFILE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Create Profile' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'APN Type Mask' TLV */
    if (input->arg_apn_type_mask_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_TYPE_MASK, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'APN Type Mask': ");
            return NULL;
        }

        {
            guint64 tmp;

            tmp = (guint64) input->arg_apn_type_mask;
            /* Write the guint64 variable to the buffer */
            if (!qmi_message_tlv_write_guint64 (self, QMI_ENDIAN_LITTLE, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'APN Type Mask': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'APN Type Mask': ");
            return NULL;
        }
    }

    /* Try to add the 'Roaming Disallowed Flag' TLV */
    if (input->arg_roaming_disallowed_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_ROAMING_DISALLOWED_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Roaming Disallowed Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_roaming_disallowed_flag;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Roaming Disallowed Flag': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Roaming Disallowed Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'APN Disabled Flag' TLV */
    if (input->arg_apn_disabled_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_DISABLED_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'APN Disabled Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_apn_disabled_flag;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'APN Disabled Flag': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'APN Disabled Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'LTE QoS Parameters' TLV */
    if (input->arg_lte_qos_parameters_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_LTE_QOS_PARAMETERS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'LTE QoS Parameters': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_lte_qos_parameters_qos_class_identifier;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'LTE QoS Parameters': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_lte_qos_parameters_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE QoS Parameters': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_lte_qos_parameters_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE QoS Parameters': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_lte_qos_parameters_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE QoS Parameters': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_lte_qos_parameters_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE QoS Parameters': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'LTE QoS Parameters': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv6 Secondary DNS Address Preference' TLV */
    if (input->arg_ipv6_secondary_dns_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv6 Secondary DNS Address Preference': ");
            return NULL;
        }

        {
            guint ipv6_secondary_dns_address_preference_i;

            for (ipv6_secondary_dns_address_preference_i = 0; ipv6_secondary_dns_address_preference_i < input->arg_ipv6_secondary_dns_address_preference->len; ipv6_secondary_dns_address_preference_i++) {
                /* Write the guint16 variable to the buffer */
                if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_BIG, g_array_index (input->arg_ipv6_secondary_dns_address_preference, guint16,ipv6_secondary_dns_address_preference_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'IPv6 Secondary DNS Address Preference': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv6 Secondary DNS Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv6 Primary DNS Address Preference' TLV */
    if (input->arg_ipv6_primary_dns_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv6 Primary DNS Address Preference': ");
            return NULL;
        }

        {
            guint ipv6_primary_dns_address_preference_i;

            for (ipv6_primary_dns_address_preference_i = 0; ipv6_primary_dns_address_preference_i < input->arg_ipv6_primary_dns_address_preference->len; ipv6_primary_dns_address_preference_i++) {
                /* Write the guint16 variable to the buffer */
                if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_BIG, g_array_index (input->arg_ipv6_primary_dns_address_preference, guint16,ipv6_primary_dns_address_preference_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'IPv6 Primary DNS Address Preference': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv6 Primary DNS Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'UMTS Minimum QoS With Signaling Indication Flag' TLV */
    if (input->arg_umts_minimum_qos_with_signaling_indication_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the gint8 variable to the buffer */
        if (!qmi_message_tlv_write_gint8 (self, input->arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'UMTS Requested QoS With Signaling Indication Flag' TLV */
    if (input->arg_umts_requested_qos_with_signaling_indication_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_traffic_class;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the gint8 variable to the buffer */
        if (!qmi_message_tlv_write_gint8 (self, input->arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv6 Address Preference' TLV */
    if (input->arg_ipv6_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv6 Address Preference': ");
            return NULL;
        }

        {
            guint address_i;

            for (address_i = 0; address_i < input->arg_ipv6_address_preference_address->len; address_i++) {
                /* Write the guint16 variable to the buffer */
                if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_BIG, g_array_index (input->arg_ipv6_address_preference_address, guint16,address_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'IPv6 Address Preference': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv6 Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Context Primary ID' TLV */
    if (input->arg_pdp_context_primary_id_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_PRIMARY_ID, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Context Primary ID': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_pdp_context_primary_id, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'PDP Context Primary ID': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Context Primary ID': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Context Secondary Flag' TLV */
    if (input->arg_pdp_context_secondary_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Context Secondary Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdp_context_secondary_flag;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDP Context Secondary Flag': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Context Secondary Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Context Number' TLV */
    if (input->arg_pdp_context_number_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_NUMBER, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Context Number': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_pdp_context_number, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'PDP Context Number': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Context Number': ");
            return NULL;
        }
    }

    /* Try to add the 'IMCN Flag' TLV */
    if (input->arg_imcn_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IMCN_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IMCN Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_imcn_flag;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'IMCN Flag': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IMCN Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'PCSCF Address Using DHCP' TLV */
    if (input->arg_pcscf_address_using_dhcp_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_DHCP, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PCSCF Address Using DHCP': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pcscf_address_using_dhcp;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PCSCF Address Using DHCP': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PCSCF Address Using DHCP': ");
            return NULL;
        }
    }

    /* Try to add the 'PCSCF Address Using PCO' TLV */
    if (input->arg_pcscf_address_using_pco_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_PCO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PCSCF Address Using PCO': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pcscf_address_using_pco;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PCSCF Address Using PCO': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PCSCF Address Using PCO': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv4 Address Preference' TLV */
    if (input->arg_ipv4_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV4_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv4 Address Preference': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_ipv4_address_preference, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'IPv4 Address Preference': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv4 Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'Authentication' TLV */
    if (input->arg_authentication_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_AUTHENTICATION, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Authentication': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_authentication;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Authentication': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Authentication': ");
            return NULL;
        }
    }

    /* Try to add the 'Password' TLV */
    if (input->arg_password_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PASSWORD, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Password': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_password, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Password': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Password': ");
            return NULL;
        }
    }

    /* Try to add the 'Username' TLV */
    if (input->arg_username_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_USERNAME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Username': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_username, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Username': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Username': ");
            return NULL;
        }
    }

    /* Try to add the 'GPRS Minimum QoS' TLV */
    if (input->arg_gprs_minimum_qos_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_GPRS_MINIMUM_QOS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'GPRS Minimum QoS': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_precedence_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_delay_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_reliability_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_peak_throughput_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_mean_throughput_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
    }

    /* Try to add the 'GPRS Requested QoS' TLV */
    if (input->arg_gprs_requested_qos_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_GPRS_REQUESTED_QOS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'GPRS Requested QoS': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_precedence_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_delay_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_reliability_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_peak_throughput_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_mean_throughput_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'GPRS Requested QoS': ");
            return NULL;
        }
    }

    /* Try to add the 'UMTS Minimum QoS' TLV */
    if (input->arg_umts_minimum_qos_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UMTS Minimum QoS': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_traffic_class;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_qos_delivery_order;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_maximum_sdu_size, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_sdu_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_residual_bit_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_delivery_erroneous_sdu;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_transfer_delay, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_traffic_handling_priority, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
    }

    /* Try to add the 'UMTS Requested QoS' TLV */
    if (input->arg_umts_requested_qos_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UMTS Requested QoS': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_traffic_class;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_qos_delivery_order;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_maximum_sdu_size, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_sdu_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_residual_bit_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_delivery_erroneous_sdu;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_transfer_delay, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_traffic_handling_priority, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UMTS Requested QoS': ");
            return NULL;
        }
    }

    /* Try to add the 'Secondary IPv4 DNS Address' TLV */
    if (input->arg_secondary_ipv4_dns_address_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Secondary IPv4 DNS Address': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_secondary_ipv4_dns_address, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Secondary IPv4 DNS Address': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Secondary IPv4 DNS Address': ");
            return NULL;
        }
    }

    /* Try to add the 'Primary IPv4 DNS Address' TLV */
    if (input->arg_primary_ipv4_dns_address_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Primary IPv4 DNS Address': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_primary_ipv4_dns_address, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Primary IPv4 DNS Address': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Primary IPv4 DNS Address': ");
            return NULL;
        }
    }

    /* Try to add the 'APN Name' TLV */
    if (input->arg_apn_name_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_NAME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'APN Name': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_apn_name, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'APN Name': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'APN Name': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Data Compression Type' TLV */
    if (input->arg_pdp_data_compression_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_DATA_COMPRESSION_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Data Compression Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdp_data_compression_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDP Data Compression Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Data Compression Type': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Header Compression Type' TLV */
    if (input->arg_pdp_header_compression_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_HEADER_COMPRESSION_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Header Compression Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdp_header_compression_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDP Header Compression Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Header Compression Type': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Type' TLV */
    if (input->arg_pdp_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdp_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDP Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Type': ");
            return NULL;
        }
    }

    /* Try to add the 'Profile Name' TLV */
    if (input->arg_profile_name_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PROFILE_NAME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile Name': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_profile_name, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Profile Name': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile Name': ");
            return NULL;
        }
    }

    /* Try to add the 'Profile Type' TLV */
    if (input->arg_profile_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PROFILE_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_profile_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Profile Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile Type': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Profile Type' in message 'Create Profile'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsCreateProfileOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Profile Identifier */
    gboolean arg_profile_identifier_set;
    guint8 arg_profile_identifier_profile_type;
    guint8 arg_profile_identifier_profile_index;

    /* Extended Error Code */
    gboolean arg_extended_error_code_set;
    guint16 arg_extended_error_code;
};

#define QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_PROFILE_IDENTIFIER 0x01
#define QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE 0xE0

gboolean
qmi_message_wds_create_profile_output_get_result (
    QmiMessageWdsCreateProfileOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_create_profile_output_get_profile_identifier (
    QmiMessageWdsCreateProfileOutput *self,
    QmiWdsProfileType *value_profile_identifier_profile_type,
    guint8 *value_profile_identifier_profile_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_identifier_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Identifier' was not found in the message");
        return FALSE;
    }

    if (value_profile_identifier_profile_type)
        *value_profile_identifier_profile_type = (QmiWdsProfileType)(self->arg_profile_identifier_profile_type);
    if (value_profile_identifier_profile_index)
        *value_profile_identifier_profile_index = self->arg_profile_identifier_profile_index;

    return TRUE;
}

gboolean
qmi_message_wds_create_profile_output_get_extended_error_code (
    QmiMessageWdsCreateProfileOutput *self,
    QmiWdsDsProfileError *value_extended_error_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_error_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended Error Code' was not found in the message");
        return FALSE;
    }

    if (value_extended_error_code)
        *value_extended_error_code = (QmiWdsDsProfileError)(self->arg_extended_error_code);

    return TRUE;
}

GType
qmi_message_wds_create_profile_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsCreateProfileOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_create_profile_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_create_profile_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsCreateProfileOutput *
qmi_message_wds_create_profile_output_ref (QmiMessageWdsCreateProfileOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_create_profile_output_unref (QmiMessageWdsCreateProfileOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsCreateProfileOutput, self);
    }
}

static gchar *
qmi_message_wds_create_profile_input_apn_type_mask_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_TYPE_MASK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_APN_TYPE_MASK_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_apn_type_mask_get_string ((QmiWdsApnTypeMask)tmp));
#elif defined  __QMI_WDS_APN_TYPE_MASK_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_apn_type_mask_build_string_from_mask ((QmiWdsApnTypeMask)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsApnTypeMask
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_roaming_disallowed_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_ROAMING_DISALLOWED_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_apn_disabled_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_DISABLED_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_lte_qos_parameters_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_LTE_QOS_PARAMETERS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " qos_class_identifier = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_QOS_CLASS_IDENTIFIER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_qos_class_identifier_get_string ((QmiWdsQosClassIdentifier)tmp));
#elif defined  __QMI_WDS_QOS_CLASS_IDENTIFIER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_qos_class_identifier_build_string_from_mask ((QmiWdsQosClassIdentifier)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsQosClassIdentifier
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_ipv6_secondary_dns_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint ipv6_secondary_dns_address_preference_i;
        guint16 ipv6_secondary_dns_address_preference_n_items = 8;


        g_string_append (printable, "{");

        for (ipv6_secondary_dns_address_preference_i = 0; ipv6_secondary_dns_address_preference_i < ipv6_secondary_dns_address_preference_n_items; ipv6_secondary_dns_address_preference_i++) {
            g_string_append_printf (printable, " [%u] = '", ipv6_secondary_dns_address_preference_i);

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_BIG, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_ipv6_primary_dns_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint ipv6_primary_dns_address_preference_i;
        guint16 ipv6_primary_dns_address_preference_n_items = 8;


        g_string_append (printable, "{");

        for (ipv6_primary_dns_address_preference_i = 0; ipv6_primary_dns_address_preference_i < ipv6_primary_dns_address_preference_n_items; ipv6_primary_dns_address_preference_i++) {
            g_string_append_printf (printable, " [%u] = '", ipv6_primary_dns_address_preference_i);

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_BIG, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_umts_minimum_qos_with_signaling_indication_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " traffic_class = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TRAFFIC_CLASS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_traffic_class_get_string ((QmiWdsTrafficClass)tmp));
#elif defined  __QMI_WDS_TRAFFIC_CLASS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_traffic_class_build_string_from_mask ((QmiWdsTrafficClass)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTrafficClass
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " qos_delivery_order = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DELIVERY_ORDER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_delivery_order_get_string ((QmiWdsDeliveryOrder)tmp));
#elif defined  __QMI_WDS_DELIVERY_ORDER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_delivery_order_build_string_from_mask ((QmiWdsDeliveryOrder)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDeliveryOrder
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " maximum_sdu_size = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sdu_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_error_ratio_get_string ((QmiWdsSduErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_error_ratio_build_string_from_mask ((QmiWdsSduErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " residual_bit_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_residual_bit_error_ratio_get_string ((QmiWdsSduResidualBitErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_residual_bit_error_ratio_build_string_from_mask ((QmiWdsSduResidualBitErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduResidualBitErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delivery_erroneous_sdu = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_erroneous_delivery_get_string ((QmiWdsSduErroneousDelivery)tmp));
#elif defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_erroneous_delivery_build_string_from_mask ((QmiWdsSduErroneousDelivery)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErroneousDelivery
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " transfer_delay = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " traffic_handling_priority = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " signaling_indication = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_umts_requested_qos_with_signaling_indication_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " traffic_class = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TRAFFIC_CLASS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_traffic_class_get_string ((QmiWdsTrafficClass)tmp));
#elif defined  __QMI_WDS_TRAFFIC_CLASS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_traffic_class_build_string_from_mask ((QmiWdsTrafficClass)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTrafficClass
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " qos_delivery_order = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DELIVERY_ORDER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_delivery_order_get_string ((QmiWdsDeliveryOrder)tmp));
#elif defined  __QMI_WDS_DELIVERY_ORDER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_delivery_order_build_string_from_mask ((QmiWdsDeliveryOrder)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDeliveryOrder
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " maximum_sdu_size = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sdu_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_error_ratio_get_string ((QmiWdsSduErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_error_ratio_build_string_from_mask ((QmiWdsSduErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " residual_bit_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_residual_bit_error_ratio_get_string ((QmiWdsSduResidualBitErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_residual_bit_error_ratio_build_string_from_mask ((QmiWdsSduResidualBitErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduResidualBitErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delivery_erroneous_sdu = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_erroneous_delivery_get_string ((QmiWdsSduErroneousDelivery)tmp));
#elif defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_erroneous_delivery_build_string_from_mask ((QmiWdsSduErroneousDelivery)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErroneousDelivery
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " transfer_delay = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " traffic_handling_priority = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " signaling_indication = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_ipv6_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " address = '");
    {
        guint address_i;
        guint16 address_n_items = 8;


        g_string_append (printable, "{");

        for (address_i = 0; address_i < address_n_items; address_i++) {
            g_string_append_printf (printable, " [%u] = '", address_i);

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_BIG, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_pdp_context_primary_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_PRIMARY_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_pdp_context_secondary_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_pdp_context_number_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_NUMBER, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_imcn_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IMCN_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_pcscf_address_using_dhcp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_DHCP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_pcscf_address_using_pco_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_PCO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_ipv4_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV4_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_authentication_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_AUTHENTICATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_AUTHENTICATION_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_authentication_get_string ((QmiWdsAuthentication)tmp));
#elif defined  __QMI_WDS_AUTHENTICATION_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_authentication_build_string_from_mask ((QmiWdsAuthentication)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsAuthentication
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_password_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PASSWORD, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_username_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_USERNAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_gprs_minimum_qos_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_GPRS_MINIMUM_QOS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " precedence_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delay_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reliability_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " peak_throughput_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mean_throughput_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_gprs_requested_qos_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_GPRS_REQUESTED_QOS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " precedence_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delay_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reliability_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " peak_throughput_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mean_throughput_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_umts_minimum_qos_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " traffic_class = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TRAFFIC_CLASS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_traffic_class_get_string ((QmiWdsTrafficClass)tmp));
#elif defined  __QMI_WDS_TRAFFIC_CLASS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_traffic_class_build_string_from_mask ((QmiWdsTrafficClass)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTrafficClass
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " qos_delivery_order = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DELIVERY_ORDER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_delivery_order_get_string ((QmiWdsDeliveryOrder)tmp));
#elif defined  __QMI_WDS_DELIVERY_ORDER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_delivery_order_build_string_from_mask ((QmiWdsDeliveryOrder)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDeliveryOrder
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " maximum_sdu_size = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sdu_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_error_ratio_get_string ((QmiWdsSduErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_error_ratio_build_string_from_mask ((QmiWdsSduErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " residual_bit_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_residual_bit_error_ratio_get_string ((QmiWdsSduResidualBitErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_residual_bit_error_ratio_build_string_from_mask ((QmiWdsSduResidualBitErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduResidualBitErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delivery_erroneous_sdu = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_erroneous_delivery_get_string ((QmiWdsSduErroneousDelivery)tmp));
#elif defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_erroneous_delivery_build_string_from_mask ((QmiWdsSduErroneousDelivery)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErroneousDelivery
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " transfer_delay = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " traffic_handling_priority = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_umts_requested_qos_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " traffic_class = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TRAFFIC_CLASS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_traffic_class_get_string ((QmiWdsTrafficClass)tmp));
#elif defined  __QMI_WDS_TRAFFIC_CLASS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_traffic_class_build_string_from_mask ((QmiWdsTrafficClass)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTrafficClass
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " qos_delivery_order = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DELIVERY_ORDER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_delivery_order_get_string ((QmiWdsDeliveryOrder)tmp));
#elif defined  __QMI_WDS_DELIVERY_ORDER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_delivery_order_build_string_from_mask ((QmiWdsDeliveryOrder)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDeliveryOrder
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " maximum_sdu_size = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sdu_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_error_ratio_get_string ((QmiWdsSduErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_error_ratio_build_string_from_mask ((QmiWdsSduErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " residual_bit_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_residual_bit_error_ratio_get_string ((QmiWdsSduResidualBitErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_residual_bit_error_ratio_build_string_from_mask ((QmiWdsSduResidualBitErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduResidualBitErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delivery_erroneous_sdu = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_erroneous_delivery_get_string ((QmiWdsSduErroneousDelivery)tmp));
#elif defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_erroneous_delivery_build_string_from_mask ((QmiWdsSduErroneousDelivery)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErroneousDelivery
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " transfer_delay = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " traffic_handling_priority = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_secondary_ipv4_dns_address_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_primary_ipv4_dns_address_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_apn_name_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_NAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_pdp_data_compression_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_DATA_COMPRESSION_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PDP_DATA_COMPRESSION_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_pdp_data_compression_type_get_string ((QmiWdsPdpDataCompressionType)tmp));
#elif defined  __QMI_WDS_PDP_DATA_COMPRESSION_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_pdp_data_compression_type_build_string_from_mask ((QmiWdsPdpDataCompressionType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsPdpDataCompressionType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_pdp_header_compression_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_HEADER_COMPRESSION_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PDP_HEADER_COMPRESSION_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_pdp_header_compression_type_get_string ((QmiWdsPdpHeaderCompressionType)tmp));
#elif defined  __QMI_WDS_PDP_HEADER_COMPRESSION_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_pdp_header_compression_type_build_string_from_mask ((QmiWdsPdpHeaderCompressionType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsPdpHeaderCompressionType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_pdp_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PDP_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_pdp_type_get_string ((QmiWdsPdpType)tmp));
#elif defined  __QMI_WDS_PDP_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_pdp_type_build_string_from_mask ((QmiWdsPdpType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsPdpType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_profile_name_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PROFILE_NAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_input_profile_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PROFILE_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PROFILE_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_profile_type_get_string ((QmiWdsProfileType)tmp));
#elif defined  __QMI_WDS_PROFILE_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_profile_type_build_string_from_mask ((QmiWdsProfileType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsProfileType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_output_profile_identifier_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_PROFILE_IDENTIFIER, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " profile_type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PROFILE_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_profile_type_get_string ((QmiWdsProfileType)tmp));
#elif defined  __QMI_WDS_PROFILE_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_profile_type_build_string_from_mask ((QmiWdsProfileType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsProfileType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " profile_index = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_create_profile_output_extended_error_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DS_PROFILE_ERROR_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_ds_profile_error_get_string ((QmiWdsDsProfileError)tmp));
#elif defined  __QMI_WDS_DS_PROFILE_ERROR_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_ds_profile_error_build_string_from_mask ((QmiWdsDsProfileError)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDsProfileError
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_create_profile_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_create_profile_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_create_profile_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_TYPE_MASK:
            tlv_type_str = "APN Type Mask";
            translated_value = qmi_message_wds_create_profile_input_apn_type_mask_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_ROAMING_DISALLOWED_FLAG:
            tlv_type_str = "Roaming Disallowed Flag";
            translated_value = qmi_message_wds_create_profile_input_roaming_disallowed_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_DISABLED_FLAG:
            tlv_type_str = "APN Disabled Flag";
            translated_value = qmi_message_wds_create_profile_input_apn_disabled_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_LTE_QOS_PARAMETERS:
            tlv_type_str = "LTE QoS Parameters";
            translated_value = qmi_message_wds_create_profile_input_lte_qos_parameters_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv6 Secondary DNS Address Preference";
            translated_value = qmi_message_wds_create_profile_input_ipv6_secondary_dns_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv6 Primary DNS Address Preference";
            translated_value = qmi_message_wds_create_profile_input_ipv6_primary_dns_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG:
            tlv_type_str = "UMTS Minimum QoS With Signaling Indication Flag";
            translated_value = qmi_message_wds_create_profile_input_umts_minimum_qos_with_signaling_indication_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG:
            tlv_type_str = "UMTS Requested QoS With Signaling Indication Flag";
            translated_value = qmi_message_wds_create_profile_input_umts_requested_qos_with_signaling_indication_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV6_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv6 Address Preference";
            translated_value = qmi_message_wds_create_profile_input_ipv6_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_PRIMARY_ID:
            tlv_type_str = "PDP Context Primary ID";
            translated_value = qmi_message_wds_create_profile_input_pdp_context_primary_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG:
            tlv_type_str = "PDP Context Secondary Flag";
            translated_value = qmi_message_wds_create_profile_input_pdp_context_secondary_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_CONTEXT_NUMBER:
            tlv_type_str = "PDP Context Number";
            translated_value = qmi_message_wds_create_profile_input_pdp_context_number_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IMCN_FLAG:
            tlv_type_str = "IMCN Flag";
            translated_value = qmi_message_wds_create_profile_input_imcn_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_DHCP:
            tlv_type_str = "PCSCF Address Using DHCP";
            translated_value = qmi_message_wds_create_profile_input_pcscf_address_using_dhcp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_PCO:
            tlv_type_str = "PCSCF Address Using PCO";
            translated_value = qmi_message_wds_create_profile_input_pcscf_address_using_pco_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_IPV4_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv4 Address Preference";
            translated_value = qmi_message_wds_create_profile_input_ipv4_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_AUTHENTICATION:
            tlv_type_str = "Authentication";
            translated_value = qmi_message_wds_create_profile_input_authentication_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PASSWORD:
            tlv_type_str = "Password";
            translated_value = qmi_message_wds_create_profile_input_password_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_USERNAME:
            tlv_type_str = "Username";
            translated_value = qmi_message_wds_create_profile_input_username_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_GPRS_MINIMUM_QOS:
            tlv_type_str = "GPRS Minimum QoS";
            translated_value = qmi_message_wds_create_profile_input_gprs_minimum_qos_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_GPRS_REQUESTED_QOS:
            tlv_type_str = "GPRS Requested QoS";
            translated_value = qmi_message_wds_create_profile_input_gprs_requested_qos_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS:
            tlv_type_str = "UMTS Minimum QoS";
            translated_value = qmi_message_wds_create_profile_input_umts_minimum_qos_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS:
            tlv_type_str = "UMTS Requested QoS";
            translated_value = qmi_message_wds_create_profile_input_umts_requested_qos_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS:
            tlv_type_str = "Secondary IPv4 DNS Address";
            translated_value = qmi_message_wds_create_profile_input_secondary_ipv4_dns_address_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS:
            tlv_type_str = "Primary IPv4 DNS Address";
            translated_value = qmi_message_wds_create_profile_input_primary_ipv4_dns_address_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_APN_NAME:
            tlv_type_str = "APN Name";
            translated_value = qmi_message_wds_create_profile_input_apn_name_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_DATA_COMPRESSION_TYPE:
            tlv_type_str = "PDP Data Compression Type";
            translated_value = qmi_message_wds_create_profile_input_pdp_data_compression_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_HEADER_COMPRESSION_TYPE:
            tlv_type_str = "PDP Header Compression Type";
            translated_value = qmi_message_wds_create_profile_input_pdp_header_compression_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PDP_TYPE:
            tlv_type_str = "PDP Type";
            translated_value = qmi_message_wds_create_profile_input_pdp_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PROFILE_NAME:
            tlv_type_str = "Profile Name";
            translated_value = qmi_message_wds_create_profile_input_profile_name_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_INPUT_TLV_PROFILE_TYPE:
            tlv_type_str = "Profile Type";
            translated_value = qmi_message_wds_create_profile_input_profile_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_PROFILE_IDENTIFIER:
            tlv_type_str = "Profile Identifier";
            translated_value = qmi_message_wds_create_profile_output_profile_identifier_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE:
            tlv_type_str = "Extended Error Code";
            translated_value = qmi_message_wds_create_profile_output_extended_error_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_create_profile_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Create Profile\" (0x0027)\n",
                            line_prefix);

    {
        struct message_create_profile_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_create_profile_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsCreateProfileOutput *
__qmi_message_wds_create_profile_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsCreateProfileOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_CREATE_PROFILE);

    self = g_slice_new0 (QmiMessageWdsCreateProfileOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_create_profile_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_create_profile_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_PROFILE_IDENTIFIER, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Profile Identifier TLV: ");
                qmi_message_wds_create_profile_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_wds_create_profile_output_profile_identifier_out;
                self->arg_profile_identifier_profile_type = (QmiWdsProfileType)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_profile_identifier_profile_index), error))
                goto qmi_message_wds_create_profile_output_profile_identifier_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Profile Identifier' TLV", offset);
            }

            self->arg_profile_identifier_set = TRUE;

qmi_message_wds_create_profile_output_profile_identifier_out:
            if (!self->arg_profile_identifier_set) {
                qmi_message_wds_create_profile_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;
        /* Prerequisite.... */
        if (!(self->arg_result_error_code == QMI_PROTOCOL_ERROR_EXTENDED_INTERNAL))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_CREATE_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE, NULL, NULL)) == 0) {
                goto qmi_message_wds_create_profile_output_extended_error_code_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_wds_create_profile_output_extended_error_code_out;
                self->arg_extended_error_code = (QmiWdsDsProfileError)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Extended Error Code' TLV", offset);
            }

            self->arg_extended_error_code_set = TRUE;

qmi_message_wds_create_profile_output_extended_error_code_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Modify Profile */


/* --- Input -- */

struct _QmiMessageWdsModifyProfileInput {
    volatile gint ref_count;

    /* APN Type Mask */
    gboolean arg_apn_type_mask_set;
    guint64 arg_apn_type_mask;

    /* Roaming Disallowed Flag */
    gboolean arg_roaming_disallowed_flag_set;
    guint8 arg_roaming_disallowed_flag;

    /* APN Disabled Flag */
    gboolean arg_apn_disabled_flag_set;
    guint8 arg_apn_disabled_flag;

    /* LTE QoS Parameters */
    gboolean arg_lte_qos_parameters_set;
    guint8 arg_lte_qos_parameters_qos_class_identifier;
    guint32 arg_lte_qos_parameters_guaranteed_downlink_bitrate;
    guint32 arg_lte_qos_parameters_max_downlink_bitrate;
    guint32 arg_lte_qos_parameters_guaranteed_uplink_bitrate;
    guint32 arg_lte_qos_parameters_max_uplink_bitrate;

    /* IPv6 Secondary DNS Address Preference */
    gboolean arg_ipv6_secondary_dns_address_preference_set;
    GArray *arg_ipv6_secondary_dns_address_preference;

    /* IPv6 Primary DNS Address Preference */
    gboolean arg_ipv6_primary_dns_address_preference_set;
    GArray *arg_ipv6_primary_dns_address_preference;

    /* UMTS Minimum QoS With Signaling Indication Flag */
    gboolean arg_umts_minimum_qos_with_signaling_indication_flag_set;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority;
    gint8 arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication;

    /* UMTS Requested QoS With Signaling Indication Flag */
    gboolean arg_umts_requested_qos_with_signaling_indication_flag_set;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_traffic_class;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority;
    gint8 arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication;

    /* IPv6 Address Preference */
    gboolean arg_ipv6_address_preference_set;
    GArray *arg_ipv6_address_preference_address;

    /* PDP Context Primary ID */
    gboolean arg_pdp_context_primary_id_set;
    guint8 arg_pdp_context_primary_id;

    /* PDP Context Secondary Flag */
    gboolean arg_pdp_context_secondary_flag_set;
    guint8 arg_pdp_context_secondary_flag;

    /* PDP Context Number */
    gboolean arg_pdp_context_number_set;
    guint8 arg_pdp_context_number;

    /* IMCN Flag */
    gboolean arg_imcn_flag_set;
    guint8 arg_imcn_flag;

    /* PCSCF Address Using DHCP */
    gboolean arg_pcscf_address_using_dhcp_set;
    guint8 arg_pcscf_address_using_dhcp;

    /* PCSCF Address Using PCO */
    gboolean arg_pcscf_address_using_pco_set;
    guint8 arg_pcscf_address_using_pco;

    /* IPv4 Address Preference */
    gboolean arg_ipv4_address_preference_set;
    guint32 arg_ipv4_address_preference;

    /* Authentication */
    gboolean arg_authentication_set;
    guint8 arg_authentication;

    /* Password */
    gboolean arg_password_set;
    gchar *arg_password;

    /* Username */
    gboolean arg_username_set;
    gchar *arg_username;

    /* GPRS Minimum QoS */
    gboolean arg_gprs_minimum_qos_set;
    guint32 arg_gprs_minimum_qos_precedence_class;
    guint32 arg_gprs_minimum_qos_delay_class;
    guint32 arg_gprs_minimum_qos_reliability_class;
    guint32 arg_gprs_minimum_qos_peak_throughput_class;
    guint32 arg_gprs_minimum_qos_mean_throughput_class;

    /* GPRS Requested QoS */
    gboolean arg_gprs_requested_qos_set;
    guint32 arg_gprs_requested_qos_precedence_class;
    guint32 arg_gprs_requested_qos_delay_class;
    guint32 arg_gprs_requested_qos_reliability_class;
    guint32 arg_gprs_requested_qos_peak_throughput_class;
    guint32 arg_gprs_requested_qos_mean_throughput_class;

    /* UMTS Minimum QoS */
    gboolean arg_umts_minimum_qos_set;
    guint8 arg_umts_minimum_qos_traffic_class;
    guint32 arg_umts_minimum_qos_max_uplink_bitrate;
    guint32 arg_umts_minimum_qos_max_downlink_bitrate;
    guint32 arg_umts_minimum_qos_guaranteed_uplink_bitrate;
    guint32 arg_umts_minimum_qos_guaranteed_downlink_bitrate;
    guint8 arg_umts_minimum_qos_qos_delivery_order;
    guint32 arg_umts_minimum_qos_maximum_sdu_size;
    guint8 arg_umts_minimum_qos_sdu_error_ratio;
    guint8 arg_umts_minimum_qos_residual_bit_error_ratio;
    guint8 arg_umts_minimum_qos_delivery_erroneous_sdu;
    guint32 arg_umts_minimum_qos_transfer_delay;
    guint32 arg_umts_minimum_qos_traffic_handling_priority;

    /* UMTS Requested QoS */
    gboolean arg_umts_requested_qos_set;
    guint8 arg_umts_requested_qos_traffic_class;
    guint32 arg_umts_requested_qos_max_uplink_bitrate;
    guint32 arg_umts_requested_qos_max_downlink_bitrate;
    guint32 arg_umts_requested_qos_guaranteed_uplink_bitrate;
    guint32 arg_umts_requested_qos_guaranteed_downlink_bitrate;
    guint8 arg_umts_requested_qos_qos_delivery_order;
    guint32 arg_umts_requested_qos_maximum_sdu_size;
    guint8 arg_umts_requested_qos_sdu_error_ratio;
    guint8 arg_umts_requested_qos_residual_bit_error_ratio;
    guint8 arg_umts_requested_qos_delivery_erroneous_sdu;
    guint32 arg_umts_requested_qos_transfer_delay;
    guint32 arg_umts_requested_qos_traffic_handling_priority;

    /* Secondary IPv4 DNS Address */
    gboolean arg_secondary_ipv4_dns_address_set;
    guint32 arg_secondary_ipv4_dns_address;

    /* Primary IPv4 DNS Address */
    gboolean arg_primary_ipv4_dns_address_set;
    guint32 arg_primary_ipv4_dns_address;

    /* APN Name */
    gboolean arg_apn_name_set;
    gchar *arg_apn_name;

    /* PDP Data Compression Type */
    gboolean arg_pdp_data_compression_type_set;
    guint8 arg_pdp_data_compression_type;

    /* PDP Header Compression Type */
    gboolean arg_pdp_header_compression_type_set;
    guint8 arg_pdp_header_compression_type;

    /* PDP Type */
    gboolean arg_pdp_type_set;
    guint8 arg_pdp_type;

    /* Profile Name */
    gboolean arg_profile_name_set;
    gchar *arg_profile_name;

    /* Profile Identifier */
    gboolean arg_profile_identifier_set;
    guint8 arg_profile_identifier_profile_type;
    guint8 arg_profile_identifier_profile_index;
};

#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_TYPE_MASK 0xDD
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_ROAMING_DISALLOWED_FLAG 0x3E
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_DISABLED_FLAG 0x2F
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_LTE_QOS_PARAMETERS 0x2E
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE 0x2C
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE 0x2B
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG 0x2A
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG 0x29
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_ADDRESS_PREFERENCE 0x28
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_PRIMARY_ID 0x27
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG 0x26
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_NUMBER 0x25
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IMCN_FLAG 0x22
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_DHCP 0x21
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_PCO 0x1F
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV4_ADDRESS_PREFERENCE 0x1E
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_AUTHENTICATION 0x1D
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PASSWORD 0x1C
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_USERNAME 0x1B
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_GPRS_MINIMUM_QOS 0x1A
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_GPRS_REQUESTED_QOS 0x19
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS 0x18
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS 0x17
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS 0x16
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS 0x15
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_NAME 0x14
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_DATA_COMPRESSION_TYPE 0x13
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_HEADER_COMPRESSION_TYPE 0x12
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_TYPE 0x11
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PROFILE_NAME 0x10
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PROFILE_IDENTIFIER 0x01

gboolean
qmi_message_wds_modify_profile_input_get_apn_type_mask (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsApnTypeMask *value_apn_type_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_apn_type_mask_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'APN Type Mask' was not found in the message");
        return FALSE;
    }

    if (value_apn_type_mask)
        *value_apn_type_mask = (QmiWdsApnTypeMask)(self->arg_apn_type_mask);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_apn_type_mask (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsApnTypeMask value_apn_type_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_apn_type_mask = (guint64)(value_apn_type_mask);
    self->arg_apn_type_mask_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_roaming_disallowed_flag (
    QmiMessageWdsModifyProfileInput *self,
    gboolean *value_roaming_disallowed_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_roaming_disallowed_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Roaming Disallowed Flag' was not found in the message");
        return FALSE;
    }

    if (value_roaming_disallowed_flag)
        *value_roaming_disallowed_flag = (gboolean)(self->arg_roaming_disallowed_flag);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_roaming_disallowed_flag (
    QmiMessageWdsModifyProfileInput *self,
    gboolean value_roaming_disallowed_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_roaming_disallowed_flag = (guint8)(value_roaming_disallowed_flag);
    self->arg_roaming_disallowed_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_apn_disabled_flag (
    QmiMessageWdsModifyProfileInput *self,
    gboolean *value_apn_disabled_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_apn_disabled_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'APN Disabled Flag' was not found in the message");
        return FALSE;
    }

    if (value_apn_disabled_flag)
        *value_apn_disabled_flag = (gboolean)(self->arg_apn_disabled_flag);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_apn_disabled_flag (
    QmiMessageWdsModifyProfileInput *self,
    gboolean value_apn_disabled_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_apn_disabled_flag = (guint8)(value_apn_disabled_flag);
    self->arg_apn_disabled_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_lte_qos_parameters (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsQosClassIdentifier *value_lte_qos_parameters_qos_class_identifier,
    guint32 *value_lte_qos_parameters_guaranteed_downlink_bitrate,
    guint32 *value_lte_qos_parameters_max_downlink_bitrate,
    guint32 *value_lte_qos_parameters_guaranteed_uplink_bitrate,
    guint32 *value_lte_qos_parameters_max_uplink_bitrate,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_qos_parameters_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE QoS Parameters' was not found in the message");
        return FALSE;
    }

    if (value_lte_qos_parameters_qos_class_identifier)
        *value_lte_qos_parameters_qos_class_identifier = (QmiWdsQosClassIdentifier)(self->arg_lte_qos_parameters_qos_class_identifier);
    if (value_lte_qos_parameters_guaranteed_downlink_bitrate)
        *value_lte_qos_parameters_guaranteed_downlink_bitrate = self->arg_lte_qos_parameters_guaranteed_downlink_bitrate;
    if (value_lte_qos_parameters_max_downlink_bitrate)
        *value_lte_qos_parameters_max_downlink_bitrate = self->arg_lte_qos_parameters_max_downlink_bitrate;
    if (value_lte_qos_parameters_guaranteed_uplink_bitrate)
        *value_lte_qos_parameters_guaranteed_uplink_bitrate = self->arg_lte_qos_parameters_guaranteed_uplink_bitrate;
    if (value_lte_qos_parameters_max_uplink_bitrate)
        *value_lte_qos_parameters_max_uplink_bitrate = self->arg_lte_qos_parameters_max_uplink_bitrate;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_lte_qos_parameters (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsQosClassIdentifier value_lte_qos_parameters_qos_class_identifier,
    guint32 value_lte_qos_parameters_guaranteed_downlink_bitrate,
    guint32 value_lte_qos_parameters_max_downlink_bitrate,
    guint32 value_lte_qos_parameters_guaranteed_uplink_bitrate,
    guint32 value_lte_qos_parameters_max_uplink_bitrate,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_lte_qos_parameters_qos_class_identifier = (guint8)(value_lte_qos_parameters_qos_class_identifier);
    self->arg_lte_qos_parameters_guaranteed_downlink_bitrate = value_lte_qos_parameters_guaranteed_downlink_bitrate;
    self->arg_lte_qos_parameters_max_downlink_bitrate = value_lte_qos_parameters_max_downlink_bitrate;
    self->arg_lte_qos_parameters_guaranteed_uplink_bitrate = value_lte_qos_parameters_guaranteed_uplink_bitrate;
    self->arg_lte_qos_parameters_max_uplink_bitrate = value_lte_qos_parameters_max_uplink_bitrate;
    self->arg_lte_qos_parameters_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_ipv6_secondary_dns_address_preference (
    QmiMessageWdsModifyProfileInput *self,
    GArray **value_ipv6_secondary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv6_secondary_dns_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv6 Secondary DNS Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv6_secondary_dns_address_preference)
        *value_ipv6_secondary_dns_address_preference = self->arg_ipv6_secondary_dns_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_ipv6_secondary_dns_address_preference (
    QmiMessageWdsModifyProfileInput *self,
    GArray *value_ipv6_secondary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_ipv6_secondary_dns_address_preference, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_ipv6_secondary_dns_address_preference, (GDestroyNotify)g_ptr_array_unref);
    self->arg_ipv6_secondary_dns_address_preference = g_array_ref (value_ipv6_secondary_dns_address_preference);
    self->arg_ipv6_secondary_dns_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_ipv6_primary_dns_address_preference (
    QmiMessageWdsModifyProfileInput *self,
    GArray **value_ipv6_primary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv6_primary_dns_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv6 Primary DNS Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv6_primary_dns_address_preference)
        *value_ipv6_primary_dns_address_preference = self->arg_ipv6_primary_dns_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_ipv6_primary_dns_address_preference (
    QmiMessageWdsModifyProfileInput *self,
    GArray *value_ipv6_primary_dns_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_ipv6_primary_dns_address_preference, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_ipv6_primary_dns_address_preference, (GDestroyNotify)g_ptr_array_unref);
    self->arg_ipv6_primary_dns_address_preference = g_array_ref (value_ipv6_primary_dns_address_preference);
    self->arg_ipv6_primary_dns_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_umts_minimum_qos_with_signaling_indication_flag (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsTrafficClass *value_umts_minimum_qos_with_signaling_indication_flag_traffic_class,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay,
    guint32 *value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 *value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_minimum_qos_with_signaling_indication_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Minimum QoS With Signaling Indication Flag' was not found in the message");
        return FALSE;
    }

    if (value_umts_minimum_qos_with_signaling_indication_flag_traffic_class)
        *value_umts_minimum_qos_with_signaling_indication_flag_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class);
    if (value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate)
        *value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate = self->arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate;
    if (value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate)
        *value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate = self->arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate;
    if (value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate)
        *value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate = self->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    if (value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate)
        *value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate = self->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    if (value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order)
        *value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order);
    if (value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size)
        *value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size = self->arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size;
    if (value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio)
        *value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio);
    if (value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio)
        *value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio);
    if (value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu)
        *value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu);
    if (value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay)
        *value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay = self->arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay;
    if (value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority)
        *value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority = self->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority;
    if (value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication)
        *value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication = self->arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_umts_minimum_qos_with_signaling_indication_flag (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsTrafficClass value_umts_minimum_qos_with_signaling_indication_flag_traffic_class,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay,
    guint32 value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_traffic_class);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate = value_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate = value_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate = value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate = value_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size = value_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu = (guint8)(value_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu);
    self->arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay = value_umts_minimum_qos_with_signaling_indication_flag_transfer_delay;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority = value_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication = value_umts_minimum_qos_with_signaling_indication_flag_signaling_indication;
    self->arg_umts_minimum_qos_with_signaling_indication_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_umts_requested_qos_with_signaling_indication_flag (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsTrafficClass *value_umts_requested_qos_with_signaling_indication_flag_traffic_class,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_transfer_delay,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 *value_umts_requested_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_requested_qos_with_signaling_indication_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Requested QoS With Signaling Indication Flag' was not found in the message");
        return FALSE;
    }

    if (value_umts_requested_qos_with_signaling_indication_flag_traffic_class)
        *value_umts_requested_qos_with_signaling_indication_flag_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_requested_qos_with_signaling_indication_flag_traffic_class);
    if (value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate)
        *value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate = self->arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate;
    if (value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate)
        *value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate = self->arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate;
    if (value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate)
        *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate = self->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    if (value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate)
        *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate = self->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    if (value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order)
        *value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order);
    if (value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size)
        *value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size = self->arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size;
    if (value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio)
        *value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio);
    if (value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio)
        *value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio);
    if (value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu)
        *value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu);
    if (value_umts_requested_qos_with_signaling_indication_flag_transfer_delay)
        *value_umts_requested_qos_with_signaling_indication_flag_transfer_delay = self->arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay;
    if (value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority)
        *value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority = self->arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority;
    if (value_umts_requested_qos_with_signaling_indication_flag_signaling_indication)
        *value_umts_requested_qos_with_signaling_indication_flag_signaling_indication = self->arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_umts_requested_qos_with_signaling_indication_flag (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsTrafficClass value_umts_requested_qos_with_signaling_indication_flag_traffic_class,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_transfer_delay,
    guint32 value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 value_umts_requested_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_umts_requested_qos_with_signaling_indication_flag_traffic_class = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_traffic_class);
    self->arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate = value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate;
    self->arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate = value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate;
    self->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate = value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    self->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate = value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    self->arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order);
    self->arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size = value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size;
    self->arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio);
    self->arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio);
    self->arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu = (guint8)(value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu);
    self->arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay = value_umts_requested_qos_with_signaling_indication_flag_transfer_delay;
    self->arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority = value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority;
    self->arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication = value_umts_requested_qos_with_signaling_indication_flag_signaling_indication;
    self->arg_umts_requested_qos_with_signaling_indication_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_ipv6_address_preference (
    QmiMessageWdsModifyProfileInput *self,
    GArray **value_ipv6_address_preference_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv6_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv6 Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv6_address_preference_address)
        *value_ipv6_address_preference_address = self->arg_ipv6_address_preference_address;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_ipv6_address_preference (
    QmiMessageWdsModifyProfileInput *self,
    GArray *value_ipv6_address_preference_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_clear_pointer (&self->arg_ipv6_address_preference_address, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_ipv6_address_preference_address, (GDestroyNotify)g_ptr_array_unref);
    self->arg_ipv6_address_preference_address = g_array_ref (value_ipv6_address_preference_address);
    self->arg_ipv6_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_pdp_context_primary_id (
    QmiMessageWdsModifyProfileInput *self,
    guint8 *value_pdp_context_primary_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_primary_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Primary ID' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_primary_id)
        *value_pdp_context_primary_id = self->arg_pdp_context_primary_id;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_pdp_context_primary_id (
    QmiMessageWdsModifyProfileInput *self,
    guint8 value_pdp_context_primary_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_context_primary_id = value_pdp_context_primary_id;
    self->arg_pdp_context_primary_id_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_pdp_context_secondary_flag (
    QmiMessageWdsModifyProfileInput *self,
    gboolean *value_pdp_context_secondary_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_secondary_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Secondary Flag' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_secondary_flag)
        *value_pdp_context_secondary_flag = (gboolean)(self->arg_pdp_context_secondary_flag);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_pdp_context_secondary_flag (
    QmiMessageWdsModifyProfileInput *self,
    gboolean value_pdp_context_secondary_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_context_secondary_flag = (guint8)(value_pdp_context_secondary_flag);
    self->arg_pdp_context_secondary_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_pdp_context_number (
    QmiMessageWdsModifyProfileInput *self,
    guint8 *value_pdp_context_number,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_number_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Number' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_number)
        *value_pdp_context_number = self->arg_pdp_context_number;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_pdp_context_number (
    QmiMessageWdsModifyProfileInput *self,
    guint8 value_pdp_context_number,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_context_number = value_pdp_context_number;
    self->arg_pdp_context_number_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_imcn_flag (
    QmiMessageWdsModifyProfileInput *self,
    gboolean *value_imcn_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_imcn_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IMCN Flag' was not found in the message");
        return FALSE;
    }

    if (value_imcn_flag)
        *value_imcn_flag = (gboolean)(self->arg_imcn_flag);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_imcn_flag (
    QmiMessageWdsModifyProfileInput *self,
    gboolean value_imcn_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_imcn_flag = (guint8)(value_imcn_flag);
    self->arg_imcn_flag_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_pcscf_address_using_dhcp (
    QmiMessageWdsModifyProfileInput *self,
    gboolean *value_pcscf_address_using_dhcp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pcscf_address_using_dhcp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PCSCF Address Using DHCP' was not found in the message");
        return FALSE;
    }

    if (value_pcscf_address_using_dhcp)
        *value_pcscf_address_using_dhcp = (gboolean)(self->arg_pcscf_address_using_dhcp);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_pcscf_address_using_dhcp (
    QmiMessageWdsModifyProfileInput *self,
    gboolean value_pcscf_address_using_dhcp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pcscf_address_using_dhcp = (guint8)(value_pcscf_address_using_dhcp);
    self->arg_pcscf_address_using_dhcp_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_pcscf_address_using_pco (
    QmiMessageWdsModifyProfileInput *self,
    gboolean *value_pcscf_address_using_pco,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pcscf_address_using_pco_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PCSCF Address Using PCO' was not found in the message");
        return FALSE;
    }

    if (value_pcscf_address_using_pco)
        *value_pcscf_address_using_pco = (gboolean)(self->arg_pcscf_address_using_pco);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_pcscf_address_using_pco (
    QmiMessageWdsModifyProfileInput *self,
    gboolean value_pcscf_address_using_pco,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pcscf_address_using_pco = (guint8)(value_pcscf_address_using_pco);
    self->arg_pcscf_address_using_pco_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_ipv4_address_preference (
    QmiMessageWdsModifyProfileInput *self,
    guint32 *value_ipv4_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv4_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv4 Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv4_address_preference)
        *value_ipv4_address_preference = self->arg_ipv4_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_ipv4_address_preference (
    QmiMessageWdsModifyProfileInput *self,
    guint32 value_ipv4_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_ipv4_address_preference = value_ipv4_address_preference;
    self->arg_ipv4_address_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_authentication (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsAuthentication *value_authentication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_authentication_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Authentication' was not found in the message");
        return FALSE;
    }

    if (value_authentication)
        *value_authentication = (QmiWdsAuthentication)(self->arg_authentication);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_authentication (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsAuthentication value_authentication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_authentication = (guint8)(value_authentication);
    self->arg_authentication_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_password (
    QmiMessageWdsModifyProfileInput *self,
    const gchar **value_password,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_password_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Password' was not found in the message");
        return FALSE;
    }

    if (value_password)
        *value_password = self->arg_password;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_password (
    QmiMessageWdsModifyProfileInput *self,
    const gchar *value_password,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_password);
    self->arg_password = g_strdup (value_password ? value_password : "");
    self->arg_password_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_username (
    QmiMessageWdsModifyProfileInput *self,
    const gchar **value_username,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_username_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Username' was not found in the message");
        return FALSE;
    }

    if (value_username)
        *value_username = self->arg_username;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_username (
    QmiMessageWdsModifyProfileInput *self,
    const gchar *value_username,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_username);
    self->arg_username = g_strdup (value_username ? value_username : "");
    self->arg_username_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_gprs_minimum_qos (
    QmiMessageWdsModifyProfileInput *self,
    guint32 *value_gprs_minimum_qos_precedence_class,
    guint32 *value_gprs_minimum_qos_delay_class,
    guint32 *value_gprs_minimum_qos_reliability_class,
    guint32 *value_gprs_minimum_qos_peak_throughput_class,
    guint32 *value_gprs_minimum_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gprs_minimum_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GPRS Minimum QoS' was not found in the message");
        return FALSE;
    }

    if (value_gprs_minimum_qos_precedence_class)
        *value_gprs_minimum_qos_precedence_class = self->arg_gprs_minimum_qos_precedence_class;
    if (value_gprs_minimum_qos_delay_class)
        *value_gprs_minimum_qos_delay_class = self->arg_gprs_minimum_qos_delay_class;
    if (value_gprs_minimum_qos_reliability_class)
        *value_gprs_minimum_qos_reliability_class = self->arg_gprs_minimum_qos_reliability_class;
    if (value_gprs_minimum_qos_peak_throughput_class)
        *value_gprs_minimum_qos_peak_throughput_class = self->arg_gprs_minimum_qos_peak_throughput_class;
    if (value_gprs_minimum_qos_mean_throughput_class)
        *value_gprs_minimum_qos_mean_throughput_class = self->arg_gprs_minimum_qos_mean_throughput_class;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_gprs_minimum_qos (
    QmiMessageWdsModifyProfileInput *self,
    guint32 value_gprs_minimum_qos_precedence_class,
    guint32 value_gprs_minimum_qos_delay_class,
    guint32 value_gprs_minimum_qos_reliability_class,
    guint32 value_gprs_minimum_qos_peak_throughput_class,
    guint32 value_gprs_minimum_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_gprs_minimum_qos_precedence_class = value_gprs_minimum_qos_precedence_class;
    self->arg_gprs_minimum_qos_delay_class = value_gprs_minimum_qos_delay_class;
    self->arg_gprs_minimum_qos_reliability_class = value_gprs_minimum_qos_reliability_class;
    self->arg_gprs_minimum_qos_peak_throughput_class = value_gprs_minimum_qos_peak_throughput_class;
    self->arg_gprs_minimum_qos_mean_throughput_class = value_gprs_minimum_qos_mean_throughput_class;
    self->arg_gprs_minimum_qos_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_gprs_requested_qos (
    QmiMessageWdsModifyProfileInput *self,
    guint32 *value_gprs_requested_qos_precedence_class,
    guint32 *value_gprs_requested_qos_delay_class,
    guint32 *value_gprs_requested_qos_reliability_class,
    guint32 *value_gprs_requested_qos_peak_throughput_class,
    guint32 *value_gprs_requested_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gprs_requested_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GPRS Requested QoS' was not found in the message");
        return FALSE;
    }

    if (value_gprs_requested_qos_precedence_class)
        *value_gprs_requested_qos_precedence_class = self->arg_gprs_requested_qos_precedence_class;
    if (value_gprs_requested_qos_delay_class)
        *value_gprs_requested_qos_delay_class = self->arg_gprs_requested_qos_delay_class;
    if (value_gprs_requested_qos_reliability_class)
        *value_gprs_requested_qos_reliability_class = self->arg_gprs_requested_qos_reliability_class;
    if (value_gprs_requested_qos_peak_throughput_class)
        *value_gprs_requested_qos_peak_throughput_class = self->arg_gprs_requested_qos_peak_throughput_class;
    if (value_gprs_requested_qos_mean_throughput_class)
        *value_gprs_requested_qos_mean_throughput_class = self->arg_gprs_requested_qos_mean_throughput_class;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_gprs_requested_qos (
    QmiMessageWdsModifyProfileInput *self,
    guint32 value_gprs_requested_qos_precedence_class,
    guint32 value_gprs_requested_qos_delay_class,
    guint32 value_gprs_requested_qos_reliability_class,
    guint32 value_gprs_requested_qos_peak_throughput_class,
    guint32 value_gprs_requested_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_gprs_requested_qos_precedence_class = value_gprs_requested_qos_precedence_class;
    self->arg_gprs_requested_qos_delay_class = value_gprs_requested_qos_delay_class;
    self->arg_gprs_requested_qos_reliability_class = value_gprs_requested_qos_reliability_class;
    self->arg_gprs_requested_qos_peak_throughput_class = value_gprs_requested_qos_peak_throughput_class;
    self->arg_gprs_requested_qos_mean_throughput_class = value_gprs_requested_qos_mean_throughput_class;
    self->arg_gprs_requested_qos_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_umts_minimum_qos (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsTrafficClass *value_umts_minimum_qos_traffic_class,
    guint32 *value_umts_minimum_qos_max_uplink_bitrate,
    guint32 *value_umts_minimum_qos_max_downlink_bitrate,
    guint32 *value_umts_minimum_qos_guaranteed_uplink_bitrate,
    guint32 *value_umts_minimum_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_minimum_qos_qos_delivery_order,
    guint32 *value_umts_minimum_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_minimum_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_minimum_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_minimum_qos_delivery_erroneous_sdu,
    guint32 *value_umts_minimum_qos_transfer_delay,
    guint32 *value_umts_minimum_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_minimum_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Minimum QoS' was not found in the message");
        return FALSE;
    }

    if (value_umts_minimum_qos_traffic_class)
        *value_umts_minimum_qos_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_minimum_qos_traffic_class);
    if (value_umts_minimum_qos_max_uplink_bitrate)
        *value_umts_minimum_qos_max_uplink_bitrate = self->arg_umts_minimum_qos_max_uplink_bitrate;
    if (value_umts_minimum_qos_max_downlink_bitrate)
        *value_umts_minimum_qos_max_downlink_bitrate = self->arg_umts_minimum_qos_max_downlink_bitrate;
    if (value_umts_minimum_qos_guaranteed_uplink_bitrate)
        *value_umts_minimum_qos_guaranteed_uplink_bitrate = self->arg_umts_minimum_qos_guaranteed_uplink_bitrate;
    if (value_umts_minimum_qos_guaranteed_downlink_bitrate)
        *value_umts_minimum_qos_guaranteed_downlink_bitrate = self->arg_umts_minimum_qos_guaranteed_downlink_bitrate;
    if (value_umts_minimum_qos_qos_delivery_order)
        *value_umts_minimum_qos_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_minimum_qos_qos_delivery_order);
    if (value_umts_minimum_qos_maximum_sdu_size)
        *value_umts_minimum_qos_maximum_sdu_size = self->arg_umts_minimum_qos_maximum_sdu_size;
    if (value_umts_minimum_qos_sdu_error_ratio)
        *value_umts_minimum_qos_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_minimum_qos_sdu_error_ratio);
    if (value_umts_minimum_qos_residual_bit_error_ratio)
        *value_umts_minimum_qos_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_minimum_qos_residual_bit_error_ratio);
    if (value_umts_minimum_qos_delivery_erroneous_sdu)
        *value_umts_minimum_qos_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_minimum_qos_delivery_erroneous_sdu);
    if (value_umts_minimum_qos_transfer_delay)
        *value_umts_minimum_qos_transfer_delay = self->arg_umts_minimum_qos_transfer_delay;
    if (value_umts_minimum_qos_traffic_handling_priority)
        *value_umts_minimum_qos_traffic_handling_priority = self->arg_umts_minimum_qos_traffic_handling_priority;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_umts_minimum_qos (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsTrafficClass value_umts_minimum_qos_traffic_class,
    guint32 value_umts_minimum_qos_max_uplink_bitrate,
    guint32 value_umts_minimum_qos_max_downlink_bitrate,
    guint32 value_umts_minimum_qos_guaranteed_uplink_bitrate,
    guint32 value_umts_minimum_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder value_umts_minimum_qos_qos_delivery_order,
    guint32 value_umts_minimum_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio value_umts_minimum_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio value_umts_minimum_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery value_umts_minimum_qos_delivery_erroneous_sdu,
    guint32 value_umts_minimum_qos_transfer_delay,
    guint32 value_umts_minimum_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_umts_minimum_qos_traffic_class = (guint8)(value_umts_minimum_qos_traffic_class);
    self->arg_umts_minimum_qos_max_uplink_bitrate = value_umts_minimum_qos_max_uplink_bitrate;
    self->arg_umts_minimum_qos_max_downlink_bitrate = value_umts_minimum_qos_max_downlink_bitrate;
    self->arg_umts_minimum_qos_guaranteed_uplink_bitrate = value_umts_minimum_qos_guaranteed_uplink_bitrate;
    self->arg_umts_minimum_qos_guaranteed_downlink_bitrate = value_umts_minimum_qos_guaranteed_downlink_bitrate;
    self->arg_umts_minimum_qos_qos_delivery_order = (guint8)(value_umts_minimum_qos_qos_delivery_order);
    self->arg_umts_minimum_qos_maximum_sdu_size = value_umts_minimum_qos_maximum_sdu_size;
    self->arg_umts_minimum_qos_sdu_error_ratio = (guint8)(value_umts_minimum_qos_sdu_error_ratio);
    self->arg_umts_minimum_qos_residual_bit_error_ratio = (guint8)(value_umts_minimum_qos_residual_bit_error_ratio);
    self->arg_umts_minimum_qos_delivery_erroneous_sdu = (guint8)(value_umts_minimum_qos_delivery_erroneous_sdu);
    self->arg_umts_minimum_qos_transfer_delay = value_umts_minimum_qos_transfer_delay;
    self->arg_umts_minimum_qos_traffic_handling_priority = value_umts_minimum_qos_traffic_handling_priority;
    self->arg_umts_minimum_qos_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_umts_requested_qos (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsTrafficClass *value_umts_requested_qos_traffic_class,
    guint32 *value_umts_requested_qos_max_uplink_bitrate,
    guint32 *value_umts_requested_qos_max_downlink_bitrate,
    guint32 *value_umts_requested_qos_guaranteed_uplink_bitrate,
    guint32 *value_umts_requested_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_requested_qos_qos_delivery_order,
    guint32 *value_umts_requested_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_requested_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_requested_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_requested_qos_delivery_erroneous_sdu,
    guint32 *value_umts_requested_qos_transfer_delay,
    guint32 *value_umts_requested_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_requested_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Requested QoS' was not found in the message");
        return FALSE;
    }

    if (value_umts_requested_qos_traffic_class)
        *value_umts_requested_qos_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_requested_qos_traffic_class);
    if (value_umts_requested_qos_max_uplink_bitrate)
        *value_umts_requested_qos_max_uplink_bitrate = self->arg_umts_requested_qos_max_uplink_bitrate;
    if (value_umts_requested_qos_max_downlink_bitrate)
        *value_umts_requested_qos_max_downlink_bitrate = self->arg_umts_requested_qos_max_downlink_bitrate;
    if (value_umts_requested_qos_guaranteed_uplink_bitrate)
        *value_umts_requested_qos_guaranteed_uplink_bitrate = self->arg_umts_requested_qos_guaranteed_uplink_bitrate;
    if (value_umts_requested_qos_guaranteed_downlink_bitrate)
        *value_umts_requested_qos_guaranteed_downlink_bitrate = self->arg_umts_requested_qos_guaranteed_downlink_bitrate;
    if (value_umts_requested_qos_qos_delivery_order)
        *value_umts_requested_qos_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_requested_qos_qos_delivery_order);
    if (value_umts_requested_qos_maximum_sdu_size)
        *value_umts_requested_qos_maximum_sdu_size = self->arg_umts_requested_qos_maximum_sdu_size;
    if (value_umts_requested_qos_sdu_error_ratio)
        *value_umts_requested_qos_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_requested_qos_sdu_error_ratio);
    if (value_umts_requested_qos_residual_bit_error_ratio)
        *value_umts_requested_qos_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_requested_qos_residual_bit_error_ratio);
    if (value_umts_requested_qos_delivery_erroneous_sdu)
        *value_umts_requested_qos_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_requested_qos_delivery_erroneous_sdu);
    if (value_umts_requested_qos_transfer_delay)
        *value_umts_requested_qos_transfer_delay = self->arg_umts_requested_qos_transfer_delay;
    if (value_umts_requested_qos_traffic_handling_priority)
        *value_umts_requested_qos_traffic_handling_priority = self->arg_umts_requested_qos_traffic_handling_priority;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_umts_requested_qos (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsTrafficClass value_umts_requested_qos_traffic_class,
    guint32 value_umts_requested_qos_max_uplink_bitrate,
    guint32 value_umts_requested_qos_max_downlink_bitrate,
    guint32 value_umts_requested_qos_guaranteed_uplink_bitrate,
    guint32 value_umts_requested_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder value_umts_requested_qos_qos_delivery_order,
    guint32 value_umts_requested_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio value_umts_requested_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio value_umts_requested_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery value_umts_requested_qos_delivery_erroneous_sdu,
    guint32 value_umts_requested_qos_transfer_delay,
    guint32 value_umts_requested_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_umts_requested_qos_traffic_class = (guint8)(value_umts_requested_qos_traffic_class);
    self->arg_umts_requested_qos_max_uplink_bitrate = value_umts_requested_qos_max_uplink_bitrate;
    self->arg_umts_requested_qos_max_downlink_bitrate = value_umts_requested_qos_max_downlink_bitrate;
    self->arg_umts_requested_qos_guaranteed_uplink_bitrate = value_umts_requested_qos_guaranteed_uplink_bitrate;
    self->arg_umts_requested_qos_guaranteed_downlink_bitrate = value_umts_requested_qos_guaranteed_downlink_bitrate;
    self->arg_umts_requested_qos_qos_delivery_order = (guint8)(value_umts_requested_qos_qos_delivery_order);
    self->arg_umts_requested_qos_maximum_sdu_size = value_umts_requested_qos_maximum_sdu_size;
    self->arg_umts_requested_qos_sdu_error_ratio = (guint8)(value_umts_requested_qos_sdu_error_ratio);
    self->arg_umts_requested_qos_residual_bit_error_ratio = (guint8)(value_umts_requested_qos_residual_bit_error_ratio);
    self->arg_umts_requested_qos_delivery_erroneous_sdu = (guint8)(value_umts_requested_qos_delivery_erroneous_sdu);
    self->arg_umts_requested_qos_transfer_delay = value_umts_requested_qos_transfer_delay;
    self->arg_umts_requested_qos_traffic_handling_priority = value_umts_requested_qos_traffic_handling_priority;
    self->arg_umts_requested_qos_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_secondary_ipv4_dns_address (
    QmiMessageWdsModifyProfileInput *self,
    guint32 *value_secondary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_secondary_ipv4_dns_address_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Secondary IPv4 DNS Address' was not found in the message");
        return FALSE;
    }

    if (value_secondary_ipv4_dns_address)
        *value_secondary_ipv4_dns_address = self->arg_secondary_ipv4_dns_address;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_secondary_ipv4_dns_address (
    QmiMessageWdsModifyProfileInput *self,
    guint32 value_secondary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_secondary_ipv4_dns_address = value_secondary_ipv4_dns_address;
    self->arg_secondary_ipv4_dns_address_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_primary_ipv4_dns_address (
    QmiMessageWdsModifyProfileInput *self,
    guint32 *value_primary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_primary_ipv4_dns_address_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Primary IPv4 DNS Address' was not found in the message");
        return FALSE;
    }

    if (value_primary_ipv4_dns_address)
        *value_primary_ipv4_dns_address = self->arg_primary_ipv4_dns_address;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_primary_ipv4_dns_address (
    QmiMessageWdsModifyProfileInput *self,
    guint32 value_primary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_primary_ipv4_dns_address = value_primary_ipv4_dns_address;
    self->arg_primary_ipv4_dns_address_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_apn_name (
    QmiMessageWdsModifyProfileInput *self,
    const gchar **value_apn_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_apn_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'APN Name' was not found in the message");
        return FALSE;
    }

    if (value_apn_name)
        *value_apn_name = self->arg_apn_name;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_apn_name (
    QmiMessageWdsModifyProfileInput *self,
    const gchar *value_apn_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_apn_name);
    self->arg_apn_name = g_strdup (value_apn_name ? value_apn_name : "");
    self->arg_apn_name_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_pdp_data_compression_type (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsPdpDataCompressionType *value_pdp_data_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_data_compression_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Data Compression Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_data_compression_type)
        *value_pdp_data_compression_type = (QmiWdsPdpDataCompressionType)(self->arg_pdp_data_compression_type);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_pdp_data_compression_type (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsPdpDataCompressionType value_pdp_data_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_data_compression_type = (guint8)(value_pdp_data_compression_type);
    self->arg_pdp_data_compression_type_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_pdp_header_compression_type (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsPdpHeaderCompressionType *value_pdp_header_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_header_compression_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Header Compression Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_header_compression_type)
        *value_pdp_header_compression_type = (QmiWdsPdpHeaderCompressionType)(self->arg_pdp_header_compression_type);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_pdp_header_compression_type (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsPdpHeaderCompressionType value_pdp_header_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_header_compression_type = (guint8)(value_pdp_header_compression_type);
    self->arg_pdp_header_compression_type_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_pdp_type (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsPdpType *value_pdp_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_type)
        *value_pdp_type = (QmiWdsPdpType)(self->arg_pdp_type);

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_pdp_type (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsPdpType value_pdp_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_pdp_type = (guint8)(value_pdp_type);
    self->arg_pdp_type_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_profile_name (
    QmiMessageWdsModifyProfileInput *self,
    const gchar **value_profile_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Name' was not found in the message");
        return FALSE;
    }

    if (value_profile_name)
        *value_profile_name = self->arg_profile_name;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_profile_name (
    QmiMessageWdsModifyProfileInput *self,
    const gchar *value_profile_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    g_free (self->arg_profile_name);
    self->arg_profile_name = g_strdup (value_profile_name ? value_profile_name : "");
    self->arg_profile_name_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_get_profile_identifier (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsProfileType *value_profile_identifier_profile_type,
    guint8 *value_profile_identifier_profile_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_identifier_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Identifier' was not found in the message");
        return FALSE;
    }

    if (value_profile_identifier_profile_type)
        *value_profile_identifier_profile_type = (QmiWdsProfileType)(self->arg_profile_identifier_profile_type);
    if (value_profile_identifier_profile_index)
        *value_profile_identifier_profile_index = self->arg_profile_identifier_profile_index;

    return TRUE;
}

gboolean
qmi_message_wds_modify_profile_input_set_profile_identifier (
    QmiMessageWdsModifyProfileInput *self,
    QmiWdsProfileType value_profile_identifier_profile_type,
    guint8 value_profile_identifier_profile_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_profile_identifier_profile_type = (guint8)(value_profile_identifier_profile_type);
    self->arg_profile_identifier_profile_index = value_profile_identifier_profile_index;
    self->arg_profile_identifier_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_modify_profile_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsModifyProfileInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_modify_profile_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_modify_profile_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsModifyProfileInput *
qmi_message_wds_modify_profile_input_ref (QmiMessageWdsModifyProfileInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_modify_profile_input_unref (QmiMessageWdsModifyProfileInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_ipv6_secondary_dns_address_preference, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_ipv6_primary_dns_address_preference, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_ipv6_address_preference_address, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_password, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_username, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_apn_name, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_profile_name, (GDestroyNotify)g_free);
        g_slice_free (QmiMessageWdsModifyProfileInput, self);
    }
}

QmiMessageWdsModifyProfileInput *
qmi_message_wds_modify_profile_input_new (void)
{
    QmiMessageWdsModifyProfileInput *self;

    self = g_slice_new0 (QmiMessageWdsModifyProfileInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_modify_profile_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsModifyProfileInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_MODIFY_PROFILE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Modify Profile' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'APN Type Mask' TLV */
    if (input->arg_apn_type_mask_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_TYPE_MASK, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'APN Type Mask': ");
            return NULL;
        }

        {
            guint64 tmp;

            tmp = (guint64) input->arg_apn_type_mask;
            /* Write the guint64 variable to the buffer */
            if (!qmi_message_tlv_write_guint64 (self, QMI_ENDIAN_LITTLE, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'APN Type Mask': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'APN Type Mask': ");
            return NULL;
        }
    }

    /* Try to add the 'Roaming Disallowed Flag' TLV */
    if (input->arg_roaming_disallowed_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_ROAMING_DISALLOWED_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Roaming Disallowed Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_roaming_disallowed_flag;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Roaming Disallowed Flag': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Roaming Disallowed Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'APN Disabled Flag' TLV */
    if (input->arg_apn_disabled_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_DISABLED_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'APN Disabled Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_apn_disabled_flag;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'APN Disabled Flag': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'APN Disabled Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'LTE QoS Parameters' TLV */
    if (input->arg_lte_qos_parameters_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_LTE_QOS_PARAMETERS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'LTE QoS Parameters': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_lte_qos_parameters_qos_class_identifier;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'LTE QoS Parameters': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_lte_qos_parameters_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE QoS Parameters': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_lte_qos_parameters_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE QoS Parameters': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_lte_qos_parameters_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE QoS Parameters': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_lte_qos_parameters_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE QoS Parameters': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'LTE QoS Parameters': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv6 Secondary DNS Address Preference' TLV */
    if (input->arg_ipv6_secondary_dns_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv6 Secondary DNS Address Preference': ");
            return NULL;
        }

        {
            guint ipv6_secondary_dns_address_preference_i;

            for (ipv6_secondary_dns_address_preference_i = 0; ipv6_secondary_dns_address_preference_i < input->arg_ipv6_secondary_dns_address_preference->len; ipv6_secondary_dns_address_preference_i++) {
                /* Write the guint16 variable to the buffer */
                if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_BIG, g_array_index (input->arg_ipv6_secondary_dns_address_preference, guint16,ipv6_secondary_dns_address_preference_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'IPv6 Secondary DNS Address Preference': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv6 Secondary DNS Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv6 Primary DNS Address Preference' TLV */
    if (input->arg_ipv6_primary_dns_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv6 Primary DNS Address Preference': ");
            return NULL;
        }

        {
            guint ipv6_primary_dns_address_preference_i;

            for (ipv6_primary_dns_address_preference_i = 0; ipv6_primary_dns_address_preference_i < input->arg_ipv6_primary_dns_address_preference->len; ipv6_primary_dns_address_preference_i++) {
                /* Write the guint16 variable to the buffer */
                if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_BIG, g_array_index (input->arg_ipv6_primary_dns_address_preference, guint16,ipv6_primary_dns_address_preference_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'IPv6 Primary DNS Address Preference': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv6 Primary DNS Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'UMTS Minimum QoS With Signaling Indication Flag' TLV */
    if (input->arg_umts_minimum_qos_with_signaling_indication_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the gint8 variable to the buffer */
        if (!qmi_message_tlv_write_gint8 (self, input->arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UMTS Minimum QoS With Signaling Indication Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'UMTS Requested QoS With Signaling Indication Flag' TLV */
    if (input->arg_umts_requested_qos_with_signaling_indication_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_traffic_class;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
        /* Write the gint8 variable to the buffer */
        if (!qmi_message_tlv_write_gint8 (self, input->arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UMTS Requested QoS With Signaling Indication Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv6 Address Preference' TLV */
    if (input->arg_ipv6_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv6 Address Preference': ");
            return NULL;
        }

        {
            guint address_i;

            for (address_i = 0; address_i < input->arg_ipv6_address_preference_address->len; address_i++) {
                /* Write the guint16 variable to the buffer */
                if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_BIG, g_array_index (input->arg_ipv6_address_preference_address, guint16,address_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'IPv6 Address Preference': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv6 Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Context Primary ID' TLV */
    if (input->arg_pdp_context_primary_id_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_PRIMARY_ID, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Context Primary ID': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_pdp_context_primary_id, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'PDP Context Primary ID': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Context Primary ID': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Context Secondary Flag' TLV */
    if (input->arg_pdp_context_secondary_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Context Secondary Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdp_context_secondary_flag;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDP Context Secondary Flag': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Context Secondary Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Context Number' TLV */
    if (input->arg_pdp_context_number_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_NUMBER, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Context Number': ");
            return NULL;
        }

        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_pdp_context_number, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'PDP Context Number': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Context Number': ");
            return NULL;
        }
    }

    /* Try to add the 'IMCN Flag' TLV */
    if (input->arg_imcn_flag_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IMCN_FLAG, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IMCN Flag': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_imcn_flag;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'IMCN Flag': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IMCN Flag': ");
            return NULL;
        }
    }

    /* Try to add the 'PCSCF Address Using DHCP' TLV */
    if (input->arg_pcscf_address_using_dhcp_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_DHCP, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PCSCF Address Using DHCP': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pcscf_address_using_dhcp;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PCSCF Address Using DHCP': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PCSCF Address Using DHCP': ");
            return NULL;
        }
    }

    /* Try to add the 'PCSCF Address Using PCO' TLV */
    if (input->arg_pcscf_address_using_pco_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_PCO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PCSCF Address Using PCO': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pcscf_address_using_pco;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PCSCF Address Using PCO': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PCSCF Address Using PCO': ");
            return NULL;
        }
    }

    /* Try to add the 'IPv4 Address Preference' TLV */
    if (input->arg_ipv4_address_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV4_ADDRESS_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IPv4 Address Preference': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_ipv4_address_preference, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'IPv4 Address Preference': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IPv4 Address Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'Authentication' TLV */
    if (input->arg_authentication_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_AUTHENTICATION, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Authentication': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_authentication;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Authentication': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Authentication': ");
            return NULL;
        }
    }

    /* Try to add the 'Password' TLV */
    if (input->arg_password_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PASSWORD, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Password': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_password, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Password': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Password': ");
            return NULL;
        }
    }

    /* Try to add the 'Username' TLV */
    if (input->arg_username_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_USERNAME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Username': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_username, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Username': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Username': ");
            return NULL;
        }
    }

    /* Try to add the 'GPRS Minimum QoS' TLV */
    if (input->arg_gprs_minimum_qos_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_GPRS_MINIMUM_QOS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'GPRS Minimum QoS': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_precedence_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_delay_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_reliability_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_peak_throughput_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_minimum_qos_mean_throughput_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Minimum QoS': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'GPRS Minimum QoS': ");
            return NULL;
        }
    }

    /* Try to add the 'GPRS Requested QoS' TLV */
    if (input->arg_gprs_requested_qos_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_GPRS_REQUESTED_QOS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'GPRS Requested QoS': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_precedence_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_delay_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_reliability_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_peak_throughput_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_gprs_requested_qos_mean_throughput_class, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'GPRS Requested QoS': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'GPRS Requested QoS': ");
            return NULL;
        }
    }

    /* Try to add the 'UMTS Minimum QoS' TLV */
    if (input->arg_umts_minimum_qos_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UMTS Minimum QoS': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_traffic_class;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_qos_delivery_order;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_maximum_sdu_size, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_sdu_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_residual_bit_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_minimum_qos_delivery_erroneous_sdu;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Minimum QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_transfer_delay, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_minimum_qos_traffic_handling_priority, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Minimum QoS': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UMTS Minimum QoS': ");
            return NULL;
        }
    }

    /* Try to add the 'UMTS Requested QoS' TLV */
    if (input->arg_umts_requested_qos_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'UMTS Requested QoS': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_traffic_class;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_max_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_max_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_guaranteed_uplink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_guaranteed_downlink_bitrate, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_qos_delivery_order;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_maximum_sdu_size, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_sdu_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_residual_bit_error_ratio;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_umts_requested_qos_delivery_erroneous_sdu;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'UMTS Requested QoS': ");
                return NULL;
            }
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_transfer_delay, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }
        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_umts_requested_qos_traffic_handling_priority, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'UMTS Requested QoS': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'UMTS Requested QoS': ");
            return NULL;
        }
    }

    /* Try to add the 'Secondary IPv4 DNS Address' TLV */
    if (input->arg_secondary_ipv4_dns_address_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Secondary IPv4 DNS Address': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_secondary_ipv4_dns_address, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Secondary IPv4 DNS Address': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Secondary IPv4 DNS Address': ");
            return NULL;
        }
    }

    /* Try to add the 'Primary IPv4 DNS Address' TLV */
    if (input->arg_primary_ipv4_dns_address_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Primary IPv4 DNS Address': ");
            return NULL;
        }

        /* Write the guint32 variable to the buffer */
        if (!qmi_message_tlv_write_guint32 (self, QMI_ENDIAN_LITTLE, input->arg_primary_ipv4_dns_address, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Primary IPv4 DNS Address': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Primary IPv4 DNS Address': ");
            return NULL;
        }
    }

    /* Try to add the 'APN Name' TLV */
    if (input->arg_apn_name_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_NAME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'APN Name': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_apn_name, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'APN Name': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'APN Name': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Data Compression Type' TLV */
    if (input->arg_pdp_data_compression_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_DATA_COMPRESSION_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Data Compression Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdp_data_compression_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDP Data Compression Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Data Compression Type': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Header Compression Type' TLV */
    if (input->arg_pdp_header_compression_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_HEADER_COMPRESSION_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Header Compression Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdp_header_compression_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDP Header Compression Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Header Compression Type': ");
            return NULL;
        }
    }

    /* Try to add the 'PDP Type' TLV */
    if (input->arg_pdp_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'PDP Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_pdp_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'PDP Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'PDP Type': ");
            return NULL;
        }
    }

    /* Try to add the 'Profile Name' TLV */
    if (input->arg_profile_name_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PROFILE_NAME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile Name': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_string (self, 0, input->arg_profile_name, -1, error)) {
            g_prefix_error (error, "Cannot write string in TLV 'Profile Name': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile Name': ");
            return NULL;
        }
    }

    /* Try to add the 'Profile Identifier' TLV */
    if (input->arg_profile_identifier_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PROFILE_IDENTIFIER, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile Identifier': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_profile_identifier_profile_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Profile Identifier': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_profile_identifier_profile_index, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Profile Identifier': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile Identifier': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Profile Identifier' in message 'Modify Profile'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsModifyProfileOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Extended Error Code */
    gboolean arg_extended_error_code_set;
    guint16 arg_extended_error_code;
};

#define QMI_MESSAGE_WDS_MODIFY_PROFILE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_MODIFY_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE 0xE0

gboolean
qmi_message_wds_modify_profile_output_get_result (
    QmiMessageWdsModifyProfileOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_modify_profile_output_get_extended_error_code (
    QmiMessageWdsModifyProfileOutput *self,
    QmiWdsDsProfileError *value_extended_error_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_error_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended Error Code' was not found in the message");
        return FALSE;
    }

    if (value_extended_error_code)
        *value_extended_error_code = (QmiWdsDsProfileError)(self->arg_extended_error_code);

    return TRUE;
}

GType
qmi_message_wds_modify_profile_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsModifyProfileOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_modify_profile_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_modify_profile_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsModifyProfileOutput *
qmi_message_wds_modify_profile_output_ref (QmiMessageWdsModifyProfileOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_modify_profile_output_unref (QmiMessageWdsModifyProfileOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsModifyProfileOutput, self);
    }
}

static gchar *
qmi_message_wds_modify_profile_input_apn_type_mask_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_TYPE_MASK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint64 tmp;

        if (!qmi_message_tlv_read_guint64 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_APN_TYPE_MASK_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_apn_type_mask_get_string ((QmiWdsApnTypeMask)tmp));
#elif defined  __QMI_WDS_APN_TYPE_MASK_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_apn_type_mask_build_string_from_mask ((QmiWdsApnTypeMask)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsApnTypeMask
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_roaming_disallowed_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_ROAMING_DISALLOWED_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_apn_disabled_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_DISABLED_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_lte_qos_parameters_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_LTE_QOS_PARAMETERS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " qos_class_identifier = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_QOS_CLASS_IDENTIFIER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_qos_class_identifier_get_string ((QmiWdsQosClassIdentifier)tmp));
#elif defined  __QMI_WDS_QOS_CLASS_IDENTIFIER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_qos_class_identifier_build_string_from_mask ((QmiWdsQosClassIdentifier)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsQosClassIdentifier
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_ipv6_secondary_dns_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint ipv6_secondary_dns_address_preference_i;
        guint16 ipv6_secondary_dns_address_preference_n_items = 8;


        g_string_append (printable, "{");

        for (ipv6_secondary_dns_address_preference_i = 0; ipv6_secondary_dns_address_preference_i < ipv6_secondary_dns_address_preference_n_items; ipv6_secondary_dns_address_preference_i++) {
            g_string_append_printf (printable, " [%u] = '", ipv6_secondary_dns_address_preference_i);

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_BIG, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_ipv6_primary_dns_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint ipv6_primary_dns_address_preference_i;
        guint16 ipv6_primary_dns_address_preference_n_items = 8;


        g_string_append (printable, "{");

        for (ipv6_primary_dns_address_preference_i = 0; ipv6_primary_dns_address_preference_i < ipv6_primary_dns_address_preference_n_items; ipv6_primary_dns_address_preference_i++) {
            g_string_append_printf (printable, " [%u] = '", ipv6_primary_dns_address_preference_i);

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_BIG, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_umts_minimum_qos_with_signaling_indication_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " traffic_class = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TRAFFIC_CLASS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_traffic_class_get_string ((QmiWdsTrafficClass)tmp));
#elif defined  __QMI_WDS_TRAFFIC_CLASS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_traffic_class_build_string_from_mask ((QmiWdsTrafficClass)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTrafficClass
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " qos_delivery_order = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DELIVERY_ORDER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_delivery_order_get_string ((QmiWdsDeliveryOrder)tmp));
#elif defined  __QMI_WDS_DELIVERY_ORDER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_delivery_order_build_string_from_mask ((QmiWdsDeliveryOrder)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDeliveryOrder
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " maximum_sdu_size = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sdu_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_error_ratio_get_string ((QmiWdsSduErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_error_ratio_build_string_from_mask ((QmiWdsSduErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " residual_bit_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_residual_bit_error_ratio_get_string ((QmiWdsSduResidualBitErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_residual_bit_error_ratio_build_string_from_mask ((QmiWdsSduResidualBitErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduResidualBitErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delivery_erroneous_sdu = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_erroneous_delivery_get_string ((QmiWdsSduErroneousDelivery)tmp));
#elif defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_erroneous_delivery_build_string_from_mask ((QmiWdsSduErroneousDelivery)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErroneousDelivery
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " transfer_delay = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " traffic_handling_priority = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " signaling_indication = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_umts_requested_qos_with_signaling_indication_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " traffic_class = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TRAFFIC_CLASS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_traffic_class_get_string ((QmiWdsTrafficClass)tmp));
#elif defined  __QMI_WDS_TRAFFIC_CLASS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_traffic_class_build_string_from_mask ((QmiWdsTrafficClass)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTrafficClass
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " qos_delivery_order = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DELIVERY_ORDER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_delivery_order_get_string ((QmiWdsDeliveryOrder)tmp));
#elif defined  __QMI_WDS_DELIVERY_ORDER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_delivery_order_build_string_from_mask ((QmiWdsDeliveryOrder)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDeliveryOrder
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " maximum_sdu_size = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sdu_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_error_ratio_get_string ((QmiWdsSduErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_error_ratio_build_string_from_mask ((QmiWdsSduErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " residual_bit_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_residual_bit_error_ratio_get_string ((QmiWdsSduResidualBitErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_residual_bit_error_ratio_build_string_from_mask ((QmiWdsSduResidualBitErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduResidualBitErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delivery_erroneous_sdu = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_erroneous_delivery_get_string ((QmiWdsSduErroneousDelivery)tmp));
#elif defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_erroneous_delivery_build_string_from_mask ((QmiWdsSduErroneousDelivery)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErroneousDelivery
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " transfer_delay = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " traffic_handling_priority = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " signaling_indication = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_ipv6_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " address = '");
    {
        guint address_i;
        guint16 address_n_items = 8;


        g_string_append (printable, "{");

        for (address_i = 0; address_i < address_n_items; address_i++) {
            g_string_append_printf (printable, " [%u] = '", address_i);

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_BIG, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_pdp_context_primary_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_PRIMARY_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_pdp_context_secondary_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_pdp_context_number_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_NUMBER, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_imcn_flag_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IMCN_FLAG, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_pcscf_address_using_dhcp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_DHCP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_pcscf_address_using_pco_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_PCO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_ipv4_address_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV4_ADDRESS_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_authentication_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_AUTHENTICATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_AUTHENTICATION_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_authentication_get_string ((QmiWdsAuthentication)tmp));
#elif defined  __QMI_WDS_AUTHENTICATION_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_authentication_build_string_from_mask ((QmiWdsAuthentication)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsAuthentication
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_password_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PASSWORD, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_username_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_USERNAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        if (qmi_utils_get_show_personal_info ()) {
            g_string_append (printable, tmp);
        } else {
            g_string_append_printf (printable, "'###'");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_gprs_minimum_qos_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_GPRS_MINIMUM_QOS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " precedence_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delay_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reliability_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " peak_throughput_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mean_throughput_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_gprs_requested_qos_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_GPRS_REQUESTED_QOS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " precedence_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delay_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reliability_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " peak_throughput_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mean_throughput_class = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_umts_minimum_qos_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " traffic_class = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TRAFFIC_CLASS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_traffic_class_get_string ((QmiWdsTrafficClass)tmp));
#elif defined  __QMI_WDS_TRAFFIC_CLASS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_traffic_class_build_string_from_mask ((QmiWdsTrafficClass)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTrafficClass
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " qos_delivery_order = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DELIVERY_ORDER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_delivery_order_get_string ((QmiWdsDeliveryOrder)tmp));
#elif defined  __QMI_WDS_DELIVERY_ORDER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_delivery_order_build_string_from_mask ((QmiWdsDeliveryOrder)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDeliveryOrder
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " maximum_sdu_size = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sdu_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_error_ratio_get_string ((QmiWdsSduErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_error_ratio_build_string_from_mask ((QmiWdsSduErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " residual_bit_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_residual_bit_error_ratio_get_string ((QmiWdsSduResidualBitErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_residual_bit_error_ratio_build_string_from_mask ((QmiWdsSduResidualBitErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduResidualBitErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delivery_erroneous_sdu = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_erroneous_delivery_get_string ((QmiWdsSduErroneousDelivery)tmp));
#elif defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_erroneous_delivery_build_string_from_mask ((QmiWdsSduErroneousDelivery)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErroneousDelivery
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " transfer_delay = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " traffic_handling_priority = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_umts_requested_qos_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " traffic_class = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_TRAFFIC_CLASS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_traffic_class_get_string ((QmiWdsTrafficClass)tmp));
#elif defined  __QMI_WDS_TRAFFIC_CLASS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_traffic_class_build_string_from_mask ((QmiWdsTrafficClass)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsTrafficClass
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " max_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_uplink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " guaranteed_downlink_bitrate = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " qos_delivery_order = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DELIVERY_ORDER_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_delivery_order_get_string ((QmiWdsDeliveryOrder)tmp));
#elif defined  __QMI_WDS_DELIVERY_ORDER_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_delivery_order_build_string_from_mask ((QmiWdsDeliveryOrder)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDeliveryOrder
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " maximum_sdu_size = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sdu_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_error_ratio_get_string ((QmiWdsSduErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_error_ratio_build_string_from_mask ((QmiWdsSduErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " residual_bit_error_ratio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_residual_bit_error_ratio_get_string ((QmiWdsSduResidualBitErrorRatio)tmp));
#elif defined  __QMI_WDS_SDU_RESIDUAL_BIT_ERROR_RATIO_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_residual_bit_error_ratio_build_string_from_mask ((QmiWdsSduResidualBitErrorRatio)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduResidualBitErrorRatio
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " delivery_erroneous_sdu = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_sdu_erroneous_delivery_get_string ((QmiWdsSduErroneousDelivery)tmp));
#elif defined  __QMI_WDS_SDU_ERRONEOUS_DELIVERY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_sdu_erroneous_delivery_build_string_from_mask ((QmiWdsSduErroneousDelivery)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsSduErroneousDelivery
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " transfer_delay = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " traffic_handling_priority = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_secondary_ipv4_dns_address_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_primary_ipv4_dns_address_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_apn_name_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_NAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_pdp_data_compression_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_DATA_COMPRESSION_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PDP_DATA_COMPRESSION_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_pdp_data_compression_type_get_string ((QmiWdsPdpDataCompressionType)tmp));
#elif defined  __QMI_WDS_PDP_DATA_COMPRESSION_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_pdp_data_compression_type_build_string_from_mask ((QmiWdsPdpDataCompressionType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsPdpDataCompressionType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_pdp_header_compression_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_HEADER_COMPRESSION_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PDP_HEADER_COMPRESSION_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_pdp_header_compression_type_get_string ((QmiWdsPdpHeaderCompressionType)tmp));
#elif defined  __QMI_WDS_PDP_HEADER_COMPRESSION_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_pdp_header_compression_type_build_string_from_mask ((QmiWdsPdpHeaderCompressionType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsPdpHeaderCompressionType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_pdp_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PDP_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_pdp_type_get_string ((QmiWdsPdpType)tmp));
#elif defined  __QMI_WDS_PDP_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_pdp_type_build_string_from_mask ((QmiWdsPdpType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsPdpType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_profile_name_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PROFILE_NAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_input_profile_identifier_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PROFILE_IDENTIFIER, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " profile_type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PROFILE_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_profile_type_get_string ((QmiWdsProfileType)tmp));
#elif defined  __QMI_WDS_PROFILE_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_profile_type_build_string_from_mask ((QmiWdsProfileType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsProfileType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " profile_index = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_modify_profile_output_extended_error_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DS_PROFILE_ERROR_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_ds_profile_error_get_string ((QmiWdsDsProfileError)tmp));
#elif defined  __QMI_WDS_DS_PROFILE_ERROR_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_ds_profile_error_build_string_from_mask ((QmiWdsDsProfileError)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDsProfileError
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_modify_profile_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_modify_profile_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_modify_profile_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_TYPE_MASK:
            tlv_type_str = "APN Type Mask";
            translated_value = qmi_message_wds_modify_profile_input_apn_type_mask_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_ROAMING_DISALLOWED_FLAG:
            tlv_type_str = "Roaming Disallowed Flag";
            translated_value = qmi_message_wds_modify_profile_input_roaming_disallowed_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_DISABLED_FLAG:
            tlv_type_str = "APN Disabled Flag";
            translated_value = qmi_message_wds_modify_profile_input_apn_disabled_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_LTE_QOS_PARAMETERS:
            tlv_type_str = "LTE QoS Parameters";
            translated_value = qmi_message_wds_modify_profile_input_lte_qos_parameters_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv6 Secondary DNS Address Preference";
            translated_value = qmi_message_wds_modify_profile_input_ipv6_secondary_dns_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv6 Primary DNS Address Preference";
            translated_value = qmi_message_wds_modify_profile_input_ipv6_primary_dns_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG:
            tlv_type_str = "UMTS Minimum QoS With Signaling Indication Flag";
            translated_value = qmi_message_wds_modify_profile_input_umts_minimum_qos_with_signaling_indication_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG:
            tlv_type_str = "UMTS Requested QoS With Signaling Indication Flag";
            translated_value = qmi_message_wds_modify_profile_input_umts_requested_qos_with_signaling_indication_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV6_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv6 Address Preference";
            translated_value = qmi_message_wds_modify_profile_input_ipv6_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_PRIMARY_ID:
            tlv_type_str = "PDP Context Primary ID";
            translated_value = qmi_message_wds_modify_profile_input_pdp_context_primary_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG:
            tlv_type_str = "PDP Context Secondary Flag";
            translated_value = qmi_message_wds_modify_profile_input_pdp_context_secondary_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_CONTEXT_NUMBER:
            tlv_type_str = "PDP Context Number";
            translated_value = qmi_message_wds_modify_profile_input_pdp_context_number_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IMCN_FLAG:
            tlv_type_str = "IMCN Flag";
            translated_value = qmi_message_wds_modify_profile_input_imcn_flag_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_DHCP:
            tlv_type_str = "PCSCF Address Using DHCP";
            translated_value = qmi_message_wds_modify_profile_input_pcscf_address_using_dhcp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PCSCF_ADDRESS_USING_PCO:
            tlv_type_str = "PCSCF Address Using PCO";
            translated_value = qmi_message_wds_modify_profile_input_pcscf_address_using_pco_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_IPV4_ADDRESS_PREFERENCE:
            tlv_type_str = "IPv4 Address Preference";
            translated_value = qmi_message_wds_modify_profile_input_ipv4_address_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_AUTHENTICATION:
            tlv_type_str = "Authentication";
            translated_value = qmi_message_wds_modify_profile_input_authentication_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PASSWORD:
            tlv_type_str = "Password";
            translated_value = qmi_message_wds_modify_profile_input_password_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_USERNAME:
            tlv_type_str = "Username";
            translated_value = qmi_message_wds_modify_profile_input_username_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            value_has_personal_info = TRUE;
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_GPRS_MINIMUM_QOS:
            tlv_type_str = "GPRS Minimum QoS";
            translated_value = qmi_message_wds_modify_profile_input_gprs_minimum_qos_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_GPRS_REQUESTED_QOS:
            tlv_type_str = "GPRS Requested QoS";
            translated_value = qmi_message_wds_modify_profile_input_gprs_requested_qos_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_MINIMUM_QOS:
            tlv_type_str = "UMTS Minimum QoS";
            translated_value = qmi_message_wds_modify_profile_input_umts_minimum_qos_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_UMTS_REQUESTED_QOS:
            tlv_type_str = "UMTS Requested QoS";
            translated_value = qmi_message_wds_modify_profile_input_umts_requested_qos_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS:
            tlv_type_str = "Secondary IPv4 DNS Address";
            translated_value = qmi_message_wds_modify_profile_input_secondary_ipv4_dns_address_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS:
            tlv_type_str = "Primary IPv4 DNS Address";
            translated_value = qmi_message_wds_modify_profile_input_primary_ipv4_dns_address_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_APN_NAME:
            tlv_type_str = "APN Name";
            translated_value = qmi_message_wds_modify_profile_input_apn_name_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_DATA_COMPRESSION_TYPE:
            tlv_type_str = "PDP Data Compression Type";
            translated_value = qmi_message_wds_modify_profile_input_pdp_data_compression_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_HEADER_COMPRESSION_TYPE:
            tlv_type_str = "PDP Header Compression Type";
            translated_value = qmi_message_wds_modify_profile_input_pdp_header_compression_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PDP_TYPE:
            tlv_type_str = "PDP Type";
            translated_value = qmi_message_wds_modify_profile_input_pdp_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PROFILE_NAME:
            tlv_type_str = "Profile Name";
            translated_value = qmi_message_wds_modify_profile_input_profile_name_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_INPUT_TLV_PROFILE_IDENTIFIER:
            tlv_type_str = "Profile Identifier";
            translated_value = qmi_message_wds_modify_profile_input_profile_identifier_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_MODIFY_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE:
            tlv_type_str = "Extended Error Code";
            translated_value = qmi_message_wds_modify_profile_output_extended_error_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_modify_profile_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Modify Profile\" (0x0028)\n",
                            line_prefix);

    {
        struct message_modify_profile_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_modify_profile_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsModifyProfileOutput *
__qmi_message_wds_modify_profile_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsModifyProfileOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_MODIFY_PROFILE);

    self = g_slice_new0 (QmiMessageWdsModifyProfileOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_modify_profile_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_modify_profile_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;
        /* Prerequisite.... */
        if (!(self->arg_result_error_code == QMI_PROTOCOL_ERROR_EXTENDED_INTERNAL))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_MODIFY_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE, NULL, NULL)) == 0) {
                goto qmi_message_wds_modify_profile_output_extended_error_code_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_wds_modify_profile_output_extended_error_code_out;
                self->arg_extended_error_code = (QmiWdsDsProfileError)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Extended Error Code' TLV", offset);
            }

            self->arg_extended_error_code_set = TRUE;

qmi_message_wds_modify_profile_output_extended_error_code_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Delete Profile */


/* --- Input -- */

struct _QmiMessageWdsDeleteProfileInput {
    volatile gint ref_count;

    /* Profile Identifier */
    gboolean arg_profile_identifier_set;
    guint8 arg_profile_identifier_profile_type;
    guint8 arg_profile_identifier_profile_index;
};

#define QMI_MESSAGE_WDS_DELETE_PROFILE_INPUT_TLV_PROFILE_IDENTIFIER 0x01

gboolean
qmi_message_wds_delete_profile_input_get_profile_identifier (
    QmiMessageWdsDeleteProfileInput *self,
    QmiWdsProfileType *value_profile_identifier_profile_type,
    guint8 *value_profile_identifier_profile_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_identifier_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Identifier' was not found in the message");
        return FALSE;
    }

    if (value_profile_identifier_profile_type)
        *value_profile_identifier_profile_type = (QmiWdsProfileType)(self->arg_profile_identifier_profile_type);
    if (value_profile_identifier_profile_index)
        *value_profile_identifier_profile_index = self->arg_profile_identifier_profile_index;

    return TRUE;
}

gboolean
qmi_message_wds_delete_profile_input_set_profile_identifier (
    QmiMessageWdsDeleteProfileInput *self,
    QmiWdsProfileType value_profile_identifier_profile_type,
    guint8 value_profile_identifier_profile_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_profile_identifier_profile_type = (guint8)(value_profile_identifier_profile_type);
    self->arg_profile_identifier_profile_index = value_profile_identifier_profile_index;
    self->arg_profile_identifier_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_delete_profile_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsDeleteProfileInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_delete_profile_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_delete_profile_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsDeleteProfileInput *
qmi_message_wds_delete_profile_input_ref (QmiMessageWdsDeleteProfileInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_delete_profile_input_unref (QmiMessageWdsDeleteProfileInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsDeleteProfileInput, self);
    }
}

QmiMessageWdsDeleteProfileInput *
qmi_message_wds_delete_profile_input_new (void)
{
    QmiMessageWdsDeleteProfileInput *self;

    self = g_slice_new0 (QmiMessageWdsDeleteProfileInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_delete_profile_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsDeleteProfileInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_DELETE_PROFILE);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Delete Profile' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Profile Identifier' TLV */
    if (input->arg_profile_identifier_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_DELETE_PROFILE_INPUT_TLV_PROFILE_IDENTIFIER, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile Identifier': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_profile_identifier_profile_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Profile Identifier': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_profile_identifier_profile_index, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Profile Identifier': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile Identifier': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Profile Identifier' in message 'Delete Profile'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsDeleteProfileOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Extended Error Code */
    gboolean arg_extended_error_code_set;
    guint16 arg_extended_error_code;
};

#define QMI_MESSAGE_WDS_DELETE_PROFILE_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_DELETE_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE 0xE0

gboolean
qmi_message_wds_delete_profile_output_get_result (
    QmiMessageWdsDeleteProfileOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_delete_profile_output_get_extended_error_code (
    QmiMessageWdsDeleteProfileOutput *self,
    QmiWdsDsProfileError *value_extended_error_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_error_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended Error Code' was not found in the message");
        return FALSE;
    }

    if (value_extended_error_code)
        *value_extended_error_code = (QmiWdsDsProfileError)(self->arg_extended_error_code);

    return TRUE;
}

GType
qmi_message_wds_delete_profile_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsDeleteProfileOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_delete_profile_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_delete_profile_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsDeleteProfileOutput *
qmi_message_wds_delete_profile_output_ref (QmiMessageWdsDeleteProfileOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_delete_profile_output_unref (QmiMessageWdsDeleteProfileOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsDeleteProfileOutput, self);
    }
}

static gchar *
qmi_message_wds_delete_profile_input_profile_identifier_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_DELETE_PROFILE_INPUT_TLV_PROFILE_IDENTIFIER, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " profile_type = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PROFILE_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_profile_type_get_string ((QmiWdsProfileType)tmp));
#elif defined  __QMI_WDS_PROFILE_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_profile_type_build_string_from_mask ((QmiWdsProfileType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsProfileType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " profile_index = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_delete_profile_output_extended_error_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_DELETE_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DS_PROFILE_ERROR_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_ds_profile_error_get_string ((QmiWdsDsProfileError)tmp));
#elif defined  __QMI_WDS_DS_PROFILE_ERROR_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_ds_profile_error_build_string_from_mask ((QmiWdsDsProfileError)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDsProfileError
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_delete_profile_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_delete_profile_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_delete_profile_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_DELETE_PROFILE_INPUT_TLV_PROFILE_IDENTIFIER:
            tlv_type_str = "Profile Identifier";
            translated_value = qmi_message_wds_delete_profile_input_profile_identifier_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_DELETE_PROFILE_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_DELETE_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE:
            tlv_type_str = "Extended Error Code";
            translated_value = qmi_message_wds_delete_profile_output_extended_error_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_delete_profile_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Delete Profile\" (0x0029)\n",
                            line_prefix);

    {
        struct message_delete_profile_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_delete_profile_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsDeleteProfileOutput *
__qmi_message_wds_delete_profile_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsDeleteProfileOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_DELETE_PROFILE);

    self = g_slice_new0 (QmiMessageWdsDeleteProfileOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_DELETE_PROFILE_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_delete_profile_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_delete_profile_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;
        /* Prerequisite.... */
        if (!(self->arg_result_error_code == QMI_PROTOCOL_ERROR_EXTENDED_INTERNAL))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_DELETE_PROFILE_OUTPUT_TLV_EXTENDED_ERROR_CODE, NULL, NULL)) == 0) {
                goto qmi_message_wds_delete_profile_output_extended_error_code_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_wds_delete_profile_output_extended_error_code_out;
                self->arg_extended_error_code = (QmiWdsDsProfileError)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Extended Error Code' TLV", offset);
            }

            self->arg_extended_error_code_set = TRUE;

qmi_message_wds_delete_profile_output_extended_error_code_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Get Profile List */


/* --- Input -- */

struct _QmiMessageWdsGetProfileListInput {
    volatile gint ref_count;

    /* Profile Type */
    gboolean arg_profile_type_set;
    guint8 arg_profile_type;
};

#define QMI_MESSAGE_WDS_GET_PROFILE_LIST_INPUT_TLV_PROFILE_TYPE 0x10

gboolean
qmi_message_wds_get_profile_list_input_get_profile_type (
    QmiMessageWdsGetProfileListInput *self,
    QmiWdsProfileType *value_profile_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Type' was not found in the message");
        return FALSE;
    }

    if (value_profile_type)
        *value_profile_type = (QmiWdsProfileType)(self->arg_profile_type);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_list_input_set_profile_type (
    QmiMessageWdsGetProfileListInput *self,
    QmiWdsProfileType value_profile_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_profile_type = (guint8)(value_profile_type);
    self->arg_profile_type_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_get_profile_list_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGetProfileListInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_get_profile_list_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_get_profile_list_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGetProfileListInput *
qmi_message_wds_get_profile_list_input_ref (QmiMessageWdsGetProfileListInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_get_profile_list_input_unref (QmiMessageWdsGetProfileListInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsGetProfileListInput, self);
    }
}

QmiMessageWdsGetProfileListInput *
qmi_message_wds_get_profile_list_input_new (void)
{
    QmiMessageWdsGetProfileListInput *self;

    self = g_slice_new0 (QmiMessageWdsGetProfileListInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_get_profile_list_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsGetProfileListInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_GET_PROFILE_LIST);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'Profile Type' TLV */
    if (input->arg_profile_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_GET_PROFILE_LIST_INPUT_TLV_PROFILE_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_profile_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Profile Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile Type': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

static void
__qmi_message_wds_get_profile_list_output_profile_list_profile_clear (QmiMessageWdsGetProfileListOutputProfileListProfile *value)
{
    g_clear_pointer (&value->profile_name, (GDestroyNotify)g_free);
}

static void
__qmi_message_wds_get_profile_list_output_profile_list_profile_free (QmiMessageWdsGetProfileListOutputProfileListProfile *value)
{
    __qmi_message_wds_get_profile_list_output_profile_list_profile_clear (value);
    g_slice_free (QmiMessageWdsGetProfileListOutputProfileListProfile, value);
}

static QmiMessageWdsGetProfileListOutputProfileListProfile *
__qmi_message_wds_get_profile_list_output_profile_list_profile_new (void)
{
    return g_slice_new0 (QmiMessageWdsGetProfileListOutputProfileListProfile);
}

static QmiMessageWdsGetProfileListOutputProfileListProfile *
__qmi_message_wds_get_profile_list_output_profile_list_profile_copy (const QmiMessageWdsGetProfileListOutputProfileListProfile *value)
{
    QmiMessageWdsGetProfileListOutputProfileListProfile *copy;

    copy = __qmi_message_wds_get_profile_list_output_profile_list_profile_new ();
    copy->profile_type = value->profile_type;
    copy->profile_index = value->profile_index;
    copy->profile_name = g_strdup (value->profile_name);
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageWdsGetProfileListOutputProfileListProfile, qmi_message_wds_get_profile_list_output_profile_list_profile, (GBoxedCopyFunc)__qmi_message_wds_get_profile_list_output_profile_list_profile_copy, (GBoxedFreeFunc)__qmi_message_wds_get_profile_list_output_profile_list_profile_free)

struct _QmiMessageWdsGetProfileListOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Profile List */
    gboolean arg_profile_list_set;
    GArray *arg_profile_list;
    GPtrArray *arg_profile_list_ptr;

    /* Extended Error Code */
    gboolean arg_extended_error_code_set;
    guint16 arg_extended_error_code;
};

#define QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_PROFILE_LIST 0x01
#define QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_EXTENDED_ERROR_CODE 0xE0

gboolean
qmi_message_wds_get_profile_list_output_get_result (
    QmiMessageWdsGetProfileListOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_get_profile_list_output_get_profile_list (
    QmiMessageWdsGetProfileListOutput *self,
    GArray **value_profile_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile List' was not found in the message");
        return FALSE;
    }

    if (value_profile_list)
        *value_profile_list = self->arg_profile_list;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_list_output_get_profile_list_gir (
    QmiMessageWdsGetProfileListOutput *self,
    GPtrArray **value_profile_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile List' was not found in the message");
        return FALSE;
    }

    if (value_profile_list_ptr) {
        if (!self->arg_profile_list_ptr) {
            {
                guint profile_list_i;

                self->arg_profile_list_ptr = g_ptr_array_new_full (self->arg_profile_list->len, (GDestroyNotify)__qmi_message_wds_get_profile_list_output_profile_list_profile_free);
                for (profile_list_i = 0; profile_list_i < self->arg_profile_list->len; profile_list_i++) {
                    QmiMessageWdsGetProfileListOutputProfileListProfile *profile_list_aux_from;
                    QmiMessageWdsGetProfileListOutputProfileListProfile *profile_list_aux_to;

                    profile_list_aux_from = &g_array_index (self->arg_profile_list, QmiMessageWdsGetProfileListOutputProfileListProfile, profile_list_i);

                    profile_list_aux_to = __qmi_message_wds_get_profile_list_output_profile_list_profile_new ();
                    profile_list_aux_to->profile_type = (*profile_list_aux_from).profile_type;
                    profile_list_aux_to->profile_index = (*profile_list_aux_from).profile_index;
                    profile_list_aux_to->profile_name = g_strdup ((*profile_list_aux_from).profile_name);

                    g_ptr_array_add (self->arg_profile_list_ptr, profile_list_aux_to);
                }
            }
        }
        *value_profile_list_ptr = self->arg_profile_list_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_wds_get_profile_list_output_get_extended_error_code (
    QmiMessageWdsGetProfileListOutput *self,
    QmiWdsDsProfileError *value_extended_error_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_extended_error_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Extended Error Code' was not found in the message");
        return FALSE;
    }

    if (value_extended_error_code)
        *value_extended_error_code = (QmiWdsDsProfileError)(self->arg_extended_error_code);

    return TRUE;
}

GType
qmi_message_wds_get_profile_list_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGetProfileListOutput"),
                                          (GBoxedCopyFunc) qmi_message_wds_get_profile_list_output_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_get_profile_list_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGetProfileListOutput *
qmi_message_wds_get_profile_list_output_ref (QmiMessageWdsGetProfileListOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_get_profile_list_output_unref (QmiMessageWdsGetProfileListOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_profile_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_profile_list, (GDestroyNotify)g_ptr_array_unref);
        g_slice_free (QmiMessageWdsGetProfileListOutput, self);
    }
}

static gchar *
qmi_message_wds_get_profile_list_input_profile_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PROFILE_LIST_INPUT_TLV_PROFILE_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_PROFILE_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_profile_type_get_string ((QmiWdsProfileType)tmp));
#elif defined  __QMI_WDS_PROFILE_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_profile_type_build_string_from_mask ((QmiWdsProfileType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsProfileType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_profile_list_output_profile_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_PROFILE_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint profile_list_i;
        guint8 profile_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(profile_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (profile_list_i = 0; profile_list_i < profile_list_n_items; profile_list_i++) {
            g_string_append_printf (printable, " [%u] = '", profile_list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " profile_type = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_WDS_PROFILE_TYPE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_wds_profile_type_get_string ((QmiWdsProfileType)tmp));
#elif defined  __QMI_WDS_PROFILE_TYPE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_wds_profile_type_build_string_from_mask ((QmiWdsProfileType)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiWdsProfileType
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " profile_index = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " profile_name = '");

            {
                g_autofree gchar *tmp = NULL;

                if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
                    goto out;
                {
                    g_string_append (printable, tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_wds_get_profile_list_output_extended_error_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_EXTENDED_ERROR_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_WDS_DS_PROFILE_ERROR_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_wds_ds_profile_error_get_string ((QmiWdsDsProfileError)tmp));
#elif defined  __QMI_WDS_DS_PROFILE_ERROR_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_wds_ds_profile_error_build_string_from_mask ((QmiWdsDsProfileError)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiWdsDsProfileError
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_profile_list_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_profile_list_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_profile_list_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_WDS_GET_PROFILE_LIST_INPUT_TLV_PROFILE_TYPE:
            tlv_type_str = "Profile Type";
            translated_value = qmi_message_wds_get_profile_list_input_profile_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_PROFILE_LIST:
            tlv_type_str = "Profile List";
            translated_value = qmi_message_wds_get_profile_list_output_profile_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_EXTENDED_ERROR_CODE:
            tlv_type_str = "Extended Error Code";
            translated_value = qmi_message_wds_get_profile_list_output_extended_error_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_helpers_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_profile_list_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Profile List\" (0x002A)\n",
                            line_prefix);

    {
        struct message_get_profile_list_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_profile_list_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageWdsGetProfileListOutput *
__qmi_message_wds_get_profile_list_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageWdsGetProfileListOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_WDS_GET_PROFILE_LIST);

    self = g_slice_new0 (QmiMessageWdsGetProfileListOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_wds_get_profile_list_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_wds_get_profile_list_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_PROFILE_LIST, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Profile List TLV: ");
                qmi_message_wds_get_profile_list_output_unref (self);
                return NULL;
            }
            {
                guint profile_list_i;
                guint8 profile_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(profile_list_n_items), error))
                    goto qmi_message_wds_get_profile_list_output_profile_list_out;

                self->arg_profile_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageWdsGetProfileListOutputProfileListProfile),
                    (guint)profile_list_n_items);

                g_array_set_clear_func (self->arg_profile_list, (GDestroyNotify)__qmi_message_wds_get_profile_list_output_profile_list_profile_clear);

                for (profile_list_i = 0; profile_list_i < profile_list_n_items; profile_list_i++) {
                    QmiMessageWdsGetProfileListOutputProfileListProfile profile_list_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                            goto qmi_message_wds_get_profile_list_output_profile_list_out;
                        profile_list_aux.profile_type = (QmiWdsProfileType)tmp;
                    }
                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(profile_list_aux.profile_index), error))
                        goto qmi_message_wds_get_profile_list_output_profile_list_out;
                    if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &(profile_list_aux.profile_name), error))
                        goto qmi_message_wds_get_profile_list_output_profile_list_out;
                    g_array_insert_val (self->arg_profile_list, profile_list_i, profile_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Profile List' TLV", offset);
            }

            self->arg_profile_list_set = TRUE;

qmi_message_wds_get_profile_list_output_profile_list_out:
            if (!self->arg_profile_list_set) {
                qmi_message_wds_get_profile_list_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status != QMI_STATUS_SUCCESS))
            break;
        /* Prerequisite.... */
        if (!(self->arg_result_error_code == QMI_PROTOCOL_ERROR_EXTENDED_INTERNAL))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_WDS_GET_PROFILE_LIST_OUTPUT_TLV_EXTENDED_ERROR_CODE, NULL, NULL)) == 0) {
                goto qmi_message_wds_get_profile_list_output_extended_error_code_out;
            }
            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_wds_get_profile_list_output_extended_error_code_out;
                self->arg_extended_error_code = (QmiWdsDsProfileError)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Extended Error Code' TLV", offset);
            }

            self->arg_extended_error_code_set = TRUE;

qmi_message_wds_get_profile_list_output_extended_error_code_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message WDS Get Profile Settings */


/* --- Input -- */

struct _QmiMessageWdsGetProfileSettingsInput {
    volatile gint ref_count;

    /* Profile ID */
    gboolean arg_profile_id_set;
    guint8 arg_profile_id_profile_type;
    guint8 arg_profile_id_profile_index;
};

#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_INPUT_TLV_PROFILE_ID 0x01

gboolean
qmi_message_wds_get_profile_settings_input_get_profile_id (
    QmiMessageWdsGetProfileSettingsInput *self,
    QmiWdsProfileType *value_profile_id_profile_type,
    guint8 *value_profile_id_profile_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile ID' was not found in the message");
        return FALSE;
    }

    if (value_profile_id_profile_type)
        *value_profile_id_profile_type = (QmiWdsProfileType)(self->arg_profile_id_profile_type);
    if (value_profile_id_profile_index)
        *value_profile_id_profile_index = self->arg_profile_id_profile_index;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_input_set_profile_id (
    QmiMessageWdsGetProfileSettingsInput *self,
    QmiWdsProfileType value_profile_id_profile_type,
    guint8 value_profile_id_profile_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_profile_id_profile_type = (guint8)(value_profile_id_profile_type);
    self->arg_profile_id_profile_index = value_profile_id_profile_index;
    self->arg_profile_id_set = TRUE;

    return TRUE;
}

GType
qmi_message_wds_get_profile_settings_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageWdsGetProfileSettingsInput"),
                                          (GBoxedCopyFunc) qmi_message_wds_get_profile_settings_input_ref,
                                          (GBoxedFreeFunc) qmi_message_wds_get_profile_settings_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageWdsGetProfileSettingsInput *
qmi_message_wds_get_profile_settings_input_ref (QmiMessageWdsGetProfileSettingsInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_wds_get_profile_settings_input_unref (QmiMessageWdsGetProfileSettingsInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageWdsGetProfileSettingsInput, self);
    }
}

QmiMessageWdsGetProfileSettingsInput *
qmi_message_wds_get_profile_settings_input_new (void)
{
    QmiMessageWdsGetProfileSettingsInput *self;

    self = g_slice_new0 (QmiMessageWdsGetProfileSettingsInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_wds_get_profile_settings_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageWdsGetProfileSettingsInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_WDS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Get Profile Settings' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Profile ID' TLV */
    if (input->arg_profile_id_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_INPUT_TLV_PROFILE_ID, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Profile ID': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_profile_id_profile_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Profile ID': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_profile_id_profile_index, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Profile ID': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Profile ID': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Profile ID' in message 'Get Profile Settings'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageWdsGetProfileSettingsOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Profile Name */
    gboolean arg_profile_name_set;
    gchar *arg_profile_name;

    /* PDP Type */
    gboolean arg_pdp_type_set;
    guint8 arg_pdp_type;

    /* PDP Header Compression Type */
    gboolean arg_pdp_header_compression_type_set;
    guint8 arg_pdp_header_compression_type;

    /* PDP Data Compression Type */
    gboolean arg_pdp_data_compression_type_set;
    guint8 arg_pdp_data_compression_type;

    /* APN Name */
    gboolean arg_apn_name_set;
    gchar *arg_apn_name;

    /* Primary IPv4 DNS Address */
    gboolean arg_primary_ipv4_dns_address_set;
    guint32 arg_primary_ipv4_dns_address;

    /* Secondary IPv4 DNS Address */
    gboolean arg_secondary_ipv4_dns_address_set;
    guint32 arg_secondary_ipv4_dns_address;

    /* UMTS Requested QoS */
    gboolean arg_umts_requested_qos_set;
    guint8 arg_umts_requested_qos_traffic_class;
    guint32 arg_umts_requested_qos_max_uplink_bitrate;
    guint32 arg_umts_requested_qos_max_downlink_bitrate;
    guint32 arg_umts_requested_qos_guaranteed_uplink_bitrate;
    guint32 arg_umts_requested_qos_guaranteed_downlink_bitrate;
    guint8 arg_umts_requested_qos_qos_delivery_order;
    guint32 arg_umts_requested_qos_maximum_sdu_size;
    guint8 arg_umts_requested_qos_sdu_error_ratio;
    guint8 arg_umts_requested_qos_residual_bit_error_ratio;
    guint8 arg_umts_requested_qos_delivery_erroneous_sdu;
    guint32 arg_umts_requested_qos_transfer_delay;
    guint32 arg_umts_requested_qos_traffic_handling_priority;

    /* UMTS Minimum QoS */
    gboolean arg_umts_minimum_qos_set;
    guint8 arg_umts_minimum_qos_traffic_class;
    guint32 arg_umts_minimum_qos_max_uplink_bitrate;
    guint32 arg_umts_minimum_qos_max_downlink_bitrate;
    guint32 arg_umts_minimum_qos_guaranteed_uplink_bitrate;
    guint32 arg_umts_minimum_qos_guaranteed_downlink_bitrate;
    guint8 arg_umts_minimum_qos_qos_delivery_order;
    guint32 arg_umts_minimum_qos_maximum_sdu_size;
    guint8 arg_umts_minimum_qos_sdu_error_ratio;
    guint8 arg_umts_minimum_qos_residual_bit_error_ratio;
    guint8 arg_umts_minimum_qos_delivery_erroneous_sdu;
    guint32 arg_umts_minimum_qos_transfer_delay;
    guint32 arg_umts_minimum_qos_traffic_handling_priority;

    /* GPRS Requested QoS */
    gboolean arg_gprs_requested_qos_set;
    guint32 arg_gprs_requested_qos_precedence_class;
    guint32 arg_gprs_requested_qos_delay_class;
    guint32 arg_gprs_requested_qos_reliability_class;
    guint32 arg_gprs_requested_qos_peak_throughput_class;
    guint32 arg_gprs_requested_qos_mean_throughput_class;

    /* GPRS Minimum QoS */
    gboolean arg_gprs_minimum_qos_set;
    guint32 arg_gprs_minimum_qos_precedence_class;
    guint32 arg_gprs_minimum_qos_delay_class;
    guint32 arg_gprs_minimum_qos_reliability_class;
    guint32 arg_gprs_minimum_qos_peak_throughput_class;
    guint32 arg_gprs_minimum_qos_mean_throughput_class;

    /* Username */
    gboolean arg_username_set;
    gchar *arg_username;

    /* Password */
    gboolean arg_password_set;
    gchar *arg_password;

    /* Authentication */
    gboolean arg_authentication_set;
    guint8 arg_authentication;

    /* IPv4 Address Preference */
    gboolean arg_ipv4_address_preference_set;
    guint32 arg_ipv4_address_preference;

    /* PCSCF Address Using PCO */
    gboolean arg_pcscf_address_using_pco_set;
    guint8 arg_pcscf_address_using_pco;

    /* PCSCF Address Using DHCP */
    gboolean arg_pcscf_address_using_dhcp_set;
    guint8 arg_pcscf_address_using_dhcp;

    /* IMCN Flag */
    gboolean arg_imcn_flag_set;
    guint8 arg_imcn_flag;

    /* PDP Context Number */
    gboolean arg_pdp_context_number_set;
    guint8 arg_pdp_context_number;

    /* PDP Context Secondary Flag */
    gboolean arg_pdp_context_secondary_flag_set;
    guint8 arg_pdp_context_secondary_flag;

    /* PDP Context Primary ID */
    gboolean arg_pdp_context_primary_id_set;
    guint8 arg_pdp_context_primary_id;

    /* IPv6 Address Preference */
    gboolean arg_ipv6_address_preference_set;
    GArray *arg_ipv6_address_preference_address;

    /* UMTS Requested QoS With Signaling Indication Flag */
    gboolean arg_umts_requested_qos_with_signaling_indication_flag_set;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_traffic_class;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio;
    guint8 arg_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_transfer_delay;
    guint32 arg_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority;
    gint8 arg_umts_requested_qos_with_signaling_indication_flag_signaling_indication;

    /* UMTS Minimum QoS With Signaling Indication Flag */
    gboolean arg_umts_minimum_qos_with_signaling_indication_flag_set;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_traffic_class;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_max_uplink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_max_downlink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_qos_delivery_order;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_maximum_sdu_size;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_sdu_error_ratio;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_residual_bit_error_ratio;
    guint8 arg_umts_minimum_qos_with_signaling_indication_flag_delivery_erroneous_sdu;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_transfer_delay;
    guint32 arg_umts_minimum_qos_with_signaling_indication_flag_traffic_handling_priority;
    gint8 arg_umts_minimum_qos_with_signaling_indication_flag_signaling_indication;

    /* IPv6 Primary DNS Address Preference */
    gboolean arg_ipv6_primary_dns_address_preference_set;
    GArray *arg_ipv6_primary_dns_address_preference;

    /* IPv6 Secondary DNS Address Preference */
    gboolean arg_ipv6_secondary_dns_address_preference_set;
    GArray *arg_ipv6_secondary_dns_address_preference;

    /* LTE QoS Parameters */
    gboolean arg_lte_qos_parameters_set;
    guint8 arg_lte_qos_parameters_qos_class_identifier;
    guint32 arg_lte_qos_parameters_guaranteed_downlink_bitrate;
    guint32 arg_lte_qos_parameters_max_downlink_bitrate;
    guint32 arg_lte_qos_parameters_guaranteed_uplink_bitrate;
    guint32 arg_lte_qos_parameters_max_uplink_bitrate;

    /* APN Disabled Flag */
    gboolean arg_apn_disabled_flag_set;
    guint8 arg_apn_disabled_flag;

    /* Roaming Disallowed Flag */
    gboolean arg_roaming_disallowed_flag_set;
    guint8 arg_roaming_disallowed_flag;

    /* APN Type Mask */
    gboolean arg_apn_type_mask_set;
    guint64 arg_apn_type_mask;

    /* Extended Error Code */
    gboolean arg_extended_error_code_set;
    guint16 arg_extended_error_code;
};

#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PROFILE_NAME 0x10
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PDP_TYPE 0x11
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PDP_HEADER_COMPRESSION_TYPE 0x12
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PDP_DATA_COMPRESSION_TYPE 0x13
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_APN_NAME 0x14
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PRIMARY_IPV4_DNS_ADDRESS 0x15
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_SECONDARY_IPV4_DNS_ADDRESS 0x16
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_UMTS_REQUESTED_QOS 0x17
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_UMTS_MINIMUM_QOS 0x18
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_GPRS_REQUESTED_QOS 0x19
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_GPRS_MINIMUM_QOS 0x1A
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_USERNAME 0x1B
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PASSWORD 0x1C
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_AUTHENTICATION 0x1D
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_IPV4_ADDRESS_PREFERENCE 0x1E
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PCSCF_ADDRESS_USING_PCO 0x1F
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PCSCF_ADDRESS_USING_DHCP 0x21
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_IMCN_FLAG 0x22
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PDP_CONTEXT_NUMBER 0x25
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PDP_CONTEXT_SECONDARY_FLAG 0x26
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_PDP_CONTEXT_PRIMARY_ID 0x27
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_IPV6_ADDRESS_PREFERENCE 0x28
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_UMTS_REQUESTED_QOS_WITH_SIGNALING_INDICATION_FLAG 0x29
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_UMTS_MINIMUM_QOS_WITH_SIGNALING_INDICATION_FLAG 0x2A
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_IPV6_PRIMARY_DNS_ADDRESS_PREFERENCE 0x2B
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_IPV6_SECONDARY_DNS_ADDRESS_PREFERENCE 0x2C
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_LTE_QOS_PARAMETERS 0x2E
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_APN_DISABLED_FLAG 0x2F
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_ROAMING_DISALLOWED_FLAG 0x3E
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_APN_TYPE_MASK 0xDD
#define QMI_MESSAGE_WDS_GET_PROFILE_SETTINGS_OUTPUT_TLV_EXTENDED_ERROR_CODE 0xE0

gboolean
qmi_message_wds_get_profile_settings_output_get_result (
    QmiMessageWdsGetProfileSettingsOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_profile_name (
    QmiMessageWdsGetProfileSettingsOutput *self,
    const gchar **value_profile_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_profile_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Profile Name' was not found in the message");
        return FALSE;
    }

    if (value_profile_name)
        *value_profile_name = self->arg_profile_name;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_pdp_type (
    QmiMessageWdsGetProfileSettingsOutput *self,
    QmiWdsPdpType *value_pdp_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_type)
        *value_pdp_type = (QmiWdsPdpType)(self->arg_pdp_type);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_pdp_header_compression_type (
    QmiMessageWdsGetProfileSettingsOutput *self,
    QmiWdsPdpHeaderCompressionType *value_pdp_header_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_header_compression_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Header Compression Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_header_compression_type)
        *value_pdp_header_compression_type = (QmiWdsPdpHeaderCompressionType)(self->arg_pdp_header_compression_type);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_pdp_data_compression_type (
    QmiMessageWdsGetProfileSettingsOutput *self,
    QmiWdsPdpDataCompressionType *value_pdp_data_compression_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_data_compression_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Data Compression Type' was not found in the message");
        return FALSE;
    }

    if (value_pdp_data_compression_type)
        *value_pdp_data_compression_type = (QmiWdsPdpDataCompressionType)(self->arg_pdp_data_compression_type);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_apn_name (
    QmiMessageWdsGetProfileSettingsOutput *self,
    const gchar **value_apn_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_apn_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'APN Name' was not found in the message");
        return FALSE;
    }

    if (value_apn_name)
        *value_apn_name = self->arg_apn_name;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_primary_ipv4_dns_address (
    QmiMessageWdsGetProfileSettingsOutput *self,
    guint32 *value_primary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_primary_ipv4_dns_address_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Primary IPv4 DNS Address' was not found in the message");
        return FALSE;
    }

    if (value_primary_ipv4_dns_address)
        *value_primary_ipv4_dns_address = self->arg_primary_ipv4_dns_address;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_secondary_ipv4_dns_address (
    QmiMessageWdsGetProfileSettingsOutput *self,
    guint32 *value_secondary_ipv4_dns_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_secondary_ipv4_dns_address_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Secondary IPv4 DNS Address' was not found in the message");
        return FALSE;
    }

    if (value_secondary_ipv4_dns_address)
        *value_secondary_ipv4_dns_address = self->arg_secondary_ipv4_dns_address;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_umts_requested_qos (
    QmiMessageWdsGetProfileSettingsOutput *self,
    QmiWdsTrafficClass *value_umts_requested_qos_traffic_class,
    guint32 *value_umts_requested_qos_max_uplink_bitrate,
    guint32 *value_umts_requested_qos_max_downlink_bitrate,
    guint32 *value_umts_requested_qos_guaranteed_uplink_bitrate,
    guint32 *value_umts_requested_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_requested_qos_qos_delivery_order,
    guint32 *value_umts_requested_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_requested_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_requested_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_requested_qos_delivery_erroneous_sdu,
    guint32 *value_umts_requested_qos_transfer_delay,
    guint32 *value_umts_requested_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_requested_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Requested QoS' was not found in the message");
        return FALSE;
    }

    if (value_umts_requested_qos_traffic_class)
        *value_umts_requested_qos_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_requested_qos_traffic_class);
    if (value_umts_requested_qos_max_uplink_bitrate)
        *value_umts_requested_qos_max_uplink_bitrate = self->arg_umts_requested_qos_max_uplink_bitrate;
    if (value_umts_requested_qos_max_downlink_bitrate)
        *value_umts_requested_qos_max_downlink_bitrate = self->arg_umts_requested_qos_max_downlink_bitrate;
    if (value_umts_requested_qos_guaranteed_uplink_bitrate)
        *value_umts_requested_qos_guaranteed_uplink_bitrate = self->arg_umts_requested_qos_guaranteed_uplink_bitrate;
    if (value_umts_requested_qos_guaranteed_downlink_bitrate)
        *value_umts_requested_qos_guaranteed_downlink_bitrate = self->arg_umts_requested_qos_guaranteed_downlink_bitrate;
    if (value_umts_requested_qos_qos_delivery_order)
        *value_umts_requested_qos_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_requested_qos_qos_delivery_order);
    if (value_umts_requested_qos_maximum_sdu_size)
        *value_umts_requested_qos_maximum_sdu_size = self->arg_umts_requested_qos_maximum_sdu_size;
    if (value_umts_requested_qos_sdu_error_ratio)
        *value_umts_requested_qos_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_requested_qos_sdu_error_ratio);
    if (value_umts_requested_qos_residual_bit_error_ratio)
        *value_umts_requested_qos_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_requested_qos_residual_bit_error_ratio);
    if (value_umts_requested_qos_delivery_erroneous_sdu)
        *value_umts_requested_qos_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_requested_qos_delivery_erroneous_sdu);
    if (value_umts_requested_qos_transfer_delay)
        *value_umts_requested_qos_transfer_delay = self->arg_umts_requested_qos_transfer_delay;
    if (value_umts_requested_qos_traffic_handling_priority)
        *value_umts_requested_qos_traffic_handling_priority = self->arg_umts_requested_qos_traffic_handling_priority;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_umts_minimum_qos (
    QmiMessageWdsGetProfileSettingsOutput *self,
    QmiWdsTrafficClass *value_umts_minimum_qos_traffic_class,
    guint32 *value_umts_minimum_qos_max_uplink_bitrate,
    guint32 *value_umts_minimum_qos_max_downlink_bitrate,
    guint32 *value_umts_minimum_qos_guaranteed_uplink_bitrate,
    guint32 *value_umts_minimum_qos_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_minimum_qos_qos_delivery_order,
    guint32 *value_umts_minimum_qos_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_minimum_qos_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_minimum_qos_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_minimum_qos_delivery_erroneous_sdu,
    guint32 *value_umts_minimum_qos_transfer_delay,
    guint32 *value_umts_minimum_qos_traffic_handling_priority,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_minimum_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Minimum QoS' was not found in the message");
        return FALSE;
    }

    if (value_umts_minimum_qos_traffic_class)
        *value_umts_minimum_qos_traffic_class = (QmiWdsTrafficClass)(self->arg_umts_minimum_qos_traffic_class);
    if (value_umts_minimum_qos_max_uplink_bitrate)
        *value_umts_minimum_qos_max_uplink_bitrate = self->arg_umts_minimum_qos_max_uplink_bitrate;
    if (value_umts_minimum_qos_max_downlink_bitrate)
        *value_umts_minimum_qos_max_downlink_bitrate = self->arg_umts_minimum_qos_max_downlink_bitrate;
    if (value_umts_minimum_qos_guaranteed_uplink_bitrate)
        *value_umts_minimum_qos_guaranteed_uplink_bitrate = self->arg_umts_minimum_qos_guaranteed_uplink_bitrate;
    if (value_umts_minimum_qos_guaranteed_downlink_bitrate)
        *value_umts_minimum_qos_guaranteed_downlink_bitrate = self->arg_umts_minimum_qos_guaranteed_downlink_bitrate;
    if (value_umts_minimum_qos_qos_delivery_order)
        *value_umts_minimum_qos_qos_delivery_order = (QmiWdsDeliveryOrder)(self->arg_umts_minimum_qos_qos_delivery_order);
    if (value_umts_minimum_qos_maximum_sdu_size)
        *value_umts_minimum_qos_maximum_sdu_size = self->arg_umts_minimum_qos_maximum_sdu_size;
    if (value_umts_minimum_qos_sdu_error_ratio)
        *value_umts_minimum_qos_sdu_error_ratio = (QmiWdsSduErrorRatio)(self->arg_umts_minimum_qos_sdu_error_ratio);
    if (value_umts_minimum_qos_residual_bit_error_ratio)
        *value_umts_minimum_qos_residual_bit_error_ratio = (QmiWdsSduResidualBitErrorRatio)(self->arg_umts_minimum_qos_residual_bit_error_ratio);
    if (value_umts_minimum_qos_delivery_erroneous_sdu)
        *value_umts_minimum_qos_delivery_erroneous_sdu = (QmiWdsSduErroneousDelivery)(self->arg_umts_minimum_qos_delivery_erroneous_sdu);
    if (value_umts_minimum_qos_transfer_delay)
        *value_umts_minimum_qos_transfer_delay = self->arg_umts_minimum_qos_transfer_delay;
    if (value_umts_minimum_qos_traffic_handling_priority)
        *value_umts_minimum_qos_traffic_handling_priority = self->arg_umts_minimum_qos_traffic_handling_priority;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_gprs_requested_qos (
    QmiMessageWdsGetProfileSettingsOutput *self,
    guint32 *value_gprs_requested_qos_precedence_class,
    guint32 *value_gprs_requested_qos_delay_class,
    guint32 *value_gprs_requested_qos_reliability_class,
    guint32 *value_gprs_requested_qos_peak_throughput_class,
    guint32 *value_gprs_requested_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gprs_requested_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GPRS Requested QoS' was not found in the message");
        return FALSE;
    }

    if (value_gprs_requested_qos_precedence_class)
        *value_gprs_requested_qos_precedence_class = self->arg_gprs_requested_qos_precedence_class;
    if (value_gprs_requested_qos_delay_class)
        *value_gprs_requested_qos_delay_class = self->arg_gprs_requested_qos_delay_class;
    if (value_gprs_requested_qos_reliability_class)
        *value_gprs_requested_qos_reliability_class = self->arg_gprs_requested_qos_reliability_class;
    if (value_gprs_requested_qos_peak_throughput_class)
        *value_gprs_requested_qos_peak_throughput_class = self->arg_gprs_requested_qos_peak_throughput_class;
    if (value_gprs_requested_qos_mean_throughput_class)
        *value_gprs_requested_qos_mean_throughput_class = self->arg_gprs_requested_qos_mean_throughput_class;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_gprs_minimum_qos (
    QmiMessageWdsGetProfileSettingsOutput *self,
    guint32 *value_gprs_minimum_qos_precedence_class,
    guint32 *value_gprs_minimum_qos_delay_class,
    guint32 *value_gprs_minimum_qos_reliability_class,
    guint32 *value_gprs_minimum_qos_peak_throughput_class,
    guint32 *value_gprs_minimum_qos_mean_throughput_class,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gprs_minimum_qos_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GPRS Minimum QoS' was not found in the message");
        return FALSE;
    }

    if (value_gprs_minimum_qos_precedence_class)
        *value_gprs_minimum_qos_precedence_class = self->arg_gprs_minimum_qos_precedence_class;
    if (value_gprs_minimum_qos_delay_class)
        *value_gprs_minimum_qos_delay_class = self->arg_gprs_minimum_qos_delay_class;
    if (value_gprs_minimum_qos_reliability_class)
        *value_gprs_minimum_qos_reliability_class = self->arg_gprs_minimum_qos_reliability_class;
    if (value_gprs_minimum_qos_peak_throughput_class)
        *value_gprs_minimum_qos_peak_throughput_class = self->arg_gprs_minimum_qos_peak_throughput_class;
    if (value_gprs_minimum_qos_mean_throughput_class)
        *value_gprs_minimum_qos_mean_throughput_class = self->arg_gprs_minimum_qos_mean_throughput_class;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_username (
    QmiMessageWdsGetProfileSettingsOutput *self,
    const gchar **value_username,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_username_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Username' was not found in the message");
        return FALSE;
    }

    if (value_username)
        *value_username = self->arg_username;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_password (
    QmiMessageWdsGetProfileSettingsOutput *self,
    const gchar **value_password,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_password_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Password' was not found in the message");
        return FALSE;
    }

    if (value_password)
        *value_password = self->arg_password;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_authentication (
    QmiMessageWdsGetProfileSettingsOutput *self,
    QmiWdsAuthentication *value_authentication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_authentication_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Authentication' was not found in the message");
        return FALSE;
    }

    if (value_authentication)
        *value_authentication = (QmiWdsAuthentication)(self->arg_authentication);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_ipv4_address_preference (
    QmiMessageWdsGetProfileSettingsOutput *self,
    guint32 *value_ipv4_address_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv4_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv4 Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv4_address_preference)
        *value_ipv4_address_preference = self->arg_ipv4_address_preference;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_pcscf_address_using_pco (
    QmiMessageWdsGetProfileSettingsOutput *self,
    gboolean *value_pcscf_address_using_pco,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pcscf_address_using_pco_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PCSCF Address Using PCO' was not found in the message");
        return FALSE;
    }

    if (value_pcscf_address_using_pco)
        *value_pcscf_address_using_pco = (gboolean)(self->arg_pcscf_address_using_pco);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_pcscf_address_using_dhcp (
    QmiMessageWdsGetProfileSettingsOutput *self,
    gboolean *value_pcscf_address_using_dhcp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pcscf_address_using_dhcp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PCSCF Address Using DHCP' was not found in the message");
        return FALSE;
    }

    if (value_pcscf_address_using_dhcp)
        *value_pcscf_address_using_dhcp = (gboolean)(self->arg_pcscf_address_using_dhcp);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_imcn_flag (
    QmiMessageWdsGetProfileSettingsOutput *self,
    gboolean *value_imcn_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_imcn_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IMCN Flag' was not found in the message");
        return FALSE;
    }

    if (value_imcn_flag)
        *value_imcn_flag = (gboolean)(self->arg_imcn_flag);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_pdp_context_number (
    QmiMessageWdsGetProfileSettingsOutput *self,
    guint8 *value_pdp_context_number,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_number_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Number' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_number)
        *value_pdp_context_number = self->arg_pdp_context_number;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_pdp_context_secondary_flag (
    QmiMessageWdsGetProfileSettingsOutput *self,
    gboolean *value_pdp_context_secondary_flag,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_secondary_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Secondary Flag' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_secondary_flag)
        *value_pdp_context_secondary_flag = (gboolean)(self->arg_pdp_context_secondary_flag);

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_pdp_context_primary_id (
    QmiMessageWdsGetProfileSettingsOutput *self,
    guint8 *value_pdp_context_primary_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_pdp_context_primary_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PDP Context Primary ID' was not found in the message");
        return FALSE;
    }

    if (value_pdp_context_primary_id)
        *value_pdp_context_primary_id = self->arg_pdp_context_primary_id;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_ipv6_address_preference (
    QmiMessageWdsGetProfileSettingsOutput *self,
    GArray **value_ipv6_address_preference_address,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ipv6_address_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IPv6 Address Preference' was not found in the message");
        return FALSE;
    }

    if (value_ipv6_address_preference_address)
        *value_ipv6_address_preference_address = self->arg_ipv6_address_preference_address;

    return TRUE;
}

gboolean
qmi_message_wds_get_profile_settings_output_get_umts_requested_qos_with_signaling_indication_flag (
    QmiMessageWdsGetProfileSettingsOutput *self,
    QmiWdsTrafficClass *value_umts_requested_qos_with_signaling_indication_flag_traffic_class,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_max_uplink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_max_downlink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_uplink_bitrate,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_guaranteed_downlink_bitrate,
    QmiWdsDeliveryOrder *value_umts_requested_qos_with_signaling_indication_flag_qos_delivery_order,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_maximum_sdu_size,
    QmiWdsSduErrorRatio *value_umts_requested_qos_with_signaling_indication_flag_sdu_error_ratio,
    QmiWdsSduResidualBitErrorRatio *value_umts_requested_qos_with_signaling_indication_flag_residual_bit_error_ratio,
    QmiWdsSduErroneousDelivery *value_umts_requested_qos_with_signaling_indication_flag_delivery_erroneous_sdu,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_transfer_delay,
    guint32 *value_umts_requested_qos_with_signaling_indication_flag_traffic_handling_priority,
    gint8 *value_umts_requested_qos_with_signaling_indication_flag_signaling_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_requested_qos_with_signaling_indication_flag_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Requested QoS With Signaling Indication Flag' was not found in the message");
        return FALSE;
    }

    if (value_umts_requested_qos_with_signaling_indication_flag_traffic_cla