/* rygel-search-criteria-parser.c generated by valac 0.56.3, the Vala compiler
 * generated from rygel-search-criteria-parser.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include "rygel-core.h"
#include "rygel-server.h"
#include <gio/gio.h>

#define RYGEL_TYPE_SEARCH_CRITERIA_ERROR (rygel_search_criteria_error_get_type ())
typedef enum  {
	RYGEL_SEARCH_CRITERIA_SYMBOL_EQ = GUPNP_SEARCH_CRITERIA_OP_EQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_LESS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER,
	RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN,
	RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM,
	RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK,
	RYGEL_SEARCH_CRITERIA_SYMBOL_AND,
	RYGEL_SEARCH_CRITERIA_SYMBOL_OR,
	RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE,
	RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE
} RygelSearchCriteriaSymbol;

#define RYGEL_TYPE_SEARCH_CRITERIA_SYMBOL (rygel_search_criteria_symbol_get_type ())

#define RYGEL_TYPE_SEARCH_CRITERIA_TOKEN (rygel_search_criteria_token_get_type ())
typedef struct _RygelSearchCriteriaToken RygelSearchCriteriaToken;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;
enum  {
	RYGEL_SEARCH_CRITERIA_PARSER_0_PROPERTY,
	RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE_PROPERTY,
	RYGEL_SEARCH_CRITERIA_PARSER_NUM_PROPERTIES
};
static GParamSpec* rygel_search_criteria_parser_properties[RYGEL_SEARCH_CRITERIA_PARSER_NUM_PROPERTIES];
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_scanner_destroy0(var) ((var == NULL) ? NULL : (var = (g_scanner_destroy (var), NULL)))
typedef struct _RygelSearchCriteriaParserRunData RygelSearchCriteriaParserRunData;

typedef enum  {
	RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR
} RygelSearchCriteriaError;
#define RYGEL_SEARCH_CRITERIA_ERROR rygel_search_criteria_error_quark ()

struct _RygelSearchCriteriaToken {
	gchar* str_symbol;
	RygelSearchCriteriaSymbol symbol;
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	gchar* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchCriteriaParserPrivate {
	GCancellable* _cancellable;
	GScanner* scanner;
};

struct _RygelSearchCriteriaParserRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSearchCriteriaParser* self;
	const gchar* _tmp0_;
	GScanner* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GScanner* _tmp6_;
	RygelSearchExpression* _tmp7_;
	RygelSearchExpression* _tmp8_;
	RygelSearchExpression* _tmp9_;
	GError* err;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _inner_error0_;
};

static gint RygelSearchCriteriaParser_private_offset;
static gpointer rygel_search_criteria_parser_parent_class = NULL;
static RygelStateMachineIface * rygel_search_criteria_parser_rygel_state_machine_parent_iface = NULL;

VALA_EXTERN GQuark rygel_search_criteria_error_quark (void);
GType rygel_search_criteria_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_search_criteria_symbol_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_search_criteria_token_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelSearchCriteriaToken* rygel_search_criteria_token_dup (const RygelSearchCriteriaToken* self);
VALA_EXTERN void rygel_search_criteria_token_free (RygelSearchCriteriaToken* self);
VALA_EXTERN void rygel_search_criteria_token_copy (const RygelSearchCriteriaToken* self,
                                       RygelSearchCriteriaToken* dest);
VALA_EXTERN void rygel_search_criteria_token_destroy (RygelSearchCriteriaToken* self);
VALA_EXTERN GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str,
                                                             GError** error);
VALA_EXTERN RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type,
                                                                   const gchar* str,
                                                                   GError** error);
static void rygel_search_criteria_parser_real_run_data_free (gpointer _data);
static void rygel_search_criteria_parser_real_run (RygelStateMachine* base,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* _data_);
static RygelSearchExpression* rygel_search_criteria_parser_parse_or_expression (RygelSearchCriteriaParser* self,
                                                                         GError** error);
static RygelSearchExpression* rygel_search_criteria_parser_parse_and_expression (RygelSearchCriteriaParser* self,
                                                                          GError** error);
static RygelSearchExpression* rygel_search_criteria_parser_parse_rel_expression (RygelSearchCriteriaParser* self,
                                                                          GError** error);
static RygelSearchCriteriaSymbol rygel_search_criteria_parser_get_token (RygelSearchCriteriaParser* self);
static gchar* rygel_search_criteria_parser_get_context (RygelSearchCriteriaParser* self);
static void rygel_search_criteria_parser_finalize (GObject * obj);
static GType rygel_search_criteria_parser_get_type_once (void);
static void _vala_rygel_search_criteria_parser_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_rygel_search_criteria_parser_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const RygelSearchCriteriaToken RYGEL_SEARCH_CRITERIA_PARSER_TOKENS[15] = {{"=", RYGEL_SEARCH_CRITERIA_SYMBOL_EQ}, {"!=", RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ}, {"<", RYGEL_SEARCH_CRITERIA_SYMBOL_LESS}, {"<=", RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ}, {">", RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER}, {">=", RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ}, {"contains", RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS}, {"doesNotContain", RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN}, {"derivedfrom", RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM}, {"exists", RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS}, {"*", RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK}, {"and", RYGEL_SEARCH_CRITERIA_SYMBOL_AND}, {"or", RYGEL_SEARCH_CRITERIA_SYMBOL_OR}, {"true", RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE}, {"false", RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE}};

GQuark
rygel_search_criteria_error_quark (void)
{
	return g_quark_from_static_string ("rygel-search-criteria-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_search_criteria_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, "RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR", "syntax-error"}, {0, NULL, NULL}};
	GType rygel_search_criteria_error_type_id;
	rygel_search_criteria_error_type_id = g_enum_register_static ("RygelSearchCriteriaError", values);
	return rygel_search_criteria_error_type_id;
}

GType
rygel_search_criteria_error_get_type (void)
{
	static volatile gsize rygel_search_criteria_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_search_criteria_error_type_id__once)) {
		GType rygel_search_criteria_error_type_id;
		rygel_search_criteria_error_type_id = rygel_search_criteria_error_get_type_once ();
		g_once_init_leave (&rygel_search_criteria_error_type_id__once, rygel_search_criteria_error_type_id);
	}
	return rygel_search_criteria_error_type_id__once;
}

 G_GNUC_NO_INLINE static GType
rygel_search_criteria_symbol_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_SEARCH_CRITERIA_SYMBOL_EQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_EQ", "eq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ", "neq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_LESS, "RYGEL_SEARCH_CRITERIA_SYMBOL_LESS", "less"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ", "leq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER, "RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER", "greater"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ", "geq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS, "RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS", "contains"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN, "RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN", "does-not-contain"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM, "RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM", "derived-from"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS, "RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS", "exists"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK, "RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK", "asterisk"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_AND, "RYGEL_SEARCH_CRITERIA_SYMBOL_AND", "and"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_OR, "RYGEL_SEARCH_CRITERIA_SYMBOL_OR", "or"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE, "RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE", "true"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE, "RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE", "false"}, {0, NULL, NULL}};
	GType rygel_search_criteria_symbol_type_id;
	rygel_search_criteria_symbol_type_id = g_enum_register_static ("RygelSearchCriteriaSymbol", values);
	return rygel_search_criteria_symbol_type_id;
}

GType
rygel_search_criteria_symbol_get_type (void)
{
	static volatile gsize rygel_search_criteria_symbol_type_id__once = 0;
	if (g_once_init_enter (&rygel_search_criteria_symbol_type_id__once)) {
		GType rygel_search_criteria_symbol_type_id;
		rygel_search_criteria_symbol_type_id = rygel_search_criteria_symbol_get_type_once ();
		g_once_init_leave (&rygel_search_criteria_symbol_type_id__once, rygel_search_criteria_symbol_type_id);
	}
	return rygel_search_criteria_symbol_type_id__once;
}

void
rygel_search_criteria_token_copy (const RygelSearchCriteriaToken* self,
                                  RygelSearchCriteriaToken* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).str_symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).str_symbol);
	(*dest).str_symbol = _tmp1_;
	(*dest).symbol = (*self).symbol;
}

void
rygel_search_criteria_token_destroy (RygelSearchCriteriaToken* self)
{
	_g_free0 ((*self).str_symbol);
}

RygelSearchCriteriaToken*
rygel_search_criteria_token_dup (const RygelSearchCriteriaToken* self)
{
	RygelSearchCriteriaToken* dup;
	dup = g_new0 (RygelSearchCriteriaToken, 1);
	rygel_search_criteria_token_copy (self, dup);
	return dup;
}

void
rygel_search_criteria_token_free (RygelSearchCriteriaToken* self)
{
	rygel_search_criteria_token_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
rygel_search_criteria_token_get_type_once (void)
{
	GType rygel_search_criteria_token_type_id;
	rygel_search_criteria_token_type_id = g_boxed_type_register_static ("RygelSearchCriteriaToken", (GBoxedCopyFunc) rygel_search_criteria_token_dup, (GBoxedFreeFunc) rygel_search_criteria_token_free);
	return rygel_search_criteria_token_type_id;
}

GType
rygel_search_criteria_token_get_type (void)
{
	static volatile gsize rygel_search_criteria_token_type_id__once = 0;
	if (g_once_init_enter (&rygel_search_criteria_token_type_id__once)) {
		GType rygel_search_criteria_token_type_id;
		rygel_search_criteria_token_type_id = rygel_search_criteria_token_get_type_once ();
		g_once_init_leave (&rygel_search_criteria_token_type_id__once, rygel_search_criteria_token_type_id);
	}
	return rygel_search_criteria_token_type_id__once;
}

static inline gpointer
rygel_search_criteria_parser_get_instance_private (RygelSearchCriteriaParser* self)
{
	return G_STRUCT_MEMBER_P (self, RygelSearchCriteriaParser_private_offset);
}

RygelSearchCriteriaParser*
rygel_search_criteria_parser_construct (GType object_type,
                                        const gchar* str,
                                        GError** error)
{
	RygelSearchCriteriaParser * self = NULL;
	gchar* _tmp0_;
	GScanner* _tmp1_;
	GScanner* _tmp2_;
	GScannerConfig* _tmp3_;
	GScanner* _tmp4_;
	GScannerConfig* _tmp5_;
	GScanner* _tmp6_;
	GScannerConfig* _tmp7_;
	GScanner* _tmp8_;
	GScannerConfig* _tmp9_;
	GScanner* _tmp10_;
	GScannerConfig* _tmp11_;
	g_return_val_if_fail (str != NULL, NULL);
	self = (RygelSearchCriteriaParser*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (str);
	_g_free0 (self->str);
	self->str = _tmp0_;
	_tmp1_ = g_scanner_new (NULL);
	_g_scanner_destroy0 (self->priv->scanner);
	self->priv->scanner = _tmp1_;
	_tmp2_ = self->priv->scanner;
	_tmp3_ = _tmp2_->config;
	(*_tmp3_).cset_skip_characters = " \t\n\r\012" "\013\014\015";
	_tmp4_ = self->priv->scanner;
	_tmp5_ = _tmp4_->config;
	(*_tmp5_).scan_identifier_1char = TRUE;
	_tmp6_ = self->priv->scanner;
	_tmp7_ = _tmp6_->config;
	(*_tmp7_).cset_identifier_first = G_CSET_a_2_z "_*<>=!@" G_CSET_A_2_Z;
	_tmp8_ = self->priv->scanner;
	_tmp9_ = _tmp8_->config;
	(*_tmp9_).cset_identifier_nth = G_CSET_a_2_z "_" G_CSET_DIGITS "=:@" G_CSET_A_2_Z G_CSET_LATINS G_CSET_LATINC;
	_tmp10_ = self->priv->scanner;
	_tmp11_ = _tmp10_->config;
	(*_tmp11_).symbol_2_token = TRUE;
	{
		RygelSearchCriteriaToken* token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = RYGEL_SEARCH_CRITERIA_PARSER_TOKENS;
		token_collection_length1 = G_N_ELEMENTS (RYGEL_SEARCH_CRITERIA_PARSER_TOKENS);
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			RygelSearchCriteriaToken token = {0};
			token = token_collection[token_it];
			{
				GScanner* _tmp12_;
				RygelSearchCriteriaToken _tmp13_;
				const gchar* _tmp14_;
				RygelSearchCriteriaToken _tmp15_;
				void* _tmp16_;
				_tmp12_ = self->priv->scanner;
				_tmp13_ = token;
				_tmp14_ = _tmp13_.str_symbol;
				_tmp15_ = token;
				_tmp16_ = GINT_TO_POINTER ((gint) _tmp15_.symbol);
				g_scanner_scope_add_symbol (_tmp12_, (guint) 0, _tmp14_, _tmp16_);
			}
		}
	}
	return self;
}

RygelSearchCriteriaParser*
rygel_search_criteria_parser_new (const gchar* str,
                                  GError** error)
{
	return rygel_search_criteria_parser_construct (RYGEL_TYPE_SEARCH_CRITERIA_PARSER, str, error);
}

static void
rygel_search_criteria_parser_real_run_data_free (gpointer _data)
{
	RygelSearchCriteriaParserRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchCriteriaParserRunData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_search_criteria_parser_real_run (RygelStateMachine* base,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	RygelSearchCriteriaParser * self;
	RygelSearchCriteriaParserRunData* _data_;
	RygelSearchCriteriaParser* _tmp0_;
	self = (RygelSearchCriteriaParser*) base;
	_data_ = g_slice_new0 (RygelSearchCriteriaParserRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_search_criteria_parser_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_search_criteria_parser_real_run_co (_data_);
}

static void
rygel_search_criteria_parser_run_finish (RygelStateMachine* base,
                                         GAsyncResult* _res_)
{
	RygelSearchCriteriaParserRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->str;
	if (g_strcmp0 (_data_->_tmp0_, "*") == 0) {
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->scanner;
	_data_->_tmp2_ = _data_->self->str;
	_data_->_tmp3_ = _data_->self->str;
	_data_->_tmp4_ = strlen (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	g_scanner_input_text (_data_->_tmp1_, _data_->_tmp2_, (guint) _data_->_tmp5_);
	_data_->_tmp6_ = _data_->self->priv->scanner;
	g_scanner_get_next_token (_data_->_tmp6_);
	{
		_data_->_tmp8_ = rygel_search_criteria_parser_parse_or_expression (_data_->self, &_data_->_inner_error0_);
		_data_->_tmp7_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_rygel_search_expression_unref0 (_data_->self->expression);
		_data_->self->expression = _data_->_tmp9_;
		_rygel_search_expression_unref0 (_data_->_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->err;
		_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
		_g_error_free0 (_data_->self->err);
		_data_->self->err = _data_->_tmp11_;
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static RygelSearchExpression*
rygel_search_criteria_parser_parse_and_expression (RygelSearchCriteriaParser* self,
                                                   GError** error)
{
	RygelSearchExpression* exp = NULL;
	RygelSearchExpression* _tmp0_;
	GError* _inner_error0_ = NULL;
	RygelSearchExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_search_criteria_parser_parse_rel_expression (self, &_inner_error0_);
	exp = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	while (TRUE) {
		RygelSearchCriteriaSymbol _tmp1_;
		RygelSearchCriteriaSymbol _tmp2_;
		GScanner* _tmp3_;
		RygelLogicalExpression* exp2 = NULL;
		RygelLogicalExpression* _tmp4_;
		RygelLogicalExpression* _tmp5_;
		RygelSearchExpression* _tmp6_;
		RygelSearchExpression* _tmp7_;
		RygelLogicalExpression* _tmp8_;
		RygelSearchExpression* _tmp9_ = NULL;
		RygelSearchExpression* _tmp10_;
		RygelLogicalExpression* _tmp11_;
		RygelSearchExpression* _tmp12_;
		RygelLogicalExpression* _tmp13_;
		RygelSearchExpression* _tmp14_;
		_tmp1_ = rygel_search_criteria_parser_get_token (self);
		_tmp2_ = _tmp1_;
		if (!(_tmp2_ == RYGEL_SEARCH_CRITERIA_SYMBOL_AND)) {
			break;
		}
		_tmp3_ = self->priv->scanner;
		g_scanner_get_next_token (_tmp3_);
		_tmp4_ = rygel_logical_expression_new ();
		exp2 = _tmp4_;
		_tmp5_ = exp2;
		_tmp6_ = exp;
		_tmp7_ = _rygel_search_expression_ref0 (_tmp6_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp5_)->operand1);
		((RygelSearchExpression*) _tmp5_)->operand1 = _tmp7_;
		_tmp8_ = exp2;
		((RygelSearchExpression*) _tmp8_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
		_tmp10_ = rygel_search_criteria_parser_parse_rel_expression (self, &_inner_error0_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_rygel_search_expression_unref0 (exp2);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
		_tmp11_ = exp2;
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp11_)->operand2);
		((RygelSearchExpression*) _tmp11_)->operand2 = _tmp12_;
		_tmp13_ = exp2;
		_tmp14_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp13_);
		_rygel_search_expression_unref0 (exp);
		exp = _tmp14_;
		_rygel_search_expression_unref0 (_tmp9_);
		_rygel_search_expression_unref0 (exp2);
	}
	result = exp;
	return result;
}

static RygelSearchExpression*
rygel_search_criteria_parser_parse_rel_expression (RygelSearchCriteriaParser* self,
                                                   GError** error)
{
	RygelRelationalExpression* exp = NULL;
	RygelRelationalExpression* _tmp0_;
	GScanner* _tmp1_;
	GError* _inner_error0_ = NULL;
	RygelSearchExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_relational_expression_new ();
	exp = _tmp0_;
	_tmp1_ = self->priv->scanner;
	if (_tmp1_->token == G_TOKEN_IDENTIFIER) {
		RygelRelationalExpression* _tmp2_;
		GScanner* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		GScanner* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		RygelSearchCriteriaSymbol _tmp15_;
		RygelSearchCriteriaSymbol _tmp16_;
		_tmp2_ = exp;
		_tmp3_ = self->priv->scanner;
		_tmp4_ = _tmp3_->value.v_identifier;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (((RygelSearchExpression*) _tmp2_)->operand1);
		((RygelSearchExpression*) _tmp2_)->operand1 = _tmp5_;
		_tmp6_ = self->priv->scanner;
		g_scanner_get_next_token (_tmp6_);
		_tmp15_ = rygel_search_criteria_parser_get_token (self);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == RYGEL_SEARCH_CRITERIA_SYMBOL_EQ) {
			_tmp14_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp17_;
			RygelSearchCriteriaSymbol _tmp18_;
			_tmp17_ = rygel_search_criteria_parser_get_token (self);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp19_;
			RygelSearchCriteriaSymbol _tmp20_;
			_tmp19_ = rygel_search_criteria_parser_get_token (self);
			_tmp20_ = _tmp19_;
			_tmp13_ = _tmp20_ == RYGEL_SEARCH_CRITERIA_SYMBOL_LESS;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp21_;
			RygelSearchCriteriaSymbol _tmp22_;
			_tmp21_ = rygel_search_criteria_parser_get_token (self);
			_tmp22_ = _tmp21_;
			_tmp12_ = _tmp22_ == RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp23_;
			RygelSearchCriteriaSymbol _tmp24_;
			_tmp23_ = rygel_search_criteria_parser_get_token (self);
			_tmp24_ = _tmp23_;
			_tmp11_ = _tmp24_ == RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp25_;
			RygelSearchCriteriaSymbol _tmp26_;
			_tmp25_ = rygel_search_criteria_parser_get_token (self);
			_tmp26_ = _tmp25_;
			_tmp10_ = _tmp26_ == RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp27_;
			RygelSearchCriteriaSymbol _tmp28_;
			_tmp27_ = rygel_search_criteria_parser_get_token (self);
			_tmp28_ = _tmp27_;
			_tmp9_ = _tmp28_ == RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp29_;
			RygelSearchCriteriaSymbol _tmp30_;
			_tmp29_ = rygel_search_criteria_parser_get_token (self);
			_tmp30_ = _tmp29_;
			_tmp8_ = _tmp30_ == RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp31_;
			RygelSearchCriteriaSymbol _tmp32_;
			_tmp31_ = rygel_search_criteria_parser_get_token (self);
			_tmp32_ = _tmp31_;
			_tmp7_ = _tmp32_ == RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM;
		}
		if (_tmp7_) {
			RygelRelationalExpression* _tmp33_;
			GScanner* _tmp34_;
			GScanner* _tmp35_;
			GScanner* _tmp36_;
			_tmp33_ = exp;
			_tmp34_ = self->priv->scanner;
			((RygelSearchExpression*) _tmp33_)->op = (gpointer) ((gintptr) _tmp34_->token);
			_tmp35_ = self->priv->scanner;
			g_scanner_get_next_token (_tmp35_);
			_tmp36_ = self->priv->scanner;
			if (_tmp36_->token == G_TOKEN_STRING) {
				RygelRelationalExpression* _tmp37_;
				GScanner* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				GScanner* _tmp41_;
				_tmp37_ = exp;
				_tmp38_ = self->priv->scanner;
				_tmp39_ = _tmp38_->value.v_string;
				_tmp40_ = g_strdup (_tmp39_);
				_g_free0 (((RygelSearchExpression*) _tmp37_)->operand2);
				((RygelSearchExpression*) _tmp37_)->operand2 = _tmp40_;
				_tmp41_ = self->priv->scanner;
				g_scanner_get_next_token (_tmp41_);
				result = (RygelSearchExpression*) exp;
				return result;
			} else {
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				GError* _tmp49_;
				GError* _tmp50_;
				_tmp42_ = rygel_search_criteria_parser_get_context (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strconcat (_tmp44_, ": expected ", NULL);
				_tmp46_ = _tmp45_;
				_tmp47_ = g_strconcat (_tmp46_, "\"STRING\"", NULL);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp48_);
				_tmp50_ = _tmp49_;
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp44_);
				_inner_error0_ = _tmp50_;
				g_propagate_error (error, _inner_error0_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
		} else {
			RygelSearchCriteriaSymbol _tmp51_;
			RygelSearchCriteriaSymbol _tmp52_;
			_tmp51_ = rygel_search_criteria_parser_get_token (self);
			_tmp52_ = _tmp51_;
			if (_tmp52_ == RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS) {
				RygelRelationalExpression* _tmp53_;
				GScanner* _tmp54_;
				GScanner* _tmp55_;
				RygelSearchCriteriaSymbol _tmp56_;
				RygelSearchCriteriaSymbol _tmp57_;
				_tmp53_ = exp;
				_tmp54_ = self->priv->scanner;
				((RygelSearchExpression*) _tmp53_)->op = (gpointer) ((gintptr) _tmp54_->token);
				_tmp55_ = self->priv->scanner;
				g_scanner_get_next_token (_tmp55_);
				_tmp56_ = rygel_search_criteria_parser_get_token (self);
				_tmp57_ = _tmp56_;
				if (_tmp57_ == RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE) {
					RygelRelationalExpression* _tmp58_;
					gchar* _tmp59_;
					GScanner* _tmp60_;
					_tmp58_ = exp;
					_tmp59_ = g_strdup ("true");
					_g_free0 (((RygelSearchExpression*) _tmp58_)->operand2);
					((RygelSearchExpression*) _tmp58_)->operand2 = _tmp59_;
					_tmp60_ = self->priv->scanner;
					g_scanner_get_next_token (_tmp60_);
					result = (RygelSearchExpression*) exp;
					return result;
				} else {
					RygelSearchCriteriaSymbol _tmp61_;
					RygelSearchCriteriaSymbol _tmp62_;
					_tmp61_ = rygel_search_criteria_parser_get_token (self);
					_tmp62_ = _tmp61_;
					if (_tmp62_ == RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE) {
						RygelRelationalExpression* _tmp63_;
						gchar* _tmp64_;
						GScanner* _tmp65_;
						_tmp63_ = exp;
						_tmp64_ = g_strdup ("false");
						_g_free0 (((RygelSearchExpression*) _tmp63_)->operand2);
						((RygelSearchExpression*) _tmp63_)->operand2 = _tmp64_;
						_tmp65_ = self->priv->scanner;
						g_scanner_get_next_token (_tmp65_);
						result = (RygelSearchExpression*) exp;
						return result;
					} else {
						gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						gchar* _tmp74_;
						GError* _tmp75_;
						GError* _tmp76_;
						_tmp66_ = rygel_search_criteria_parser_get_context (self);
						_tmp67_ = _tmp66_;
						_tmp68_ = _tmp67_;
						_tmp69_ = g_strconcat (_tmp68_, ": expected ", NULL);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strconcat (_tmp70_, "\"true\"|\"", NULL);
						_tmp72_ = _tmp71_;
						_tmp73_ = g_strconcat (_tmp72_, "false\"", NULL);
						_tmp74_ = _tmp73_;
						_tmp75_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp74_);
						_tmp76_ = _tmp75_;
						_g_free0 (_tmp74_);
						_g_free0 (_tmp72_);
						_g_free0 (_tmp70_);
						_g_free0 (_tmp68_);
						_inner_error0_ = _tmp76_;
						g_propagate_error (error, _inner_error0_);
						_rygel_search_expression_unref0 (exp);
						return NULL;
					}
				}
			} else {
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				GError* _tmp84_;
				GError* _tmp85_;
				_tmp77_ = rygel_search_criteria_parser_get_context (self);
				_tmp78_ = _tmp77_;
				_tmp79_ = _tmp78_;
				_tmp80_ = g_strconcat (_tmp79_, ": expected ", NULL);
				_tmp81_ = _tmp80_;
				_tmp82_ = g_strconcat (_tmp81_, "operator", NULL);
				_tmp83_ = _tmp82_;
				_tmp84_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp83_);
				_tmp85_ = _tmp84_;
				_g_free0 (_tmp83_);
				_g_free0 (_tmp81_);
				_g_free0 (_tmp79_);
				_inner_error0_ = _tmp85_;
				g_propagate_error (error, _inner_error0_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
		}
	} else {
		GScanner* _tmp86_;
		_tmp86_ = self->priv->scanner;
		if (_tmp86_->token == G_TOKEN_LEFT_PAREN) {
			GScanner* _tmp87_;
			RygelSearchExpression* exp2 = NULL;
			RygelSearchExpression* _tmp88_;
			GScanner* _tmp89_;
			_tmp87_ = self->priv->scanner;
			g_scanner_get_next_token (_tmp87_);
			_tmp88_ = rygel_search_criteria_parser_parse_or_expression (self, &_inner_error0_);
			exp2 = _tmp88_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
			_tmp89_ = self->priv->scanner;
			if (_tmp89_->token != G_TOKEN_RIGHT_PAREN) {
				gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				GError* _tmp95_;
				GError* _tmp96_;
				_tmp90_ = rygel_search_criteria_parser_get_context (self);
				_tmp91_ = _tmp90_;
				_tmp92_ = _tmp91_;
				_tmp93_ = g_strconcat (_tmp92_, ": expected ')'", NULL);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp94_);
				_tmp96_ = _tmp95_;
				_g_free0 (_tmp94_);
				_g_free0 (_tmp92_);
				_inner_error0_ = _tmp96_;
				g_propagate_error (error, _inner_error0_);
				_rygel_search_expression_unref0 (exp2);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			} else {
				GScanner* _tmp97_;
				_tmp97_ = self->priv->scanner;
				g_scanner_get_next_token (_tmp97_);
				result = exp2;
				_rygel_search_expression_unref0 (exp);
				return result;
			}
			_rygel_search_expression_unref0 (exp2);
		} else {
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			GError* _tmp105_;
			GError* _tmp106_;
			_tmp98_ = rygel_search_criteria_parser_get_context (self);
			_tmp99_ = _tmp98_;
			_tmp100_ = _tmp99_;
			_tmp101_ = g_strconcat (_tmp100_, ": expected ", NULL);
			_tmp102_ = _tmp101_;
			_tmp103_ = g_strconcat (_tmp102_, "identifier or '('", NULL);
			_tmp104_ = _tmp103_;
			_tmp105_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp104_);
			_tmp106_ = _tmp105_;
			_g_free0 (_tmp104_);
			_g_free0 (_tmp102_);
			_g_free0 (_tmp100_);
			_inner_error0_ = _tmp106_;
			g_propagate_error (error, _inner_error0_);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
	}
}

static RygelSearchExpression*
rygel_search_criteria_parser_parse_or_expression (RygelSearchCriteriaParser* self,
                                                  GError** error)
{
	RygelSearchExpression* exp = NULL;
	RygelSearchExpression* _tmp0_;
	GError* _inner_error0_ = NULL;
	RygelSearchExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_search_criteria_parser_parse_and_expression (self, &_inner_error0_);
	exp = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	while (TRUE) {
		RygelSearchCriteriaSymbol _tmp1_;
		RygelSearchCriteriaSymbol _tmp2_;
		GScanner* _tmp3_;
		RygelLogicalExpression* exp2 = NULL;
		RygelLogicalExpression* _tmp4_;
		RygelLogicalExpression* _tmp5_;
		RygelSearchExpression* _tmp6_;
		RygelSearchExpression* _tmp7_;
		RygelLogicalExpression* _tmp8_;
		RygelSearchExpression* _tmp9_ = NULL;
		RygelSearchExpression* _tmp10_;
		RygelLogicalExpression* _tmp11_;
		RygelSearchExpression* _tmp12_;
		RygelLogicalExpression* _tmp13_;
		RygelSearchExpression* _tmp14_;
		_tmp1_ = rygel_search_criteria_parser_get_token (self);
		_tmp2_ = _tmp1_;
		if (!(_tmp2_ == RYGEL_SEARCH_CRITERIA_SYMBOL_OR)) {
			break;
		}
		_tmp3_ = self->priv->scanner;
		g_scanner_get_next_token (_tmp3_);
		_tmp4_ = rygel_logical_expression_new ();
		exp2 = _tmp4_;
		_tmp5_ = exp2;
		_tmp6_ = exp;
		_tmp7_ = _rygel_search_expression_ref0 (_tmp6_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp5_)->operand1);
		((RygelSearchExpression*) _tmp5_)->operand1 = _tmp7_;
		_tmp8_ = exp2;
		((RygelSearchExpression*) _tmp8_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_OR);
		_tmp10_ = rygel_search_criteria_parser_parse_and_expression (self, &_inner_error0_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_rygel_search_expression_unref0 (exp2);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
		_tmp11_ = exp2;
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp11_)->operand2);
		((RygelSearchExpression*) _tmp11_)->operand2 = _tmp12_;
		_tmp13_ = exp2;
		_tmp14_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp13_);
		_rygel_search_expression_unref0 (exp);
		exp = _tmp14_;
		_rygel_search_expression_unref0 (_tmp9_);
		_rygel_search_expression_unref0 (exp2);
	}
	result = exp;
	return result;
}

static GCancellable*
rygel_search_criteria_parser_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelSearchCriteriaParser* self;
	GCancellable* _tmp0_;
	self = (RygelSearchCriteriaParser*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_search_criteria_parser_real_set_cancellable (RygelStateMachine* base,
                                                   GCancellable* value)
{
	RygelSearchCriteriaParser* self;
	GCancellable* old_value;
	self = (RygelSearchCriteriaParser*) base;
	old_value = rygel_search_criteria_parser_real_get_cancellable (base);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_search_criteria_parser_properties[RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE_PROPERTY]);
	}
}

static RygelSearchCriteriaSymbol
rygel_search_criteria_parser_get_token (RygelSearchCriteriaParser* self)
{
	RygelSearchCriteriaSymbol result;
	GScanner* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->scanner;
	result = (RygelSearchCriteriaSymbol) _tmp0_->token;
	return result;
}

static gchar*
rygel_search_criteria_parser_get_context (RygelSearchCriteriaParser* self)
{
	gchar* result;
	GScanner* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GScanner* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_->line);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ".", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->scanner;
	_tmp6_ = g_strdup_printf ("%u", _tmp5_->position);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
rygel_search_criteria_parser_class_init (RygelSearchCriteriaParserClass * klass,
                                         gpointer klass_data)
{
	rygel_search_criteria_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelSearchCriteriaParser_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_search_criteria_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_search_criteria_parser_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_search_criteria_parser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE_PROPERTY, rygel_search_criteria_parser_properties[RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_search_criteria_parser_rygel_state_machine_interface_init (RygelStateMachineIface * iface,
                                                                 gpointer iface_data)
{
	rygel_search_criteria_parser_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_search_criteria_parser_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_search_criteria_parser_run_finish;
	iface->get_cancellable = rygel_search_criteria_parser_real_get_cancellable;
	iface->set_cancellable = rygel_search_criteria_parser_real_set_cancellable;
}

static void
rygel_search_criteria_parser_instance_init (RygelSearchCriteriaParser * self,
                                            gpointer klass)
{
	self->priv = rygel_search_criteria_parser_get_instance_private (self);
}

static void
rygel_search_criteria_parser_finalize (GObject * obj)
{
	RygelSearchCriteriaParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser);
	_g_free0 (self->str);
	_rygel_search_expression_unref0 (self->expression);
	_g_error_free0 (self->err);
	_g_object_unref0 (self->priv->_cancellable);
	_g_scanner_destroy0 (self->priv->scanner);
	G_OBJECT_CLASS (rygel_search_criteria_parser_parent_class)->finalize (obj);
}

/**
 * Parses a search criteria string and creates SearchExpression as a result.
 */
 G_GNUC_NO_INLINE static GType
rygel_search_criteria_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelSearchCriteriaParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_criteria_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearchCriteriaParser), 0, (GInstanceInitFunc) rygel_search_criteria_parser_instance_init, NULL };
	static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_search_criteria_parser_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_search_criteria_parser_type_id;
	rygel_search_criteria_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSearchCriteriaParser", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_search_criteria_parser_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	RygelSearchCriteriaParser_private_offset = g_type_add_instance_private (rygel_search_criteria_parser_type_id, sizeof (RygelSearchCriteriaParserPrivate));
	return rygel_search_criteria_parser_type_id;
}

GType
rygel_search_criteria_parser_get_type (void)
{
	static volatile gsize rygel_search_criteria_parser_type_id__once = 0;
	if (g_once_init_enter (&rygel_search_criteria_parser_type_id__once)) {
		GType rygel_search_criteria_parser_type_id;
		rygel_search_criteria_parser_type_id = rygel_search_criteria_parser_get_type_once ();
		g_once_init_leave (&rygel_search_criteria_parser_type_id__once, rygel_search_criteria_parser_type_id);
	}
	return rygel_search_criteria_parser_type_id__once;
}

static void
_vala_rygel_search_criteria_parser_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	RygelSearchCriteriaParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_search_criteria_parser_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	RygelSearchCriteriaParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

